/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.common.blueprintshare.support;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import com.fasterxml.jackson.core.type.TypeReference;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.scm.pur.common.blueprintshare.po.BluePrintDTO;
import kd.scm.pur.common.blueprintshare.po.DocumentMessageRes;
import kd.scm.pur.common.blueprintshare.support.plmservice.IPLMRequestService;
import kd.scm.pur.common.blueprintshare.support.plmservice.impl.K3cloudPLMRequestService;
import org.apache.commons.lang.StringUtils;

public class PurGetBlueprintSupport {
    private static final Log log = LogFactory.getLog(PurGetBlueprintSupport.class);
    private static final IAppCache cache = AppCache.get((String)"scm");
    private final IPLMRequestService plmRequestService = new K3cloudPLMRequestService();

    public Map<String, List<BluePrintDTO>> getBluePrintDTOS(Set<String> materielNumbers) {
        try {
            log.info("\u6839\u636e\u7269\u6599\u7f16\u7801\uff0c\u67e5\u8be2\u661f\u7a7aplm\u56fe\u7eb8\u4fe1\u606f{}: ", materielNumbers);
            String cacheString = (String)cache.get("BLUEPRINT_MAP_CACHE_KEY_" + UserServiceHelper.getCurrentUserId(), String.class);
            if (StringUtils.isNotBlank((String)cacheString)) {
                Map bluePrintMapCache = (Map)JSON.parseObject((String)cacheString, (Type)new TypeReference<Map<String, List<BluePrintDTO>>>(){}.getType(), (Feature[])new Feature[]{Feature.AllowISO8601DateFormat});
                if ((materielNumbers = materielNumbers.stream().filter(n -> !bluePrintMapCache.containsKey(n)).collect(Collectors.toSet())).isEmpty()) {
                    return bluePrintMapCache;
                }
            }
            Map<String, List<DocumentMessageRes>> documentMapRes = this.plmRequestService.getDocumentMessageRes(materielNumbers);
            log.info("\u67e5\u8be2\u661f\u7a7a\u6587\u6863\u4fe1\u606f\uff0c\u7269\u6599\u7f16\u7801\uff1a{} \u56fe\u7eb8\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString(materielNumbers), (Object)JSON.toJSONString(documentMapRes));
            if (documentMapRes == null || documentMapRes.isEmpty()) {
                return Collections.emptyMap();
            }
            Map<String, List<BluePrintDTO>> bluePrintMap = this.convert(documentMapRes);
            Map<String, List<BluePrintDTO>> bluePrintMapFromCache = this.putBluePrintDTOsToCache(bluePrintMap);
            log.info("\u5b58\u5165\u7f13\u5b58\u6210\u529f\uff1a" + JSON.toJSONString(bluePrintMap));
            return bluePrintMapFromCache;
        }
        catch (Exception e) {
            log.info("\u6839\u636e\u7269\u6599\u7f16\u7801\uff0c\u67e5\u8be2\u661f\u7a7aplm\u56fe\u7eb8\u4fe1\u606f\u5931\u8d25\uff0c\u7269\u6599\u7f16\u7801\uff1a{}", materielNumbers);
            return new HashMap<String, List<BluePrintDTO>>();
        }
    }

    private Set<String> doFilerMateriel(Set<String> materielNumbers) throws Exception {
        log.info("\u8fc7\u6ee4\u7f13\u5b58\u4e2d\u5b58\u5728\u7684\u7269\u6599\u7f16\u7801\uff1a" + materielNumbers);
        long currentUserId = UserServiceHelper.getCurrentUserId();
        String cacheString = (String)cache.get("BLUEPRINT_MAP_CACHE_KEY_" + currentUserId, String.class);
        if (StringUtils.isBlank((String)cacheString)) {
            return materielNumbers;
        }
        Map bluePrintMapCache = (Map)JSON.parseObject((String)cacheString, (Type)new TypeReference<Map<String, List<BluePrintDTO>>>(){}.getType(), (Feature[])new Feature[]{Feature.AllowISO8601DateFormat});
        if (bluePrintMapCache == null || bluePrintMapCache.isEmpty()) {
            return materielNumbers;
        }
        HashSet<String> filterMaterielNumbers = new HashSet<String>(materielNumbers.size());
        for (String materielNumber : materielNumbers) {
            if (bluePrintMapCache.containsKey(materielNumber)) continue;
            filterMaterielNumbers.add(materielNumber);
        }
        return filterMaterielNumbers;
    }

    private Map<String, List<BluePrintDTO>> convert(Map<String, List<DocumentMessageRes>> documentMapRes) {
        HashMap<String, List<BluePrintDTO>> bluePrintMap = new HashMap<String, List<BluePrintDTO>>(documentMapRes.size());
        for (Map.Entry<String, List<DocumentMessageRes>> entry : documentMapRes.entrySet()) {
            String materielNumber = entry.getKey();
            List<DocumentMessageRes> documentMessageResList = entry.getValue();
            ArrayList<BluePrintDTO> bluePrintDTOS = new ArrayList<BluePrintDTO>(documentMessageResList.size());
            for (DocumentMessageRes documentMessageRes : documentMessageResList) {
                BluePrintDTO bluePrintDTO = new BluePrintDTO();
                bluePrintDTO.setFileId(documentMessageRes.getFileId());
                bluePrintDTO.setMaterielName(materielNumber);
                bluePrintDTO.setDocumentNumber(documentMessageRes.getCode());
                bluePrintDTO.setDocumentName(documentMessageRes.getName());
                bluePrintDTO.setBizType(documentMessageRes.getCategoryName());
                bluePrintDTO.setCreatorName(documentMessageRes.getCreatorName());
                bluePrintDTO.setCreateDate(documentMessageRes.getCreateDate());
                bluePrintDTO.setModifyDate(documentMessageRes.getModifyDate());
                bluePrintDTO.setVersion(documentMessageRes.getVerNO());
                bluePrintDTO.setFileSize(documentMessageRes.getFileSize());
                bluePrintDTO.setNotes(documentMessageRes.getRemark());
                bluePrintDTO.setDrawingNo(documentMessageRes.getDrawNumber());
                bluePrintDTO.setSpecifications(documentMessageRes.getSpecification());
                bluePrintDTO.setMaterialQuality(documentMessageRes.getMaterialQuality());
                bluePrintDTO.setColour(documentMessageRes.getColor());
                bluePrintDTOS.add(bluePrintDTO);
            }
            bluePrintMap.put(materielNumber, bluePrintDTOS);
        }
        return bluePrintMap;
    }

    private Map<String, List<BluePrintDTO>> putBluePrintDTOsToCache(Map<String, List<BluePrintDTO>> bluePrintMap) throws Exception {
        long currentUserId = UserServiceHelper.getCurrentUserId();
        String cacheString = (String)cache.get("BLUEPRINT_MAP_CACHE_KEY_" + currentUserId, String.class);
        if (StringUtils.isBlank((String)cacheString)) {
            cache.put("BLUEPRINT_MAP_CACHE_KEY_" + currentUserId, (Object)JSON.toJSONString(bluePrintMap));
            return bluePrintMap;
        }
        Map bluePrintMapCache = (Map)JSON.parseObject((String)cacheString, (Type)new TypeReference<Map<String, List<DocumentMessageRes>>>(){}.getType(), (Feature[])new Feature[]{Feature.AllowISO8601DateFormat});
        if (bluePrintMapCache != null && !bluePrintMapCache.isEmpty()) {
            bluePrintMapCache.putAll(bluePrintMap);
            cache.put("BLUEPRINT_MAP_CACHE_KEY_" + currentUserId, (Object)JSON.toJSONString((Object)bluePrintMapCache));
            return bluePrintMapCache;
        }
        cache.put("BLUEPRINT_MAP_CACHE_KEY_" + currentUserId, (Object)JSON.toJSONString(bluePrintMap));
        return bluePrintMap;
    }
}

