/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.common.blueprintshare.support.plmservice.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.k3cloud.util.InvokeHelper;
import kd.scm.common.systemjoint.SystemJointChannelHelper;
import kd.scm.pur.common.blueprintshare.po.DocumentMessageRes;
import kd.scm.pur.common.blueprintshare.support.plmservice.AbstractPLMRequestService;

public class K3cloudPLMRequestService
extends AbstractPLMRequestService {
    @Override
    public Map<String, List<DocumentMessageRes>> getDocumentMessageRes(Set<String> erpMatCodes) throws Exception {
        if (erpMatCodes == null || erpMatCodes.isEmpty()) {
            return Collections.emptyMap();
        }
        this.login();
        String url = (String)XKCookival.get("K3_URL", String.class);
        String requestParam = this.buildDocumentMessageRequestParam(erpMatCodes);
        log.info("\u83b7\u53d6\u6587\u6863\u4fe1\u606f\u5f00\u59cb\u8bf7\u6c42\u63a5\u53e3\uff0c\u8bf7\u6c42url:{}\uff0crequestParam:{}", (Object)url, (Object)requestParam);
        String documentMessageJSON = this.blueprintHttpRequestExecutor.doHttpRequest(url, "Kingdee.K3.PLM.WebApi.ServiceFacade.ServicesStub.DocumentBusniessService.GetDocInfoByErpMatCode.common.kdsvc", requestParam);
        log.info("\u83b7\u53d6\u6587\u6863\u4fe1\u606f\u5f00\u59cb\u8bf7\u6c42\u63a5\u53e3\uff0c\u8fd4\u56de\u54cd\u5e94\u503c:{}", (Object)documentMessageJSON);
        try {
            return (Map)JSON.parseObject((String)documentMessageJSON, (Type)new TypeReference<Map<String, List<DocumentMessageRes>>>(){}.getType(), (Feature[])new Feature[]{Feature.AllowISO8601DateFormat});
        }
        catch (Exception e) {
            log.error(e.getMessage());
            return new HashMap<String, List<DocumentMessageRes>>();
        }
    }

    @Override
    public InputStream getFileInputStream(String fileId) throws Exception {
        log.info("kd.scm.pur.common.blueprintshare.support.plmservice.impl.K3cloudPLMRequestService.getFileInputStream \u83b7\u53d6\u6587\u4ef6\u6d41\uff0c\u6587\u4ef6id \uff1a{}", (Object)fileId);
        String url = (String)XKCookival.get("K3_URL", String.class);
        String urlNotPort = (String)XKCookival.get("K3_URL_NOT_PORT", String.class);
        String xkCookie = (String)XKCookival.get("XKCookie", String.class);
        if (StringUtils.isBlank((CharSequence)url) || StringUtils.isBlank((CharSequence)urlNotPort) || StringUtils.isBlank((CharSequence)xkCookie)) {
            this.login();
        }
        DynamicObject pathObj = BusinessDataServiceHelper.loadSingle((String)"pur_plmpath", (String)"path,billno", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)"K3_WAREHOUSE_PATH")});
        String plmPath = null;
        if (pathObj != null) {
            plmPath = pathObj.getString("path");
            log.info("\u661f\u7a7a\u7269\u7406\u7535\u5b50\u4ed3\u5730\u5740\uff1a{}", (Object)plmPath);
        }
        if (StringUtils.isBlank(plmPath)) {
            plmPath = this.queryPlmPathFormK3cloudWebApi(url, pathObj);
        }
        String plmUrl = plmPath + "/Download";
        String base64FileId = Base64.getEncoder().encodeToString(fileId.getBytes(StandardCharsets.UTF_8));
        String sessionId = this.extractSessionId(xkCookie);
        String warehouseCtx = String.format("LoginUrl=%s&KDServiceSessionId=%s", urlNotPort.toLowerCase(), sessionId);
        String base64ctx = Base64.getEncoder().encodeToString(warehouseCtx.getBytes(StandardCharsets.UTF_8));
        UUID token = UUID.randomUUID();
        log.info("\u6267\u884c\u8bbf\u95ee\u7535\u5b50\u4ed3\uff0c\u83b7\u53d6\u6587\u4ef6\u6d41\uff0cxkCookie:{},sessionId:{}, plmUrl:{}, fileId:{}, base64FileId:{}, warehouseCtx:{}, base64ctx:{}, token:{}", new Object[]{xkCookie, sessionId, plmUrl, fileId, base64FileId, warehouseCtx, base64ctx, token});
        try {
            return this.blueprintHttpRequestExecutor.doHttpRequestDownloadFile(plmUrl, base64FileId, base64ctx, token.toString(), "pure");
        }
        catch (Exception e) {
            plmPath = this.queryPlmPathFormK3cloudWebApi(url, pathObj);
            log.info("\u91cd\u8bd5\u8c03\u7528\u661f\u7a7awebapi\u83b7\u53d6 \u7535\u5b50\u4ed3\u5730\u5740\uff1a{}", (Object)plmPath);
            return this.blueprintHttpRequestExecutor.doHttpRequestDownloadFile(plmPath, base64FileId, base64ctx, token.toString(), "pure");
        }
    }

    private String extractSessionId(String cookieValue) {
        Pattern pattern = Pattern.compile("kdservice-sessionid=([^;]+)");
        Matcher matcher = pattern.matcher(cookieValue);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    private String queryPlmPathFormK3cloudWebApi(String url, DynamicObject pathObj) throws Exception {
        String requestParam = this.buildQueryParam();
        log.info("\u8c03\u7528\u661f\u7a7awebapi\u83b7\u53d6 \u7535\u5b50\u4ed3\u5730\u5740\uff0curl: {} , executeBillQuery: {} , requestParam: {} ", new Object[]{url, "Kingdee.BOS.WebApi.ServicesStub.DynamicFormService.ExecuteBillQuery.common.kdsvc", requestParam});
        String response = this.blueprintHttpRequestExecutor.doHttpRequest(url, "Kingdee.BOS.WebApi.ServicesStub.DynamicFormService.ExecuteBillQuery.common.kdsvc", requestParam);
        JSONArray jsonArray = JSON.parseArray((String)response);
        JSONArray valueArray = jsonArray.getJSONArray(0);
        String plmPath = valueArray.getString(2);
        log.info("\u8c03\u7528\u661f\u7a7awebapi\u83b7\u53d6 \u7535\u5b50\u4ed3\u5730\u5740\uff1a{}", (Object)plmPath);
        if (StringUtils.isBlank((CharSequence)plmPath)) {
            log.error("kd.scm.pur.common.blueprintshare.support.plmservice.impl.K3cloudPLMRequestService.getFileInputStream \uff1a\u672a\u67e5\u8be2\u5230\u661f\u7a7aplm\u7535\u5b50\u4ed3\u5730\u5740\u3002");
            throw new Exception("No electronic PLM warehouse address found, please check the K3cloud PLM configuration.");
        }
        if (pathObj != null) {
            pathObj.set("path", (Object)plmPath);
            pathObj.set("billno", (Object)"K3_WAREHOUSE_PATH");
            SaveServiceHelper.update((DynamicObject)pathObj);
        } else {
            DynamicObject path = BusinessDataServiceHelper.newDynamicObject((String)"pur_plmpath");
            path.set("path", (Object)plmPath);
            path.set("billno", (Object)"K3_WAREHOUSE_PATH");
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{path});
        }
        return plmPath;
    }

    private void login() throws Exception {
        DynamicObject defaultJointChannelData = SystemJointChannelHelper.getDefaultJointChannelData();
        DynamicObject iscLinkData = SystemJointChannelHelper.getJointDataIscLink((DynamicObject)defaultJointChannelData);
        if (iscLinkData == null) {
            throw new KDException(new ErrorCode("", ResManager.loadKDString((String)"\u65e0\u6709\u6548\u96c6\u6210\u4e91\u8fde\u63a5\u5668\u6570\u636e\uff0c\u65e0\u6cd5\u6267\u884c\u96c6\u6210\u4e91\u8bf7\u6c42\u3002", (String)"IerpIscK3CloudSend_0", (String)"scm-common", (Object[])new Object[0])), new Object[0]);
        }
        String ip = String.valueOf(iscLinkData.get("server_ip"));
        String protocal = String.valueOf(iscLinkData.get("http_protocal"));
        String data_center = String.valueOf(iscLinkData.get("data_center"));
        String user = String.valueOf(iscLinkData.get("user"));
        String password = String.valueOf(iscLinkData.get("newpwd"));
        String port = String.valueOf(iscLinkData.get("server_port"));
        String url = protocal + "://" + ip + ":" + port + "/K3Cloud/";
        XKCookival.put("K3_URL", (Object)url);
        XKCookival.put("K3_URL_NOT_PORT", (Object)(protocal + "://" + ip + "/K3Cloud"));
        log.info("data_center:{},  user:{},  url:{}", new Object[]{data_center, user, url});
        boolean success = InvokeHelper.Login((String)data_center, (String)user, (String)password, (int)2052, (String)url);
        if (!success) {
            throw new Exception("login k3cloud fail.");
        }
    }

    private String buildQueryParam() {
        boolean tre = true;
        HashMap data = new HashMap();
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("FormId", "PLM_STD_WAREHOUSE");
        param.put("FieldKeys", "FIsMain,FInnerUrl,FOuterUrl");
        param.put("FilterString", "FIsMain = 1");
        data.put("data", param);
        return JSON.toJSONString(data);
    }

    private String buildDocumentMessageRequestParam(Set<String> erpMatCodes) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("erpMatCodes", erpMatCodes);
        return jsonObject.toJSONString();
    }
}

