/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.formplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.extplugin.PluginProxy;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.systemjoint.SystemJointChannelHelper;
import kd.scm.common.util.BillFormUtil;
import kd.scm.common.util.CommonUtil;
import kd.scm.common.util.DateUtil;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.util.OrgUtil;
import kd.scm.common.util.check.HandCheckImpl;
import kd.scm.common.util.check.Icheck;
import kd.scm.common.util.check.OrderCheckUtil;
import kd.scm.pur.business.PurJointChannelHelper;
import kd.scm.pur.formplugin.ext.PurHandCheckSupportImpl;
import kd.sdk.scm.pur.extpoint.IPurHandCheckSupport;

public class PurCheckCenterPlugin
extends AbstractFormPlugin {
    private static final String BYCHECKDATE = "bycheckdate";
    private static final String MATERIAL_GROUP = "materialgroup";
    private static final String CHECKTYPE = "checktype";
    private static final String RECHECK = "recheck";
    private static final String WAREHOUSE = "warehouse";
    private static final String SHOWMATCHED = "showmatched";
    protected Icheck check;
    private static Log log = LogFactory.getLog(PurCheckCenterPlugin.class);

    protected Icheck getCheck() {
        if (null == this.check) {
            this.check = new HandCheckImpl();
        }
        return this.check;
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        BasedataEdit rcvOrg = (BasedataEdit)this.getControl("rcvorg");
        rcvOrg.addBeforeF7SelectListener((BeforeF7SelectListener)new /* Unavailable Anonymous Inner Class!! */);
        BasedataEdit settleOrg = (BasedataEdit)this.getControl("settleorg");
        settleOrg.addBeforeF7SelectListener(new BeforeF7SelectListener(){

            public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
                HashSet orgSet = new HashSet(1024);
                List orgList = OrgUtil.getHasSettlePermissionOrgs((String)"pur_check");
                orgSet.addAll(orgList);
                log.info("###\u7ed3\u7b97\u7ec4\u7ec7\u8fc7\u6ee4\u7ec4\u7ec7\u4fe1\u606f\uff1a" + CommonUtil.objs2str((Object[])orgList.toArray()));
                ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                formShowParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", orgSet));
            }
        });
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setJointChannelDataVisibleAndEnable();
    }

    private void setJointChannelDataVisibleAndEnable() {
        ArrayList<String> verifyEntityNumbers = new ArrayList<String>(16);
        verifyEntityNumbers.add("pur_order");
        verifyEntityNumbers.add("pur_instock");
        verifyEntityNumbers.add("pur_receipt");
        boolean isEnable = PurJointChannelHelper.checkMultiJointSystem(verifyEntityNumbers);
        this.getView().setEnable(Boolean.valueOf(isEnable), new String[]{"jointchanneldata"});
        this.getView().setVisible(Boolean.valueOf(isEnable), new String[]{"jointchanneldata"});
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        switch (itemKey) {
            case "btn_startcheck": {
                Object byCheckDate;
                Object checkType = model.getValue(CHECKTYPE);
                if (null != checkType && "1".equals(checkType.toString()) && null != (byCheckDate = model.getValue(BYCHECKDATE)) && Boolean.parseBoolean(byCheckDate.toString())) {
                    return;
                }
                Date datefrom = (Date)model.getValue("datefrom");
                Date dateto = (Date)model.getValue("dateto");
                if (datefrom == null) {
                    view.showMessage(ResManager.loadKDString((String)"\u201c\u5bf9\u8d26\u671f\u95f4\u4ece\u201d\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u5f55\u5165\u3002", (String)"PurCheckCenterPlugin_4", (String)"scm-pur-formplugin", (Object[])new Object[0]));
                    evt.setCancel(true);
                    return;
                }
                if (dateto == null) {
                    view.showMessage(ResManager.loadKDString((String)"\u201c\u5bf9\u8d26\u671f\u95f4\u81f3\u201d\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u5f55\u5165\u3002", (String)"PurCheckCenterPlugin_0", (String)"scm-pur-formplugin", (Object[])new Object[0]));
                    evt.setCancel(true);
                    return;
                }
                if (datefrom == null || !dateto.before(datefrom)) break;
                view.showMessage(ResManager.loadKDString((String)"\u201c\u5bf9\u8d26\u671f\u95f4\u4ece\u201d\u4e0d\u80fd\u665a\u4e8e\u201c\u5bf9\u8d26\u671f\u95f4\u81f3\u201d\u3002", (String)"PurCheckCenterPlugin_1", (String)"scm-pur-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String clickKey = evt.getItemKey();
        if (clickKey.length() == 0) {
            return;
        }
        switch (clickKey) {
            case "btn_startcheck": {
                this.openHandCheck();
                if (this.getView().getMainView() == null) break;
                this.getView().close();
                break;
            }
            case "reset": {
                this.resetHandCheck();
            }
        }
    }

    private void resetHandCheck() {
        IDataModel model = this.getModel();
        model.setValue("settleorg", null);
        model.setValue("rcvorg", null);
        model.setValue("supplier", null);
        model.setValue(MATERIAL_GROUP, null);
        model.setValue(WAREHOUSE, null);
        Date currDate = TimeServiceHelper.now();
        model.setValue("datefrom", (Object)DateUtil.addMonth((Date)currDate, (int)-1));
        model.setValue("dateto", (Object)currDate);
        model.setValue(RECHECK, (Object)false);
    }

    public void afterCreateNewData(EventObject e) {
        Object showMatched;
        String warehouse;
        String materialGroup;
        String supplier;
        String rcvOrg;
        String settleOrg;
        Object datefrom;
        Object checkType;
        Object byCheckDate;
        IDataModel model = this.getModel();
        FormShowParameter formParamter = this.getView().getFormShowParameter();
        Map customerParam = formParamter.getCustomParams();
        Object paramJoint = customerParam.get("jointchanneldata");
        String jointChannelId = null;
        if (paramJoint != null) {
            jointChannelId = paramJoint.toString();
        }
        if (null != (byCheckDate = customerParam.get(BYCHECKDATE))) {
            model.setValue(BYCHECKDATE, byCheckDate);
        }
        Object reCheck = customerParam.get(RECHECK);
        if (null != RECHECK) {
            model.setValue(RECHECK, reCheck);
        }
        if (null != (checkType = customerParam.get(CHECKTYPE))) {
            model.setValue(CHECKTYPE, checkType);
        }
        if (null != (datefrom = customerParam.get("startdate"))) {
            model.setValue("datefrom", (Object)DateUtil.string2date((String)datefrom.toString(), null));
        } else {
            Date currDate = new Date();
            model.setValue("datefrom", (Object)DateUtil.addMonth((Date)currDate, (int)-1));
        }
        Object dateto = customerParam.get("enddate");
        if (null != dateto) {
            model.setValue("dateto", (Object)DateUtil.string2date((String)dateto.toString(), null));
        }
        if (null != (settleOrg = (String)customerParam.get("settleorg")) && settleOrg.trim().length() > 0) {
            model.setValue("settleorg", (Object)CommonUtil.strids2Longs((String)settleOrg, (String)","));
        }
        if (null != (rcvOrg = (String)customerParam.get("rcvorg")) && rcvOrg.trim().length() > 0) {
            model.setValue("rcvorg", (Object)CommonUtil.strids2Longs((String)rcvOrg, (String)","));
        }
        if (null != (supplier = (String)customerParam.get("supplier")) && supplier.trim().length() > 0) {
            model.setValue("supplier", (Object)CommonUtil.strids2Longs((String)supplier, (String)","));
        }
        if (null != (materialGroup = (String)customerParam.get(MATERIAL_GROUP)) && materialGroup.trim().length() > 0) {
            model.setValue(MATERIAL_GROUP, (Object)CommonUtil.strids2Longs((String)materialGroup, (String)","));
        }
        if (null != (warehouse = (String)customerParam.get(WAREHOUSE)) && warehouse.trim().length() > 0) {
            model.setValue(WAREHOUSE, (Object)CommonUtil.strids2Longs((String)warehouse, (String)","));
        }
        if ((showMatched = customerParam.get(SHOWMATCHED)) != null) {
            model.setValue(SHOWMATCHED, (Object)Boolean.parseBoolean(showMatched.toString()));
        }
        if (jointChannelId == null) {
            jointChannelId = SystemJointChannelHelper.getDefaultJointChannelId();
        }
        if (jointChannelId != null) {
            this.getModel().setValue("jointchanneldata", (Object)jointChannelId);
        }
    }

    protected void openHandCheck() {
        String formKey = "pur_handcheck";
        FormShowParameter param = null;
        Object checkType = this.getModel().getValue(CHECKTYPE);
        String checkTypeStr = "";
        if (checkType != null) {
            checkTypeStr = checkType.toString();
        }
        if ("3".equals(checkTypeStr) || "1".equals(checkTypeStr)) {
            formKey = "pur_handcheck";
            Map<String, Object> objectMap = this.getParamByInstock();
            objectMap.put("jointchanneldata", this.getModel().getDataEntity().getString("jointchanneldata.id"));
            param = BillFormUtil.assembleShowDynamicFormParam((String)formKey, objectMap, (CloseCallBack)new CloseCallBack((IFormPlugin)this, "comfirmaction"), (ShowType)ShowType.MainNewTabPage);
            if ("3".equals(checkType)) {
                param.setCaption(ResManager.loadKDString((String)"\u6536\u8d27/\u5165\u5e93\u5bf9\u8d26", (String)"PurCheckCenterPlugin_2", (String)"scm-pur-formplugin", (Object[])new Object[0]));
            }
        } else {
            Map<String, Object> objectMap = this.getParam();
            formKey = "pur_ordercheck";
            objectMap.put("jointchanneldata", this.getModel().getDataEntity().getString("jointchanneldata.id"));
            Map<String, Map<String, Object>> paramsMap = this.buildCondition(objectMap);
            OrderCheckUtil.updateOrderCheckentry((String)"pur_ordercheck", paramsMap);
            param = BillFormUtil.assembleShowListFormParam((String)formKey, objectMap, (CloseCallBack)new CloseCallBack((IFormPlugin)this, "comfirmaction"));
        }
        this.getView().showForm(param);
    }

    protected Map<String, Object> getParamByInstock() {
        Map paramByInstock;
        Map<String, Object> objectMap = this.getParam();
        if (objectMap != null && (paramByInstock = this.getCheck().getParamByInstock(this.getModel().getDataEntity())) != null) {
            objectMap.putAll(paramByInstock);
        }
        return objectMap;
    }

    protected Map<String, Object> getParam() {
        HashMap<String, Object> param = new HashMap<String, Object>(8);
        IDataModel model = this.getModel();
        DynamicObjectCollection materialGroup = (DynamicObjectCollection)model.getValue(MATERIAL_GROUP);
        DynamicObjectCollection settleOrg = (DynamicObjectCollection)model.getValue("settleorg");
        DynamicObjectCollection rcvOrg = (DynamicObjectCollection)model.getValue("rcvorg");
        DynamicObjectCollection supplier = (DynamicObjectCollection)model.getValue("supplier");
        Object byCheckDate = model.getValue(BYCHECKDATE);
        param.put("supplier", CommonUtil.objs2str((Object[])DynamicObjectUtil.getMulBaseDataOfId((DynamicObjectCollection)supplier)));
        param.put(MATERIAL_GROUP, CommonUtil.objs2str((Object[])DynamicObjectUtil.getMulBaseDataOfId((DynamicObjectCollection)materialGroup)));
        param.put("settleorg", CommonUtil.objs2str((Object[])DynamicObjectUtil.getMulBaseDataOfId((DynamicObjectCollection)settleOrg)));
        param.put("rcvorg", CommonUtil.objs2str((Object[])DynamicObjectUtil.getMulBaseDataOfId((DynamicObjectCollection)rcvOrg)));
        param.put(BYCHECKDATE, byCheckDate);
        Object reCheck = model.getValue(RECHECK);
        param.put(RECHECK, reCheck);
        param.put(SHOWMATCHED, String.valueOf(model.getDataEntity().getBoolean(SHOWMATCHED)));
        String checkType = (String)model.getValue(CHECKTYPE);
        param.put(CHECKTYPE, checkType);
        Map<String, Object> pluginParams = this.getPluginParams(model);
        if (pluginParams != null && !pluginParams.isEmpty()) {
            param.putAll(pluginParams);
        }
        boolean isFilterDate = true;
        if ("1".equals(checkType)) {
            if (null != byCheckDate && Boolean.parseBoolean(byCheckDate.toString())) {
                isFilterDate = false;
            }
        } else if ("3".equals(checkType)) {
            param.put("unMatch", Boolean.TRUE);
        }
        if (isFilterDate) {
            Date datefrom = (Date)model.getValue("datefrom");
            Date dateto = (Date)model.getValue("dateto");
            param.put("startdate", datefrom != null ? DateUtil.getFormatStartDate((Date)datefrom) : null);
            dateto = DateUtil.formatEndDate((Date)dateto);
            param.put("enddate", DateUtil.date2str((Date)dateto, (String)"yyyy-MM-dd HH:mm:ss"));
        }
        return param;
    }

    private Map<String, Object> getPluginParams(IDataModel model) {
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        PurHandCheckSupportImpl defaultSupport = new PurHandCheckSupportImpl();
        PluginProxy pluginProxy = PluginProxy.create((Object)defaultSupport, IPurHandCheckSupport.class, (String)"SCM_PUR_HANDCHECK_SUPPORT", null);
        List checkHandPlugin = pluginProxy.getPlugins();
        if (checkHandPlugin != null && !checkHandPlugin.isEmpty()) {
            checkHandPlugin.forEach(handCheck -> {
                List extendParams = handCheck.getExtendParams();
                if (extendParams != null && !extendParams.isEmpty()) {
                    Map temp;
                    HashMap filter = new HashMap(extendParams.size());
                    extendParams.forEach(t -> {
                        Object temp = model.getValue(t);
                        if (temp != null) {
                            filter.put(t, model.getValue(t));
                        }
                    });
                    if (!filter.isEmpty() && (temp = handCheck.getParamsMap(filter)) != null && !temp.isEmpty()) {
                        params.putAll(temp);
                    }
                }
            });
        }
        return params;
    }

    protected Map<String, Map<String, Object>> buildCondition(Map<String, Object> params) {
        String settleorgscope;
        String supplierscope;
        Object datefrom;
        HashMap<String, Map<String, Object>> filterMap = new HashMap<String, Map<String, Object>>();
        HashMap<String, Date> datetoMap = new HashMap<String, Date>(2);
        if (null == params) {
            Date now = new Date();
            datetoMap.put("<=", now);
            datetoMap.put(">=", DateUtil.getPreviousSomeMonthStingDate((Date)now, (int)1));
            filterMap.put("billdate", datetoMap);
            ArrayList<String> checkStatusList = new ArrayList<String>();
            checkStatusList.add("D");
            checkStatusList.add("C");
            HashMap<String, ArrayList<String>> checkStatusMap = new HashMap<String, ArrayList<String>>(1);
            checkStatusMap.put("not in", checkStatusList);
            filterMap.put("checkstatus", checkStatusMap);
            return filterMap;
        }
        Object dateto = params.get("enddate");
        String pattern = "yyyy-MM-dd HH:mm:ss";
        if (null != dateto) {
            datetoMap.put("<=", DateUtil.string2date((String)dateto.toString(), (String)pattern));
            filterMap.put("billdate", datetoMap);
        }
        if (null != (datefrom = params.get("startdate"))) {
            datetoMap.put(">=", DateUtil.string2date((String)datefrom.toString(), (String)pattern));
            filterMap.put("billdate", datetoMap);
        }
        if (null != (supplierscope = (String)params.get("supplier")) && !supplierscope.isEmpty()) {
            HashMap supplierMap = new HashMap(1);
            supplierMap.put("in", Arrays.stream(supplierscope.split(",")).map(s -> Long.parseLong(s.trim())).collect(Collectors.toSet()));
            filterMap.put("supplier", supplierMap);
        }
        if (null != (settleorgscope = (String)params.get("settleorg")) && !settleorgscope.isEmpty()) {
            HashMap settleOrgScopeMap = new HashMap(1);
            settleOrgScopeMap.put("in", Arrays.stream(settleorgscope.split(",")).map(s -> Long.parseLong(s.trim())).collect(Collectors.toSet()));
            filterMap.put("settleorg", settleOrgScopeMap);
        }
        ArrayList<String> checkStatusList = new ArrayList<String>();
        checkStatusList.add("D");
        Object reCheck = params.get(RECHECK);
        if (null == reCheck || !Boolean.parseBoolean(reCheck.toString())) {
            checkStatusList.add("C");
        }
        HashMap<String, ArrayList<String>> checkStatusMap = new HashMap<String, ArrayList<String>>(1);
        checkStatusMap.put("not in", checkStatusList);
        filterMap.put("checkstatus", checkStatusMap);
        HashMap<String, String[]> statusMap = new HashMap<String, String[]>(1);
        statusMap.put("in", new String[]{BillStatusEnum.AUDIT.getVal(), BillStatusEnum.CLOSED.getVal()});
        filterMap.put("billstatus", statusMap);
        return filterMap;
    }
}

