/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.formplugin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.pur.common.blueprintshare.po.BluePrintDTO;
import kd.scm.pur.common.blueprintshare.po.DocumentSaveMessage;
import kd.scm.pur.common.blueprintshare.support.PurGetBlueprintSupport;

public class PurGetDocument
extends AbstractFormPlugin {
    private static final Log log = LogFactory.getLog(PurGetDocument.class);
    private final PurGetBlueprintSupport purGetBlueprintSupport = new PurGetBlueprintSupport();

    public void registerListener(EventObject e) {
        try {
            this.addClickListeners(new String[]{"btnok"});
        }
        catch (Exception exception) {
            log.error((Throwable)exception);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u670d\u52a1\u51fa\u9519\uff0c\u8bf7\u91cd\u8bd5\u3002", (String)"PurBluePrintPlugin_3", (String)"scm-pur-formplugin", (Object[])new Object[0]));
        }
    }

    public void click(EventObject evt) {
        try {
            Control source = (Control)evt.getSource();
            String key = source.getKey();
            if (key.equals("btnok")) {
                EntryGrid entryGrid = (EntryGrid)this.getControl("documententry");
                int[] selectRows = entryGrid.getSelectRows();
                DynamicObjectCollection entry = this.getModel().getEntryEntity("documententry");
                if (entry == null || entry.isEmpty()) {
                    return;
                }
                Map customParams = this.getView().getFormShowParameter().getCustomParams();
                Integer index = (Integer)customParams.get("rowIndex");
                ArrayList<DocumentSaveMessage> documentSaveMessages = new ArrayList<DocumentSaveMessage>(selectRows.length);
                for (int selectRow : selectRows) {
                    DynamicObject row = (DynamicObject)entry.get(selectRow);
                    String documentName = row.getString("documentname");
                    String id = row.getString("id");
                    DocumentSaveMessage documentSaveMessage = new DocumentSaveMessage();
                    documentSaveMessage.setId(id);
                    documentSaveMessage.setDocumentName(documentName);
                    documentSaveMessage.setIndex(index.intValue());
                    documentSaveMessages.add(documentSaveMessage);
                }
                this.getView().returnDataToParent(documentSaveMessages);
                this.getView().close();
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u670d\u52a1\u51fa\u9519\uff0c\u8bf7\u91cd\u8bd5\u3002", (String)"PurBluePrintPlugin_3", (String)"scm-pur-formplugin", (Object[])new Object[0]));
        }
    }

    public void afterCreateNewData(EventObject e) {
        try {
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            Object materielNumberObj = customParams.get("materiel.number");
            Object materielIdObj = customParams.get("materiel.id");
            if (materielNumberObj == null || materielIdObj == null) {
                return;
            }
            String materielNumber = (String)materielNumberObj;
            Map bluePrintMap = this.purGetBlueprintSupport.getBluePrintDTOS(Collections.singleton(materielNumber));
            if (bluePrintMap == null || bluePrintMap.isEmpty()) {
                return;
            }
            List bluePrintDTOS = (List)bluePrintMap.get(materielNumber);
            if (bluePrintDTOS == null || bluePrintDTOS.isEmpty()) {
                return;
            }
            DynamicObjectCollection documentEntry = this.getModel().getDataEntity().getDynamicObjectCollection("documententry");
            for (int i = 0; i < bluePrintDTOS.size(); ++i) {
                String unitNumber;
                DynamicObject unitObj;
                BluePrintDTO bluePrintDTO = (BluePrintDTO)bluePrintDTOS.get(i);
                DynamicObject entryRow = documentEntry.addNew();
                entryRow.set("id", (Object)bluePrintDTO.getFileId());
                entryRow.set("icon", (Object)bluePrintDTO.getIcon());
                entryRow.set("documentnumber", (Object)bluePrintDTO.getDocumentNumber());
                entryRow.set("documentname", (Object)bluePrintDTO.getDocumentName());
                entryRow.set("createdate", (Object)bluePrintDTO.getCreateDate());
                entryRow.set("modifydate", (Object)bluePrintDTO.getModifyDate());
                entryRow.set("version", (Object)bluePrintDTO.getVersion());
                entryRow.set("filesize", (Object)bluePrintDTO.getFileSize());
                entryRow.set("drawingno", (Object)bluePrintDTO.getDrawingNo());
                entryRow.set("specifications", (Object)bluePrintDTO.getSpecifications());
                entryRow.set("materialquality", (Object)bluePrintDTO.getMaterialQuality());
                entryRow.set("colour", (Object)bluePrintDTO.getColour());
                entryRow.set("quantity", (Object)bluePrintDTO.getQuantity());
                this.getModel().setValue("materiel", materielIdObj, i);
                String creatorName = bluePrintDTO.getCreatorName();
                String creatorNumber = bluePrintDTO.getCreatorNumber();
                DynamicObject creatorObj = QueryServiceHelper.queryOne((String)"bos_user", (String)"id", (QFilter[])new QFilter[]{new QFilter("name", "=", (Object)creatorName).and("number", "=", (Object)creatorNumber)});
                if (creatorObj != null) {
                    this.getModel().setValue("creator", (Object)creatorObj.getLong("id"), i);
                }
                if ((unitObj = QueryServiceHelper.queryOne((String)"bd_measureunits", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)(unitNumber = bluePrintDTO.getUnit()))})) == null) continue;
                this.getModel().setValue("UNIT", (Object)unitObj.getLong("id"), i);
            }
        }
        catch (Exception exception) {
            log.error("\u83b7\u53d6\u5176\u4ed6\u6587\u6863\u51fa\u9519\uff1a" + exception);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u670d\u52a1\u51fa\u9519\uff0c\u8bf7\u91cd\u8bd5\uff0c\u9519\u8bef\u4fe1\u606f\uff1a{0}", (String)"PurBluePrintPlugin_4", (String)"scm-pur-formplugin", (Object[])new Object[]{exception}));
        }
    }
}

