/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.formplugin;

import com.alibaba.fastjson.JSON;
import java.io.IOException;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dlock.DLock;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.report.CellStyle;
import kd.bos.extplugin.PluginProxy;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.form.plugin.YzjContextMenuClickPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.ORMUtil;
import kd.scm.common.checkmapping.PurCheckMappingUtils;
import kd.scm.common.checkmapping.PurCheckServiceImpl;
import kd.scm.common.constant.InitDataConstant;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.enums.CheckStatusEnum;
import kd.scm.common.systemjoint.SystemJointChannelHelper;
import kd.scm.common.util.ApiConfigUtil;
import kd.scm.common.util.BatchCheckUtil;
import kd.scm.common.util.BillFormUtil;
import kd.scm.common.util.BizPartnerUtil;
import kd.scm.common.util.CommonUtil;
import kd.scm.common.util.DateUtil;
import kd.scm.common.util.DynamicFormUtil;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.util.ExceptionUtil;
import kd.scm.common.util.ExchrateUtil;
import kd.scm.common.util.LowTimer;
import kd.scm.common.util.MaterialUtil;
import kd.scm.common.util.MetaDataUtil;
import kd.scm.common.util.OrgUtil;
import kd.scm.common.util.SupplierChatEngineUtil;
import kd.scm.common.util.check.CheckRelationUtil;
import kd.scm.common.util.check.HandCheckImpl;
import kd.scm.common.util.check.HandCheckUtil;
import kd.scm.common.util.check.Icheck;
import kd.scm.common.util.check.OrderCheckUtil;
import kd.scm.common.util.excel.ExcelDataEntity;
import kd.scm.common.util.excel.ExcelUtil;
import kd.scm.pur.business.PurAvailableCheckBasicQtyHelper;
import kd.scm.pur.formplugin.OrgSumInfo;
import kd.scm.pur.formplugin.ext.PurHandCheckSupportImpl;
import kd.sdk.scm.pur.extpoint.IPurHandCheckSupport;

public class PurHandCheckPlugin
extends AbstractFormPlugin
implements HyperLinkClickListener,
RowClickEventListener {
    private static final Log log = LogFactory.getLog(PurHandCheckPlugin.class, (String)"eae607fb000143ac");
    private static final String ORG_ENTRY_KEY = "orgentry";
    private static final String CHECKSUM_ENTRY_KEY = "sumentryentity";
    private static final String PUR_ENTRY_KEY = "materialentryentity3";
    private static final String PUR_ENTRY_SUFFIX = "3";
    private static final String GROUPKEY = "groupkey";
    private static final String BYCHECKDATE = "bycheckdate";
    private IAppCache cache = AppCache.get((String)"scm_handchecklock");
    private static final int PERIOD = 27;
    private static boolean isSelected = false;
    private static int previousSelect = -1;
    protected Icheck check;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        this.addClickListeners(new String[]{"lbl_closereimburtips", "lbl_showreimburtips"});
        IFormView view = this.getView();
        EntryGrid purSumGrid = (EntryGrid)view.getControl(PUR_ENTRY_KEY);
        purSumGrid.addHyperClickListener((HyperLinkClickListener)this);
        EntryGrid headGrid = (EntryGrid)this.getView().getControl(CHECKSUM_ENTRY_KEY);
        headGrid.addRowClickListener((RowClickEventListener)this);
        headGrid.addHyperClickListener((HyperLinkClickListener)this);
        headGrid.addDataBindListener((EntryGridBindDataListener)new /* Unavailable Anonymous Inner Class!! */);
        EntryGrid orgGrid = (EntryGrid)this.getView().getControl(ORG_ENTRY_KEY);
        orgGrid.addRowClickListener((RowClickEventListener)this);
    }

    public void itemClick(ItemClickEvent evt) {
        String clickKey = evt.getItemKey();
        if (clickKey.length() == 0) {
            return;
        }
        switch (clickKey) {
            case "recheck": {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u91cd\u65b0\u5bf9\u8d26\u4f1a\u5173\u95ed\u5f53\u524d\u9875\u9762\uff0c\u662f\u5426\u91cd\u65b0\u5bf9\u8d26\uff1f", (String)"PurHandCheckPlugin_0", (String)"scm-pur-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("recheck"));
                break;
            }
            case "tocheck": {
                this.createCheckBill();
                break;
            }
            case "comparedata": {
                FormShowParameter param = BillFormUtil.assembleShowDynamicFormParam((String)"pbd_comparedata", null, (CloseCallBack)new CloseCallBack((IFormPlugin)this, "comfirmaction"), (ShowType)ShowType.MainNewTabPage);
                this.getView().showForm(param);
                break;
            }
            case "export": {
                this.export();
                break;
            }
            case "barrefresh": {
                this.initData(false);
                this.getView().updateView();
                break;
            }
        }
        super.itemClick(evt);
    }

    protected void export() {
        int rowCount = this.getModel().getEntryRowCount(PUR_ENTRY_KEY);
        if (rowCount <= 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u5bfc\u51fa\u7684\u6570\u636e\u3002", (String)"PurHandCheckPlugin_1", (String)"scm-pur-formplugin", (Object[])new Object[0]));
            return;
        }
        IFormView view = this.getView();
        List<DynamicObject> selectedRows = this.getSelectObject(CHECKSUM_ENTRY_KEY);
        HashMap<String, String> supplierMap = new HashMap<String, String>(selectedRows.size());
        HashMap<String, String> currMap = new HashMap<String, String>(selectedRows.size());
        for (DynamicObject selectRow : selectedRows) {
            String groupKey = selectRow.getString(GROUPKEY);
            DynamicObject supplier = selectRow.getDynamicObject("supplier");
            DynamicObject curr = selectRow.getDynamicObject("curr");
            if (null == supplier || null == curr) continue;
            supplierMap.put(groupKey, supplier.getString("name"));
            currMap.put(groupKey, curr.getString("name"));
        }
        try {
            ExcelDataEntity excelDataEntity = new ExcelDataEntity();
            excelDataEntity.createSheet();
            excelDataEntity.setFileName(ResManager.loadKDString((String)"\u5bf9\u8d26\u660e\u7ec6.xlsx", (String)"PurHandCheckPlugin_2", (String)"scm-pur-formplugin", (Object[])new Object[0]));
            this.setColumn(excelDataEntity);
            this.setExcelHeader(excelDataEntity);
            this.setEexclBody(excelDataEntity, supplierMap, currMap);
            ExcelUtil.exportExcel((IFormView)view, (ExcelDataEntity)excelDataEntity);
        }
        catch (IOException e) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u5bfc\u51fa\u5931\u8d25\u3002", (String)"PurHandCheckPlugin_3", (String)"scm-pur-formplugin", (Object[])new Object[0]));
            log.warn((Throwable)e);
        }
    }

    protected void setColumn(ExcelDataEntity excelDataEntity) {
        List columnList = MetaDataUtil.getColumnKey((String)"pur_handcheck", (String)PUR_ENTRY_KEY);
        columnList.add("supplier");
        columnList.add("curr");
        excelDataEntity.setColumnKeyList(columnList);
    }

    protected void setExcelHeader(ExcelDataEntity excelDataEntity) throws IOException {
        List<String> columnTitle = this.getColumnTitle(excelDataEntity.getColumnKeyList());
        excelDataEntity.setExcelHeader(columnTitle);
    }

    private List<String> getColumnTitle(List<String> columnList) {
        ArrayList<String> columnTitleList = new ArrayList<String>();
        IDataModel model = this.getModel();
        for (String column : columnList) {
            DynamicProperty pro = (DynamicProperty)model.getDataEntityType().findProperty(column);
            if (pro != null) {
                columnTitleList.add(pro.getDisplayName().toString());
                continue;
            }
            if ("supplier".equals(column)) {
                columnTitleList.add(ResManager.loadKDString((String)"\u4f9b\u5e94\u5546", (String)"PurHandCheckPlugin_4", (String)"scm-pur-formplugin", (Object[])new Object[0]));
                continue;
            }
            if ("curr".equals(column)) {
                columnTitleList.add(ResManager.loadKDString((String)"\u5e01\u522b", (String)"PurHandCheckPlugin_5", (String)"scm-pur-formplugin", (Object[])new Object[0]));
                continue;
            }
            if ("materialname3".equals(column)) {
                columnTitleList.add(ResManager.loadKDString((String)"\u7269\u6599\u540d\u79f0", (String)"PurHandCheckPlugin_6", (String)"scm-pur-formplugin", (Object[])new Object[0]));
                continue;
            }
            if ("materialmodel3".equals(column)) {
                columnTitleList.add(ResManager.loadKDString((String)"\u89c4\u683c\u578b\u53f7", (String)"PurHandCheckPlugin_7", (String)"scm-pur-formplugin", (Object[])new Object[0]));
                continue;
            }
            if ("basedatapropfield3".equals(column)) {
                columnTitleList.add(ResManager.loadKDString((String)"\u5546\u54c1\u540d\u79f0", (String)"PurHandCheckPlugin_8", (String)"scm-pur-formplugin", (Object[])new Object[0]));
                continue;
            }
            if (!"basedatapropfield1121".equals(column)) continue;
            columnTitleList.add(ResManager.loadKDString((String)"\u5546\u54c1\u89c4\u683c\u578b\u53f7", (String)"PurHandCheckPlugin_9", (String)"scm-pur-formplugin", (Object[])new Object[0]));
        }
        return columnTitleList;
    }

    private void setEexclBody(ExcelDataEntity excelDataEntity, Map<String, String> supplierMap, Map<String, String> currMap) throws IOException {
        int rowCount = this.getModel().getEntryRowCount(PUR_ENTRY_KEY);
        List columnKeyList = excelDataEntity.getColumnKeyList();
        for (int i = 0; i < rowCount; ++i) {
            List<String> rowData = this.getRowDataByIndex(columnKeyList, i, supplierMap, currMap);
            excelDataEntity.createRow(0, i + 1);
            excelDataEntity.setRowValue(0, rowData, i + 1);
        }
    }

    private List<String> getRowDataByIndex(List<String> columnKeyList, int i, Map<String, String> supplierMap, Map<String, String> currMap) {
        ArrayList<String> rowData = new ArrayList<String>();
        DynamicObject dyObj = this.getModel().getEntryRowEntity(PUR_ENTRY_KEY, i);
        Iterator<String> iterator = columnKeyList.iterator();
        block22: while (iterator.hasNext()) {
            String column;
            switch (column = iterator.next()) {
                case "supplier": {
                    String supplier = supplierMap.get(dyObj.getString("groupkey3"));
                    rowData.add(supplier);
                    continue block22;
                }
                case "curr": {
                    String curr = currMap.get(dyObj.getString("groupkey3"));
                    rowData.add(curr);
                    continue block22;
                }
                case "checkstatus3": {
                    String checkStatus = CheckStatusEnum.NODIFFERENCE.fromVal(dyObj.getString("checkstatus3")).getName();
                    rowData.add(checkStatus);
                    continue block22;
                }
                case "material3": {
                    Object material = dyObj.get("material3");
                    if (null != material && material instanceof DynamicObject) {
                        rowData.add(((DynamicObject)material).getString("number"));
                        continue block22;
                    }
                    rowData.add("");
                    continue block22;
                }
                case "materialname3": {
                    Object material3 = dyObj.get("material3");
                    if (null != material3 && material3 instanceof DynamicObject) {
                        rowData.add(((DynamicObject)material3).getString("name"));
                        continue block22;
                    }
                    rowData.add("");
                    continue block22;
                }
                case "materialmodel3": {
                    Object material2 = dyObj.get("material3");
                    if (null != material2 && material2 instanceof DynamicObject) {
                        rowData.add(((DynamicObject)material2).getString("modelnum"));
                        continue block22;
                    }
                    rowData.add("");
                    continue block22;
                }
                case "goods3": {
                    Object goods3 = dyObj.get("goods3");
                    if (null != goods3 && goods3 instanceof DynamicObject) {
                        rowData.add(((DynamicObject)goods3).getString("number"));
                        continue block22;
                    }
                    rowData.add("");
                    continue block22;
                }
                case "basedatapropfield3": {
                    Object goods = dyObj.get("goods3");
                    if (null != goods && goods instanceof DynamicObject) {
                        rowData.add(((DynamicObject)goods).getString("name"));
                        continue block22;
                    }
                    rowData.add("");
                    continue block22;
                }
                case "basedatapropfield1121": {
                    Object good = dyObj.get("goods3");
                    if (null != good && good instanceof DynamicObject) {
                        rowData.add(((DynamicObject)good).getString("model"));
                        continue block22;
                    }
                    rowData.add("");
                    continue block22;
                }
            }
            Object columnVal = dyObj.get(column);
            Object val = "";
            if (columnVal == null) {
                val = "";
            } else if (null != columnVal && columnVal instanceof DynamicObject) {
                DynamicObject dy = (DynamicObject)columnVal;
                IDataEntityType dataEntityType = dy.getDataEntityType();
                if (!(dataEntityType instanceof BasedataEntityType)) {
                    val = ((DynamicObject)columnVal).get("name");
                }
                if (dataEntityType instanceof BasedataEntityType) {
                    BasedataEntityType dataEntityTypeBd = (BasedataEntityType)dataEntityType;
                    String nameProperty = dataEntityTypeBd.getNameProperty();
                    val = StringUtils.isNotBlank((CharSequence)nameProperty) ? ((DynamicObject)columnVal).getString(nameProperty) : ((DynamicObject)columnVal).get("name");
                }
            } else {
                val = columnVal instanceof BigDecimal ? (((BigDecimal)columnVal).compareTo(BigDecimal.ZERO) == 0 ? "" : columnVal) : (columnVal instanceof Date ? DateUtil.date2str((Date)((Date)columnVal), (String)"yyyy-MM-dd") : (columnVal instanceof Boolean ? ((Boolean)columnVal != false ? ResManager.loadKDString((String)"\u662f", (String)"PurHandCheckPlugin_10", (String)"scm-pur-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5426", (String)"PurHandCheckPlugin_11", (String)"scm-pur-formplugin", (Object[])new Object[0])) : columnVal));
            }
            rowData.add(String.valueOf(val));
        }
        return rowData;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String key = ((AbstractOperate)args.getSource()).getOperateKey();
        if (key.isEmpty()) {
            return;
        }
        switch (key) {
            case "wechat": {
                this.weChat();
                break;
            }
        }
    }

    protected void weChat() {
        int currentIndex;
        IDataModel entryOperate = this.getModel();
        DynamicObject supplier = (DynamicObject)entryOperate.getEntryRowEntity(CHECKSUM_ENTRY_KEY, currentIndex = entryOperate.getEntryCurrentRowIndex(CHECKSUM_ENTRY_KEY)).get("supplier");
        Map resultMap = SupplierChatEngineUtil.createSupplierChat((DynamicObject)supplier);
        if ("true".equals(resultMap.get("succed"))) {
            YzjContextMenuClickPlugin yzj = new YzjContextMenuClickPlugin();
            yzj.setView(this.getView());
            HashMap mData = new HashMap();
            mData.put("openId", resultMap.get("data"));
            mData.put("userName", "");
            mData.put("chattype", "chat_pc");
            yzj.yzjInterface("createAndChat", mData);
        } else {
            this.getView().showMessage(resultMap.get("message").toString());
        }
    }

    public void openCheckCenter() {
        FormShowParameter formParamter = this.getView().getFormShowParameter();
        Map customerParam = formParamter.getCustomParams();
        FormShowParameter param = BillFormUtil.assembleShowDynamicFormParam((String)"pur_checkcenter", (Map)customerParam, (CloseCallBack)new CloseCallBack((IFormPlugin)this, "comfirmaction"), (ShowType)ShowType.MainNewTabPage);
        this.getView().showForm(param);
    }

    public void afterCreateNewData(EventObject e) {
        this.initData(false);
        this.initReminder();
    }

    private void initReminder() {
        IDataModel model = this.getModel();
        String reminder = ResManager.loadKDString((String)"\u6e29\u99a8\u63d0\u793a\uff1a", (String)"PurHandCheckPlugin_25", (String)"scm-pur-formplugin", (Object[])new Object[0]);
        String reminder1 = ResManager.loadKDString((String)"1.\u5bf9\u8d26\u6570\u636e\u8303\u56f4\u5305\u542b\u6536\u8d27/\u5165\u5e93\u5355\uff08\u542b\u9000\u8d27\uff09\u3001\u7d22\u8d54\u5355\uff1b", (String)"PurHandCheckPlugin_26", (String)"scm-pur-formplugin", (Object[])new Object[0]);
        String reminder2 = ResManager.loadKDString((String)"2.\u82e5\u5165\u5e93\u5355\u5728ERP\u7cfb\u7edf\u4e2d\u5df2\u751f\u6210\u5e94\u4ed8\u5355\u6216\u7ea2\u84dd\u5355\u6838\u9500\uff0c\u5219\u5bf9\u8d26\u4e2d\u5fc3\u4e0d\u663e\u793a\u8fd9\u4e9b\u5355\u636e\uff1b", (String)"PurHandCheckPlugin_27", (String)"scm-pur-formplugin", (Object[])new Object[0]);
        String reminder3 = ResManager.loadKDString((String)"3.\u6700\u7ec8\u751f\u6210\u5bf9\u8d26\u5355\u7684\u91d1\u989d\u7531\u6240\u9009\u5bf9\u8d26\u6570\u636e\u8fdb\u884c\u5408\u8ba1\u3002\u5982\u679c\u5305\u542b\u7d22\u8d54\u5355\uff0c\u4ef7\u7a0e\u5408\u8ba1\u4e0d\u5f97\u5c0f\u4e8e0\u3002", (String)"PurHandCheckPlugin_28", (String)"scm-pur-formplugin", (Object[])new Object[0]);
        model.setValue("text_tips_title", (Object)reminder);
        model.setValue("text_tips", (Object)reminder1);
        model.setValue("text_tips1", (Object)reminder2);
        model.setValue("text_tips2", (Object)reminder3);
        this.getView().setVisible(Boolean.FALSE, new String[]{"text_tips", "text_tips1", "text_tips2", "lbl_closereimburtips"});
        this.getView().setVisible(Boolean.TRUE, new String[]{"lbl_showreimburtips"});
    }

    public void click(EventObject evt) {
        String clickKey;
        Control control = (Control)evt.getSource();
        switch (clickKey = control.getKey()) {
            case "lbl_showreimburtips": {
                this.getView().setVisible(Boolean.TRUE, new String[]{"text_tips", "text_tips1", "text_tips2", "lbl_closereimburtips"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"lbl_showreimburtips"});
                break;
            }
            case "lbl_closereimburtips": {
                this.getView().setVisible(Boolean.FALSE, new String[]{"text_tips", "text_tips1", "text_tips2", "lbl_closereimburtips"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"lbl_showreimburtips"});
            }
        }
        super.click(evt);
    }

    private void initData(Boolean isAutoRefresh) {
        ArrayList<DynamicObject> sumList = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> purDetailList = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> saleDetailList = new ArrayList<DynamicObject>();
        Map<String, Map<String, Object>> periodMap = this.getCheckPeriod();
        HashMap<String, Map<String, Object>> params = new HashMap<String, Map<String, Object>>(2);
        String jointchanneldata = this.getJointChannelId();
        IPageCache pageCache = this.getPageCache();
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object showMatched = this.getView().getFormShowParameter().getCustomParams().get("showmatched");
        if (showMatched != null) {
            pageCache.put("showmatched", String.valueOf(showMatched));
        } else {
            pageCache.put("showmatched", String.valueOf(false));
        }
        List<IPurHandCheckSupport> handCheckPlugin = this.getExtendPlugin();
        Set<String> entryFields = this.getAllExtendFields(handCheckPlugin);
        Map<String, Set<String>> entryFieldsMap = this.getExtendFieldsMap(handCheckPlugin);
        Map<String, Set<String>> extendGroups = this.getExtendCheckGroupFields(handCheckPlugin);
        Set<String> removeGroups = this.removeCheckGroupFields(handCheckPlugin);
        LowTimer timer = new LowTimer();
        for (Map.Entry<String, Map<String, Object>> period : periodMap.entrySet()) {
            DynamicObjectCollection purCheckSum;
            params.clear();
            params.put("billdate", period.getValue());
            PurCheckServiceImpl checkService = new PurCheckServiceImpl(entryFields, entryFieldsMap, extendGroups, removeGroups, Boolean.valueOf(true));
            Map purMap = checkService.getData(params, customParams, jointchanneldata);
            if (CollectionUtils.isEmpty((Map)purMap) || null == (purCheckSum = (DynamicObjectCollection)purMap.get("sum")) || purCheckSum.size() <= 0) continue;
            sumList.addAll((Collection<DynamicObject>)purCheckSum);
            DynamicObjectCollection purDetail = (DynamicObjectCollection)purMap.get("detail");
            purDetailList.addAll((Collection<DynamicObject>)purDetail);
        }
        PurAvailableCheckBasicQtyHelper.assembleDetailmatchQty(purDetailList);
        log.info("initData\u67e5\u8be2\u5bf9\u8d26\u6570\u636e\u65f6\u957f\uff1a" + timer.msValue());
        this.buildCheckSumData(sumList, purDetailList, saleDetailList, CHECKSUM_ENTRY_KEY, isAutoRefresh);
    }

    private String getJointChannelId() {
        Object jointchanneldata = this.getView().getFormShowParameter().getCustomParams().get("jointchanneldata");
        if (jointchanneldata == null) {
            jointchanneldata = SystemJointChannelHelper.getDefaultJointChannelId();
        }
        return String.valueOf(jointchanneldata);
    }

    private Map<String, Map<String, Object>> getCheckPeriod() {
        long startTime = System.currentTimeMillis();
        int period = 27;
        HashMap<String, Map<String, Object>> periodMap = new HashMap<String, Map<String, Object>>();
        Map params = this.getView().getFormShowParameter().getCustomParams();
        Object byCheckDate = params.get(BYCHECKDATE);
        if (null != byCheckDate && Boolean.parseBoolean(byCheckDate.toString())) {
            Date earlyDate = this.getEarlyDate();
            Date nowDate = DateUtil.getPreviousNatureMonthDate((int)period);
            if (null != earlyDate) {
                int index = 0;
                while (nowDate.compareTo(earlyDate) > 0) {
                    HashMap<String, Date> datetoMap = new HashMap<String, Date>(2);
                    datetoMap.put("<=", nowDate);
                    datetoMap.put(">=", DateUtil.getDefaultPreviousMonthDate((Date)nowDate));
                    nowDate = DateUtil.addMonth((Date)nowDate, (int)-1);
                    periodMap.put(String.valueOf(index), datetoMap);
                    ++index;
                }
            }
        } else {
            Object datefrom;
            Object dateto = params.get("enddate");
            String pattern = "yyyy-MM-dd HH:mm:ss";
            HashMap<String, Date> datetoMap = new HashMap<String, Date>(2);
            if (null != dateto) {
                datetoMap.put("<=", DateUtil.string2date((String)dateto.toString(), (String)pattern));
            }
            if (null != (datefrom = params.get("startdate"))) {
                datetoMap.put(">=", DateUtil.string2date((String)datefrom.toString(), (String)pattern));
            }
            periodMap.put("0", datetoMap);
        }
        long endTime = System.currentTimeMillis();
        log.info("getPeriod \u6267\u884c\u65f6\u957f\uff1a" + (endTime - startTime));
        return periodMap;
    }

    private Date getEarlyDate() {
        String selectFields = "id,billno,billdate";
        String orderBys = "billdate";
        Map params = this.getView().getFormShowParameter().getCustomParams();
        DynamicObjectCollection cols = ORMUtil.queryDynamicObjectCollection((String)"pur_instock", (String)selectFields, this.buildCondition(params, "pur_instock"), (String)orderBys, (int)1);
        Date earlyDate = null;
        if (null != cols && cols.size() > 0) {
            earlyDate = (Date)((DynamicObject)cols.get(0)).get("billdate");
        } else {
            this.getView().showMessage(ResManager.loadKDString((String)"\u672a\u53d6\u5230\u5165\u5e93\u5355\u6570\u636e\u3002", (String)"PurHandCheckPlugin_12", (String)"scm-pur-formplugin", (Object[])new Object[0]));
        }
        return earlyDate;
    }

    private Map<String, Map<String, Object>> buildCondition(Map<String, Map<String, Object>> params, Map<String, Object> customParams, String entityKey) {
        Map<Object, Object> filterMap = new HashMap();
        filterMap = this.buildCondition(customParams, entityKey);
        filterMap.putAll(params);
        return filterMap;
    }

    private Map<String, Map<String, Object>> buildCondition(Map<String, Object> params, String entityKey) {
        String rcvOrgscope;
        String settleorgscope;
        HashMap<String, Map<String, Object>> filterMap = new HashMap<String, Map<String, Object>>();
        String settleorgKey = null;
        String supplierKey = null;
        if (entityKey.equals("pur_return") || entityKey.equals("pur_instock") || entityKey.equals("scp_instock") || entityKey.equals("scp_return") || entityKey.equals("pur_receipt") || entityKey.equals("scp_receipt")) {
            HashMap<String, Boolean> isCheckInvoiceMap = new HashMap<String, Boolean>(1);
            isCheckInvoiceMap.put("=", Boolean.FALSE);
            filterMap.put("materialentry.ischeckorinvoice", isCheckInvoiceMap);
        }
        if ("pur_instock".equals(entityKey)) {
            HashMap<String, String> isNotWriteOffMap = new HashMap<String, String>(1);
            isNotWriteOffMap.put("!=", "1");
            filterMap.put("writeoffflag", isNotWriteOffMap);
            settleorgKey = "materialentry.entrysettleorg";
            supplierKey = "materialentry.settlesup";
        } else if ("pur_saloutstock".equals(entityKey)) {
            settleorgKey = "materialentry.entrysettleorg";
            supplierKey = "supplier";
            HashMap<String, String> entryCheckStatusMap = new HashMap<String, String>(1);
            entryCheckStatusMap.put("!=", "B");
            filterMap.put("materialentry.checkstatus", entryCheckStatusMap);
        }
        HashMap<String, BigDecimal> qtyMap = new HashMap<String, BigDecimal>(1);
        qtyMap.put("<=", BigDecimal.ZERO);
        filterMap.put("materialentry.sumcheckqty", qtyMap);
        String supplierscope = (String)params.get("supplier");
        if (null != supplierscope && !supplierscope.isEmpty()) {
            HashMap<String, Object[]> supplierMap = new HashMap<String, Object[]>(1);
            supplierMap.put("in", Arrays.stream(supplierscope.split(",")).map(s -> Long.parseLong(s.trim())).collect(Collectors.toSet()).toArray());
            filterMap.put(supplierKey, supplierMap);
        }
        if (null != (settleorgscope = (String)params.get("settleorg")) && !settleorgscope.isEmpty()) {
            HashMap<String, Object[]> settleOrgScopeMap = new HashMap<String, Object[]>(1);
            settleOrgScopeMap.put("in", Arrays.stream(settleorgscope.split(",")).map(s -> Long.parseLong(s.trim())).collect(Collectors.toSet()).toArray());
            filterMap.put(settleorgKey, settleOrgScopeMap);
        } else {
            List permissionOrgs = OrgUtil.getHasSettlePermissionOrgs((String)entityKey);
            HashMap<String, List> orgsMap = new HashMap<String, List>(1);
            orgsMap.put("in", permissionOrgs);
            filterMap.put(settleorgKey, orgsMap);
        }
        String materielGroup = (String)params.get("materialgroup");
        if (null != materielGroup && !materielGroup.isEmpty()) {
            HashMap<String, List> materialMap = new HashMap<String, List>(1);
            materialMap.put("in", MaterialUtil.getMaterialByGroup((Object[])Arrays.stream(materielGroup.split(",")).map(s -> Long.parseLong(s.trim())).collect(Collectors.toSet()).toArray()));
            filterMap.put("materialentry.material", materialMap);
        }
        if (null != (rcvOrgscope = (String)params.get("rcvorg")) && !rcvOrgscope.isEmpty()) {
            HashMap<String, Object[]> rcvOrgScopeMap = new HashMap<String, Object[]>(1);
            rcvOrgScopeMap.put("in", Arrays.stream(rcvOrgscope.split(",")).map(s -> Long.parseLong(s.trim())).collect(Collectors.toSet()).toArray());
            filterMap.put("org", rcvOrgScopeMap);
        } else {
            List permissionOrgs = OrgUtil.getUserHasPermissionOrgs((String)entityKey);
            HashMap<String, List> orgsMap = new HashMap<String, List>(1);
            orgsMap.put("in", permissionOrgs);
            filterMap.put("org", orgsMap);
        }
        filterMap.putAll(this.getCheck(false).wrapCustomFilterMap(params, entityKey));
        HashMap<String, String> statusMap = new HashMap<String, String>(1);
        statusMap.put("=", BillStatusEnum.AUDIT.getVal());
        filterMap.put("billstatus", statusMap);
        HashMap<String, QFilter> vmiMap = new HashMap<String, QFilter>(1);
        HashSet<Long> biztypeSet = new HashSet<Long>(2);
        biztypeSet.add(InitDataConstant.BUSINESSTYPE_REVMI_ID);
        biztypeSet.add(InitDataConstant.BUSINESSTYPE_VMI_ID);
        QFilter qfilter = new QFilter("businesstype", "not in", biztypeSet);
        QFilter vmisettleFilter = new QFilter("businesstype", "in", biztypeSet).and(new QFilter("vmisettle", "=", (Object)"1"));
        qfilter.or(vmisettleFilter);
        vmiMap.put("qfilter", qfilter);
        filterMap.put("vmisettle", vmiMap);
        List<IPurHandCheckSupport> handCheckPlugins = this.getExtendPlugin();
        if (handCheckPlugins != null && !handCheckPlugins.isEmpty()) {
            handCheckPlugins.forEach(t -> {
                Map tempParams = t.getFilterMap(params, entityKey);
                if (tempParams != null && !tempParams.isEmpty()) {
                    filterMap.putAll(tempParams);
                }
            });
        }
        return filterMap;
    }

    private void buildCheckSumData(List<DynamicObject> sumList, List<DynamicObject> purDetailList, List<DynamicObject> saleDetailList, String entryKey, Boolean isAutoRefresh) {
        LowTimer timer = new LowTimer();
        this.buildHeadEndDate();
        IFormView view = this.getView();
        if (sumList == null || sumList.size() == 0) {
            this.clearData();
            view.updateView();
            if (!isAutoRefresh.booleanValue()) {
                view.showErrorNotification(ResManager.loadKDString((String)"\u5bf9\u4e0d\u8d77\uff0c\u6682\u65e0\u76f8\u5173\u6570\u636e\u3002", (String)"PurHandCheckPlugin_13", (String)"scm-pur-formplugin", (Object[])new Object[0]));
            }
            return;
        }
        Integer maxCheckRow = HandCheckUtil.getMaxCheckRow((String)"scp_check", (String)"maxcheckdata");
        if (sumList.size() > maxCheckRow) {
            this.getView().showTipNotification(MessageFormat.format(ResManager.loadKDString((String)"\u5bf9\u8d26\u6c47\u603b\u6570\u636e\u8d85\u8fc7{0}\u884c\uff0c\u8bf7\u7f29\u5c0f\u8fc7\u6ee4\u8303\u56f4\u91cd\u65b0\u5bf9\u8d26\u3002", (String)"PurHandCheckPlugin_30", (String)"scm-pur-formplugin", (Object[])new Object[0]), maxCheckRow));
            return;
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.deleteEntryData(ORG_ENTRY_KEY);
        model.deleteEntryData(entryKey);
        List properties = DynamicObjectUtil.getEntryentityProperties((IDataEntityType)model.getEntryEntity(entryKey).getDynamicObjectType());
        Map keyMap = DynamicObjectUtil.getDynamicObjectKeyMap((DynamicObject)sumList.get(0));
        int i = 0;
        TableValueSetter ts = new TableValueSetter(new String[0]);
        for (DynamicObject sumCol : sumList) {
            for (String key : properties) {
                if (null == keyMap.get(key)) continue;
                ts.set(key, sumCol.get(key), i);
            }
            Object checkPeriod = null;
            if (sumCol != null) {
                checkPeriod = sumCol.get("checkperiod");
            }
            if (null != checkPeriod) {
                Object[] checkDates = CommonUtil.str2objs((String)checkPeriod.toString(), (String)":");
                Object dateFrom = null;
                Object dateTo = null;
                if (checkDates.length > 1) {
                    dateFrom = checkDates[1];
                    dateTo = checkDates[0];
                } else {
                    dateTo = checkDates[0];
                }
                ts.set("datefrom", (Object)DateUtil.string2date((String)(null == dateFrom ? null : dateFrom.toString()), (String)"yyyy-MM-dd"), i);
                ts.set("dateto", (Object)DateUtil.string2date((String)(null == dateTo ? null : dateTo.toString()), (String)"yyyy-MM-dd"), i);
            }
            ++i;
        }
        model.beginInit();
        model.batchCreateNewEntryRow(entryKey, ts);
        model.endInit();
        log.info("\u6784\u9020\u6c47\u603b\u6570\u636e\u65f6\u957f\uff1a" + timer.msValue());
        timer.reset();
        boolean isMatch = this.isMatch();
        if (isMatch) {
            List entryIdList = DynamicObjectUtil.getProVal2List((DynamicObject[])purDetailList.toArray(new DynamicObject[0]), (String)"entryid");
            DynamicObjectCollection relationDatas = CheckRelationUtil.getRelationData((List)entryIdList);
            log.info("\u6784\u9020\u5173\u8054\u5339\u914d\u6570\u636e\u65f6\u957f\uff1a" + timer.msValue());
            timer.reset();
            this.buildMatchData(purDetailList, relationDatas, PUR_ENTRY_SUFFIX);
            log.info("\u6784\u9020\u5339\u914d\u6570\u636e\u65f6\u957f1\uff1a" + timer.msValue());
            timer.reset();
        } else {
            this.buildUnMatchData(purDetailList, PUR_ENTRY_SUFFIX);
            log.info("\u6784\u9020\u5339\u914d\u6570\u636e\u65f6\u957f2\uff1a" + timer.msValue());
            timer.reset();
        }
        IPageCache pageCache = this.getPageCache();
        List allDetails = HandCheckUtil.getAllDetailCache((IPageCache)pageCache);
        HandCheckUtil.fillMatchData((IDataModel)model, (List)allDetails, (String)PUR_ENTRY_SUFFIX, (boolean)true);
        log.info("\u6784\u9020\u5339\u914d\u6570\u636e\u65f6\u957f\uff1a" + timer.msValue());
        timer.reset();
        if (isMatch) {
            this.buildDiffSumData();
        } else {
            this.setUndiffStatus(pageCache, PUR_ENTRY_SUFFIX);
        }
        log.info("\u8bbe\u7f6e\u5dee\u5f02\u6570\u636e\u65f6\u957f\uff1a" + timer.msValue());
        timer.reset();
        HandCheckUtil.buildVirtualData((List)allDetails, (String)"pur_instock", (String)PUR_ENTRY_SUFFIX);
        HandCheckUtil.buildVirtualData((List)allDetails, (String)"pur_return", (String)PUR_ENTRY_SUFFIX);
        this.buildCheckSumData(purDetailList);
        this.setStatusColumnFontColor(entryKey, "");
        this.clearStatus(CHECKSUM_ENTRY_KEY);
        this.clearStatus(PUR_ENTRY_KEY);
        log.info("buildCheckData \u6784\u9020\u6570\u636e\u6267\u884c\u65f6\u957f\uff1a" + timer.msValue());
    }

    protected void setUndiffStatus(IPageCache pageCache, String suffix) {
        List allDetails = HandCheckUtil.getAllDetailCache((IPageCache)pageCache);
        for (Map detail : allDetails) {
            detail.put("checkstatus" + suffix, "1");
        }
    }

    protected void buildMatchData(List<DynamicObject> purDetailList, DynamicObjectCollection relationDatas, String suffix) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        IPageCache pageCache = this.getPageCache();
        String[] groupKeys = this.getCheckGroups();
        HandCheckUtil.buildMatchData((AbstractFormDataModel)model, (IPageCache)pageCache, purDetailList, (DynamicObjectCollection)relationDatas, (String)PUR_ENTRY_KEY, (String[])groupKeys, (String)suffix);
    }

    protected void buildUnMatchData(List<DynamicObject> purDetailList, String suffix) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        IPageCache pageCache = this.getPageCache();
        String[] groupKeys = this.getCheckGroups();
        HandCheckUtil.buildUnMatchData((AbstractFormDataModel)model, (IPageCache)pageCache, purDetailList, (String)PUR_ENTRY_KEY, (String[])groupKeys, (String)suffix);
    }

    private void buildHeadEndDate() {
        FormShowParameter params = this.getView().getFormShowParameter();
        String endDate = (String)params.getCustomParam("enddate");
        if (null == endDate) {
            Date nowDate = DateUtil.getPreviousNatureMonthDate((int)27);
            endDate = DateUtil.date2str((Date)nowDate, (String)"yyyy-MM-dd HH:mm:ss");
        }
        this.getModel().setValue("enddatetext", (Object)MessageFormat.format(ResManager.loadKDString((String)"\u5bf9\u8d26\u622a\u6b62\u65e5\u671f\uff1a{0}", (String)"PurHandCheckPlugin_14", (String)"scm-pur-formplugin", (Object[])new Object[0]), endDate));
    }

    private void buildCheckSumData(List<DynamicObject> purDetail) {
        HashSet<String> billNoSet = new HashSet<String>((int)((double)purDetail.size() / 0.75));
        BigDecimal sumTaxAmount = BigDecimal.ZERO;
        for (DynamicObject detail : purDetail) {
            billNoSet.add(detail.getString("billno"));
            sumTaxAmount = sumTaxAmount.add(detail.getBigDecimal("taxamount"));
        }
        IDataModel model = this.getModel();
        model.setValue("becheckedbill", (Object)billNoSet.size());
        model.setValue("sumamount", (Object)sumTaxAmount);
    }

    private void buildDiffSumData() {
        IDataModel model = this.getModel();
        IPageCache pageCache = this.getPageCache();
        HashSet<String> billNoSet = new HashSet<String>();
        BigDecimal sumDiffTaxAmount = BigDecimal.ZERO;
        List allDetails = HandCheckUtil.getAllDetailCache((IPageCache)pageCache);
        for (Map detail : allDetails) {
            Object diffamt;
            Object checkStatusObj = detail.get("checkstatus3");
            if (checkStatusObj == null || CheckStatusEnum.NODIFFERENCE.getVal().equals(checkStatusObj.toString())) continue;
            Object billNoObj = detail.get("billno3");
            if (billNoObj != null) {
                String billNo = (String)billNoObj;
                billNoSet.add(billNo);
            }
            if ((diffamt = detail.get("diffamt3")) == null) continue;
            BigDecimal diffamtBd = new BigDecimal(diffamt.toString());
            sumDiffTaxAmount = sumDiffTaxAmount.add(diffamtBd);
        }
        model.setValue("exceptionbill", (Object)billNoSet.size());
        model.setValue("sumdiffamount", (Object)sumDiffTaxAmount);
    }

    protected void buildLeftOrgData(String entryKey, String suffix, String sumKey) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.deleteEntryData(ORG_ENTRY_KEY);
        DynamicObjectCollection checkSumCols = model.getEntryEntity(entryKey);
        HashMap<String, OrgSumInfo> orgSumMap = new HashMap<String, OrgSumInfo>();
        for (DynamicObject checkSumCol : checkSumCols) {
            DynamicObject settleOrg = checkSumCol.getDynamicObject(sumKey + suffix);
            if (null == settleOrg) continue;
            BigDecimal taxAmount = checkSumCol.getBigDecimal("taxamount" + suffix);
            String orgId = settleOrg.getPkValue().toString();
            OrgSumInfo sumInfo = (OrgSumInfo)orgSumMap.get(orgId);
            if (null == sumInfo) {
                sumInfo = new OrgSumInfo();
                sumInfo.setOrg(settleOrg);
                sumInfo.setSumTaxAmount(taxAmount);
            } else {
                sumInfo.addSumTaxAmount(taxAmount);
            }
            orgSumMap.put(orgId, sumInfo);
        }
        TableValueSetter ts = new TableValueSetter(new String[0]);
        int index = 0;
        for (Map.Entry data : orgSumMap.entrySet()) {
            ts.set("org", ((OrgSumInfo)data.getValue()).getOrg().getPkValue(), index);
            ts.set("orgsumamount", (Object)((OrgSumInfo)data.getValue()).getSumTaxAmount(), index);
            ++index;
        }
        model.batchCreateNewEntryRow(ORG_ENTRY_KEY, ts);
    }

    protected void setStatusColumnFontColor(String entryKey, String suffix) {
        EntryGrid grid = (EntryGrid)this.getControl(entryKey);
        IDataModel model = this.getModel();
        DynamicObjectCollection col = model.getEntryEntity(entryKey);
        ArrayList<CellStyle> cellStyles = new ArrayList<CellStyle>(col.size());
        int i = 0;
        for (DynamicObject rowEntity : col) {
            String checkStatus = rowEntity.getString("checkstatus" + suffix);
            String color = "#000000";
            color = "2".equals(checkStatus) ? "#ff0000" : "#00bf5f";
            CellStyle cs = new CellStyle();
            cs.setForeColor(color);
            cs.setRow(i);
            cs.setFieldKey("checkstatus" + suffix);
            cellStyles.add(cs);
            ++i;
        }
        grid.setCellStyle(cellStyles);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createCheckBill() {
        Object success;
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        EntryGrid grid = (EntryGrid)view.getControl(CHECKSUM_ENTRY_KEY);
        int[] selectIndex = grid.getSelectRows();
        if (selectIndex.length == 0) {
            view.showMessage(ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u4ee5\u751f\u6210\u5bf9\u8d26\u5355\u7684\u6570\u636e\uff0c\u8bf7\u9009\u62e9\u660e\u7ec6\u5206\u5f55\u3002", (String)"PurHandCheckPlugin_15", (String)"scm-pur-formplugin", (Object[])new Object[0]));
            return;
        }
        ArrayList<DynamicObject> selectRows = new ArrayList<DynamicObject>(selectIndex.length);
        for (int i = 0; i < selectIndex.length; ++i) {
            selectRows.add(model.getEntryRowEntity(CHECKSUM_ENTRY_KEY, selectIndex[i]));
        }
        ArrayList<DynamicObject> checkDynamicList = new ArrayList<DynamicObject>(selectRows.size());
        List purObjs = DynamicFormUtil.getSelectedData((IFormView)view, (IDataModel)model, (String)PUR_ENTRY_KEY);
        HashMap verifyRowMessage = new HashMap(1024);
        if (SystemJointChannelHelper.hasSpecJointType((String)this.getJointChannelId(), (String)"self")) {
            verifyRowMessage.putAll(HandCheckUtil.getVerifyRowMessage((List)purObjs, (String)PUR_ENTRY_SUFFIX));
        }
        if ((success = verifyRowMessage.get("succed")) != null && !((Boolean)success).booleanValue()) {
            this.getView().showMessage(verifyRowMessage.get("message").toString());
            return;
        }
        if (!this.isValideRow(purObjs)) {
            return;
        }
        HashMap<Object, ArrayList<DynamicObject>> groupKey_purObjsMap = new HashMap<Object, ArrayList<DynamicObject>>((int)((double)purObjs.size() / 0.75));
        for (DynamicObject col : purObjs) {
            String groupKey = col.getString("groupkey3");
            ArrayList<DynamicObject> purObjsList = (ArrayList<DynamicObject>)groupKey_purObjsMap.get(groupKey);
            if (null == purObjsList) {
                purObjsList = new ArrayList<DynamicObject>();
            }
            purObjsList.add(col);
            groupKey_purObjsMap.put(groupKey, purObjsList);
        }
        HashSet<String> supplieridSet = new HashSet<String>();
        List<IPurHandCheckSupport> handCheckPlugins = this.getExtendPlugin();
        for (DynamicObject checkSum : selectRows) {
            String checkGroupKey = checkSum.getString(GROUPKEY);
            List selectDetailObjs = (List)groupKey_purObjsMap.get(checkGroupKey);
            if (null == selectDetailObjs || selectDetailObjs.size() == 0) continue;
            DynamicObject billObj = this.createCheckBillHead(checkSum);
            this.createCheckBillEntryByEntryKey(billObj, selectDetailObjs, checkGroupKey, PUR_ENTRY_SUFFIX, "materialentry", handCheckPlugins);
            this.createCheckBillEntryByEntryKey(billObj, selectDetailObjs, checkGroupKey, PUR_ENTRY_SUFFIX, "outentry", null);
            BigDecimal sumAmount = billObj.getBigDecimal("sumtaxamount");
            checkDynamicList.add(billObj);
            if (checkSum.get("supplier") == null || !(checkSum.get("supplier") instanceof DynamicObject)) continue;
            supplieridSet.add(((DynamicObject)checkSum.get("supplier")).getPkValue().toString());
        }
        if (checkDynamicList.size() > 0) {
            StringBuilder sb = PurCheckMappingUtils.validateDeduction(checkDynamicList, (String)"materialentry", (String)"");
            if (sb.length() > 0) {
                String errmsg = ResManager.loadKDString((String)"\u751f\u6210\u5bf9\u8d26\u5355\u5931\u8d25\uff0c\u8bf7\u770b\u8be6\u60c5\u3002", (String)"PurOrderCheckPushPlugin_5", (String)"scm-pur-formplugin", (Object[])new Object[0]);
                this.getView().showMessage(errmsg, sb.toString(), MessageTypes.Default);
                return;
            }
            HashSet<String> sucessSupplieridSet = new HashSet();
            try {
                sucessSupplieridSet = this.lockedData(supplieridSet);
                if (sucessSupplieridSet.size() < supplieridSet.size()) {
                    view.showMessage(ResManager.loadKDString((String)"\u6240\u9009\u62e9\u7684\u5355\u636e\u6709\u4eba\u6b63\u5728\u751f\u6210\u5bf9\u8d26\u5355\uff0c\u8bf7\u7a0d\u540e\u5237\u65b0\u9875\u9762\u518d\u91cd\u65b0\u751f\u6210\u3002", (String)"PurHandCheckPlugin_22", (String)"scm-pur-formplugin", (Object[])new Object[0]));
                    return;
                }
                OperationResult opResult = SaveServiceHelper.saveOperate((String)"pur_check", (DynamicObject[])checkDynamicList.toArray(new DynamicObject[0]), null);
                if (null == opResult.getBillNos() || !opResult.isSuccess()) {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u751f\u6210\u5bf9\u8d26\u5355\u5931\u8d25\uff0c\u8bf7\u770b\u8be6\u60c5\u3002", (String)"PurOrderCheckPushPlugin_5", (String)"scm-pur-formplugin", (Object[])new Object[0]), opResult.getMessage() + ExceptionUtil.getErrorInfoDetails((List)opResult.getAllErrorOrValidateInfo()), MessageTypes.Default);
                    return;
                }
                this.updateOrderCheckData(checkDynamicList);
                Object[] objs = BusinessDataServiceHelper.load((String)"pur_check", (String)"id,billno,materialentry.qty,materialentry.taxamount,materialentry.srcbilltype,materialentry.poentryId", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)opResult.getSuccessPkIds())});
                BatchCheckUtil.writeBackPurOrder((DynamicObject[])objs, (String)"materialentry", (String)"", (String)"audit");
                this.resetCheckData();
                this.openCheckPage(objs);
            }
            finally {
                this.clearLockedData(sucessSupplieridSet);
            }
        } else {
            view.showMessage(ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u4ee5\u751f\u6210\u5bf9\u8d26\u5355\u7684\u6570\u636e\uff0c\u8bf7\u9009\u62e9\u660e\u7ec6\u5206\u5f55\u3002", (String)"PurHandCheckPlugin_15", (String)"scm-pur-formplugin", (Object[])new Object[0]));
        }
    }

    private void resetCheckData() {
        EntryGrid SumGrid = (EntryGrid)this.getControl(CHECKSUM_ENTRY_KEY);
        HashSet<String> deleteMaterialGroup = new HashSet<String>(1024);
        int[] selectRows = SumGrid.getSelectRows();
        for (int index = 0; index < selectRows.length; ++index) {
            deleteMaterialGroup.add(this.getModel().getEntryRowEntity(CHECKSUM_ENTRY_KEY, index).getString(GROUPKEY));
        }
        this.initData(true);
        this.getView().updateView(CHECKSUM_ENTRY_KEY);
        SumGrid = (EntryGrid)this.getControl(CHECKSUM_ENTRY_KEY);
        DynamicObjectCollection checkSum = this.getModel().getEntryEntity(CHECKSUM_ENTRY_KEY);
        ArrayList<Integer> newSelectRows = new ArrayList<Integer>(deleteMaterialGroup.size());
        for (int indexRow = 0; indexRow < checkSum.size(); ++indexRow) {
            if (!deleteMaterialGroup.contains(((DynamicObject)checkSum.get(indexRow)).getString(GROUPKEY))) continue;
            newSelectRows.add(indexRow);
        }
        Iterator iterator = newSelectRows.iterator();
        while (iterator.hasNext()) {
            int s = (Integer)iterator.next();
            SumGrid.selectRows(s);
            SumGrid.entryRowClick(Integer.valueOf(s));
        }
        this.getView().updateView(PUR_ENTRY_KEY);
    }

    private void clearLockedData(Set<String> sucessSupplieridSet) {
        for (String supplierid : sucessSupplieridSet) {
            this.cache.remove(supplierid + "_scm_handcheck");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<String> lockedData(Set<String> supplieridSet) {
        HashSet<String> sucessSupplieridSet = new HashSet<String>();
        for (String supplierid : supplieridSet) {
            boolean flag;
            DLock lock = DLock.create((String)supplierid).fastMode();
            if (lock == null || !(flag = lock.tryLock(50000L))) continue;
            try {
                String isExist = (String)this.cache.get(supplierid + "_scm_handcheck", String.class);
                if (isExist != null) continue;
                sucessSupplieridSet.add(supplierid);
                this.cache.put(supplierid + "_scm_handcheck", (Object)"isExist_Flag");
            }
            finally {
                if (lock == null) continue;
                lock.unlock();
            }
        }
        return sucessSupplieridSet;
    }

    protected void updateOrderCheckData(List<DynamicObject> checkDynamicList) {
        List poBillNoList = DynamicObjectUtil.getProVal2List((DynamicObject[])checkDynamicList.toArray(new DynamicObject[0]), (String)"materialentry", (String)"pobillno");
        HashMap param = new HashMap(1);
        HashMap<String, List> billNoMap = new HashMap<String, List>();
        billNoMap.put("in", poBillNoList);
        param.put("billno", billNoMap);
        OrderCheckUtil.updateOrderCheckentry((String)"pur_ordercheck", param);
        OrderCheckUtil.updateOrderCheckDataByPoBillNo((List)poBillNoList, (String)"audit");
    }

    private boolean isValideRow(List<DynamicObject> cols) {
        Object poentryid;
        IFormView view = this.getView();
        int i = 0;
        ArrayList<Integer> diffRows = new ArrayList<Integer>(cols.size());
        ArrayList<Integer> haveCheck = new ArrayList<Integer>(cols.size());
        ArrayList<String> poEntryPks = new ArrayList<String>(cols.size());
        ArrayList<String> inOrRcvEntryIds = new ArrayList<String>(cols.size());
        for (DynamicObject obj : cols) {
            String inOrRcvEntryId;
            poentryid = obj.getString("poentryid3");
            if (!((String)poentryid).isEmpty()) {
                poEntryPks.add((String)poentryid);
            }
            if (!StringUtils.isNotBlank((CharSequence)(inOrRcvEntryId = obj.getString("entryid3"))) || "0".equals(inOrRcvEntryId)) continue;
            inOrRcvEntryIds.add(inOrRcvEntryId);
        }
        HashMap poEntryPkOfStatus = new HashMap(poEntryPks.size());
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)RequestContext.get().getTraceId(), (String)"pur_ordercheck", (String)"id,entryentity.poentryid poentryid,entryentity.status status", (QFilter[])new QFilter[]{new QFilter("entryentity.poentryid", "in", poEntryPks)}, (String)"id");
        poentryid = null;
        try {
            dataSet.forEach(row -> poEntryPkOfStatus.put(row.getString("poentryid"), row.getString("status")));
        }
        catch (Throwable inOrRcvEntryId) {
            poentryid = inOrRcvEntryId;
            throw inOrRcvEntryId;
        }
        finally {
            if (dataSet != null) {
                if (poentryid != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable inOrRcvEntryId) {
                        ((Throwable)poentryid).addSuppressed(inOrRcvEntryId);
                    }
                } else {
                    dataSet.close();
                }
            }
        }
        for (DynamicObject obj : cols) {
            String checkStatus = obj.getString("checkstatus3");
            String poentryid2 = obj.getString("poentryid3");
            String orderCheckStatus = (String)poEntryPkOfStatus.get(poentryid2);
            ++i;
            if (orderCheckStatus != null && "D".equals(orderCheckStatus)) {
                haveCheck.add(i);
            }
            if ("1".equals(checkStatus)) continue;
            diffRows.add(i);
        }
        ArrayList existCheckBill = new ArrayList(1024);
        try (DataSet dataSet2 = QueryServiceHelper.queryDataSet((String)RequestContext.get().getTraceId(), (String)"pur_check", (String)"id,materialentry.srcentryid srcentryid", (QFilter[])new QFilter[]{new QFilter("materialentry.srcentryid", "in", inOrRcvEntryIds)}, (String)"id");){
            dataSet2.forEach(row -> existCheckBill.add(row.getString("srcentryid")));
        }
        StringBuilder checkMsgInfo = new StringBuilder();
        if (diffRows.size() > 0) {
            checkMsgInfo.append(MessageFormat.format(ResManager.loadKDString((String)"\u7b2c{0}\u884c\u6709\u5dee\u5f02\u3002", (String)"PurHandCheckPlugin_16", (String)"scm-pur-formplugin", (Object[])new Object[0]), CommonUtil.objs2str((Object[])diffRows.toArray(new Object[0]))));
            view.showMessage(ResManager.loadKDString((String)"\u6240\u9009\u660e\u7ec6\u6570\u636e\u5b58\u5728\u5dee\u5f02\uff0c\u65e0\u6cd5\u751f\u6210\u5bf9\u8d26\u5355\u3002", (String)"PurHandCheckPlugin_17", (String)"scm-pur-formplugin", (Object[])new Object[0]), checkMsgInfo.toString(), MessageTypes.Default);
            return false;
        }
        if (!haveCheck.isEmpty() || !existCheckBill.isEmpty()) {
            view.showMessage(ResManager.loadKDString((String)"\u6240\u9009\u660e\u7ec6\u6570\u636e\u5df2\u7ecf\u751f\u6210\u5bf9\u8d26\u5355\uff0c\u65e0\u6cd5\u751f\u6210\u5bf9\u8d26\u5355\u3002", (String)"PurHandCheckPlugin_18", (String)"scm-pur-formplugin", (Object[])new Object[0]), checkMsgInfo.toString(), MessageTypes.Default);
            return false;
        }
        return true;
    }

    private void openCheckPage(Object[] objs) {
        if (objs == null) {
            return;
        }
        if (objs.length > 1) {
            String billNoStr = DynamicObjectUtil.getBillPro2Str((Object[])objs, (String)"billno");
            this.getView().showMessage(MessageFormat.format(ResManager.loadKDString((String)"\u751f\u6210\u4e86{0}\u5f20\u5bf9\u8d26\u5355\u3002", (String)"PurHandCheckPlugin_19", (String)"scm-pur-formplugin", (Object[])new Object[0]), objs.length), MessageFormat.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\u4e3a\uff1a{0}\u3002", (String)"PurHandCheckPlugin_20", (String)"scm-pur-formplugin", (Object[])new Object[0]), billNoStr), MessageTypes.Default);
            ListShowParameter parameter = BillFormUtil.assembleShowListFormParam((String)"pur_check", null, (CloseCallBack)new CloseCallBack());
            this.getView().showForm((FormShowParameter)parameter);
        } else {
            BillShowParameter param = BillFormUtil.assembleShowBillFormParam((String)"pur_check", (ShowType)ShowType.MainNewTabPage, (OperationStatus)OperationStatus.EDIT, (long)((Long)((DynamicObject)objs[0]).getPkValue()), null, null);
            this.getView().showForm((FormShowParameter)param);
        }
    }

    private DynamicObject createCheckBillHead(DynamicObject checkSum) {
        Object supplier;
        DynamicObject billObj = ORMUtil.newDynamicObject((String)"pur_check");
        billObj.set("billdate", (Object)new Date());
        if (checkSum.get("settleorg") != null) {
            billObj.set("org", ((DynamicObject)checkSum.get("settleorg")).getPkValue());
        }
        if (checkSum.get("loccurr") != null) {
            billObj.set("loccurr", ((DynamicObject)checkSum.get("loccurr")).getPkValue());
        }
        if ((supplier = checkSum.get("supplier")) instanceof DynamicObject) {
            Long supPk = (Long)((DynamicObject)supplier).getPkValue();
            billObj.set("supplier", (Object)supPk);
            billObj.set("bizpartner", (Object)BizPartnerUtil.getBizPartnerBySupplier((Object)supPk));
        }
        if (checkSum.get("curr") != null) {
            billObj.set("curr", ((DynamicObject)checkSum.get("curr")).getPkValue());
        }
        billObj.set("sumtaxamount", checkSum.get("cfmamt"));
        billObj.set("sumamount_in", checkSum.get("taxamount"));
        billObj.set("sumamount", checkSum.get("outtaxamount"));
        billObj.set("sumdiffamt", checkSum.get("diffamt"));
        billObj.set("datefrom", checkSum.get("datefrom"));
        billObj.set("dateto", checkSum.get("dateto"));
        billObj.set("invtype", (Object)"1");
        billObj.set("invtypeid", (Object)961639799666521088L);
        billObj.set("invdetail", (Object)"1");
        billObj.set("billstatus", (Object)BillStatusEnum.SAVE.getVal());
        billObj.set("creator", (Object)Long.valueOf(RequestContext.get().getUserId()));
        billObj.set("createtime", (Object)new Date());
        billObj.set("modifier", (Object)Long.valueOf(RequestContext.get().getUserId()));
        billObj.set("modifytime", (Object)new Date());
        billObj.set("origin", (Object)"2");
        billObj.set("id", (Object)DBServiceHelper.genLongIds((String)"", (int)1)[0]);
        return billObj;
    }

    private void createCheckBillEntryByEntryKey(DynamicObject billObj, List<DynamicObject> detailCol, String checkGroupKey, String index, String entryKey, List<IPurHandCheckSupport> handCheckPlugins) {
        DynamicObjectCollection entrys = billObj.getDynamicObjectCollection(entryKey);
        IDataEntityProperty propSeq = (IDataEntityProperty)entrys.getDynamicObjectType().getProperties().get((Object)"seq");
        int seqIndex = 1;
        BigDecimal outSumAmount = BigDecimal.ZERO;
        BigDecimal inSumAmount = BigDecimal.ZERO;
        BigDecimal sumDiffamt = BigDecimal.ZERO;
        BigDecimal sumTax = BigDecimal.ZERO;
        Boolean inputamountBool = true;
        BigDecimal deductsumtaxamount = BigDecimal.ZERO;
        Set deductBill = PurCheckMappingUtils.getDeductBill();
        Object taxtype = null;
        for (DynamicObject detail : detailCol) {
            String detailGroupKey = detail.get(GROUPKEY + index).toString();
            if (!detailGroupKey.equals(checkGroupKey)) continue;
            String suffix = "materialentry".equals(entryKey) ? "" : "1";
            DynamicObject entry = this.createPurEntryBySuffix(detail, entrys.getDynamicObjectType(), suffix, handCheckPlugins, billObj);
            outSumAmount = outSumAmount.add(CommonUtil.getBigDecimalPro((Object)entry.get("outtaxamount" + suffix)));
            String srcBillType = entry.getString("srcbilltype" + suffix);
            if (deductBill.contains(srcBillType)) {
                deductsumtaxamount = deductsumtaxamount.add(CommonUtil.getBigDecimalPro((Object)entry.get("intaxamount" + suffix)));
            } else {
                inSumAmount = inSumAmount.add(CommonUtil.getBigDecimalPro((Object)entry.get("intaxamount" + suffix)));
                if (taxtype == null) {
                    taxtype = detail.get("taxtype3");
                }
            }
            sumDiffamt = sumDiffamt.add(CommonUtil.getBigDecimalPro((Object)entry.get("diffamt" + suffix)));
            sumTax = sumTax.add(CommonUtil.getBigDecimalPro((Object)entry.get("tax" + suffix)));
            propSeq.setValueFast((Object)entry, (Object)seqIndex);
            ++seqIndex;
            entrys.add((Object)entry);
            Boolean inputamount = detail.getBoolean("inputamount3");
            if (inputamount != null && inputamount.booleanValue()) continue;
            inputamountBool = false;
        }
        billObj.set("inputamount", (Object)inputamountBool);
        if ("materialentry".equals(entryKey)) {
            billObj.set("taxtype", taxtype);
            billObj.set("deductsumtaxamount", (Object)deductsumtaxamount);
            BigDecimal sumtaxamount = inSumAmount.add(deductsumtaxamount);
            billObj.set("sumtaxamount", (Object)sumtaxamount);
            billObj.set("sumamount", (Object)outSumAmount);
            billObj.set("sumamount_in", (Object)inSumAmount);
            billObj.set("sumdiffamt", (Object)sumDiffamt);
            billObj.set("sumtax", (Object)sumTax);
        }
        billObj.set(entryKey, (Object)entrys);
    }

    private DynamicObject createPurEntryBySuffix(DynamicObject purDetail, DynamicObjectType type, String suffix, List<IPurHandCheckSupport> handCheckPlugin, DynamicObject headBill) {
        DynamicObject entry = ORMUtil.newDynamicObject((DynamicObjectType)type);
        entry.set("jointdatachannelid" + suffix, (Object)this.getJointChannelId());
        entry.set("pobillno" + suffix, purDetail.get("pobillno3"));
        entry.set("inbillno" + suffix, purDetail.get("billno3"));
        if ("".equals(suffix)) {
            entry.set("inbilldate", purDetail.get("billdate3"));
            entry.set("entryexchrate", purDetail.get("exchrate3"));
            entry.set("entryloccurr", purDetail.get("loccurr3"));
        }
        Object materialNameText = purDetail.get("materialname3");
        if (purDetail.get("material3") != null) {
            entry.set("material" + suffix, ((DynamicObject)purDetail.get("material3")).getPkValue());
            if (materialNameText == null || materialNameText.toString().isEmpty()) {
                materialNameText = ((DynamicObject)purDetail.get("material3")).getString("name");
            }
        }
        entry.set("materialnametext" + suffix, materialNameText);
        if (purDetail.get("linetype3") != null) {
            entry.set("linetype" + suffix, ((DynamicObject)purDetail.get("linetype3")).getPkValue());
        }
        entry.set("materialdesc" + suffix, purDetail.get("materialdesc3"));
        if (purDetail.get("unit3") != null) {
            entry.set("unit" + suffix, ((DynamicObject)purDetail.get("unit3")).getPkValue());
        }
        if (purDetail.get("invorg3") != null) {
            entry.set("entryrcvorg" + suffix, ((DynamicObject)purDetail.get("invorg3")).getPkValue());
        }
        if (purDetail.get("entrypurorg3") != null) {
            entry.set("entrypurorg" + suffix, ((DynamicObject)purDetail.get("entrypurorg3")).getPkValue());
        }
        if (purDetail.get("settleorg3") != null) {
            entry.set("entrysettleorg" + suffix, ((DynamicObject)purDetail.get("settleorg3")).getPkValue());
        }
        if (purDetail.get("goods3") != null) {
            entry.set("goods" + suffix, ((DynamicObject)purDetail.get("goods3")).getPkValue());
        }
        if (purDetail.get("businesstype_in3") != null && "".equals(suffix)) {
            entry.set("businesstype_in" + suffix, ((DynamicObject)purDetail.get("businesstype_in3")).getPkValue());
        }
        BigDecimal cfmQty = CommonUtil.getBigDecimalPro((Object)purDetail.get("cfmqty3"));
        BigDecimal cfmAmt = CommonUtil.getBigDecimalPro((Object)purDetail.get("cfmamt3"));
        BigDecimal tax = CommonUtil.getBigDecimalPro((Object)purDetail.get("tax3"));
        BigDecimal amount = cfmAmt.subtract(tax);
        entry.set("price" + suffix, purDetail.get("price3"));
        entry.set("taxprice" + suffix, purDetail.get("taxprice3"));
        DynamicObject material = purDetail.getDynamicObject("material3");
        DynamicObject baseunit = null;
        if (material != null) {
            baseunit = material.getDynamicObject("baseunit");
        }
        BigDecimal basicQty = CommonUtil.getDesQtyConv((DynamicObject)material, (DynamicObject)purDetail.getDynamicObject("unit3"), (BigDecimal)purDetail.getBigDecimal("qty3"), (DynamicObject)baseunit);
        entry.set("basicqty" + suffix, (Object)basicQty);
        entry.set("basicunit" + suffix, (Object)baseunit);
        entry.set("qty" + suffix, (Object)cfmQty);
        entry.set("tax" + suffix, (Object)tax);
        entry.set("amount" + suffix, (Object)amount);
        entry.set("taxamount" + suffix, (Object)cfmAmt);
        entry.set("diffqty" + suffix, purDetail.get("diffqty3"));
        entry.set("diffamt" + suffix, purDetail.get("diffamt3"));
        entry.set("inqty" + suffix, purDetail.get("qty3"));
        entry.set("intaxamount" + suffix, purDetail.get("taxamount3"));
        entry.set("outtaxamount" + suffix, purDetail.get("outtaxamount3"));
        entry.set("outqty" + suffix, purDetail.get("outqty3"));
        String outbillno = (String)purDetail.get("outbillno3");
        if (null != outbillno) {
            entry.set("outbillno" + suffix, (Object)outbillno.substring(0, Math.min(outbillno.length(), 255)));
        }
        entry.set("ispresent" + suffix, purDetail.get("ispresent3"));
        entry.set("discounttype" + suffix, purDetail.get("discounttype3"));
        entry.set("dctrate" + suffix, purDetail.get("dctrate3"));
        entry.set("dctamount" + suffix, purDetail.get("dctamount3"));
        entry.set("taxrate" + suffix, purDetail.get("taxrate3"));
        entry.set("taxrateid" + suffix, purDetail.get("taxrateid3"));
        entry.set("entrystatus" + suffix, (Object)"A");
        if (ApiConfigUtil.hasEASConfig() && "".equals(suffix)) {
            entry.set("actbillno", purDetail.get("actbillno3"));
        }
        entry.set("pobillid" + suffix, purDetail.get("pobillid3"));
        entry.set("poentryid" + suffix, purDetail.get("poentryid3"));
        String srcBillType = String.valueOf(purDetail.get("srcbilltype3"));
        entry.set("srcbilltype" + suffix, (Object)srcBillType);
        entry.set("srcbillid" + suffix, purDetail.get("billid3"));
        entry.set("srcentryid" + suffix, purDetail.get("entryid3"));
        entry.set("note" + suffix, purDetail.get("remark3"));
        if ("materialentry".equals(type.getName())) {
            entry.set("actchecktaxprice", entry.get("taxprice" + suffix));
            entry.set("actchecktaxamount", entry.get("taxamount" + suffix));
            entry.set("actcheckprice", entry.get("price" + suffix));
            entry.set("actcheckamount", (Object)amount);
            entry.set("unmatchamt", purDetail.get("unmatchtaxamount3"));
            entry.set("unmatchqty" + suffix, purDetail.get("unmatchqty3"));
            entry.set("sourcebill" + suffix, purDetail.get("sourcebill3"));
        }
        if ("".equals(suffix)) {
            ExchrateUtil.setLocalPrice((DynamicObject)entry, (String)suffix, (String)suffix, (boolean)false);
            if (handCheckPlugin != null && !handCheckPlugin.isEmpty()) {
                handCheckPlugin.forEach(handCheck -> {
                    handCheck.putCheckEntryFields(entry, purDetail);
                    handCheck.putCheckHeadFields(headBill, purDetail);
                });
            }
        }
        return entry;
    }

    private String[] getMaterialGroups() {
        return new String[]{"srcentryid"};
    }

    private String[] getCheckGroups() {
        return ((HandCheckImpl)this.getCheck(false)).getCheckGroups();
    }

    private void clearStatus(String entryKey) {
        IDataModel model;
        int rowCount;
        EntryGrid grid = (EntryGrid)this.getControl(entryKey);
        grid.clearEntryState();
        if (CHECKSUM_ENTRY_KEY.equals(entryKey) && (rowCount = (model = this.getModel()).getEntryRowCount(entryKey)) > 0) {
            grid.selectRows(0);
        }
    }

    private void clearData() {
        IDataModel model = this.getModel();
        model.deleteEntryData(ORG_ENTRY_KEY);
        model.deleteEntryData(PUR_ENTRY_KEY);
        model.deleteEntryData(CHECKSUM_ENTRY_KEY);
        model.setValue("becheckedbill", (Object)0);
        model.setValue("sumamount", (Object)0.0);
        model.setValue("exceptionbill", (Object)0);
        model.setValue("sumdiffamount", (Object)0.0);
    }

    public void entryRowClick(RowClickEvent evt) {
        IPageCache pageCache = this.getPageCache();
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        EntryGrid grid = (EntryGrid)evt.getSource();
        String entryKey = grid.getKey();
        if (CHECKSUM_ENTRY_KEY.equals(entryKey)) {
            List<DynamicObject> selectedRows = this.getSelectObject(CHECKSUM_ENTRY_KEY);
            model.deleteEntryData(PUR_ENTRY_KEY);
            this.addDetailData(model, pageCache, selectedRows, PUR_ENTRY_KEY, PUR_ENTRY_SUFFIX, false);
            this.buildLeftOrgData(PUR_ENTRY_KEY, PUR_ENTRY_SUFFIX, "invorg");
            this.setSelect(PUR_ENTRY_KEY, PUR_ENTRY_SUFFIX);
        } else if (ORG_ENTRY_KEY.equals(entryKey)) {
            int[] selectedIndexs = grid.getEntryState().getSelectedRows();
            if (!isSelected || selectedIndexs[0] != previousSelect) {
                isSelected = true;
                previousSelect = selectedIndexs[0];
                List<DynamicObject> selectedRows = this.getSelectObject(CHECKSUM_ENTRY_KEY);
                this.addDetailData(model, pageCache, selectedRows, PUR_ENTRY_KEY, PUR_ENTRY_SUFFIX, true);
                this.setSelect(PUR_ENTRY_KEY, PUR_ENTRY_SUFFIX);
            } else if (selectedIndexs[0] == previousSelect) {
                grid.selectRows(selectedIndexs[0]);
                List<DynamicObject> selectedRows = this.getSelectObject(CHECKSUM_ENTRY_KEY);
                this.addDetailData(model, pageCache, selectedRows, PUR_ENTRY_KEY, PUR_ENTRY_SUFFIX, false);
                this.setSelect(PUR_ENTRY_KEY, PUR_ENTRY_SUFFIX);
                this.getView().updateView(ORG_ENTRY_KEY);
                isSelected = false;
            } else {
                isSelected = false;
            }
        }
    }

    private List<DynamicObject> getSelectObject(String entryKey) {
        EntryGrid grid = (EntryGrid)this.getControl(entryKey);
        IDataModel model = this.getModel();
        int[] selectedIndexs = grid.getEntryState().getSelectedRows();
        ArrayList<DynamicObject> selectedRows = new ArrayList<DynamicObject>(selectedIndexs.length);
        for (int i = 0; i < selectedIndexs.length; ++i) {
            selectedRows.add(model.getEntryRowEntity(entryKey, selectedIndexs[i]));
        }
        return selectedRows;
    }

    public void addDetailData(AbstractFormDataModel model, IPageCache pageCache, List<DynamicObject> selectedRows, String entryKey, String index, boolean isFilter) {
        int rowCount = 0;
        LowTimer timer = new LowTimer();
        List propertiesentity = DynamicObjectUtil.getEntryentityProperties((IDataEntityType)model.getEntryEntity(entryKey).getDynamicObjectType());
        HashMap<String, String> propertiesMap = new HashMap<String, String>();
        for (String property : propertiesentity) {
            if ("id".equals(property) || "seq".equals(property)) continue;
            propertiesMap.put(property, property);
        }
        TableValueSetter vs = new TableValueSetter(new String[0]);
        DynamicObject currLeftData = model.getEntryCurrentRow(ORG_ENTRY_KEY);
        DynamicObject leftOrg = null;
        if (isFilter && null != currLeftData) {
            leftOrg = currLeftData.getDynamicObject("org");
        }
        ArrayList alldetail = new ArrayList(8);
        for (DynamicObject selectRow : selectedRows) {
            String groupKey = selectRow.getString(GROUPKEY);
            List detailCache = HandCheckUtil.getDetailCache((IPageCache)pageCache, (String)groupKey);
            alldetail.addAll(detailCache);
        }
        for (Map detail : alldetail) {
            if (isFilter && null != leftOrg) {
                Object invOrgObj = detail.get("invorg3");
                if (!leftOrg.getPkValue().toString().equals(invOrgObj.toString())) continue;
            }
            Set entrySet = detail.entrySet();
            for (Map.Entry entry : entrySet) {
                String newKey = ((String)entry.getKey()).replaceFirst(PUR_ENTRY_SUFFIX, PUR_ENTRY_SUFFIX);
                if (null == propertiesMap.get(newKey)) continue;
                vs.set(newKey, entry.getValue(), rowCount);
            }
            ++rowCount;
        }
        Integer maxCheckRow = HandCheckUtil.getMaxCheckRow((String)"scp_check", (String)"maxcheckdata");
        if (rowCount > maxCheckRow) {
            this.getView().showTipNotification(MessageFormat.format(ResManager.loadKDString((String)"\u5bf9\u8d26\u7269\u6599\u660e\u7ec6\u8d85\u8fc7{0}\u884c\uff0c\u8bf7\u7f29\u5c0f\u8fc7\u6ee4\u8303\u56f4\u91cd\u65b0\u5bf9\u8d26\u3002", (String)"PurHandCheckPlugin_29", (String)"scm-pur-formplugin", (Object[])new Object[0]), maxCheckRow));
            return;
        }
        timer.reset();
        model.deleteEntryData(entryKey);
        model.beginInit();
        model.batchCreateNewEntryRow(entryKey, vs);
        model.endInit();
        timer.reset();
        this.getView().updateView(entryKey);
        this.setStatusColumnFontColor(PUR_ENTRY_KEY, PUR_ENTRY_SUFFIX);
    }

    public void setSelect(String entryKey, String index) {
        LowTimer timer = new LowTimer();
        IDataModel model = this.getModel();
        DynamicObjectCollection col = model.getEntryEntity(entryKey);
        if (null == col) {
            return;
        }
        EntryGrid grid = (EntryGrid)this.getView().getControl(entryKey);
        ArrayList<Integer> selectedList = new ArrayList<Integer>(col.size());
        for (int i = 0; i < col.size(); ++i) {
            selectedList.add(i);
        }
        if (selectedList.size() > 0) {
            int[] selected = CommonUtil.list2Array(selectedList);
            grid.selectRows(selected, 0);
        }
        log.info("\u8bbe\u7f6e\u9009\u4e2d\u884c\u65f6\u95f4\uff1a" + timer.msValue());
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if ("recheck".equals(messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult().equals((Object)MessageBoxResult.Yes)) {
            this.openCheckCenter();
            this.getView().close();
        }
    }

    protected Icheck getCheck(boolean addExtendPlugin) {
        if (addExtendPlugin) {
            List<IPurHandCheckSupport> handCheckPlugin = this.getExtendPlugin();
            Set<String> entryFields = this.getAllExtendFields(handCheckPlugin);
            Map<String, Set<String>> entryFieldsMap = this.getExtendFieldsMap(handCheckPlugin);
            Map<String, Set<String>> extendGroups = this.getExtendCheckGroupFields(handCheckPlugin);
            Set<String> removeGroups = this.removeCheckGroupFields(handCheckPlugin);
            this.check = new HandCheckImpl(entryFields, entryFieldsMap, extendGroups, removeGroups);
        } else if (this.check == null) {
            this.check = new HandCheckImpl();
        }
        return this.check;
    }

    protected Map<String, Set<String>> getExtendCheckGroupFields(List<IPurHandCheckSupport> handCheckPlugin) {
        HashMap<String, Set<String>> extendFieldsMap = new HashMap<String, Set<String>>(10);
        if (handCheckPlugin != null && !handCheckPlugin.isEmpty()) {
            handCheckPlugin.forEach(p -> {
                Map tempFieldsMap = p.getExtendCheckGroups();
                if (tempFieldsMap != null && !tempFieldsMap.isEmpty()) {
                    for (Map.Entry entry : tempFieldsMap.entrySet()) {
                        String entityName = (String)entry.getKey();
                        List fieldsList = (List)entry.getValue();
                        HashSet fieldsSet = (HashSet)extendFieldsMap.get(entityName);
                        if (null == fieldsSet) {
                            fieldsSet = new HashSet(16);
                        }
                        if (fieldsList != null && !fieldsList.isEmpty()) {
                            fieldsSet.addAll(fieldsList);
                        }
                        extendFieldsMap.put(entityName, fieldsSet);
                    }
                }
            });
        }
        return extendFieldsMap;
    }

    protected Set<String> removeCheckGroupFields(List<IPurHandCheckSupport> handCheckPlugin) {
        HashSet<String> extendFields = new HashSet<String>(10);
        if (handCheckPlugin != null && !handCheckPlugin.isEmpty()) {
            handCheckPlugin.forEach(p -> {
                List tempFields = p.removeCheckGroups();
                if (tempFields != null && !tempFields.isEmpty()) {
                    extendFields.addAll(tempFields);
                }
            });
        }
        return extendFields;
    }

    protected Set<String> getAllExtendFields(List<IPurHandCheckSupport> handCheckPlugin) {
        HashSet<String> extendFields = new HashSet<String>(10);
        if (handCheckPlugin != null && !handCheckPlugin.isEmpty()) {
            handCheckPlugin.forEach(p -> {
                List tempFields = p.getExtendFields();
                if (tempFields != null && !tempFields.isEmpty()) {
                    extendFields.addAll(tempFields);
                }
            });
        }
        return extendFields;
    }

    protected Map<String, Set<String>> getExtendFieldsMap(List<IPurHandCheckSupport> handCheckPlugin) {
        HashMap<String, Set<String>> extendFieldsMap = new HashMap<String, Set<String>>(10);
        if (handCheckPlugin != null && !handCheckPlugin.isEmpty()) {
            handCheckPlugin.forEach(p -> {
                Map tempFieldsMap = p.getEntityExtendFieldsMap();
                if (tempFieldsMap != null && !tempFieldsMap.isEmpty()) {
                    for (Map.Entry entry : tempFieldsMap.entrySet()) {
                        String entityName = (String)entry.getKey();
                        List fieldsList = (List)entry.getValue();
                        HashSet fieldsSet = (HashSet)extendFieldsMap.get(entityName);
                        if (null == fieldsSet) {
                            fieldsSet = new HashSet(16);
                        }
                        if (fieldsList != null && !fieldsList.isEmpty()) {
                            fieldsSet.addAll(fieldsList);
                        }
                        extendFieldsMap.put(entityName, fieldsSet);
                    }
                }
            });
        }
        return extendFieldsMap;
    }

    private List<IPurHandCheckSupport> getExtendPlugin() {
        PurHandCheckSupportImpl defaultSupport = new PurHandCheckSupportImpl();
        PluginProxy pluginProxy = PluginProxy.create((Object)defaultSupport, IPurHandCheckSupport.class, (String)"SCM_PUR_HANDCHECK_SUPPORT", null);
        return pluginProxy.getPlugins();
    }

    public void hyperLinkClick(HyperLinkClickEvent heperLinkEvent) {
        String gridKey;
        IPageCache pageCache = this.getPageCache();
        EntryGrid grid = (EntryGrid)heperLinkEvent.getSource();
        String property = heperLinkEvent.getFieldName();
        Object val = grid.getModel().getValue(property);
        switch (gridKey = grid.getKey()) {
            case "materialentryentity3": {
                boolean isFindBill;
                if (val == null) break;
                if (property.startsWith("pobillno")) {
                    this.assembleBill("pur_order", val, true);
                    break;
                }
                if (property.startsWith("billno3") || property.equals("actbillno3")) {
                    String srcBillType = String.valueOf(grid.getModel().getValue("srcbilltype3"));
                    this.assembleBill(srcBillType, val, true);
                    break;
                }
                if (!property.startsWith("outbillno3") || (isFindBill = this.assembleBill("pur_saloutstock", val, false))) break;
                this.assembleBill("pur_salreturn", val, true);
                break;
            }
            case "sumentryentity": {
                if (!"deducttaxamount".equals(property)) break;
                Set deductBill = PurCheckMappingUtils.getDeductBill();
                HashMap<String, String> customParams = new HashMap<String, String>(8);
                String groupKey = String.valueOf(grid.getModel().getValue("groupkey3"));
                List detailCache = HandCheckUtil.getDetailCache((IPageCache)pageCache, (String)groupKey);
                List deductDetails = detailCache.stream().filter(detail -> deductBill.contains(detail.get("srcbilltype3"))).collect(Collectors.toList());
                customParams.put("pur_handcheck", JSON.toJSONString(deductDetails));
                this.getView().showForm(BillFormUtil.assembleShowDynamicFormParam((String)"pur_invoice_deductdetail", customParams, null, (ShowType)ShowType.Modal));
                break;
            }
        }
    }

    private boolean assembleBill(String billKey, Object billNo, boolean isShowMsg) {
        DynamicObjectCollection cols;
        boolean isFindBill = true;
        HashMap params = new HashMap(1);
        HashMap<String, Object[]> billNoMap = new HashMap<String, Object[]>(1);
        Object[] billNoObjs = null;
        if (null != billNo) {
            billNoObjs = CommonUtil.str2objs((String)billNo.toString(), (String)",");
            billNoMap.put("in", billNoObjs);
            params.put("billno", billNoMap);
        }
        if ((cols = ORMUtil.queryDynamicObjectCollection((String)billKey, (String)"id,billno", params)) == null || cols.size() == 0) {
            if (isShowMsg) {
                this.getView().showMessage(MessageFormat.format(ResManager.loadKDString((String)"\u5355\u636e{0}\u4e0d\u5b58\u5728\u3002", (String)"PurHandCheckPlugin_21", (String)"scm-pur-formplugin", (Object[])new Object[0]), billNo));
            }
            isFindBill = false;
        } else {
            List idList = DynamicObjectUtil.col2ListId((DynamicObjectCollection)cols, (String)"id");
            if (idList.size() == 1) {
                BillShowParameter showParam = BillFormUtil.assembleShowBillFormParam((String)billKey, (ShowType)ShowType.MainNewTabPage, (OperationStatus)OperationStatus.VIEW, (long)((Long)idList.get(0)), null, null);
                this.getView().showForm((FormShowParameter)showParam);
            } else {
                HashMap<String, Object> customeParam = new HashMap<String, Object>(1);
                customeParam.put("billno", billNo);
                ListShowParameter listParam = BillFormUtil.assembleShowListFormParam((String)billKey, customeParam, null);
                this.getView().showForm((FormShowParameter)listParam);
            }
        }
        return isFindBill;
    }

    private boolean isMatch() {
        Map params = this.getView().getFormShowParameter().getCustomParams();
        Object unMatch = params.get("unMatch");
        return null == unMatch;
    }

    public void createNewData(BizDataEventArgs e) {
        super.createNewData(e);
        this.getModel().putContextVariable("MODEL_BOSENTRYSERVERFILTERSORT", (Object)true);
    }

    static /* synthetic */ boolean access$002(boolean x0) {
        isSelected = x0;
        return isSelected;
    }
}

