/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.scp.formplugin;

import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.bill.BillModel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.scm.common.ORMUtil;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.enums.ConfirmStatusEnum;
import kd.scm.common.util.BillFormUtil;
import kd.scm.common.util.CommonUtil;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.util.calmodel.CalModelFactory;
import kd.scm.common.util.calmodel.ICalModel;
import kd.scm.scp.common.util.ScpCheckDiscounttype;
import kd.scm.scp.formplugin.ScpCoreBillEditPlugin;

public class ScpCheckEditPlugin
extends ScpCoreBillEditPlugin
implements HyperLinkClickListener {
    private static final String SPLITCHECK = "splitcheck";
    private static final String ACTION_SPLITCHECK = "action_splitcheck";
    private static final String SCP_INVOICEINFO = "scp_invoiceinfo";
    private static final String CFMSTATUS = "cfmstatus";
    private static final String BAR_SPLIT = "bar_split";
    private static final String MATERIAL_ENTRY = "entryentity1";
    private ICalModel iCalDynamic = new CalModelFactory().createCal();
    public static final String TARGETKEY = "_submaintab_";

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setBarStatus();
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid headGrid = (EntryGrid)this.getView().getControl(MATERIAL_ENTRY);
        headGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        IDataModel model = this.getModel();
        ChangeData[] changeSets = e.getChangeSet();
        model.beginInit();
        block13: for (ChangeData changeSet : changeSets) {
            int rowIndex = changeSet.getRowIndex();
            Object newValue = changeSet.getNewValue();
            Object oldValue = changeSet.getOldValue();
            switch (propertyName) {
                case "qty1": {
                    this.iCalDynamic.proChanged(model, MATERIAL_ENTRY, "qty1", "1", rowIndex);
                    continue block13;
                }
                case "actchecktaxprice": 
                case "actcheckprice": {
                    boolean checkIsCompliance = ScpCheckDiscounttype.checkIsCompliance((IFormView)this.getView(), (String)propertyName, (Object)newValue, (Object)oldValue, (String)"1", (int)rowIndex);
                    if (!checkIsCompliance) continue block13;
                    this.iCalDynamic.proChanged(model, MATERIAL_ENTRY, propertyName, "1", rowIndex);
                    continue block13;
                }
                case "actchecktaxamount": {
                    this.iCalDynamic.proChanged(model, MATERIAL_ENTRY, "actchecktaxamount", "1", rowIndex);
                    continue block13;
                }
                case "actcheckamount": {
                    this.iCalDynamic.proChanged(model, MATERIAL_ENTRY, "actcheckamount", "1", rowIndex);
                    continue block13;
                }
            }
        }
        model.endInit();
        this.getView().updateView(MATERIAL_ENTRY);
        DynamicObjectCollection entryCol = model.getDataEntity(true).getDynamicObjectCollection(MATERIAL_ENTRY);
        BigDecimal sumAmount = BigDecimal.ZERO;
        for (DynamicObject obj : entryCol) {
            sumAmount = sumAmount.add(obj.getBigDecimal("actchecktaxamount"));
        }
        model.setValue("sumtaxamount", (Object)sumAmount);
    }

    @Override
    public void hyperLinkClick(HyperLinkClickEvent heperLinkEvent) {
        EntryGrid grid = (EntryGrid)heperLinkEvent.getSource();
        String property = heperLinkEvent.getFieldName();
        String gridKey = grid.getKey();
        String val = null;
        String entityKey = null;
        if (gridKey.equals(MATERIAL_ENTRY)) {
            boolean isFindBill;
            val = (String)grid.getModel().getValue(property);
            if ("inbillno1".equals(property)) {
                Object srcBillTypeObj = grid.getModel().getValue("srcbilltype1");
                if (null != srcBillTypeObj && !"scp_receipt".equals(srcBillTypeObj.toString().replace("pur", "scp"))) {
                    entityKey = srcBillTypeObj.toString().replace("pur", "scp");
                } else if (QueryServiceHelper.exists((String)"scp_receipt", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)val).and(new QFilter("isreturn", "=", (Object)"0"))})) {
                    entityKey = "scp_receipt";
                } else if (QueryServiceHelper.exists((String)"scp_return_receipt", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)val).and(new QFilter("isreturn", "=", (Object)"1"))})) {
                    entityKey = "scp_return_receipt";
                } else if (QueryServiceHelper.exists((String)"scp_instock", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)val)})) {
                    entityKey = "scp_instock";
                } else if (QueryServiceHelper.exists((String)"scp_return", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)val)})) {
                    entityKey = "scp_return";
                }
            } else if ("pobillno1".equals(property)) {
                entityKey = "scp_order";
            }
            if ("outbillno1".equals(property) && !(isFindBill = this.assembleBill("scp_saloutstock", val, false))) {
                this.assembleBill("scp_salreturn", val, true);
            }
            this.showBillForm(val, entityKey);
        }
    }

    private boolean assembleBill(String billKey, Object billNo, boolean isShowMsg) {
        DynamicObjectCollection cols;
        boolean isFindBill = true;
        HashMap params = new HashMap(1);
        HashMap<String, Object[]> billNoMap = new HashMap<String, Object[]>(1);
        Object[] billNoObjs = null;
        if (null != billNo) {
            billNoObjs = CommonUtil.str2objs((String)billNo.toString(), (String)",");
            billNoMap.put("in", billNoObjs);
            params.put("billno", billNoMap);
        }
        if ((cols = ORMUtil.queryDynamicObjectCollection((String)billKey, (String)"id,billno", params)) == null || cols.size() == 0) {
            if (isShowMsg) {
                this.getView().showMessage(MessageFormat.format(ResManager.loadKDString((String)"\u5355\u636e{0}\u4e0d\u5b58\u5728\u3002", (String)"ScpCheckEditPlugin_0", (String)"scm-scp-formplugin", (Object[])new Object[0]), billNo));
            }
            isFindBill = false;
        } else {
            List idList = DynamicObjectUtil.col2ListId((DynamicObjectCollection)cols, (String)"id");
            if (idList.size() == 1) {
                BillShowParameter showParam = BillFormUtil.assembleShowBillFormParam((String)billKey, (ShowType)ShowType.MainNewTabPage, (OperationStatus)OperationStatus.VIEW, (long)((Long)idList.get(0)), null, null);
                this.getView().showForm((FormShowParameter)showParam);
            } else {
                HashMap<String, Object> customeParam = new HashMap<String, Object>(1);
                customeParam.put("billno", billNo);
                ListShowParameter listParam = BillFormUtil.assembleShowListFormParam((String)billKey, customeParam, null);
                this.getView().showForm((FormShowParameter)listParam);
            }
        }
        return isFindBill;
    }

    public void showBillForm(Object val, String entityKey) {
        if (val == null || entityKey == null || entityKey.isEmpty()) {
            return;
        }
        DynamicObject dynaObject = QueryServiceHelper.queryOne((String)entityKey, (String)"id,billno", (QFilter[])new QFilter[]{new QFilter("billno", "=", val)});
        if (dynaObject != null) {
            this.getView().showForm((FormShowParameter)BillFormUtil.assembleShowBillFormParam((String)entityKey, (ShowType)ShowType.MainNewTabPage, (OperationStatus)OperationStatus.VIEW, (long)((Long)dynaObject.get("id")), null, null));
        }
    }

    public void itemClick(ItemClickEvent evt) {
        if ("bar_revoke".equals(evt.getItemKey())) {
            String billstatus = this.getModel().getDataEntity(true).getString("billstatus");
            if (BillStatusEnum.AUDIT.getVal().equals(billstatus)) {
                this.getView().invokeOperation("unaudit");
            } else {
                this.getView().invokeOperation("unsubmit");
            }
        }
    }

    private Map<String, Object> buildParam() {
        IDataModel model = this.getModel();
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("billid", this.getModel().getDataEntity().getPkValue());
        param.put("billno", model.getValue("billno"));
        if (model.getValue("curr") != null) {
            param.put("curr", ((DynamicObject)model.getValue("curr")).getPkValue());
        }
        if (model.getValue("chkscheme") != null) {
            param.put("chkscheme", ((DynamicObject)model.getValue("chkscheme")).getPkValue());
        }
        BigDecimal unInvoicedTaxAmount = BigDecimal.ZERO;
        BigDecimal taxAmount = BigDecimal.ZERO;
        DynamicObjectCollection entrys = model.getEntryEntity(MATERIAL_ENTRY);
        for (DynamicObject entry : entrys) {
            String inventryId = entry.getString("invoiceid1");
            if (!inventryId.isEmpty() && !inventryId.trim().isEmpty()) continue;
            taxAmount = CommonUtil.getBigDecimalPro((Object)entry.get("taxamount1"));
            unInvoicedTaxAmount = unInvoicedTaxAmount.add(taxAmount);
        }
        param.put("unInvoicedTaxAmount", unInvoicedTaxAmount);
        param.put("sumtaxamount", model.getValue("sumtaxamount"));
        return param;
    }

    public void showListForm(String billFormId, String filterParameter, String formTypeId) {
        if (StringUtils.isEmpty((String)billFormId)) {
            return;
        }
        ListShowParameter parameter = new ListShowParameter();
        parameter.setBillFormId(billFormId);
        parameter.setFormId(formTypeId);
        parameter.getOpenStyle().setTargetKey(TARGETKEY);
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.setCustomParam("isOpenNewTab", (Object)Boolean.TRUE);
        if (null != filterParameter) {
            ListFilterParameter listFilterParameter = new ListFilterParameter();
            listFilterParameter.setQFilter(filterParameter);
            parameter.setListFilterParameter(listFilterParameter);
        }
        this.getView().showForm((FormShowParameter)parameter);
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String operateKey = ((AbstractOperate)e.getSource()).getOperateKey();
        if (null != e.getOperationResult() && e.getOperationResult().isSuccess()) {
            switch (operateKey) {
                case "confirm": 
                case "agreecheck": {
                    this.setBarStatus();
                    break;
                }
                case "splitcheck": {
                    Object cfmStatus = this.getModel().getValue(CFMSTATUS);
                    if (null == cfmStatus || !ConfirmStatusEnum.CONFIRM.getVal().equals(cfmStatus)) {
                        this.getView().showMessage(ResManager.loadKDString((String)"\u5355\u636e\u672a\u786e\u8ba4\u65e0\u6cd5\u6267\u884c\u3002", (String)"ScpCheckEditPlugin_1", (String)"scm-scp-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    Map<String, Object> param = this.buildParam();
                    BigDecimal unInvoicedAmount = CommonUtil.getBigDecimalPro((Object)param.get("unInvoicedTaxAmount"));
                    BigDecimal sumtaxamount = CommonUtil.getBigDecimalPro((Object)param.get("sumtaxamount"));
                    if (sumtaxamount.compareTo(BigDecimal.ZERO) == 0) {
                        this.getView().showMessage(ResManager.loadKDString((String)"\u5bf9\u8d26\u5355\u786e\u8ba4\u5408\u8ba1\u91d1\u989d\u4e3a0\uff0c\u65e0\u6cd5\u5f00\u7968\u3002", (String)"ScpCheckEditPlugin_2", (String)"scm-scp-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    if (unInvoicedAmount.compareTo(BigDecimal.ZERO) == 0) {
                        this.getView().showMessage(ResManager.loadKDString((String)"\u5df2\u5168\u90e8\u751f\u6210\u5f00\u7968\u5355\uff0c\u65e0\u6cd5\u4e0b\u63a8\u3002", (String)"ScpCheckEditPlugin_3", (String)"scm-scp-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    this.getView().showForm(BillFormUtil.assembleShowDynamicFormParam((String)SCP_INVOICEINFO, param, (CloseCallBack)new CloseCallBack((IFormPlugin)this, ACTION_SPLITCHECK), (ShowType)ShowType.MainNewTabPage));
                    break;
                }
                case "submit": {
                    BillModel billModel = (BillModel)this.getModel();
                    billModel.load(billModel.getPKValue());
                    this.getView().updateView(MATERIAL_ENTRY);
                    break;
                }
            }
        }
    }

    private void setBarStatus() {
        Object cfmStatus = this.getModel().getValue(CFMSTATUS);
        if (cfmStatus != null && ConfirmStatusEnum.CONFIRM.getVal().equalsIgnoreCase(cfmStatus.toString())) {
            this.getView().setVisible(Boolean.TRUE, new String[]{BAR_SPLIT});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{BAR_SPLIT});
        }
    }
}

