/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.scp.formplugin;

import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.FlexEntityType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.LoadDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.form.ClientViewProxy;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.scm.common.ORMUtil;
import kd.scm.common.util.BillFormUtil;
import kd.scm.common.util.BizPartnerUtil;
import kd.scm.common.util.MaterialUtil;
import kd.scm.common.util.SupplierChangeUtil;
import kd.scm.common.util.caldynamic.CalDynamicFactory;
import kd.scm.common.util.caldynamic.ICalDynamic;

public class ScpCoreBillEditPlugin
extends AbstractBillPlugIn
implements HyperLinkClickListener,
BeforeF7SelectListener {
    private static final Set<String> NO_CHANGE_FEILDS = Stream.of("suplot", "note").collect(Collectors.toCollection(HashSet::new));
    private ICalDynamic iCalDynamic = new CalDynamicFactory().createCal();
    private String entryKey = "materialentry";

    public String getEntryKey() {
        return this.entryKey;
    }

    public void setEntryKey(String entryKey) {
        this.entryKey = entryKey;
    }

    public void loadData(LoadDataEventArgs e) {
        super.loadData(e);
    }

    public void afterCreateNewData(EventObject e) {
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        BillFormUtil.activeTab((IFormView)this.getView(), (String)"status_tabap", (String)(this.getStatusTabVal() + "tab"));
    }

    protected String getStatusTabVal() {
        return "";
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        String operateKey;
        super.beforeDoOperation(e);
        String value = RequestContext.get().getUserId();
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        switch (operateKey = ((AbstractOperate)e.getSource()).getOperateKey()) {
            case "new": {
                model.setValue("creator", (Object)value);
                break;
            }
            case "modify": {
                model.setValue("modifier", (Object)value);
                model.setValue("modifytime", (Object)TimeServiceHelper.now());
                break;
            }
            case "delete": {
                model.setDataChanged(false);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if (null != afterDoOperationEventArgs.getOperationResult() && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            String entityId = this.getView().getEntityId();
            switch (operateKey) {
                case "confirm": 
                case "reject": 
                case "agreeorder": 
                case "unconfirm": {
                    BillFormUtil.activeTab((IFormView)this.getView(), (String)"status_tabap", (String)(this.getStatusTabVal() + "tab"));
                    break;
                }
                case "logquery": {
                    Map tBills;
                    if (entityId.equals("scp_invoice")) {
                        return;
                    }
                    IDataModel dataModel = this.getModel();
                    HashMap<String, Object> customFilter = new HashMap<String, Object>();
                    Object pkvalue = dataModel.getDataEntity().getPkValue();
                    String entrykey = dataModel.getDataEntity().getDataEntityType().getName();
                    customFilter.put("pkidcoll", new Object[]{pkvalue});
                    customFilter.put("ENTRY_KEY", entrykey);
                    FormShowParameter param = null;
                    customFilter.put("isFromSupplier", Boolean.TRUE);
                    if ("scp_order".equals(entrykey) && (tBills = BFTrackerServiceHelper.findTargetBills((String)"scp_order", (Long[])new Long[]{(Long)pkvalue})) != null && tBills.size() > 0) {
                        Set outStockids = (Set)tBills.get("scp_saloutstock");
                        customFilter.put("orderfindstockid", outStockids);
                        customFilter.put("orderfindstockentrykey", "scp_saloutstock");
                    }
                    param = BillFormUtil.assembleShowDynamicFormParam((String)"scp_logquery", customFilter, null, (ShowType)ShowType.MainNewTabPage);
                    this.getView().showForm(param);
                    break;
                }
                case "inputdellog": {
                    if (entityId.equals("scp_invoice")) {
                        return;
                    }
                    IDataModel dataModelInput = this.getModel();
                    HashMap<String, Object> customFilterInput = new HashMap<String, Object>();
                    customFilterInput.put("pkidcoll", new Object[]{dataModelInput.getDataEntity().getPkValue()});
                    customFilterInput.put("ENTRY_KEY", dataModelInput.getDataEntity().getDataEntityType().getName());
                    FormShowParameter paramInput = null;
                    paramInput = BillFormUtil.assembleShowDynamicFormParam((String)"scp_loginfo", customFilterInput, (CloseCallBack)new CloseCallBack((IFormPlugin)this, "scp_loginfo"), (ShowType)ShowType.NonModal);
                    this.getView().showForm(paramInput);
                }
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        if (evt.getActionId().equals("scp_loginfo")) {
            this.getView().invokeOperation("refresh");
        }
    }

    public void registerListener(EventObject e) {
        EntryGrid materialSumGrid;
        BasedataEdit contacter;
        super.registerListener(e);
        BasedataEdit supplier = (BasedataEdit)this.getControl("supplier");
        if (supplier != null) {
            supplier.addBeforeF7SelectListener(this::beforeF7Select);
        }
        if ((contacter = (BasedataEdit)this.getControl("contacter")) != null) {
            contacter.addBeforeF7SelectListener(this::beforeF7Select);
        }
        if ((materialSumGrid = (EntryGrid)this.getView().getControl("materialentry")) != null) {
            materialSumGrid.addHyperClickListener((HyperLinkClickListener)this);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        if (NO_CHANGE_FEILDS.contains(propertyName)) {
            return;
        }
        IDataModel model = this.getModel();
        int currentRowIndex = 0;
        String entityKey = this.getView().getEntityId();
        block8: for (ChangeData changeData : e.getChangeSet()) {
            IDataEntityProperty property;
            int rowIndex = changeData.getRowIndex();
            currentRowIndex = model.getEntryCurrentRowIndex(this.entryKey);
            if (rowIndex >= 0 && currentRowIndex != rowIndex) {
                EntryGrid grid = (EntryGrid)this.getControl(this.entryKey);
                grid.selectRows(rowIndex, true);
            }
            if ((property = e.getProperty()).getParent() != null && property.getParent() instanceof FlexEntityType) {
                return;
            }
            Object modelValue = model.getValue(propertyName, rowIndex);
            if (entityKey.equals("scp_saloutstock") || entityKey.equals("scp_receive")) {
                this.iCalDynamic.proChanged(this.getModel().getDataEntity(true), this.entryKey, propertyName, rowIndex);
            }
            switch (propertyName) {
                case "supplier": {
                    if (!(modelValue instanceof DynamicObject)) continue block8;
                    SupplierChangeUtil.supplierChangeBill((DynamicObject)model.getDataEntity(), (DynamicObject)((DynamicObject)modelValue));
                    continue block8;
                }
                case "material": {
                    if (!(modelValue instanceof DynamicObject)) continue block8;
                    MaterialUtil.materialChanged((DynamicObject)model.getDataEntity(true), (int)rowIndex);
                }
            }
        }
        if (entityKey.equals("scp_saloutstock") || entityKey.equals("scp_receive")) {
            this.iCalDynamic.calSum(this.getModel().getDataEntity(true), this.entryKey);
        }
        if (!entityKey.equals("scp_check") && !entityKey.equals("scp_invoice")) {
            if ("qty".equals(propertyName) || "proddate".equals(propertyName) || "duedate".equals(propertyName)) {
                this.getView().updateView("materialentry", currentRowIndex);
            } else {
                this.getView().updateView("materialentry");
            }
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        String fieldName = hyperLinkClickEvent.getFieldName();
        int rowIndex = hyperLinkClickEvent.getRowIndex();
        DynamicObject rowEntity = this.getModel().getEntryRowEntity("materialentry", rowIndex);
        String orderBillNo = rowEntity.getString(fieldName);
        HashMap<String, String> uniqueMap = new HashMap<String, String>();
        uniqueMap.put("billno", orderBillNo);
        DynamicObject dynamicObject = ORMUtil.querySingleByPro((String)"scp_order", (String)"id,billno", uniqueMap);
        if (dynamicObject != null) {
            BillShowParameter showParam = BillFormUtil.assembleShowBillFormParam((String)"scp_order", (ShowType)ShowType.MainNewTabPage, (OperationStatus)OperationStatus.VIEW, (long)dynamicObject.getLong("id"), null, null);
            this.getView().showForm((FormShowParameter)showParam);
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String name;
        switch (name = beforeF7SelectEvent.getProperty().getName()) {
            case "supplier": {
                ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter().getQFilters().add(BizPartnerUtil.assembleQFilterBizPartner());
                break;
            }
            case "contacter": {
                ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter().getQFilters().add(BizPartnerUtil.assembleQFilterBizPartner());
                break;
            }
        }
    }

    public void setIsPersentUnable(String entry, String ispresentProp, String ... entryprop) {
        DynamicObjectCollection cols = this.getModel().getEntryEntity(entry);
        for (int i = 0; i < cols.size(); ++i) {
            DynamicObject dy = (DynamicObject)cols.get(i);
            boolean ispresent = dy.getBoolean(ispresentProp);
            if (!ispresent) continue;
            this.getView().setEnable(Boolean.valueOf(false), i, entryprop);
        }
    }

    protected void setDiscountRateScale(Object newValue, String entryKey, String fieldKey) {
        int priceRecision = 4;
        if (newValue instanceof DynamicObject) {
            DynamicObject settleCurrency = (DynamicObject)newValue;
            priceRecision = settleCurrency.getInt("priceprecision");
        }
        ClientViewProxy clientViewProxy = (ClientViewProxy)this.getView().getService(IClientViewProxy.class);
        clientViewProxy.invokeControlMethod(entryKey, "setColEditorProp", new Object[]{fieldKey, "sc", priceRecision});
    }
}

