/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.scp.opplugin.botp;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterBuildQueryParemeterEventArgs;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.entity.botp.plugin.args.AfterGetSourceDataEventArgs;
import kd.bos.entity.botp.plugin.args.BeforeBuildRowConditionEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.scm.common.ORMUtil;
import kd.scm.common.checkmapping.PurCheckMappingUtils;
import kd.scm.common.enums.TaxTypeEnum;
import kd.scm.common.util.ApiConfigUtil;
import kd.scm.common.util.CommonUtil;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.util.ExchrateUtil;
import kd.scm.common.util.ParamConfigUtil;
import kd.scm.common.util.caldynamic.CalDynamicFactory;
import kd.scm.common.util.caldynamic.ICalDynamic;
import kd.scm.common.util.invoice.PurInvoiceDeductionCalHelper;

public class ScpCheckToScpInvoicePlugin
extends AbstractConvertPlugIn {
    private static final String PURENTRYKEY = "entryentity1";
    private static final String PURENTRYKEY_SUFFIX = "1";
    private static final String SUMTAX = "sumtax";
    private static final String SUMAMOUNT = "sumamount";
    private static final String SUM_TAXAMOUNT = "sumtaxamount";
    private static final String ENTRY_TAX = "tax";
    private static final String ENTRY_AMOUNT = "amount";
    private static final String ENTRY_QTY = "qty";
    private static final String SUMQTY = "sumqty";
    private static final String ENTRY_ACTCHECKTAXAMOUT = "actchecktaxamount";
    private static final Log log = LogFactory.getLog(ScpCheckToScpInvoicePlugin.class);

    public void beforeBuildRowCondition(BeforeBuildRowConditionEventArgs e) {
        super.beforeBuildRowCondition(e);
        List qFilters = e.getCustQFilters();
        QFilter qFilter = QFilter.of((String)"(ABS(entryentity1.inqty1) > ABS(entryentity1.suminvqty1))  or (entryentity1.linetype1.controlcriterion='1')", (Object[])new Object[0]);
        e.setCustFilterDesc(ResManager.loadKDString((String)"\u6240\u9009\u7684\u5206\u5f55\u5df2\u5168\u90e8\u5f00\u7968\u3002", (String)"ScpCheckToScpInvoicePlugin_0", (String)"scm-scp-opplugin", (Object[])new Object[0]));
        e.setCustFilterExpression("  (ABS(entryentity1.inqty1) > entryentity1.suminvqty1)  or (entryentity1.linetype1.controlcriterion='1')");
        boolean enableWriteOffFlag = ParamConfigUtil.getCacheBooleanParamConfig((String)"writeoffkey");
        if (ApiConfigUtil.hasCQScmConfig() || enableWriteOffFlag) {
            QFilter writeOffQFilter = QFilter.of((String)"(entryentity1.unmatchqty1 !=0 and ABS(entryentity1.unmatchqty1) > ABS(entryentity1.suminvqty1))  or (entryentity1.linetype1.controlcriterion='1')", (Object[])new Object[0]);
            e.setCustFilterDesc(ResManager.loadKDString((String)"\u60a8\u6240\u9009\u7684\u5206\u5f55\u5df2\u5168\u90e8\u5f00\u7968\u6216\u672a\u6838\u9500\u6570\u91cf\u4e0d\u7b49\u4e8e0\u3002", (String)"ScpCheckToScpInvoicePlugin_2", (String)"scm-scp-opplugin", (Object[])new Object[0]));
            e.setCustFilterExpression(" ((entryentity1.unmatchqty1 !=0) and (ABS(entryentity1.unmatchqty1) > entryentity1.suminvqty1)) or (entryentity1.linetype1.controlcriterion='1')");
            qFilters.add(writeOffQFilter);
        }
        qFilters.add(qFilter);
        log.info("qFilters.add( qtyQFilter )" + qFilters.toArray());
    }

    public void afterBuildQueryParemeter(AfterBuildQueryParemeterEventArgs e) {
        super.afterBuildQueryParemeter(e);
        e.addSrcField("entryentity1.srcbilltype1");
        e.addSrcField("entryentity1.srcentryid1");
        e.addSrcField("entryentity1.unmatchqty1");
        e.addSrcField("entryentity1.inqty1");
        e.addSrcField("entryentity1.businesstype_in1");
    }

    public void afterGetSourceData(AfterGetSourceDataEventArgs e) {
        super.afterGetSourceData(e);
    }

    public void afterConvert(AfterConvertEventArgs e) {
        ExtendedDataEntitySet entitySet = e.getTargetExtDataEntitySet();
        ExtendedDataEntity[] entitys = entitySet.FindByEntityKey("scp_invoice");
        ArrayList<String> checkBillNoList = new ArrayList<String>(entitys.length);
        for (ExtendedDataEntity entity : entitys) {
            DynamicObject obj = entity.getDataEntity();
            checkBillNoList.add(obj.getString("checkbillno"));
        }
        Set deductBills = PurCheckMappingUtils.getDeductBill();
        DynamicObject[] checkObjs = this.getCheckBillByBillNo(checkBillNoList);
        for (ExtendedDataEntity entity : entitys) {
            DynamicObject invoiceObj = entity.getDataEntity();
            String checkBillNo = invoiceObj.getString("checkbillno");
            String invoiceKey = invoiceObj.getString("invoiceid");
            for (DynamicObject checkObj : checkObjs) {
                String billNo = checkObj.getString("billno");
                if (null == checkBillNo || !checkBillNo.equals(billNo)) continue;
                this.setInvoiceData(invoiceObj, checkObj, invoiceKey);
            }
            ICalDynamic iCalDynamic = new CalDynamicFactory().createCal();
            DynamicObjectCollection cols = invoiceObj.getDynamicObjectCollection(PURENTRYKEY);
            if (!CollectionUtils.isEmpty((Collection)cols)) {
                boolean containTax = this.isContainTax(invoiceObj);
                DynamicObject linetypeDy = ((DynamicObject)cols.get(0)).getDynamicObject("linetype1");
                if (linetypeDy != null && PURENTRYKEY_SUFFIX.equals(linetypeDy.getString("controlcriterion"))) {
                    if (containTax) {
                        iCalDynamic.calByEntryActCheckTaxAmountChange(invoiceObj, PURENTRYKEY, PURENTRYKEY_SUFFIX);
                    } else {
                        iCalDynamic.calByEntryActCheckAmountChange(invoiceObj, PURENTRYKEY, PURENTRYKEY_SUFFIX);
                    }
                } else {
                    iCalDynamic.calByEntryActQtyChange(invoiceObj, PURENTRYKEY, PURENTRYKEY_SUFFIX);
                }
                this.setHeadData(invoiceObj, cols);
            }
            PurInvoiceDeductionCalHelper.calDeduction((DynamicObject)invoiceObj, (Set)deductBills);
        }
    }

    protected boolean isContainTax(DynamicObject billDynamicObject) {
        String taxType = billDynamicObject.getString("taxtype");
        return TaxTypeEnum.TAXSEXPRICE_INTAX.getVal().equals(taxType) || TaxTypeEnum.TAXSINPRICE_INTAX.getVal().equals(taxType);
    }

    private void setHeadData(DynamicObject obj, DynamicObjectCollection cols) {
        BigDecimal sumTaxAmount = BigDecimal.ZERO;
        BigDecimal sumTax = BigDecimal.ZERO;
        BigDecimal sumAmount = BigDecimal.ZERO;
        BigDecimal sumqty = BigDecimal.ZERO;
        for (DynamicObject dynamicObject : cols) {
            ExchrateUtil.setLocalPrice((DynamicObject)dynamicObject, (String)PURENTRYKEY_SUFFIX, (String)PURENTRYKEY_SUFFIX, (boolean)true);
            sumTax = sumTax.add(CommonUtil.getBigDecimalPro((Object)dynamicObject.get("tax1")));
            sumAmount = sumAmount.add(CommonUtil.getBigDecimalPro((Object)dynamicObject.get("amount1")));
            sumTaxAmount = sumTaxAmount.add(CommonUtil.getBigDecimalPro((Object)dynamicObject.get(ENTRY_ACTCHECKTAXAMOUT)));
            sumqty = sumqty.add(CommonUtil.getBigDecimalPro((Object)dynamicObject.get("qty1")));
        }
        obj.set(SUMQTY, (Object)sumqty);
        obj.set(SUMTAX, (Object)sumTax);
        obj.set(SUM_TAXAMOUNT, (Object)sumTaxAmount);
        obj.set(SUMAMOUNT, (Object)sumTaxAmount.subtract(sumTax));
    }

    private DynamicObject[] getCheckBillByBillNo(List<String> billNoList) {
        HashMap params = new HashMap(2);
        HashMap<String, List<String>> idMap = new HashMap<String, List<String>>(1);
        idMap.put("in", billNoList);
        params.put("billno", idMap);
        String selectfields = DynamicObjectUtil.getSelectfields((String)"scp_check", (boolean)false);
        selectfields = DynamicObjectUtil.getEntrySelectfields((String)selectfields, (String)"scp_check", (String)"entryentity2", (boolean)false);
        return ORMUtil.load((String)"scp_check", (String)selectfields, params);
    }

    private void setInvoiceData(DynamicObject invoiceObj, DynamicObject checkObj, String invoiceKey) {
        DynamicObjectCollection invoiceCols = checkObj.getDynamicObjectCollection("entryentity2");
        for (DynamicObject invoiceCol : invoiceCols) {
            String currInvoiceKey = invoiceCol.getString("invoiceid2");
            if (!invoiceKey.equals(currInvoiceKey)) continue;
            invoiceObj.set("invoicecode", (Object)invoiceCol.getString("invoicecode"));
            invoiceObj.set("invoiceno", (Object)invoiceCol.getString("invoiceno"));
            invoiceObj.set("invoicedate", invoiceCol.get("invoicedate"));
            invoiceObj.set("remark", invoiceCol.get("note2"));
            return;
        }
        DynamicObjectCollection invoiceEntryentityCols = invoiceObj.getDynamicObjectCollection("entryentity");
        for (DynamicObject invoiceCol : invoiceEntryentityCols) {
            this.setInvoiceDefaultValue(invoiceCol, invoiceObj);
        }
    }

    private void setInvoiceDefaultValue(DynamicObject invoiceCol, DynamicObject invoiceObj) {
        DynamicObject bizpartner;
        DynamicObject curr;
        DynamicObject org = invoiceObj.getDynamicObject("org");
        if (org != null) {
            String ffirmname = org.getString("ffirmname");
            invoiceCol.set("reccompany", (Object)ffirmname);
        }
        if ((curr = invoiceObj.getDynamicObject("curr")) != null) {
            invoiceCol.set("invcurr", (Object)curr);
        }
        if ((bizpartner = invoiceObj.getDynamicObject("bizpartner")) != null) {
            String bizpartnerName = bizpartner.getString("name");
            invoiceCol.set("invcompany", (Object)bizpartnerName);
        }
    }
}

