/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.service;

import java.util.ArrayList;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.scm.src.service.SrcDbUpgradeService;

public class SrcDbBigTableUpdateService
implements IUpgradeService {
    private static final Log logger = LogFactory.getLog(SrcDbUpgradeService.class);

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        result.setEl("warning");
        StringBuilder pProcessInfo = new StringBuilder();
        try {
            result.setLog("start upgrade mallgoods");
            ArrayList<String> filedList = new ArrayList<String>(1);
            filedList.add("fnodename");
            this.upgrade("scm", filedList, "fid", "t_src_project", "t_src_project_l", pProcessInfo);
            result.setSuccess(true);
        }
        catch (Exception e) {
            result.setSuccess(false);
        }
        return result;
    }

    public boolean upgrade(String dbKey, List<String> filedList, String idFiledName, String srcTableName, String tarTablename, StringBuilder pProcessInfo) {
        int pageSize = 2000;
        StringBuilder selectSql = new StringBuilder();
        selectSql.append("select ").append(idFiledName);
        for (String string : filedList) {
            selectSql.append(", ").append(string);
        }
        selectSql.append(" from  ").append(srcTableName);
        StringBuilder updateSql = new StringBuilder();
        updateSql.append("update ").append(tarTablename).append(" set ").append(idFiledName).append(" = ? ");
        for (String filed : filedList) {
            updateSql.append(", ").append(filed).append(" = ? ");
        }
        updateSql.append(" where  ").append(idFiledName).append(" = ? ").append("and flocaleid = 'zh_CN'");
        try (DataSet dataSet = this.getDataSet(dbKey, selectSql.toString());){
            ArrayList<Object[]> allParamsList = new ArrayList<Object[]>(2048);
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                ArrayList<Object> paramsList = new ArrayList<Object>(filedList.size() + 2);
                paramsList.add(row.get(idFiledName));
                for (String filed : filedList) {
                    paramsList.add(row.get(filed));
                }
                paramsList.add(row.get(idFiledName));
                allParamsList.add(paramsList.toArray());
                if (allParamsList.size() <= pageSize) continue;
                this.updateBatch(dbKey, updateSql.toString(), allParamsList);
                allParamsList.clear();
            }
            if (allParamsList.size() > 0) {
                this.updateBatch(dbKey, updateSql.toString(), allParamsList);
            }
        }
        return true;
    }

    private void updateBatch(String dbKey, String updateSql, List<Object[]> paramsList) {
        DBRoute dbRoute = DBRoute.of((String)dbKey);
        DB.executeBatch((DBRoute)dbRoute, (String)updateSql, paramsList);
    }

    private DataSet getDataSet(String dbKey, String sql) {
        DBRoute dbRoute = DBRoute.of((String)dbKey);
        return DB.queryDataSet((String)RequestContext.get().getTraceId(), (DBRoute)dbRoute, (String)sql);
    }
}

