/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.service;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDBizException;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;

public class SrcDbInsertService
implements IUpgradeService {
    private static final Log logger = LogFactory.getLog(SrcDbInsertService.class);

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        result.setEl("warning");
        StringBuilder pProcessInfo = new StringBuilder();
        try {
            result.setLog("start upgrade mallgoods");
            this.upgrade("scm", "src_index", "fentryid", "t_src_indexentry", "t_src_indexentry_l", pProcessInfo);
            this.upgrade("scm", "src_scheme", "fentryid", "t_src_schemeindex", "t_src_schemeindex_l", pProcessInfo);
            this.upgrade("scm", "src_schemerulef7", "fdetailid", "t_src_schemerule", "t_src_schemerule_l", pProcessInfo);
            this.upgrade("scm", "src_expert", "fentryid", "t_src_expertaptitude", "t_src_expertaptitude_l", pProcessInfo);
            this.upgrade("scm", "src_bizscheme", "fentryid", "t_src_bizschemeentry", "t_src_bizschemeentry_l", pProcessInfo);
            this.upgrade("scm", "src_index", "fid", "t_src_index", "t_src_index_l", pProcessInfo);
            this.upgrade("scm", "src_expertgrade", "fid", "t_src_grade", "t_src_grade_l", pProcessInfo);
            this.upgrade("scm", "src_openscheme", "fid", "t_src_openscheme", "t_src_openscheme_l", pProcessInfo);
            this.upgrade("scm", "src_bizscheme", "fid", "t_src_bizscheme", "t_src_bizscheme_l", pProcessInfo);
            this.upgrade("scm", "src_bizitem", "fid", "t_src_bizitem", "t_src_bizitem_l", pProcessInfo);
            result.setSuccess(true);
        }
        catch (Exception e) {
            result.setErrorInfo(pProcessInfo.append(e.getMessage()).toString());
            result.setSuccess(false);
            throw new KDBizException(result.getErrorInfo());
        }
        return result;
    }

    public boolean upgrade(String dbKey, String billname, String idFiledName, String srcTableName, String tarTablename, StringBuilder pProcessInfo) {
        int pageSize = 2000;
        StringBuilder selectSql = new StringBuilder();
        selectSql.append("select ").append(idFiledName);
        selectSql.append(" from  ").append(srcTableName);
        StringBuilder updateSql = new StringBuilder();
        updateSql.append("insert ").append(tarTablename).append(" ( ").append(idFiledName);
        updateSql.append(", FPKID ,FLOCALEID ");
        updateSql.append(" )");
        updateSql.append(" values ( ?,?,? ");
        updateSql.append(" )");
        String selectFromTarSql = "select " + idFiledName + " from  " + tarTablename + " where flocaleid = 'zh_CN'";
        DataSet tarDs = null;
        try (DataSet tmp = this.getDataSet(dbKey, selectFromTarSql);){
            tarDs = tmp.copy();
        }
        HashSet<Long> tarIds = new HashSet<Long>(tarDs.copy().count(idFiledName, true));
        while (tarDs.hasNext()) {
            Row row = tarDs.next();
            long id = row.getLong(idFiledName);
            tarIds.add(id);
        }
        try (DataSet srcDs = this.getDataSet(dbKey, selectSql.toString());){
            int count = srcDs.copy().count(idFiledName, true);
            String[] ids = ID.genStringIds((int)count);
            ArrayList<Object[]> allParamsList = new ArrayList<Object[]>(2048);
            int i = 0;
            while (srcDs.hasNext()) {
                Row row = srcDs.next();
                ArrayList<Object> paramsList = new ArrayList<Object>(3);
                long id = (Long)row.get(idFiledName);
                if (tarIds.contains(id)) continue;
                paramsList.add(id);
                paramsList.add(ids[i]);
                ++i;
                paramsList.add("zh_CN");
                allParamsList.add(paramsList.toArray());
                if (allParamsList.size() <= pageSize) continue;
                this.updateBatch(dbKey, updateSql.toString(), allParamsList);
                allParamsList.clear();
            }
            if (allParamsList.size() > 0) {
                this.updateBatch(dbKey, updateSql.toString(), allParamsList);
            }
        }
        return true;
    }

    private void updateBatch(String dbKey, String updateSql, List<Object[]> paramsList) {
        DBRoute dbRoute = DBRoute.of((String)dbKey);
        DB.executeBatch((DBRoute)dbRoute, (String)updateSql, paramsList);
    }

    private DataSet getDataSet(String dbKey, String sql) {
        DBRoute dbRoute = DBRoute.of((String)dbKey);
        return DB.queryDataSet((String)RequestContext.get().getTraceId(), (DBRoute)dbRoute, (String)sql);
    }
}

