/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.formplugin.comp;

import java.util.EventObject;
import java.util.HashSet;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.TemplateUtil;
import kd.scm.src.common.bidopen.SrcBidOpenFacade;
import kd.scm.src.common.util.SrcAppCache;

public class SrcSupplierOpenEdit
extends AbstractBillPlugIn {
    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        IFormView parentView = this.getView().getParentView();
        if (null != parentView) {
            SrcAppCache.put((String)"src_supplier_open", (Object)this.getView().getPageId(), (IFormView)parentView);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        IFormView parentView = this.getView().getParentView();
        if (parentView == null) {
            return;
        }
        this.loadCompEntryData(parentView);
        this.setEnableFalse(parentView);
        SrcBidOpenFacade.hideSupplierName((IFormView)this.getView(), (long)PdsCommonUtils.object2Long((Object)this.getModel().getValue("parentid")));
        this.getModel().setDataChanged(false);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        super.afterDoOperation(args);
        switch (operateKey = args.getOperateKey()) {
            case "save": 
            case "submit": {
                SrcBidOpenFacade.saveSupOpenData((IFormView)this.getView().getParentView());
                break;
            }
        }
    }

    private void loadCompEntryData(IFormView parentView) {
        DynamicObject projectObj = parentView.getModel().getDataEntity(true);
        long projectId = SrmCommonUtil.getPkValue((DynamicObject)projectObj);
        QFilter qfilter = new QFilter("billid", "=", (Object)projectId);
        SrcBidOpenFacade.addSupplierOpenFilter((QFilter)qfilter, (!"src_aptitudeaudit".equals(parentView.getEntityId()) ? 1 : 0) != 0);
        HashSet<String> excFields = new HashSet<String>();
        excFields.add("id");
        excFields.add("seq");
        TemplateUtil.loadCompEntryData((IFormView)this.getView(), (String)"src_bidopensupplier", (QFilter)qfilter, excFields, (String)this.getOrderBy());
    }

    private void setEnableFalse(IFormView parentView) {
        if (parentView.getModel().getValue("billstatus").equals(BillStatusEnum.SAVE.getVal())) {
            QFilter qfilters2;
            QFilter qfilters = this.getProjectFilter().and(this.getStatusFilter(parentView));
            if (QueryServiceHelper.exists((String)"src_supplieropen", (QFilter[])qfilters.toArray())) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"supopentype", "isnoderank"});
                this.getView().setEnable(Boolean.valueOf(false), -1, new String[]{"rank"});
            } else if (this.isNodeRank() && QueryServiceHelper.exists((String)"src_supplieropen", (QFilter[])(qfilters2 = this.getProjectFilter().and(this.getAllStatusFilter())).toArray())) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"isnoderank"});
            }
        }
    }

    private QFilter getStatusFilter(IFormView parentView) {
        if (!this.isNodeRank()) {
            return this.getAllStatusFilter();
        }
        switch (parentView.getEntityId()) {
            case "src_aptitudeaudit": {
                return new QFilter("isaptopen", "=", (Object)"1");
            }
            case "src_aptitudeaudit2": 
            case "src_scorertask": 
            case "src_bidassess": {
                return new QFilter("istecopen", "=", (Object)"1");
            }
            case "src_compare": {
                return new QFilter("isbizopen", "=", (Object)"1");
            }
        }
        return this.getAllStatusFilter();
    }

    private QFilter getProjectFilter() {
        return new QFilter("billid", "=", this.getView().getParentView().getModel().getDataEntity().getPkValue());
    }

    private QFilter getAllStatusFilter() {
        QFilter qfilters = new QFilter("isaptopen", "=", (Object)"1");
        qfilters.or("istecopen", "=", (Object)"1");
        qfilters.or("isbizopen", "=", (Object)"1");
        return qfilters;
    }

    private String getOrderBy() {
        String orderBy = "rank";
        if (this.isNodeRank()) {
            switch (this.getView().getParentView().getEntityId()) {
                case "src_aptitudeaudit": {
                    orderBy = "aptrank";
                    break;
                }
                case "src_aptitudeaudit2": 
                case "src_scorertask": 
                case "src_bidassess": {
                    orderBy = "tecrank";
                    break;
                }
                case "src_compare": {
                    orderBy = "bizrank";
                }
            }
        }
        return orderBy;
    }

    private boolean isNodeRank() {
        return this.getView().getModel().getDataEntity().getBoolean("isnoderank");
    }
}

