/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.formplugin.comp;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.DateTimeEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.util.DateUtil;
import kd.scm.common.util.ParamUtil;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.carryvalue.PdsCarryValueFacade;
import kd.scm.pds.common.enums.SourceTypeEnums;
import kd.scm.pds.common.util.ComboEditUtils;
import kd.scm.pds.common.util.ExtParameterUtils;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.PdsCompConfigUtil;
import kd.scm.pds.common.util.SrcCurrencyUtil;
import kd.scm.pds.common.util.TemplateUtil;
import kd.scm.src.common.patternfilter.PatternFilterUtils;
import kd.scm.src.common.util.SrcAppCache;

public class SrcVieRuleEdit
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    private static final String VIE_RULE_PAGE_ID = "vierulepageid";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit scheme = (BasedataEdit)this.getView().getControl("scheme");
        if (scheme != null) {
            scheme.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        IFormView parentView = this.getView().getParentView();
        if (!PdsCommonUtils.isValidBillType((IFormView)parentView)) {
            return;
        }
        this.showVieTurns();
        DynamicObject obj = parentView.getModel().getDataEntity();
        String billStatus = obj.getString("billstatus");
        if (null != billStatus && !BillStatusEnum.SAVE.getVal().equals(billStatus)) {
            return;
        }
        SrcAppCache.put((String)VIE_RULE_PAGE_ID, (Object)this.getView().getPageId(), (IFormView)parentView);
        long sourceFlowId = SrmCommonUtil.getPkValue((DynamicObject)this.getView().getParentView().getModel().getDataEntity().getDynamicObject("srctype"));
        boolean isManualScoreTask = ExtParameterUtils.convertToBoolen((Object)ExtParameterUtils.getExtParameterValueById((String)"pds_flowconfig", (long)sourceFlowId, (String)"ismanualscoretask", (Object)false, (long)SrmCommonUtil.getPkValue((DynamicObject)this.getView().getParentView().getModel().getDataEntity())));
        if (!isManualScoreTask && this.getModel().getDataEntity().getBigDecimal("ratio_biz").compareTo(BigDecimal.ZERO) == 0) {
            this.getModel().setValue("ratio_biz", (Object)100);
        }
        String vieType = this.getModel().getDataEntity().getString("vietype");
        if (Objects.equals(parentView.getEntityId(), "src_project")) {
            String srcType = parentView.getModel().getDataEntity().getString("sourcetype.number");
            if (Objects.equals(SourceTypeEnums.ELECTRONIC_AUCTION.getValue(), srcType)) {
                this.getModel().setValue("vietype", (Object)"B");
            } else {
                this.getModel().setValue("vietype", (Object)"A");
            }
        }
        if ("src_project".equals(parentView.getEntityId())) {
            Object tendency;
            List compKey = TemplateUtil.getCompKeyListByTplEntry((DynamicObject)this.getView().getParentView().getModel().getDataEntity(true), (boolean)false);
            if (compKey.contains("src_project_base")) {
                tendency = (FieldEdit)this.getView().getControl("tendency");
                tendency.setFieldKey(null);
                tendency.setVisible("visible", false);
                FieldEdit taxType = (FieldEdit)this.getView().getControl("taxtype");
                taxType.setFieldKey(null);
                taxType.setVisible("visible", false);
            } else {
                tendency = this.getModel().getDataEntity().getString("tendency");
                if (null == tendency || "".equals(((String)tendency).trim())) {
                    tendency = this.getView().getParentView().getModel().getDataEntity().getString("srctype.tendency");
                    if (!StringUtils.isBlank((CharSequence)tendency)) {
                        this.getModel().setValue("tendency", tendency);
                    } else {
                        this.getModel().setValue("tendency", (Object)"3");
                    }
                }
            }
        }
        this.setCurrency();
        PatternFilterUtils.setSchemeDefaultValue((IFormView)this.getView());
        String isRegionControl = this.getModel().getDataEntity().getString("isregioncontrol");
        if (null == isRegionControl || "".equals(isRegionControl.trim())) {
            if (ExtParameterUtils.convertToBoolen((Object)ExtParameterUtils.getExtParameterValueById((String)"pds_flowconfig", (long)sourceFlowId, (String)"isregioncontrol", (Object)false, (long)SrmCommonUtil.getPkValue((DynamicObject)this.getView().getParentView().getModel().getDataEntity())))) {
                this.getModel().setValue("isregioncontrol", (Object)"1");
            } else {
                this.getModel().setValue("isregioncontrol", (Object)"2");
            }
        }
        if (PdsCompConfigUtil.parentIsProject((IFormView)this.getView()) && PdsCompConfigUtil.isTemplateChanged((IFormView)this.getView())) {
            ArrayList<String> defaultCompKeyList = new ArrayList<String>(1);
            defaultCompKeyList.add(this.getView().getEntityId());
            PdsCarryValueFacade.carryValueToComponent((IFormView)this.getView().getParentView(), (String)"srctype", defaultCompKeyList);
        }
        this.setFieldKey();
        this.setSysVieParam();
    }

    private void setFieldKey() {
        IFormView parentView = this.getView().getParentView();
        if (Objects.isNull(parentView)) {
            return;
        }
        if (!Objects.equals("src_project", parentView.getEntityId())) {
            return;
        }
        List compKeys = TemplateUtil.getCompKeyList((DynamicObject)parentView.getModel().getDataEntity(true));
        if (compKeys.contains("src_project_rule")) {
            FieldEdit scheme = (FieldEdit)this.getControl("scheme");
            scheme.setFieldKey(null);
            FieldEdit winerQty = (FieldEdit)this.getControl("winerqty");
            winerQty.setFieldKey(null);
        }
        if (compKeys.contains("src_bidopen_config")) {
            FieldEdit ratio_biz = (FieldEdit)this.getControl("ratio_biz");
            ratio_biz.setFieldKey(null);
        }
    }

    private void showVieTurns() {
        long projectId = PdsCommonUtils.object2Long((Object)this.getModel().getDataEntity().getPkValue());
        QFilter qFilters = new QFilter("billid", "=", (Object)projectId);
        if (!QueryServiceHelper.exists((String)"src_vie_turns", (QFilter[])qFilters.toArray())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"entryentityturns"});
        }
    }

    private void setCurrency() {
        IFormView parentView = this.getView().getParentView();
        if (Objects.isNull(parentView)) {
            return;
        }
        if (parentView.getEntityId().equals("src_project")) {
            DynamicObject currencyObject = this.getModel().getDataEntity().getDynamicObject("currency");
            DynamicObject orgObj = parentView.getModel().getDataEntity().getDynamicObject("org_tmp");
            if (Objects.isNull(currencyObject) && Objects.nonNull(orgObj)) {
                this.getModel().setValue("currency", SrcCurrencyUtil.getBaseCurrIdByOrg((Object)orgObj.getPkValue()));
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        Object newValue = e.getChangeSet()[0].getNewValue();
        switch (e.getProperty().getName()) {
            case "vietype": {
                HashMap<String, String> comboMap = new HashMap<String, String>();
                if (this.getModel().getValue("vietype").equals("A")) {
                    comboMap.put("1", ResManager.loadKDString((String)"\u53ea\u5141\u8bb8\u964d\u4ef7", (String)"SrcVieRuleEdit_3", (String)"scm-src-formplugin", (Object[])new Object[0]));
                } else {
                    comboMap.put("2", ResManager.loadKDString((String)"\u53ea\u5141\u8bb8\u52a0\u4ef7", (String)"SrcVieRuleEdit_4", (String)"scm-src-formplugin", (Object[])new Object[0]));
                }
                comboMap.put("3", ResManager.loadKDString((String)"\u5141\u8bb8\u52a0\u4ef7\u6216\u964d\u4ef7\u3002", (String)"SrcVieRuleEdit_5", (String)"scm-src-formplugin", (Object[])new Object[0]));
                ComboEdit tendency = (ComboEdit)this.getControl("tendency");
                tendency.setComboItems(ComboEditUtils.getComboList(comboMap));
                PatternFilterUtils.setSchemeDefaultValue((IFormView)this.getView());
                break;
            }
            case "autoconfirm": {
                this.setOpenDateMustInput();
                break;
            }
            case "planopendate": {
                if (Objects.isNull(newValue)) {
                    return;
                }
                Date openDate = (Date)newValue;
                Date nowDate = TimeServiceHelper.now();
                if (!nowDate.after(openDate)) break;
                this.getModel().setValue("planopendate", null);
                this.getView().showMessage(String.format(ResManager.loadKDString((String)"\u9884\u8ba1\u7ade\u4ef7\u5f00\u59cb\u65f6\u95f4(%1$s)\u5e94\u5927\u4e8e\u5f53\u524d\u65f6\u95f4(%2$s)\u3002", (String)"SrcVieRuleEdit_9", (String)"scm-src-formplugin", (Object[])new Object[0]), DateUtil.getFormatEndDate((Date)openDate), DateUtil.getFormatEndDate((Date)nowDate)));
                break;
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String key;
        switch (key = evt.getProperty().getName()) {
            case "scheme": {
                QFilter qfilter = PatternFilterUtils.getSchemeFilter((IFormView)this.getView());
                if (qfilter == null) {
                    return;
                }
                ListShowParameter schemeFormShowParameter = (ListShowParameter)evt.getFormShowParameter();
                schemeFormShowParameter.getListFilterParameter().getQFilters().add(qfilter);
                String orderBy = "matchfield desc,priority,modifytime desc";
                schemeFormShowParameter.getListFilterParameter().setOrderBy(orderBy);
                break;
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setOpenDateMustInput();
    }

    private void setOpenDateMustInput() {
        DateTimeEdit planOpenDate = (DateTimeEdit)this.getControl("planopendate");
        if (((Boolean)this.getModel().getValue("autoconfirm")).booleanValue()) {
            planOpenDate.setMustInput(true);
        } else {
            planOpenDate.setMustInput(false);
        }
    }

    private void setSysVieParam() {
        IFormView parentView = this.getView().getParentView();
        if (Objects.isNull(parentView)) {
            return;
        }
        if (parentView.getEntityId().equals("src_project")) {
            Object submittype;
            Object vie_purlist = this.getModel().getDataEntity().get("vie_purlist");
            if (StringUtils.isBlank((Object)vie_purlist)) {
                this.getModel().setValue("vie_purlist", ParamUtil.getParamObj((String)"0DUM2+6E41IA", (String)"vie_purlist"));
            }
            if (StringUtils.isBlank((Object)(submittype = this.getModel().getDataEntity().get("submittype")))) {
                this.getModel().setValue("submittype", ParamUtil.getParamObj((String)"0DUM2+6E41IA", (String)"submittype"));
            }
        }
    }
}

