/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.formplugin.edit;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.IBillView;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.scm.common.util.cal.Cal4DynamicObj;
import kd.scm.common.util.cal.ICal;
import kd.scm.pds.common.enums.SourceTypeEnums;
import kd.scm.pds.common.extfilter.SchemeFilterUtils;
import kd.scm.pds.common.extplugin.ExtPluginContext;
import kd.scm.pds.common.extplugin.ExtPluginFactory;
import kd.scm.pds.common.util.PdsReportUtils;
import kd.scm.pds.common.util.SourceTypeUtils;
import kd.scm.pds.common.util.SrcCalImpl;
import kd.scm.src.common.hyperlink.SrcPurListHyperlinkHandler;
import kd.scm.src.common.pushproject.SrcPushProjectUtils;
import kd.scm.src.common.util.SrcDemandUtils;
import kd.scm.src.common.util.SrcProjectUtil;

public class SrcDemandEdit
extends AbstractBillPlugIn
implements BeforeF7SelectListener,
HyperLinkClickListener {
    private ICal cal = new SrcCalImpl();

    public void initialize() {
        this.getView().getPageCache().put("BOS.setRowDataByNumberAutoAddRow", "false");
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit srcflowconfig = (BasedataEdit)this.getControl("srcflowconfig");
        srcflowconfig.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit srcType2 = (BasedataEdit)this.getControl("srctype2");
        srcType2.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit category = (BasedataEdit)this.getControl("category");
        category.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        FormOperate formOperate = (FormOperate)e.getSource();
        String operateKey = formOperate.getOperateKey();
        Set sourceTypeSet = SourceTypeUtils.getAllSourceTypeKey();
        if (sourceTypeSet.contains(operateKey)) {
            formOperate.getOption().setVariableValue("sourcetype", SourceTypeEnums.getValue((String)operateKey.toUpperCase()));
        } else if (operateKey.equals("save") || operateKey.equals("submit")) {
            this.updateReferPrice();
            this.beforeSaveHandle();
            this.setSrcBillNoValue();
        } else if (operateKey.equals("createpdf")) {
            PdsReportUtils.openCreatePdf((IFormView)this.getView(), (boolean)false, null);
        }
    }

    private void setSrcBillNoValue() {
        DynamicObjectCollection rows = this.getModel().getEntryEntity("entryentity");
        for (int i = 0; i < rows.size(); ++i) {
            if (!Objects.equals(((DynamicObject)rows.get(i)).getString("reqsource11"), "3")) continue;
            this.getModel().setValue("srcbillno", this.getModel().getDataEntity().get("billno"), i);
        }
    }

    private void beforeSaveHandle() {
        DynamicObjectCollection rows = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        for (int index = 0; index < rows.size(); ++index) {
            DynamicObject entryOrgObj = ((DynamicObject)rows.get(index)).getDynamicObject("entryorg");
            if (Objects.isNull(entryOrgObj)) {
                this.getModel().setValue("entryorg", (Object)this.getModel().getDataEntity().getLong("org.id"), index);
                continue;
            }
            String reqSource = ((DynamicObject)rows.get(index)).getString("reqsource11");
            if (Objects.equals(reqSource, "2")) continue;
            this.getModel().setValue("entryorg", (Object)this.getModel().getDataEntity().getLong("org.id"), index);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String fieldKey = e.getProperty().getName();
        if (Objects.equals(e.getProperty().getParent().getName(), "entryentity")) {
            int rowIndex = e.getChangeSet()[0].getRowIndex();
            int currRowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
            if (rowIndex >= 0 && currRowIndex != rowIndex) {
                EntryGrid grid = (EntryGrid)this.getControl("entryentity");
                grid.selectRows(rowIndex, true);
            }
        }
        switch (fieldKey) {
            case "purtype": {
                this.getModel().setValue("srcflowconfig", null);
                this.getModel().setValue("decisionitem", null);
                break;
            }
            case "resultstatus": {
                if ("A".equals(this.getModel().getValue("resultstatus"))) break;
                this.getModel().setValue("istemppush", (Object)Boolean.FALSE);
                break;
            }
            case "istemppush": {
                if (((Boolean)this.getModel().getValue("istemppush")).booleanValue()) {
                    this.setMustInput(true, "tempreason");
                    break;
                }
                this.setMustInput(false, "tempreason");
                break;
            }
            case "biztype": {
                SrcProjectUtil.resetSoureFlow((IFormView)this.getView(), (PropertyChangedArgs)e);
                break;
            }
            case "sourcetype2": {
                this.getModel().setValue("srctype2", null);
                break;
            }
            case "srctype2": {
                if (null != this.getModel().getValue("sourcetype2")) break;
                Object newValue = e.getChangeSet()[0].getNewValue();
                if (Objects.isNull(newValue)) {
                    return;
                }
                this.getModel().beginInit();
                this.getModel().setValue("sourcetype2", (Object)((DynamicObject)newValue).getDynamicObject("sourcetype"));
                this.getModel().endInit();
                this.getView().updateView("sourcetype2");
                break;
            }
        }
        this.cal.proChanged(this.getModel(), "entryentity", fieldKey);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.autoLoadScenepurorg();
        this.setBillStatus();
        this.calTaxFromK3cloud();
        this.getModel().setDataChanged(false);
    }

    public void calTaxFromK3cloud() {
        String srcbilltype = (String)this.getModel().getValue("srcbilltype");
        if (!"PUR_Requisition".equals(srcbilltype)) {
            return;
        }
        DynamicObject dataEntity = this.getModel().getDataEntity();
        BigDecimal sumAmount = (BigDecimal)dataEntity.get("sumtaxamount");
        if (BigDecimal.ZERO.compareTo(sumAmount) == 0) {
            dataEntity.set("curr", dataEntity.get("currency"));
            Cal4DynamicObj.calByQty((DynamicObject)dataEntity, (String)"entryentity");
            this.getView().updateView("sumtaxamount");
            this.getView().updateView("sumamount");
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key;
        switch (key = e.getProperty().getName()) {
            case "srctype2": {
                this.setSrctype2Select(e);
                break;
            }
            case "srcflowconfig": {
                this.setSrctypeSelect(e);
                break;
            }
        }
    }

    public void beforeBindData(EventObject e) {
        this.hideSomeButton();
        this.setButtonVisible();
    }

    private void setButtonVisible() {
        DynamicObjectCollection rows = this.getModel().getEntryEntity("entry");
        Set purTypes = rows.stream().map(row -> Optional.ofNullable(row.getDynamicObject("purtype")).map(type -> type.getString("number")).orElse(null)).filter(Objects::nonNull).collect(Collectors.toSet());
        for (String type : purTypes) {
            String sourceType = SourceTypeEnums.getName((String)type);
            this.getView().setVisible(Boolean.TRUE, new String[]{sourceType.replace("_", "").toLowerCase()});
        }
        Set typeEnums = Arrays.stream(SourceTypeEnums.values()).map(SourceTypeEnums::getValue).collect(Collectors.toSet());
        typeEnums.removeAll(purTypes);
        for (String type : typeEnums) {
            String sourceType = SourceTypeEnums.getName((String)type);
            this.getView().setVisible(Boolean.FALSE, new String[]{sourceType.replace("_", "").toLowerCase()});
        }
    }

    private void setMustInput(boolean isMustInput, String ... keys) {
        for (String key : keys) {
            FieldEdit edit = (FieldEdit)this.getControl(key);
            edit.setMustInput(isMustInput);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if (args.getOperationResult() != null && args.getOperationResult().isSuccess()) {
            Set sourceTypeSet = SourceTypeUtils.getAllSourceTypeKey();
            if (sourceTypeSet.contains(operateKey)) {
                SrcDemandUtils.afterPushOperation((AfterDoOperationEventArgs)args, (IFormView)this.getView());
            } else if (operateKey.equals("audit")) {
                SrcPushProjectUtils.showTipsAfterDemandAudit((IFormView)this.getView(), (AfterDoOperationEventArgs)args);
                this.getView().invokeOperation("refresh");
            }
        }
    }

    public void hideSomeButton() {
        IFormView parentView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
        if (parentView == null) {
            return;
        }
        if ("src_decisioncfm".equals(parentView.getEntityId())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"baritemap1", "initiatechange"});
        }
    }

    private void setSrctypeSelect(BeforeF7SelectEvent evt) {
        int curInx = this.getModel().getEntryCurrentRowIndex("entry");
        DynamicObject sourcetype = (DynamicObject)this.getModel().getValue("purtype", curInx);
        if (sourcetype == null) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5bfb\u6e90\u65b9\u5f0f\u3002", (String)"SrcDemandEdit_4", (String)"scm-src-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>(2);
        paramMap.put("sourcetype", sourcetype.getPkValue());
        paramMap.put("ismustinput", "1");
        SchemeFilterUtils.setSchemeF7Filter((BeforeF7SelectEvent)evt, (DynamicObject)this.getModel().getDataEntity(), (String)"src_project_srctype_filter", paramMap);
    }

    private void setSrctype2Select(BeforeF7SelectEvent evt) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>(2);
        long sourcetypeId = this.getModel().getDataEntity().getLong("sourcetype2.id");
        paramMap.put("sourcetype", sourcetypeId);
        paramMap.put("ismustinput", "1");
        SchemeFilterUtils.setSchemeF7Filter((BeforeF7SelectEvent)evt, (DynamicObject)this.getModel().getDataEntity(), (String)"src_project_srctype_filter", paramMap);
    }

    private void autoLoadScenepurorg() {
        IDataModel model = this.getModel();
        DynamicObjectCollection rows = model.getDataEntity(true).getDynamicObjectCollection("entry");
        if (rows == null || rows.size() == 0) {
            return;
        }
        DynamicObject purorg = (DynamicObject)model.getValue("org");
        if (null == purorg) {
            return;
        }
        int index = model.getEntryCurrentRowIndex("entry");
        DynamicObjectCollection dycols = new DynamicObjectCollection();
        dycols.add((Object)purorg);
        model.setValue("scenepurorg", (Object)dycols, index);
    }

    private void setBillStatus() {
        IDataEntityProperty property = this.getModel().getProperty("billstatus");
        if (property != null) {
            if (this.getView().getFormShowParameter().getStatus() == OperationStatus.VIEW) {
                ((IBillView)this.getView()).setBillStatus(BillOperationStatus.VIEW);
            } else {
                String value = (String)this.getModel().getValue("billstatus");
                if ("A".equals(value)) {
                    boolean bFromDb = this.getModel().getDataEntity().getDataEntityState().getFromDatabase();
                    if (bFromDb) {
                        ((IBillView)this.getView()).setBillStatus(BillOperationStatus.EDIT);
                    } else {
                        ((IBillView)this.getView()).setBillStatus(BillOperationStatus.ADDNEW);
                    }
                } else if ("B".equals(value)) {
                    ((IBillView)this.getView()).setBillStatus(BillOperationStatus.SUBMIT);
                } else if ("C".equals(value)) {
                    ((IBillView)this.getView()).setBillStatus(BillOperationStatus.AUDIT);
                }
            }
        }
    }

    public void updateReferPrice() {
        DynamicObject obj = this.getModel().getDataEntity(true);
        SrcDemandUtils.updateReferPrice((DynamicObject)obj);
        this.getView().updateView("entryentity");
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        ExtPluginContext context = new ExtPluginContext();
        context.setView(this.getView());
        context.setHyperLinkClickEvent(evt);
        ExtPluginFactory.executeExtplugin((String)SrcPurListHyperlinkHandler.class.getSimpleName(), (ExtPluginContext)context, (boolean)true);
    }
}

