/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.formplugin.edit;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.SubEntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.BizLog;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.util.LowTimer;
import kd.scm.common.util.ParamUtil;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.common.util.cal.ICal;
import kd.scm.pds.common.enums.SrcNegotiatetypeEnums;
import kd.scm.pds.common.extplugin.ExtPluginContext;
import kd.scm.pds.common.extplugin.ExtPluginFactory;
import kd.scm.pds.common.util.ExtParameterUtils;
import kd.scm.pds.common.util.GridColorStyleData;
import kd.scm.pds.common.util.GridColorStyleUtils;
import kd.scm.pds.common.util.PdsBizNodeUtils;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.PdsOrderByUtils;
import kd.scm.pds.common.util.SrcCalImpl;
import kd.scm.pds.common.util.SupplierUtil;
import kd.scm.src.common.bizquery.ISrcReferPriceHandler;
import kd.scm.src.common.hyperlink.SrcPurListHyperlinkHandler;
import kd.scm.src.common.util.SrcDecisionUtil;
import kd.scm.src.common.util.SrcNegotiateUtil;
import kd.scm.src.common.util.SrcProjectUtil;
import kd.scm.src.common.util.SrcPurListUtil;
import kd.scm.src.common.util.SrcQuickPurUtil;

public class SrcPurListComptpEdit
extends AbstractBillPlugIn
implements BeforeF7SelectListener,
HyperLinkClickListener {
    private static Log log = LogFactory.getLog(SrcPurListComptpEdit.class);
    private ICal cal = new SrcCalImpl();

    public void initialize() {
        this.getView().getPageCache().put("BOS.setRowDataByNumberAutoAddRow", "false");
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.createDataByQuoTool();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit areaEdit = (BasedataEdit)this.getView().getControl("area");
        if (null != areaEdit) {
            areaEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        EntryGrid entry = (EntryGrid)this.getControl("entryentity");
        entry.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        if ("area".equals(beforeF7SelectEvent.getProperty().getName())) {
            this.setAreaSelect(beforeF7SelectEvent);
        }
    }

    private void setAreaSelect(BeforeF7SelectEvent beforeF7SelectEvent) {
        int row = beforeF7SelectEvent.getRow();
        DynamicObject districtObj = this.getModel().getEntryRowEntity("entryentity", row).getDynamicObject("district");
        if (districtObj == null) {
            return;
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        Boolean issrc = (Boolean)this.getModel().getValue("issrc");
        if (StringUtils.equals((CharSequence)"entryentity", (CharSequence)e.getEntryProp().getName()) && !issrc.booleanValue()) {
            int rowIndex = 0;
            RowDataEntity[] rowData = e.getRowDataEntities();
            for (int i = 0; i < rowData.length; ++i) {
                rowIndex = rowData[i].getRowIndex();
                this.getModel().setValue("isnew", (Object)Boolean.TRUE, rowIndex);
            }
        }
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        int[] rowIndexs;
        super.beforeDeleteRow(e);
        if (!StringUtils.equals((CharSequence)"entryentity", (CharSequence)e.getEntryProp().getName())) {
            return;
        }
        for (int index : rowIndexs = e.getRowIndexs()) {
            boolean isDecision = (Boolean)this.getModel().getValue("isdecision", index);
            if (!isDecision) continue;
            this.getView().showMessage(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u5220\u9664\u5df2\u5b9a\u6807\u5206\u5f55\u3002", (String)"SrcPurListComptpEdit_14", (String)"scm-src-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        if (SrcQuickPurUtil.isQuickPurchase((IFormView)this.getView(), Collections.singletonList("src_decision"))) {
            return;
        }
        Boolean issrc = (Boolean)this.getModel().getValue("issrc");
        for (int index : rowIndexs) {
            Boolean isnew = (Boolean)this.getModel().getValue("isnew", index);
            if (isnew.booleanValue() || issrc.booleanValue()) continue;
            this.getView().showMessage(ResManager.loadKDString((String)"\u4ec5\u80fd\u5220\u9664\u81ea\u5df1\u65b0\u589e\u7684\u6807\u7684\u3002", (String)"SrcPurListComptpEdit_0", (String)"scm-src-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        LowTimer timer = new LowTimer();
        this.setVisible();
        this.setIsSrc();
        this.setManagetype();
        this.setIsAdd();
        this.setIsOffLine();
        this.setCurr();
        Map params = this.getView().getFormShowParameter().getCustomParams();
        Object isFromQuoToolRefer = params.get("isFromQuoTool_refer");
        if (isFromQuoToolRefer != null) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"advcontoolbarap"});
        }
        BizLog.log((String)("###afterbinddata costtime:" + timer.msValue()));
        timer.reset();
        this.loadCompData();
        this.getModel().setDataChanged(false);
        BizLog.log((String)("###afterbinddata loadCompData costtime:" + timer.msValue()));
    }

    private void setIsOffLine() {
        IFormView parentView = this.getView().getParentView();
        if (parentView == null) {
            return;
        }
        DynamicObject data = parentView.getModel().getDataEntity();
        DynamicObject srcType = null;
        try {
            srcType = data.getDynamicObject("srctype");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (null == srcType) {
            return;
        }
        DynamicObject sourceClass = srcType.getDynamicObject("sourceclass");
        if (null == sourceClass) {
            return;
        }
        String srcClassNumber = sourceClass.getString("number");
        IDataModel model = this.getModel();
        if ("C011402".equals(srcClassNumber)) {
            model.setValue("negotiatetype", (Object)SrcNegotiatetypeEnums.OFFLINE_PURLIST.getValue());
            model.setValue("origin", (Object)"3");
        } else {
            model.setValue("negotiatetype", (Object)SrcNegotiatetypeEnums.ONLINE.getValue());
            model.setValue("origin", (Object)"1");
        }
    }

    private void setManagetype() {
        IFormView parentView = this.getView().getParentView();
        if (parentView == null) {
            return;
        }
        String parentEntityId = parentView.getEntityId();
        if ("src_purlist".equals(parentEntityId) || "src_project".equals(parentEntityId)) {
            Object managetype = parentView.getModel().getValue("managetype");
            this.getModel().setValue("managetype", managetype);
        } else {
            Object project = this.getModel().getValue("project");
            if (Objects.nonNull(project)) {
                String managetype = ((DynamicObject)project).getString("managetype");
                this.getModel().setValue("managetype", (Object)managetype);
            }
        }
    }

    private void setIsMultiPackage() {
        IFormView parentView = this.getView().getParentView();
        if (parentView == null) {
            return;
        }
        String entityId = parentView.getEntityId();
        if ("ide_formdesigner".equals(entityId)) {
            return;
        }
        DynamicObject parentObj = parentView.getModel().getDataEntity();
        if (("src_purlist".equals(entityId) || "src_project".equals(entityId)) && !BillStatusEnum.AUDIT.getVal().equals(parentObj.getString("billstatus"))) {
            Boolean isMultiPackage = Boolean.TRUE;
            this.getModel().setValue("ismultipackage", (Object)isMultiPackage);
            return;
        }
        IDataModel model = this.getModel();
        model.setValue("ismultipackage", (Object)Boolean.FALSE);
        try {
            if (Objects.equals("src_negotiatebill", entityId) || Objects.equals("tnd_tenderbill", entityId) || Objects.equals("tnd_quotebill", entityId)) {
                model.setValue("ismultipackage", (Object)parentObj.getBoolean("project.ismultipackage"));
            } else {
                model.setValue("ismultipackage", (Object)parentObj.getBoolean("ismultipackage"));
            }
        }
        catch (Exception e) {
            BizLog.log((String)("###setIsMultiPackage setValeException:" + e.getMessage()));
        }
    }

    public void setIsSrc() {
        IFormView parentView = this.getView().getParentView();
        if (parentView == null) {
            return;
        }
        String appId = parentView.getModel().getDataEntityType().getAppId();
        if (appId.equals("src")) {
            this.getModel().setValue("issrc", (Object)Boolean.TRUE);
        } else if (appId.equals("tnd")) {
            this.getModel().setValue("issrc", (Object)Boolean.FALSE);
        }
    }

    public void setIsAdd() {
        IFormView parentView = this.getView().getParentView();
        if (parentView == null) {
            return;
        }
        String entityId = parentView.getEntityId();
        if (entityId.equals("src_purlist") || entityId.equals("tnd_quotebill") || entityId.equals("tnd_tenderbill")) {
            Boolean isadd = (Boolean)parentView.getModel().getValue("isadd");
            this.getView().getModel().setValue("isadd", (Object)isadd);
        }
    }

    public void setCurr() {
        DynamicObject obj = this.getModel().getDataEntity(true);
        DynamicObjectCollection cols = obj.getDynamicObjectCollection("entryentity");
        for (int i = 0; i < cols.size(); ++i) {
            DynamicObject curr;
            DynamicObject col = (DynamicObject)cols.get(i);
            DynamicObject project = col.getDynamicObject("project");
            if (null == project || null == (curr = project.getDynamicObject("currency"))) continue;
            this.getModel().setValue("loccurr", curr.getPkValue(), i);
        }
    }

    protected void loadCompData() {
        log.info("SrcPurListComptpEdit start loadCompData.");
        IFormView parentView = this.getView().getParentView();
        if (null == parentView) {
            return;
        }
        String pageId = parentView.getPageId();
        parentView = SessionManager.getCurrent().getView(pageId);
        if (null == parentView) {
            return;
        }
        String entityKey = parentView.getEntityId();
        if (entityKey.equals("src_compare") || entityKey.equals("src_decision")) {
            BizLog.log((String)String.format(ResManager.loadKDString((String)"\u7236\u9875\u9762\u6807\u8bc6\uff1a%1$s", (String)"SrcPurListComptpEdit_12", (String)"scm-src-formplugin", (Object[])new Object[0]), entityKey));
        }
        DynamicObject templateDy = null;
        try {
            Object template = parentView.getModel().getValue("template");
            if (null == template || !(template instanceof DynamicObject)) {
                return;
            }
            templateDy = (DynamicObject)template;
        }
        catch (Exception e) {
            BizLog.log((String)ResManager.loadKDString((String)"\u7236\u9875\u9762\u5355\u636e\u6ca1\u6709\u6a21\u677f\u3002", (String)"SrcPurListComptpEdit_2", (String)"scm-src-formplugin", (Object[])new Object[0]));
            return;
        }
        if (!templateDy.getBoolean("isattachpurlist")) {
            return;
        }
        Long projectId = (Long)parentView.getModel().getDataEntity().getPkValue();
        if (projectId == 0L) {
            return;
        }
        Object[] projectIds = this.getProjectIds(parentView);
        StringBuilder logMsg = new StringBuilder();
        logMsg.append("SrcPurListComptpEdit projectIds:");
        logMsg.append(Arrays.toString(projectIds));
        log.info(logMsg.toString());
        String compKey = this.getView().getEntityId();
        this.setCompData(compKey, projectIds);
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"tieredadvconap"});
    }

    public void createDataByQuoTool() {
        Map params = this.getView().getFormShowParameter().getCustomParams();
        Object isFromQuoTool = params.get("isFromQuoTool");
        if (null == isFromQuoTool) {
            return;
        }
        IFormView parentView = this.getView().getParentView();
        if (null == parentView) {
            return;
        }
        String pageId = parentView.getPageId();
        IFormView view = SessionManager.getCurrent().getView(pageId);
        Object projectId = view.getModel().getValue("projectid");
        String compKey = this.getView().getEntityId();
        this.setCompData(compKey, projectId);
    }

    private void setCompData(String compKey, Object[] parentIds) {
        EntryGrid entryGrid;
        IFormView view = this.getView();
        if (null == view) {
            return;
        }
        AbstractFormDataModel model = (AbstractFormDataModel)view.getModel();
        String entryKey = this.getCompEntryKey(compKey);
        if (!SrcPurListComptpEdit.getShowPurlistInfoBill().contains(view.getParentView().getEntityId())) {
            DynamicObject billObj = view.getParentView().getModel().getDataEntity(true);
            long sourceFlowId = SrmCommonUtil.getPkValue((DynamicObject)view.getParentView().getModel().getDataEntity(true).getDynamicObject("srctype"));
            boolean isShowPurlistInfoBeforeBizOpe = ExtParameterUtils.convertToBoolen((Object)ExtParameterUtils.getExtParameterValueById((String)"pds_flowconfig", (long)sourceFlowId, (String)"isShowPurlistInfoBeforeBizOpe", (Object)false, (long)SrmCommonUtil.getPkValue((DynamicObject)billObj)));
            if (isShowPurlistInfoBeforeBizOpe && !this.hasBizOpen(parentIds)) {
                return;
            }
            model.deleteEntryData(entryKey);
        }
        if (null == (entryGrid = (EntryGrid)view.getControl(entryKey))) {
            return;
        }
        List properties = DynamicObjectUtil.getContainerProperties((Container)entryGrid);
        TableValueSetter ts = new TableValueSetter(new String[0]);
        int i = 0;
        Map<String, DynamicObject> entryId_entryMap = this.getComponetDataMap(compKey, parentIds);
        if (null == entryId_entryMap) {
            entryId_entryMap = new HashMap<String, DynamicObject>(1);
        }
        assert (null != entryId_entryMap);
        for (Map.Entry<String, DynamicObject> entryMap : entryId_entryMap.entrySet()) {
            DynamicObject col = entryMap.getValue();
            if (null == col) continue;
            SrcPurListUtil.setCompData((TableValueSetter)ts, entryMap, (List)properties, (int)i);
            ++i;
        }
        log.info("SrcPurListComptpEdit loadDataSize:" + ts.getCount());
        model.beginInit();
        model.batchCreateNewEntryRow(entryKey, ts);
        model.endInit();
        this.getView().updateView(entryKey);
        this.setSubEntryGridData(entryId_entryMap, entryGrid, ts.getCount());
        if (!compKey.equals("src_purlist_item")) {
            // empty if block
        }
    }

    private static Set<String> getShowPurlistInfoBill() {
        HashSet<String> billSet = new HashSet<String>(8);
        billSet.add("tnd_project");
        billSet.add("tnd_tenderbill");
        billSet.add("tnd_quotebill");
        return billSet;
    }

    public void setSubEntryGridData(Map<String, DynamicObject> entryId_entryMap, EntryGrid entryGrid, int rowCount) {
        List subEntryKeyList = entryGrid.getSubEntryGrids();
        StringBuilder logMsg = new StringBuilder();
        for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
            Object srcEntryId = this.getModel().getValue("srcentryid", rowIndex);
            DynamicObject rowObj = entryId_entryMap.get(String.valueOf(srcEntryId));
            entryGrid.selectRows(rowIndex);
            if (null == rowObj) continue;
            for (String subEntryKey : subEntryKeyList) {
                DynamicObjectCollection subEntryCols = rowObj.getDynamicObjectCollection(subEntryKey);
                if (subEntryCols.size() == 0) continue;
                this.setSubVal(subEntryKey, subEntryCols, logMsg);
            }
        }
        log.info(logMsg.length() == 0 ? "###set subVal:" : logMsg.toString());
        entryGrid.selectRows(-1);
    }

    private void setSubVal(String subEntryKey, DynamicObjectCollection subEntryCols, StringBuilder logMsg) {
        SubEntryGrid subEntryGrid = (SubEntryGrid)this.getControl(subEntryKey);
        List subProperties = DynamicObjectUtil.getContainerProperties((Container)subEntryGrid);
        TableValueSetter ts = new TableValueSetter(new String[0]);
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.deleteEntryData(subEntryKey);
        for (int index = 0; index < subEntryCols.size(); ++index) {
            DynamicObject subCol = (DynamicObject)subEntryCols.get(index);
            for (String pro : subProperties) {
                DynamicProperty property = subCol.getDynamicObjectType().getProperty(pro);
                if (null == property) continue;
                try {
                    Object proVal = subCol.get(pro);
                    if (proVal instanceof DynamicObject) {
                        ts.set(pro, ((DynamicObject)proVal).getPkValue(), index);
                        continue;
                    }
                    ts.set(pro, proVal, index);
                }
                catch (Exception e) {
                    logMsg.append("###set property exception\uff1a").append(e.getMessage()).append('\uff1b');
                }
            }
        }
        model.beginInit();
        model.batchCreateNewEntryRow(subEntryKey, ts);
        model.endInit();
        this.getView().updateView(subEntryKey);
    }

    public boolean hasBizOpen(Object[] projectIds) {
        if (projectIds.length > 1) {
            return true;
        }
        return SrcProjectUtil.hasBizOpen((Object)projectIds[0]);
    }

    public void setGridColor(Set<String> purlistIds) {
        GridColorStyleData styleData = new GridColorStyleData();
        styleData.setView(this.getView());
        styleData.setEntryName("entryentity");
        styleData.setFieldName("purlist");
        styleData.setCondition(purlistIds);
        styleData.setBackColor("#eaebef");
        GridColorStyleUtils.setGridRowColor((GridColorStyleData)styleData);
    }

    private String getCompEntryKey(String compKey) {
        if ("src_purlist_item".equals(compKey)) {
            return "itementity";
        }
        return "entryentity";
    }

    private void setCompData(String compKey, Object parentId) {
        this.setCompData(compKey, new Object[]{parentId});
    }

    private Map<String, DynamicObject> getComponetDataMap(String compKey, Object[] parentIds) {
        Object entityId;
        QFilter filter = null;
        IFormView parentView = this.getView().getParentView();
        if (parentView == null) {
            return null;
        }
        List<Object> entryIDList = new ArrayList();
        List<Object> compIDList = new ArrayList();
        String entryKey = this.getCompEntryKey(compKey);
        if ("src_purlist_item".equals(compKey)) {
            filter = new QFilter(entryKey + "." + "itemproject", "in", (Object)parentIds);
            List<Long> supIdList = null;
            entityId = this.getView().getParentView().getEntityId();
            supIdList = ((String)entityId).equals("tnd_project") ? PdsCommonUtils.getSupplierByUserOfBizPartner() : this.getIsTenderSupplierList(parentIds);
            String supType = SupplierUtil.getSupType(null);
            if ("src_supplier".equals(supType)) {
                DynamicObject decCols = BusinessDataServiceHelper.loadSingle((String)supType, (String)"id", (QFilter[])new QFilter[]{new QFilter("supplier.id", "in", supIdList)});
                filter.and(entryKey + "." + "itemsupplier", "=", decCols.get("id"));
            } else if ("bd_supplier".equals(supType)) {
                filter.and(entryKey + "." + "itemsupplier", "in", supIdList);
            }
        } else {
            DynamicObjectCollection purListF7Cols = this.getPurListF7Data(compKey, parentIds);
            if (null != purListF7Cols) {
                entryIDList = purListF7Cols.stream().map(obj -> obj.getLong("entryid")).collect(Collectors.toList());
                compIDList = purListF7Cols.stream().map(obj -> obj.getLong("billid")).collect(Collectors.toList());
            }
            filter = new QFilter("entitykey", "=", (Object)compKey);
            filter.and(entryKey + "." + "id", "in", entryIDList);
        }
        LinkedHashMap<String, DynamicObject> entryId_objMap = new LinkedHashMap<String, DynamicObject>(entryIDList.size());
        entityId = entryIDList.iterator();
        while (entityId.hasNext()) {
            long entryId = (Long)entityId.next();
            entryId_objMap.put(String.valueOf(entryId), null);
        }
        DynamicObject[] objs = null;
        if (compIDList.size() > 0) {
            DynamicObject newCompObj = BusinessDataServiceHelper.newDynamicObject((String)compKey);
            objs = BusinessDataServiceHelper.load((Object[])compIDList.toArray(new Object[0]), (DynamicObjectType)newCompObj.getDynamicObjectType());
        } else {
            String selectFields = DynamicObjectUtil.getSelectfields((String)compKey, (boolean)false);
            selectFields = DynamicObjectUtil.getEntrySelectfields((String)selectFields, (String)compKey, (String)entryKey, (boolean)false);
            StringBuilder msg = new StringBuilder();
            msg.append("getComponetDataMap filter:");
            msg.append(filter);
            log.info(msg.toString());
            objs = BusinessDataServiceHelper.load((String)compKey, (String)selectFields, (QFilter[])filter.toArray());
        }
        for (DynamicObject obj2 : objs) {
            String entityKey = obj2.getString("entitykey");
            if (!entityKey.equals(compKey)) continue;
            DynamicObjectCollection entryCols = obj2.getDynamicObjectCollection(entryKey);
            for (DynamicObject entryCol : entryCols) {
                String entryId = String.valueOf(entryCol.getPkValue());
                if (!entryIDList.contains(Long.valueOf(entryId)) && !"src_purlist_item".equals(compKey)) continue;
                entryId_objMap.put(entryId, entryCol);
            }
        }
        return entryId_objMap;
    }

    protected List<Long> getIsTenderSupplierList(Object[] parentIds) {
        QFilter bidOpenSupFilter = new QFilter("billid", "in", (Object)parentIds);
        bidOpenSupFilter.and("istender", "=", (Object)"1");
        DynamicObjectCollection bidOpenSupCols = QueryServiceHelper.query((String)"src_bidopensupplier", (String)"suppliertype,supplier,istender", (QFilter[])bidOpenSupFilter.toArray());
        List<Long> tenderSupList = bidOpenSupCols.stream().filter(col -> col.getBoolean("istender")).map(col -> col.getLong("supplier")).collect(Collectors.toList());
        return tenderSupList;
    }

    private DynamicObjectCollection getPurListF7Data(String compKey, Object[] parentIds) {
        QFilter filter = new QFilter("project", "in", (Object)parentIds);
        String userType = RequestContext.get().getUserType();
        if (null != userType && userType.contains("3")) {
            IFormView parentView = this.getView().getParentView();
            if (null != parentView) {
                boolean isExists;
                String parentEntityKey = parentView.getEntityId();
                boolean isSupplier = true;
                if (userType.contains("1") && !(isExists = PdsBizNodeUtils.isSupplierNode((String)parentEntityKey))) {
                    isSupplier = false;
                }
                if (isSupplier) {
                    String supType = SupplierUtil.getSupType(null);
                    String supFilterPro = SupplierUtil.getSupProBySupType((String)supType);
                    ArrayList<String> entryStatusList = new ArrayList<String>();
                    if ("tnd_apply".equals(parentEntityKey)) {
                        entryStatusList.add("A");
                        filter.and("entrystatus", "in", entryStatusList);
                        filter.and(supFilterPro, "=", (Object)0L);
                    } else {
                        filter.and(SupplierUtil.getRegistSupFilterByCurrUserId());
                        filter.and("entrystatus", "not in", entryStatusList);
                    }
                } else {
                    filter.and("entrystatus", "=", (Object)"C");
                }
            }
        } else {
            filter.and("entrystatus", "=", (Object)"C");
        }
        StringBuilder selectFieldsSb = new StringBuilder();
        selectFieldsSb.append("entryid").append(',').append("billid");
        String orderBy = PdsOrderByUtils.getOrderByString((String)"orderby001");
        DynamicObjectCollection cols = QueryServiceHelper.query((String)"src_purlistf7", (String)selectFieldsSb.toString(), (QFilter[])new QFilter[]{filter}, (String)orderBy);
        return cols;
    }

    private Object[] getProjectIds(IFormView view) {
        Long projectId = (Long)view.getModel().getDataEntity().getPkValue();
        return new Object[]{projectId};
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        LowTimer timer = new LowTimer();
        this.setHeadData();
        this.setIsMultiPackage();
        BizLog.log((String)("###beforebinddata costtime:" + timer.msValue()));
    }

    private void setHeadData() {
        IFormView parentView = this.getView().getParentView();
        if (parentView == null) {
            return;
        }
        Map params = this.getView().getFormShowParameter().getCustomParams();
        Object isFromQuoTool = params.get("isFromQuoTool");
        Object pkVal = null;
        String entityKey = parentView.getEntityId();
        pkVal = null != isFromQuoTool ? parentView.getModel().getValue("projectid") : ("tnd_quotebill".equals(entityKey) || "tnd_tenderbill".equals(entityKey) || "tnd_negotiatebill".equals(entityKey) ? Long.valueOf(SrmCommonUtil.getPkValue((DynamicObject)parentView.getModel().getDataEntity().getDynamicObject("project"))) : parentView.getModel().getDataEntity().getPkValue());
        if (null == pkVal) {
            return;
        }
        QFilter filter = new QFilter("id", "=", (Object)Long.parseLong(pkVal.toString()));
        DynamicObject projectObj = QueryServiceHelper.queryOne((String)"src_project_base", (String)"currency,taxtype", (QFilter[])new QFilter[]{filter});
        if (null == projectObj) {
            return;
        }
        IDataModel model = this.getModel();
        model.setValue("curr", projectObj.get("currency"));
        model.setValue("orderratioresult", (Object)PdsCommonUtils.object2String((Object)ParamUtil.getParamObj((String)"0DUM2+6E41IA", (String)"orderratio"), (String)"1"));
    }

    public void setCategorySelect(BeforeF7SelectEvent beforeF7SelectEvent, DynamicObject sourceObj) {
        ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter().getShowParameter();
        QFilter qFilter = new QFilter("id", "=", sourceObj.get("entryentitynotyear.category2.id")).or(new QFilter("id", "=", sourceObj.get("entryentityyear.category3.id")));
        showParameter.getListFilterParameter().setFilter(qFilter);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String calByImport;
        List<String> calProList;
        super.propertyChanged(e);
        if (Objects.equals(e.getProperty().getParent().getName(), "subentryentity")) {
            return;
        }
        String propertyName = e.getProperty().getName();
        IDataModel model = this.getModel();
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        int currRowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
        if (rowIndex >= 0 && currRowIndex != rowIndex && (calProList = this.getCalProList()).contains(propertyName)) {
            EntryGrid grid = (EntryGrid)this.getControl("entryentity");
            grid.selectRows(rowIndex, true);
        }
        if (null == (calByImport = this.getPageCache().get("purlist_cal_by_import"))) {
            this.cal.proChanged(model, "entryentity", propertyName);
        }
    }

    private List<String> getCalProList() {
        ArrayList<String> calProList = new ArrayList<String>();
        calProList.add("price_uom");
        calProList.add("currency");
        calProList.add("price");
        calProList.add("taxprice");
        calProList.add("actprice");
        calProList.add("acttaxprice");
        calProList.add("amount");
        calProList.add("taxamount");
        calProList.add("tax");
        calProList.add("dctrate");
        calProList.add("dctamount");
        calProList.add("taxrate");
        calProList.add("qty");
        return calProList;
    }

    private void setVisible() {
        IFormView view = this.getView();
        IFormView parentView = view.getParentView();
        if (parentView == null) {
            return;
        }
        String formId = parentView.getFormShowParameter().getFormId();
        long parentId = this.getModel().getDataEntity().getLong("parentid");
        DynamicObject parentData = parentView.getModel().getDataEntity();
        view.setVisible(Boolean.valueOf(false), new String[]{"addnegbill"});
        view.setVisible(Boolean.valueOf(false), new String[]{"viewnegbill"});
        switch (formId) {
            case "src_compare": 
            case "src_compete": {
                view.setVisible(Boolean.FALSE, new String[]{"addentry", "deleteentry", "copyentryrow", "advconbaritemap1", "import", "importdata", "exporttpl"});
                if (SrcNegotiateUtil.isAudit((long)parentId, (String)formId)) break;
                view.setVisible(Boolean.valueOf(true), new String[]{"addnegbill"});
                view.setVisible(Boolean.valueOf(true), new String[]{"viewnegbill"});
                break;
            }
            case "src_scorertask": {
                if (SrcNegotiateUtil.isAudit((long)parentId, (String)formId)) break;
                view.setVisible(Boolean.valueOf(true), new String[]{"addnegbill"});
                view.setVisible(Boolean.valueOf(true), new String[]{"viewnegbill"});
                break;
            }
            case "src_predecision": {
                view.setVisible(Boolean.FALSE, new String[]{"addentry", "deleteentry", "copyentryrow", "advconbaritemap1", "import", "importdata", "exporttpl"});
                String sourceclass = parentView.getModel().getDataEntity().getString("sourceclass.number");
                if ("C011402".equals(sourceclass)) {
                    return;
                }
                if (SrcNegotiateUtil.isAudit((long)parentId, (String)formId)) break;
                view.setVisible(Boolean.valueOf(true), new String[]{"addnegbill"});
                view.setVisible(Boolean.valueOf(true), new String[]{"viewnegbill"});
                break;
            }
            case "src_decision": {
                if (SrcQuickPurUtil.isPublicQuickPurchase((IFormView)this.getView())) {
                    view.setVisible(Boolean.valueOf(true), new String[]{"deleteentry"});
                } else {
                    view.setVisible(Boolean.valueOf(false), new String[]{"deleteentry"});
                }
                String sourceclass = parentView.getModel().getDataEntity().getString("sourceclass.number");
                if ("C011402".equals(sourceclass)) {
                    return;
                }
                if (SrcDecisionUtil.isDecisionConfirm((DynamicObject)this.getModel().getDataEntity(), (boolean)true)) {
                    if (!parentView.getModel().getDataEntity().getBoolean("srctype.isnegotiable")) break;
                    view.setVisible(Boolean.valueOf(true), new String[]{"addnegbill"});
                    view.setVisible(Boolean.valueOf(true), new String[]{"viewnegbill"});
                    break;
                }
                view.setVisible(Boolean.valueOf(true), new String[]{"addnegbill"});
                view.setVisible(Boolean.valueOf(true), new String[]{"viewnegbill"});
                break;
            }
            case "src_negotiatebill": {
                view.setVisible(Boolean.FALSE, new String[]{"addentry", "copyentryrow", "advconbaritemap1", "import", "exporttpl"});
                view.setVisible(Boolean.TRUE, new String[]{"historyprice", "historytaxprice", "preamount", "pretaxamount"});
                String negotiateType = parentData.getString("negotiatetype");
                if (!StringUtils.equals((CharSequence)SrcNegotiatetypeEnums.ONLINE.getValue(), (CharSequence)negotiateType) && !StringUtils.equals((CharSequence)SrcNegotiatetypeEnums.ONLINE_VIE.getValue(), (CharSequence)negotiateType)) break;
                view.setVisible(Boolean.FALSE, new String[]{"importdata"});
                break;
            }
            case "tnd_quotebill": {
                view.setVisible(Boolean.TRUE, new String[]{"historyprice", "historytaxprice", "preamount", "pretaxamount"});
                String billStatus = parentData.getString("billstatus");
                if (!StringUtils.equals((CharSequence)"C", (CharSequence)billStatus)) break;
                view.setVisible(Boolean.FALSE, new String[]{"importdata", "exporttpl"});
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs beforeDoOperation) {
        super.beforeDoOperation(beforeDoOperation);
        IFormView parentView = this.getView().getParentView();
        if (parentView == null) {
            return;
        }
        String operateKey = ((AbstractOperate)beforeDoOperation.getSource()).getOperateKey();
        if ("submit".equals(operateKey) || "save".equals(operateKey)) {
            this.deleteInvalidRows(this.getModel().getDataEntity(true));
            if ("src_project".equals(parentView.getEntityId()) || "src_purlist".equals(parentView.getEntityId())) {
                this.updateReferPrice();
            }
            String pageId = parentView.getPageId();
            parentView = SessionManager.getCurrent().getView(pageId);
            if (null == parentView) {
                return;
            }
            if ("submit".equals(operateKey)) {
                String compEntityKey = this.getView().getEntityId();
                Boolean isNull = this.checkListEntry();
                Boolean isCheck = Boolean.FALSE;
                String entityKey = parentView.getEntityId();
                if ("src_purlist".equals(entityKey)) {
                    isCheck = Boolean.TRUE;
                }
                if (isNull.booleanValue() && !"src_purlist_item".equals(compEntityKey) && isCheck.booleanValue()) {
                    beforeDoOperation.setCancelMessage(String.format(ResManager.loadKDString((String)"%1$s\u672a\u586b\u5199\u5185\u5bb9\u3002", (String)"SrcPurListComptpEdit_13", (String)"scm-src-formplugin", (Object[])new Object[0]), PdsCommonUtils.getShowCompTitle((String)entityKey, (String)this.getView().getEntityId(), null)));
                    beforeDoOperation.setCancel(true);
                    return;
                }
                if (isCheck.booleanValue()) {
                    this.validDataBySourceList(beforeDoOperation);
                }
            }
        }
    }

    protected Boolean checkListEntry() {
        DynamicObjectCollection rows = this.getModel().getEntryEntity("entryentity");
        if (null == rows || rows.size() == 0) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    protected boolean validDataBySourceList(BeforeDoOperationEventArgs beforeDoOperation) {
        IFormView parentView = this.getView().getParentView();
        if (null == parentView) {
            return true;
        }
        DynamicObject obj = parentView.getModel().getDataEntity();
        boolean isSourceSup = obj.getBoolean("issourcesupplier");
        if (!isSourceSup) {
            return true;
        }
        DynamicObjectCollection rows = this.getModel().getEntryEntity("entryentity");
        HashSet<Long> matrialIdSet = new HashSet<Long>();
        HashMap<Long, DynamicObject> matId_matObjMap = new HashMap<Long, DynamicObject>();
        for (DynamicObject row : rows) {
            DynamicObject material = row.getDynamicObject("material");
            if (null == material) {
                beforeDoOperation.setCancel(true);
                beforeDoOperation.setCancelMessage(ResManager.loadKDString((String)"\u6309\u8d27\u6e90\u6e05\u5355\u53d6\u4f9b\u5e94\u5546\u6807\u7684\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SrcPurListComptpEdit_4", (String)"scm-src-formplugin", (Object[])new Object[0]));
                return false;
            }
            matrialIdSet.add(material.getLong("id"));
            matId_matObjMap.put(material.getLong("id"), material);
        }
        List dataList = SrcPurListUtil.getPmSourceListData((DynamicObject)obj, matrialIdSet);
        StringBuilder cancleMsg = new StringBuilder();
        if (dataList.size() == 0) {
            cancleMsg.append(ResManager.loadKDString((String)"\u5168\u90e8\u6807\u7684\u6ca1\u6709\u53d6\u5230\u8d27\u6e90\u6e05\u5355\u4f9b\u5e94\u5546\u3002", (String)"SrcPurListComptpEdit_5", (String)"scm-src-formplugin", (Object[])new Object[0]));
        } else {
            for (Map dataMap : dataList) {
                long matId;
                DynamicObject material;
                Object supplierId = dataMap.get("supplierId");
                if (supplierId instanceof Long || null == (material = (DynamicObject)matId_matObjMap.get(matId = ((Long)dataMap.get("materialId")).longValue()))) continue;
                cancleMsg.append(String.format(ResManager.loadKDString((String)"\u6807\u7684%s\u6ca1\u6709\u53d6\u5230\u8d27\u6e90\u6e05\u5355\u4f9b\u5e94\u5546\u3002", (String)"SrcPurListComptpEdit_15", (String)"scm-src-formplugin", (Object[])new Object[0]), material.getString("name")));
                cancleMsg.append('\n');
            }
        }
        if (cancleMsg.length() > 0) {
            beforeDoOperation.setCancel(true);
            beforeDoOperation.setCancelMessage(cancleMsg.toString());
            return false;
        }
        return true;
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        super.afterDoOperation(args);
        block5 : switch (operateKey = args.getOperateKey()) {
            case "submit": {
                OperationResult operationResult = args.getOperationResult();
                if (!operationResult.isSuccess()) {
                    return;
                }
                String compKey = this.getView().getEntityId();
                DynamicObject billObj = this.getModel().getDataEntity(true);
                DynamicObjectCollection rows = billObj.getDynamicObjectCollection("entryentity");
                for (DynamicObject row : rows) {
                    row.set("compkey", (Object)compKey);
                }
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{billObj});
                break;
            }
            case "addnegotiate": {
                IFormView parentView = this.getView().getParentView();
                if (parentView == null) {
                    return;
                }
                DynamicObject project = (DynamicObject)parentView.getModel().getValue("project");
                String projectId = project.getString("id");
                this.openNewPage("src_compare", this.getView(), projectId);
                break;
            }
            case "batchfillentry": {
                String entryCurrentFieldKey;
                switch (entryCurrentFieldKey = this.getModel().getEntryCurrentFieldKey("entryentity")) {
                    case "material": {
                        this.checkMaterialAndCategory();
                        this.checkMaterialAndUnit();
                        break block5;
                    }
                    case "category": {
                        this.checkMaterialAndCategory();
                        break block5;
                    }
                    case "unit": {
                        this.checkMaterialAndUnit();
                        break block5;
                    }
                }
                break;
            }
        }
    }

    private void checkMaterialAndUnit() {
        DynamicObjectCollection entryEntity = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        StringBuffer stringBuffer = new StringBuffer();
        int i = 1;
        for (DynamicObject dynamicObject : entryEntity) {
            String categoryNumber;
            if (dynamicObject.getDynamicObject("material") == null || dynamicObject.getDynamicObject("unit") == null) {
                ++i;
                continue;
            }
            String categoryNumberByMaterial = dynamicObject.getString("material.baseunit.number");
            if (StringUtils.equals((CharSequence)categoryNumberByMaterial, (CharSequence)(categoryNumber = dynamicObject.getString("unit.number")))) {
                ++i;
                continue;
            }
            this.getModel().setValue("unit", null, i - 1);
            stringBuffer.append(MessageFormat.format(ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7269\u6599\u548c\u8ba1\u91cf\u5355\u4f4d\u5173\u7cfb\u4e0d\u5408\u6cd5\u3002", (String)"SrcPurListComptpEdit_10", (String)"scm-src-formplugin", (Object[])new Object[0]), i)).append('\n');
            ++i;
        }
        if (stringBuffer.length() > 0) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u5b57\u6bb5\u5173\u7cfb\u4e0d\u5408\u6cd5\u3002", (String)"SrcPurListComptpEdit_9", (String)"scm-src-formplugin", (Object[])new Object[0]), String.valueOf(stringBuffer), MessageTypes.Default);
        }
    }

    private void checkMaterialAndCategory() {
        DynamicObjectCollection entryEntity = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        StringBuffer stringBuffer = new StringBuffer();
        int i = 1;
        for (DynamicObject dynamicObject : entryEntity) {
            String categoryNumber;
            if (dynamicObject.getDynamicObject("material") == null || dynamicObject.getDynamicObject("category") == null) {
                ++i;
                continue;
            }
            String categoryNumberByMaterial = dynamicObject.getString("material.group.number");
            if (StringUtils.equals((CharSequence)categoryNumberByMaterial, (CharSequence)(categoryNumber = dynamicObject.getString("category.number")))) {
                ++i;
                continue;
            }
            this.getModel().setValue("category", null, i - 1);
            stringBuffer.append(MessageFormat.format(ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7269\u6599\u548c\u54c1\u7c7b\u5173\u7cfb\u4e0d\u5408\u6cd5\u3002", (String)"SrcPurListComptpEdit_11", (String)"scm-src-formplugin", (Object[])new Object[0]), i)).append('\n');
            ++i;
        }
        if (stringBuffer.length() > 0) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u5b57\u6bb5\u5173\u7cfb\u4e0d\u5408\u6cd5\u3002", (String)"SrcPurListComptpEdit_9", (String)"scm-src-formplugin", (Object[])new Object[0]), String.valueOf(stringBuffer), MessageTypes.Default);
        }
    }

    private void openNewPage(String FormId, IFormView view, String PkId) {
        BillShowParameter formshowParameter = new BillShowParameter();
        if (StringUtils.isNotBlank((CharSequence)PkId)) {
            formshowParameter.setPkId((Object)PkId);
        }
        formshowParameter.setFormId(FormId);
        formshowParameter.getOpenStyle().setShowType(ShowType.NewWindow);
        formshowParameter.setStatus(OperationStatus.EDIT);
        view.showForm((FormShowParameter)formshowParameter);
    }

    private void deleteInvalidRows(DynamicObject billObj) {
        DynamicObjectCollection rows = billObj.getDynamicObjectCollection("entryentity");
        if (rows == null || rows.size() == 0) {
            return;
        }
        Iterator ite = rows.iterator();
        while (ite.hasNext()) {
            DynamicObject obj = (DynamicObject)ite.next();
            if (obj.getString("materialnane") != null && !"".equals(obj.getString("materialnane").trim())) continue;
            ite.remove();
        }
        this.getView().updateView("entryentity");
    }

    public void updateReferPrice() {
        ExtPluginContext context = new ExtPluginContext();
        context.setView(this.getView());
        context.setRows((DynamicObject[])this.getModel().getEntryEntity("entryentity").toArray((Object[])new DynamicObject[0]));
        context.getParamMap().put("currency", this.getModel().getDataEntity().getLong("curr.id"));
        context.getParamMap().put("fieldnamecurrency", "curr.id");
        context.getParamMap().put("fieldnamematerial", "material.id");
        context.getParamMap().put("fieldnameunit", "unit.id");
        ExtPluginFactory.executeExtplugin((String)(ISrcReferPriceHandler.class.getSimpleName() + "_purlist"), (ExtPluginContext)context, (boolean)false);
        this.getView().updateView("entryentity");
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        ExtPluginContext context = new ExtPluginContext();
        context.setView(this.getView());
        context.setHyperLinkClickEvent(evt);
        ExtPluginFactory.executeExtplugin((String)SrcPurListHyperlinkHandler.class.getSimpleName(), (ExtPluginContext)context, (boolean)true);
    }
}

