/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.opplugin.enroll;

import java.util.ArrayList;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.scm.pds.common.enroll.IPdsEnrollHandler;
import kd.scm.pds.common.enroll.PdsEnrollContext;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.SupplierUtil;
import kd.scm.src.common.util.SrcPurListUtil;

public class SrcTenderSupplierHandler
implements IPdsEnrollHandler {
    private static final long serialVersionUID = 1L;

    public void process(PdsEnrollContext context) {
        if (context.isAutoPublish() && context.isSucced()) {
            this.createTenderSupplier(context);
        }
    }

    protected void createTenderSupplier(PdsEnrollContext context) {
        ArrayList supplierList = new ArrayList(8);
        if (null == context.getSelectSupplierList() || context.getSelectSupplierList().size() == 0) {
            return;
        }
        Set entryIds = context.getSelectSupplierList().stream().map(e -> e.getLong("id")).collect(Collectors.toSet());
        DynamicObjectCollection entryCols = SupplierUtil.reloadSupplierCollection((String)"src_supplierinvite", entryIds);
        SrcPurListUtil.createTenderSupEntry((DynamicObject)context.getProjectObj(), (DynamicObjectCollection)entryCols, supplierList);
        if (null == supplierList || supplierList.size() == 0) {
            this.logErrorMessage(context, null, "Tender supplierList is null");
            return;
        }
        try {
            PdsCommonUtils.saveDynamicObjects(supplierList);
        }
        catch (Exception e2) {
            this.logErrorMessage(context, e2, null);
        }
    }
}

