/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.bidopen.bidopencomm;

import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.enums.PdsBizNodeEnums;
import kd.scm.pds.common.util.PdsFlowConfigUtils;
import kd.scm.src.common.bidopen.ISrcBidOpenHandler;
import kd.scm.src.common.bidopen.SrcBidOpenContext;

public class SrcBidOpenBizHandle
implements ISrcBidOpenHandler {
    private static final long serialVersionUID = 1L;

    public void process(SrcBidOpenContext context) {
        this.handleBizBid(context);
    }

    protected void handleBizBid(SrcBidOpenContext context) {
        IFormView view = context.getView();
        String openType = context.getOpenType();
        DynamicObject row = context.getRow();
        List bizList = context.getBizList();
        List supList = context.getSupList();
        StringBuilder sb = context.getSb();
        DynamicObject[] packageObjs = context.getPackageObjs();
        switch (openType) {
            case "1": {
                if (row.getBoolean("isbizopen")) break;
                this.setBizBid(context, view, row, bizList, sb, packageObjs, supList);
                break;
            }
            case "2": {
                if (context.isOpenBySupplier()) {
                    if (!row.getBoolean("istecopen") || row.getBoolean("isbizopen")) break;
                    this.setBizBid(context, view, row, bizList, sb, packageObjs, supList);
                    break;
                }
                if (!row.getBoolean("istecassess") || row.getBoolean("isbizopen")) break;
                this.setBizBid(context, view, row, bizList, sb, packageObjs, supList);
                break;
            }
            case "3": 
            case "4": {
                if (row.getBoolean("isbizopen")) break;
                this.setBizBid(context, view, row, bizList, sb, packageObjs, supList);
                break;
            }
            default: {
                if (row.getBoolean("isbizopen")) break;
                this.setBizBid(context, view, row, bizList, sb, packageObjs, supList);
            }
        }
    }

    protected void setBizBid(SrcBidOpenContext context, IFormView view, DynamicObject row, List<Long> bizList, StringBuilder sb, DynamicObject[] packageObjs, List<Long> supList) {
        boolean isNeedOpenBiz = false;
        DynamicObject projectObj = view.getModel().getDataEntity(true);
        if (PdsFlowConfigUtils.existsSpecificNode((DynamicObject)projectObj, (String)PdsBizNodeEnums.COMPARE.getValue())) {
            isNeedOpenBiz = true;
        } else if (PdsFlowConfigUtils.existsSpecificNode((DynamicObject)projectObj, (String)PdsBizNodeEnums.SCORERTASK.getValue())) {
            isNeedOpenBiz = true;
        }
        for (DynamicObject packageObj : packageObjs) {
            Object pkId;
            Object object = pkId = context.isOpenBySupplier() ? Long.valueOf(row.getLong("srcentryid")) : row.getPkValue();
            if (!packageObj.getPkValue().equals(pkId)) continue;
            packageObj.set("isbizopen", (Object)"1");
            packageObj.set("bizopendate", (Object)TimeServiceHelper.now());
            packageObj.set("bizopenuser", (Object)RequestContext.get().getCurrUserId());
            if (row.getDynamicObject("package") == null) continue;
            if (isNeedOpenBiz) {
                if (context.isOpenBySupplier()) {
                    sb.append(String.format(ResManager.loadKDString((String)"\u4f9b\u5e94\u5546(%s)\u5c06\u5f00\u5546\u52a1\u6807,", (String)"SrcBidOpenBizHandle_9", (String)"scm-src-common", (Object[])new Object[0]), row.getString("supplier.name")));
                } else if (((Boolean)view.getModel().getValue("ismultipackage")).booleanValue()) {
                    sb.append(String.format(ResManager.loadKDString((String)"\u6807\u6bb5(%s)\u5c06\u5f00\u5546\u52a1\u6807,", (String)"SrcBidOpenBizHandle_10", (String)"scm-src-common", (Object[])new Object[0]), row.getDynamicObject("package").getString("packagename")));
                } else {
                    sb.append(String.format(ResManager.loadKDString((String)"\u9879\u76ee(%s)\u5c06\u5f00\u5546\u52a1\u6807,", (String)"SrcBidOpenBizHandle_11", (String)"scm-src-common", (Object[])new Object[0]), view.getModel().getDataEntity().getString("bidname")));
                }
            }
            bizList.add(SrmCommonUtil.getPkValue((DynamicObject)row.getDynamicObject("package")));
            if (!context.isOpenBySupplier()) continue;
            supList.add(SrmCommonUtil.getPkValue((DynamicObject)row.getDynamicObject("supplier")));
        }
    }
}

