/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.calc.rank;

import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.enums.ResultStatusEnums;
import kd.scm.pds.common.extfilter.ExtFilterUtils;
import kd.scm.pds.common.util.ExtParameterUtils;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.src.common.calc.SrcCalcContext;
import kd.scm.src.common.calc.rank.ISrcRankCoreCalc;

public class SrcRankCalcRecommendUnPass
implements ISrcRankCoreCalc {
    private static final long serialVersionUID = 1L;

    public void process(SrcCalcContext context) {
        if (ExtFilterUtils.isMatchSourceTypeAndSourceFlow((Object)context, (String)SrcRankCalcRecommendUnPass.class.getName(), (String)ISrcRankCoreCalc.class.getSimpleName()) && "3".equals(context.getSumType())) {
            Set<String> unPassSuppliers;
            long sourceFlowId = context.getProjectObj().getLong("srctype.id");
            boolean isPushTecByPurlist = ExtParameterUtils.convertToBoolen((Object)ExtParameterUtils.getExtParameterValueById((String)"pds_flowconfig", (long)sourceFlowId, (String)"isPushTecScoreTaskByPurlist", (Object)false, (long)SrmCommonUtil.getPkValue((DynamicObject)context.getProjectObj())));
            boolean isPushBizByPurlist = ExtParameterUtils.convertToBoolen((Object)ExtParameterUtils.getExtParameterValueById((String)"pds_flowconfig", (long)sourceFlowId, (String)"isPushBizScoreTaskByPurlist", (Object)false, (long)SrmCommonUtil.getPkValue((DynamicObject)context.getProjectObj())));
            if ((isPushTecByPurlist || isPushBizByPurlist) && null != (unPassSuppliers = this.getUnPassSupplier(context)) && unPassSuppliers.size() > 0) {
                this.rankAndRecommendUnPass(context, unPassSuppliers);
            }
        }
    }

    public Set<String> getUnPassSupplier(SrcCalcContext context) {
        QFilter qfilter = new QFilter("scoretask.project", "=", (Object)SrmCommonUtil.getPkValue((DynamicObject)context.getProjectObj()));
        qfilter.and("isaptitude", "=", (Object)"2");
        qfilter.and("scoretask.purlist", ">", (Object)0);
        String selectFields = "scoretask.supplier.id,scoretask.purlist.id";
        DynamicObjectCollection rows = QueryServiceHelper.query((String)"src_bidassess_tec", (String)selectFields, (QFilter[])qfilter.toArray());
        return rows.stream().map(e -> e.getString("scoretask.supplier.id") + '_' + e.getString("scoretask.purlist.id")).collect(Collectors.toSet());
    }

    public void rankAndRecommendUnPass(SrcCalcContext context, Set<String> unPassSuppliers) {
        for (DynamicObject assessObj : context.getAllAssessList()) {
            String supId_purlistId = PdsCommonUtils.buildString((Object[])new Object[]{assessObj.getLong("supplier_id"), "_", assessObj.getLong("purlist_id")});
            if (!unPassSuppliers.contains(supId_purlistId)) continue;
            assessObj.set("rank", (Object)0);
            assessObj.set("result", (Object)ResultStatusEnums.NOPASSAPTITUDE.getValue());
        }
    }
}

