/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.copycompdata;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.extfilter.ExtFilterUtils;
import kd.scm.pds.common.extplugin.ExtPluginContext;
import kd.scm.pds.common.extplugin.ExtPluginFactory;
import kd.scm.pds.common.util.TemplateUtil;
import kd.scm.src.common.copycompdata.ISrcCopyCompData;
import kd.scm.src.common.copycompdata.comm.SrcCopyProjectHeadData;

public class SrcCopyCompDataUtils {
    public static List<String> getValidCompKeyList() {
        QFilter qfilter = new QFilter("group.number", "=", (Object)"SYS41");
        qfilter.and("enable", "=", (Object)true);
        DynamicObjectCollection rows = QueryServiceHelper.query((String)"pds_extplugin", (String)"number", (QFilter[])qfilter.toArray(), (String)"order");
        ArrayList<String> compKeyList = new ArrayList<String>(rows.size());
        HashSet<String> compKeySet = new HashSet<String>(rows.size());
        for (DynamicObject row : rows) {
            String[] compKeys = row.getString("number").split("\\|");
            if (compKeys.length <= 1 || !compKeySet.add(compKeys[1])) continue;
            compKeyList.add(compKeys[1]);
        }
        return compKeyList;
    }

    public static List<String> getValidCompKeyList(DynamicObject projectObj) {
        List<String> compKeyList = SrcCopyCompDataUtils.getValidCompKeyList();
        if (!"3".equals(projectObj.getString("managetype"))) {
            compKeyList.remove("src_itemsupplier");
        }
        if ("2".equals(projectObj.getString("tendertype"))) {
            if (compKeyList.contains("src_supplier_select")) {
                compKeyList.remove("src_supplier_invite");
            }
        } else if (compKeyList.contains("src_supplier_invite")) {
            compKeyList.remove("src_supplier_select");
        }
        return compKeyList;
    }

    public static void copyProjetCompAndHead(ExtPluginContext context) {
        Set purlistCompKeys = TemplateUtil.getPurListCompKeySet();
        context.setCompKeys(purlistCompKeys);
        List<String> compKeyList = SrcCopyCompDataUtils.getValidCompKeyList(context.getSourceObj());
        DynamicObjectCollection compRows = context.getSourceObj().getDynamicObjectCollection("tplentry");
        Map<String, DynamicObject> compKeyMap = compRows.stream().filter(e -> !StringUtils.isBlank((CharSequence)e.getString("tmp_bizobject"))).collect(Collectors.groupingBy(e -> e.getString("tmp_bizobject"), Collectors.collectingAndThen(Collectors.toList(), value -> (DynamicObject)value.get(0))));
        String currentCompKey = "";
        boolean isSucced = false;
        boolean isCopyPacakge = false;
        context.getSourceId_targetIdMap().put(SrmCommonUtil.getPkValue((DynamicObject)context.getSourceObj()), SrmCommonUtil.getPkValue((DynamicObject)context.getTargetObj()));
        for (String compKey : compKeyList) {
            DynamicObject compRow = compKeyMap.get(compKey);
            if (null == compRow) continue;
            if (!isCopyPacakge) {
                currentCompKey = "src_projectpackage";
                isCopyPacakge = true;
            } else {
                currentCompKey = compRow.getString("tmp_bizobject");
            }
            if (StringUtils.isEmpty((CharSequence)currentCompKey)) continue;
            context.setCurrentCompKey(currentCompKey);
            context.setSourceCompObj(null);
            String pluginNumber = ISrcCopyCompData.class.getSimpleName() + '|' + currentCompKey;
            if (ExtFilterUtils.isMatchSourceTypeAndSourceFlow((Object)context, null, (String)pluginNumber)) {
                ExtPluginFactory.executeExtplugin((String)pluginNumber, (ExtPluginContext)context, (boolean)true);
            }
            if (!context.isSucced()) continue;
            isSucced = true;
        }
        if (isSucced) {
            ExtPluginFactory.executeExtplugin((String)SrcCopyProjectHeadData.class.getSimpleName(), (ExtPluginContext)context, (boolean)true);
        }
    }
}

