/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.pushproject;

import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.pds.common.enums.PdsBizNodeEnums;
import kd.scm.pds.common.enums.ProcessStatusEnums;
import kd.scm.pds.common.extplugin.ExtPluginContext;
import kd.scm.pds.common.extplugin.IExtPluginHandler;
import kd.scm.pds.common.util.OrgAndUserUtils;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.src.common.pushproject.SrcPushProjectUtils;
import kd.scm.src.common.util.SrcProjectUtil;

public class SrcPushProjectCreate
implements IExtPluginHandler {
    private static final long serialVersionUID = 1L;

    public void process(ExtPluginContext context) {
        if (!context.isSucced()) {
            return;
        }
        for (DynamicObject targetObj : context.getTargetObjs()) {
            context.setTargetObj(targetObj);
            this.createProject(context);
        }
    }

    public void createProject(ExtPluginContext context) {
        DynamicObject sourceFlowObj = SrcPushProjectUtils.getSourceFlowObj((DynamicObject)context.getTargetObj());
        long projectId = SrcProjectUtil.createNewBillId("src_project", sourceFlowObj.getString("number"), sourceFlowObj.getLong("id"), false);
        if (projectId == 0L) {
            context.setSucced(false);
            return;
        }
        DynamicObject projectObj = BusinessDataServiceHelper.loadSingle((Object)projectId, (String)"src_project");
        if (null == projectObj) {
            context.setSucced(false);
            return;
        }
        projectObj.set("bidname", (Object)context.getTargetObj().getString("bidname"));
        long orgId = context.getTargetObj().getLong("org.id");
        if (orgId == 0L) {
            orgId = OrgAndUserUtils.getHasPermBizOrgId((String)"src_project", (String)"02");
        }
        projectObj.set("org", (Object)orgId);
        projectObj.set("sourcetype", (Object)sourceFlowObj.getLong("sourcetype.id"));
        projectObj.set("sourceclass", (Object)sourceFlowObj.getLong("sourceclass.id"));
        projectObj.set("managetype", (Object)sourceFlowObj.getString("managetype"));
        SrcProjectUtil.setBizTypeDefaultValue(projectObj, context.getTargetObj().getDynamicObject("biztype"));
        long templateId = ((DynamicObject)sourceFlowObj.getDynamicObjectCollection("entrynode").get(0)).getLong("template.id");
        projectObj.set("template", (Object)templateId);
        Set srcBillIds = SrcPushProjectUtils.getSrcBillIdsByBotpLink((ExtPluginContext)context);
        if ("src_apply".equals(context.getEntityId())) {
            projectObj.set("srcapply", srcBillIds.iterator().next());
        } else if ("src_demand".equals(context.getEntityId())) {
            projectObj.set("source", srcBillIds.iterator().next());
            projectObj.set("scene", (Object)context.getTargetObj().getLong("scene.id"));
        }
        projectObj.set("billstatus", (Object)BillStatusEnum.SAVE.getVal());
        projectObj.set("bizstatus", (Object)ProcessStatusEnums.PROCESSING.getValue());
        projectObj.set("currentnode", (Object)PdsBizNodeEnums.PROJECT.getId());
        projectObj.set("currentnodename", projectObj.get("currentnode.name"));
        SrcProjectUtil.createEntryData(projectObj);
        PdsCommonUtils.saveDynamicObjects((DynamicObject)projectObj);
        projectObj = BusinessDataServiceHelper.loadSingle((Object)projectId, (String)"src_project");
        PdsCommonUtils.setBillNo((String)"src_project", (DynamicObject)projectObj);
        PdsCommonUtils.saveDynamicObjects((DynamicObject)projectObj);
        context.setProjectObj(projectObj);
        context.getObjMap().put(context.getTargetObj().getLong("id"), projectObj);
        DynamicObject billObj = BusinessDataServiceHelper.loadSingle(srcBillIds.iterator().next(), (String)context.getEntityId());
        context.getObjMap2().put(context.getTargetObj().getLong("id"), billObj);
        SrcPushProjectUtils.setResultMessage((ExtPluginContext)context);
    }
}

