/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.util;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.logging.BizLog;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.ORMUtil;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.util.CommonUtil;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.enums.ProcessStatusEnums;
import kd.scm.pds.common.enums.QuoteTurnsEnums;
import kd.scm.pds.common.enums.SrcNegotiatetypeEnums;
import kd.scm.pds.common.enums.SrcVieStatusEnums;
import kd.scm.pds.common.extplugin.ExtPluginContext;
import kd.scm.pds.common.extplugin.ExtPluginFactory;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.PdsCompConfigUtil;
import kd.scm.pds.common.util.PdsCostDetailUtils;
import kd.scm.pds.common.util.PdsDefaultConfigUtil;
import kd.scm.pds.common.util.PdsOrderByUtils;
import kd.scm.pds.common.util.PdsParameterUtils;
import kd.scm.pds.common.util.SendMessageUtils;
import kd.scm.pds.common.util.SrcDateUtils;
import kd.scm.pds.common.util.SupplierUtil;
import kd.scm.pds.common.util.TemplateUtil;
import kd.scm.pds.common.util.TndQuoteUtil;
import kd.scm.src.common.extplugin.purlist.SrcPurlistEntryFilter;
import kd.scm.src.common.negopen.SrcNegOpenContext;

public class SrcNegotiateUtil {
    private static Log log = LogFactory.getLog(SrcNegotiateUtil.class);
    private static final String COMPKEY = "compkey.number";

    public static DynamicObject getQuoteBill(String formId, QFilter qfilter) {
        qfilter.and("bizpartner.id", "=", (Object)0);
        String selectFields = DynamicObjectUtil.getSelectfields((String)formId, (boolean)true);
        DynamicObject[] negObjs = BusinessDataServiceHelper.load((String)formId, (String)selectFields, (QFilter[])qfilter.toArray());
        DynamicObject lastTurnsNegBill = SrcNegotiateUtil.getLastTurnsNegBill(negObjs);
        return lastTurnsNegBill;
    }

    public static DynamicObject getLastTurnsNegBill(IFormView view) {
        IFormView parentView = view.getParentView();
        if (parentView == null) {
            return null;
        }
        QFilter qfilter = new QFilter("project.id", "=", (Object)SrmCommonUtil.getPkValue((DynamicObject)parentView.getModel().getDataEntity()));
        return SrcNegotiateUtil.getQuoteBill("src_negotiatebill", qfilter);
    }

    public static DynamicObject getLastTurnsNegBill(DynamicObject[] negObjs) {
        if (negObjs.length == 0) {
            return null;
        }
        Function<DynamicObject, Integer> function = row -> Integer.parseInt(row.getString("turns"));
        List sortList = Arrays.asList(negObjs).stream().sorted(Comparator.comparing(function)).collect(Collectors.toList());
        return (DynamicObject)sortList.get(sortList.size() - 1);
    }

    public static void setMultiquotecomdata(DynamicObject negBillObj, Map<String, List<DynamicObject>> selectData) {
        SrcNegotiateUtil.setMultiquotecomdata(negBillObj, selectData, false);
    }

    public static void setMultiquotecomdata(DynamicObject negBillObj, Map<String, List<DynamicObject>> selectData, boolean isreplenish) {
        DynamicObject targetObj;
        String negBillObjId = negBillObj.getString("id");
        String turns = negBillObj.getString("turns");
        QFilter filter = new QFilter("parentid", "=", (Object)negBillObjId);
        String comFormId = "";
        DynamicObject compData = null;
        OperateOption option = OperateOption.create();
        for (Map.Entry<String, List<DynamicObject>> entry : selectData.entrySet()) {
            boolean flag;
            comFormId = entry.getKey();
            boolean bl = flag = comFormId == null || comFormId != null && comFormId.trim().length() <= 0;
            if (flag) continue;
            QFilter comFilter = new QFilter("entitykey", "=", (Object)comFormId);
            filter.and(comFilter);
            compData = BusinessDataServiceHelper.loadSingle((String)comFormId, (String)"id,taxtype", (QFilter[])filter.toArray());
            if (compData != null) {
                compData = BusinessDataServiceHelper.loadSingle((Object)compData.getLong("id"), (String)comFormId);
                DynamicObjectCollection entryentity = compData.getDynamicObjectCollection("entryentity");
                List<DynamicObject> list = entry.getValue();
                DynamicObjectType type = entryentity.getDynamicObjectType();
                List<String> noValueFieldSet = SrcNegotiateUtil.getClearFieldList(negBillObj, compData);
                for (int i = 0; i < list.size(); ++i) {
                    DynamicObject entryrolldata = list.get(i);
                    SrcNegotiateUtil.setEntry(entryentity, type, entryrolldata, turns, noValueFieldSet);
                }
                compData.set("entryentity", (Object)entryentity);
                if (StringUtils.isBlank((Object)compData.get("taxtype"))) {
                    compData.set("taxtype", (Object)"1");
                }
                OperationServiceHelper.executeOperate((String)"save", (String)comFormId, (DynamicObject[])new DynamicObject[]{compData}, (OperateOption)option);
                continue;
            }
            compData = BusinessDataServiceHelper.newDynamicObject((String)comFormId);
            if ((compData = SrcNegotiateUtil.setvalueToOnlinecom(compData, entry.getValue(), Long.parseLong(negBillObjId), turns, isreplenish)) == null) continue;
            OperationServiceHelper.executeOperate((String)"save", (String)comFormId, (DynamicObject[])new DynamicObject[]{compData}, (OperateOption)option);
        }
        DynamicObject sourceObj = BusinessDataServiceHelper.loadSingle((Object)negBillObj.getLong("project.id"), (String)"src_purlist");
        boolean isChanged = TemplateUtil.createNegTplEntryData((DynamicObject)sourceObj, (DynamicObject)(targetObj = BusinessDataServiceHelper.loadSingle((Object)negBillObjId, (String)"src_negotiatebill")), selectData.keySet(), (boolean)false);
        if (isChanged) {
            PdsCommonUtils.saveDynamicObjects((DynamicObject)targetObj);
        }
    }

    public static String createNegotiateBill(DynamicObject negBill, Map<String, List<DynamicObject>> selectData, String formId, String pkValue, String turns) {
        String billId = SrcNegotiateUtil.createNegotiateBill(negBill, selectData, formId, pkValue, turns, false, new StringBuilder());
        return billId;
    }

    public static String createNegotiateBill(DynamicObject negBill, Map<String, List<DynamicObject>> selectData, String formId, String pkValue, String turns, StringBuilder errorMessage) {
        String billId = SrcNegotiateUtil.createNegotiateBill(negBill, selectData, formId, pkValue, turns, false, errorMessage);
        return billId;
    }

    public static String createNegotiateBill(DynamicObject negBill, Map<String, List<DynamicObject>> selectData, String formId, String pkValue, String turns, boolean isreplenish, StringBuilder errorMessage) {
        OperationResult saveResult;
        OperateOption option = OperateOption.create();
        negBill = BusinessDataServiceHelper.newDynamicObject((String)formId);
        ORM orm = ORM.create();
        long genLongId = orm.genLongId(formId);
        String billId = String.valueOf(genLongId);
        DynamicObject purListObj = SrcNegotiateUtil.getPurListObj(pkValue);
        negBill = SrcNegotiateUtil.setQuoteBillHeader(negBill, formId, pkValue, turns, genLongId);
        negBill.set("isreplenish", (Object)isreplenish);
        negBill.set("turns", (Object)negBill.getString("turns"));
        if (isreplenish) {
            negBill.set("deadline", (Object)new Date());
        }
        String negotiateType = PdsCommonUtils.object2String((Object)PdsDefaultConfigUtil.getDefaultValue((DynamicObject)negBill, (String)"src_negotiatebill", (String)formId, (String)"negotiatetype", (Object)"1"), (String)"1");
        negBill.set("negotiatetype", (Object)negotiateType);
        if (null != purListObj) {
            DynamicObject template = purListObj.getDynamicObject("template");
            if (null != template) {
                negBill.set("template", template.getPkValue());
            }
            TemplateUtil.createNegTplEntryData((DynamicObject)purListObj, (DynamicObject)negBill, selectData.keySet(), (boolean)false);
        }
        if (!(saveResult = OperationServiceHelper.executeOperate((String)"save", (String)formId, (DynamicObject[])new DynamicObject[]{negBill}, (OperateOption)option)).isSuccess()) {
            PdsCommonUtils.buildOpErrorMessage((OperationResult)saveResult, (StringBuilder)errorMessage);
            return "0";
        }
        List compKeyList = TemplateUtil.getCompKeyList((DynamicObject)purListObj);
        for (String compKey : compKeyList) {
            DynamicObject compData;
            if (null != selectData.get(compKey) || (compData = TemplateUtil.getCompData((DynamicObject)purListObj, (String)compKey)) == null) continue;
            DynamicObject newCompData = (DynamicObject)OrmUtils.clone((IDataEntityBase)compData, (boolean)false, (boolean)true);
            newCompData.set("parentid", negBill.getPkValue());
            newCompData.set("entitykey", (Object)compKey);
            DynamicObjectCollection newCols = newCompData.getDynamicObjectCollection("entryentity");
            newCols.clear();
            saveResult = OperationServiceHelper.executeOperate((String)"save", (String)compKey, (DynamicObject[])new DynamicObject[]{newCompData}, (OperateOption)option);
            if (saveResult.isSuccess()) continue;
            PdsCommonUtils.deleteBillAndComp((DynamicObject)negBill);
            PdsCommonUtils.buildOpErrorMessage((OperationResult)saveResult, (StringBuilder)errorMessage);
            return "0";
        }
        turns = negBill.getString("turns");
        for (String key : selectData.keySet()) {
            String comFormId = key;
            if (selectData.get(comFormId).size() == 0) continue;
            DynamicObject multiquotecomdata = BusinessDataServiceHelper.newDynamicObject((String)comFormId);
            List<DynamicObject> list = selectData.get(comFormId);
            if ((multiquotecomdata = SrcNegotiateUtil.setvalueToOnlinecom(multiquotecomdata, list, genLongId, turns, isreplenish)) == null || (saveResult = OperationServiceHelper.executeOperate((String)"save", (String)comFormId, (DynamicObject[])new DynamicObject[]{multiquotecomdata}, (OperateOption)option)).isSuccess()) continue;
            PdsCommonUtils.deleteBillAndComp((DynamicObject)negBill);
            PdsCommonUtils.buildOpErrorMessage((OperationResult)saveResult, (StringBuilder)errorMessage);
            return "0";
        }
        return billId;
    }

    private static DynamicObject getPurListObj(String pkVal) {
        DynamicObject purListObj = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(pkVal), (String)"src_purlist");
        return purListObj;
    }

    public static void setEntry(DynamicObjectCollection entryentity, DynamicObjectType type, DynamicObject entryrolldata, String turns, List<String> noValueFieldSet) {
        List entryentityProperties = DynamicObjectUtil.getEntryentityProperties((IDataEntityType)type);
        DynamicObject entry = new DynamicObject(type);
        StringBuilder logMsg = new StringBuilder();
        for (int i = 0; i < entryentityProperties.size(); ++i) {
            if (noValueFieldSet.contains(entryentityProperties.get(i))) continue;
            Object val = null;
            try {
                val = entryrolldata.get((String)entryentityProperties.get(i));
            }
            catch (Exception e) {
                continue;
            }
            if ("entrystatus".equals(entryentityProperties.get(i))) {
                entry.set((String)entryentityProperties.get(i), (Object)"A");
                continue;
            }
            if ("historyprice".equals(entryentityProperties.get(i))) {
                entry.set("historyprice", entryrolldata.get("price"));
                continue;
            }
            if ("historytaxprice".equals(entryentityProperties.get(i))) {
                entry.set("historytaxprice", entryrolldata.get("taxprice"));
                continue;
            }
            if ("preamount".equals(entryentityProperties.get(i))) {
                entry.set("preamount", entryrolldata.get("amount"));
                continue;
            }
            if ("pretaxamount".equals(entryentityProperties.get(i))) {
                entry.set("pretaxamount", entryrolldata.get("taxamount"));
                continue;
            }
            if ("turns".equals(entryentityProperties.get(i))) {
                entry.set((String)entryentityProperties.get(i), (Object)turns);
                continue;
            }
            if ("costdetail".equals(entryentityProperties.get(i))) {
                entry.set((String)entryentityProperties.get(i), (Object)"0");
                continue;
            }
            if ("srcentryid".equals(entryentityProperties.get(i))) {
                entry.set((String)entryentityProperties.get(i), (Object)entryrolldata.getString("entryid"));
                continue;
            }
            if ("compkey".equals(entryentityProperties.get(i))) {
                entry.set((String)entryentityProperties.get(i), (Object)entryrolldata.getString(COMPKEY));
                continue;
            }
            if ("purlistentry_fj".equals(entryentityProperties.get(i))) {
                SrcNegotiateUtil.setFJVal(entry, entryrolldata, (String)entryentityProperties.get(i));
                continue;
            }
            if ("purlistentry_supfj".equals(entryentityProperties.get(i))) {
                SrcNegotiateUtil.setFJVal(entry, entryrolldata, (String)entryentityProperties.get(i));
                continue;
            }
            if (val instanceof DynamicObjectCollection) {
                entry.set((String)entryentityProperties.get(i), (Object)PdsCommonUtils.cloneCols((DynamicObject)entryrolldata, (String)((String)entryentityProperties.get(i))));
                continue;
            }
            try {
                DynamicProperty property = entry.getDynamicObjectType().getProperty((String)entryentityProperties.get(i));
                if (null == property) continue;
                entry.set((String)entryentityProperties.get(i), val);
                continue;
            }
            catch (Exception e) {
                logMsg.append("###SrcNegotiateUtil.setEntry exception:").append(e.getMessage()).append(';');
            }
        }
        BizLog.log((String)(logMsg.length() == 0 ? "###SrcNegotiateUtil.setEntry" : logMsg.toString()));
        entry.set("billtype", (Object)"3");
        entryentity.add((Object)entry);
    }

    public static List<String> getClearFieldList(DynamicObject negBillObj, DynamicObject compData) {
        String compKey = compData.getDynamicObjectType().getName();
        List proList = PdsCompConfigUtil.getPros((DynamicObject)negBillObj, (String)compKey, (String)"entryentity", (String)"isclearup", (boolean)true);
        proList.add("id");
        proList.add("seq");
        proList.add("result");
        proList.add("orderratio");
        proList.add("cfmqty");
        proList.add("preresult");
        proList.add("preorderratio");
        proList.add("precfmqty");
        return proList;
    }

    public static DynamicObject setvalueToOnlinecom(DynamicObject compData, List<DynamicObject> selectData, long genLongId, String turns) {
        return SrcNegotiateUtil.setvalueToOnlinecom(compData, selectData, genLongId, turns, false);
    }

    public static DynamicObject setvalueToOnlinecom(DynamicObject compData, List<DynamicObject> selectData, long negBillId, String turns, boolean isreplenish) {
        compData.set("parentid", (Object)String.valueOf(negBillId));
        compData.set("entitykey", (Object)compData.getDynamicObjectType().getName());
        compData.set("pentitykey", (Object)"src_negotiatebill");
        DynamicObjectCollection entryentity = compData.getDynamicObjectCollection("entryentity");
        DynamicObjectType type = entryentity.getDynamicObjectType();
        DynamicObject negBillObj = BusinessDataServiceHelper.loadSingle((Object)negBillId, (String)"src_negotiatebill");
        List<String> noValueFieldSet = SrcNegotiateUtil.getClearFieldList(negBillObj, compData);
        for (int i = 0; i < selectData.size(); ++i) {
            DynamicObject entryrolldata = selectData.get(i);
            SrcNegotiateUtil.setEntry(entryentity, type, entryrolldata, turns, noValueFieldSet);
        }
        compData.set("entryentity", (Object)entryentity);
        DynamicObject selectDataInfo = selectData.get(0);
        DynamicObject compInfo = (DynamicObject)selectDataInfo.getParent();
        if (compInfo == null) {
            compInfo = QueryServiceHelper.queryOne((String)compData.getDynamicObjectType().getName(), (String)"id,taxtype,curr,decisiontype", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)selectDataInfo.getLong("billid"))});
        }
        if (compInfo == null) {
            return compData;
        }
        compData.set("taxtype", StringUtils.isBlank((Object)compInfo.get("taxtype")) ? "1" : compInfo.get("taxtype"));
        compData.set("curr", compInfo.get("curr"));
        compData.set("decisiontype", compInfo.get("decisiontype"));
        return compData;
    }

    public static DynamicObject setQuoteBillHeader(DynamicObject negBillObj, String formId, String pkValue, String turns, long genLongId) {
        negBillObj.set("project", (Object)pkValue);
        DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(pkValue), (String)"src_project");
        if (Objects.nonNull(obj)) {
            negBillObj.set("org", (Object)obj.getLong("org.id"));
            negBillObj.set("currentnode", obj.get("currentnode"));
        }
        negBillObj.set("id", (Object)genLongId);
        negBillObj.set("billstatus", (Object)BillStatusEnum.SAVE.getVal());
        negBillObj.set("opentype", (Object)"1");
        if (StringUtils.isBlank((CharSequence)turns)) {
            turns = QuoteTurnsEnums.NEGOTIATE01.getValue();
            negBillObj.set("turns", (Object)turns);
        } else {
            int parseInt = Integer.parseInt(turns) + 1;
            turns = String.valueOf(parseInt);
            negBillObj.set("turns", (Object)turns);
        }
        Date date = new Date();
        negBillObj.set("billdate", (Object)date);
        negBillObj.set("createtime", (Object)date);
        negBillObj.set("creator", (Object)RequestContext.get().getCurrUserId());
        return negBillObj;
    }

    public static Map<String, List<DynamicObject>> getQuoteData(IFormView view) {
        IDataModel model = view.getModel();
        EntryGrid entryGrid = (EntryGrid)view.getControl("entryentity");
        HashMap<String, List<DynamicObject>> compEntryMap = new HashMap<String, List<DynamicObject>>(16);
        int[] selectRows = entryGrid.getSelectRows();
        ArrayList<String> compKeyList = new ArrayList<String>();
        String compKey = null;
        ArrayList<Integer> selectRowList = new ArrayList<Integer>();
        DynamicObject negBillObj = null;
        HashMap<String, DynamicObjectCollection> negEntryMap = new HashMap<String, DynamicObjectCollection>();
        String isNeedCheck = null;
        DynamicObjectCollection rows = model.getDataEntity(true).getDynamicObjectCollection("entryentity");
        for (int i = 0; i < selectRows.length; ++i) {
            int index = selectRows[i];
            DynamicObject row = (DynamicObject)rows.get(index);
            if (row == null) continue;
            compKey = row.getString(COMPKEY);
            if (!compKeyList.contains(compKey)) {
                compKeyList.add(compKey);
            }
            String entryId = row.getString("entryid");
            DynamicObject projectObj = row.getDynamicObject("project");
            if (projectObj == null) continue;
            if (null == isNeedCheck) {
                negBillObj = SrcNegotiateUtil.getNegBillObj(projectObj.getLong("id"));
                isNeedCheck = SrcNegotiateUtil.isUnOpen(negBillObj) ? "1" : "0";
            }
            if ("1".equals(isNeedCheck)) {
                if (SrcNegotiateUtil.isExistEntryId(entryId, negBillObj, compKey, negEntryMap)) continue;
                selectRowList.add(index);
                continue;
            }
            selectRowList.add(index);
        }
        Integer[] afterSelectRows = selectRowList.toArray(new Integer[selectRowList.size()]);
        for (int j = 0; j < compKeyList.size(); ++j) {
            ArrayList<DynamicObject> entryList = new ArrayList<DynamicObject>();
            for (int i = 0; i < afterSelectRows.length; ++i) {
                int index = afterSelectRows[i];
                DynamicObject entryrollData = (DynamicObject)rows.get(index);
                if (entryrollData == null || !(compKey = entryrollData.getString(COMPKEY)).equals(compKeyList.get(j))) continue;
                entryList.add(entryrollData);
            }
            compEntryMap.put((String)compKeyList.get(j), (List<DynamicObject>)entryList);
        }
        return compEntryMap;
    }

    public static DynamicObject getNegBillObj(long projectId) {
        QFilter qfilter = new QFilter("project", "=", (Object)projectId);
        String selectFields = "turns,isquotebidopen,deadline,billstatus";
        DynamicObject[] negBillObjs = BusinessDataServiceHelper.load((String)"src_negotiatebill", (String)selectFields, (QFilter[])qfilter.toArray());
        return SrcNegotiateUtil.getLastTurnsNegBill(negBillObjs);
    }

    public static boolean isUnOpen(DynamicObject negBillObj) {
        if (null == negBillObj) {
            return false;
        }
        if (negBillObj.getBoolean("isquotebidopen")) {
            return false;
        }
        Date deadline = negBillObj.getDate("deadline");
        return deadline == null || BillStatusEnum.SAVE.getVal().equals(negBillObj.getString("billstatus")) || !TimeServiceHelper.now().after(deadline);
    }

    public static boolean isExistEntryId(String entryId, DynamicObject negBillObj, String compKey, Map<String, DynamicObjectCollection> negEntryMap) {
        DynamicObjectCollection rows = negEntryMap.get(compKey);
        if (null == rows) {
            DynamicObject compObj = TemplateUtil.getCompData((DynamicObject)negBillObj, (String)compKey);
            rows = compObj != null ? compObj.getDynamicObjectCollection("entryentity") : new DynamicObjectCollection();
            negEntryMap.put(compKey, rows);
        }
        if (null == rows || rows.size() == 0) {
            return false;
        }
        return rows.stream().anyMatch(e -> e.getString("srcentryid").equals(entryId));
    }

    public static void createSupQuoBill(DynamicObject srcNegotiateObj) {
        if (null == srcNegotiateObj) {
            return;
        }
        ArrayList<Object> packageIdList = new ArrayList<Object>();
        HashSet<String> supIdSet = new HashSet<String>();
        List compKeyList = TemplateUtil.getCompKeyListByTplEntry((DynamicObject)srcNegotiateObj);
        HashMap<String, DynamicObject> compKey_objMap = new HashMap<String, DynamicObject>(4);
        HashMap<String, Set<String>> supId_compKeysMap = new HashMap<String, Set<String>>(32);
        for (String compKey : compKeyList) {
            DynamicObject compObj = TemplateUtil.getCompData((DynamicObject)srcNegotiateObj, (String)compKey);
            if (null == compObj) continue;
            DynamicObjectCollection cols = compObj.getDynamicObjectCollection("entryentity");
            for (DynamicObject col : cols) {
                DynamicObject supplier = col.getDynamicObject("supplier");
                if (null == supplier) continue;
                String supId = supplier.getPkValue().toString();
                supIdSet.add(supId);
                HashSet<String> supCompKeys = (HashSet<String>)supId_compKeysMap.get(supId);
                if (null == supCompKeys) {
                    supCompKeys = new HashSet<String>(4);
                }
                supCompKeys.add(compKey);
                supId_compKeysMap.put(supId, supCompKeys);
                DynamicObject packageObj = col.getDynamicObject("package");
                if (null == packageObj) continue;
                packageIdList.add(packageObj.getPkValue());
            }
            compKey_objMap.put(compKey, compObj);
        }
        if (supIdSet.size() == 0) {
            return;
        }
        for (String supId : supIdSet) {
            DynamicObject createQuoteBill = SrcNegotiateUtil.createQuoteBill(supId, srcNegotiateObj, compKey_objMap, supId_compKeysMap);
            SrcNegotiateUtil.sendPortal(createQuoteBill, srcNegotiateObj, supId);
        }
        SrcNegotiateUtil.writeBidOpenPackage(srcNegotiateObj, packageIdList);
    }

    private static void sendPortal(DynamicObject createQuoteBill, DynamicObject srcNegotiateObj, String supId) {
        long bizPartner = createQuoteBill.getLong("bizpartner");
        Long userId = SupplierUtil.getUserIdByBizPartner((long)bizPartner);
        if (null != userId) {
            String turns = srcNegotiateObj.getString("turns");
            String title = String.format(ResManager.loadKDString((String)"\u60a8\u6709\u5f85\u62a5\u4ef7\u7684\u62a5\u4ef7\u5355(%1$s),\u8bf7\u53ca\u65f6\u8fdb\u884c\u62a5\u4ef7\u3002", (String)"SrcNegotiateUtil_0", (String)"scm-src-common", (Object[])new Object[0]), createQuoteBill.getString("billno"));
            if (Integer.parseInt(turns) >= Integer.parseInt(QuoteTurnsEnums.REPLENISH01.getValue())) {
                title = String.format(ResManager.loadKDString((String)"\u60a8\u6709\u5f85\u8865\u4ef7\u7684\u62a5\u4ef7\u5355(%1$s),\u8bf7\u53ca\u65f6\u8fdb\u884c\u8865\u4ef7\u3002", (String)"SrcNegotiateUtil_1", (String)"scm-src-common", (Object[])new Object[0]), createQuoteBill.getString("billno"));
            }
            DynamicObject ptObj = srcNegotiateObj.getDynamicObject("project");
            String content = String.format(ResManager.loadKDString((String)"\u9879\u76ee\u7f16\u53f7\uff1a%1$s\uff0c\u9879\u76ee\u540d\u79f0\uff1a%2$s", (String)"SrcNegotiateUtil_2", (String)"scm-src-common", (Object[])new Object[0]), ptObj.getString("billno"), ptObj.getString("bidname"));
            SendMessageUtils.sendMessage((long)Long.parseLong(((Object)userId).toString()), (long)Long.parseLong(createQuoteBill.getPkValue().toString()), (String)"tnd_quotebill", (String)title, (String)content);
        }
    }

    private static DynamicObject createQuoteBill(String supId, DynamicObject srcNegotiateObj, Map<String, DynamicObject> compKey_objMap, Map<String, Set<String>> supId_compKeysMap) {
        DynamicObject project;
        DynamicObject quoteObj = BusinessDataServiceHelper.newDynamicObject((String)"tnd_quotebill");
        ORMUtil.setPrimaryKey((DynamicObject)quoteObj);
        String billNo = CodeRuleServiceHelper.getNumber((String)"tnd_quotebill", (DynamicObject)quoteObj, (String)String.valueOf(RequestContext.get().getOrgId()));
        quoteObj.set("billno", (Object)(billNo == null ? CommonUtil.getBillnoByDate((Object)quoteObj) : billNo));
        DynamicObject template = srcNegotiateObj.getDynamicObject("template");
        if (null != template) {
            quoteObj.set("template", template.getPkValue());
        }
        quoteObj.set("supplier", (Object)supId);
        String supType = SupplierUtil.getSupType((DynamicObject)quoteObj);
        quoteObj.set("suppliertype", (Object)supType);
        DynamicObject bizPartner = SupplierUtil.getBizPartner((Object)supId, (String)supType);
        if (null != bizPartner) {
            quoteObj.set("bizpartner", bizPartner.getPkValue());
        }
        if (null != (project = srcNegotiateObj.getDynamicObject("project"))) {
            quoteObj.set("project", project.getPkValue());
            DynamicObject org = project.getDynamicObject("org");
            quoteObj.set("org", org.getPkValue());
            quoteObj.set("isadd", (Object)project.getBoolean("isadd"));
        }
        quoteObj.set("turns", (Object)srcNegotiateObj.getString("turns"));
        quoteObj.set("opentype", (Object)srcNegotiateObj.getString("opentype"));
        quoteObj.set("negotiatetype", (Object)srcNegotiateObj.getString("negotiatetype"));
        quoteObj.set("replenishtype", (Object)srcNegotiateObj.getString("replenishtype"));
        Date deadLine = srcNegotiateObj.getDate("deadline") == null ? SrcDateUtils.getMaxDate() : srcNegotiateObj.getDate("deadline");
        quoteObj.set("deadline", (Object)deadLine);
        quoteObj.set("creator", (Object)RequestContext.get().getCurrUserId());
        Date now = TimeServiceHelper.now();
        quoteObj.set("createtime", (Object)now);
        quoteObj.set("billstatus", (Object)BillStatusEnum.SAVE.getVal());
        quoteObj.set("bizstatus", (Object)ProcessStatusEnums.PROCESSING.getValue());
        TemplateUtil.createTplEntryData((DynamicObject)srcNegotiateObj, (DynamicObject)quoteObj, (boolean)false, supId_compKeysMap.get(supId));
        if (SrcNegotiatetypeEnums.ONLINE_VIE.getValue().equals(srcNegotiateObj.getString("negotiatetype"))) {
            quoteObj.set("iscompete", (Object)Boolean.TRUE);
            quoteObj.set("billstatus", (Object)BillStatusEnum.SUBMIT.getVal());
        }
        SupplierUtil.setIsPurAgent((DynamicObject)quoteObj, (long)SrmCommonUtil.getPkValue((DynamicObject)project), (long)Long.parseLong(supId));
        SupplierUtil.setSupplierUser((DynamicObject)quoteObj, (long)SrmCommonUtil.getPkValue((DynamicObject)project), (long)Long.parseLong(supId));
        TndQuoteUtil.copyDynamicObjectValue((DynamicObject)srcNegotiateObj, (DynamicObject)quoteObj);
        Object[] objs = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{quoteObj});
        if (objs.length > 0) {
            SrcNegotiateUtil.createCompData(quoteObj, compKey_objMap);
        }
        return quoteObj;
    }

    private static void createCompData(DynamicObject negotiateObj, Map<String, DynamicObject> compKey_objMap) {
        Object supplierId = negotiateObj.get("supplier");
        if (null == supplierId) {
            return;
        }
        for (Map.Entry<String, DynamicObject> compKey_obj : compKey_objMap.entrySet()) {
            DynamicObject compData = compKey_obj.getValue();
            String compKey = compKey_obj.getKey();
            DynamicObject newCompData = (DynamicObject)OrmUtils.clone((IDataEntityBase)compData, (boolean)false, (boolean)true);
            newCompData.set("parentid", negotiateObj.getPkValue());
            newCompData.set("entitykey", (Object)compKey);
            newCompData.set("origin", (Object)"1");
            newCompData.set("pentitykey", (Object)negotiateObj.getDynamicObjectType().getName());
            DynamicObjectCollection newCols = newCompData.getDynamicObjectCollection("entryentity");
            newCols.clear();
            DynamicObjectCollection cols = compData.getDynamicObjectCollection("entryentity");
            for (DynamicObject col : cols) {
                DynamicObject supplier = col.getDynamicObject("supplier");
                if (null == supplier || !String.valueOf(supplierId).equals(supplier.getPkValue().toString())) continue;
                DynamicObject newCol = (DynamicObject)OrmUtils.clone((IDataEntityBase)col, (boolean)true, (boolean)true);
                newCol.set("srcentryid", col.getPkValue());
                DynamicObject taxItem = col.getDynamicObject("taxitem");
                if (null != taxItem) {
                    BigDecimal taxRate = taxItem.getBigDecimal("taxrate");
                    newCol.set("taxrate", (Object)taxRate);
                }
                newCol.set("quotedate", null);
                newCol.set("billtype", (Object)"2");
                newCol.set("costdetail", (Object)"0");
                newCols.add((Object)newCol);
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{newCompData});
            PdsCostDetailUtils.handleCostDetail((String)"src_costdetail", (DynamicObjectCollection)cols, (boolean)true);
        }
    }

    private static void writeBidOpenPackage(DynamicObject srcObj, List<Object> packageIdList) {
        DynamicObject[] objs;
        QFilter filter = new QFilter("package", "in", packageIdList);
        DynamicObject project = srcObj.getDynamicObject("project");
        if (null != project) {
            filter.and("billid", "=", project.getPkValue());
        }
        for (DynamicObject obj : objs = BusinessDataServiceHelper.load((String)"src_bidopenpackage", (String)"isnegotiate,turns,isnegopen,negopendate,negopenuser", (QFilter[])new QFilter[]{filter})) {
            obj.set("isnegotiate", (Object)Boolean.TRUE);
            obj.set("isnegopen", null);
            obj.set("negopendate", null);
            obj.set("negopenuser", null);
            String turns = obj.getString("turns");
            if (null == turns || turns.trim().length() == 0) {
                obj.set("turns", (Object)QuoteTurnsEnums.NEGOTIATE00.getValue());
                continue;
            }
            obj.set("turns", (Object)turns);
        }
        SaveServiceHelper.save((DynamicObject[])objs);
    }

    public static boolean checkNegIsEnd(long projectId, boolean isAdd) {
        QFilter filter = new QFilter("project", "=", (Object)projectId);
        DynamicObject[] negObjs = BusinessDataServiceHelper.load((String)"src_negotiatebill", (String)"id,turns,isquotebidopen,deadline,billstatus,opentype,negotiatetype", (QFilter[])filter.toArray());
        DynamicObject lastTurnsNegBill = SrcNegotiateUtil.getLastTurnsNegBill(negObjs);
        if (null == lastTurnsNegBill) {
            return false;
        }
        boolean isquotebidopen = lastTurnsNegBill.getBoolean("isquotebidopen");
        if (isquotebidopen) {
            return false;
        }
        Date deadline = lastTurnsNegBill.getDate("deadline");
        Date nowData = TimeServiceHelper.now();
        String entryStatus = lastTurnsNegBill.getString("billstatus");
        String negotiatetype = lastTurnsNegBill.getString("negotiatetype");
        String opentype = lastTurnsNegBill.getString("opentype");
        String turns = lastTurnsNegBill.getString("turns");
        boolean isPass = true;
        if ((StringUtils.equals((CharSequence)SrcNegotiatetypeEnums.ONLINE.getValue(), (CharSequence)negotiatetype) || StringUtils.equals((CharSequence)SrcNegotiatetypeEnums.ONLINE_VIE.getValue(), (CharSequence)negotiatetype)) && StringUtils.equals((CharSequence)"1", (CharSequence)opentype)) {
            isPass = isquotebidopen;
        } else {
            QFilter qfilter = new QFilter("turns", "=", (Object)turns).and("entrystatus", "=", (Object)"A");
            qfilter.and("billid", "=", (Object)projectId);
            boolean bl = isPass = !QueryServiceHelper.exists((String)"src_quote_detailsf7", (QFilter[])qfilter.toArray());
        }
        if (deadline == null) {
            return !isAdd;
        }
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String nowDataStr = formatter.format(TimeServiceHelper.now());
        String deadlineStr = formatter.format(deadline);
        try {
            nowData = formatter.parse(nowDataStr);
            deadline = formatter.parse(deadlineStr);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        if (isAdd) {
            if (!isPass && "C".equals(entryStatus)) {
                return true;
            }
        } else if (StringUtils.equals((CharSequence)SrcNegotiatetypeEnums.OFFLINE_PURLIST.getValue(), (CharSequence)negotiatetype) || StringUtils.equals((CharSequence)SrcNegotiatetypeEnums.OFFLINE_PACKAGE.getValue(), (CharSequence)negotiatetype)) {
            if (entryStatus.compareTo("C") < 0 || !isPass) {
                return true;
            }
        } else {
            boolean flag;
            boolean bl = flag = nowData.before(deadline) && (entryStatus.compareTo("C") < 0 || !isPass);
            if (flag) {
                return true;
            }
        }
        return false;
    }

    public static boolean checkCompeteIsEnd(long projectId) {
        QFilter qfilter = new QFilter("id", "=", (Object)projectId);
        qfilter.and("bidstatus", "in", Arrays.asList(SrcVieStatusEnums.BIDDING.getValue(), SrcVieStatusEnums.PAUSED.getValue()));
        return QueryServiceHelper.exists((String)"src_compete", (QFilter[])qfilter.toArray());
    }

    public static boolean isAudit(long projectId, String entityName) {
        QFilter qFilter = new QFilter("id", "=", (Object)projectId).or("id", "=", (Object)projectId);
        qFilter = qFilter.and("billstatus", "=", (Object)"C");
        return QueryServiceHelper.exists((String)entityName, (QFilter[])new QFilter[]{qFilter});
    }

    public static boolean checkCfmStatus(long projectId) {
        boolean flag = false;
        DynamicObject decision = QueryServiceHelper.queryOne((String)"src_decision", (String)"cfmstatus,srctype.isnegotiable", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)projectId)});
        if (decision != null) {
            if (decision.getBoolean("srctype.isnegotiable")) {
                return flag;
            }
            String cfmstatus = decision.getString("cfmstatus");
            if (StringUtils.equals((CharSequence)"B", (CharSequence)cfmstatus)) {
                flag = true;
            }
        }
        return flag;
    }

    public static boolean checkSupplierAccuracy(IFormView iFormView, DynamicObject[] objs, long parentId, boolean isCompare) {
        QFilter filter = new QFilter("id", "=", (Object)parentId);
        DynamicObject compareConfig = QueryServiceHelper.queryOne((String)"src_compare_config", (String)"negotiaterule,topsupplier", (QFilter[])filter.toArray());
        if (compareConfig != null) {
            if (isCompare) {
                objs = SrcNegotiateUtil.getEntryDate(iFormView);
            }
            return SrcNegotiateUtil.checkDataIsPass(objs, compareConfig, isCompare);
        }
        return true;
    }

    private static boolean checkDataIsPass(DynamicObject[] objs, DynamicObject compareConfig, boolean isCompare) {
        boolean isPass = true;
        String negotiaterule = compareConfig.getString("negotiaterule");
        int topsupplier = compareConfig.getInt("topsupplier");
        Set resultSet = PdsParameterUtils.getResultValueSet();
        for (int i = 0; i < objs.length; ++i) {
            int rank;
            DynamicObject entryrollData = objs[i];
            if (entryrollData == null) continue;
            if (StringUtils.equals((CharSequence)"1", (CharSequence)negotiaterule)) {
                String result;
                String resultField = "sysresult";
                if (!isCompare) {
                    resultField = "result";
                }
                if (resultSet.contains(result = entryrollData.getString(resultField))) continue;
                isPass = false;
                break;
            }
            if (!StringUtils.equals((CharSequence)"2", (CharSequence)negotiaterule) || (rank = entryrollData.getInt("rank")) <= topsupplier) continue;
            isPass = false;
            break;
        }
        return isPass;
    }

    private static DynamicObject[] getEntryDate(IFormView iFormView) {
        EntryGrid entryGrid = (EntryGrid)iFormView.getControl("entryentity");
        if (null == entryGrid) {
            return new DynamicObject[0];
        }
        int[] selectRows = entryGrid.getSelectRows();
        DynamicObjectCollection entryentity = iFormView.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        DynamicObject[] objs = new DynamicObject[selectRows.length];
        for (int i = 0; i < selectRows.length; ++i) {
            DynamicObject entryrollData;
            int index = selectRows[i];
            objs[i] = entryrollData = (DynamicObject)entryentity.get(index);
        }
        return objs;
    }

    public static void setFJVal(DynamicObject entryInfo, DynamicObject compEntryinfo, String pro) {
        DynamicObjectCollection newFjCol = entryInfo.getDynamicObjectCollection(pro);
        newFjCol.clear();
        DynamicObjectCollection fjCols = compEntryinfo.getDynamicObjectCollection(pro);
        for (DynamicObject fjCol : fjCols) {
            DynamicObject newCol = (DynamicObject)OrmUtils.clone((IDataEntityBase)fjCol, (boolean)true, (boolean)true);
            newFjCol.add((Object)newCol);
        }
        entryInfo.set(pro, (Object)newFjCol);
    }

    public static Map<String, DynamicObject> queryQuote(IFormView iFormView) {
        Map<String, DynamicObject> entryId_entryMap = new HashMap<String, DynamicObject>(16);
        IFormView parentView = iFormView.getParentView();
        if (null == parentView) {
            return entryId_entryMap;
        }
        Object[] projectIds = SrcNegotiateUtil.getProjectIds(parentView);
        String compKey = iFormView.getEntityId();
        entryId_entryMap = SrcNegotiateUtil.getComponetDataMap(compKey, projectIds, iFormView, false);
        return entryId_entryMap;
    }

    public static Object[] getProjectIds(IFormView view) {
        Object projectId = view.getModel().getDataEntity().getPkValue();
        return new Object[]{projectId};
    }

    public static Map<String, DynamicObject> getComponetDataMap(String compKey, Object[] parentIds, IFormView iFormView, boolean isQueryAll) {
        DynamicObjectCollection purListF7Cols = SrcNegotiateUtil.getPurListF7Data(parentIds, iFormView, isQueryAll);
        List<Object> entryIDList = new ArrayList();
        List<Object> compIDList = new ArrayList();
        entryIDList = purListF7Cols.stream().map(obj -> obj.getLong("entryid")).collect(Collectors.toList());
        compIDList = purListF7Cols.stream().map(obj -> obj.getLong("billid")).collect(Collectors.toList());
        LinkedHashMap<String, DynamicObject> entryId_objMap = new LinkedHashMap<String, DynamicObject>(entryIDList.size());
        for (Long l : entryIDList) {
            entryId_objMap.put(String.valueOf(l), null);
        }
        DynamicObject[] objs = null;
        if (compIDList.size() > 0) {
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)compKey);
            for (DynamicObject obj2 : objs = BusinessDataServiceHelper.load((Object[])compIDList.toArray(new Object[0]), (DynamicObjectType)dynamicObject.getDynamicObjectType())) {
                DynamicObjectCollection entryCols = obj2.getDynamicObjectCollection("entryentity");
                for (DynamicObject entryCol : entryCols) {
                    if (!entryIDList.contains(entryCol.getLong("id"))) continue;
                    String entryId = String.valueOf(entryCol.getPkValue());
                    entryId_objMap.put(entryId, entryCol);
                }
            }
        }
        return entryId_objMap;
    }

    private static DynamicObjectCollection getPurListF7Data(Object[] parentIds, IFormView iFormView, boolean isQueryAll) {
        QFilter filter = SrcNegotiateUtil.getFilter(parentIds, iFormView, isQueryAll);
        filter.and("compkey", "=", (Object)iFormView.getEntityId());
        StringBuilder selectFieldsSb = new StringBuilder();
        selectFieldsSb.append("entryid").append(',').append("billid");
        String orderBy = PdsOrderByUtils.getOrderByString((String)"orderby001");
        DynamicObjectCollection cols = QueryServiceHelper.query((String)"src_purlistf7", (String)selectFieldsSb.toString(), (QFilter[])new QFilter[]{filter}, (String)orderBy);
        return cols;
    }

    private static QFilter getFilter(Object[] parentIds, IFormView iFormView, boolean isQueryAll) {
        QFilter filter = new QFilter("project", "in", (Object)parentIds);
        IFormView parentView = iFormView.getParentView();
        if (null != parentView) {
            String parentEntityKey = parentView.getEntityId();
            filter = SrcNegotiateUtil.getFilter(parentIds, parentEntityKey, isQueryAll);
        }
        return filter;
    }

    public static QFilter getFilter(Object[] parentIds, String parentEntityKey, boolean isQueryAll) {
        ExtPluginContext context = new ExtPluginContext();
        context.setHandleIds(Arrays.asList(parentIds).stream().map(e -> PdsCommonUtils.object2Long((Object)e)).collect(Collectors.toSet()));
        context.setHandleOk(isQueryAll);
        context.setPentitykey(parentEntityKey);
        ExtPluginFactory.executeExtplugin((String)SrcPurlistEntryFilter.class.getSimpleName(), (ExtPluginContext)context, (boolean)true, (String)SrcPurlistEntryFilter.class.getName());
        QFilter filter = context.getQfilters();
        StringBuilder msg = new StringBuilder();
        msg.append("getFilter filter:");
        msg.append(filter);
        log.info(msg.toString());
        return filter;
    }

    public static DynamicObject getNegBillObj(DynamicObject billObj, boolean isCompData) {
        long projectId;
        if (null == billObj) {
            return null;
        }
        if (isCompData) {
            billObj = billObj.getDynamicObject("project");
        }
        if (0L == (projectId = SrmCommonUtil.getPkValue((DynamicObject)billObj))) {
            return null;
        }
        QFilter qfilter = new QFilter("project", "=", (Object)projectId);
        return SrcNegotiateUtil.getQuoteBill("src_negotiatebill", qfilter);
    }

    public static boolean isSameProject(DynamicObject[] objs) {
        HashSet<Long> projects = new HashSet<Long>(16);
        for (DynamicObject obj : objs) {
            projects.add(obj.getLong("project.id"));
        }
        return projects.size() == 1;
    }

    public static boolean isVie(long projectId) {
        QFilter filter = new QFilter("project", "=", (Object)projectId);
        DynamicObject[] negObjs = BusinessDataServiceHelper.load((String)"src_negotiatebill", (String)"turns,negotiatetype,billstatus", (QFilter[])filter.toArray());
        DynamicObject lastTurnsNegBill = SrcNegotiateUtil.getLastTurnsNegBill(negObjs);
        if (null == lastTurnsNegBill) {
            return false;
        }
        String entryStatus = lastTurnsNegBill.getString("billstatus");
        if (!Objects.equals(entryStatus, "C")) {
            return false;
        }
        return "4".equals(lastTurnsNegBill.getString("negotiatetype"));
    }

    public static void createNegDetails(SrcNegOpenContext context) {
        if (null == context.getSupplierIds() || context.getSupplierIds().size() == 0) {
            return;
        }
        ArrayList<DynamicObject> negDetailList = new ArrayList<DynamicObject>(context.getSupplierIds().size());
        String supType = SupplierUtil.getSupType((DynamicObject)context.getNegBillObj());
        Iterator iterator = context.getSupplierIds().iterator();
        while (iterator.hasNext()) {
            long supplierId = (Long)iterator.next();
            DynamicObject negDetail = BusinessDataServiceHelper.newDynamicObject((String)"src_quote_detailsf7");
            negDetail.set("billid", context.getNegBillObj().get("project"));
            negDetail.set("suppliertype", (Object)supType);
            negDetail.set("supplier", (Object)supplierId);
            negDetail.set("turns", context.getNegBillObj().get("turns"));
            negDetail.set("negotiatetype", context.getNegBillObj().get("negotiatetype"));
            if (context.isOffline()) {
                negDetail.set("entrystatus", (Object)"B");
                negDetail.set("negotiatedate", (Object)TimeServiceHelper.now());
            } else {
                negDetail.set("entrystatus", (Object)"A");
            }
            negDetailList.add(negDetail);
        }
        PdsCommonUtils.saveDynamicObjects(negDetailList);
    }

    public static String getLastTurns(long projectId) {
        QFilter qfilter = new QFilter("project", "=", (Object)projectId);
        DynamicObject[] negObjs = BusinessDataServiceHelper.load((String)"src_negotiatebill", (String)"turns,negotiatetype,billstatus", (QFilter[])qfilter.toArray());
        DynamicObject lastTurnsNegBill = SrcNegotiateUtil.getLastTurnsNegBill(negObjs);
        if (null == lastTurnsNegBill) {
            return QuoteTurnsEnums.NEGOTIATE00.getValue();
        }
        return lastTurnsNegBill.getString("turns");
    }
}

