/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.util;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.container.Container;
import kd.bos.form.control.EntryGrid;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.BizLog;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.JSONUtils;
import kd.bos.util.StringUtils;
import kd.scm.common.ORMUtil;
import kd.scm.common.util.DateUtil;
import kd.scm.common.util.ParamUtil;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.enums.PdsBizNodeEnums;
import kd.scm.pds.common.enums.PdsFlowConfigEnum;
import kd.scm.pds.common.enums.ProjectStatusEnums;
import kd.scm.pds.common.enums.QuoteTurnsEnums;
import kd.scm.pds.common.enums.SourceTypeEnums;
import kd.scm.pds.common.extplugin.ExtPluginContext;
import kd.scm.pds.common.extplugin.ExtPluginFactory;
import kd.scm.pds.common.extplugin.IExtPluginHandler;
import kd.scm.pds.common.suplinkman.PdsLinkManFacade;
import kd.scm.pds.common.util.DynamicObjectUtil;
import kd.scm.pds.common.util.ExtParameterUtils;
import kd.scm.pds.common.util.MultiBasedataUtils;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.PdsCompConfigUtil;
import kd.scm.pds.common.util.PdsFlowConfigUtils;
import kd.scm.pds.common.util.SrcExchangeRateUtils;
import kd.scm.pds.common.util.SupplierUtil;
import kd.scm.pds.common.util.TemplateUtil;
import kd.scm.src.common.extplugin.purlist.SrcPurlistEntryEditHandler;
import kd.scm.src.common.util.SrcQuickPurUtil;

public class SrcPurListUtil {
    private static Log log = LogFactory.getLog(SrcPurListUtil.class);

    public static void writeBackSrcEntryData(IFormView compView, IFormView billView) {
        IExtPluginHandler writeBackHandle = (IExtPluginHandler)ExtPluginFactory.getInstance().getExtPluginInstance("IPurListWriteBackSrcEntryData");
        if (null != writeBackHandle) {
            ExtPluginContext context = new ExtPluginContext();
            context.setView(compView);
            context.setBillObj(compView.getModel().getDataEntity(true));
            context.setProjectObj(billView.getModel().getDataEntity(true));
            writeBackHandle.process(context);
        }
    }

    public static void validatorMaterialNaneSupplier(DynamicObjectCollection rows) {
        if (null == rows || rows.size() == 0) {
            return;
        }
        long projectId = ((DynamicObject)rows.get(0)).getLong("project.id");
        DynamicObject ratioRuleObj = BusinessDataServiceHelper.loadSingle((Object)projectId, (String)"src_project_rule");
        String ratioType = PdsCommonUtils.object2String((Object)ratioRuleObj.get("ratiotype"), (String)"1");
        Object orderRatioObj = ParamUtil.getParamObj((String)"0DUM2+6E41IA", (String)"orderratio");
        String orderRatio = String.valueOf(orderRatioObj == null ? ",1,2,5," : orderRatioObj);
        List orderRatioIndex = Arrays.stream(orderRatio.split(",")).filter(StringUtils::isNotEmpty).collect(Collectors.toList());
        Map<String, List<DynamicObject>> materialMap = rows.stream().filter(row -> !Objects.isNull(row.getDynamicObject("purlist"))).filter(row -> orderRatioIndex.contains(row.getString("result"))).collect(Collectors.groupingBy(row -> row.getString("purlist.id")));
        materialMap.forEach((key, value) -> {
            if (value.size() == 1) {
                DynamicObject col = (DynamicObject)value.get(0);
                if ("9".equals(ratioType)) {
                    if (col.getBigDecimal("orderratio").compareTo(BigDecimal.ZERO) <= 0) {
                        col.set("orderratio", (Object)100);
                    }
                } else {
                    col.set("orderratio", (Object)100);
                    if (col.getBigDecimal("cfmqty").compareTo(BigDecimal.ZERO) <= 0) {
                        col.set("cfmqty", (Object)col.getBigDecimal("qty"));
                    }
                }
            }
        });
    }

    public static List<Long> getInviteSupplier(Object pkValue) {
        DynamicObject supplierObj = TemplateUtil.getComponentData((String)String.valueOf(pkValue), (String)"src_supplier_invite");
        if (null == supplierObj) {
            return null;
        }
        DynamicObjectCollection rows = supplierObj.getDynamicObjectCollection("entrysupplier");
        return rows.stream().filter(row -> row.getDynamicObject("supplier") != null && row.getBoolean("isinvite")).map(row -> Long.parseLong(row.getDynamicObject("supplier").getPkValue().toString())).distinct().collect(Collectors.toList());
    }

    public static List<Map<String, Object>> getInviteSupplierAndPackage(Object pkValue) {
        DynamicObject[] rows = SrcPurListUtil.getInviteSupplierEntry(pkValue);
        if (rows.length == 0) {
            return null;
        }
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>(32);
        for (DynamicObject row : rows) {
            HashMap<String, Object> resultMap = new HashMap<String, Object>(32);
            if (!row.getBoolean("isinvite") || null == row.getDynamicObject("supplier") || null == row.getDynamicObject("package")) continue;
            resultMap.put("supplier", row.getDynamicObject("supplier"));
            resultMap.put("package", row.getDynamicObject("package").get("packagename"));
            resultList.add(resultMap);
        }
        return resultList;
    }

    private static DynamicObject[] getInviteSupplierEntry(Object pkValue) {
        return BusinessDataServiceHelper.load((String)"src_bidopensupplier", (String)"isinvite,suppliertype,supplier,package", (QFilter[])new QFilter[]{new QFilter("billid", "=", pkValue)});
    }

    public static void updatePurListEntry(DynamicObject obj) {
        boolean flag;
        DynamicObject[] pkgObjs;
        DynamicObject template = obj.getDynamicObject("template");
        if (null == template) {
            return;
        }
        long sourceFlowId = SrmCommonUtil.getPkValue((DynamicObject)obj.getDynamicObject("srctype"));
        boolean isManualCreatePackage = ExtParameterUtils.convertToBoolen((Object)ExtParameterUtils.getExtParameterValueById((String)"pds_flowconfig", (long)sourceFlowId, (String)"isManualCreatePackage", (Object)false, (long)SrmCommonUtil.getPkValue((DynamicObject)obj)));
        List compIdList = TemplateUtil.getCompIdList((DynamicObject)obj);
        ArrayList<DynamicObject> packageF7List = new ArrayList<DynamicObject>();
        HashSet<String> packageSet = new HashSet<String>(16);
        QFilter purListFilter = new QFilter("billid", "in", (Object)compIdList);
        DynamicObject[] objs = BusinessDataServiceHelper.load((String)"src_purlistf7", (String)"packagename,package,project,entrystatus,purlist,billtype,suppliertype,turns,org,reqsource,exratetable,isbizitem", (QFilter[])new QFilter[]{purListFilter}, (String)"packagename");
        Set<String> newPackageSet = SrcPurListUtil.getPackageSetByPurlist(objs);
        HashSet<String> delPackageSet = new HashSet<String>(newPackageSet.size());
        QFilter filter = new QFilter("project", "=", obj.getPkValue());
        HashMap<String, Long> pkgMap = new HashMap<String, Long>(16);
        for (DynamicObject pkgObj : pkgObjs = BusinessDataServiceHelper.load((String)"src_packagef7", (String)"packagename", (QFilter[])new QFilter[]{filter})) {
            String packageName = pkgObj.getString("packagename");
            pkgMap.put(packageName, SrmCommonUtil.getPkValue((DynamicObject)pkgObj));
            if (newPackageSet.contains(packageName)) continue;
            delPackageSet.add(packageName);
        }
        if (delPackageSet.size() > 0 && !isManualCreatePackage) {
            filter.and("packagename", "in", delPackageSet);
            DeleteServiceHelper.delete((String)"src_packagef7", (QFilter[])new QFilter[]{filter});
        }
        HashMap<String, Object> packageName_packF7IdMap = new HashMap<String, Object>(8);
        DynamicObject newObject = null;
        String packageName = null;
        String supType = SupplierUtil.getSupType(null);
        for (int i = 0; i < objs.length; ++i) {
            boolean isBizItem;
            packageName = objs[i].getString("packagename");
            if (StringUtils.isEmpty((String)packageName)) {
                packageName = "ByItem";
                objs[i].set("packagename", (Object)packageName);
            }
            if (!(isBizItem = objs[i].getBoolean("isbizitem")) && packageSet.add(packageName)) {
                Long pkgPkVal = (Long)pkgMap.get(packageName);
                if (null == pkgPkVal || pkgPkVal == 0L) {
                    newObject = SrcPurListUtil.createPackageF7(obj.getPkValue(), packageName, pkgMap);
                    packageF7List.add(newObject);
                    packageName_packF7IdMap.put(packageName, newObject.getPkValue());
                } else {
                    packageName_packF7IdMap.put(packageName, pkgPkVal);
                }
            }
            objs[i].set("package", packageName_packF7IdMap.get(packageName));
            objs[i].set("project", obj.getPkValue());
            objs[i].set("entrystatus", (Object)"A");
            objs[i].set("purlist", objs[i].getPkValue());
            objs[i].set("billtype", (Object)"1");
            if (StringUtils.isBlank((String)objs[i].getString("suppliertype"))) {
                objs[i].set("suppliertype", (Object)supType);
            }
            objs[i].set("turns", (Object)QuoteTurnsEnums.NEGOTIATE00.getValue());
            DynamicObject orgObj = objs[i].getDynamicObject("org");
            if (Objects.isNull(orgObj)) {
                objs[i].set("org", (Object)SrmCommonUtil.getPkValue((DynamicObject)obj.getDynamicObject("org")));
                continue;
            }
            String reqSource = objs[i].getString("reqsource");
            if (!Objects.equals(reqSource, "4")) continue;
            objs[i].set("exratetable_id", (Object)SrcExchangeRateUtils.getRateTableIdByOrg((long)SrmCommonUtil.getPkValue((DynamicObject)orgObj)));
        }
        boolean bl = flag = !CollectionUtils.isEmpty(packageName_packF7IdMap) && null == packageName_packF7IdMap.get("ByItem") || packageF7List.size() > 1;
        if (flag) {
            obj.set("ismultipackage", (Object)"1");
        } else {
            obj.set("ismultipackage", (Object)"0");
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{obj});
        if (objs.length > 0) {
            SaveServiceHelper.save((DynamicObject[])objs);
        }
        if (packageF7List.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])packageF7List.toArray(new DynamicObject[0]));
        }
    }

    private static Set<String> getPackageSetByPurlist(DynamicObject[] objs) {
        HashSet<String> packageSet = new HashSet<String>(16);
        for (int i = 0; i < objs.length; ++i) {
            boolean isBizItem = objs[i].getBoolean("isbizitem");
            if (isBizItem) continue;
            String packageName = objs[i].getString("packagename");
            if (StringUtils.isEmpty((String)packageName)) {
                packageName = "ByItem";
            }
            packageSet.add(packageName);
        }
        return packageSet;
    }

    public static void deletePurlistCompPackage(DynamicObject obj) {
        String manageType = obj.getString("managetype");
        if (!"1".equals(manageType)) {
            return;
        }
        List compIdList = TemplateUtil.getCompIdList((DynamicObject)obj);
        QFilter purListFilter = new QFilter("billid", "in", (Object)compIdList);
        DynamicObject[] objs = BusinessDataServiceHelper.load((String)"src_purlistf7", (String)"packagename,package,project,entrystatus,purlist", (QFilter[])new QFilter[]{purListFilter});
        ArrayList<DynamicObject> changedObjList = new ArrayList<DynamicObject>(objs.length);
        boolean isChanged = false;
        for (DynamicObject purlistObj : objs) {
            String packageName = purlistObj.getString("packagename");
            if (!"ByItem".equals(packageName)) continue;
            purlistObj.set("packagename", (Object)"");
            changedObjList.add(purlistObj);
            isChanged = true;
        }
        if (isChanged) {
            SaveServiceHelper.save((DynamicObject[])changedObjList.toArray(new DynamicObject[0]));
        }
    }

    public static DynamicObject createPackageF7(Object projectId, String packageName, Map<String, Long> pkgMap) {
        DynamicObject newObject = BusinessDataServiceHelper.newDynamicObject((String)"src_packagef7");
        ORMUtil.setPrimaryKey((DynamicObject)newObject);
        newObject.set("packagename", (Object)packageName);
        newObject.set("project", projectId);
        long packageId = PdsCommonUtils.object2Long((Object)pkgMap.get(packageName));
        if (packageId > 0L) {
            newObject.set("id", (Object)packageId);
            newObject.set("package", (Object)packageId);
        } else {
            newObject.set("package", newObject.getPkValue());
        }
        return newObject;
    }

    public static List<Long> getInviteSupplier(Object pkValue, Object packageId) {
        QFilter supFilter = new QFilter("billid", "=", (Object)Long.parseLong(pkValue.toString())).and("isinvite", "=", (Object)Boolean.TRUE).and("isabandon", "=", (Object)Boolean.FALSE).and("package", "=", (Object)Long.parseLong(packageId.toString()));
        DynamicObjectCollection supRows = QueryServiceHelper.query((String)"src_bidopensupplier", (String)"suppliertype,supplier.id", (QFilter[])supFilter.toArray());
        List<Long> supplierIds = supRows.stream().map(row -> row.getLong("supplier.id")).distinct().collect(Collectors.toList());
        return supplierIds;
    }

    public static boolean purlistQtyIsZero(DynamicObject project) {
        QFilter filter = new QFilter("project", "=", (Object)Long.parseLong(project.getPkValue().toString()));
        StringBuilder selectFieldsSb = new StringBuilder();
        selectFieldsSb.append("entryid").append(',').append("billid").append(',').append("qty").append(',').append("compkey");
        DynamicObjectCollection cols = QueryServiceHelper.query((String)"src_purlistf7", (String)selectFieldsSb.toString(), (QFilter[])new QFilter[]{filter});
        DynamicObject purlistObj = BusinessDataServiceHelper.loadSingle((Object)project.getPkValue(), (String)"src_purlist");
        Map<String, List<DynamicObject>> compKey_objMap = cols.stream().collect(Collectors.groupingBy(col -> col.getString("compkey")));
        for (Map.Entry<String, List<DynamicObject>> compKey_objEntry : compKey_objMap.entrySet()) {
            long qtyZeroCount;
            List editProList = PdsCompConfigUtil.getEditablePros((DynamicObject)purlistObj, (String)compKey_objEntry.getKey(), (String)"entryentity");
            if (!editProList.contains("qty") || (qtyZeroCount = compKey_objEntry.getValue().stream().filter(col -> col.getBigDecimal("qty").compareTo(BigDecimal.ZERO) <= 0).count()) <= 0L) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public static void createSupDataBySourceList(DynamicObject obj) {
        DynamicObjectCollection purListF7Cols = SrcPurListUtil.getPurlistF7DataByProject(new Long[]{Long.valueOf(obj.getPkValue().toString())});
        HashSet<Long> matrialIdSet = new HashSet<Long>();
        HashMap<String, List<Object>> matrial_purlistIdMap = new HashMap<String, List<Object>>(16);
        for (DynamicObject purListF7Col : purListF7Cols) {
            void var7_7;
            String material = purListF7Col.getString("material");
            if (null == material) continue;
            matrialIdSet.add(Long.valueOf(material));
            List list = (List)matrial_purlistIdMap.get(material);
            if (null == list) {
                ArrayList arrayList = new ArrayList();
            }
            var7_7.add(purListF7Col.get("purlist"));
            matrial_purlistIdMap.put(material, (List<Object>)var7_7);
        }
        List<Map<String, Long>> dataList = SrcPurListUtil.getPmSourceListData(obj, matrialIdSet);
        ArrayList<Object> supIdList = new ArrayList<Object>(16);
        for (Map map : dataList) {
            Object supplierId = map.get("supplierId");
            if (!(supplierId instanceof Long)) continue;
            supIdList.add(supplierId);
        }
        if (supIdList.size() == 0) {
            return;
        }
        String manageType = obj.getString("managetype");
        if ("3".equals(manageType)) {
            DynamicObject dynamicObject = SrcPurListUtil.createItemSupCompData(obj, dataList, matrial_purlistIdMap);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
        } else {
            DynamicObject dynamicObject = SrcPurListUtil.getInviteSupData(obj);
            SrcPurListUtil.setInviteSupData(obj, dynamicObject, supIdList);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
        }
    }

    public static DynamicObject getInviteSupData(DynamicObject obj) {
        QFilter filter = TemplateUtil.getComponentQfilter((String)String.valueOf(obj.getPkValue()), (String)"src_supplier_invite");
        return BusinessDataServiceHelper.loadSingle((String)"src_supplier_invite", (String)"condition,entrysupplier,package,suppliertype,supplier,supname,societycreditcode,linkman,phone,source,isinvite", (QFilter[])new QFilter[]{filter});
    }

    public static void setInviteSupData(DynamicObject obj, DynamicObject inviteObj, List<Object> supIdList) {
        DynamicObjectCollection inviteObjRows = inviteObj.getDynamicObjectCollection("entrysupplier");
        if (inviteObjRows == null) {
            log.info("setInviteSupData \u9080\u8bf7\u4f9b\u5e94\u5546\u5206\u5f55\u4e3a\u7a7a\u3002");
            return;
        }
        if (inviteObjRows.size() > 0) {
            inviteObjRows.clear();
        }
        SrcPurListUtil.createInviteSupEntry(obj, inviteObj, inviteObjRows, supIdList);
    }

    public static void createInviteSupEntry(DynamicObject obj, DynamicObject inviteObj, DynamicObjectCollection inviteObjRows, List<Object> supIdList) {
        DynamicObject supObj = BusinessDataServiceHelper.newDynamicObject((String)"bd_supplier");
        DynamicObject[] supObjs = (DynamicObject[])BusinessDataServiceHelper.load((Object[])supIdList.toArray(new Object[0]), (IDataEntityType)supObj.getDataEntityType());
        String managetype = obj.getString("managetype");
        if ("2".equals(managetype)) {
            QFilter pkgfilter = new QFilter("project.id", "=", (Object)Long.parseLong(obj.getPkValue().toString()));
            DynamicObjectCollection pkgCols = QueryServiceHelper.query((String)"src_packagef7", (String)"id", (QFilter[])new QFilter[]{pkgfilter});
            if (pkgCols == null || pkgCols.size() == 0) {
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{inviteObj});
                return;
            }
            for (DynamicObject pkg : pkgCols) {
                for (DynamicObject sup : supObjs) {
                    if (Objects.isNull(inviteObjRows)) continue;
                    DynamicObject supEntryObj = inviteObjRows.addNew();
                    supEntryObj.set("package", (Object)pkg.getLong("id"));
                    SrcPurListUtil.setInviteSupEntry(supEntryObj, sup);
                }
            }
        } else {
            HashSet<String> haveCreateSupSet = new HashSet<String>(supObjs.length);
            for (DynamicObject sup : supObjs) {
                DynamicObject supEntryObj = inviteObjRows.addNew();
                if (!haveCreateSupSet.add(String.valueOf(sup.getPkValue()))) continue;
                SrcPurListUtil.setInviteSupEntry(supEntryObj, sup);
            }
        }
    }

    public static void setInviteSupEntry(DynamicObject supEntryObj, DynamicObject supplier) {
        supEntryObj.set("suppliertype", (Object)"bd_supplier");
        supEntryObj.set("supplier", supplier.getPkValue());
        supEntryObj.set("supplier_id", supplier.getPkValue());
        supEntryObj.set("supname", (Object)supplier.getString("name"));
        supEntryObj.set("societycreditcode", (Object)supplier.getString("societycreditcode"));
        HashMap linkMap = PdsLinkManFacade.getSupplierLinkMan((DynamicObject)supplier);
        supEntryObj.set("linkman", linkMap.get("linkman"));
        supEntryObj.set("phone", linkMap.get("phone"));
        supEntryObj.set("isinvite", (Object)"1");
    }

    public static DynamicObject createItemSupCompData(DynamicObject obj, List<Map<String, Long>> dataList, Map<String, List<Object>> matrial_purlistIdMap) {
        SrcPurListUtil.deleteItemSupplierData(obj);
        DynamicObject itemSupObj = BusinessDataServiceHelper.newDynamicObject((String)"src_itemsupplier");
        itemSupObj.set("parentid", obj.getPkValue());
        itemSupObj.set("pentitykey", (Object)"src_project");
        itemSupObj.set("entitykey", (Object)"src_itemsupplier");
        HashMap mat_supMap = new HashMap(1);
        for (Map<String, Long> dataMap : dataList) {
            Long supplierId;
            long matId = dataMap.get("materialId");
            ArrayList<Long> supIdList = (ArrayList<Long>)mat_supMap.get(matId);
            if (null == supIdList) {
                supIdList = new ArrayList<Long>();
            }
            if (!((supplierId = dataMap.get("supplierId")) instanceof Long)) continue;
            supIdList.add(supplierId);
            mat_supMap.put(matId, supIdList);
        }
        DynamicObjectCollection cols = itemSupObj.getDynamicObjectCollection("entryentity");
        for (Map.Entry mat_supEntry : mat_supMap.entrySet()) {
            String material = String.valueOf(mat_supEntry.getKey());
            List<Object> purlistList = matrial_purlistIdMap.get(material);
            if (null == purlistList) continue;
            for (Object purlist : purlistList) {
                DynamicObject entry = cols.addNew();
                DynamicObjectCollection supCols = entry.getDynamicObjectCollection("supplier");
                List supIdList = (List)mat_supEntry.getValue();
                Iterator iterator = supIdList.iterator();
                while (iterator.hasNext()) {
                    long supId = (Long)iterator.next();
                    DynamicObject supCol = supCols.addNew();
                    supCol.set("fbasedataid", (Object)supId);
                }
                entry.set("purlist", purlist);
                entry.set("supplier", (Object)supCols);
            }
        }
        return itemSupObj;
    }

    public static void deleteItemSupplierData(DynamicObject obj) {
        String[] entityKeys = new String[]{"src_project", "src_bidpublish"};
        StringBuilder logMsg = new StringBuilder();
        for (int i = 0; i < entityKeys.length; ++i) {
            QFilter itemSupFilter = TemplateUtil.getComponentQfilter((Object)obj.getPkValue(), (String)entityKeys[i], (String)"src_itemsupplier");
            int delRows = DeleteServiceHelper.delete((String)"src_itemsupplier", (QFilter[])itemSupFilter.toArray());
            if (delRows <= 0) continue;
            logMsg.append("###del success->entityKey:").append(entityKeys[i]).append(",count:").append(delRows).append('\uff1b');
        }
        log.info(logMsg.length() == 0 ? "###del log" : logMsg.toString());
    }

    public static void deleteBidMaterial(DynamicObject obj) {
        QFilter qfilter = new QFilter("pentitykey", "not in", Arrays.asList("src_purlist", "src_project"));
        qfilter.and("parentid", "=", (Object)obj.getPkValue().toString());
        DeleteServiceHelper.delete((String)"src_purlistcomptpl", (QFilter[])qfilter.toArray());
    }

    public static List<Map<String, Long>> getPmSourceListData(DynamicObject obj, Set<Long> matrialIdSet) {
        HashMap<String, Object> params = new HashMap<String, Object>(4);
        DynamicObject org = obj.getDynamicObject("org");
        params.put("purchaseOrgId", null == org ? Long.valueOf(0L) : org.getPkValue());
        Date billDate = obj.getDate("billdate");
        String dateStr = DateUtil.date2str((Date)billDate, (String)"yyyy-MM-dd");
        params.put("bizDate", dateStr);
        params.put("materialIds", matrialIdSet);
        List<Map<String, Long>> dataList = new ArrayList<Map<String, Long>>();
        try {
            String jsonStr = JSONUtils.toString(params);
            Object result = DispatchServiceHelper.invokeBizService((String)"scmc", (String)"pm", (String)"SourceService", (String)"invokeSourceSupplier", (Object[])new Object[]{jsonStr});
            log.info("\u83b7\u53d6\u8d27\u6e90\u6e05\u5355\u6570\u636e\u8fd4\u56de\u7ed3\u679c\uff1a" + result);
            if (null != result) {
                Map resultMap = (Map)JSONUtils.cast((String)result.toString(), Map.class);
                Object success = resultMap.get("success");
                if (((Boolean)success).booleanValue()) {
                    dataList = (List)resultMap.get("data");
                } else {
                    log.info("\u83b7\u53d6\u8d27\u6e90\u6e05\u5355\u6570\u636e\u5931\u8d25\uff1a" + resultMap.get("message"));
                }
            }
        }
        catch (IOException e) {
            log.error((Throwable)e);
        }
        return dataList;
    }

    private static DynamicObjectCollection getPurlistF7DataByProject(Long[] projectIds) {
        QFilter filter = new QFilter("project", "in", (Object)projectIds);
        String selectFieldsSb = kd.scm.common.util.DynamicObjectUtil.getSelectfields((String)"src_purlistf7", (boolean)true);
        DynamicObjectCollection cols = QueryServiceHelper.query((String)"src_purlistf7", (String)selectFieldsSb, (QFilter[])new QFilter[]{filter});
        return cols;
    }

    public static void setPurListEditParams(DynamicObject row, Map<String, Object> params) {
        params.put("entrystatus", row.getString("entrystatus"));
        params.put("isnew", row.getBoolean("isnew"));
        params.put("material", row.getLong("material.id"));
        params.put("materialnane", row.getString("materialnane"));
        params.put("description", row.getString("description"));
        params.put("materialmodel", row.getString("materialmodel"));
        params.put("brand", row.getString("brand"));
        params.put("note", row.getString("note"));
    }

    public static void setCompData(TableValueSetter ts, Map.Entry<String, DynamicObject> entryMap, List<String> properties, int index) {
        DynamicObject col = entryMap.getValue();
        String entryId = entryMap.getKey();
        StringBuilder logMsg = new StringBuilder();
        for (String pro : properties) {
            if ("srcentryid".equals(pro)) {
                ts.set(pro, (Object)entryId, index);
                continue;
            }
            if ("turns".equals(pro)) {
                String turns = col.getString("turns");
                if (null != turns && turns.trim().length() > 0) {
                    ts.set(pro, (Object)turns, index);
                    continue;
                }
                ts.set(pro, (Object)"1", index);
                continue;
            }
            if ("purlistseq".equals(pro)) continue;
            if ("entryid".equals(pro)) {
                ts.set(pro, (Object)entryId, index);
                continue;
            }
            DynamicProperty property = col.getDynamicObjectType().getProperty(pro);
            if (null == property) continue;
            try {
                Object proVal = col.get(pro);
                if (proVal instanceof DynamicObject) {
                    ts.set(pro, ((DynamicObject)proVal).getPkValue(), index);
                    continue;
                }
                ts.set(pro, proVal, index);
            }
            catch (Exception e) {
                logMsg.append("###set property exception\uff1a").append(e.getMessage()).append('\uff1b');
            }
        }
        log.info(logMsg.length() == 0 ? "###set setCompData:" : logMsg.toString());
    }

    public static QFilter getBidMaterialFilter(DynamicObject parentObj, String sourceType) {
        Set<Object> ids = new HashSet(16);
        DynamicObject source = parentObj.getDynamicObject("source");
        if (Objects.nonNull(source)) {
            if (source.getBoolean("sceneitem")) {
                DynamicObject scene = parentObj.getDynamicObject("scene");
                Set<Object> sceneIds = new HashSet<Object>(16);
                if (Objects.nonNull(scene)) {
                    sceneIds.add(scene.getPkValue());
                } else {
                    DynamicObjectCollection sceneCols = source.getDynamicObjectCollection("entryentity");
                    sceneIds = Objects.isNull(sourceType) ? sceneCols.stream().filter(col -> !Objects.equals(col.getString("purtype.number"), SourceTypeEnums.DIRECT_PUR.getValue())).map(DataEntityBase::getPkValue).collect(Collectors.toSet()) : sceneCols.stream().filter(col -> Optional.ofNullable(col.getDynamicObject("purtype")).map(type -> Objects.equals(sourceType, type.getString("number"))).orElse(false)).map(DataEntityBase::getPkValue).collect(Collectors.toSet());
                }
                QFilter qFilter = new QFilter("entryid", "in", sceneIds);
                DynamicObjectCollection cols = QueryServiceHelper.query((String)"src_decisionitem", (String)"fbasedataid id", (QFilter[])qFilter.toArray());
                ids = cols.stream().map(col -> col.getLong("id")).collect(Collectors.toSet());
            } else {
                DynamicObjectCollection cols = QueryServiceHelper.query((String)"src_demandf7two", (String)"id,source", (QFilter[])new QFilter[]{new QFilter("source", "=", source.getPkValue())});
                ids = cols.stream().map(col -> col.getLong("id")).collect(Collectors.toSet());
            }
        }
        return new QFilter("id", "in", ids);
    }

    public static void setBidMaterialDisplay(IFormView view) {
        IExtPluginHandler handler = (IExtPluginHandler)ExtPluginFactory.getInstance().getExtPluginInstance("SrcDemandPushPurListFieldEnablePlugin");
        if (null != handler) {
            ExtPluginContext context = new ExtPluginContext();
            context.setView(view);
            handler.process(context);
        }
    }

    public static Set<Object> getCategoryIds(DynamicObject dataEntity) {
        HashSet<Object> categoryIds = new HashSet<Object>(16);
        DynamicObject sceneObj = dataEntity.getDynamicObject("scene");
        if (null != sceneObj) {
            DynamicObjectCollection categoryCollection = sceneObj.getDynamicObjectCollection("category");
            for (DynamicObject category : categoryCollection) {
                DynamicObject baseDataObj = category.getDynamicObject("fbasedataid");
                if (null == baseDataObj) continue;
                Object baseDataId = baseDataObj.getPkValue();
                categoryIds.add(baseDataId);
            }
        }
        return categoryIds;
    }

    public static void setMaterialFilter(IDataModel iDataModel, int row, ListShowParameter formShowParameter) {
        Object categoryId = Optional.ofNullable(iDataModel.getEntryRowEntity("entryentity", row)).map(object -> object.getDynamicObject("category")).map(DataEntityBase::getPkValue).orElse(null);
        if (Objects.nonNull(categoryId)) {
            formShowParameter.getListFilterParameter().setFilter(new QFilter("group.id", "=", categoryId));
        }
    }

    public static void createInviteSupEntryByItemSup(DynamicObject billObj, DynamicObject inviteSupplierEntry) {
        ArrayList<Object> supIdList = new ArrayList<Object>();
        DynamicObject itemSupplier = TemplateUtil.getComponentData((String)billObj.getString("id"), (String)"src_itemsupplier");
        if (null != itemSupplier) {
            DynamicObjectCollection itemSupCols = itemSupplier.getDynamicObjectCollection("entryentity");
            for (DynamicObject itemSupCol : itemSupCols) {
                DynamicObjectCollection supCols = itemSupCol.getDynamicObjectCollection("supplier");
                List currSupIdList = supCols.stream().map(supCol -> supCol.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList());
                supIdList.addAll(currSupIdList);
            }
        }
        SrcPurListUtil.setInviteSupData(billObj, inviteSupplierEntry, supIdList);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{inviteSupplierEntry});
    }

    public static void createSupplierObj(DynamicObject entry, DynamicObject obj, List<DynamicObject> objList, Object packageObj, boolean isExistNotifyNode) {
        DynamicObject sourceObj;
        boolean isNeedInvite;
        DynamicObject srcType;
        DynamicObject bidOpenSupplier = BusinessDataServiceHelper.newDynamicObject((String)"src_bidopensupplier");
        bidOpenSupplier.set("billid", obj.getPkValue());
        bidOpenSupplier.set("package", packageObj);
        bidOpenSupplier.set("suppliertype", (Object)entry.getString("suppliertype"));
        bidOpenSupplier.set("supplier", entry.get("supplier"));
        bidOpenSupplier.set("isinvite", entry.get("isinvite"));
        bidOpenSupplier.set("entryparentid", obj.get("parentid"));
        bidOpenSupplier.set("isdownload", entry.get("isdownload"));
        bidOpenSupplier.set("ispuragent", entry.get("ispuragent"));
        bidOpenSupplier.set("isfeeagent", entry.get("isfeeagent"));
        bidOpenSupplier.set("ispuraptitude", entry.get("ispuraptitude"));
        bidOpenSupplier.set("isexemptapt", entry.get("isexemptapt"));
        bidOpenSupplier.set("isaptitude", entry.get("isaptitude"));
        bidOpenSupplier.set("aptitudenote", entry.get("aptitudenote"));
        bidOpenSupplier.set("societycreditcode", entry.get("societycreditcode"));
        DynamicObjectCollection rows = entry.getDynamicObjectCollection("supplieruser");
        if (null != rows && rows.size() > 0) {
            MultiBasedataUtils.setMultiBasedataForObject((DynamicObject)bidOpenSupplier, (DynamicObjectCollection)rows, (String)"supplieruser");
        }
        if (Objects.nonNull(srcType = obj.getDynamicObject("srctype")) && !(isNeedInvite = srcType.getBoolean("isneedinvite")) && !isExistNotifyNode) {
            bidOpenSupplier.set("isconfirm", (Object)Boolean.TRUE);
        }
        if (null != (sourceObj = obj.getDynamicObject("sourceclass")) && Objects.equals(PdsFlowConfigEnum.QUICK_PUR.getCode(), sourceObj.getString("number"))) {
            bidOpenSupplier.set("isconfirm", (Object)Boolean.TRUE);
            bidOpenSupplier.set("isabandon", (Object)Boolean.FALSE);
            bidOpenSupplier.set("istender", (Object)Boolean.TRUE);
        }
        bidOpenSupplier.set("linkman", (Object)entry.getString("linkman"));
        bidOpenSupplier.set("duty", (Object)entry.getString("duty"));
        bidOpenSupplier.set("phone", (Object)entry.getString("phone"));
        bidOpenSupplier.set("address", (Object)entry.getString("address"));
        bidOpenSupplier.set("email", (Object)entry.getString("email"));
        objList.add(bidOpenSupplier);
    }

    public static void createTenderSupEntry(DynamicObject projectObj, DynamicObjectCollection entryCols, List<DynamicObject> objList) {
        Set package_supplierSet = SupplierUtil.getPackageId_SupplierIdSet((long)SrmCommonUtil.getPkValue((DynamicObject)projectObj), (long)0L, (long)0L, (String)"src_bidopensupplier");
        boolean isExistNotifyNode = PdsFlowConfigUtils.existsSpecificNode((DynamicObject)projectObj, (String)PdsBizNodeEnums.NOTIFY.getValue());
        for (DynamicObject entry : entryCols) {
            boolean isinvite = entry.getBoolean("isinvite");
            if (!isinvite) continue;
            long supplierId = entry.getLong("supplier.id");
            if (supplierId == 0L) {
                supplierId = entry.getLong("supplier");
            }
            if (projectObj.getString("managetype").equals("1") || projectObj.getString("managetype").equals("3")) {
                DynamicObjectCollection rows = QueryServiceHelper.query((String)"src_packagef7", (String)"id", (QFilter[])new QFilter[]{new QFilter("project", "=", projectObj.getPkValue())});
                for (DynamicObject row : rows) {
                    String key = String.valueOf(row.getLong("id")) + '_' + String.valueOf(supplierId);
                    if (!package_supplierSet.add(key)) continue;
                    SrcPurListUtil.createSupplierObj(entry, projectObj, objList, row.get("id"), isExistNotifyNode);
                }
                continue;
            }
            String key = String.valueOf(entry.getLong("package.id")) + '_' + String.valueOf(supplierId);
            if (!package_supplierSet.add(key)) continue;
            SrcPurListUtil.createSupplierObj(entry, projectObj, objList, entry.get("package"), isExistNotifyNode);
        }
    }

    public static long getNoPackageNameId(long projectId) {
        QFilter pacakgeFilter = new QFilter("project", "=", (Object)projectId);
        pacakgeFilter.and("packagename", "in", (Object)"ByItem");
        DynamicObject packageObj = BusinessDataServiceHelper.loadSingle((String)"src_packagef7", (String)"id", (QFilter[])pacakgeFilter.toArray());
        if (packageObj == null) {
            return 0L;
        }
        return SrmCommonUtil.getPkValue((DynamicObject)packageObj);
    }

    public static boolean checkPurlistStatus(IDataModel model, String status) {
        String billstatus;
        long projectId = PdsCommonUtils.object2Long((Object)model.getDataEntity().getPkValue());
        DynamicObjectCollection purlistCols = QueryServiceHelper.query((String)"src_purlist", (String)"id,billstatus", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)projectId)});
        return purlistCols.size() > 0 && status.equals(billstatus = ((DynamicObject)purlistCols.get(0)).getString("billstatus"));
    }

    public static boolean isContainPurlistComp(IFormView view, IDataModel model) {
        Set purlistCompKey;
        boolean isIntersected;
        List compKeyList = TemplateUtil.getCompKeyList((DynamicObject)model.getDataEntity(true));
        boolean bl = isIntersected = PdsCommonUtils.getIntersectSet(new HashSet(compKeyList), (Set)(purlistCompKey = TemplateUtil.getPurListCompKeySet())).size() > 0;
        return isIntersected;
    }

    public static boolean isPurlistComp(IFormView view, IDataModel model, String compKey) {
        Set purlistCompKey = TemplateUtil.getPurListCompKeySet();
        return purlistCompKey.contains(compKey);
    }

    public static void quickBuildPurListData(IFormView iFormView) {
        IFormView parentView = iFormView.getParentView();
        if (parentView == null) {
            return;
        }
        ArrayList<String> nodeNames = new ArrayList<String>(2);
        nodeNames.add("src_decision");
        nodeNames.add("src_predecision");
        if (!nodeNames.contains(parentView.getEntityId())) {
            return;
        }
        if (!SrcQuickPurUtil.isQuickPurchase((IFormView)iFormView, nodeNames)) {
            return;
        }
        if (SrcQuickPurUtil.isPublicQuickPurchase((IFormView)iFormView)) {
            return;
        }
        AbstractFormDataModel model = (AbstractFormDataModel)iFormView.getModel();
        Object projectId = parentView.getModel().getDataEntity().getPkValue();
        DynamicObject purListObj = BusinessDataServiceHelper.loadSingle((Object)projectId, (String)"src_purlist");
        List compKeys = TemplateUtil.getCompKeyListByTplEntry((DynamicObject)purListObj);
        for (String compKey : compKeys) {
            if (Objects.equals("src_purlist_item", compKey) || !Objects.equals(compKey, iFormView.getEntityId())) continue;
            List supObjList = SrcQuickPurUtil.getTenderBillF7SupplierAndPackage((Object)projectId);
            DynamicObjectCollection cols = model.getEntryEntity("entryentity");
            Map<String, List<DynamicObject>> groupMap = cols.stream().collect(Collectors.groupingBy(col -> col.getString("package.id") + "|" + col.getString("supplier.id") + "|" + col.getString("supplier.name")));
            HashSet seqSet = new HashSet();
            for (Map.Entry<String, List<DynamicObject>> entry : groupMap.entrySet()) {
                if (supObjList.remove(entry.getKey())) continue;
                seqSet.addAll(entry.getValue().stream().map(row -> row.getInt("seq") - 1).collect(Collectors.toSet()));
            }
            if (!CollectionUtils.isEmpty(seqSet)) {
                iFormView.getModel().deleteEntryRows("entryentity", seqSet.stream().mapToInt(Integer::valueOf).toArray());
            }
            if (CollectionUtils.isEmpty((Collection)supObjList)) continue;
            Map<Long, Set<Long>> itemSupMap = SrcPurListUtil.getItemSupplierMap(parentView.getModel().getDataEntity(true));
            DynamicObject purListCompObj = TemplateUtil.getComponentData((String)String.valueOf(projectId), (String)compKey);
            DynamicObjectCollection rows = purListCompObj.getDynamicObjectCollection("entryentity");
            EntryGrid entryGrid = (EntryGrid)iFormView.getControl("entryentity");
            if (null == entryGrid) {
                return;
            }
            List properties = DynamicObjectUtil.getContainerProperties((Container)entryGrid);
            SrcPurListUtil.removeInvalidProperties(properties);
            TableValueSetter ts = new TableValueSetter(new String[0]);
            SrcPurListUtil.buildData(rows, properties, ts, supObjList, itemSupMap);
            model.batchCreateNewEntryRow("entryentity", ts);
        }
    }

    private static void removeInvalidProperties(List<String> properties) {
        properties.remove("purlistseq");
        properties.remove("suppliername");
        properties.remove("costdetail");
    }

    private static void buildData(DynamicObjectCollection rows, List<String> properties, TableValueSetter ts, List<String> supObjList, Map<Long, Set<Long>> itemSupMap) {
        int i = 0;
        for (DynamicObject row : rows) {
            for (String supplierAndPackage : supObjList) {
                String[] arr;
                String packageId = row.getString("package.id");
                if (!Objects.equals(packageId, (arr = supplierAndPackage.split("\\|"))[0]) || itemSupMap.size() > 0 && !itemSupMap.get(row.getLong("id")).contains(PdsCommonUtils.object2Long((Object)arr[1]))) continue;
                for (String pro : properties) {
                    Object obj = row.get(pro);
                    if ("supplier".equals(pro)) {
                        ts.set(pro, (Object)arr[1], i);
                        ts.set("suppliername", (Object)arr[2], i);
                        continue;
                    }
                    if (obj instanceof DynamicObject) {
                        if ("packagename".equals(pro)) {
                            ts.set(pro, (Object)((DynamicObject)obj).getString("packagename"), i);
                            continue;
                        }
                        if ("compkey".equals(pro)) {
                            ts.set(pro, (Object)((DynamicObject)obj).getString("number"), i);
                            continue;
                        }
                        ts.set(pro, ((DynamicObject)obj).getPkValue(), i);
                        continue;
                    }
                    if ("entrystatus".equals(pro)) {
                        ts.set(pro, (Object)ProjectStatusEnums.OPENED.getValue(), i);
                        continue;
                    }
                    if (Objects.equals("billtype", pro)) {
                        ts.set(pro, (Object)"2", i);
                        continue;
                    }
                    if (obj instanceof DynamicObjectCollection) {
                        ts.set(pro, (Object)PdsCommonUtils.cloneAttachment((DynamicObject)row, (String)pro), i);
                        continue;
                    }
                    try {
                        ts.set(pro, row.get(pro), i);
                    }
                    catch (Exception exception) {
                        BizLog.log((String)exception.getMessage());
                    }
                }
                ++i;
            }
        }
    }

    public static Map<String, DynamicObject> getPurlistCompDataMap(String entityName, long pkId) {
        HashMap<String, DynamicObject> compMap = new HashMap<String, DynamicObject>(1);
        if (QueryServiceHelper.exists((String)entityName, (Object)pkId)) {
            DynamicObject billObj = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)entityName);
            List compKeyList = TemplateUtil.getCompKeyListByTplEntry((DynamicObject)billObj);
            Set purlistCompKeyList = TemplateUtil.getPurListCompKeySet();
            if (compKeyList != null && compKeyList.size() > 0) {
                for (String compKey : compKeyList) {
                    DynamicObject compObj;
                    if (!purlistCompKeyList.contains(compKey) || null == (compObj = TemplateUtil.getComponentData((Object)billObj.getPkValue(), (String)entityName, (String)compKey))) continue;
                    compMap.put(compKey, compObj);
                }
            }
        }
        return compMap;
    }

    public static Map<String, DynamicObject> getPurlistAllEntryMap(long projectId) {
        HashMap<String, DynamicObject> purlistMap = new HashMap<String, DynamicObject>(16);
        Map<String, DynamicObject> compMap = SrcPurListUtil.getPurlistCompDataMap("src_purlist", projectId);
        if (null == compMap || compMap.size() == 0) {
            compMap = SrcPurListUtil.getPurlistCompDataMap("src_project", projectId);
        }
        if (null == compMap || compMap.size() == 0) {
            compMap = SrcPurListUtil.getPurlistCompDataMap("src_biddoc", projectId);
        }
        if (null == compMap || compMap.size() == 0) {
            compMap = SrcPurListUtil.getPurlistCompDataMap("src_bidpublish", projectId);
        }
        for (Map.Entry<String, DynamicObject> entry : compMap.entrySet()) {
            DynamicObjectCollection rows;
            if (null == entry || (rows = entry.getValue().getDynamicObjectCollection("entryentity")) == null || rows.size() == 0) continue;
            Map<String, DynamicObject> entryMap = rows.stream().collect(Collectors.groupingBy(e -> e.getString("purlist.id"), Collectors.collectingAndThen(Collectors.toList(), value -> (DynamicObject)value.get(0))));
            purlistMap.putAll(entryMap);
        }
        return purlistMap;
    }

    public static Set<Long> getValidPackageIds(long projectId) {
        QFilter qfilters = SrcPurListUtil.getValidPackageFilter(projectId);
        DynamicObjectCollection rows = QueryServiceHelper.query((String)"src_purlistf7", (String)"package.id", (QFilter[])qfilters.toArray());
        if (rows == null || rows.size() == 0) {
            return Collections.emptySet();
        }
        return rows.stream().map(row -> row.getLong("package.id")).collect(Collectors.toSet());
    }

    public static QFilter getValidPackageFilter(long projectId) {
        QFilter qfilters = new QFilter("project", "=", (Object)projectId);
        qfilters.and("supplier", ">", (Object)0);
        qfilters.and("entrystatus", "not in", (Object)PdsCommonUtils.buildSet((String[])new String[]{ProjectStatusEnums.TOQUOTE.getValue(), ProjectStatusEnums.INVALID.getValue(), ProjectStatusEnums.DISCARDED.getValue(), ProjectStatusEnums.TERMINATED.getValue()}));
        return qfilters;
    }

    public static Set<Long> getNotInvalidPackageIds(long projectId) {
        QFilter qfilters = new QFilter("project", "=", (Object)projectId);
        qfilters.and("entrystatus", "not in", (Object)PdsCommonUtils.buildSet((String[])new String[]{ProjectStatusEnums.INVALID.getValue(), ProjectStatusEnums.DISCARDED.getValue(), ProjectStatusEnums.TERMINATED.getValue()}));
        DynamicObjectCollection rows = QueryServiceHelper.query((String)"src_purlistf7", (String)"package.id", (QFilter[])qfilters.toArray());
        if (rows == null || rows.size() == 0) {
            return Collections.emptySet();
        }
        return rows.stream().map(row -> row.getLong("package.id")).collect(Collectors.toSet());
    }

    public static Map<Long, Set<Long>> getItemSupplierMap(DynamicObject projectObj) {
        HashMap<Long, Set<Long>> itemSupMap = new HashMap<Long, Set<Long>>(32);
        if (!"3".equals(projectObj.getString("managetype"))) {
            return itemSupMap;
        }
        DynamicObject itemSupObj = TemplateUtil.getCompData((DynamicObject)projectObj, (String)"src_itemsupplier");
        if (null == itemSupObj) {
            return itemSupMap;
        }
        DynamicObjectCollection rows = itemSupObj.getDynamicObjectCollection("entryentity");
        for (DynamicObject row : rows) {
            itemSupMap.put(row.getLong("purlist.id"), MultiBasedataUtils.getBasedataIdSet((DynamicObject)row, (String)"supplier"));
        }
        return itemSupMap;
    }

    public static void purlistEntryEditHandle(IFormView view, int rowIndex, String fieldKey, PropertyChangedArgs args) {
        ExtPluginContext context = new ExtPluginContext();
        context.setView(view);
        context.setSourceRow(view.getModel().getEntryRowEntity("entryentity", rowIndex));
        context.setIndex(rowIndex);
        context.setOperationKey(fieldKey);
        context.setPropertyChangeArgs(args);
        ExtPluginFactory.executeExtplugin((String)SrcPurlistEntryEditHandler.class.getSimpleName(), (ExtPluginContext)context, (boolean)true);
    }
}

