/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.vie;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.util.ExceptionUtil;
import kd.scm.pds.common.enums.ProcessStatusEnums;
import kd.scm.pds.common.enums.SrcVieStatusEnums;
import kd.scm.pds.common.vie.PdsVieContext;
import kd.scm.pds.common.vie.PdsVieHelper;
import kd.scm.src.common.bidopen.SrcBidOpenFacade;
import kd.scm.src.common.calc.SrcCalcHelper;
import kd.scm.src.common.vie.ISrcFinishVerify;
import kd.scm.src.common.vie.ISrcVieAddtime;
import kd.scm.src.common.vie.ISrcVieAuthorityVerify;
import kd.scm.src.common.vie.ISrcVieCDByRefresh;
import kd.scm.src.common.vie.ISrcVieDelaytime;
import kd.scm.src.common.vie.ISrcVieFinish;
import kd.scm.src.common.vie.ISrcVieInitDynamic;
import kd.scm.src.common.vie.ISrcVieInitStatic;
import kd.scm.src.common.vie.ISrcViePause;
import kd.scm.src.common.vie.ISrcVieRestart;
import kd.scm.src.common.vie.SrcVieFactory;

public class SrcVieFacade {
    public static void initRedisCache(PdsVieContext context) {
        if ((context.getVieTechScheme().equals("2") || context.getVieTechScheme().equals("3")) && PdsVieHelper.isInitializeRedisCache((PdsVieContext)context)) {
            SrcVieFacade.initSupRankPriceMap(context);
            SrcVieFactory.getSrcRedisUpdateFromDB().getData(context).handleData(context).updateRedis(context);
            PdsVieHelper.allowInitializeRedisCache((PdsVieContext)context, (String)"0");
        }
    }

    public static void initSupRankPriceMap(PdsVieContext context) {
        QFilter qfilter = new QFilter("project", "=", (Object)context.getProjectId());
        DynamicObjectCollection rows = QueryServiceHelper.query((String)"src_vie_detailf7", (String)"purlist.id", (QFilter[])qfilter.toArray());
        Set purlistIdSet = rows.stream().map(e -> e.getLong("purlist.id")).collect(Collectors.toSet());
        for (Long purlistId : purlistIdSet) {
            String key = String.valueOf(context.getProjectId()) + '|' + String.valueOf(purlistId);
            PdsVieHelper.getInstance().remove(key);
        }
    }

    public static void initVieDynamic(PdsVieContext context) {
        List srcVieInitDynamics = SrcVieFactory.getSrcVieInitDynamics();
        for (ISrcVieInitDynamic srcVieInitDynamic : srcVieInitDynamics) {
            srcVieInitDynamic.process(context);
        }
    }

    public static void initVieStatic(PdsVieContext context) {
        List srcVieInitStatics = SrcVieFactory.getSrcVieInitStatics();
        for (ISrcVieInitStatic srcVieInitStatic : srcVieInitStatics) {
            srcVieInitStatic.process(context);
        }
    }

    public static void refreshByCountDown(IFormView view) {
        PdsVieContext context = SrcVieFactory.createVieContext((IFormView)view);
        List handlers = SrcVieFactory.getSrcVieCDByRefresh();
        for (ISrcVieCDByRefresh handler : handlers) {
            handler.process(context);
        }
    }

    public static void refreshByTimeOut(IFormView view) {
        SrcVieFactory.getSrcVieCDByTimeOut().process(SrcVieFactory.createVieContext((IFormView)view));
    }

    public static void refreshRank(PdsVieContext context) {
        if (context.getVieTechScheme().equals("1")) {
            SrcVieFactory.getSrcQuoteRefreshFromDB().getData(context).handleData(context).refreshData(context);
        }
    }

    public static void saveFinishData(PdsVieContext context) {
        Map finishData = context.getFinishData();
        if (finishData == null || finishData.size() == 0) {
            context.setSucced(Boolean.FALSE.booleanValue());
            context.setMessage(ResManager.loadKDString((String)"\u6ca1\u6709\u9700\u8981\u4fdd\u5b58\u7684\u6570\u636e\u3002", (String)"SrcVieFacade_0", (String)"scm-src-common", (Object[])new Object[0]));
            return;
        }
        try (TXHandle h = TX.required();){
            try {
                for (Map.Entry entry : finishData.entrySet()) {
                    SaveServiceHelper.save((DynamicObject[])((DynamicObject[])entry.getValue()));
                }
            }
            catch (Exception e) {
                context.setSucced(Boolean.FALSE.booleanValue());
                h.markRollback();
                throw new KDBizException(ExceptionUtil.getStackTrace((Throwable)e));
            }
        }
    }

    public static void setFinishData(PdsVieContext context, String key, DynamicObject[] dataObjs) {
        HashMap<String, DynamicObject[]> finishData = context.getFinishData();
        if (finishData == null) {
            finishData = new HashMap<String, DynamicObject[]>(8);
        }
        finishData.put(key, dataObjs);
        context.setFinishData(finishData);
    }

    public static void vieHandle(PdsVieContext context) {
        SrcVieFacade.vieAuthorityVerify(context);
        if (!context.isAuthority()) {
            return;
        }
        switch (context.getHandleType()) {
            case "E": {
                SrcVieFacade.vieRestart(context);
                break;
            }
            case "A": {
                SrcVieFacade.viePause(context);
                break;
            }
            case "B": {
                SrcVieFacade.vieFinish(context);
                break;
            }
            case "C": {
                SrcVieFacade.vieTerminate(context);
                break;
            }
            case "D": {
                SrcVieFacade.vieAddTime(context);
                break;
            }
            case "F": {
                SrcVieFacade.vieDelayTime(context);
                break;
            }
            default: {
                return;
            }
        }
    }

    public static void vieAuthorityVerify(PdsVieContext context) {
        List authorityVerifys = SrcVieFactory.getSrcVieAuthorityVerify();
        for (ISrcVieAuthorityVerify authorityVerify : authorityVerifys) {
            if (!context.isAuthority()) continue;
            authorityVerify.process(context);
        }
    }

    public static synchronized boolean vieAddTime(PdsVieContext context) {
        Boolean isAddTime = false;
        List srcVieAddtimes = SrcVieFactory.getSrcVieAddtimes();
        for (ISrcVieAddtime srcVieAddtime : srcVieAddtimes) {
            srcVieAddtime.process(context);
            if (!context.isAddTime()) continue;
            isAddTime = true;
        }
        if (isAddTime.booleanValue()) {
            ThreadPools.executeOnce((String)"Http-request-pool-SrcVieOnlinePlugin-countdown", () -> SrcVieFactory.getSrcVieCDByTimeOutDaemon().process(SrcVieFactory.createVieContext((IFormView)context.getView())));
        }
        return isAddTime;
    }

    public static synchronized void vieDelayTime(PdsVieContext context) {
        List srcVieDelaytimes = SrcVieFactory.getSrcVieDelaytimes();
        for (ISrcVieDelaytime srcVieDelaytime : srcVieDelaytimes) {
            srcVieDelaytime.process(context);
        }
    }

    public static void verifyFinish(PdsVieContext context) {
        List finishVerifys = SrcVieFactory.getSrcFinishVerify();
        for (ISrcFinishVerify finishVerify : finishVerifys) {
            finishVerify.verifyData(context);
        }
    }

    public static synchronized void vieFinish(PdsVieContext context) {
        PdsVieContext newContext = null;
        newContext = null != context.getView() ? SrcVieFactory.createVieContext((PdsVieContext)context) : SrcVieFactory.getSrcVieInitContext().createVieContext(context.getProjectId());
        newContext.setVerify(Boolean.TRUE.booleanValue());
        SrcVieFacade.verifyFinish(newContext);
        if (newContext.isVerify()) {
            newContext.setSucced(Boolean.TRUE.booleanValue());
            List srcVieFinishs = SrcVieFactory.getSrcVieFinishs();
            for (ISrcVieFinish srcVieFinish : srcVieFinishs) {
                srcVieFinish.process(newContext);
                if (newContext.isSucced()) continue;
                break;
            }
            if (newContext.isSucced()) {
                SrcVieFacade.saveFinishData(newContext);
            }
            SrcBidOpenFacade.setProjectOpenStatus((long)context.getProjectId());
            if (newContext.isSucced()) {
                SrcCalcHelper.syntheticalCalculate((String)"src_compare", (long)context.getProjectId());
                newContext.setMessage(ResManager.loadKDString((String)"\u7ade\u4ef7\u5904\u7406\u5df2\u6210\u529f\u3002", (String)"SrcVieFacade_3", (String)"scm-src-common", (Object[])new Object[0]));
            } else {
                newContext.setMessage(ResManager.loadKDString((String)"\u7ade\u4ef7\u5904\u7406\u5931\u8d25\uff0c\u8bf7\u91cd\u65b0\u5904\u7406\u3002", (String)"SrcVieFacade_4", (String)"scm-src-common", (Object[])new Object[0]));
            }
        }
        if (!StringUtils.isBlank((CharSequence)newContext.getMessage())) {
            newContext.getView().showMessage(newContext.getMessage());
        }
    }

    public static synchronized void viePause(PdsVieContext context) {
        List srcViePauses = SrcVieFactory.getSrcViePauses();
        for (ISrcViePause srcViePause : srcViePauses) {
            srcViePause.process(context);
        }
    }

    public static synchronized void vieRestart(PdsVieContext context) {
        context.setSucced(true);
        List srcVieRestarts = SrcVieFactory.getSrcVieRestarts();
        for (ISrcVieRestart srcVieRestart : srcVieRestarts) {
            srcVieRestart.process(context);
        }
        if (context.isSucced()) {
            ThreadPools.executeOnce((String)"Http-request-pool-SrcVieOnlinePlugin-countdown", () -> SrcVieFactory.getSrcVieCDByTimeOutDaemon().process(SrcVieFactory.createVieContext((IFormView)context.getView())));
        }
    }

    public static synchronized void vieTerminate(PdsVieContext context) {
    }

    public static void setCompeteBillStatus(DynamicObject billObj, DynamicObject competebillObj, DynamicObject turnsObj, List<DynamicObject> competeBillObjs) {
        String bidStatus = competebillObj.getString("bidstatus");
        if (bidStatus == null || "".equals(bidStatus.trim())) {
            bidStatus = SrcVieStatusEnums.BEENEXAMINED.getValue();
        }
        Date openDate = billObj.getDate("opendate");
        if (bidStatus.equals(SrcVieStatusEnums.PAUSED.getValue())) {
            competebillObj.set("pausestarttime", (Object)openDate);
        } else {
            competebillObj.set("opendate", (Object)openDate);
        }
        competebillObj.set("bidstatus", (Object)SrcVieStatusEnums.BIDDING.getValue());
        if (null != turnsObj) {
            turnsObj.set("turnsopendate", (Object)openDate);
            turnsObj.set("turnsbidstatus", (Object)SrcVieStatusEnums.BIDDING.getValue());
        }
        competeBillObjs.add(competebillObj);
    }

    public static void setQuoteBillStatus(long projectId, String turns, String vieturns, List<DynamicObject> quoteBillObjs) {
        QFilter qfilter = new QFilter("project", "=", (Object)projectId).and("turns", "=", (Object)turns);
        qfilter.and("bizstatus", "!=", (Object)ProcessStatusEnums.TERMINATED.getValue());
        DynamicObject[] quoteObjs = BusinessDataServiceHelper.load((String)"tnd_quotebill", (String)"billstatus,bizstatus,isfinish,opentype,turns,vieturns", (QFilter[])qfilter.toArray());
        if (quoteObjs == null || quoteObjs.length == 0) {
            return;
        }
        for (DynamicObject quoteObj : quoteObjs) {
            quoteObj.set("vieturns", (Object)vieturns);
            quoteObj.set("isfinish", (Object)"0");
            quoteObj.set("billstatus", (Object)BillStatusEnum.SUBMIT.getVal());
            quoteObj.set("bizstatus", (Object)ProcessStatusEnums.PROCESSED.getValue());
            quoteBillObjs.add(quoteObj);
        }
    }

    public static void setCostDetailStatus(List<DynamicObject> quoteBillObjs, List<DynamicObject> costDetailObjs) {
        if (null == quoteBillObjs || quoteBillObjs.size() == 0) {
            return;
        }
        Set parentIds = quoteBillObjs.stream().map(e -> e.getString("id")).collect(Collectors.toSet());
        QFilter compFilter = new QFilter("parentid", "in", parentIds);
        DynamicObjectCollection compRows = QueryServiceHelper.query((String)"src_purlistcomptpl", (String)"id", (QFilter[])compFilter.toArray());
        if (null == compRows || compRows.size() == 0) {
            return;
        }
        Set billIds = compRows.stream().map(e -> e.getLong("id")).collect(Collectors.toSet());
        QFilter purlistFilter = new QFilter("billid", "in", billIds);
        DynamicObjectCollection rows = QueryServiceHelper.query((String)"src_purlistf7", (String)"id", (QFilter[])purlistFilter.toArray());
        if (null == rows || rows.size() == 0) {
            return;
        }
        Set entryIds = rows.stream().map(e -> e.getLong("id")).collect(Collectors.toSet());
        QFilter costDetailFilter = new QFilter("purlist", "in", entryIds);
        DynamicObject[] costDetailBills = BusinessDataServiceHelper.load((String)"tnd_costdetail", (String)"billstatus", (QFilter[])costDetailFilter.toArray());
        if (costDetailBills == null || costDetailBills.length == 0) {
            return;
        }
        for (DynamicObject costDetailObj : costDetailBills) {
            costDetailObj.set("billstatus", (Object)BillStatusEnum.SAVE.getVal());
            costDetailObjs.add(costDetailObj);
        }
    }

    public static Set<Long> getVieSupplierIds(PdsVieContext context) {
        QFilter vieFilter = new QFilter("project", "=", (Object)context.getProjectId()).and("turns", "=", (Object)context.getTurns()).and("vieturns", "=", (Object)context.getVieturns());
        DynamicObjectCollection vieRows = QueryServiceHelper.query((String)"src_vie_detailf7", (String)"supplier.id", (QFilter[])vieFilter.toArray());
        if (vieRows.size() == 0) {
            return Collections.emptySet();
        }
        return vieRows.stream().map(e -> e.getLong("supplier.id")).collect(Collectors.toSet());
    }

    public static Set<Long> getQuoteSupplierIds(PdsVieContext context) {
        QFilter quoteFilter = new QFilter("project", "=", (Object)context.getProjectId()).and("turns", "=", (Object)context.getTurns());
        DynamicObjectCollection quoteRows = QueryServiceHelper.query((String)"tnd_quotebill", (String)"supplier.id", (QFilter[])quoteFilter.toArray());
        if (quoteRows.size() == 0) {
            return Collections.emptySet();
        }
        return quoteRows.stream().map(e -> e.getLong("supplier.id")).collect(Collectors.toSet());
    }
}

