/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.tnd.formplugin.list;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.scm.pds.common.entity.PdsObjectPools;
import kd.scm.pds.common.enums.BidOpenStatusEnums;
import kd.scm.pds.common.extplugin.IExtendPlugin;
import kd.scm.pds.common.nodestatus.SrcNodeStatusContext;
import kd.scm.pds.common.nodestatus.SrcNodeStatusData;
import kd.scm.pds.common.nodestatus.SrcNodeStatusHandler;
import kd.scm.pds.common.nodestatus.SrcNodeStatusHandlerFactory;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.tnd.common.util.TndListFilterUtil;

public class TndProjectListHandler
implements IExtendPlugin {
    private static final long serialVersionUID = 1L;
    private static ExecutorService threadPool = ThreadPools.newCachedExecutorService((String)"TndProjectListHandler", (int)10, (int)50);

    public DynamicObjectCollection handleNodeStatus(DynamicObjectCollection rows) {
        DynamicObjectCollection todoRows = new DynamicObjectCollection();
        for (DynamicObject row : rows) {
            String openStatus = row.getString("openstatus");
            if (BidOpenStatusEnums.DECISION.getValue().equals(openStatus)) {
                row.set("todotask", (Object)"--");
                row.set("donetask", (Object)ResManager.loadKDString((String)"\u5df2\u5b9a\u6807", (String)"TndProjectListHandler_0", (String)"scm-tnd-formplugin", (Object[])new Object[0]));
                continue;
            }
            if (BidOpenStatusEnums.ARCHIVED.getValue().equals(openStatus)) {
                row.set("todotask", (Object)"--");
                row.set("donetask", (Object)ResManager.loadKDString((String)"\u5df2\u5f52\u6863", (String)"TndProjectListHandler_1", (String)"scm-tnd-formplugin", (Object[])new Object[0]));
                continue;
            }
            if (BidOpenStatusEnums.TERMINATED.getValue().equals(openStatus)) {
                row.set("todotask", (Object)"--");
                row.set("closetask", (Object)ResManager.loadKDString((String)"\u5df2\u7ec8\u6b62", (String)"TndProjectListHandler_2", (String)"scm-tnd-formplugin", (Object[])new Object[0]));
                continue;
            }
            todoRows.add((Object)row);
        }
        if (todoRows.size() > 0) {
            this.getNodeStatusByThreads(todoRows);
        }
        return rows;
    }

    private void getNodeStatusByThreads(DynamicObjectCollection rows) {
        List splitList = PdsCommonUtils.splitList((List)rows, (int)10);
        CompletableFuture[] futures = new CompletableFuture[splitList.size()];
        for (int i = 0; i < splitList.size(); ++i) {
            DynamicObjectCollection splitRows = new DynamicObjectCollection(((DynamicObject)rows.get(0)).getDynamicObjectType(), null, (List)splitList.get(i));
            futures[i] = CompletableFuture.runAsync(() -> this.getNodeStatus(splitRows), threadPool);
        }
        try {
            CompletableFuture.allOf(futures).get(60L, TimeUnit.SECONDS);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void getNodeStatus(DynamicObjectCollection rows) {
        String selectFields = "id,tendertype,srctypeid.isneedinvite,srctypeid.id,isneedinvite";
        Set projectIds = rows.stream().map(e -> e.getLong("id")).collect(Collectors.toSet());
        QFilter qfilter = new QFilter("id", "in", projectIds);
        DynamicObjectCollection projectObjs = QueryServiceHelper.query((String)"tnd_project", (String)selectFields, (QFilter[])qfilter.toArray());
        if (null == projectObjs || projectObjs.size() == 0) {
            return;
        }
        HashMap<Long, SrcNodeStatusContext> tempMap = new HashMap<Long, SrcNodeStatusContext>(projectObjs.size());
        for (DynamicObject projectObj : projectObjs) {
            this.getProjectNodeStatus(projectObj, tempMap);
        }
        this.setTaskStatusInfo(rows, tempMap);
    }

    private void getProjectNodeStatus(DynamicObject projectObj, Map<Long, SrcNodeStatusContext> nodeStatusMap) {
        List<DynamicObject> bizNodes = this.getBizNodes(projectObj);
        if (null == bizNodes || bizNodes.size() == 0) {
            return;
        }
        SrcNodeStatusContext context = this.createNodeStatusContext();
        context.setProjectId(projectObj.getLong("id"));
        context.setNodeList(new ArrayList());
        TndListFilterUtil.isConfirm((DynamicObject)projectObj, (SrcNodeStatusContext)context);
        int index = 0;
        for (DynamicObject bizNode : bizNodes) {
            context.setNodeObj(bizNode);
            context.setNodeSeq(index);
            SrcNodeStatusHandler nodeHandler = SrcNodeStatusHandlerFactory.getStrategyInstance((SrcNodeStatusContext)context);
            if (nodeHandler != null) {
                nodeHandler.nodeStatusHandle(context);
            }
            ++index;
        }
        nodeStatusMap.put(projectObj.getLong("id"), context);
    }

    public List<DynamicObject> getBizNodes(DynamicObject projectObj) {
        String tendertype = PdsCommonUtils.object2String((Object)projectObj.get("tendertype"), (String)"1");
        boolean isNeedInvite = projectObj.getBoolean("srctypeid.isneedinvite");
        if (!isNeedInvite) {
            isNeedInvite = "2".equals(projectObj.getString("isneedinvite"));
        }
        QFilter srctypeFilter = new QFilter("issupplier", "=", (Object)Character.valueOf('1'));
        srctypeFilter.and("tendertype", "=", (Object)tendertype);
        StringBuilder key = new StringBuilder();
        key.append("TndProjectListHandler").append('|').append("pds_flowconfig").append('|').append(tendertype).append('|').append(isNeedInvite ? "1" : "0");
        List<Object> bizNodeList = (List<DynamicObject>)PdsObjectPools.getInstance((String)key.toString());
        if (null != bizNodeList) {
            return bizNodeList;
        }
        DynamicObject tempObj = QueryServiceHelper.queryOne((String)"pds_flowconfig", (String)"id", (QFilter[])srctypeFilter.toArray());
        if (null == tempObj) {
            return null;
        }
        DynamicObject flowConfigObj = BusinessDataServiceHelper.loadSingle((Object)tempObj.getLong("id"), (String)"pds_flowconfig");
        DynamicObjectCollection bizNodes = flowConfigObj.getDynamicObjectCollection("entrynode");
        if (null == bizNodes || bizNodes.size() == 0) {
            return null;
        }
        bizNodeList = isNeedInvite ? bizNodes : bizNodes.stream().filter(e -> !e.getString("biznode.number").equals("34")).collect(Collectors.toList());
        PdsObjectPools.putInstance((String)key.toString(), (Object)bizNodeList);
        return bizNodeList;
    }

    public String getTaskNameByBizStatus(SrcNodeStatusContext context, List<String> bizStatusSet, boolean isTodoTask) {
        List tasks = context.getNodeList().stream().filter(e -> bizStatusSet.contains(e.getBizStatus())).collect(Collectors.toList());
        if (null == tasks || tasks.size() == 0) {
            if (isTodoTask) {
                return "";
            }
            return "--";
        }
        StringBuilder sb = new StringBuilder();
        for (SrcNodeStatusData task : tasks) {
            if (isTodoTask) {
                sb.append(task.getEntityName()).append('|').append(task.getBillId());
            } else {
                sb.append(task.getNodeName());
            }
            sb.append(',');
        }
        return sb.substring(0, sb.toString().lastIndexOf(44));
    }

    private void setTaskStatusInfo(DynamicObjectCollection rows, Map<Long, SrcNodeStatusContext> nodeStatusMap) {
        for (DynamicObject row : rows) {
            SrcNodeStatusContext context = nodeStatusMap.get(PdsCommonUtils.object2Long((Object)row.getPkValue()));
            if (null == context) continue;
            String todoTask = this.getTaskNameByBizStatus(context, Arrays.asList("A", "B"), true);
            row.set("todotask", (Object)todoTask);
            String doneTask = this.getTaskNameByBizStatus(context, Collections.singletonList("C"), false);
            row.set("donetask", (Object)doneTask);
            String closeTask = this.getTaskNameByBizStatus(context, Arrays.asList("D", "E"), false);
            row.set("closetask", (Object)closeTask);
        }
    }

    private SrcNodeStatusContext createNodeStatusContext() {
        SrcNodeStatusContext context = new SrcNodeStatusContext();
        List supplierList = PdsCommonUtils.getSupplierByUserOfBizPartner();
        context.setSupplierList(supplierList);
        context.setSupplierType("bd_supplier");
        return context;
    }
}

