/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.tnd.common.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.BillOperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.pds.common.entity.PdsObjectPools;
import kd.scm.pds.common.enums.SourceTypeEnums;
import kd.scm.pds.common.util.CheckPermission4OrgUtils;
import kd.scm.pds.common.util.OpenFormUtils;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.vie.PdsVieHelper;

public class TndProjectTaskUtils {
    public static Map<String, Long> getTodoTaskMap(String todoTaskStr) {
        HashMap<String, Long> todoTaskMap = new HashMap<String, Long>();
        if (todoTaskStr.length() > 5) {
            String[] todoTasks;
            for (String todoTask : todoTasks = todoTaskStr.split("\\,")) {
                String[] myTasks = todoTask.split("\\|");
                todoTaskMap.put(myTasks[0], Long.valueOf(myTasks[1]));
            }
        }
        return todoTaskMap;
    }

    public static void openProjectTask(IFormView view, String callbackClassName, String entityName, long billId, String biztype) {
        if (billId == 0L || null == entityName) {
            return;
        }
        if (!QueryServiceHelper.exists((String)entityName, (Object)billId)) {
            view.showTipNotification(ResManager.loadKDString((String)"\u91c7\u8d2d\u65b9\u5df2\u64a4\u9500\u6b64\u5355\u636e\uff0c\u8bf7\u5237\u65b0\u540e\u518d\u8bd5\u3002", (String)"TndProjectTaskUtils_1", (String)"scm-tnd-common", (Object[])new Object[0]));
            return;
        }
        boolean isPermission = CheckPermission4OrgUtils.checkPermission4Org((String)entityName, (String)String.valueOf(billId), (String)"47150e89000000ac", (String)"0DUMFA=HL9S1");
        if (!isPermission) {
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityName);
            view.showTipNotification(String.format(ResManager.loadKDString((String)"\u65e0\u201c%1$s\u201d\u7684\u67e5\u770b\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"TndProjectTaskUtils_0", (String)"scm-tnd-common", (Object[])new Object[0]), mainEntityType.getDisplayName().getLocaleValue()));
            return;
        }
        if (TndProjectTaskUtils.isOpenVieHall(entityName, billId)) {
            Map paraMap = PdsVieHelper.getQuoteBillMap((long)billId);
            if (paraMap != null) {
                String projectId = paraMap.get("projectid").toString();
                String vieturns = paraMap.get("vieturns").toString();
                String targetPageId = PdsCommonUtils.object2String((Object)PdsObjectPools.getInstance((String)PdsCommonUtils.getPageIdKey((IFormView)view, (String)"tnd_quotebill", (String)(projectId + '_' + vieturns))), (String)"");
                OpenFormUtils.openDynamicPage((IFormView)view, (String)"tnd_vie_online", (ShowType)ShowType.MainNewTabPage, (Map)paraMap, (CloseCallBack)new CloseCallBack(callbackClassName, "tnd_project_task"), (String)targetPageId);
            }
        } else if ("biztype".equals(biztype) || "tnd_supencryptdetail".equals(entityName)) {
            if ("tnd_supencryptdetail".equals(entityName)) {
                OpenFormUtils.openListPage((IFormView)view, (String)entityName, (ShowType)ShowType.MainNewTabPage, null, (QFilter)TndProjectTaskUtils.getProjectQFilter(billId), (CloseCallBack)new CloseCallBack(callbackClassName, "tnd_project_task"));
            } else {
                OpenFormUtils.openListPage((IFormView)view, (String)entityName, (ShowType)ShowType.MainNewTabPage, null, null, (CloseCallBack)new CloseCallBack(callbackClassName, "tnd_project_task"));
            }
        } else {
            OpenFormUtils.openBillPage((IFormView)view, (String)entityName, (Object)billId, (BillOperationStatus)BillOperationStatus.EDIT, (ShowType)ShowType.MainNewTabPage, null, (CloseCallBack)new CloseCallBack(callbackClassName, "tnd_project_task"));
        }
    }

    public static boolean isOpenVieHall(String entityName, long billId) {
        if (!entityName.equals("tnd_quotebill")) {
            return false;
        }
        ArrayList<String> sourcetypeList = new ArrayList<String>(2);
        sourcetypeList.add(SourceTypeEnums.VIE.getValue());
        sourcetypeList.add(SourceTypeEnums.ELECTRONIC_AUCTION.getValue());
        QFilter qFilter = new QFilter("id", "=", (Object)billId).and("project.sourcetype.number", "in", sourcetypeList).and("billstatus", "=", (Object)BillStatusEnum.SUBMIT.getVal()).and("iscompete", "=", (Object)"1").and("isfinish", "=", (Object)"0");
        return QueryServiceHelper.exists((String)entityName, (QFilter[])qFilter.toArray());
    }

    public static Set<String> getProjetTaskOpSet() {
        HashSet<String> taskOpSet = new HashSet<String>(8);
        taskOpSet.add("tnd_apply");
        taskOpSet.add("tnd_inviteletter");
        taskOpSet.add("tnd_payment");
        taskOpSet.add("tnd_question");
        taskOpSet.add("tnd_tenderbill");
        taskOpSet.add("tnd_quotebill");
        taskOpSet.add("tnd_winnotice");
        taskOpSet.add("tnd_supencryptdetail");
        taskOpSet.add("tnd_aptitude");
        return taskOpSet;
    }

    public static QFilter getProjectQFilter(Object entryId) {
        QFilter qFilter = new QFilter("id", "=", (Object)PdsCommonUtils.object2Long((Object)entryId));
        DynamicObject row = QueryServiceHelper.queryOne((String)"tnd_supencryptdetail", (String)"project.id", (QFilter[])qFilter.toArray());
        long projectId = null == row ? 0L : row.getLong("project.id");
        return new QFilter("project", "=", (Object)projectId);
    }
}

