/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.mservice;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.param.AppParam;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.model.OrgViewTypeEnum;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.fi.cal.common.helper.CommonSettingHelper;
import kd.fi.cal.common.helper.CostElementHelper;
import kd.fi.cal.common.helper.ParamsHelper;
import kd.fi.cal.common.helper.WriteLogHelper;
import kd.fi.cal.common.model.CostAdjustDetailParams;
import kd.fi.cal.common.util.CommonUtils;
import kd.fi.cal.common.util.DateUtils;

public class CalStandardCostDiffBillServiceHelper {
    private static final Log logger = LogFactory.getLog(CalStandardCostDiffBillServiceHelper.class);
    private static final String[] DIFFALLOC_CREATETYPE = new String[]{"g", "h", "k", "m", "p", "q", "r", "s", "t", "c", "w", "x", "y"};
    private Map<String, List<DynamicObject>> billHeaderKey2BillMap = new HashMap<String, List<DynamicObject>>(16);
    private Map<String, DynamicObject> entryKey2IdMap = new HashMap<String, DynamicObject>(16);
    private long[] entryIds = null;
    private int index = 0;
    private String[] headerFields = new String[]{"calorg", "costaccount", "billtype", "biztype", "createtype", "bizdate", "bookdate", "currency", "cstype", "billsrctype", "isupdatecost", "custsupplier", "adminorg", "srcsys", "period"};
    private String[] entryFields = new String[]{"material", "storageorgunit", "mversion", "assist", "lot", "baseunit", "warehouse", "location", "invtype", "invstatus", "ownertype", "owner", "project", "invbillnum", "inventryseq", "invbillentryid", "invbilltype", "invbillid", "invbizentityobject", "invbiztype", "srcbillnum", "srcentryseq", "srcbillid", "srcbillentryid", "srcbilltype", "srcbizentityobject", "tracknumber", "configuredcode", "ecostcenter", "noupdatecalfields"};
    private String[] detailFields = new String[]{"costelement", "costsubelement", "sub_material", "sub_currency"};
    private Map<Long, Integer> calorg2MaxSizeMap = new HashMap<Long, Integer>(16);
    private Set<String> exFields = new HashSet<String>(16);

    protected Map<String, Map<String, Object>> buildDiffBill(Set<Map<String, Object>> params) throws KDBizException {
        Object entryKey;
        logger.info("CalStandardCostDiffBillServiceHelper \u6210\u672c\u4f20\u5165\u53c2\u6570\uff1a" + params);
        if (params == null || params.isEmpty()) {
            return null;
        }
        Set exAllFields = CommonSettingHelper.getExFieldSet();
        MainEntityType costAdjustEntityType = MetadataServiceHelper.getDataEntityType((String)"cal_stdcostdiffbill");
        for (String exField : exAllFields) {
            IDataEntityProperty costadjustField = costAdjustEntityType.findProperty(exField);
            if (costadjustField == null || !(costadjustField.getParent() instanceof EntryType)) continue;
            this.exFields.add(exField);
        }
        HashMap<Long, Boolean> calByCostElementMap = new HashMap<Long, Boolean>(16);
        Long[] materialDefualtElements = CostElementHelper.getDefaultMaterialElements();
        ArrayList<CostAdjustDetailParams> detailParamsList = new ArrayList<CostAdjustDetailParams>(params.size());
        this.entryIds = DBServiceHelper.genLongIds((String)"cal_stdcostdiffbill", (int)params.size());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        for (Map<String, Object> map : params) {
            DynamicObject entry;
            boolean bl;
            WriteLogHelper.writeInfoLog((Log)logger, (String)("CalStandardCostDiffBillServiceHelper map\uff1a" + map), (Object[])new Object[0]);
            if (map.get("bizdate") instanceof Date) {
                map.put("bizdate", DateUtils.getDayStartTime((Date)((Date)map.get("bizdate"))));
                map.put("bookdate", DateUtils.getDayStartTime((Date)((Date)map.get("bookdate"))));
            } else {
                try {
                    map.put("bizdate", DateUtils.getDayStartTime((Date)sdf.parse((String)map.get("bizdate"))));
                    map.put("bookdate", DateUtils.getDayStartTime((Date)sdf.parse((String)map.get("bookdate"))));
                }
                catch (ParseException parseException) {
                    logger.error("CalStandardCostDiffBillServiceHelper buildDiffBill", (Throwable)parseException);
                    throw new KDBizException(parseException.getMessage());
                }
            }
            String string = this.getHeaderKey(map);
            entryKey = this.getEntryKey(map);
            String allKey = string + (String)entryKey;
            Object costElementId = map.get("costelement");
            Object costSubElementId = map.get("costsubelement");
            Long l = (Long)map.get("costaccount");
            if (!calByCostElementMap.containsKey(l)) {
                Boolean bl2 = ParamsHelper.getCostElementByCostAccount((long)l);
                calByCostElementMap.put(l, bl2);
            }
            if (!(bl = ((Boolean)calByCostElementMap.get(l)).booleanValue())) {
                costSubElementId = materialDefualtElements[0];
                costElementId = materialDefualtElements[1];
            }
            if ((entry = this.entryKey2IdMap.get(allKey)) != null && entry.getLong("id") != 0L) {
                CostAdjustDetailParams parms = new CostAdjustDetailParams((Object)entry.getLong("id"), costElementId, costSubElementId, this.getBigDecimalVal(map, "adjustamt"), this.getBigDecimalVal(map, "ddiff_g"), this.getBigDecimalVal(map, "ddiff_h"), this.getBigDecimalVal(map, "ddiff_k"), this.getBigDecimalVal(map, "ddiff_p"), this.getBigDecimalVal(map, "ddiff_q"), this.getBigDecimalVal(map, "ddiff_r"), this.getBigDecimalVal(map, "ddiff_m"), this.getBigDecimalVal(map, "ddiff_s"), this.getBigDecimalVal(map, "ddiff_t"), this.getBigDecimalVal(map, "ddiff_c"), this.getBigDecimalVal(map, "ddiff_x"), this.getBigDecimalVal(map, "ddiff_w"), this.getBigDecimalVal(map, "ddiff_y"));
                detailParamsList.add(parms);
                BigDecimal currAdjustAmt = entry.getBigDecimal("adjustamt");
                BigDecimal entryAdjustAmt = currAdjustAmt == null ? BigDecimal.ZERO : currAdjustAmt;
                for (String diffType : DIFFALLOC_CREATETYPE) {
                    entry.set("diff_" + diffType, (Object)entry.getBigDecimal("diff_" + diffType).add(this.getBigDecimalVal(map, "ddiff_" + diffType)));
                    entryAdjustAmt = entryAdjustAmt.add(this.getBigDecimalVal(map, "ddiff_" + diffType));
                }
                entry.set("adjustamt", (Object)entryAdjustAmt);
                this.addDetail(entry, map);
                continue;
            }
            int entryMaxSize = this.getEntryMaxSize((Long)map.get("calorg"));
            ArrayList<DynamicObject> bills = this.billHeaderKey2BillMap.get(string);
            Long entryid = this.entryIds[this.index++];
            DynamicObject bill = null;
            if (bills == null) {
                bills = new ArrayList<DynamicObject>(16);
                this.billHeaderKey2BillMap.put(string, bills);
                bill = this.createBillHeader(map);
                bills.add(bill);
            } else {
                bill = (DynamicObject)bills.get(bills.size() - 1);
                if (bill.getDynamicObjectCollection("entryentity").size() >= entryMaxSize) {
                    bill = this.createBillHeader(map);
                    bills.add(bill);
                }
            }
            entry = this.createBillEntry(bill, map, entryid);
            this.entryKey2IdMap.put(allKey, entry);
            CostAdjustDetailParams parms = new CostAdjustDetailParams((Object)entryid, costElementId, costSubElementId, this.getBigDecimalVal(map, "adjustamt"), this.getBigDecimalVal(map, "ddiff_g"), this.getBigDecimalVal(map, "ddiff_h"), this.getBigDecimalVal(map, "ddiff_k"), this.getBigDecimalVal(map, "ddiff_p"), this.getBigDecimalVal(map, "ddiff_q"), this.getBigDecimalVal(map, "ddiff_r"), this.getBigDecimalVal(map, "ddiff_m"), this.getBigDecimalVal(map, "ddiff_s"), this.getBigDecimalVal(map, "ddiff_t"), this.getBigDecimalVal(map, "ddiff_c"), this.getBigDecimalVal(map, "ddiff_x"), this.getBigDecimalVal(map, "ddiff_w"), this.getBigDecimalVal(map, "ddiff_y"));
            detailParamsList.add(parms);
            this.addDetail(entry, map);
        }
        ArrayList<DynamicObject[]> bills = new ArrayList<DynamicObject[]>(16);
        for (List<DynamicObject> list : this.billHeaderKey2BillMap.values()) {
            for (DynamicObject[] dynamicObject : list) {
                bills.add(dynamicObject);
            }
        }
        if (!bills.isEmpty()) {
            DynamicObject[] dynamicObjectArray;
            TXHandle tXHandle = TX.required();
            entryKey = null;
            try {
                dynamicObjectArray = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])bills.toArray(new DynamicObject[0]));
            }
            catch (Throwable dynamicObject) {
                entryKey = dynamicObject;
                throw dynamicObject;
            }
            finally {
                if (tXHandle != null) {
                    if (entryKey != null) {
                        try {
                            tXHandle.close();
                        }
                        catch (Throwable dynamicObject) {
                            ((Throwable)entryKey).addSuppressed(dynamicObject);
                        }
                    } else {
                        tXHandle.close();
                    }
                }
            }
            HashSet<Long> hashSet = new HashSet<Long>(16);
            HashSet<Long> noUpdateCostIds = new HashSet<Long>(16);
            for (DynamicObject dynamicObject : dynamicObjectArray) {
                if (dynamicObject.getBoolean("isupdatecost")) {
                    hashSet.add(dynamicObject.getLong("id"));
                    continue;
                }
                noUpdateCostIds.add(dynamicObject.getLong("id"));
            }
            ArrayList<HashSet<Long>> listIds = new ArrayList<HashSet<Long>>(16);
            listIds.add(hashSet);
            listIds.add(noUpdateCostIds);
            OperateOption op = OperateOption.create();
            op.setVariableValue("ishasright", "true");
            op.setVariableValue("ignoreValidation", "true");
            for (Set set : listIds) {
                OperationResult operationResult = OperationServiceHelper.executeOperate((String)"submit", (String)"cal_stdcostdiffbill", (Object[])set.toArray(), (OperateOption)op);
                if (operationResult.isSuccess()) continue;
                List errors = operationResult.getAllErrorOrValidateInfo();
                StringBuilder errorMsg = new StringBuilder();
                if (!errors.isEmpty()) {
                    for (Object error : errors) {
                        OperateInfo operror = (OperateInfo)error;
                        errorMsg.append(operror.getMessage());
                    }
                }
                errorMsg.append("\n");
                errorMsg.append(operationResult.getMessage());
                logger.error("---------------------\u6807\u51c6\u6210\u672c\u5dee\u5f02\u5355\u63d0\u4ea4\u5931\u8d25-------------\n" + errorMsg);
            }
            String detailParams = SerializationUtils.toJsonString(detailParamsList);
            op.setVariableValue("CostAdjustDetailParms", detailParams);
            for (Set set : listIds) {
                OperationResult result = OperationServiceHelper.executeOperate((String)"audit", (String)"cal_stdcostdiffbill", (Object[])set.toArray(), (OperateOption)op);
                if (result.isSuccess()) continue;
                List errors = result.getAllErrorOrValidateInfo();
                StringBuilder errorMsg = new StringBuilder();
                if (!errors.isEmpty()) {
                    for (IOperateInfo error : errors) {
                        OperateInfo operror = (OperateInfo)error;
                        errorMsg.append(operror.getMessage());
                    }
                }
                errorMsg.append("\n");
                errorMsg.append(result.getMessage());
                logger.error("---------------------\u6807\u51c6\u6210\u672c\u5dee\u5f02\u5355\u5ba1\u6838\u5931\u8d25-------------\n" + errorMsg);
            }
            HashMap<String, Map<String, Object>> hashMap = new HashMap<String, Map<String, Object>>(16);
            for (DynamicObject info : dynamicObjectArray) {
                Long id = info.getLong("id");
                String billNo = info.getString("billno");
                HashMap<String, Object> map = new HashMap<String, Object>(4);
                map.put("id", id);
                map.put("billno", billNo);
                DynamicObjectCollection entrys = info.getDynamicObjectCollection("entryentity");
                for (DynamicObject row : entrys) {
                    Long srcbillid = row.getLong("srcbillid");
                    String key = srcbillid + "";
                    hashMap.put(key, map);
                }
            }
            return hashMap;
        }
        return null;
    }

    private void updateCostElement(List<Object[]> paramList) {
        String updateSql = "update t_cal_costadjust_detail set fadjustamt = fadjustamt+? where fentryid = ? and fcostsubelementid = ? and fcostelementid = ?";
        DB.executeBatch((DBRoute)CommonUtils.getCalDBRouteKey(), (String)updateSql, paramList);
    }

    private void updateBillEntryAdjustAmt(List<Object[]> paramList) {
        HashSet<Long> entryIds = new HashSet<Long>(16);
        for (Object[] params : paramList) {
            entryIds.add((Long)params[1]);
        }
        if (!entryIds.isEmpty()) {
            CostElementHelper.calCostAdjustCost((Long[])entryIds.toArray(new Long[0]));
        }
    }

    private DynamicObject createBillEntry(DynamicObject bill, Map<String, Object> map, long entryId) {
        DynamicObjectCollection entry = bill.getDynamicObjectCollection("entryentity");
        int size = entry.size();
        DynamicObject entryRow = entry.addNew();
        for (String field : this.entryFields) {
            entryRow.set(field, map.get(field));
        }
        entryRow.set("id", (Object)entryId);
        entryRow.set("seq", (Object)(size + 1));
        entryRow.set("invbilltype", map.get("billtype"));
        for (String exField : this.exFields) {
            entryRow.set(exField, map.get(exField));
        }
        BigDecimal entryAdjustAmt = BigDecimal.ZERO;
        for (String diffType : DIFFALLOC_CREATETYPE) {
            entryRow.set("diff_" + diffType, (Object)this.getBigDecimalVal(map, "ddiff_" + diffType));
            entryAdjustAmt = entryAdjustAmt.add(this.getBigDecimalVal(map, "ddiff_" + diffType));
        }
        entryRow.set("adjustamt", (Object)entryAdjustAmt);
        return entryRow;
    }

    private DynamicObject createBillHeader(Map<String, Object> map) {
        DynamicObject bill = BusinessDataServiceHelper.newDynamicObject((String)"cal_stdcostdiffbill");
        for (String string : this.headerFields) {
            bill.set(string, map.get(string));
        }
        bill.set("billstatus", (Object)Character.valueOf('A'));
        bill.set("remark", (Object)ResManager.loadKDString((String)"\u6210\u672c\u9886\u57df\u751f\u6210\u8f6c\u51fa\u5355", (String)"CalStandardCostDiffBillServiceHelper_1", (String)"fi-cal-mservice", (Object[])new Object[0]));
        String userId = RequestContext.get().getUserId();
        Date date = TimeServiceHelper.now();
        bill.set("creator", (Object)userId);
        bill.set("createtime", (Object)date);
        bill.set("modifier", (Object)userId);
        bill.set("modifytime", (Object)date);
        long costAdjustId = DBServiceHelper.genLongIds((String)"t_cal_costadjustbill", (int)1)[0];
        String billno = "CBTZ" + costAdjustId;
        bill.set("billno", (Object)billno);
        return bill;
    }

    private int getEntryMaxSize(Long calorg) {
        Integer size = this.calorg2MaxSizeMap.get(calorg);
        if (size == null) {
            AppParam appParam = new AppParam("/KIUHEXROK3D", calorg);
            appParam.setViewType(OrgViewTypeEnum.IS_ACCOUNTING.getViewType());
            size = (Integer)SystemParamServiceHelper.loadAppParameterFromCache((AppParam)appParam, (String)"maxnumberentries");
        }
        return size;
    }

    private String getEntryKey(Map<String, Object> map) {
        StringBuilder sBuilder = new StringBuilder();
        for (String string : this.entryFields) {
            sBuilder.append(map.get(string));
            sBuilder.append('_');
        }
        return sBuilder.toString();
    }

    private String getHeaderKey(Map<String, Object> map) {
        StringBuilder sBuilder = new StringBuilder();
        for (String string : this.headerFields) {
            sBuilder.append(map.get(string));
            sBuilder.append('_');
        }
        sBuilder.append(map.get("srcbizentityobject"));
        sBuilder.append("_");
        sBuilder.append(map.get("srcbillid"));
        sBuilder.append("_");
        sBuilder.append(map.get("material"));
        return sBuilder.toString();
    }

    private DynamicObject[] getLoadDynamicObject(DynamicObject[] infos) {
        HashSet<Object> infoIds = new HashSet<Object>(32);
        for (DynamicObject object : infos) {
            infoIds.add(object.getPkValue());
        }
        MainEntityType costAdjustEntityType = MetadataServiceHelper.getDataEntityType((String)"cal_costadjust_subentity");
        return BusinessDataServiceHelper.load((Object[])infoIds.toArray(), (DynamicObjectType)costAdjustEntityType);
    }

    private BigDecimal getBigDecimalVal(Map<String, Object> valuesMap, String key) {
        Object val = valuesMap.get(key);
        if (val == null) {
            return BigDecimal.ZERO;
        }
        if (val instanceof BigDecimal) {
            return (BigDecimal)val;
        }
        if (val instanceof Double) {
            return BigDecimal.valueOf((Double)val);
        }
        return BigDecimal.ZERO;
    }

    private void setDetailParamAmt(DynamicObject detail, Map<String, Object> valuesMap) {
        BigDecimal totalAdjAmt = BigDecimal.ZERO;
        for (String diffType : DIFFALLOC_CREATETYPE) {
            BigDecimal currAmt = this.getBigDecimalVal(valuesMap, "ddiff_" + diffType);
            detail.set("ddiff_" + diffType, (Object)currAmt);
            totalAdjAmt = totalAdjAmt.add(currAmt);
        }
        detail.set("sub_adjustamt", (Object)totalAdjAmt);
    }

    private void addDetail(DynamicObject entry, Map<String, Object> valuesMap) {
        if (entry == null) {
            return;
        }
        DynamicObjectCollection details = entry.getDynamicObjectCollection("subentryentity");
        int size = details.size();
        DynamicObject detailRow = details.addNew();
        for (String field : this.detailFields) {
            detailRow.set(field + "_id", valuesMap.get(field));
        }
        detailRow.set("seq", (Object)(size + 1));
        this.setDetailParamAmt(detailRow, valuesMap);
    }
}

