/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.opplugin.bill;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.cal.business.balance.BalanceOpInvoker;
import kd.fi.cal.business.calculate.out.IntimeBufferPoolHandle;
import kd.fi.cal.business.process.inner.QueueTypeHelper;
import kd.fi.cal.common.constant.CalDbParamConstant;
import kd.fi.cal.common.enums.AccountTypeEnum;
import kd.fi.cal.common.enums.ActionEnum;
import kd.fi.cal.common.enums.CostAdjustBilCreateTypeEnum;
import kd.fi.cal.common.helper.AccountType4CostAdjustHelper;
import kd.fi.cal.common.helper.CalDbParamServiceHelper;
import kd.fi.cal.common.helper.CommonSettingHelper;
import kd.fi.cal.common.helper.CostAdjustBillOpHelper;
import kd.fi.cal.common.helper.CostElementHelper;
import kd.fi.cal.common.helper.MaterialCategoryHandle;
import kd.fi.cal.common.model.CostAdjustDetailParams;
import kd.fi.cal.common.util.DateUtils;
import kd.fi.cal.opplugin.validator.CalBillMustInputValidator;
import kd.fi.cal.opplugin.validator.StdCostDiffBillAuditValidator;

public class StdCostDiffBillAuditOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("srcsys");
        e.getFieldKeys().add("isupdatecost");
        e.getFieldKeys().add("entryentity.warehouse.isopenlocation");
        e.getFieldKeys().add("entryentity.material.isuseauxpty");
        e.getFieldKeys().add("entryentity.material.configproperties");
        e.getFieldKeys().add("id");
        e.getFieldKeys().add("biztype");
        e.getFieldKeys().add("costaccount.id");
        e.getFieldKeys().add("auditdate");
        e.getFieldKeys().add("bizdate");
        e.getFieldKeys().add("bookdate");
        e.getFieldKeys().add("billno");
        e.getFieldKeys().add("costaccount");
        e.getFieldKeys().add("calorg");
        e.getFieldKeys().add("createtype");
        e.getFieldKeys().add("entryentity.storageorgunit");
        e.getFieldKeys().add("lastupdateuser");
        e.getFieldKeys().add("auditor");
        e.getFieldKeys().add("lastupdatetime");
        e.getFieldKeys().add("entryentity.lot");
        e.getFieldKeys().add("entryentity.adjustamt");
        e.getFieldKeys().add("entryentity.diff_g");
        e.getFieldKeys().add("entryentity.diff_h");
        e.getFieldKeys().add("entryentity.diff_k");
        e.getFieldKeys().add("entryentity.diff_p");
        e.getFieldKeys().add("entryentity.diff_q");
        e.getFieldKeys().add("entryentity.diff_r");
        e.getFieldKeys().add("entryentity.diff_m");
        e.getFieldKeys().add("entryentity.diff_s");
        e.getFieldKeys().add("entryentity.diff_t");
        e.getFieldKeys().add("entryentity.diff_c");
        e.getFieldKeys().add("entryentity.diff_x");
        e.getFieldKeys().add("entryentity.diff_w");
        e.getFieldKeys().add("entryentity.diff_y");
        e.getFieldKeys().add("entryentity.material");
        e.getFieldKeys().add("entryentity.warehouse");
        e.getFieldKeys().add("entryentity.location");
        e.getFieldKeys().add("entryentity.assist");
        e.getFieldKeys().add("entryentity.project");
        e.getFieldKeys().add("entryentity.ownertype");
        e.getFieldKeys().add("entryentity.owner");
        e.getFieldKeys().add("entryentity.calrange");
        e.getFieldKeys().add("entryentity.accounttype");
        e.getFieldKeys().add("entryentity.caldimension");
        e.getFieldKeys().add("entryentity.queuetype");
        e.getFieldKeys().add("entryentity.signnum");
        e.getFieldKeys().add("entryentity.invbillid");
        e.getFieldKeys().add("period");
        e.getFieldKeys().add("bizdate");
        e.getFieldKeys().add("currency");
        e.getFieldKeys().add("entryentity.mversion");
        e.getFieldKeys().add("entryentity.seq");
        e.getFieldKeys().add("auditdate");
        e.getFieldKeys().add("entryentity.invbizdate");
        e.getFieldKeys().add("entryentity.invauditdate");
        e.getFieldKeys().add("entryentity.invbillid");
        e.getFieldKeys().add("entryentity.invbillentryid");
        e.getFieldKeys().add("entryentity.invbizentityobject");
        e.getFieldKeys().add("entryentity.invbillnum");
        e.getFieldKeys().add("entryentity.subentryentity");
        e.getFieldKeys().add("entryentity.subentryentity_json");
        e.getFieldKeys().add("entryentity.invbiztype");
        e.getFieldKeys().add("entryentity.transtype");
        e.getFieldKeys().add("entryentity.costdomainkey");
        e.getFieldKeys().add("entryentity.ecalstatus");
        e.getFieldKeys().add("entryentity.entrystatus");
        e.getFieldKeys().add("entryentity.tracknumber");
        e.getFieldKeys().add("entryentity.configuredcode");
        e.getFieldKeys().add("entryentity.noupdatecalfields");
        e.getFieldKeys().add("entryentity.stocktype");
        e.getFieldKeys().add("calstatus");
        Set exFieldSet = CommonSettingHelper.getExFieldSet();
        for (String entryField : exFieldSet) {
            e.getFieldKeys().add("entryentity." + entryField);
        }
        e.getFieldKeys().add("costsubelement");
        e.getFieldKeys().add("costelement");
        e.getFieldKeys().add("sub_material");
        e.getFieldKeys().add("sub_currency");
        e.getFieldKeys().add("sub_adjustamt");
        e.getFieldKeys().add("ddiff_g");
        e.getFieldKeys().add("ddiff_h");
        e.getFieldKeys().add("ddiff_k");
        e.getFieldKeys().add("ddiff_p");
        e.getFieldKeys().add("ddiff_q");
        e.getFieldKeys().add("ddiff_r");
        e.getFieldKeys().add("ddiff_m");
        e.getFieldKeys().add("ddiff_s");
        e.getFieldKeys().add("ddiff_t");
        e.getFieldKeys().add("ddiff_c");
        e.getFieldKeys().add("ddiff_x");
        e.getFieldKeys().add("ddiff_w");
        e.getFieldKeys().add("ddiff_y");
        e.getFieldKeys().add("entryentity.adjustamt");
        e.getFieldKeys().add("entryentity.diff_g");
        e.getFieldKeys().add("entryentity.diff_h");
        e.getFieldKeys().add("entryentity.diff_k");
        e.getFieldKeys().add("entryentity.diff_p");
        e.getFieldKeys().add("entryentity.diff_q");
        e.getFieldKeys().add("entryentity.diff_r");
        e.getFieldKeys().add("entryentity.diff_m");
        e.getFieldKeys().add("entryentity.diff_s");
        e.getFieldKeys().add("entryentity.diff_t");
        e.getFieldKeys().add("entryentity.diff_c");
        e.getFieldKeys().add("entryentity.diff_x");
        e.getFieldKeys().add("entryentity.diff_w");
        e.getFieldKeys().add("entryentity.diff_y");
        e.getFieldKeys().add("srcsys");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new CalBillMustInputValidator());
        e.addValidator((AbstractValidator)new StdCostDiffBillAuditValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        String[] updateQueuetypeIds;
        String updateQueuetypeIdStr;
        DynamicObject[] stdCostDiffBills = e.getDataEntities();
        CostAdjustBillOpHelper helper = new CostAdjustBillOpHelper(stdCostDiffBills);
        helper.handleBillPeriod(stdCostDiffBills);
        helper.handleBillCalRange(stdCostDiffBills);
        DynamicObject userDyc = BusinessDataServiceHelper.loadSingle((Object)UserServiceHelper.getCurrentUserId(), (String)"bos_user");
        for (DynamicObject info : stdCostDiffBills) {
            String auditor_id;
            Long id = info.getLong("id");
            info.set("bizdate", (Object)DateUtils.getDayStartTime((Date)info.getDate("bizdate")));
            info.set("bookdate", (Object)DateUtils.getDayStartTime((Date)info.getDate("bookdate")));
            info.set("calstatus", (Object)"A");
            String srcsys = info.getString("srcsys");
            if (StringUtils.isEmpty((String)srcsys)) {
                info.set("srcsys", (Object)"A");
            }
            for (Iterator entryDyc : info.getDynamicObjectCollection("entryentity")) {
                entryDyc.set("ecalstatus", "A");
                entryDyc.set("entrystatus", "C");
            }
            if (null == info.get("lastupdateuser")) {
                info.set("lastupdateuser_id", userDyc.getPkValue());
                info.set("lastupdatetime", (Object)new Date());
            }
            if (!this.getOption().containsVariable("auditor_id") || StringUtils.isEmpty((String)(auditor_id = this.getOption().getVariableValue("auditor_id"))) || "0".equals(auditor_id)) continue;
            info.set("auditor_id", (Object)auditor_id);
            info.set("lastupdateuser_id", (Object)auditor_id);
        }
        this.handleInvDateAndExField(stdCostDiffBills);
        new AccountType4CostAdjustHelper(stdCostDiffBills).handleCalRangeAccountType();
        this.checkNullCalRange(stdCostDiffBills);
        HashSet<String> notStandardMaterialNames = new HashSet<String>(16);
        for (DynamicObject dynamicObject : stdCostDiffBills) {
            DynamicObjectCollection entrys = dynamicObject.getDynamicObjectCollection("entryentity");
            int seq = 1;
            for (DynamicObject entry : entrys) {
                entry.set("seq", (Object)seq);
                ++seq;
            }
            DynamicObjectCollection entry = dynamicObject.getDynamicObjectCollection("entryentity");
            for (DynamicObject entryInfo : entry) {
                String accountType = entryInfo.getString("accountType");
                String invBillNum = entryInfo.getString("invbillnum");
                if (AccountTypeEnum.STANDARDCOST.getValue().equals(accountType) || !StringUtils.isEmpty((String)invBillNum)) continue;
                notStandardMaterialNames.add("\u3010" + entryInfo.getString("material.name") + "\u3011");
            }
        }
        if (!notStandardMaterialNames.isEmpty()) {
            String errorMsg = String.format(ResManager.loadKDString((String)"\u5b58\u5728\u8ba1\u4ef7\u65b9\u6cd5\u662f\u975e\u6807\u51c6\u6210\u672c\u6cd5\u7684\u7269\u6599\u201c%1$s\u201d\uff0c\u4e0d\u5141\u8bb8\u624b\u5de5\u65b0\u589e\u8ba1\u4ef7\u65b9\u6cd5\u662f\u975e\u6807\u51c6\u6210\u672c\u6cd5\u7684\u6807\u51c6\u6210\u672c\u5dee\u5f02\u5355\u3002", (String)"CostAdjustBillAuditOp_3", (String)"fi-cal-opplugin", (Object[])new Object[0]), String.join((CharSequence)",", notStandardMaterialNames));
            throw new KDBizException(errorMsg);
        }
        HashSet<String> updateQueuetypeIdSet = new HashSet<String>(16);
        if (this.getOption().containsVariable("updateQueuetypeIds") && StringUtils.isNotEmpty((String)(updateQueuetypeIdStr = this.operateOption.getVariableValue("updateQueuetypeIds"))) && (updateQueuetypeIds = updateQueuetypeIdStr.split(",")) != null && updateQueuetypeIds.length > 0) {
            for (String updateQueuetypeId : updateQueuetypeIds) {
                updateQueuetypeIdSet.add(updateQueuetypeId);
            }
        }
        if (!this.getOption().containsVariable("isResetQueueType") || "true".equals(this.getOption().getVariableValue("isResetQueueType"))) {
            QueueTypeHelper.assingQueueType4CostAdjust((DynamicObject[])stdCostDiffBills, (boolean)true, updateQueuetypeIdSet);
        }
        this.handleInvDateAndExField(stdCostDiffBills);
        if (!this.getOption().containsVariable("isResetQueueType") || "true".equals(this.getOption().getVariableValue("isResetQueueType"))) {
            QueueTypeHelper.assingQueueType4CostAdjust((DynamicObject[])e.getDataEntities(), (boolean)true, updateQueuetypeIdSet);
        }
        MaterialCategoryHandle.handle4Bill((DynamicObject[])stdCostDiffBills);
    }

    private void handleInvDateAndExField(DynamicObject[] costAdjustBills) {
        HashSet<Long> costRecordEntryIds = new HashSet<Long>(16);
        HashSet<Long> costRecordIds = new HashSet<Long>(16);
        for (DynamicObject info : costAdjustBills) {
            String createType = info.getString("createtype");
            if (CostAdjustBilCreateTypeEnum.CAL_OUT_BEFORE_PERIOD.getValue().equals(createType)) continue;
            Date bizDate = info.getDate("bookdate");
            Date auditDate = info.getDate("auditdate");
            DynamicObjectCollection entrys = info.getDynamicObjectCollection("entryentity");
            int count = 1;
            for (DynamicObject entryinfo : entrys) {
                String invbizentityobject = entryinfo.getString("invbizentityobject");
                Long invbillentryid = entryinfo.getLong("invbillentryid");
                Long invbillid = entryinfo.getLong("invbillid");
                if (StringUtils.isNotEmpty((String)invbizentityobject) && invbillentryid != null && ("cal_costrecord".equals(invbizentityobject) || "cal_costrecord_subentity".equals(invbizentityobject))) {
                    costRecordEntryIds.add(invbillentryid);
                    costRecordIds.add(invbillid);
                } else {
                    entryinfo.set("invbizdate", (Object)bizDate);
                    entryinfo.set("invauditdate", (Object)auditDate);
                }
                entryinfo.set("seq", (Object)count++);
            }
        }
        if (costRecordEntryIds.isEmpty()) {
            return;
        }
        StringBuilder selectFields = new StringBuilder();
        selectFields.append("entry.id");
        selectFields.append(",bizdate");
        selectFields.append(",bookdate");
        selectFields.append(",auditdate");
        selectFields.append(",biztype");
        selectFields.append(",transtype");
        HashSet<String> fields = new HashSet<String>(16);
        Set exFields = CommonSettingHelper.getExFieldSet();
        MainEntityType costAdjustEntityType = MetadataServiceHelper.getDataEntityType((String)"cal_stdcostdiffbill");
        MainEntityType costRecordEntityType = MetadataServiceHelper.getDataEntityType((String)"cal_costrecord_subentity");
        for (String exField : exFields) {
            IDataEntityProperty costadjustField = costAdjustEntityType.findProperty(exField);
            IDataEntityProperty costrecordField = costRecordEntityType.findProperty(exField);
            if (costadjustField == null || costrecordField == null || !(costadjustField.getParent() instanceof EntryType) || !(costrecordField.getParent() instanceof EntryType)) continue;
            fields.add(exField);
            selectFields.append(",entry.");
            selectFields.append(exField);
            selectFields.append(" as ");
            selectFields.append(exField);
        }
        QFilter q = new QFilter("entry.id", "in", costRecordEntryIds);
        q.and("id", "in", costRecordIds);
        HashMap<String, Object> costRecordFieldMap = new HashMap<String, Object>(costRecordEntryIds.size());
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_costrecord_subentity", (String)selectFields.toString(), (QFilter[])q.toArray(), null);){
            for (Row row : dataSet) {
                Long entryId = row.getLong("entry.id");
                Date bizdate = row.getDate("bookdate");
                Date auditdate = row.getDate("auditdate");
                Object biztype = row.get("biztype");
                Object transtype = row.get("transtype");
                costRecordFieldMap.put(entryId + "-invbizdate", bizdate);
                costRecordFieldMap.put(entryId + "-invauditdate", auditdate);
                costRecordFieldMap.put(entryId + "-invbiztype", biztype);
                costRecordFieldMap.put(entryId + "-transtype", transtype);
                for (String field : fields) {
                    costRecordFieldMap.put(entryId + "-" + field, row.get(field));
                }
            }
        }
        for (DynamicObject info : costAdjustBills) {
            String createType = info.getString("createtype");
            if (CostAdjustBilCreateTypeEnum.CAL_OUT_BEFORE_PERIOD.getValue().equals(createType)) continue;
            DynamicObjectCollection entrys = info.getDynamicObjectCollection("entryentity");
            for (DynamicObject entryinfo : entrys) {
                String invbizentityobject = entryinfo.getString("invbizentityobject");
                Long invbillentryid = entryinfo.getLong("invbillentryid");
                if (!StringUtils.isNotEmpty((String)invbizentityobject) || invbillentryid == null || !"cal_costrecord".equals(invbizentityobject) && !"cal_costrecord_subentity".equals(invbizentityobject)) continue;
                entryinfo.set("invbizdate", costRecordFieldMap.get(invbillentryid + "-invbizdate"));
                entryinfo.set("invauditdate", costRecordFieldMap.get(invbillentryid + "-invauditdate"));
                entryinfo.set("invbiztype", costRecordFieldMap.get(invbillentryid + "-invbiztype"));
                entryinfo.set("transtype", costRecordFieldMap.get(invbillentryid + "-transtype"));
                for (String field : fields) {
                    entryinfo.set(field, costRecordFieldMap.get(invbillentryid + "-" + field));
                }
            }
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        String isGroupDiffBill;
        super.endOperationTransaction(e);
        DynamicObject[] costAdjustBill = e.getDataEntities();
        HashSet<Long> allBillIds = new HashSet<Long>(16);
        HashSet<Long> costAccountIds = new HashSet<Long>(16);
        for (DynamicObject bill : costAdjustBill) {
            allBillIds.add(bill.getLong("id"));
            Long costAccountId = bill.getDynamicObject("costaccount").getLong("id");
            costAccountIds.add(costAccountId);
        }
        DynamicObjectCollection costAccounts = QueryServiceHelper.query((String)"cal_bd_costaccount", (String)"id,calpolicy.calbycostelement", (QFilter[])new QFilter("id", "in", costAccountIds).toArray());
        HashMap<DynamicObject[], Boolean> calByCostElementMaps = new HashMap<DynamicObject[], Boolean>(16);
        for (DynamicObject dynamicObject : costAccounts) {
            DynamicObject[] id = Long.valueOf(dynamicObject.getLong("id"));
            Boolean calByCostElement = dynamicObject.getBoolean("calpolicy.calbycostelement");
            calByCostElementMaps.put(id, calByCostElement);
        }
        HashMap<Long, Boolean> entryCostElementMap = new HashMap<Long, Boolean>(16);
        boolean calbycostelementtem = false;
        for (DynamicObject bill : costAdjustBill) {
            Long costAccountId = bill.getDynamicObject("costaccount").getLong("id");
            boolean calbycostelement = (Boolean)calByCostElementMaps.get(costAccountId);
            calbycostelementtem = (Boolean)calByCostElementMaps.get(costAccountId);
            DynamicObjectCollection entryentitys = bill.getDynamicObjectCollection("entryentity");
            Iterator iterator = entryentitys.iterator();
            while (iterator.hasNext()) {
                DynamicObject dynamicObject = (DynamicObject)iterator.next();
                Long entryid = dynamicObject.getLong("id");
                entryCostElementMap.put(entryid, calbycostelement);
            }
        }
        HashMap<Long, Set<CostAdjustDetailParams>> costEntryIdDetailParamMap = new HashMap<Long, Set<CostAdjustDetailParams>>(16);
        if (!this.getOption().containsVariable("createtype") || !"W".equals(this.operateOption.getVariableValue("createtype"))) {
            if (this.getOption().containsVariable("CostAdjustDetailParms")) {
                String params = this.getOption().getVariableValue("CostAdjustDetailParms");
                if (StringUtils.isNotEmpty((String)params)) {
                    List costAdjustDetailParams = SerializationUtils.fromJsonStringToList((String)params, CostAdjustDetailParams.class);
                    for (CostAdjustDetailParams param : costAdjustDetailParams) {
                        HashSet<CostAdjustDetailParams> CostAdjustDetailParamsSet = (HashSet<CostAdjustDetailParams>)costEntryIdDetailParamMap.get(param.getEntryid());
                        if (null == CostAdjustDetailParamsSet || CostAdjustDetailParamsSet.size() == 0) {
                            CostAdjustDetailParamsSet = new HashSet<CostAdjustDetailParams>();
                            CostAdjustDetailParamsSet.add(param);
                            costEntryIdDetailParamMap.put(Long.parseLong(String.valueOf(param.getEntryid())), CostAdjustDetailParamsSet);
                            continue;
                        }
                        CostAdjustDetailParamsSet.add(param);
                    }
                } else {
                    this.getParamsByMaterial(costAdjustBill, costEntryIdDetailParamMap);
                }
            } else {
                this.getParamsByMaterial(costAdjustBill, costEntryIdDetailParamMap);
            }
            List allElements = CostElementHelper.getAllCostEle4InitBill();
            for (Map.Entry mapEntry : costEntryIdDetailParamMap.entrySet()) {
                Set valueList = (Set)mapEntry.getValue();
                HashSet<String> hasElementSet = new HashSet<String>(16);
                for (CostAdjustDetailParams param : valueList) {
                    String string = param.getCostElementId() + "_" + param.getCostSubElementId();
                    hasElementSet.add(string);
                }
                for (Long[] element : allElements) {
                    String elementKey;
                    boolean bl = false;
                    bl = entryCostElementMap.get(mapEntry.getKey()) != null ? (Boolean)entryCostElementMap.get(mapEntry.getKey()) : calbycostelementtem;
                    if (!bl || hasElementSet.contains(elementKey = element[1] + "_" + element[0])) continue;
                    CostAdjustDetailParams param = new CostAdjustDetailParams(mapEntry.getKey(), (Object)element[1], (Object)element[0], BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO);
                    valueList.add(param);
                }
            }
            if (costAdjustBill != null && costAdjustBill.length > 0) {
                CostElementHelper.insertDiffbillCostElements((DynamicObject[])costAdjustBill, costEntryIdDetailParamMap);
            }
        }
        if ("true".equals(isGroupDiffBill = CalDbParamServiceHelper.getString((String)"isgroupdiffbill", null))) {
            HashMap<String, HashSet<Long>> diffBillIdMap = new HashMap<String, HashSet<Long>>(16);
            diffBillIdMap.put("diffbillid", allBillIds);
            DispatchServiceHelper.invokeBizService((String)"fi", (String)"cal", (String)"CalGroupDiffBillService", (String)"createDiffGroupBill", (Object[])new Object[]{diffBillIdMap});
        }
        HashMap<Long, Set> endAdjIdEntryIdsMap = new HashMap<Long, Set>(16);
        if (costAdjustBill != null && costAdjustBill.length > 0) {
            for (int i = 0; i < costAdjustBill.length; ++i) {
                DynamicObject info = costAdjustBill[i];
                String createType = info.getString("createtype");
                boolean isEndBalBill = CostAdjustBilCreateTypeEnum.END_BAL_BILL.getValue().equals(createType);
                DynamicObjectCollection entrys = info.getDynamicObjectCollection("entryentity");
                Iterator iterator = entrys.iterator();
                while (iterator.hasNext()) {
                    DynamicObject entry = (DynamicObject)iterator.next();
                    if (!isEndBalBill) continue;
                    Set endBalAdjEntryIds = endAdjIdEntryIdsMap.computeIfAbsent(info.getLong("id"), k -> new HashSet(16));
                    endBalAdjEntryIds.add((Long)entry.getPkValue());
                }
            }
        }
        if (this.getOption().containsVariable("ignoreop")) {
            this.updateBal(allBillIds);
            return;
        }
        if (CalDbParamServiceHelper.getBoolean((String)CalDbParamConstant.ENTRY_SPLIT_INTIME_CAL).booleanValue()) {
            IntimeBufferPoolHandle handle = new IntimeBufferPoolHandle(costAdjustBill, "cal_stdcostdiffbill", ActionEnum.AUDIT.getValue(), false);
            handle.insertIntoPool();
            Map noInPoolBillIdEntryIdMap = handle.getNoInPoolBillEntryIdMap();
            Set billids = handle.getBillids();
            endAdjIdEntryIdsMap.keySet().retainAll(billids);
            HashSet<Long> notInPoolBillIds = new HashSet<Long>(16);
            for (Map.Entry entry : noInPoolBillIdEntryIdMap.entrySet()) {
                notInPoolBillIds.add((Long)entry.getKey());
            }
            notInPoolBillIds.addAll(endAdjIdEntryIdsMap.keySet());
            Throwable throwable = null;
            try (TXHandle handler = TX.requiresNew();){
                this.updateBal(notInPoolBillIds);
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                throw throwable2;
            }
        } else {
            this.updateBal(allBillIds);
        }
        if (CalDbParamServiceHelper.getBoolean((String)CalDbParamConstant.ENTRY_SPLIT_INTIME_CAL).booleanValue()) {
            this.updateBalDel(endAdjIdEntryIdsMap.keySet());
        }
    }

    private void updateBal(Set<Long> notInPoolBillIds) {
        BalanceOpInvoker balanceOpInvoker = new BalanceOpInvoker();
        balanceOpInvoker.setEntity("cal_stdcostdiffbill");
        balanceOpInvoker.invokeBalOp(notInPoolBillIds, null);
    }

    private void updateBalDel(Set<Long> billIds) {
        BalanceOpInvoker balanceOpInvoker = new BalanceOpInvoker();
        balanceOpInvoker.setEntity("cal_stdcostdiffbill");
        balanceOpInvoker.invokeBalReverseOp(billIds, null);
    }

    private void getParamsByMaterial(DynamicObject[] infos, Map<Long, Set<CostAdjustDetailParams>> costEntryIdDetailParamMap) {
        for (DynamicObject info : infos) {
            DynamicObjectCollection entrys = info.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entrys) {
                long entryId = entry.getLong("id");
                DynamicObjectCollection inEntryDetails = entry.getDynamicObjectCollection("subentryentity");
                for (DynamicObject inEntryDetail : inEntryDetails) {
                    CostAdjustDetailParams adjustDetailParams = new CostAdjustDetailParams();
                    adjustDetailParams.setEntryid((Object)entryId);
                    adjustDetailParams.setCostElementId((Object)inEntryDetail.getLong("costelement.id"));
                    adjustDetailParams.setCostSubElementId((Object)inEntryDetail.getLong("costsubelement.id"));
                    BigDecimal sub_adjustamt = inEntryDetail.getBigDecimal("sub_adjustamt");
                    adjustDetailParams.setAdjustAmt(sub_adjustamt);
                    BigDecimal diff_g = inEntryDetail.getBigDecimal("ddiff_g");
                    adjustDetailParams.setDdiff_g(diff_g);
                    BigDecimal diff_h = inEntryDetail.getBigDecimal("ddiff_h");
                    adjustDetailParams.setDdiff_h(diff_h);
                    BigDecimal diff_k = inEntryDetail.getBigDecimal("ddiff_k");
                    adjustDetailParams.setDdiff_k(diff_k);
                    BigDecimal diff_p = inEntryDetail.getBigDecimal("ddiff_p");
                    adjustDetailParams.setDdiff_p(diff_p);
                    BigDecimal diff_q = inEntryDetail.getBigDecimal("ddiff_q");
                    adjustDetailParams.setDdiff_q(diff_q);
                    BigDecimal diff_r = inEntryDetail.getBigDecimal("ddiff_r");
                    adjustDetailParams.setDdiff_r(diff_r);
                    BigDecimal diff_m = inEntryDetail.getBigDecimal("ddiff_m");
                    adjustDetailParams.setDdiff_m(diff_m);
                    BigDecimal diff_s = inEntryDetail.getBigDecimal("ddiff_s");
                    adjustDetailParams.setDdiff_s(diff_s);
                    BigDecimal diff_t = inEntryDetail.getBigDecimal("ddiff_t");
                    adjustDetailParams.setDdiff_t(diff_t);
                    BigDecimal diff_c = inEntryDetail.getBigDecimal("ddiff_c");
                    adjustDetailParams.setDdiff_c(diff_c);
                    BigDecimal diff_x = inEntryDetail.getBigDecimal("ddiff_x");
                    adjustDetailParams.setDdiff_x(diff_x);
                    BigDecimal diff_w = inEntryDetail.getBigDecimal("ddiff_w");
                    adjustDetailParams.setDdiff_w(diff_w);
                    BigDecimal diff_y = inEntryDetail.getBigDecimal("ddiff_y");
                    adjustDetailParams.setDdiff_y(diff_y);
                    Set<CostAdjustDetailParams> CostAdjustDetailParamsSet = costEntryIdDetailParamMap.get(entryId);
                    if (null == CostAdjustDetailParamsSet || CostAdjustDetailParamsSet.size() == 0) {
                        CostAdjustDetailParamsSet = new HashSet<CostAdjustDetailParams>();
                        CostAdjustDetailParamsSet.add(adjustDetailParams);
                        costEntryIdDetailParamMap.put(entryId, CostAdjustDetailParamsSet);
                        continue;
                    }
                    CostAdjustDetailParamsSet.add(adjustDetailParams);
                }
            }
        }
    }

    private void checkNullCalRange(DynamicObject[] costAdjustBill) {
        StringBuilder msg = new StringBuilder();
        for (DynamicObject info : costAdjustBill) {
            String billnum = info.getString("billno");
            HashSet<String> seqs = new HashSet<String>(16);
            DynamicObjectCollection entry = info.getDynamicObjectCollection("entryentity");
            for (int i = 0; i < entry.size(); ++i) {
                DynamicObject entryRow = (DynamicObject)entry.get(i);
                int rowNum = i + 1;
                Object calrangeid = entryRow.get("calrange");
                entryRow.set("seq", (Object)rowNum);
                if (calrangeid != null && !"0".equals(calrangeid.toString())) continue;
                seqs.add(rowNum + "");
            }
            if (seqs.isEmpty()) continue;
            String s = ResManager.loadKDString((String)"\u5355\u636e\u201c%1$s\u201d\u7b2c%2$s\u884c\u5206\u5f55\u672a\u627e\u5230\u6838\u7b97\u8303\u56f4\u3002", (String)"CostAdjustBillSubmitOp_23", (String)"fi-cal-opplugin", (Object[])new Object[0]);
            String errorMsg = String.format(s + "\r\n", billnum, String.join((CharSequence)",", seqs));
            msg.append(errorMsg);
        }
        if (msg.length() > 0) {
            throw new KDBizException(msg.toString());
        }
    }
}

