/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.account;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kd.bos.algo.Algo;
import kd.bos.algo.CacheHint;
import kd.bos.algo.CachedDataSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Input;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.input.OrmInput;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.util.StringUtils;
import kd.fi.cal.common.constant.CalDbParamConstant;
import kd.fi.cal.common.helper.CalDbParamServiceHelper;
import kd.fi.cal.common.helper.ParamsHelper;

public class AbstractAccount4Frm {
    protected static RowMeta rowMeta = new RowMeta(new Field[]{new Field("entity", (DataType)DataType.StringType), new Field("voucherid", (DataType)DataType.LongType), new Field("sourcebillid", (DataType)DataType.LongType)});
    protected DataSetBuilder builder = Algo.create((String)this.getClass().getName()).createDataSetBuilder(rowMeta);
    protected int split_size = CalDbParamServiceHelper.getInteger((String)CalDbParamConstant.CAL_ACCOUNT4FRM_SPLIT_SIZE);
    protected int cache_time_out = CalDbParamServiceHelper.getInteger((String)CalDbParamConstant.CAL_ACCOUNT4FRM_CACHE_TIMEOUT);
    protected String dischargeType = null;
    protected Long orgId = 0L;
    protected Long periodId = 0L;
    protected String billType = null;
    protected Set<Long> billIds = null;

    public AbstractAccount4Frm(Map<String, Object> paramMap) {
        this.orgId = (Long)paramMap.get("org");
        this.periodId = (Long)paramMap.get("period");
        this.billType = (String)paramMap.get("billType");
        this.billIds = (Set)paramMap.get("billIds");
    }

    public static Set<String> getEmptyDataSetCacheId() {
        DataSet billDS = Algo.create((String)AbstractAccount4Frm.class.getName()).createDataSet(new ArrayList(4), rowMeta);
        billDS = billDS.distinct();
        CacheHint cacheHint = new CacheHint();
        cacheHint.setTimeout((long)CalDbParamServiceHelper.getInteger((String)CalDbParamConstant.CAL_ACCOUNT4FRM_CACHE_TIMEOUT).intValue(), TimeUnit.SECONDS);
        CachedDataSet cache = billDS.cache(cacheHint);
        String cacheId = cache.getCacheId();
        return Collections.singleton(cacheId);
    }

    protected String getDisChargeType(Long calorgid) {
        if (StringUtils.isEmpty((String)this.dischargeType)) {
            this.dischargeType = (String)ParamsHelper.getAppParam((long)calorgid, (String)"dischargetype");
        }
        return this.dischargeType;
    }

    protected Set<String> getDataSetCacheId() {
        CacheHint cacheHint = new CacheHint();
        cacheHint.setTimeout((long)this.cache_time_out, TimeUnit.SECONDS);
        DataSet dataSet = this.builder.build();
        dataSet = dataSet.distinct();
        CachedDataSet cache = dataSet.cache(cacheHint);
        String cacheId = cache.getCacheId();
        return Collections.singleton(cacheId);
    }

    public Set<String> getCacheId() {
        return null;
    }

    public static Set<String> getCacheId(Map<String, Object> paramMap) {
        DataSet dapTracker;
        Long orgId = (Long)paramMap.get("org");
        Long periodId = (Long)paramMap.get("period");
        String billType = (String)paramMap.get("billType");
        Set billIds = (Set)paramMap.get("billIds");
        String selectFields = "billtype entity, sourcebillid, voucherid";
        QFilter dapFilter = new QFilter("org", "=", (Object)orgId);
        dapFilter.and("period", "=", (Object)periodId);
        dapFilter.and("billtype", "=", (Object)billType);
        ArrayList inputList = new ArrayList();
        int splitsize = CalDbParamServiceHelper.getInteger((String)CalDbParamConstant.CAL_ACCOUNT4FRM_SPLIT_SIZE);
        Lists.partition(Arrays.asList(billIds.toArray(new Long[0])), (int)splitsize).forEach(list -> {
            OrmInput input = new OrmInput(AbstractAccount4Frm.class.getName(), "ai_daptracker", selectFields, new QFilter[]{new QFilter("sourcebillid", "in", list), dapFilter});
            inputList.add(input);
        });
        if (inputList.isEmpty()) {
            RowMeta rowMeta = ORM.create().createRowMeta("ai_daptracker", selectFields);
            dapTracker = Algo.create((String)AbstractAccount4Frm.class.getName()).createDataSet(new ArrayList(16), rowMeta);
        } else {
            dapTracker = Algo.create((String)AbstractAccount4Frm.class.getName()).createDataSet((Input[])inputList.toArray(new OrmInput[0]));
        }
        CacheHint cacheHint = new CacheHint();
        cacheHint.setTimeout((long)CalDbParamServiceHelper.getInteger((String)CalDbParamConstant.CAL_ACCOUNT4FRM_CACHE_TIMEOUT).intValue(), TimeUnit.SECONDS);
        CachedDataSet cache = dapTracker.cache(cacheHint);
        String cacheId = cache.getCacheId();
        return Collections.singleton(cacheId);
    }

    protected void queryOtherBillVoucher(Map<String, Set<Long>> apEntity2ApBillidsMap, Map<Long, Set<Long>> apBill2calBillIdsMap) {
        QFilter dapFilter = new QFilter("org", "=", (Object)this.orgId);
        dapFilter.and("period", "=", (Object)this.periodId);
        ArrayList inputs = new ArrayList(4);
        for (Map.Entry<String, Set<Long>> entry : apEntity2ApBillidsMap.entrySet()) {
            String apentity = entry.getKey();
            Set<Long> apBillIds = entry.getValue();
            Lists.partition(Arrays.asList(apBillIds.toArray(new Long[0])), (int)this.split_size).forEach(list -> {
                QFilter filter = new QFilter("sourcebillid", "in", list);
                filter.and("billtype", "=", (Object)apentity);
                filter.and(dapFilter);
                OrmInput input = new OrmInput(this.getClass().getName(), "ai_daptracker", "sourcebillid,voucherid", filter.toArray());
                inputs.add(input);
            });
        }
        if (inputs.isEmpty()) {
            return;
        }
        DataSet dapTracker = Algo.create((String)this.getClass().getName()).createDataSet((Input[])inputs.toArray(new OrmInput[0]));
        for (Row row : dapTracker) {
            Long sourcebillid = row.getLong("sourcebillid");
            Long voucherid = row.getLong("voucherid");
            Set<Long> calBillIds = apBill2calBillIdsMap.get(sourcebillid);
            if (calBillIds == null || calBillIds.isEmpty()) continue;
            for (Long calBillId : calBillIds) {
                this.builder.append(new Object[]{this.billType, voucherid, calBillId});
            }
        }
    }

    protected Map<Long, Set<Long>> queryApChareBusBill(Map<Long, Set<Long>> apBill2calBillIdsMap) {
        QFilter orgFilter = new QFilter("org", "=", (Object)this.orgId);
        ArrayList inputs = new ArrayList(4);
        Lists.partition(Arrays.asList(apBill2calBillIdsMap.keySet().toArray(new Long[0])), (int)this.split_size).forEach(list -> {
            QFilter filter = new QFilter("srcfinbillid", "in", list);
            filter.and(orgFilter);
            OrmInput input = new OrmInput(this.getClass().getName(), "ap_busbill", "id,srcfinbillid", filter.toArray());
            inputs.add(input);
        });
        HashMap<Long, Set<Long>> apBusBill2calBillIdsMap = new HashMap<Long, Set<Long>>(4);
        if (inputs.isEmpty()) {
            return apBusBill2calBillIdsMap;
        }
        DataSet billDS = Algo.create((String)this.getClass().getName()).createDataSet((Input[])inputs.toArray(new OrmInput[0]));
        for (Row row : billDS) {
            Long bizbill = row.getLong("srcfinbillid");
            Long apBillId = row.getLong("id");
            Set<Long> calBillIds = apBill2calBillIdsMap.get(bizbill);
            Set curCalBillIds = apBusBill2calBillIdsMap.computeIfAbsent(apBillId, k -> new HashSet(4));
            curCalBillIds.addAll(calBillIds);
        }
        return apBusBill2calBillIdsMap;
    }

    protected DataSet getDataSetByPartition(Set<Long> billIds, String selectFields, String entity) {
        ArrayList inputs = new ArrayList(4);
        Lists.partition(Arrays.asList(billIds.toArray(new Long[0])), (int)this.split_size).forEach(list -> {
            QFilter filter = new QFilter("id", "in", list);
            OrmInput input = new OrmInput(this.getClass().getName(), entity, selectFields, filter.toArray());
            inputs.add(input);
        });
        DataSet billDS = null;
        if (inputs.isEmpty()) {
            RowMeta rowMeta = ORM.create().createRowMeta(entity, selectFields);
            billDS = Algo.create((String)this.getClass().getName()).createDataSet(new ArrayList(16), rowMeta);
        } else {
            billDS = Algo.create((String)this.getClass().getName()).createDataSet((Input[])inputs.toArray(new OrmInput[0]));
        }
        return billDS;
    }
}

