/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.account;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Input;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.input.OrmInput;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.util.StringUtils;
import kd.fi.cal.business.account.AbstractAccount4Frm;
import kd.fi.cal.common.enums.CostAdjustBilCreateTypeEnum;
import kd.fi.cal.common.enums.DischargeTypeEnum;

public class AdjustStdDiffAccount4Frm
extends AbstractAccount4Frm {
    public AdjustStdDiffAccount4Frm(Map<String, Object> paramMap) {
        super(paramMap);
    }

    @Override
    public Set<String> getCacheId() {
        Object CRids;
        Set adjIds;
        Set adjIds2;
        String selectFields = "id,calorg,createtype,isvoucher,voucherid,entryentity.invbillid as invbillid,entryentity.srcbillid as srcbillid,ischargeoff";
        DataSet billDS = this.getDataSetByPartition(this.billIds, selectFields, this.billType);
        billDS = billDS.distinct();
        DataSet[] billDSs = billDS.splitByFilter(new String[]{"isvoucher = true", "isvoucher = false and createtype in ('B','U','D')", "isvoucher = false and createtype in ('B-A1','I','J')"}, false);
        for (Row row : billDSs[0]) {
            Long id = row.getLong("id");
            boolean isvoucher = row.getBoolean("isvoucher");
            Long voucherid = row.getLong("voucherid");
            if (!isvoucher) continue;
            this.builder.append(new Object[]{this.billType, voucherid, id});
        }
        HashSet<Long> CRIds = new HashSet<Long>(16);
        HashSet<Object> apBillIds = new HashSet<Object>(16);
        HashSet<Long> unclearApBillIds = new HashSet<Long>(16);
        HashMap<Long, Set> unclearApBill2AdjuIdsMap = new HashMap<Long, Set>(16);
        HashMap<Long, Set> unclearApBill2CRidsMap = new HashMap<Long, Set>(16);
        HashSet<Long> chargeoffApBillIds = new HashSet<Long>(16);
        HashMap<Long, Set> chargeoffApBill2AdjuIdsMap = new HashMap<Long, Set>(16);
        HashMap<Long, Set> chargeoffApBill2CRidsMap = new HashMap<Long, Set>(16);
        HashMap<Long, Set<Long>> apBill2calBillIdsMap = new HashMap<Long, Set<Long>>(4);
        RowMeta adjuRowMeta = new RowMeta(new Field[]{new Field("adjid", (DataType)DataType.LongType), new Field("invbillid", (DataType)DataType.LongType), new Field("srcbillid", (DataType)DataType.LongType)});
        DataSetBuilder adjBuilder = Algo.create((String)this.getClass().getName()).createDataSetBuilder(adjuRowMeta);
        for (Row row : billDSs[1]) {
            Long id = row.getLong("id");
            Long srcbillid = row.getLong("srcbillid");
            Long calorgid = row.getLong("calorg");
            Long l = row.getLong("invbillid");
            String string = row.getString("createtype");
            boolean bl = row.getBoolean("ischargeoff");
            apBillIds.add(srcbillid);
            CRIds.add(l);
            if (bl) {
                chargeoffApBillIds.add(srcbillid);
                Set adjIds22 = chargeoffApBill2AdjuIdsMap.computeIfAbsent(srcbillid, k -> new HashSet(4));
                adjIds22.add(id);
                Set CRids2 = chargeoffApBill2CRidsMap.computeIfAbsent(srcbillid, k -> new HashSet(4));
                CRids2.add(l);
            } else if (CostAdjustBilCreateTypeEnum.PUR_WIRTEOFF.getValue().equals(string) || CostAdjustBilCreateTypeEnum.OM_WRITEOFF.getValue().equals(string)) {
                adjBuilder.append(new Object[]{id, l, srcbillid});
            } else {
                adjIds2 = apBill2calBillIdsMap.computeIfAbsent(srcbillid, k -> new HashSet(4));
                adjIds2.add(id);
            }
            String dischargetype = this.getDisChargeType(calorgid);
            if (!CostAdjustBilCreateTypeEnum.PUR_WIRTEOFF.getValue().equals(string) || !DischargeTypeEnum.UNCLEAR.getValue().equals(dischargetype)) continue;
            unclearApBillIds.add(srcbillid);
            adjIds = unclearApBill2AdjuIdsMap.computeIfAbsent(srcbillid, k -> new HashSet(4));
            adjIds.add(id);
            CRids = unclearApBill2CRidsMap.computeIfAbsent(srcbillid, k -> new HashSet(4));
            CRids.add(l);
        }
        HashSet<Long> busBillIds = new HashSet<Long>(16);
        HashSet<Long> busAdjBillIds = new HashSet<Long>(16);
        HashMap<Long, Set> busAdjBillId2Adj_InvMap = new HashMap<Long, Set>(16);
        for (Object row : billDSs[2]) {
            Long l = row.getLong("id");
            Long l2 = row.getLong("srcbillid");
            Long l3 = row.getLong("invbillid");
            String createtype = row.getString("createtype");
            if (CostAdjustBilCreateTypeEnum.PUR_ADJUSTESTIMATE.getValue().equals(createtype)) {
                adjBuilder.append(new Object[]{l, l3, l2});
                busAdjBillIds.add(l2);
                Set adj_invs = busAdjBillId2Adj_InvMap.computeIfAbsent(l2, k -> new HashSet(4));
                adj_invs.add(l + "_" + l3);
            } else {
                adjIds = apBill2calBillIdsMap.computeIfAbsent(l2, k -> new HashSet(4));
                adjIds.add(l);
            }
            busBillIds.add(l2);
            CRIds.add(l3);
        }
        Map<Long, Set<Long>> apChareBusBillMap = this.queryApChareBusBill(unclearApBillIds);
        for (Map.Entry entry : apChareBusBillMap.entrySet()) {
            Long l = (Long)entry.getKey();
            Set set = (Set)entry.getValue();
            adjIds2 = (Set)unclearApBill2AdjuIdsMap.get(l);
            Set CRids2 = (Set)unclearApBill2CRidsMap.get(l);
            busBillIds.addAll(set);
            for (Iterator crid : CRids2) {
                for (Object busBill : set) {
                    for (Long adjId : adjIds2) {
                        adjBuilder.append(new Object[]{adjId, crid, busBill});
                    }
                }
            }
        }
        Map<Long, Long> ap2ChargeoffApMap = this.queryChargeOffApBill(chargeoffApBillIds);
        for (Map.Entry<Long, Long> entry : ap2ChargeoffApMap.entrySet()) {
            Iterator crid;
            Long l = entry.getKey();
            Long chargeOffApBill = entry.getValue();
            adjIds = (Set)chargeoffApBill2AdjuIdsMap.get(l);
            CRids = (Set)chargeoffApBill2CRidsMap.get(l);
            apBillIds.add(chargeOffApBill);
            crid = CRids.iterator();
            while (crid.hasNext()) {
                Long crid2 = (Long)crid.next();
                for (Long adjId : adjIds) {
                    adjBuilder.append(new Object[]{adjId, crid2, chargeOffApBill});
                }
            }
        }
        Map<Long, Set<Long>> map = this.queryBusAdjMap(busAdjBillIds);
        for (Map.Entry<Long, Set<Long>> entry : map.entrySet()) {
            Long busid = entry.getKey();
            Set<Long> reBusids = entry.getValue();
            Set adj_invs = (Set)busAdjBillId2Adj_InvMap.get(busid);
            for (String adj_inv : adj_invs) {
                String[] adj_invArr = adj_inv.split("_");
                Iterator<Object> iterator = reBusids.iterator();
                while (iterator.hasNext()) {
                    Long reBusid = (Long)iterator.next();
                    busBillIds.add(reBusid);
                    adjBuilder.append(new Object[]{Long.valueOf(adj_invArr[0]), Long.valueOf(adj_invArr[1]), reBusid});
                }
            }
        }
        DataSet dataSet = this.getDataSetByPartition(CRIds, "id,bizbillid", "cal_costrecord");
        DataSet dataSet4 = adjBuilder.build();
        dataSet4 = dataSet4.join(dataSet, JoinType.INNER).on("invbillid", "id").select(new String[]{"adjid", "srcbillid"}, new String[]{"bizbillid"}).finish();
        dataSet4 = dataSet4.distinct();
        DataSet adj2ApbillDS = dataSet4.groupBy(new String[]{"bizbillid"}).groupConcat("adjid", "adjids", ",").groupConcat("srcbillid", "srcbillids", ",").finish();
        for (Row row : adj2ApbillDS) {
            String adjids = row.getString("adjids");
            String srcbillids = row.getString("srcbillids");
            HashSet<Long> adjIdSet = new HashSet<Long>(4);
            for (Iterator<Object> adjid : adjids.split(",")) {
                adjIdSet.add(Long.valueOf(adjid));
            }
            for (Iterator<Object> srcbillid : srcbillids.split(",")) {
                Set adjIds3 = apBill2calBillIdsMap.computeIfAbsent(Long.valueOf(srcbillid), k -> new HashSet(4));
                adjIds3.addAll(adjIdSet);
            }
        }
        HashMap<String, Set<Long>> apEntity2ApBillidsMap = new HashMap<String, Set<Long>>(4);
        apEntity2ApBillidsMap.put("ap_finapbill", apBillIds);
        apEntity2ApBillidsMap.put("ap_busbill", busBillIds);
        this.queryOtherBillVoucher(apEntity2ApBillidsMap, apBill2calBillIdsMap);
        return this.getDataSetCacheId();
    }

    private Map<Long, Set<Long>> queryBusAdjMap(Set<Long> busAdjBillIds) {
        HashMap<Long, Set<Long>> map = new HashMap<Long, Set<Long>>(4);
        if (busAdjBillIds.isEmpty()) {
            return map;
        }
        ArrayList inputs = new ArrayList(4);
        RowMeta rowMeta = ORM.create().createRowMeta("ap_busbill", "id,TO_CHAR(revaluasrcbusbillid) as revaluasrcbusbillid");
        rowMeta.getField("revaluasrcbusbillid").setDataType((DataType)DataType.StringType);
        Lists.partition(Arrays.asList(busAdjBillIds.toArray(new Long[0])), (int)this.split_size).forEach(list -> {
            QFilter filter = new QFilter("id", "in", list);
            OrmInput input = new OrmInput(this.getClass().getName(), "ap_busbill", "id,TO_CHAR(revaluasrcbusbillid) as revaluasrcbusbillid", filter.toArray(), rowMeta);
            inputs.add(input);
        });
        DataSet busAdjDS = Algo.create((String)this.getClass().getName()).createDataSet((Input[])inputs.toArray(new OrmInput[0]));
        HashSet<String> sourcebillids = new HashSet<String>(4);
        for (Row row : busAdjDS.copy()) {
            String idStr = row.getString("revaluasrcbusbillid");
            if (StringUtils.isEmpty((String)idStr)) continue;
            sourcebillids.add(idStr);
        }
        ArrayList reinputs = new ArrayList(4);
        Lists.partition(Arrays.asList(sourcebillids.toArray(new String[0])), (int)this.split_size).forEach(list -> {
            QFilter filter = new QFilter("sourcebillid", "in", list);
            OrmInput input = new OrmInput(this.getClass().getName(), "ap_busbill", "id as reid,sourcebillid", filter.toArray());
            reinputs.add(input);
        });
        if (reinputs.isEmpty()) {
            return map;
        }
        DataSet rebusAdjDS = Algo.create((String)this.getClass().getName()).createDataSet((Input[])reinputs.toArray(new OrmInput[0]));
        DataSet dataSet = rebusAdjDS.join(busAdjDS, JoinType.INNER).on("sourcebillid", "revaluasrcbusbillid").select(new String[]{"reid"}, new String[]{"id"}).finish();
        for (Row row : dataSet) {
            Long id = row.getLong("id");
            Long reid = row.getLong("reid");
            Set reids = map.computeIfAbsent(id, k -> new HashSet(4));
            reids.add(reid);
        }
        return map;
    }

    private Map<Long, Long> queryChargeOffApBill(Set<Long> chargeoffApBillIds) {
        HashMap<Long, Long> resultMap = new HashMap<Long, Long>(4);
        if (chargeoffApBillIds.isEmpty()) {
            return resultMap;
        }
        ArrayList inputs = new ArrayList(4);
        Lists.partition(Arrays.asList(chargeoffApBillIds.toArray(new Long[0])), (int)this.split_size).forEach(list -> {
            QFilter filter = new QFilter("sourcebillid", "in", list);
            OrmInput input = new OrmInput(this.getClass().getName(), "ap_finapbill", "id,sourcebillid", filter.toArray());
            inputs.add(input);
        });
        if (inputs.isEmpty()) {
            return resultMap;
        }
        DataSet billDS = Algo.create((String)this.getClass().getName()).createDataSet((Input[])inputs.toArray(new OrmInput[0]));
        for (Row row : billDS) {
            resultMap.put(row.getLong("sourcebillid"), row.getLong("id"));
        }
        return resultMap;
    }

    protected Map<Long, Set<Long>> queryApChareBusBill(Set<Long> unclearApBillIds) {
        QFilter orgFilter = new QFilter("org", "=", (Object)this.orgId);
        ArrayList inputs = new ArrayList(4);
        Lists.partition(Arrays.asList(unclearApBillIds.toArray(new Long[0])), (int)this.split_size).forEach(list -> {
            QFilter filter = new QFilter("srcfinbillid", "in", list);
            filter.and(orgFilter);
            OrmInput input = new OrmInput(this.getClass().getName(), "ap_busbill", "id,srcfinbillid", filter.toArray());
            inputs.add(input);
        });
        HashMap<Long, Set<Long>> finApBill2BusBillIds = new HashMap<Long, Set<Long>>(4);
        if (inputs.isEmpty()) {
            return finApBill2BusBillIds;
        }
        DataSet billDS = Algo.create((String)this.getClass().getName()).createDataSet((Input[])inputs.toArray(new OrmInput[0]));
        for (Row row : billDS) {
            Long finapbill = row.getLong("srcfinbillid");
            Long busbill = row.getLong("id");
            Set busBillIds = finApBill2BusBillIds.computeIfAbsent(finapbill, k -> new HashSet(4));
            busBillIds.add(busbill);
        }
        return finApBill2BusBillIds;
    }
}

