/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.builder;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.cal.business.builder.CostAccountCache;
import kd.fi.cal.business.builder.IBillNoGenerator;
import kd.fi.cal.common.enums.DischargeTypeEnum;
import kd.fi.cal.common.helper.CalBalanceModelHelper;
import kd.fi.cal.common.helper.CommonSettingHelper;
import kd.fi.cal.common.helper.ParamsHelper;
import kd.fi.cal.common.helper.PeriodHelper;
import org.apache.commons.lang.time.DateFormatUtils;

public class CostRecordBuilder {
    private DynamicObject calBill;
    private DynamicObject costAccount;
    private DynamicObject currentperiod;
    private DynamicObject startperiod;
    private String errorhead;
    private boolean isPur;
    private boolean isSale;
    private boolean isOmin;
    private boolean isOmReqOut;
    private String convertMode;
    private String convertMode4TargetUSD;
    private String convertMode4sourceUSD;
    private BigDecimal exchangeRate = null;
    private BigDecimal exchangeRate4TargetUSD = null;
    private BigDecimal exchangeRate4sourceUSD = null;
    private int amtPrecision;
    private int pricePrecision;
    private String calBillType;
    private boolean isSameLocalCurrency;
    private Set<String> exFieldSet;
    private MainEntityType calEntityType;
    private String dischargetype;
    private Long bizDatePeriod;
    private boolean isRepeatTemp;
    private boolean checkPeriod = true;

    public CostRecordBuilder(DynamicObject calbill, DynamicObject account, Set<String> exFieldSet, Map<Long, CostAccountCache> costAccountCache) {
        this.init(calbill, account, exFieldSet, costAccountCache, true);
    }

    public CostRecordBuilder(DynamicObject calbill, DynamicObject account, Set<String> exFieldSet, Map<Long, CostAccountCache> costAccountCache, boolean isCheckPeriod) {
        this.init(calbill, account, exFieldSet, costAccountCache, isCheckPeriod);
    }

    private void init(DynamicObject calbill, DynamicObject account, Set<String> exFieldSet, Map<Long, CostAccountCache> costAccountCache, boolean isCheckPeriod) {
        String msg1;
        this.checkPeriod = isCheckPeriod;
        this.calBill = calbill;
        this.costAccount = account;
        this.exFieldSet = exFieldSet;
        String calbillEntityName = this.calBill.getDataEntityType().getName();
        this.calEntityType = MetadataServiceHelper.getDataEntityType((String)calbillEntityName);
        if ("cal_outcalbill".equals(calbillEntityName)) {
            this.calBillType = "OUT";
        } else if ("cal_incalbill".equals(calbillEntityName)) {
            this.calBillType = "IN";
        } else {
            String msg = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u7c7b\u578b\u201c%1$s\u201d\u4e0d\u80fd\u751f\u6210\u6838\u7b97\u6210\u672c\u8bb0\u5f55\u3002", (String)"CostRecordBuilder_15", (String)"fi-cal-business", (Object[])new Object[0]), calbillEntityName);
            throw new KDBizException(msg);
        }
        this.errorhead = msg1 = String.format(ResManager.loadKDString((String)"\u5728\u6210\u672c\u8d26\u7c3f\u3010%1$s\uff09\u3011\u4e0b\u751f\u6210\u6838\u7b97\u6210\u672c\u8bb0\u5f55\u5931\u8d25\uff1a", (String)"CostRecordBuilder_16", (String)"fi-cal-business", (Object[])new Object[0]), account.getString("number") + "\uff08" + account.getString("name"));
        Date bookDate = this.calBill.getDate("bookdate");
        Set purBizEntityNumSet = null;
        CostAccountCache cache = costAccountCache.get(account.getLong("id"));
        boolean isInitBill = this.calBill.getBoolean("isinitbill");
        if (cache == null) {
            DynamicObject startPeriod;
            cache = new CostAccountCache();
            DynamicObject currentperiod = PeriodHelper.getCurrentPeriod((Long)account.getLong("id"));
            if (currentperiod == null) {
                String msg = String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u8be5\u6210\u672c\u8d26\u7c3f\u6ca1\u6709\u8bbe\u7f6e\u5f53\u524d\u671f\u95f4\uff0c\u53ef\u80fd\u8fd8\u672a\u542f\u7528\u3002", (String)"CostRecordBuilder_4", (String)"fi-cal-business", (Object[])new Object[0]), this.errorhead);
                throw new KDBizException(msg);
            }
            cache.setCurPeriod(currentperiod);
            this.currentperiod = currentperiod;
            this.startperiod = startPeriod = PeriodHelper.getStartPeriod((Long)account.getLong("id"));
            cache.setStartPeriod(startPeriod);
            this.dischargetype = (String)ParamsHelper.getAppParam((long)Long.parseLong(this.costAccount.get("calorg").toString()), (String)"dischargetype");
            cache.setDischargetype(this.dischargetype);
            this.getBizDatePeriod(account.getLong("id"), bookDate, cache, isInitBill);
            this.isRepeatTemp = (Boolean)ParamsHelper.getAppParam((long)Long.parseLong(this.costAccount.get("calorg").toString()), (String)"initbill_need_repeattemp");
            cache.setRepeatTemp(this.isRepeatTemp);
            purBizEntityNumSet = CommonSettingHelper.getBizEntityNumbers((String)"purbiztype");
            cache.getCacheMap().put("purbiztype", purBizEntityNumSet);
            costAccountCache.put(account.getLong("id"), cache);
        } else {
            this.currentperiod = cache.getCurPeriod();
            this.startperiod = cache.getStartPeriod();
            this.dischargetype = cache.getDischargetype();
            this.bizDatePeriod = cache.getBizDatePeriodMap().get(bookDate);
            if (this.bizDatePeriod == null) {
                this.getBizDatePeriod(account.getLong("id"), bookDate, cache, isInitBill);
            }
            this.isRepeatTemp = cache.isRepeatTemp();
            purBizEntityNumSet = (Set)cache.getCacheMap().get("purbiztype");
        }
        if (!isInitBill) {
            Date startDate = this.currentperiod.getDate("begindate");
            if (isCheckPeriod && bookDate.before(startDate)) {
                String msg = String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u8bb0\u8d26\u65e5\u671f\u201c%2$s\u201d\u5c0f\u4e8e\u6210\u672c\u8d26\u7c3f\u7684\u5f53\u524d\u671f\u95f4\u7b2c\u4e00\u5929\u201c%3$s\u201d\u3002", (String)"CostRecordBuilder_17", (String)"fi-cal-business", (Object[])new Object[0]), this.errorhead, DateFormatUtils.format((Date)bookDate, (String)"yyyy-MM-dd"), DateFormatUtils.format((Date)startDate, (String)"yyyy-MM-dd"));
                throw new KDBizException(msg);
            }
        }
        String bizEntityNumber = this.calBill.getDynamicObject("bizentityobject").getString("number");
        this.isPur = purBizEntityNumSet.contains(bizEntityNumber);
        Set ominBizEntityNumSet = CommonSettingHelper.getBizEntityNumbers((String)"ominbiztype");
        this.isOmin = ominBizEntityNumSet.contains(bizEntityNumber);
        this.isSale = "im_saloutbill".equals(bizEntityNumber) || "im_salreturnbill".equals(bizEntityNumber);
        this.isOmReqOut = "im_osmaterialreqoutbill".equals(bizEntityNumber);
        this.amtPrecision = this.costAccount.getInt("calpolicy.currency.amtprecision");
        this.pricePrecision = 10;
        Object exratetable = this.costAccount.get("calpolicy.exratetable");
        Date exratedate = this.calBill.getDate("exratedate");
        Date date = bookDate;
        long billLocalCurrencyId = this.calBill.getLong("localcurrency_id");
        long localCurrencyId = this.costAccount.getLong("calpolicy.currency");
        boolean bl = this.isSameLocalCurrency = localCurrencyId == billLocalCurrencyId;
        if (this.calBill.getLong("exratetable_id") != 0L) {
            exratetable = this.calBill.getLong("exratetable_id");
        }
        if (exratedate != null) {
            date = exratedate;
        }
        this.convertMode = "1";
        if (!this.isSameLocalCurrency) {
            if (billLocalCurrencyId == 0L) {
                this.exchangeRate = BigDecimal.ONE;
            } else {
                boolean isIndirect = BaseDataServiceHelper.getRateConversionConfig((Long)billLocalCurrencyId, (Long)localCurrencyId, (Date)date);
                if (isIndirect) {
                    this.convertMode = "2";
                }
                this.exchangeRate = BaseDataServiceHelper.getExchangeRateByQuoteType((Long)billLocalCurrencyId, (Long)localCurrencyId, (Long)Long.valueOf(exratetable.toString()), (Date)date, (boolean)isIndirect);
            }
            if (this.exchangeRate == null) {
                if (billLocalCurrencyId == 6L || localCurrencyId == 6L) {
                    DynamicObject currency = BusinessDataServiceHelper.loadSingleFromCache((Object)billLocalCurrencyId, (String)"bd_currency");
                    String msg = String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u5355\u636e\u672c\u4f4d\u5e01\u201c%2$s\u201d\u4e0e\u6210\u672c\u8d26\u7c3f\u672c\u4f4d\u5e01\u201c%3$s\u201d\u6ca1\u6709\u6c47\u7387\u5173\u7cfb\uff0c\u8bf7\u5148\u7ef4\u62a4\u6c47\u7387\u8868\u518d\u91cd\u65b0\u6267\u884c\u3002", (String)"CostRecordBuilder_18", (String)"fi-cal-business", (Object[])new Object[0]), this.errorhead, currency.getString("name"), this.costAccount.getString("calpolicy.currency.name"));
                    throw new KDBizException(msg);
                }
                boolean isIndirect4TargetUSD = BaseDataServiceHelper.getRateConversionConfig((Long)billLocalCurrencyId, (Long)6L, (Date)date);
                this.convertMode4TargetUSD = "1";
                if (isIndirect4TargetUSD) {
                    this.convertMode4TargetUSD = "2";
                }
                this.exchangeRate4TargetUSD = BaseDataServiceHelper.getExchangeRateByQuoteType((Long)billLocalCurrencyId, (Long)6L, (Long)Long.valueOf(exratetable.toString()), (Date)date, (boolean)isIndirect4TargetUSD);
                boolean isIndirect4sourceUSD = BaseDataServiceHelper.getRateConversionConfig((Long)6L, (Long)localCurrencyId, (Date)date);
                this.convertMode4sourceUSD = "1";
                if (isIndirect4sourceUSD) {
                    this.convertMode4sourceUSD = "2";
                }
                this.exchangeRate4sourceUSD = BaseDataServiceHelper.getExchangeRateByQuoteType((Long)6L, (Long)localCurrencyId, (Long)Long.valueOf(exratetable.toString()), (Date)date, (boolean)isIndirect4sourceUSD);
                if (this.exchangeRate4TargetUSD == null) {
                    DynamicObject currency = BusinessDataServiceHelper.loadSingleFromCache((Object)billLocalCurrencyId, (String)"bd_currency");
                    String msg = String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u5355\u636e\u672c\u4f4d\u5e01\u201c%2$s\u201d\u4e0e\u6210\u672c\u8d26\u7c3f\u672c\u4f4d\u5e01\u201c%3$s\u201d\u6ca1\u6709\u6c47\u7387\u5173\u7cfb\uff0c\u5e76\u4e14\u5355\u636e\u672c\u4f4d\u5e01\u201c%4$s\u201d\u4e0e\u201c\u7f8e\u5143\u201d\u6ca1\u6709\u6c47\u7387\u5173\u7cfb\uff0c\u8bf7\u5148\u7ef4\u62a4\u6c47\u7387\u8868\u518d\u91cd\u65b0\u6267\u884c\u3002", (String)"CostRecordBuilder_19", (String)"fi-cal-business", (Object[])new Object[0]), this.errorhead, currency.getString("name"), this.costAccount.getString("calpolicy.currency.name"), currency.getString("name"));
                    throw new KDBizException(msg);
                }
                if (this.exchangeRate4sourceUSD == null) {
                    DynamicObject currency = BusinessDataServiceHelper.loadSingleFromCache((Object)billLocalCurrencyId, (String)"bd_currency");
                    String msg2 = String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u5355\u636e\u672c\u4f4d\u5e01\u201c%2$s\u201d\u4e0e\u6210\u672c\u8d26\u7c3f\u672c\u4f4d\u5e01\u201c%3$s\u201d\u6ca1\u6709\u6c47\u7387\u5173\u7cfb\uff0c\u5e76\u4e14\u201c\u7f8e\u5143\u201d\u4e0e\u6210\u672c\u8d26\u7c3f\u672c\u4f4d\u5e01\u201c%4$s\u201d\u6ca1\u6709\u6c47\u7387\u5173\u7cfb\uff0c\u8bf7\u5148\u7ef4\u62a4\u6c47\u7387\u8868\u518d\u91cd\u65b0\u6267\u884c\u3002", (String)"CostRecordBuilder_20", (String)"fi-cal-business", (Object[])new Object[0]), this.errorhead, currency.getString("name"), this.costAccount.getString("calpolicy.currency.name"), this.costAccount.getString("calpolicy.currency.name"));
                    throw new KDBizException(msg2);
                }
            }
        }
    }

    public DynamicObject createCostRecord(IBillNoGenerator generator, Map<Long, CostAccountCache> costAccountCache) {
        DynamicObject recordInfo = this.buildHeader(generator, costAccountCache);
        this.buildEntry(recordInfo);
        return recordInfo;
    }

    protected void buildEntry(DynamicObject recordInfo) {
        DynamicObjectCollection entryCol = recordInfo.getDynamicObjectCollection("entry");
        DynamicObjectCollection calBillEntryCol = this.calBill.getDynamicObjectCollection("entry");
        long[] entryIds = DBServiceHelper.genLongIds((String)"t_cal_calcostrecordentry", (int)calBillEntryCol.size());
        int i = 0;
        for (DynamicObject calbillEntryInfo : calBillEntryCol) {
            BigDecimal interCostAmt;
            BigDecimal interCostAmt2;
            DynamicObject entryInfo = entryCol.addNew();
            entryInfo.set("id", (Object)entryIds[i]);
            entryInfo.set("ancestorentryid", (Object)entryIds[i]);
            ++i;
            entryInfo.set("seq", (Object)entryCol.size());
            entryInfo.set("calentryid", (Object)calbillEntryInfo.getLong("id"));
            entryInfo.set("bizbillentryid", (Object)calbillEntryInfo.getLong("bizbillentryid"));
            entryInfo.set("material_id", calbillEntryInfo.get("material_id"));
            entryInfo.set("assist_id", calbillEntryInfo.get("assistproperty_id"));
            entryInfo.set("ownertype", calbillEntryInfo.get("ownertype"));
            entryInfo.set("owner_id", calbillEntryInfo.get("owner_id"));
            entryInfo.set("ecostcenter_id", calbillEntryInfo.get("ecostcenter_id"));
            entryInfo.set("lot", calbillEntryInfo.get("lot"));
            entryInfo.set("project_id", calbillEntryInfo.get("project_id"));
            entryInfo.set("ispresent", calbillEntryInfo.get("ispresent"));
            entryInfo.set("baseqty", (Object)calbillEntryInfo.getBigDecimal("baseqty"));
            entryInfo.set("weight", (Object)calbillEntryInfo.getBigDecimal("weight"));
            entryInfo.set("baseunit_id", calbillEntryInfo.get("baseunit_id"));
            entryInfo.set("unitstandardcost", (Object)BigDecimal.ZERO);
            entryInfo.set("standardcost", (Object)BigDecimal.ZERO);
            boolean supportTaxAmt = this.costAccount.getBoolean("calpolicy.supporttaxamt");
            BigDecimal calMaterialCost = BigDecimal.ZERO;
            calMaterialCost = this.isPur ? ((interCostAmt2 = calbillEntryInfo.getBigDecimal("intercostamt")) != null && interCostAmt2.compareTo(BigDecimal.ZERO) != 0 ? interCostAmt2 : (supportTaxAmt ? calbillEntryInfo.getBigDecimal("localtaxamount") : calbillEntryInfo.getBigDecimal("materialcost"))) : calbillEntryInfo.getBigDecimal("materialcost");
            BigDecimal materialcost = BigDecimal.ZERO;
            BigDecimal unitMaterialCost = BigDecimal.ZERO;
            if (this.isSameLocalCurrency) {
                materialcost = calMaterialCost.setScale(this.amtPrecision, 4);
                unitMaterialCost = materialcost.divide(entryInfo.getBigDecimal("baseqty"), this.pricePrecision, 4);
            } else {
                materialcost = this.convertAmount(calMaterialCost);
                unitMaterialCost = materialcost.divide(entryInfo.getBigDecimal("baseqty"), this.pricePrecision, 4);
            }
            if (materialcost.compareTo(BigDecimal.ZERO) == 0 && calbillEntryInfo.getBigDecimal("unitmaterialcost").compareTo(BigDecimal.ZERO) != 0) {
                unitMaterialCost = calbillEntryInfo.getBigDecimal("unitmaterialcost");
            }
            entryInfo.set("materialcost", (Object)materialcost);
            entryInfo.set("unitmaterialcost", (Object)unitMaterialCost);
            BigDecimal unitFee = calbillEntryInfo.getBigDecimal("unitfee");
            BigDecimal fee = calbillEntryInfo.getBigDecimal("fee");
            fee = this.convertAmount(fee);
            if (fee.compareTo(BigDecimal.ZERO) != 0) {
                unitFee = fee.divide(entryInfo.getBigDecimal("baseqty"), this.pricePrecision, 4);
            }
            entryInfo.set("fee", (Object)fee);
            entryInfo.set("unitfee", (Object)unitFee);
            BigDecimal unitProcessCost = calbillEntryInfo.getBigDecimal("unitprocesscost");
            BigDecimal processCost = this.isOmin ? ((interCostAmt = calbillEntryInfo.getBigDecimal("intercostamt")) != null && interCostAmt.compareTo(BigDecimal.ZERO) != 0 ? interCostAmt : (supportTaxAmt ? calbillEntryInfo.getBigDecimal("localtaxamount") : calbillEntryInfo.getBigDecimal("processcost"))) : calbillEntryInfo.getBigDecimal("processcost");
            processCost = this.convertAmount(processCost);
            if (processCost.compareTo(BigDecimal.ZERO) != 0) {
                unitProcessCost = processCost.divide(entryInfo.getBigDecimal("baseqty"), this.pricePrecision, 4);
            }
            entryInfo.set("processcost", (Object)processCost);
            entryInfo.set("unitprocesscost", (Object)unitProcessCost);
            entryInfo.set("actualcost", (Object)entryInfo.getBigDecimal("processcost").add(entryInfo.getBigDecimal("materialcost")).add(entryInfo.getBigDecimal("fee")));
            entryInfo.set("unitactualcost", (Object)entryInfo.getBigDecimal("unitprocesscost").add(entryInfo.getBigDecimal("unitmaterialcost")).add(entryInfo.getBigDecimal("unitfee")));
            BigDecimal localtax = calbillEntryInfo.getBigDecimal("localtax");
            localtax = this.convertAmount(localtax);
            entryInfo.set("localtax", (Object)localtax);
            entryInfo.set("audittime", calbillEntryInfo.get("audittime"));
            entryInfo.set("tax", calbillEntryInfo.get("tax"));
            entryInfo.set("taxrate", calbillEntryInfo.get("taxrate"));
            entryInfo.set("taxamt", calbillEntryInfo.get("taxamount"));
            entryInfo.set("loctaxamt", calbillEntryInfo.get("localtaxamount"));
            entryInfo.set("warehouse_id", calbillEntryInfo.get("warehouse_id"));
            entryInfo.set("location_id", calbillEntryInfo.get("location_id"));
            entryInfo.set("invtype_id", calbillEntryInfo.get("invtype_id"));
            entryInfo.set("invstatus_id", calbillEntryInfo.get("invstatus_id"));
            entryInfo.set("tracknumber_id", calbillEntryInfo.get("tracknumber_id"));
            entryInfo.set("configuredcode_id", calbillEntryInfo.get("configuredcode_id"));
            entryInfo.set("adjustamount", (Object)BigDecimal.ZERO);
            entryInfo.set("srcbillentity", calbillEntryInfo.get("srcbillentity"));
            entryInfo.set("srcbillentryid", calbillEntryInfo.get("srcbillentryid"));
            entryInfo.set("srcbillid", calbillEntryInfo.get("srcbillid"));
            entryInfo.set("srcbillnumber", calbillEntryInfo.get("srcbillnumber"));
            entryInfo.set("srcbillentryseq", calbillEntryInfo.get("srcbillentryseq"));
            entryInfo.set("mainbillentity", calbillEntryInfo.get("mainbillentity"));
            entryInfo.set("mainbillnumber", calbillEntryInfo.get("mainbillnumber"));
            entryInfo.set("mainbillid", calbillEntryInfo.get("mainbillid"));
            entryInfo.set("mainbillentryid", calbillEntryInfo.get("mainbillentryid"));
            entryInfo.set("mainbillentryseq", calbillEntryInfo.get("mainbillentryseq"));
            entryInfo.set("mversion_id", calbillEntryInfo.get("mversion_id"));
            entryInfo.set("islastentry", calbillEntryInfo.get("islastentry"));
            entryInfo.set("srcsysbillentryid", calbillEntryInfo.get("srcsysbillentryid"));
            entryInfo.set("srcsystem", calbillEntryInfo.get("srcsystem"));
            entryInfo.set("srcsysbillno", calbillEntryInfo.get("srcsysbillno"));
            entryInfo.set("srcsysbillid", calbillEntryInfo.get("srcsysbillid"));
            entryInfo.set("groupnumber", calbillEntryInfo.get("groupnumber"));
            entryInfo.set("groupseq", calbillEntryInfo.get("groupseq"));
            entryInfo.set("pid", calbillEntryInfo.get("pid"));
            entryInfo.set("productnum", calbillEntryInfo.get("productnum"));
            if ("IN".equals(this.calBillType)) {
                entryInfo.set("balancesupplier_id", calbillEntryInfo.get("balancesupplier_id"));
            }
            if ("OUT".equals(this.calBillType)) {
                entryInfo.set("balancecustomer_id", calbillEntryInfo.get("balancecustomer_id"));
                entryInfo.set("isrework", calbillEntryInfo.get("isrework"));
                entryInfo.set("product_id", calbillEntryInfo.get("product_id"));
            }
            entryInfo.set("entrystatus", (Object)"B");
            entryInfo.set("ecalstatus", (Object)"A");
            entryInfo.set("productline_id", calbillEntryInfo.get("productline_id"));
            entryInfo.set("noupdatecalfields", (Object)this.getNoUpdateCalFields(calbillEntryInfo.get("noupdatecalfields").toString()));
            if (this.exFieldSet == null || this.exFieldSet.isEmpty()) continue;
            for (String exField : this.exFieldSet) {
                IDataEntityProperty property = this.calEntityType.findProperty(exField);
                if (property == null) continue;
                if (property instanceof BasedataProp) {
                    entryInfo.set(exField + "_id", calbillEntryInfo.get(exField + "_id"));
                    continue;
                }
                entryInfo.set(exField, calbillEntryInfo.get(exField));
            }
        }
    }

    protected DynamicObject buildHeader(IBillNoGenerator generator, Map<Long, CostAccountCache> costAccountCache) {
        Date endDate;
        DynamicObject recordInfo = BusinessDataServiceHelper.newDynamicObject((String)"cal_costrecord_subentity");
        recordInfo.set("calbilltype", (Object)this.calBillType);
        recordInfo.set("calbillid", this.calBill.getPkValue());
        recordInfo.set("costaccount_id", this.costAccount.get("id"));
        recordInfo.set("calorg_id", this.costAccount.get("calorg"));
        recordInfo.set("bizbillid", (Object)this.calBill.getLong("bizbillid"));
        recordInfo.set("billno", (Object)generator.getNumber());
        recordInfo.set("billnumber", (Object)this.calBill.getString("billno"));
        recordInfo.set("billtype_id", this.calBill.get("billtype_id"));
        recordInfo.set("billstatus", this.calBill.get("billstatus"));
        recordInfo.set("calstatus", (Object)"A");
        recordInfo.set("bizentityobject", this.calBill.get("bizentityobject"));
        recordInfo.set("storageorgunit_id", this.calBill.get("org_id"));
        recordInfo.set("currency_id", this.calBill.get("currency_id"));
        recordInfo.set("biztype", this.calBill.get("biztype_id"));
        Long invschemeId = this.calBill.getLong("invscheme_id");
        if (invschemeId == null || invschemeId.equals(0L)) {
            invschemeId = 688309880632690688L;
        }
        recordInfo.set("invscheme", (Object)invschemeId);
        recordInfo.set("isinitbill", this.calBill.get("isinitbill"));
        boolean isInitBill = this.calBill.getBoolean("isinitbill");
        recordInfo.set("localcurrency_id", this.costAccount.get("calpolicy.currency"));
        DynamicObject currency = BusinessDataServiceHelper.newDynamicObject((String)"bd_currency");
        currency.set("id", this.costAccount.get("calpolicy.currency"));
        currency.set("amtprecision", this.costAccount.get("calpolicy.currency.amtprecision"));
        recordInfo.set("localcurrency", (Object)currency);
        recordInfo.set("exchangerate", this.calBill.get("exchangerate"));
        recordInfo.set("exratetable_id", this.calBill.get("exratetable_id"));
        recordInfo.set("exratedate", this.calBill.get("exratedate"));
        Date bizdate = this.calBill.getDate("bizdate");
        recordInfo.set("bizdate", (Object)bizdate);
        if (!isInitBill) {
            recordInfo.set("period_id", (Object)this.bizDatePeriod);
        }
        recordInfo.set("auditdate", this.calBill.get("auditdate"));
        recordInfo.set("isvirtualbill", this.calBill.get("isvirtualbill"));
        Date bookdate = this.calBill.getDate("bookdate");
        recordInfo.set("bookdate", (Object)bookdate);
        recordInfo.set("createtime", this.calBill.get("createtime"));
        recordInfo.set("creator_id", this.calBill.get("creator_id"));
        recordInfo.set("modifytime", this.calBill.get("modifytime"));
        recordInfo.set("modifier_id", this.calBill.get("modifier_id"));
        recordInfo.set("auditor_id", this.calBill.get("auditor_id"));
        recordInfo.set("lastupdatetime", this.calBill.get("lastupdatetime"));
        recordInfo.set("lastupdateuser_id", this.calBill.get("lastupdateuser_id"));
        recordInfo.set("adminorg_id", this.calBill.get("adminorg_id"));
        recordInfo.set("transtype", this.calBill.get("transtype"));
        recordInfo.set("invorg_id", this.calBill.get("invorg_id"));
        recordInfo.set("comment", this.calBill.get("comment"));
        recordInfo.set("billstatus", (Object)"B");
        recordInfo.set("ischargeoffed", this.calBill.get("ischargeoffed"));
        recordInfo.set("ischargeoff", this.calBill.get("ischargeoff"));
        if (this.isPur || this.isOmin) {
            if (this.dischargetype != null) {
                recordInfo.set("dischargetype", (Object)this.dischargetype);
            } else {
                String msg = String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u6ca1\u6709\u5728\u53c2\u6570\u4e2d\u8bbe\u7f6e\u6838\u7b97\u7ec4\u7ec7\u201c%2$s\u201d\u7684\u51b2\u56de\u65b9\u5f0f\u3002", (String)"CostRecordBuilder_21", (String)"fi-cal-business", (Object[])new Object[0]), this.errorhead, this.costAccount.getString("calorg.number") + "\uff08" + this.costAccount.getString("calorg.name"));
                throw new KDBizException(msg);
            }
        }
        if (this.isPur || this.isSale || this.isOmin) {
            recordInfo.set("writeoffstatus", (Object)Character.valueOf('B'));
        }
        recordInfo.set("customer_id", this.calBill.get("customer_id"));
        recordInfo.set("supplier_id", this.calBill.get("supplier_id"));
        if ((this.isPur || this.isOmin) && isInitBill) {
            endDate = this.currentperiod.getDate("enddate");
            if (!this.checkPeriod) {
                recordInfo.set("period_id", (Object)this.startperiod.getLong("id"));
            } else if (bookdate.compareTo(endDate) <= 0) {
                recordInfo.set("period_id", (Object)this.currentperiod.getLong("id"));
            } else {
                recordInfo.set("period_id", (Object)this.bizDatePeriod);
            }
            String dischargeType = recordInfo.getString("dischargetype");
            if (DischargeTypeEnum.BEGINPERIODCLEAR.getValue().equals(dischargeType)) {
                if (this.isRepeatTemp) {
                    recordInfo.set("dischargetype", (Object)DischargeTypeEnum.BEGINPERIODCLEAR.getValue());
                } else {
                    recordInfo.set("dischargetype", (Object)DischargeTypeEnum.BILLCOMECLEAR.getValue());
                    recordInfo.set("istempvoucher", (Object)true);
                }
            } else if (DischargeTypeEnum.BILLCOMECLEAR.getValue().equals(dischargeType)) {
                recordInfo.set("istempvoucher", (Object)true);
            } else if (DischargeTypeEnum.UNCLEAR.getValue().equals(dischargeType)) {
                recordInfo.set("isfivoucher", (Object)true);
            }
        }
        if ((this.isSale || this.isOmReqOut) && isInitBill) {
            endDate = this.currentperiod.getDate("enddate");
            if (bookdate.compareTo(endDate) <= 0) {
                recordInfo.set("period_id", (Object)this.currentperiod.getLong("id"));
            } else {
                recordInfo.set("period_id", (Object)this.bizDatePeriod);
            }
        }
        Object periodId = recordInfo.get("period_id");
        Date writeOffDate = null;
        recordInfo.set("writeoffperiod_id", periodId);
        if (isInitBill) {
            DynamicObject periodDyc = BusinessDataServiceHelper.loadSingleFromCache((Object)periodId, (String)"bd_period");
            if (periodDyc != null) {
                writeOffDate = periodDyc.getDate("begindate");
            }
        } else {
            writeOffDate = recordInfo.getDate("bookdate");
        }
        recordInfo.set("writeoffdate", (Object)writeOffDate);
        return recordInfo;
    }

    private BigDecimal getTargetAmount(BigDecimal exchangeRate, String convertMode, BigDecimal sourceAmount, int amtPrecision) {
        BigDecimal targetAmount = BigDecimal.ZERO;
        if (sourceAmount == null || sourceAmount.compareTo(BigDecimal.ZERO) == 0) {
            return targetAmount;
        }
        if (exchangeRate != null) {
            targetAmount = "1".equals(convertMode) ? sourceAmount.multiply(exchangeRate).setScale(amtPrecision, 4) : sourceAmount.divide(exchangeRate, amtPrecision, 4);
        }
        return targetAmount;
    }

    private BigDecimal convertAmount(BigDecimal amount) {
        BigDecimal newAmount = amount;
        newAmount = !this.isSameLocalCurrency ? (this.exchangeRate != null ? this.getTargetAmount(this.exchangeRate, this.convertMode, amount, this.amtPrecision) : this.getTargetAmount(this.exchangeRate4sourceUSD, this.convertMode4sourceUSD, this.getTargetAmount(this.exchangeRate4TargetUSD, this.convertMode4TargetUSD, amount, this.amtPrecision), this.amtPrecision)) : newAmount.setScale(this.amtPrecision, 4);
        return newAmount;
    }

    private void getBizDatePeriod(Long acctId, Date bookdate, CostAccountCache cache, boolean isInitBill) {
        if (isInitBill) {
            DynamicObject periodDyc = PeriodHelper.getPeriodByDateNotCheck((Date)bookdate, (Long)acctId);
            if (periodDyc != null) {
                this.bizDatePeriod = periodDyc.getLong("id");
                cache.getBizDatePeriodMap().put(bookdate, this.bizDatePeriod);
            }
        } else {
            this.bizDatePeriod = PeriodHelper.getPeriodByDate((Date)bookdate, (Long)acctId).getLong("id");
            cache.getBizDatePeriodMap().put(bookdate, this.bizDatePeriod);
        }
    }

    private JSONObject getNoUpdateCalFields(String noupdatecalfieldStr) {
        if (StringUtils.isEmpty((String)noupdatecalfieldStr)) {
            return JSON.parseObject((String)"");
        }
        Set balDims = CalBalanceModelHelper.getDimField();
        JSONObject jsonObject = JSON.parseObject((String)noupdatecalfieldStr);
        JSONArray newNoupdateFields = new JSONArray();
        if (jsonObject != null) {
            JSONArray noupdateFields = jsonObject.getJSONArray("setnull");
            for (Object noupdateField : noupdateFields) {
                String noupdateFieldStr = noupdateField.toString();
                for (String balDim : balDims) {
                    if (!noupdateFieldStr.startsWith(balDim)) continue;
                    newNoupdateFields.add((Object)balDim);
                }
            }
            jsonObject.put("setnull", (Object)newNoupdateFields);
        }
        return jsonObject;
    }
}

