/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.calculate.billgroup;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.cal.business.calculate.billgroup.AutoSortServic;
import kd.fi.cal.common.helper.AccountingSysHelper;
import kd.fi.cal.common.helper.AcctGroupModelHelper;
import kd.fi.cal.common.util.CommonUtils;

public class CalAutoRepairSortResultTask
extends AbstractTask {
    private static Log log = LogFactory.getLog(CalAutoRepairSortResultTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        boolean validatortime;
        if (!AcctGroupModelHelper.isNewGroupModel()) {
            log.info("CalAutoRepairSortResultTask-oldgroup-return");
            QFilter fs = new QFilter("number", "=", (Object)"cal_CalAutoRepairSortResult_SKDP_S");
            DynamicObject info = BusinessDataServiceHelper.loadSingle((String)"sch_schedule", (String)"id,status", (QFilter[])fs.toArray());
            if (info != null) {
                info.set("status", (Object)"0");
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{info});
            }
            return;
        }
        log.info("CalAutoRepairSortResultTask-start");
        String batchsizeStr = (String)map.get("batchsize");
        int batchsize = batchsizeStr == null ? 10 : Integer.parseInt(batchsizeStr);
        String repairbycostaccountStr = (String)map.get("repairbycostaccount");
        boolean repairbycostaccount = repairbycostaccountStr == null ? false : Boolean.parseBoolean(repairbycostaccountStr);
        String validatortimeStr = (String)map.get("validatortime");
        boolean bl = validatortime = validatortimeStr == null ? true : Boolean.parseBoolean(validatortimeStr);
        if (repairbycostaccount) {
            log.info("CalAutoRepairSortResultTask-repairByCostAccount");
            this.repairByCostAccount(validatortime);
        } else {
            log.info("CalAutoRepairSortResultTask-repairByCostDomainGroupIds");
            this.repairByCostDomainGroupIds(batchsize);
        }
        log.info("CalAutoRepairSortResultTask-end");
    }

    private void repairByCostAccount(Boolean validatortime) {
        Calendar instance = Calendar.getInstance();
        if (validatortime.booleanValue() && (instance.get(11) < 1 || instance.get(11) >= 3)) {
            log.info("CalAutoRepairSortResultTask-repairByCostAccount-return" + instance);
            return;
        }
        QFilter filter = new QFilter("enable", "=", (Object)"1");
        HashSet<Long> costAccountIds = new HashSet<Long>(4);
        HashMap<Long, Set> ingroupBooktypeCostAccountidMap = new HashMap<Long, Set>(4);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)AccountingSysHelper.class.getName(), (String)"cal_bd_costaccount", (String)"id,booktype,booktype.isingroup as isingroup", (QFilter[])filter.toArray(), (String)null);
        Iterator iterator = null;
        try {
            for (Row row : dataSet) {
                Boolean isingroup = row.getBoolean("isingroup");
                Long id = row.getLong("id");
                Long booktype = row.getLong("booktype");
                if (isingroup != null && isingroup.booleanValue()) {
                    Set ids = ingroupBooktypeCostAccountidMap.computeIfAbsent(booktype, k -> new HashSet(4));
                    ids.add(id);
                    continue;
                }
                costAccountIds.add(id);
            }
        }
        catch (Throwable throwable) {
            iterator = throwable;
            throw throwable;
        }
        finally {
            if (dataSet != null) {
                if (iterator != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)((Object)iterator)).addSuppressed(throwable);
                    }
                } else {
                    dataSet.close();
                }
            }
        }
        log.info("CalAutoRepairSortResultTask-costAccountIds" + costAccountIds);
        log.info("CalAutoRepairSortResultTask-ingroupBooktypeCostAccountidMap" + ingroupBooktypeCostAccountidMap);
        AutoSortServic autoSortServic = new AutoSortServic();
        for (Long costAccountId : costAccountIds) {
            autoSortServic.sortByAsyncByAccountId(Collections.singleton(costAccountId));
        }
        for (Set ids : ingroupBooktypeCostAccountidMap.values()) {
            autoSortServic.sortByAsyncByAccountId(ids);
        }
    }

    private void repairByCostDomainGroupIds(int batchsize) {
        HashSet<Long> costdomaingroupids = new HashSet<Long>(4);
        try (DataSet dataSet = DB.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (DBRoute)CommonUtils.getCalDBRouteKey(), (String)"SELECT A.fid from t_cal_costdomaingroup A left join t_cal_sortresultentry B on A.FSDIMENSIONID = B.FDIMENSION where A.fcount >0 and B.fid is null");){
            for (Row row : dataSet) {
                costdomaingroupids.add(row.getLong("fid"));
            }
        }
        dataSet = DB.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (DBRoute)CommonUtils.getCalDBRouteKey(), (String)"SELECT A.fid from t_cal_costdomaingroup A left join t_cal_sortresultentry B on A.FTDIMENSIONID = B.FDIMENSION where A.fcount >0 and B.fid is null");
        var4_4 = null;
        try {
            for (Row row : dataSet) {
                costdomaingroupids.add(row.getLong("fid"));
            }
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        finally {
            if (dataSet != null) {
                if (var4_4 != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable throwable) {
                        var4_4.addSuppressed(throwable);
                    }
                } else {
                    dataSet.close();
                }
            }
        }
        if (!costdomaingroupids.isEmpty()) {
            log.info("CalAutoRepairSortResultTask-costdomaingroupids" + costdomaingroupids);
            List<Long> idLists = Arrays.asList(costdomaingroupids.toArray(new Long[0]));
            idLists.sort(Comparator.naturalOrder());
            AutoSortServic autoSortServic = new AutoSortServic();
            Lists.partition(idLists, (int)batchsize).forEach(list -> {
                try (TXHandle handle = TX.requiresNew();){
                    autoSortServic.sortByAsync(new HashSet(list));
                }
            });
        }
    }
}

