/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.extsysupgrade;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import kd.bos.algo.Algo;
import kd.bos.algo.CacheHint;
import kd.bos.algo.CachedDataSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Input;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.input.OrmInput;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.bos.util.StringUtils;
import kd.fi.cal.business.builder.CostAccountCache;
import kd.fi.cal.business.builder.CostRecordBuilder;
import kd.fi.cal.business.builder.CreateCostRecordHelper;
import kd.fi.cal.business.builder.IBillNoGenerator;
import kd.fi.cal.business.process.inner.CalBillInfo;
import kd.fi.cal.business.process.inner.FieldMappingResult;
import kd.fi.cal.common.constant.CalDbParamConstant;
import kd.fi.cal.common.enums.CostPriceSourceTypeEnum;
import kd.fi.cal.common.helper.AccountTypeHelperNew;
import kd.fi.cal.common.helper.AccountingSysHelper;
import kd.fi.cal.common.helper.AcctGroupModelHelper;
import kd.fi.cal.common.helper.CalBillRuleHelper;
import kd.fi.cal.common.helper.CalDbParamServiceHelper;
import kd.fi.cal.common.helper.CalGroupAccountHelper;
import kd.fi.cal.common.helper.CostPriceSourceTypeHelper;
import kd.fi.cal.common.helper.IDGenerator;
import kd.fi.cal.common.helper.MaterialCategoryHandle;
import kd.fi.cal.common.helper.SynBizBillHelper;
import kd.fi.cal.common.model.CalBillRule;
import kd.fi.cal.common.util.DateUtils;

public class PrePeriodImBillSyncSubTask
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(PrePeriodImBillSyncSubTask.class);
    private IAppCache CACHE = AppCache.get((String)"cal");
    private RowMeta rowMeta = new RowMeta(new Field[]{new Field("id", (DataType)DataType.LongType), new Field("entity", (DataType)DataType.StringType)});
    private Map<String, MainEntityType> entity2EntityTypeMap = new HashMap<String, MainEntityType>(4);
    private Map<String, DynamicObject> entity2DynamicObjectMap = new HashMap<String, DynamicObject>(4);
    private Map<String, String> entity2EntryKeyMap = new HashMap<String, String>(4);
    private static final String COSTACCOUNTFIELDS = "id,name,number,calpolicy,calpolicy.currency,calpolicy.currency.amtprecision,calpolicy.currency.priceprecision,dividebasis,calpolicy.currency.number,calpolicy.currency.name,calpolicy.convertmode,calpolicy.exratetable,calpolicy.calbycostelement,calpolicy.supporttaxamt,calorg,calorg.name,calorg.number";
    private Map<Long, DynamicObjectCollection> costAccountMap = new HashMap<Long, DynamicObjectCollection>(32);
    private Set<Long> isCalInvSchemeIds = new HashSet<Long>(16);
    private Set<Long> isCalInvTypeIds = new HashSet<Long>(16);
    private boolean isBizGroupModel = AcctGroupModelHelper.isBizGroupModel();
    private boolean eas_sync_handle_catrange = CalDbParamServiceHelper.getBoolean((String)CalDbParamConstant.EAS_SYNC_HANDLE_CATRANGE);
    private Set<Long> errorBizBillIds = new HashSet<Long>(4);
    private Map<Long, BigDecimal> purFeeMap = new HashMap<Long, BigDecimal>(4);
    private Map<Long, BigDecimal> purMaterialCostMap = new HashMap<Long, BigDecimal>(4);
    private Map<Long, BigDecimal> purActualCostMap = new HashMap<Long, BigDecimal>(4);
    private IDGenerator cosRecIdGen = new IDGenerator("t_cal_calcostrecord");
    private IDGenerator idGenerator = new IDGenerator("t_cal_calbill_pk");

    public void execute(RequestContext requestContext, Map<String, Object> paramMap) throws KDException {
        int batch_size = CalDbParamServiceHelper.getInteger((String)CalDbParamConstant.EAS_SYNC_BATCH_SIZE);
        String BATCHSTR = (String)paramMap.get("BATCHSTR");
        String begindateStr = (String)paramMap.get("begindate");
        Date begindate = begindateStr == null ? null : new Date(Long.parseLong(begindateStr));
        String enddateStr = (String)paramMap.get("enddate");
        Date enddate = enddateStr == null ? null : new Date(Long.parseLong(enddateStr));
        String msg = "success";
        String taskKey = (String)paramMap.get("taskKey");
        this.init(taskKey, begindate, enddate);
        try {
            Map<String, Set<Long>> entity2BizBillIdMap = this.getCostRecordBizBillIdMap(begindate, enddate);
            CalBillRuleHelper calBillRuleHelper = new CalBillRuleHelper();
            calBillRuleHelper.loadAllRules();
            Map inCalBillRuleMap = calBillRuleHelper.getInCalBillRuleMap();
            Map outCalBillRuleMap = calBillRuleHelper.getOutCalBillRuleMap();
            ArrayList<Input> allBizBillInputs = new ArrayList<Input>(4);
            List<Input> inBizBillInputs = this.allBizBillInputs(begindate, enddate, inCalBillRuleMap);
            List<Input> outBizBillInputs = this.allBizBillInputs(begindate, enddate, outCalBillRuleMap);
            allBizBillInputs.addAll(inBizBillInputs);
            allBizBillInputs.addAll(outBizBillInputs);
            if (allBizBillInputs.isEmpty()) {
                return;
            }
            this.cacheInvSchemeAndInvTypeInfos();
            Algo algo = Algo.create((String)((Object)((Object)this)).getClass().getName());
            DataSet allBillDs = algo.createDataSet((Input[])allBizBillInputs.toArray(new OrmInput[allBizBillInputs.size()]));
            HashMap<String, Set> needSyncEntity2BizBillIdMap = new HashMap<String, Set>(16);
            for (Row row : allBillDs) {
                String entity = row.getString("entity");
                Long bizbillid = row.getLong("id");
                Set<Long> syncedBizBillids = entity2BizBillIdMap.get(entity);
                if (syncedBizBillids != null && syncedBizBillids.contains(bizbillid)) continue;
                Set needSyncBizBillids = needSyncEntity2BizBillIdMap.computeIfAbsent(entity, k -> new HashSet(4));
                needSyncBizBillids.add(bizbillid);
            }
            CalBillInfo inCalBillInfo = new CalBillInfo("cal_incalbill");
            CalBillInfo outCalBillInfo = new CalBillInfo("cal_outcalbill");
            for (Map.Entry bizIdEntry : needSyncEntity2BizBillIdMap.entrySet()) {
                String entity = (String)bizIdEntry.getKey();
                Set bizbillids = (Set)bizIdEntry.getValue();
                List inCalBillRules = inCalBillRuleMap.get(entity) == null ? Collections.emptyList() : (List)inCalBillRuleMap.get(entity);
                List outCalBillRules = outCalBillRuleMap.get(entity) == null ? Collections.emptyList() : (List)outCalBillRuleMap.get(entity);
                Lists.partition(Arrays.asList(bizbillids.toArray(new Long[0])), (int)batch_size).forEach(list -> {
                    this.errorBizBillIds.clear();
                    HashMap<CalBillInfo, Map<String, DynamicObject>> calBillMap = new HashMap<CalBillInfo, Map<String, DynamicObject>>(4);
                    HashMap<Long, Set<String>> exFieldMap = new HashMap<Long, Set<String>>(32);
                    for (Object calBillRule : inCalBillRules) {
                        this.createCalBill(inCalBillInfo, entity, inCalBillRules, outCalBillRules, (List<Long>)list, (Map<CalBillInfo, Map<String, DynamicObject>>)calBillMap, (Map<Long, Set<String>>)exFieldMap, (CalBillRule)calBillRule, "cal_incalbill");
                    }
                    for (Object calBillRule : outCalBillRules) {
                        this.createCalBill(outCalBillInfo, entity, inCalBillRules, outCalBillRules, (List<Long>)list, (Map<CalBillInfo, Map<String, DynamicObject>>)calBillMap, (Map<Long, Set<String>>)exFieldMap, (CalBillRule)calBillRule, "cal_outcalbill");
                    }
                    HashMap<String, List<DynamicObject>> costBillMap = new HashMap<String, List<DynamicObject>>(4);
                    for (Map.Entry entry : calBillMap.entrySet()) {
                        CalBillInfo calInfo = (CalBillInfo)entry.getKey();
                        Map map = (Map)entry.getValue();
                        DynamicObject[] billarr = map.values().toArray(new DynamicObject[0]);
                        if (this.isBizGroupModel) {
                            billarr = this.getCalBillPKArr(billarr, calInfo);
                        }
                        if (billarr.length > 0) {
                            try {
                                SaveServiceHelper.save((DynamicObject[])billarr);
                            }
                            catch (Exception e) {
                                String exceptionStackTraceMessage = ExceptionUtils.getExceptionStackTraceMessage((Exception)e);
                                logger.info("kd.fi.cal.business.process.impl.CreateCostRecordProcess-\u4fdd\u5b58\u6838\u7b97\u5355\u5f02\u5e38" + exceptionStackTraceMessage);
                            }
                        }
                        for (Map.Entry stringDynamicObjectEntry : map.entrySet()) {
                            List dynamicObjects = costBillMap.computeIfAbsent((String)stringDynamicObjectEntry.getKey(), (Function<String, List<DynamicObject>>)((Function<String, List>)k -> new ArrayList(4)));
                            dynamicObjects.add(stringDynamicObjectEntry.getValue());
                        }
                    }
                    this.createCostRecord(exFieldMap, costBillMap, entity);
                    if (!this.errorBizBillIds.isEmpty()) {
                        QFilter q1 = new QFilter("bizbillid", "in", this.errorBizBillIds);
                        DeleteServiceHelper.delete((String)"cal_costrecord_subentity", (QFilter[])new QFilter[]{q1});
                        logger.info("CreateCostRecordProcess-\u6838\u7b97\u6210\u672c\u8bb0\u5f55\u5220\u9664\uff1a");
                        if (this.isBizGroupModel) {
                            DeleteServiceHelper.delete((String)"cal_calbill_pk", (QFilter[])new QFilter[]{q1});
                        } else {
                            DeleteServiceHelper.delete((String)"cal_incalbill", (QFilter[])new QFilter[]{q1});
                            DeleteServiceHelper.delete((String)"cal_outcalbill", (QFilter[])new QFilter[]{q1});
                        }
                    }
                });
            }
        }
        catch (Exception e) {
            msg = "error-traceid:" + RequestContext.get().getTraceId();
            logger.error((Throwable)e);
            throw e;
        }
        finally {
            this.CACHE.put(BATCHSTR, (Object)msg);
        }
    }

    private void init(String taskKey, Date begindate, Date enddate) {
        HashMap<String, Date> map;
        String cacheid = (String)this.CACHE.get(taskKey + "#PURCOSTINFO", String.class);
        DataSet infoDS = null;
        try {
            infoDS = Algo.getCacheDataSet((String)cacheid).toDataSet(Algo.create((String)((Object)((Object)this)).getClass().getName()), false);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        if (infoDS == null) {
            infoDS = DB.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (DBRoute)new DBRoute("cal"), (String)"select fbizbillentryid,fpurchasefee,fmaterialcost,factualcost,fbizdate from t_im_purinwarehsentry_caltemp");
            CacheHint cacheHint = new CacheHint();
            CachedDataSet cache = infoDS.cache(cacheHint);
            String cacheId = cache.getCacheId();
            this.CACHE.put(taskKey + "#PURCOSTINFO", (Object)cacheId);
            infoDS = Algo.getCacheDataSet((String)cacheId).toDataSet(Algo.create((String)((Object)((Object)this)).getClass().getName()), false);
        }
        if (begindate == null) {
            map = new HashMap<String, Date>(4);
            map.put("enddateValue", enddate);
            infoDS = infoDS.where("fbizdate <= enddateValue", map);
        } else {
            map = new HashMap(4);
            map.put("enddateValue", enddate);
            map.put("begindateValue", begindate);
            infoDS = infoDS.where("fbizdate <= enddateValue and fbizdate >= begindateValue", map);
        }
        for (Row row : infoDS) {
            Long entryid = row.getLong("fbizbillentryid");
            BigDecimal fpurchasefee = row.getBigDecimal("fpurchasefee");
            BigDecimal fmaterialcost = row.getBigDecimal("fmaterialcost");
            BigDecimal factualcost = row.getBigDecimal("factualcost");
            this.purFeeMap.put(entryid, fpurchasefee);
            this.purMaterialCostMap.put(entryid, fmaterialcost);
            this.purActualCostMap.put(entryid, factualcost);
        }
    }

    private void createCostRecord(Map<Long, Set<String>> exFieldMap, Map<String, List<DynamicObject>> costBillMap, String entity) {
        HashMap costRecordMap = new HashMap();
        HashSet<DynamicObject> costRecordAllSet = new HashSet<DynamicObject>(16);
        HashMap<Long, CostAccountCache> costAccountCache = new HashMap<Long, CostAccountCache>();
        HashMap<Long, DynamicObject> ownerMap = new HashMap<Long, DynamicObject>();
        for (Map.Entry<String, List<DynamicObject>> entry : costBillMap.entrySet()) {
            boolean isSingle;
            HashSet<DynamicObject> costRecordSet = new HashSet<DynamicObject>(16);
            String key = entry.getKey();
            long billId = Long.parseLong(key.split(",")[0]);
            Long ownerId = Long.valueOf(key.split(",")[1]);
            DynamicObjectCollection costAccounts = this.getAllCostAccount(ownerId);
            if (costAccounts.isEmpty()) {
                DynamicObject owner = (DynamicObject)ownerMap.get(ownerId);
                if (owner == null) {
                    owner = BusinessDataServiceHelper.loadSingleFromCache((Object)ownerId, (String)"bos_org", (String)"id,number,name");
                }
                if (owner == null) {
                    owner = BusinessDataServiceHelper.loadSingleFromCache((Object)ownerId, (String)"bd_supplier", (String)"id,number,name");
                }
                if (owner == null) {
                    owner = BusinessDataServiceHelper.loadSingleFromCache((Object)ownerId, (String)"bd_customer", (String)"id,number,name");
                }
                if (owner == null) continue;
                ownerMap.put(ownerId, owner);
                continue;
            }
            int size = costAccounts.size();
            DynamicObject calBill = null;
            if (size <= 0) continue;
            List<DynamicObject> calBillList = entry.getValue();
            int listSize = calBillList.size();
            boolean bl = isSingle = listSize == 1;
            if (listSize > 1) {
                Collections.sort(calBillList, new /* Unavailable Anonymous Inner Class!! */);
            }
            boolean isErr = false;
            for (int i = 0; i < listSize; ++i) {
                calBill = calBillList.get(i);
                String calNo = calBill.getString("billNo");
                for (DynamicObject costAccount : costAccounts) {
                    CostRecordNoGenerator generator = new CostRecordNoGenerator(calNo, isSingle, i + 1);
                    Set<String> exFieldSet = exFieldMap.get(calBill.getLong("id"));
                    try {
                        CostRecordBuilder builder = new CostRecordBuilder(calBill, costAccount, exFieldSet, costAccountCache, false);
                        DynamicObject record = builder.createCostRecord(generator, costAccountCache);
                        record.set("id", (Object)this.cosRecIdGen.getId());
                        costRecordSet.add(record);
                    }
                    catch (Exception e) {
                        logger.error("CreateCostRecordProcess-\u5f02\u5e38", (Throwable)e);
                        isErr = true;
                        break;
                    }
                }
                if (isErr) break;
            }
            if (!isErr) {
                HashSet set = (HashSet)costRecordMap.get(billId);
                if (set == null) {
                    set = new HashSet(16);
                    costRecordMap.put(billId, set);
                }
                set.addAll(costRecordSet);
                continue;
            }
            this.errorBizBillIds.add(billId);
        }
        for (Map.Entry<String, List<Object>> entry : costRecordMap.entrySet()) {
            for (DynamicObject info : (Set)((Object)entry.getValue())) {
                costRecordAllSet.add(info);
            }
        }
        if (costRecordAllSet == null || costRecordAllSet.isEmpty()) {
            return;
        }
        DynamicObject[] infos = costRecordAllSet.toArray(new DynamicObject[costRecordAllSet.size()]);
        this.handleCost(infos, entity);
        if (this.eas_sync_handle_catrange) {
            MaterialCategoryHandle.handle4Bill((DynamicObject[])infos);
            new AccountTypeHelperNew(infos).handleCalRangeAccountType();
            this.updateBeforeCostPriceSource(infos, null);
        }
        SaveServiceHelper.save((DynamicObject[])infos);
    }

    private void handleCost(DynamicObject[] infos, String entity) {
        for (DynamicObject info : infos) {
            info.set("billstatus", (Object)"C");
            DynamicObjectCollection entry = info.getDynamicObjectCollection("entry");
            for (DynamicObject entryRow : entry) {
                entryRow.set("entrystatus", (Object)"C");
                Long bizbillentryid = entryRow.getLong("bizbillentryid");
                BigDecimal baseqty = entryRow.getBigDecimal("baseqty");
                if ("im_purinbill".equals(entity)) {
                    BigDecimal fee = this.purFeeMap.get(bizbillentryid);
                    BigDecimal actualcost = this.purActualCostMap.get(bizbillentryid);
                    if (fee != null && actualcost != null) {
                        entryRow.set("fee", (Object)fee);
                        entryRow.set("unitfee", (Object)fee.divide(baseqty, 10, RoundingMode.HALF_UP));
                        entryRow.set("actualcost", (Object)actualcost);
                        entryRow.set("unitactualcost", (Object)actualcost.divide(baseqty, 10, RoundingMode.HALF_UP));
                    }
                } else if ("im_ospurinbill".equals(entity)) {
                    BigDecimal materialcost = this.purMaterialCostMap.get(bizbillentryid);
                    BigDecimal fee = this.purFeeMap.get(bizbillentryid);
                    BigDecimal actualcost = this.purActualCostMap.get(bizbillentryid);
                    if (fee != null && materialcost != null && actualcost != null) {
                        entryRow.set("fee", (Object)fee);
                        entryRow.set("unitfee", (Object)fee.divide(baseqty, 10, RoundingMode.HALF_UP));
                        entryRow.set("materialcost", (Object)materialcost);
                        entryRow.set("unitmaterialcost", (Object)materialcost.divide(baseqty, 10, RoundingMode.HALF_UP));
                        entryRow.set("actualcost", (Object)actualcost);
                        entryRow.set("unitactualcost", (Object)actualcost.divide(baseqty, 10, RoundingMode.HALF_UP));
                    }
                }
                DynamicObjectCollection subEntrys = entryRow.getDynamicObjectCollection("subentrycostelement");
                DynamicObject subEntryRow = subEntrys.addNew();
                subEntryRow.set("costelement", (Object)773126985240072192L);
                subEntryRow.set("costsubelement", (Object)773175233367685120L);
                subEntryRow.set("sub_material", entryRow.get("material_id"));
                subEntryRow.set("sub_baseunit", entryRow.get("baseunit_id"));
                subEntryRow.set("sub_baseqty", entryRow.get("baseqty"));
                subEntryRow.set("sub_unitactualcost", entryRow.get("unitactualcost"));
                subEntryRow.set("sub_actualcost", entryRow.get("actualcost"));
                subEntryRow.set("sub_currency", info.get("localcurrency"));
            }
        }
    }

    private void updateBeforeCostPriceSource(DynamicObject[] infos, String type) {
        for (DynamicObject costRecord : infos) {
            DynamicObjectCollection entrys = costRecord.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entrys) {
                BigDecimal unitactualcost;
                String costpricesource = entry.getString("costpricesource");
                boolean isUpdateFromExpCalcute = CostPriceSourceTypeHelper.isUpdateFromExpCalcute((String)type, (String)costpricesource);
                if (isUpdateFromExpCalcute || (unitactualcost = entry.getBigDecimal("unitactualcost")) == null || unitactualcost.compareTo(BigDecimal.ZERO) == 0) continue;
                entry.set("costpricesource", (Object)CostPriceSourceTypeEnum.getCostPriceSourceValue((String)CostPriceSourceTypeEnum.DOCUMENT_SPECIFICATION.getValue()));
                entry.set("designatedcost", (Object)CostPriceSourceTypeEnum.DOCUMENT_SPECIFICATION.getDesignated());
            }
        }
    }

    private void createCalBill(CalBillInfo calBillInfo, String entity, List<CalBillRule> inCalBillRules, List<CalBillRule> outCalBillRules, List<Long> bizBillIds, Map<CalBillInfo, Map<String, DynamicObject>> calBillMap, Map<Long, Set<String>> exFieldMap, CalBillRule calBillRule, String calBillEntityName) {
        String calBillEntryKey = calBillInfo.getEntrykey();
        String bizEntityEntryKey = this.getBizEntityEntryKey(entity, inCalBillRules, outCalBillRules);
        FieldMappingResult mappingResult = CreateCostRecordHelper.getFieldMapping((DynamicObject)calBillRule.getRuleDyn(), (String)calBillEntityName, (MainEntityType)this.getEntityType(entity), (CalBillInfo)calBillInfo, (String)bizEntityEntryKey);
        String ownerkey = mappingResult.getOwnerField().getTotalkey();
        kd.fi.cal.business.process.inner.Field calorgField = mappingResult.getCalOrgField();
        StringBuilder bizEntryKey = new StringBuilder();
        String[] entryOwners = ownerkey.split("\\.");
        entryOwners[entryOwners.length - 1] = "id";
        for (String name : entryOwners) {
            bizEntryKey.append(name).append('.');
        }
        String bizEntryKeyStr = bizEntryKey.toString().substring(0, bizEntryKey.length() - 1);
        String bizSelector = CreateCostRecordHelper.getBizBillSelector((Collection)mappingResult.getBizFieldSet(), (String)bizEntityEntryKey, (String)entity);
        if (!bizSelector.contains(bizEntryKeyStr)) {
            bizSelector = bizSelector + "," + bizEntryKeyStr;
        }
        Map<Long, DynamicObjectCollection> validEntryMaps = this.getValidEntrys(calBillRule.getBillFilters(), bizBillIds, bizSelector, bizEntryKeyStr, entity);
        for (Map.Entry<Long, DynamicObjectCollection> entry : validEntryMaps.entrySet()) {
            long bizBillId = entry.getKey();
            DynamicObjectCollection bizBillColl = entry.getValue();
            if (bizBillColl.isEmpty()) continue;
            HashSet<String> exFieldSet = new HashSet<String>();
            for (DynamicObject ruleEntry : calBillRule.getRuleDyn().getDynamicObjectCollection("fieldmap")) {
                boolean isExtendField = ruleEntry.getBoolean("isextendfield");
                if (!isExtendField) continue;
                String calFieldName = ruleEntry.getString("calfield");
                exFieldSet.add(calFieldName);
            }
            Map<String, DynamicObject> bizbillidOwnerMapCalBill = calBillMap.get(calBillInfo);
            if (bizbillidOwnerMapCalBill == null) {
                bizbillidOwnerMapCalBill = new HashMap<String, DynamicObject>(16);
                calBillMap.put(calBillInfo, bizbillidOwnerMapCalBill);
            }
            Map headMapping = mappingResult.getHeadmap();
            Map entryMapping = mappingResult.getEntrymap();
            for (DynamicObject billentry : bizBillColl) {
                String bizBillId2OwneridKey;
                DynamicObject calBill;
                Long ownerid = billentry.getLong(ownerkey);
                boolean isPurRecBill = "im_purreceivebill".equals(entity);
                if (isPurRecBill && calorgField != null && StringUtils.isNotEmpty((String)calorgField.getTotalkey()) && billentry.getLong(calorgField.getTotalkey()) != 0L) {
                    ownerid = billentry.getLong(calorgField.getTotalkey());
                }
                if ((calBill = bizbillidOwnerMapCalBill.get(bizBillId2OwneridKey = bizBillId + "," + ownerid)) == null) {
                    calBill = BusinessDataServiceHelper.newDynamicObject((String)calBillEntityName);
                    calBill.set("id", (Object)this.idGenerator.getId());
                    for (Map.Entry mapEntry : headMapping.entrySet()) {
                        calBill.set(((kd.fi.cal.business.process.inner.Field)mapEntry.getKey()).getProperty(), billentry.get(((kd.fi.cal.business.process.inner.Field)mapEntry.getValue()).getTotalkey()));
                    }
                    for (Map.Entry mapEntry : headMapping.entrySet()) {
                        calBill.set(((kd.fi.cal.business.process.inner.Field)mapEntry.getKey()).getProperty(), billentry.get(((kd.fi.cal.business.process.inner.Field)mapEntry.getValue()).getTotalkey()));
                    }
                    calBill.set("bizbillid", billentry.get("id"));
                    calBill.set("bizentityobject", (Object)this.getEntityTypeDynamicObject(entity));
                    calBill.set("billstatus", (Object)"C");
                    bizbillidOwnerMapCalBill.put(bizBillId2OwneridKey, calBill);
                }
                DynamicObjectCollection entryCol = calBill.getDynamicObjectCollection(calBillEntryKey);
                DynamicObject costBillEntry = entryCol.addNew();
                costBillEntry.set("seq", (Object)entryCol.size());
                for (Map.Entry entryMap : entryMapping.entrySet()) {
                    costBillEntry.set(((kd.fi.cal.business.process.inner.Field)entryMap.getKey()).getProperty(), billentry.get(((kd.fi.cal.business.process.inner.Field)entryMap.getValue()).getTotalkey()));
                }
                if (StringUtils.isEmpty((String)bizEntryKeyStr)) {
                    costBillEntry.set("bizbillentryid", billentry.get(bizEntryKeyStr + ".id"));
                } else {
                    costBillEntry.set("bizbillentryid", billentry.get(bizEntryKeyStr));
                }
                exFieldMap.put(calBill.getLong("id"), exFieldSet);
            }
        }
    }

    private void cacheInvSchemeAndInvTypeInfos() {
        QFilter invSchemeFilter = new QFilter("isforwardamount", "=", (Object)true);
        DynamicObjectCollection invSchemes = QueryServiceHelper.query((String)"im_invscheme", (String)"id", (QFilter[])invSchemeFilter.toArray());
        for (DynamicObject dynamicObject : invSchemes) {
            this.isCalInvSchemeIds.add(dynamicObject.getLong("id"));
        }
        QFilter invTypeFilter = new QFilter("isforwardamount", "=", (Object)true);
        DynamicObjectCollection invTypes = QueryServiceHelper.query((String)"bd_invtype", (String)"id", (QFilter[])invTypeFilter.toArray());
        for (DynamicObject dynamicObject : invTypes) {
            this.isCalInvTypeIds.add(dynamicObject.getLong("id"));
        }
    }

    private DynamicObjectCollection getAllCostAccount(long ownerId) {
        DynamicObjectCollection accountcoll = this.costAccountMap.get(ownerId);
        if (accountcoll == null) {
            DynamicObjectCollection coll = AccountingSysHelper.getAccountingSysCollsByOwner((Long)ownerId, null);
            QFilter q = QFilter.of((String)"1 <> 1", (Object[])new Object[0]);
            for (DynamicObject info : coll) {
                long calSystemId = info.getLong("id");
                long calOrgId = info.getLong("calorgid");
                QFilter q1 = new QFilter("calsystem", "=", (Object)calSystemId);
                q1.and("calorg", "=", (Object)calOrgId);
                q.or(q1);
            }
            q.and("status", "=", (Object)"C");
            q.and("enable", "=", (Object)"1");
            new CalGroupAccountHelper().addNotGroupAcctFilterSelf(q);
            accountcoll = QueryServiceHelper.query((String)"cal_bd_costaccount", (String)COSTACCOUNTFIELDS, (QFilter[])q.toArray());
            this.costAccountMap.put(ownerId, accountcoll);
        }
        return accountcoll;
    }

    private DynamicObject[] getCalBillPKArr(DynamicObject[] billarr, CalBillInfo calInfo) {
        String calbilltype = "IN";
        if ("cal_outcalbill".equals(calInfo.getType().getName())) {
            calbilltype = "OUT";
        }
        IDGenerator idGenerator = new IDGenerator("t_cal_calbill_pk");
        HashSet<DynamicObject> calBillPKs = new HashSet<DynamicObject>(16);
        for (DynamicObject calbill : billarr) {
            Long calbillid = calbill.getLong("id");
            String billno = calbill.getString("billno");
            Long bizbillid = calbill.getLong("bizbillid");
            DynamicObjectCollection entry = calbill.getDynamicObjectCollection(calInfo.getEntrykey());
            for (DynamicObject entryRow : entry) {
                Long bizbillentryid = entryRow.getLong("bizbillentryid");
                Long calentryid = idGenerator.getId();
                entryRow.set("id", (Object)calentryid);
                DynamicObject calbillpk = BusinessDataServiceHelper.newDynamicObject((String)"cal_calbill_pk");
                calbillpk.set("id", (Object)calentryid);
                calbillpk.set("bizbillid", (Object)bizbillid);
                calbillpk.set("bizbillentryid", (Object)bizbillentryid);
                calbillpk.set("billno", (Object)billno);
                calbillpk.set("calbilltype", (Object)calbilltype);
                calbillpk.set("calbillid", (Object)calbillid);
                calbillpk.set("createtime", (Object)TimeServiceHelper.now());
                calBillPKs.add(calbillpk);
            }
        }
        return calBillPKs.toArray(new DynamicObject[0]);
    }

    protected Map<Long, DynamicObjectCollection> getValidEntrys(List<QFilter> filters, List<Long> bizBillID, String selectors, String bizEntryKey, String entity) {
        ArrayList<QFilter> allFitlers = new ArrayList<QFilter>(4);
        allFitlers.addAll(filters);
        allFitlers.add(new QFilter("id", "in", bizBillID));
        DynamicObjectCollection bizBillColl = QueryServiceHelper.query((String)entity, (String)selectors, (QFilter[])allFitlers.toArray(new QFilter[0]));
        HashMap<Long, DynamicObjectCollection> map = new HashMap<Long, DynamicObjectCollection>();
        HashSet<Long> hasEntryIds = new HashSet<Long>(16);
        for (DynamicObject info : bizBillColl) {
            long id = info.getLong("id");
            DynamicObjectCollection coll = (DynamicObjectCollection)map.get(id);
            if (coll != null) {
                boolean isExist = false;
                if (!hasEntryIds.add(info.getLong(bizEntryKey))) {
                    isExist = true;
                }
                if (isExist) continue;
                coll.add((Object)info);
                continue;
            }
            coll = new DynamicObjectCollection();
            coll.add((Object)info);
            map.put(id, coll);
            hasEntryIds.add(info.getLong(bizEntryKey));
        }
        return map;
    }

    private String getBizEntityEntryKey(String entity, List<CalBillRule> inCalBillRules, List<CalBillRule> outCalBillRules) {
        String entryKey = this.entity2EntryKeyMap.get(entity);
        if (entryKey == null) {
            ArrayList<DynamicObject> allrules = new ArrayList<DynamicObject>(4);
            for (CalBillRule inCalBillRule : inCalBillRules) {
                allrules.add(inCalBillRule.getRuleDyn());
            }
            for (CalBillRule outCalBillRule : outCalBillRules) {
                allrules.add(outCalBillRule.getRuleDyn());
            }
            entryKey = SynBizBillHelper.getFirstEntryKeyByMatField((String)entity, allrules);
            this.entity2EntryKeyMap.put(entity, entryKey);
        }
        return entryKey;
    }

    private MainEntityType getEntityType(String entity) {
        MainEntityType entityType = this.entity2EntityTypeMap.get(entity);
        if (entityType == null) {
            entityType = MetadataServiceHelper.getDataEntityType((String)entity);
            this.entity2EntityTypeMap.put(entity, entityType);
        }
        return entityType;
    }

    private DynamicObject getEntityTypeDynamicObject(String entity) {
        DynamicObject entityType = this.entity2DynamicObjectMap.get(entity);
        if (entityType == null) {
            entityType = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_entityobject", (String)"id,number,name", (QFilter[])new QFilter("number", "=", (Object)entity).toArray());
            this.entity2DynamicObjectMap.put(entity, entityType);
        }
        return entityType;
    }

    private List<Input> allBizBillInputs(Date begindate, Date enddate, Map<String, List<CalBillRule>> inCalBillRuleMap) {
        ArrayList<Input> bizBillInputs = new ArrayList<Input>(4);
        for (Map.Entry<String, List<CalBillRule>> entry : inCalBillRuleMap.entrySet()) {
            String entity = entry.getKey();
            List<CalBillRule> calBillRules = entry.getValue();
            if (calBillRules == null || calBillRules.isEmpty()) continue;
            String selectFields = "id, '" + entity + "' as entity";
            for (CalBillRule calBillRule : calBillRules) {
                List bizFilters = calBillRule.getBillFilters();
                Map calBillFielsMap = calBillRule.getCalBizFieldMap();
                if (calBillFielsMap == null) continue;
                String bizDateField = (String)calBillFielsMap.get("bookdate");
                List bookdateFilters = DateUtils.getDateSplitFilters((Date)begindate, (Date)enddate, (String)bizDateField, (boolean)false);
                QFilter entityFilter = null;
                if (entity.contains("im_mdc_")) {
                    entityFilter = new QFilter("billtype.billformid.number", "=", (Object)entity);
                }
                for (QFilter bookdateFilter : bookdateFilters) {
                    ArrayList<QFilter> filters = new ArrayList<QFilter>(4);
                    filters.add(bookdateFilter);
                    filters.addAll(bizFilters);
                    if (entityFilter != null) {
                        filters.add(entityFilter);
                    }
                    OrmInput input = new OrmInput(((Object)((Object)this)).getClass().getName(), entity, selectFields, filters.toArray(new QFilter[0]), this.rowMeta);
                    bizBillInputs.add((Input)input);
                }
            }
        }
        return bizBillInputs;
    }

    private Map<String, Set<Long>> getCostRecordBizBillIdMap(Date begindate, Date enddate) {
        List bookdateFilters = DateUtils.getDateSplitFilters((Date)begindate, (Date)enddate, (String)"bookdate", (boolean)false);
        String calSelectFields = "bizbillid,bizentityobject,billtype.billformid";
        ArrayList<OrmInput> billOIs = new ArrayList<OrmInput>(16);
        for (QFilter dateSpitFilter : bookdateFilters) {
            OrmInput costRecordOI = new OrmInput(((Object)((Object)this)).getClass().getName(), "cal_costrecord", calSelectFields, dateSpitFilter.toArray());
            billOIs.add(costRecordOI);
        }
        if (billOIs.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, Set<Long>> map = new HashMap<String, Set<Long>>(16);
        Algo algo = Algo.create((String)((Object)((Object)this)).getClass().getName());
        DataSet allBillDs = algo.createDataSet((Input[])billOIs.toArray(new OrmInput[billOIs.size()]));
        for (Row row : allBillDs) {
            String bizentityobject = row.getString("bizentityobject");
            String billformid = row.getString("billtype.billformid");
            Long bizbillid = row.getLong("bizbillid");
            billformid = billformid == null ? bizentityobject : billformid;
            Set bizbillids = map.computeIfAbsent(billformid, k -> new HashSet(4));
            bizbillids.add(bizbillid);
        }
        return map;
    }

    private static class CostRecordNoGenerator
    implements IBillNoGenerator {
        private String calNo;
        private boolean isSingle;
        private int seq;

        CostRecordNoGenerator(String calNo, boolean isSingle, int seq) {
            this.calNo = calNo;
            this.isSingle = isSingle;
            this.seq = seq;
        }

        public String getNumber() {
            String number = null;
            number = this.isSingle ? this.calNo : this.calNo + "-" + this.seq;
            return number;
        }
    }
}

