/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.extsysupgrade.easwriteoffrecord;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import kd.bos.algo.Collector;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.ReduceGroupFunctionWithCollector;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.fi.cal.business.extsysupgrade.easwriteoffrecord.WriteOffBillRow;
import kd.fi.cal.business.extsysupgrade.easwriteoffrecord.writeoffrecordstrategy.AbstractRecordStrategy;
import kd.fi.cal.business.extsysupgrade.easwriteoffrecord.writeoffrecordstrategy.Neg2NegRecordStrategy;
import kd.fi.cal.business.extsysupgrade.easwriteoffrecord.writeoffrecordstrategy.Pos2NegRecordStrategy;
import kd.fi.cal.business.extsysupgrade.easwriteoffrecord.writeoffrecordstrategy.Pos2PosRecordStrategy;
import kd.fi.cal.business.extsysupgrade.easwriteoffrecord.writeoffrecordstrategy.SingleBillRecordStrategy;
import kd.fi.cal.common.util.DateUtils;

public class EASWriteoffRecordCreateFunction
extends ReduceGroupFunctionWithCollector {
    public void reduce(Iterator<Row> iterator, Collector collector) {
        Object strategy;
        ArrayList<WriteOffBillRow> imPosList = new ArrayList<WriteOffBillRow>();
        ArrayList<WriteOffBillRow> imNegList = new ArrayList<WriteOffBillRow>();
        ArrayList<WriteOffBillRow> aparPosList = new ArrayList<WriteOffBillRow>();
        ArrayList<WriteOffBillRow> aparNegList = new ArrayList<WriteOffBillRow>();
        Long FCOMPANYORGUNITID = 0L;
        int FCALCULATEKIND = 0;
        int FCREATETYPE = 0;
        int FWRITEOFFYEAR = 0;
        int FWRITEOFFPERIOD = 0;
        Date FWRITEOFFDATE = null;
        Long FCREATORID = 0L;
        String EASFID = "";
        while (iterator.hasNext()) {
            Row row = iterator.next();
            EASFID = row.getString("FID");
            FCOMPANYORGUNITID = row.getLong("FCOMPANYORGUNITID");
            FCALCULATEKIND = row.getInteger("FCALCULATEKIND");
            FCREATETYPE = row.getInteger("FCREATETYPE");
            FCREATORID = row.getLong("FCREATORID");
            FWRITEOFFDATE = row.getDate("FWRITEOFFDATE");
            FWRITEOFFYEAR = row.getInteger("FWRITEOFFYEAR");
            FWRITEOFFPERIOD = row.getInteger("FWRITEOFFPERIOD");
            Long billentryid = row.getLong("billentryid");
            if (billentryid == null) {
                return;
            }
            WriteOffBillRow writeOffBillRow = new WriteOffBillRow(row);
            if (writeOffBillRow.isImPos()) {
                imPosList.add(writeOffBillRow);
                continue;
            }
            if (writeOffBillRow.isImNeg()) {
                imNegList.add(writeOffBillRow);
                continue;
            }
            if (writeOffBillRow.isAparPos()) {
                aparPosList.add(writeOffBillRow);
                continue;
            }
            if (!writeOffBillRow.isAparNeg()) continue;
            aparNegList.add(writeOffBillRow);
        }
        imPosList.sort(Comparator.comparing(WriteOffBillRow::getCurWriteoffBaseqty));
        imNegList.sort(Comparator.comparing(WriteOffBillRow::getCurWriteoffBaseqty).reversed());
        aparPosList.sort(Comparator.comparing(WriteOffBillRow::getCurWriteoffBaseqty));
        aparNegList.sort(Comparator.comparing(WriteOffBillRow::getCurWriteoffBaseqty).reversed());
        Date writeoffPeriodEndDay = DateUtils.getMonthEndDayByYearMonth((int)FWRITEOFFYEAR, (int)FWRITEOFFPERIOD);
        List<Object[]> resRows = null;
        if (imPosList.size() > 0 && aparPosList.size() > 0) {
            strategy = new Pos2PosRecordStrategy(imPosList, aparPosList, FCALCULATEKIND, FCREATETYPE);
            resRows = ((AbstractRecordStrategy)strategy).create();
        } else if (imPosList.size() > 0 && imNegList.size() > 0) {
            strategy = new Pos2NegRecordStrategy(imPosList, imNegList, FCALCULATEKIND, FCREATETYPE);
            resRows = ((AbstractRecordStrategy)strategy).create();
        } else if (imNegList.size() > 0 && aparNegList.size() > 0) {
            strategy = new Neg2NegRecordStrategy(imNegList, aparNegList, FCALCULATEKIND, FCREATETYPE);
            resRows = ((AbstractRecordStrategy)strategy).create();
        } else if (aparPosList.size() > 0 && aparNegList.size() > 0) {
            strategy = new Pos2NegRecordStrategy(aparPosList, aparNegList, FCALCULATEKIND, FCREATETYPE);
            resRows = ((AbstractRecordStrategy)strategy).create();
        } else {
            strategy = new SingleBillRecordStrategy(imPosList, imNegList, aparPosList, aparNegList, FCALCULATEKIND, FCREATETYPE);
            resRows = ((SingleBillRecordStrategy)strategy).create();
        }
        if (resRows != null) {
            for (Object[] objects : resRows) {
                objects[0] = EASFID;
                objects[1] = FCOMPANYORGUNITID;
                objects[2] = FCREATORID;
                objects[3] = FWRITEOFFDATE;
                objects[4] = "extsys";
                objects[5] = writeoffPeriodEndDay;
                collector.collect(objects);
            }
        }
    }

    public RowMeta getResultRowMeta() {
        return new RowMeta(new Field[]{new Field("wfnumber", (DataType)DataType.StringType), new Field("org", (DataType)DataType.LongType), new Field("creator", (DataType)DataType.LongType), new Field("verifydate", (DataType)DataType.DateType), new Field("verifytype", (DataType)DataType.StringType), new Field("writeoffperiodendday", (DataType)DataType.DateType), new Field("verifyrelation", (DataType)DataType.StringType), new Field("verifyRecordEntity", (DataType)DataType.StringType), new Field("billno", (DataType)DataType.StringType), new Field("billtype", (DataType)DataType.StringType), new Field("billdate", (DataType)DataType.DateType), new Field("material", (DataType)DataType.LongType), new Field("measureunit", (DataType)DataType.LongType), new Field("baseunit", (DataType)DataType.LongType), new Field("qty", (DataType)DataType.BigDecimalType), new Field("baseqty", (DataType)DataType.BigDecimalType), new Field("verifyqty", (DataType)DataType.BigDecimalType), new Field("verifybaseqty", (DataType)DataType.BigDecimalType), new Field("asstacttype", (DataType)DataType.StringType), new Field("asstact", (DataType)DataType.LongType), new Field("currency", (DataType)DataType.LongType), new Field("payableamount", (DataType)DataType.BigDecimalType), new Field("verifyamount", (DataType)DataType.BigDecimalType), new Field("billid", (DataType)DataType.LongType), new Field("billentryid", (DataType)DataType.LongType), new Field("exchangerate", (DataType)DataType.BigDecimalType), new Field("e_billtype", (DataType)DataType.StringType), new Field("e_billno", (DataType)DataType.StringType), new Field("e_billdate", (DataType)DataType.DateType), new Field("e_asstacttype", (DataType)DataType.StringType), new Field("e_asstact", (DataType)DataType.StringType), new Field("e_currency", (DataType)DataType.LongType), new Field("e_material", (DataType)DataType.LongType), new Field("e_measureunit", (DataType)DataType.LongType), new Field("e_baseunit", (DataType)DataType.LongType), new Field("e_qty", (DataType)DataType.BigDecimalType), new Field("e_baseqty", (DataType)DataType.BigDecimalType), new Field("e_payableamount", (DataType)DataType.BigDecimalType), new Field("e_verifyqty", (DataType)DataType.BigDecimalType), new Field("e_verifybaseqty", (DataType)DataType.BigDecimalType), new Field("e_verifyamount", (DataType)DataType.BigDecimalType), new Field("e_exchangerate", (DataType)DataType.BigDecimalType), new Field("e_billid", (DataType)DataType.LongType), new Field("e_billentryid", (DataType)DataType.LongType)});
    }
}

