/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.extsysupgrade.easwriteoffrecord;

import com.google.common.collect.Lists;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.Input;
import kd.bos.algo.JoinType;
import kd.bos.algo.ReduceGroupFunctionWithCollector;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.input.OrmInput;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.cal.business.extsysupgrade.easwriteoffrecord.EASWriteoffRecordConstant;
import kd.fi.cal.business.extsysupgrade.easwriteoffrecord.EASWriteoffRecordCreateFunction;
import kd.fi.cal.business.extsysupgrade.easwriteoffrecord.EASWriteoffRecordVerifyRelationHelper;
import kd.fi.cal.business.extsysupgrade.easwriteoffrecord.EASWriteoffRecordVerifySeqHelper;
import kd.fi.cal.business.wf.WfHelper;
import kd.fi.cal.common.helper.IDGenerator;
import kd.fi.cal.common.util.CommonUtils;

public class EASWriteoffRecordCreateSubTask
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(EASWriteoffRecordCreateSubTask.class);
    private IAppCache CACHE = AppCache.get((String)"cal");
    private static final String SQL_WRITEOFFRECORD_TEMPDATE1 = "SELECT A.FID,A.FCREATETYPE,A.FCALCULATEKIND,A.FCOMPANYORGUNITID,A.FWRITEOFFDATE,A.FCREATETIME,A.FCREATORID, A.FWRITEOFFYEAR,A.FWRITEOFFPERIOD,B.FBILLTYPENUMBER,B.FBILLENTRYID,B.FBILLDATE,B.FCURRWRITTENOFFQTY,B.FCURRWRITTENOFFAMOUNT FROM T_CL_WRITEOFFGROUP_CALTEMP A JOIN T_CL_WRITEOFFRECORD_CALTEMP B ON A.FID=B.FPARENTID WHERE A.FCREATETIME >= ? AND A.FCREATETIME < ?";
    private static final String SQL_WRITEOFFRECORD_TEMPDATE2 = "SELECT A.FID,A.FCREATETYPE,A.FCALCULATEKIND,A.FCOMPANYORGUNITID,A.FWRITEOFFDATE,A.FCREATETIME,A.FCREATORID, A.FWRITEOFFYEAR,A.FWRITEOFFPERIOD,B.FBILLTYPENUMBER,B.FBILLENTRYID,B.FBILLDATE,B.FCURRWRITTENOFFQTY,B.FCURRWRITTENOFFAMOUNT FROM T_CL_WRITEOFFGROUP_CALTEMP A JOIN T_CL_WRITEOFFRECORD_CALTEMP B ON A.FID=B.FPARENTID WHERE A.FCREATETIME >= ?";
    private Date begindate = null;
    private Date enddate = null;
    private Set<Long> orgIds = new HashSet<Long>(4);
    private Date purinBillMinDate = null;
    private Date purinBillMaxDate = null;
    private Set<String> easPurinEntryIds = new HashSet<String>(4);
    private Date osPurinBillMinDate = null;
    private Date osPurinBillMaxDate = null;
    private Set<String> easOsPurinEntryIds = new HashSet<String>(4);
    private Date saloutBillMinDate = null;
    private Date saloutBillMaxDate = null;
    private Set<String> easSaloutEntryIds = new HashSet<String>(4);
    private Date apBillMinDate = null;
    private Date apBillMaxDate = null;
    private Set<String> easApEntryIds = new HashSet<String>(4);
    private Date arBillMinDate = null;
    private Date arBillMaxDate = null;
    private Set<String> easArEntryIds = new HashSet<String>(4);

    public void execute(RequestContext requestContext, Map<String, Object> paramMap) throws KDException {
        String BATCHSTR = (String)paramMap.get("BATCHSTR");
        String begindateStr = (String)paramMap.get("begindate");
        this.begindate = begindateStr == null ? null : new Date(Long.parseLong(begindateStr));
        String enddateStr = (String)paramMap.get("enddate");
        this.enddate = enddateStr == null ? null : new Date(Long.parseLong(enddateStr));
        String msg = "success";
        String taskKey = (String)paramMap.get("taskKey");
        logger.info("EASWriteoffRecordCreateTask-lock");
        try {
            DataSet writeoffRecordTempData = this.createWriteoffRecordTempData();
            DataSet conWriteoffRecord = this.createConWriteoffRecord();
            String[] fieldNames = writeoffRecordTempData.getRowMeta().getFieldNames();
            writeoffRecordTempData = writeoffRecordTempData.join(conWriteoffRecord, JoinType.LEFT).on("FID", "wfnumber").select(fieldNames, conWriteoffRecord.getRowMeta().getFieldNames()).finish();
            writeoffRecordTempData = writeoffRecordTempData.where("wfnumber = null").select(fieldNames);
            this.collectParamsFromWriteoffRecordTempData(writeoffRecordTempData.copy());
            DataSet bizBillDataSet = this.createBizBillData();
            DataSet writeoffRecordJoinBizDataSet = writeoffRecordTempData.join(bizBillDataSet, JoinType.LEFT).on("FBILLENTRYID", "easentryid").select(writeoffRecordTempData.getRowMeta().getFieldNames(), bizBillDataSet.getRowMeta().getFieldNames()).finish();
            DataSet writeoffRecordDataSet = writeoffRecordJoinBizDataSet.groupBy(new String[]{"FID"}).reduceGroup((ReduceGroupFunctionWithCollector)new EASWriteoffRecordCreateFunction());
            writeoffRecordDataSet = writeoffRecordDataSet.orderBy(new String[]{"billid", "e_billid", "wfnumber"});
            IDGenerator apGenerator = new IDGenerator("ap_verifyrecord");
            IDGenerator arGenerator = new IDGenerator("ar_verifyrecord");
            EASWriteoffRecordVerifySeqHelper apSeqHelper = new EASWriteoffRecordVerifySeqHelper("ap_verifyrecord");
            EASWriteoffRecordVerifySeqHelper arSeqHelper = new EASWriteoffRecordVerifySeqHelper("ar_verifyrecord");
            HashSet<DynamicObject> apVerifyRecords = new HashSet<DynamicObject>(4);
            HashSet<DynamicObject> apOMVerifyRecords = new HashSet<DynamicObject>(4);
            HashSet<DynamicObject> arVerifyRecords = new HashSet<DynamicObject>(4);
            String preVerifySeq = "";
            HashMap<Long, Date> writeoffperiodenddayMap = new HashMap<Long, Date>(4);
            for (Row row : writeoffRecordDataSet) {
                String verifyrelation;
                String verifyRecordEntity = row.getString("verifyRecordEntity");
                Date writeoffperiodendday = row.getDate("writeoffperiodendday");
                DynamicObject verifyRecord = null;
                if ("cal_purwfrecord".equals(verifyRecordEntity)) {
                    verifyRecord = this.buildApRecord(row);
                    verifyRecord.set("id", (Object)apGenerator.getId());
                    apSeqHelper.setVerifySeq(verifyRecord);
                    verifyrelation = verifyRecord.getString("verifyrelation");
                    if ("appurin".equals(verifyrelation) || "appurreturn".equals(verifyrelation) || "purself".equals(verifyrelation) || "apfinself".equals(verifyrelation)) {
                        apVerifyRecords.add(verifyRecord);
                    } else if ("apomin".equals(verifyrelation) || "apominreturn".equals(verifyrelation) || "ominself".equals(verifyrelation)) {
                        apOMVerifyRecords.add(verifyRecord);
                    }
                } else if ("cal_salwfrecord".equals(verifyRecordEntity)) {
                    verifyRecord = this.buildArRecord(row);
                    verifyRecord.set("id", (Object)arGenerator.getId());
                    arSeqHelper.setVerifySeq(verifyRecord);
                    arVerifyRecords.add(verifyRecord);
                }
                if (verifyRecord == null) continue;
                verifyrelation = verifyRecord.getString("verifyrelation");
                verifyRecord.set("writeofftypeid", (Object)EASWriteoffRecordVerifyRelationHelper.getWriteoffTypeId(verifyrelation));
                writeoffperiodenddayMap.put(verifyRecord.getLong("id"), writeoffperiodendday);
                String verifyseq = verifyRecord.getString("verifyseq");
                if (!verifyseq.equals(preVerifySeq)) {
                    this.batchSaveAndInvoke(apVerifyRecords, apOMVerifyRecords, arVerifyRecords, 1000, writeoffperiodenddayMap);
                }
                preVerifySeq = verifyseq;
            }
            this.batchSaveAndInvoke(apVerifyRecords, apOMVerifyRecords, arVerifyRecords, 1, writeoffperiodenddayMap);
            logger.info("EASWriteoffRecordCreateTask-success");
        }
        catch (Exception e) {
            msg = "error-traceid:" + RequestContext.get().getTraceId();
            logger.error((Throwable)e);
            throw e;
        }
        finally {
            this.CACHE.put(BATCHSTR, (Object)msg);
        }
    }

    private DataSet createConWriteoffRecord() {
        QFilter filter = new QFilter("verifydate", ">=", (Object)this.begindate);
        if (this.enddate != null) {
            filter.and("verifydate", "<", (Object)this.enddate);
        }
        OrmInput arVerifyRecord = new OrmInput(((Object)((Object)this)).getClass().getName(), "cal_salwfrecord", "wfnumber", filter.toArray());
        OrmInput apVerifyRecord = new OrmInput(((Object)((Object)this)).getClass().getName(), "cal_purwfrecord", "wfnumber", filter.toArray());
        DataSet dataSet = Algo.create((String)((Object)((Object)this)).getClass().getName()).createDataSet(new Input[]{arVerifyRecord, apVerifyRecord});
        dataSet = dataSet.distinct();
        return dataSet;
    }

    private void batchSaveAndInvoke(Set<DynamicObject> apVerifyRecords, Set<DynamicObject> apOMVerifyRecords, Set<DynamicObject> arVerifyRecords, int batchsize, Map<Long, Date> writeoffperiodenddayMap) {
        if (apVerifyRecords.size() >= batchsize) {
            this.saveDBAndInvoke(writeoffperiodenddayMap, apVerifyRecords, "ap_verifyrecord");
        }
        if (apOMVerifyRecords.size() >= batchsize) {
            this.saveDBAndInvoke(writeoffperiodenddayMap, apOMVerifyRecords, "ap_verifyrecord");
        }
        if (arVerifyRecords.size() >= batchsize) {
            this.saveDBAndInvoke(writeoffperiodenddayMap, arVerifyRecords, "ar_verifyrecord");
        }
    }

    private void saveDBAndInvoke(Map<Long, Date> writeoffperiodenddayMap, Set<DynamicObject> verifyRecords, String entity) {
        if (verifyRecords != null && !verifyRecords.isEmpty()) {
            try (TXHandle txHandle = TX.requiresNew();){
                try {
                    SaveServiceHelper.save((DynamicObject[])verifyRecords.toArray(new DynamicObject[0]));
                    this.insertWriteOffIDChange(verifyRecords, entity, writeoffperiodenddayMap);
                }
                catch (Exception e) {
                    txHandle.markRollback();
                    throw e;
                }
            }
            new WfHelper().invokeWfByBatch(verifyRecords, entity);
            verifyRecords.clear();
        }
    }

    private void insertWriteOffIDChange(Set<DynamicObject> verifyRecords, String verifyrecordentity, Map<Long, Date> writeoffperiodenddayMap) {
        String sql = "insert into T_CAL_WRITEOFFRECORD_IDCHANGE(FCONID,FEASID,FFORMID,FWRITEOFFDATE)values(?,?,?,?)";
        try (TXHandle txHandle = TX.requiresNew();){
            try {
                ArrayList<Object[]> params = new ArrayList<Object[]>(4);
                for (DynamicObject verifyRecord : verifyRecords) {
                    long conid = verifyRecord.getLong("id");
                    String easId = verifyRecord.getString("wfnumber");
                    Date FWRITEOFFDATE = writeoffperiodenddayMap.remove(conid);
                    params.add(new Object[]{conid, easId, verifyrecordentity, FWRITEOFFDATE});
                }
                if (!params.isEmpty()) {
                    DB.executeBatch((DBRoute)CommonUtils.getCalDBRouteKey(), (String)sql, params);
                }
            }
            catch (Exception e) {
                txHandle.markRollback();
                throw e;
            }
        }
    }

    private DynamicObject buildApRecord(Row row) {
        DynamicObject record = BusinessDataServiceHelper.newDynamicObject((String)"cal_purwfrecord");
        record.set("wfnumber", (Object)row.getString("wfnumber"));
        record.set("billno", (Object)row.getString("billno"));
        record.set("billstatus", (Object)"C");
        record.set("billtype", (Object)row.getString("billtype"));
        record.set("billdate", (Object)row.getDate("billdate"));
        record.set("material", (Object)row.getLong("material"));
        record.set("measureunit", (Object)row.getLong("measureunit"));
        record.set("baseunit", (Object)row.getLong("baseunit"));
        record.set("qty", (Object)row.getBigDecimal("qty"));
        record.set("baseqty", (Object)row.getBigDecimal("baseqty"));
        record.set("verifyqty", (Object)row.getBigDecimal("verifyqty"));
        record.set("verifybaseqty", (Object)row.getBigDecimal("verifybaseqty"));
        record.set("asstacttype", (Object)row.getString("asstacttype"));
        record.set("asstact", (Object)row.getLong("asstact"));
        record.set("org", (Object)row.getLong("org"));
        record.set("currency", (Object)row.getLong("currency"));
        record.set("payableamount", (Object)row.getBigDecimal("payableamount"));
        record.set("verifyamount", (Object)row.getBigDecimal("verifyamount"));
        record.set("localverifyamt", (Object)row.getBigDecimal("verifyamount"));
        record.set("verifyintercostamt", (Object)row.getBigDecimal("verifyamount"));
        record.set("creator", (Object)row.getLong("creator"));
        record.set("verifytype", (Object)row.getString("verifytype"));
        record.set("verifyrelation", (Object)row.getString("verifyrelation"));
        record.set("billid", (Object)row.getString("billid"));
        record.set("billentryid", (Object)row.getString("billentryid"));
        record.set("basecurrency", (Object)row.getLong("currency"));
        record.set("exchangerate", (Object)row.getBigDecimal("exchangerate"));
        record.set("verifytaxamount", (Object)row.getBigDecimal("verifyamount"));
        record.set("localverifytaxamt", (Object)row.getBigDecimal("verifyamount"));
        record.set("verifydate", (Object)row.getDate("verifydate"));
        Long e_billid = row.getLong("e_billid");
        if (e_billid != null) {
            DynamicObjectCollection entry = record.getDynamicObjectCollection("entry");
            DynamicObject entryRow = entry.addNew();
            entryRow.set("e_billtype", (Object)row.getString("e_billtype"));
            entryRow.set("e_billno", (Object)row.getString("e_billno"));
            entryRow.set("e_billdate", (Object)row.getDate("e_billdate"));
            entryRow.set("e_asstacttype", (Object)row.getString("e_asstacttype"));
            entryRow.set("e_asstact", (Object)row.getLong("e_asstact"));
            entryRow.set("e_currency", (Object)row.getLong("e_currency"));
            entryRow.set("e_material", (Object)row.getLong("e_material"));
            entryRow.set("e_measureunit", (Object)row.getLong("e_measureunit"));
            entryRow.set("e_baseunit", (Object)row.getLong("e_baseunit"));
            entryRow.set("e_qty", (Object)row.getBigDecimal("e_qty"));
            entryRow.set("e_baseqty", (Object)row.getBigDecimal("e_baseqty"));
            entryRow.set("e_payableamount", (Object)row.getBigDecimal("e_payableamount"));
            entryRow.set("e_verifyqty", (Object)row.getBigDecimal("e_verifyqty"));
            entryRow.set("e_verifybaseqty", (Object)row.getBigDecimal("e_verifybaseqty"));
            entryRow.set("e_verifyamount", (Object)row.getBigDecimal("e_verifyamount"));
            entryRow.set("e_verifyintercostamt", (Object)row.getBigDecimal("e_verifyamount"));
            entryRow.set("e_localverifyamt", (Object)row.getBigDecimal("e_verifyamount"));
            entryRow.set("e_localverifytaxamt", (Object)row.getBigDecimal("e_verifyamount"));
            entryRow.set("e_verifytaxamount", (Object)row.getBigDecimal("e_verifyamount"));
            entryRow.set("e_exchangerate", (Object)row.getBigDecimal("e_exchangerate"));
            entryRow.set("e_basecurrency", (Object)row.getLong("e_currency"));
            entryRow.set("e_billid", (Object)row.getLong("e_billid"));
            entryRow.set("e_billentryid", (Object)row.getLong("e_billentryid"));
        }
        return record;
    }

    private DynamicObject buildArRecord(Row row) {
        DynamicObject record = BusinessDataServiceHelper.newDynamicObject((String)"cal_salwfrecord");
        record.set("wfnumber", (Object)row.getString("wfnumber"));
        record.set("billno", (Object)row.getString("billno"));
        record.set("billstatus", (Object)"C");
        record.set("billtype", (Object)row.getString("billtype"));
        record.set("billdate", (Object)row.getDate("billdate"));
        record.set("material", (Object)row.getLong("material"));
        record.set("measureunit", (Object)row.getLong("measureunit"));
        record.set("baseunit", (Object)row.getLong("baseunit"));
        record.set("qty", (Object)row.getBigDecimal("qty"));
        record.set("baseqty", (Object)row.getBigDecimal("baseqty"));
        record.set("verifyqty", (Object)row.getBigDecimal("verifyqty"));
        record.set("verifybaseqty", (Object)row.getBigDecimal("verifybaseqty"));
        record.set("producttype", (Object)"standard");
        record.set("asstacttype", (Object)row.getString("asstacttype"));
        record.set("asstact", (Object)row.getLong("asstact"));
        record.set("org", (Object)row.getLong("org"));
        record.set("currency", (Object)row.getLong("currency"));
        record.set("payableamount", (Object)row.getBigDecimal("payableamount"));
        record.set("verifyamount", (Object)row.getBigDecimal("verifyamount"));
        record.set("localverifyamt", (Object)row.getBigDecimal("verifyamount"));
        record.set("inventorycost", (Object)row.getBigDecimal("verifyamount"));
        record.set("baseactualcost", (Object)row.getBigDecimal("verifyamount").divide(row.getBigDecimal("verifybaseqty"), 10, RoundingMode.HALF_UP));
        record.set("creator", (Object)row.getLong("creator"));
        record.set("verifytype", (Object)row.getString("verifytype"));
        record.set("verifyrelation", (Object)row.getString("verifyrelation"));
        record.set("billid", (Object)row.getString("billid"));
        record.set("billentryid", (Object)row.getString("billentryid"));
        record.set("basecurrency", (Object)row.getLong("currency"));
        record.set("exchangerate", (Object)row.getBigDecimal("exchangerate"));
        record.set("verifytaxamount", (Object)row.getBigDecimal("verifyamount"));
        record.set("verifydate", (Object)row.getDate("verifydate"));
        Long e_billid = row.getLong("e_billid");
        if (e_billid != null) {
            DynamicObjectCollection entry = record.getDynamicObjectCollection("entry");
            DynamicObject entryRow = entry.addNew();
            entryRow.set("e_billtype", (Object)row.getString("e_billtype"));
            entryRow.set("e_billno", (Object)row.getString("e_billno"));
            entryRow.set("e_billdate", (Object)row.getDate("e_billdate"));
            entryRow.set("e_asstacttype", (Object)row.getString("e_asstacttype"));
            entryRow.set("e_asstact", (Object)row.getLong("e_asstact"));
            entryRow.set("e_currency", (Object)row.getLong("e_currency"));
            entryRow.set("e_material", (Object)row.getLong("e_material"));
            entryRow.set("e_measureunit", (Object)row.getLong("e_measureunit"));
            entryRow.set("e_baseunit", (Object)row.getLong("e_baseunit"));
            entryRow.set("e_qty", (Object)row.getBigDecimal("e_qty"));
            entryRow.set("e_baseqty", (Object)row.getBigDecimal("e_baseqty"));
            entryRow.set("e_payableamount", (Object)row.getBigDecimal("e_payableamount"));
            entryRow.set("e_verifyqty", (Object)row.getBigDecimal("e_verifyqty"));
            entryRow.set("e_verifybaseqty", (Object)row.getBigDecimal("e_verifybaseqty"));
            entryRow.set("e_verifyamount", (Object)row.getBigDecimal("e_verifyamount"));
            entryRow.set("e_localverifyamt", (Object)row.getBigDecimal("e_verifyamount"));
            entryRow.set("e_inventorycost", (Object)row.getBigDecimal("verifyamount"));
            entryRow.set("e_baseactualcost", (Object)row.getBigDecimal("verifyamount").divide(row.getBigDecimal("verifybaseqty"), 10, RoundingMode.HALF_UP));
            entryRow.set("e_verifytaxamount", (Object)row.getBigDecimal("e_verifyamount"));
            entryRow.set("e_exchangerate", (Object)row.getBigDecimal("e_exchangerate"));
            entryRow.set("e_basecurrency", (Object)row.getLong("e_currency"));
            entryRow.set("e_billid", (Object)row.getLong("e_billid"));
            entryRow.set("e_billentryid", (Object)row.getLong("e_billentryid"));
        }
        return record;
    }

    private DataSet createBizBillData() {
        DataSet purInBillDataSet = this.createPurInBillDataSet(this.easPurinEntryIds, "im_purinbill", this.purinBillMinDate, this.purinBillMaxDate, "id as billid,billno,billtype,exchangerate,currency,billentry.id as billentryid,billentry.id as conentryid,billentry.unit as unit,billentry.unit.precision as unitprecision,billentry.baseunit as baseunit,billentry.baseunit.precision as baseunitprecision,billentry.qty as qty,billentry.baseqty as baseqty,billentry.materialmasterid as material,billentry.invoicesupplier as asstact,billentry.curamountandtax as payableamount,currency.amtprecision as currencyamtprecision");
        DataSet osPurInBillDataSet = this.createPurInBillDataSet(this.easOsPurinEntryIds, "im_ospurinbill", this.osPurinBillMinDate, this.osPurinBillMaxDate, "id as billid,billno,billtype,exchangerate,currency,billentry.id as billentryid,billentry.id as conentryid,billentry.unit as unit,billentry.unit.precision as unitprecision,billentry.baseunit as baseunit,billentry.baseunit.precision as baseunitprecision,billentry.qty as qty,billentry.baseqty as baseqty,billentry.materialmasterid as material,billentry.invoicesupplier as asstact,billentry.curamountandtax as payableamount,currency.amtprecision as currencyamtprecision");
        DataSet salOutBillDataSet = this.createPurInBillDataSet(this.easSaloutEntryIds, "im_saloutbill", this.saloutBillMinDate, this.saloutBillMaxDate, "id as billid,billno,billtype,exchangerate,currency,billentry.id as billentryid,billentry.id as conentryid,billentry.unit as unit,billentry.unit.precision as unitprecision,billentry.baseunit as baseunit,billentry.baseunit.precision as baseunitprecision,billentry.qty as qty,billentry.baseqty as baseqty,billentry.materialmasterid as material,billentry.settlecustomer as asstact,billentry.curamountandtax as payableamount,currency.amtprecision as currencyamtprecision");
        DataSet apBillDataSet = this.createPurInBillDataSet(this.easApEntryIds, "ap_finapbill", this.apBillMinDate, this.apBillMaxDate, "id as billid,billno,billtypeid as billtype,exchangerate,basecurrency as currency,detailentry.id as billentryid,detailentry.id as conentryid,detailentry.measureunit as unit,detailentry.measureunit.precision as unitprecision,detailentry.e_baseunit as baseunit,detailentry.e_baseunit.precision as baseunitprecision,detailentry.quantity as qty,detailentry.e_baseunitqty as baseqty,detailentry.material as material,asstact,detailentry.e_pricetaxtotalbase as payableamount,basecurrency.amtprecision as currencyamtprecision");
        DataSet arBillDataSet = this.createPurInBillDataSet(this.easArEntryIds, "ar_revcfmbill", this.arBillMinDate, this.arBillMaxDate, "id as billid,billno,billtype,exchangerate,basecurrency as currency,entry.id as billentryid,entry.e_sourcebillentryid as conentryid,entry.e_measureunit as unit,entry.e_measureunit.precision as unitprecision,entry.e_baseunitid as baseunit,entry.e_baseunitid.precision as baseunitprecision,entry.e_quantity as qty,entry.e_baseunitqty as baseqty,entry.e_material as material,asstact,entry.e_pricetaxtotalbase as payableamount,basecurrency.amtprecision as currencyamtprecision");
        DataSet resDataSet = purInBillDataSet.union(new DataSet[]{osPurInBillDataSet, salOutBillDataSet, apBillDataSet, arBillDataSet});
        return resDataSet;
    }

    private DataSet createPurInBillDataSet(Set<String> easEntryIds, String entity, Date mindate, Date maxdate, String bizBillSelectFields) {
        DataSet bizBillDataSet;
        DataSet easIdChangeDataSet;
        ArrayList easIdChangeInputs = new ArrayList(4);
        Lists.partition(Arrays.asList(easEntryIds.toArray(new String[0])), (int)4500).forEach(list -> {
            QFilter filter = new QFilter("easentryid", "in", list);
            if (entity.equals("ar_revcfmbill")) {
                filter.and("conentity", "=", (Object)"ar_finarbill");
            } else {
                filter.and("conentity", "=", (Object)entity);
            }
            OrmInput input = new OrmInput(((Object)((Object)this)).getClass().getName(), "dmw_easidchange", "easentryid,conentryid,conparentid", filter.toArray());
            easIdChangeInputs.add(input);
        });
        if (easIdChangeInputs.isEmpty()) {
            RowMeta rowMeta = ORM.create().createRowMeta("dmw_easidchange", "easentryid,conentryid,conparentid");
            easIdChangeDataSet = Algo.create((String)((Object)((Object)this)).getClass().getName()).createDataSet(new ArrayList(16), rowMeta);
        } else {
            easIdChangeDataSet = Algo.create((String)((Object)((Object)this)).getClass().getName()).createDataSet(easIdChangeInputs.toArray(new Input[0]));
        }
        HashSet<Long> bizBillids = new HashSet<Long>(4);
        for (Row row : easIdChangeDataSet.copy()) {
            bizBillids.add(row.getLong("conparentid"));
        }
        ArrayList bizBillInputs = new ArrayList(4);
        Lists.partition(Arrays.asList(bizBillids.toArray(new Long[0])), (int)4500).forEach(list -> {
            QFilter filter = new QFilter("org", "in", this.orgIds);
            filter.and("bookdate", ">=", (Object)mindate);
            filter.and("bookdate", "<=", (Object)maxdate);
            if (entity.equals("ar_revcfmbill")) {
                filter.and("sourcebillid", "in", list);
                OrmInput input = new OrmInput(((Object)((Object)this)).getClass().getName(), "ar_revcfmbill", bizBillSelectFields, filter.toArray());
                bizBillInputs.add(input);
            } else {
                filter.and("id", "in", list);
                OrmInput input = new OrmInput(((Object)((Object)this)).getClass().getName(), entity, bizBillSelectFields, filter.toArray());
                bizBillInputs.add(input);
            }
        });
        if (bizBillInputs.isEmpty()) {
            RowMeta rowMeta = ORM.create().createRowMeta(entity, bizBillSelectFields);
            bizBillDataSet = Algo.create((String)((Object)((Object)this)).getClass().getName()).createDataSet(new ArrayList(16), rowMeta);
        } else {
            bizBillDataSet = Algo.create((String)((Object)((Object)this)).getClass().getName()).createDataSet(bizBillInputs.toArray(new Input[0]));
        }
        DataSet resDataSet = easIdChangeDataSet.join(bizBillDataSet, JoinType.INNER).on("conentryid", "conentryid").select(new String[]{"easentryid"}, bizBillDataSet.getRowMeta().getFieldNames()).finish();
        return resDataSet;
    }

    private void collectParamsFromWriteoffRecordTempData(DataSet copy) {
        for (Row row : copy) {
            Long FCOMPANYORGUNITID = row.getLong("FCOMPANYORGUNITID");
            this.orgIds.add(FCOMPANYORGUNITID);
            int FCALCULATEKIND = row.getInteger("FCALCULATEKIND");
            int FCREATETYPE = row.getInteger("FCREATETYPE");
            Date FBILLDATE = row.getDate("FBILLDATE");
            String FBILLENTRYID = row.getString("FBILLENTRYID");
            String FBILLTYPENUMBER = row.getString("FBILLTYPENUMBER");
            if (FCALCULATEKIND == 0) {
                if ("103".equals(FBILLTYPENUMBER)) {
                    if (EASWriteoffRecordConstant.PURWRITEOFF_CREATETYPE.contains(FCREATETYPE)) {
                        this.easPurinEntryIds.add(FBILLENTRYID);
                        if (this.purinBillMinDate == null || FBILLDATE != null && this.purinBillMinDate.getTime() > FBILLDATE.getTime()) {
                            this.purinBillMinDate = FBILLDATE;
                        }
                        if (this.purinBillMaxDate != null && (FBILLDATE == null || this.purinBillMaxDate.getTime() >= FBILLDATE.getTime())) continue;
                        this.purinBillMaxDate = FBILLDATE;
                        continue;
                    }
                    if (!EASWriteoffRecordConstant.OSPURWRITEOFF_CREATETYPE.contains(FCREATETYPE)) continue;
                    this.easOsPurinEntryIds.add(FBILLENTRYID);
                    if (this.osPurinBillMinDate == null || FBILLDATE != null && this.osPurinBillMinDate.getTime() > FBILLDATE.getTime()) {
                        this.osPurinBillMinDate = FBILLDATE;
                    }
                    if (this.osPurinBillMaxDate != null && (FBILLDATE == null || this.osPurinBillMaxDate.getTime() >= FBILLDATE.getTime())) continue;
                    this.osPurinBillMaxDate = FBILLDATE;
                    continue;
                }
                if (!"230".equals(FBILLTYPENUMBER)) continue;
                this.easApEntryIds.add(FBILLENTRYID);
                if (this.apBillMinDate == null || FBILLDATE != null && this.apBillMinDate.getTime() > FBILLDATE.getTime()) {
                    this.apBillMinDate = FBILLDATE;
                }
                if (this.apBillMaxDate != null && (FBILLDATE == null || this.apBillMaxDate.getTime() >= FBILLDATE.getTime())) continue;
                this.apBillMaxDate = FBILLDATE;
                continue;
            }
            if (FCALCULATEKIND != 1) continue;
            if ("102".equals(FBILLTYPENUMBER)) {
                this.easSaloutEntryIds.add(FBILLENTRYID);
                if (this.saloutBillMinDate == null || FBILLDATE != null && this.saloutBillMinDate.getTime() > FBILLDATE.getTime()) {
                    this.saloutBillMinDate = FBILLDATE;
                }
                if (this.saloutBillMaxDate != null && (FBILLDATE == null || this.saloutBillMaxDate.getTime() >= FBILLDATE.getTime())) continue;
                this.saloutBillMaxDate = FBILLDATE;
                continue;
            }
            if (!"330".equals(FBILLTYPENUMBER)) continue;
            this.easArEntryIds.add(FBILLENTRYID);
            if (this.arBillMinDate == null || FBILLDATE != null && this.arBillMinDate.getTime() > FBILLDATE.getTime()) {
                this.arBillMinDate = FBILLDATE;
            }
            if (this.arBillMaxDate != null && (FBILLDATE == null || this.arBillMaxDate.getTime() >= FBILLDATE.getTime())) continue;
            this.arBillMaxDate = FBILLDATE;
        }
    }

    private DataSet createWriteoffRecordTempData() {
        if (this.enddate == null) {
            DataSet dataSet = DB.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (DBRoute)CommonUtils.getCalDBRouteKey(), (String)SQL_WRITEOFFRECORD_TEMPDATE2, (Object[])new Date[]{this.begindate});
            return dataSet;
        }
        DataSet dataSet = DB.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (DBRoute)CommonUtils.getCalDBRouteKey(), (String)SQL_WRITEOFFRECORD_TEMPDATE1, (Object[])new Object[]{this.begindate, this.enddate});
        return dataSet;
    }
}

