/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.extsysupgrade.easwriteoffrecord;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;

public class EASWriteoffRecordVerifySeqHelper {
    private static final Log logger = LogFactory.getLog(EASWriteoffRecordVerifySeqHelper.class);
    private Map<Long, Integer> org2BatchSizeMap = new HashMap<Long, Integer>(4);
    private Map<Long, Map<String, Integer>> org2MidAid2SeqMap = new HashMap<Long, Map<String, Integer>>(4);
    private Map<Long, List<Integer>> org2ToBeUsedSeqsMap = new HashMap<Long, List<Integer>>(4);
    private String verifyRecordEntity = "";

    public EASWriteoffRecordVerifySeqHelper(String entity) {
        this.verifyRecordEntity = entity;
    }

    void setVerifySeq(DynamicObject verifyRecord) {
        Map<String, Integer> midAid2SeqMap;
        Long orgid = verifyRecord.getLong("org");
        Long mainBillid = verifyRecord.getLong("billid");
        DynamicObjectCollection entry = verifyRecord.getDynamicObjectCollection("entry");
        Long assBillid = 0L;
        if (entry != null && entry.size() > 0) {
            assBillid = ((DynamicObject)entry.iterator().next()).getLong("e_billid");
        }
        if ((midAid2SeqMap = this.org2MidAid2SeqMap.get(orgid)) == null) {
            midAid2SeqMap = new HashMap<String, Integer>(4);
            this.org2MidAid2SeqMap.put(orgid, midAid2SeqMap);
        }
        String wfnumber = verifyRecord.getString("wfnumber");
        String midAidKey = mainBillid + "#" + assBillid + "#" + wfnumber;
        Integer seq = midAid2SeqMap.get(midAidKey);
        if (seq == null) {
            seq = this.getSeq(orgid, verifyRecord);
            midAid2SeqMap.put(midAidKey, seq);
            logger.info("EASWriteoffRecordVerifySeqHelper.setVerifySeq:org{},seq{}", (Object)orgid, (Object)seq);
        }
        verifyRecord.set("verifyseq", (Object)seq);
    }

    private Integer getSeq(Long orgid, DynamicObject verifyRecord) {
        List<Integer> seqs = this.org2ToBeUsedSeqsMap.get(orgid);
        if (seqs == null) {
            seqs = new ArrayList<Integer>(10);
        }
        if (seqs.isEmpty()) {
            Integer batchSize = this.org2BatchSizeMap.get(orgid);
            if (batchSize == null) {
                batchSize = 2;
            } else if ((batchSize = Integer.valueOf(batchSize * 2)) >= 500) {
                batchSize = 500;
            }
            this.org2BatchSizeMap.put(orgid, batchSize);
            DynamicObject record = BusinessDataServiceHelper.newDynamicObject((String)this.verifyRecordEntity);
            record.set("org", verifyRecord.get("org"));
            long startTime = System.currentTimeMillis();
            String[] batchNumber = CodeRuleServiceHelper.getBatchNumber((String)this.verifyRecordEntity, (DynamicObject)record, (String)orgid.toString(), (int)batchSize);
            for (int i = batchNumber.length - 1; i >= 0; --i) {
                String billno = batchNumber[i];
                seqs.add(Integer.valueOf(billno));
            }
            this.org2ToBeUsedSeqsMap.put(orgid, seqs);
            logger.info("EASWriteoffRecordVerifySeqHelper.CodeRuleServiceHelper.getBatchNumber:org{},batchsize{},seqs{},cost{}s", new Object[]{orgid, batchSize, seqs, (System.currentTimeMillis() - startTime) / 1000L});
        }
        int tailIndex = seqs.size() - 1;
        Integer seq = seqs.remove(tailIndex);
        return seq;
    }
}

