/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.extsysupgrade.easwriteoffrecord;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import kd.bos.algo.Row;
import kd.fi.cal.business.extsysupgrade.easwriteoffrecord.EASWriteoffRecordConstant;

public class WriteOffBillRow {
    private Long unit = 0L;
    private Long baseunit = 0L;
    private BigDecimal exchangerate = BigDecimal.ONE;
    private Long currency = 0L;
    private int currencyAmtprecision = 2;
    private BigDecimal qty = BigDecimal.ZERO;
    private BigDecimal baseqty = BigDecimal.ZERO;
    private int unitprecision = 2;
    private int baseunitprecision = 2;
    private BigDecimal payableamount = BigDecimal.ZERO;
    private String entity = "";
    private Date FBILLDATE = null;
    private String billno = null;
    private Long material = null;
    private String asstacttype = null;
    private Long asstact = 0L;
    private Long billid = 0L;
    private Long billentryid = 0L;
    private BigDecimal curWriteoffBaseqty = BigDecimal.ZERO;
    private BigDecimal curWriteoffQty = BigDecimal.ZERO;
    private BigDecimal curWriteoffAmount = BigDecimal.ZERO;
    private boolean imPos = false;
    private boolean imNeg = false;
    private boolean aparPos = false;
    private boolean aparNeg = false;

    public WriteOffBillRow(Row row) {
        this.unit = row.getLong("unit");
        this.baseunit = row.getLong("baseunit");
        this.currency = row.getLong("currency");
        this.currencyAmtprecision = row.getInteger("currencyamtprecision");
        this.exchangerate = row.getBigDecimal("exchangerate");
        this.qty = row.getBigDecimal("qty");
        this.baseqty = row.getBigDecimal("baseqty");
        this.payableamount = row.getBigDecimal("payableamount");
        this.curWriteoffBaseqty = row.getBigDecimal("FCURRWRITTENOFFQTY");
        this.FBILLDATE = row.getDate("FBILLDATE");
        this.billno = row.getString("billno");
        this.material = row.getLong("material");
        this.unitprecision = row.getInteger("unitprecision");
        this.baseunitprecision = row.getInteger("baseunitprecision");
        this.asstact = row.getLong("asstact");
        this.billid = row.getLong("billid");
        this.billentryid = row.getLong("billentryid");
        this.curWriteoffAmount = row.getBigDecimal("FCURRWRITTENOFFAMOUNT");
        this.curWriteoffQty = this.curWriteoffBaseqty.multiply(this.qty).divide(this.baseqty, this.unitprecision, RoundingMode.HALF_UP);
        int FCALCULATEKIND = row.getInteger("FCALCULATEKIND");
        int FCREATETYPE = row.getInteger("FCREATETYPE");
        String FBILLTYPENUMBER = row.getString("FBILLTYPENUMBER");
        if (FCALCULATEKIND == 0) {
            if ("103".equals(FBILLTYPENUMBER)) {
                if (EASWriteoffRecordConstant.PURWRITEOFF_CREATETYPE.contains(FCREATETYPE)) {
                    this.entity = "im_purinbill";
                } else if (EASWriteoffRecordConstant.OSPURWRITEOFF_CREATETYPE.contains(FCREATETYPE)) {
                    this.entity = "im_ospurinbill";
                }
                if (this.curWriteoffBaseqty.signum() > 0) {
                    this.imPos = true;
                } else {
                    this.imNeg = true;
                }
            } else if ("230".equals(FBILLTYPENUMBER)) {
                this.entity = "ap_finapbill";
                if (this.curWriteoffBaseqty.signum() > 0) {
                    this.aparPos = true;
                } else {
                    this.aparNeg = true;
                }
            }
            this.asstacttype = "bd_supplier";
        } else if (FCALCULATEKIND == 1) {
            if ("102".equals(FBILLTYPENUMBER)) {
                this.entity = "im_saloutbill";
                if (this.curWriteoffBaseqty.signum() > 0) {
                    this.imPos = true;
                } else {
                    this.imNeg = true;
                }
            } else if ("330".equals(FBILLTYPENUMBER)) {
                this.entity = "ar_revcfmbill";
                if (this.curWriteoffBaseqty.signum() > 0) {
                    this.aparPos = true;
                } else {
                    this.aparNeg = true;
                }
            }
            this.asstacttype = "bd_customer";
        }
    }

    public boolean isImPos() {
        return this.imPos;
    }

    public boolean isImNeg() {
        return this.imNeg;
    }

    public boolean isAparPos() {
        return this.aparPos;
    }

    public boolean isAparNeg() {
        return this.aparNeg;
    }

    public Long getUnit() {
        return this.unit;
    }

    public Long getBaseunit() {
        return this.baseunit;
    }

    public BigDecimal getExchangerate() {
        return this.exchangerate;
    }

    public Long getCurrency() {
        return this.currency;
    }

    public int getCurrencyAmtprecision() {
        return this.currencyAmtprecision;
    }

    public BigDecimal getQty() {
        return this.qty;
    }

    public BigDecimal getBaseqty() {
        return this.baseqty;
    }

    public BigDecimal getPayableamount() {
        return this.payableamount;
    }

    public String getEntity() {
        return this.entity;
    }

    public Date getFBILLDATE() {
        return this.FBILLDATE;
    }

    public String getBillno() {
        return this.billno;
    }

    public Long getMaterial() {
        return this.material;
    }

    public BigDecimal getCurWriteoffBaseqty() {
        return this.curWriteoffBaseqty;
    }

    public void setCurWriteoffBaseqty(BigDecimal curWriteoffBaseqty) {
        this.curWriteoffBaseqty = curWriteoffBaseqty;
        this.curWriteoffQty = curWriteoffBaseqty.multiply(this.qty).divide(this.baseqty, this.unitprecision, RoundingMode.HALF_UP);
    }

    public int getUnitprecision() {
        return this.unitprecision;
    }

    public int getBaseunitprecision() {
        return this.baseunitprecision;
    }

    public BigDecimal getCurWriteoffQty() {
        return this.curWriteoffQty;
    }

    public BigDecimal getCurWriteoffAmount() {
        return this.curWriteoffAmount;
    }

    public void setCurWriteoffAmount(BigDecimal curWriteoffAmount) {
        this.curWriteoffAmount = curWriteoffAmount;
    }

    public String getAsstacttype() {
        return this.asstacttype;
    }

    public Long getAsstact() {
        return this.asstact;
    }

    public Long getBillid() {
        return this.billid;
    }

    public Long getBillentryid() {
        return this.billentryid;
    }
}

