/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.extsysupgrade.easwriteoffrecord.writeoffrecordstrategy;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import kd.fi.cal.business.extsysupgrade.easwriteoffrecord.EASWriteoffRecordConstant;
import kd.fi.cal.business.extsysupgrade.easwriteoffrecord.WriteOffBillRow;

public abstract class AbstractRecordStrategy {
    public static final int resRowLength = 44;
    List<WriteOffBillRow> mainRows;
    List<WriteOffBillRow> assRows;
    int fcalculatekind;
    int fcreatetype;
    String mainBillEntity;

    public AbstractRecordStrategy(List<WriteOffBillRow> mainRows, List<WriteOffBillRow> assRows, int fcalculatekind, int fcreatetype) {
        this.mainRows = mainRows;
        this.assRows = assRows;
        this.fcalculatekind = fcalculatekind;
        this.fcreatetype = fcreatetype;
        this.mainBillEntity = mainRows.get(0).getEntity();
    }

    public List<Object[]> create() {
        ArrayList<Object[]> resRows = new ArrayList<Object[]>(4);
        int mainSize = this.mainRows.size();
        int assSize = this.assRows.size();
        int i = 0;
        int j = 0;
        while (i < mainSize && j < assSize) {
            WriteOffBillRow mainRow = this.mainRows.get(i);
            WriteOffBillRow assRow = this.assRows.get(j);
            if (i == mainSize - 1) {
                resRows.addAll(this.createShareRows(mainRow, this.assRows, j, false));
                break;
            }
            if (j == assSize - 1) {
                resRows.addAll(this.createShareRows(assRow, this.mainRows, i, true));
                break;
            }
            resRows.add(this.calculateWriteOffQty(mainRow, assRow));
            if (mainRow.getCurWriteoffBaseqty().compareTo(BigDecimal.ZERO) == 0) {
                ++i;
            }
            if (assRow.getCurWriteoffBaseqty().compareTo(BigDecimal.ZERO) != 0) continue;
            ++j;
        }
        return resRows;
    }

    protected Object[] calculateWriteOffQty(WriteOffBillRow mainRow, WriteOffBillRow assRow) {
        Object[] resRow = new Object[44];
        BigDecimal mainWFBaseqty = this.calculateMainWriteOffQty(mainRow, assRow);
        BigDecimal assWFBaseqty = this.calculateAssWriteOffQty(mainRow, assRow);
        BigDecimal mainRemainWriteoffBaseqty = mainRow.getCurWriteoffBaseqty();
        BigDecimal mainRemainWriteoffAmount = mainRow.getCurWriteoffAmount();
        mainRow.setCurWriteoffBaseqty(mainWFBaseqty);
        BigDecimal mainCurWriteoffAmount = mainWFBaseqty.multiply(mainRemainWriteoffAmount).divide(mainRemainWriteoffBaseqty, mainRow.getCurrencyAmtprecision(), RoundingMode.HALF_UP);
        mainRow.setCurWriteoffAmount(mainCurWriteoffAmount);
        this.setMainBill(resRow, mainRow);
        mainRow.setCurWriteoffBaseqty(mainRemainWriteoffBaseqty.subtract(mainWFBaseqty));
        mainRow.setCurWriteoffAmount(mainRemainWriteoffAmount.subtract(mainCurWriteoffAmount));
        BigDecimal assRemainWriteoffBaseqty = assRow.getCurWriteoffBaseqty();
        BigDecimal assRemainWriteoffAmount = assRow.getCurWriteoffAmount();
        assRow.setCurWriteoffBaseqty(assWFBaseqty);
        BigDecimal assCurWriteoffAmount = assWFBaseqty.multiply(assRemainWriteoffAmount).divide(assRemainWriteoffBaseqty, assRow.getCurrencyAmtprecision(), RoundingMode.HALF_UP);
        assRow.setCurWriteoffAmount(assCurWriteoffAmount);
        this.setAssBill(resRow, assRow);
        assRow.setCurWriteoffBaseqty(assRemainWriteoffBaseqty.subtract(assWFBaseqty));
        assRow.setCurWriteoffAmount(assRemainWriteoffAmount.subtract(assCurWriteoffAmount));
        return resRow;
    }

    protected abstract BigDecimal calculateAssWriteOffQty(WriteOffBillRow var1, WriteOffBillRow var2);

    protected abstract BigDecimal calculateMainWriteOffQty(WriteOffBillRow var1, WriteOffBillRow var2);

    private List<Object[]> createShareRows(WriteOffBillRow singleRow, List<WriteOffBillRow> mulRows, int startIndex, boolean reverse) {
        BigDecimal sumWeight = BigDecimal.ZERO;
        ArrayList<Object[]> resRows = new ArrayList<Object[]>(4);
        for (int i = startIndex; i < mulRows.size(); ++i) {
            WriteOffBillRow writeOffBillRow = mulRows.get(i);
            BigDecimal curBaseqty = writeOffBillRow.getCurWriteoffBaseqty();
            sumWeight = sumWeight.add(curBaseqty);
            Object[] resRow = new Object[44];
            resRows.add(resRow);
            if (reverse) {
                this.setMainBill(resRow, writeOffBillRow);
                continue;
            }
            this.setAssBill(resRow, writeOffBillRow);
        }
        BigDecimal writeoffBaseqty = singleRow.getCurWriteoffBaseqty();
        BigDecimal writeoffAmount = singleRow.getCurWriteoffAmount();
        BigDecimal remainWriteoffBaseqty = singleRow.getCurWriteoffBaseqty();
        BigDecimal remainWriteoffAmount = singleRow.getCurWriteoffAmount();
        for (int i = startIndex; i < mulRows.size(); ++i) {
            WriteOffBillRow writeOffBillRow = mulRows.get(i);
            BigDecimal curWeight = writeOffBillRow.getCurWriteoffBaseqty();
            if (i == mulRows.size() - 1) {
                singleRow.setCurWriteoffBaseqty(remainWriteoffBaseqty);
                singleRow.setCurWriteoffAmount(remainWriteoffAmount);
            } else {
                BigDecimal curWriteOffBaseqty = curWeight.multiply(writeoffBaseqty).divide(sumWeight, singleRow.getBaseunitprecision(), RoundingMode.HALF_UP);
                singleRow.setCurWriteoffBaseqty(curWriteOffBaseqty);
                remainWriteoffBaseqty = remainWriteoffBaseqty.subtract(curWriteOffBaseqty);
                BigDecimal curWriteOffAmount = curWeight.multiply(writeoffAmount).divide(sumWeight, singleRow.getCurrencyAmtprecision(), RoundingMode.HALF_UP);
                singleRow.setCurWriteoffAmount(curWriteOffAmount);
                remainWriteoffAmount = remainWriteoffAmount.subtract(curWriteOffAmount);
            }
            Object[] resRow = (Object[])resRows.get(i - startIndex);
            if (reverse) {
                this.setAssBill(resRow, singleRow);
                continue;
            }
            this.setMainBill(resRow, singleRow);
        }
        return resRows;
    }

    protected void setAssBill(Object[] resRow, WriteOffBillRow writeOffBillRow) {
        int index = 26;
        resRow[index++] = writeOffBillRow.getEntity();
        resRow[index++] = writeOffBillRow.getBillno();
        resRow[index++] = writeOffBillRow.getFBILLDATE();
        resRow[index++] = writeOffBillRow.getAsstacttype();
        resRow[index++] = writeOffBillRow.getAsstact();
        resRow[index++] = writeOffBillRow.getCurrency();
        resRow[index++] = writeOffBillRow.getMaterial();
        resRow[index++] = writeOffBillRow.getUnit();
        resRow[index++] = writeOffBillRow.getBaseunit();
        resRow[index++] = writeOffBillRow.getQty();
        resRow[index++] = writeOffBillRow.getBaseqty();
        resRow[index++] = writeOffBillRow.getPayableamount();
        resRow[index++] = writeOffBillRow.getCurWriteoffQty();
        resRow[index++] = writeOffBillRow.getCurWriteoffBaseqty();
        resRow[index++] = writeOffBillRow.getCurWriteoffAmount();
        resRow[index++] = writeOffBillRow.getExchangerate();
        resRow[index++] = writeOffBillRow.getBillid();
        resRow[index++] = writeOffBillRow.getBillentryid();
    }

    protected void setMainBill(Object[] resRow, WriteOffBillRow writeOffBillRow) {
        resRow[6] = this.getVerifyRelation();
        resRow[7] = this.getVerifyRecordEntity();
        int index = 8;
        resRow[index++] = writeOffBillRow.getBillno();
        resRow[index++] = writeOffBillRow.getEntity();
        resRow[index++] = writeOffBillRow.getFBILLDATE();
        resRow[index++] = writeOffBillRow.getMaterial();
        resRow[index++] = writeOffBillRow.getUnit();
        resRow[index++] = writeOffBillRow.getBaseunit();
        resRow[index++] = writeOffBillRow.getQty();
        resRow[index++] = writeOffBillRow.getBaseqty();
        resRow[index++] = writeOffBillRow.getCurWriteoffQty();
        resRow[index++] = writeOffBillRow.getCurWriteoffBaseqty();
        resRow[index++] = writeOffBillRow.getAsstacttype();
        resRow[index++] = writeOffBillRow.getAsstact();
        resRow[index++] = writeOffBillRow.getCurrency();
        resRow[index++] = writeOffBillRow.getPayableamount();
        resRow[index++] = writeOffBillRow.getCurWriteoffAmount();
        resRow[index++] = writeOffBillRow.getBillid();
        resRow[index++] = writeOffBillRow.getBillentryid();
        resRow[index++] = writeOffBillRow.getExchangerate();
    }

    protected String getVerifyRecordEntity() {
        String verifyRecordEntity = null;
        if (this.fcalculatekind == 0 && (EASWriteoffRecordConstant.PURWRITEOFF_CREATETYPE.contains(this.fcreatetype) || EASWriteoffRecordConstant.OSPURWRITEOFF_CREATETYPE.contains(this.fcreatetype))) {
            verifyRecordEntity = "cal_purwfrecord";
        } else if (this.fcalculatekind == 1 && EASWriteoffRecordConstant.SALWRITEOFF_CREATETYPE.contains(this.fcreatetype)) {
            verifyRecordEntity = "cal_salwfrecord";
        }
        return verifyRecordEntity;
    }

    protected String getVerifyRelation() {
        String verifyrelation = null;
        if (EASWriteoffRecordConstant.PURWRITEOFF_CREATETYPE.contains(this.fcreatetype)) {
            verifyrelation = this.getPurVerifyRelation(this.mainBillEntity);
        } else if (EASWriteoffRecordConstant.OSPURWRITEOFF_CREATETYPE.contains(this.fcreatetype)) {
            verifyrelation = this.getOSPurVerifyRelation(this.mainBillEntity);
        } else if (EASWriteoffRecordConstant.SALWRITEOFF_CREATETYPE.contains(this.fcreatetype)) {
            verifyrelation = this.getSalVerifyRelation(this.mainBillEntity);
        }
        return verifyrelation;
    }

    protected abstract String getSalVerifyRelation(String var1);

    protected abstract String getOSPurVerifyRelation(String var1);

    protected abstract String getPurVerifyRelation(String var1);
}

