/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.extsysupgrade.easwriteoffrecord.writeoffrecordstrategy;

import java.util.ArrayList;
import java.util.List;
import kd.fi.cal.business.extsysupgrade.easwriteoffrecord.EASWriteoffRecordConstant;
import kd.fi.cal.business.extsysupgrade.easwriteoffrecord.WriteOffBillRow;

public class SingleBillRecordStrategy {
    public static final int resRowLength = 44;
    List<WriteOffBillRow> imPos;
    List<WriteOffBillRow> imNeg;
    List<WriteOffBillRow> aparPos;
    List<WriteOffBillRow> aparNeg;
    int fcalculatekind;
    int fcreatetype;

    public SingleBillRecordStrategy(List<WriteOffBillRow> imPos, List<WriteOffBillRow> imNeg, List<WriteOffBillRow> aparPos, List<WriteOffBillRow> aparNeg, int fcalculatekind, int fcreatetype) {
        this.imPos = imPos;
        this.imNeg = imNeg;
        this.aparPos = aparPos;
        this.aparNeg = aparNeg;
        this.fcalculatekind = fcalculatekind;
        this.fcreatetype = fcreatetype;
    }

    public List<Object[]> create() {
        ArrayList<Object[]> resRows = new ArrayList<Object[]>(4);
        resRows.addAll(this.createResRows(this.imPos));
        resRows.addAll(this.createResRows(this.imNeg));
        resRows.addAll(this.createResRows(this.aparPos));
        resRows.addAll(this.createResRows(this.aparNeg));
        return resRows;
    }

    private List<Object[]> createResRows(List<WriteOffBillRow> writeOffBillRows) {
        ArrayList<Object[]> resRows = new ArrayList<Object[]>(4);
        for (WriteOffBillRow writeOffBillRow : writeOffBillRows) {
            Object[] resRow = new Object[44];
            this.setMainBill(resRow, writeOffBillRow);
            resRows.add(resRow);
        }
        return resRows;
    }

    protected void setMainBill(Object[] resRow, WriteOffBillRow writeOffBillRow) {
        resRow[6] = this.getVerifyRelation(writeOffBillRow);
        resRow[7] = this.getVerifyRecordEntity();
        int index = 8;
        resRow[index++] = writeOffBillRow.getBillno();
        resRow[index++] = writeOffBillRow.getEntity();
        resRow[index++] = writeOffBillRow.getFBILLDATE();
        resRow[index++] = writeOffBillRow.getMaterial();
        resRow[index++] = writeOffBillRow.getUnit();
        resRow[index++] = writeOffBillRow.getBaseunit();
        resRow[index++] = writeOffBillRow.getQty();
        resRow[index++] = writeOffBillRow.getBaseqty();
        resRow[index++] = writeOffBillRow.getCurWriteoffQty();
        resRow[index++] = writeOffBillRow.getCurWriteoffBaseqty();
        resRow[index++] = writeOffBillRow.getAsstacttype();
        resRow[index++] = writeOffBillRow.getAsstact();
        resRow[index++] = writeOffBillRow.getCurrency();
        resRow[index++] = writeOffBillRow.getPayableamount();
        resRow[index++] = writeOffBillRow.getCurWriteoffAmount();
        resRow[index++] = writeOffBillRow.getBillid();
        resRow[index++] = writeOffBillRow.getBillentryid();
        resRow[index++] = writeOffBillRow.getExchangerate();
    }

    private String getVerifyRelation(WriteOffBillRow writeOffBillRow) {
        if ("im_purinbill".equals(writeOffBillRow.getEntity()) && writeOffBillRow.getCurWriteoffBaseqty().signum() > 0) {
            return "appurin";
        }
        if ("im_purinbill".equals(writeOffBillRow.getEntity()) && writeOffBillRow.getCurWriteoffBaseqty().signum() < 0) {
            return "appurreturn";
        }
        if ("im_ospurinbill".equals(writeOffBillRow.getEntity()) && writeOffBillRow.getCurWriteoffBaseqty().signum() > 0) {
            return "apomin";
        }
        if ("im_ospurinbill".equals(writeOffBillRow.getEntity()) && writeOffBillRow.getCurWriteoffBaseqty().signum() < 0) {
            return "apominreturn";
        }
        if ("im_saloutbill".equals(writeOffBillRow.getEntity()) && writeOffBillRow.getCurWriteoffBaseqty().signum() > 0) {
            return "arsalout";
        }
        if ("im_saloutbill".equals(writeOffBillRow.getEntity()) && writeOffBillRow.getCurWriteoffBaseqty().signum() < 0) {
            return "arsalreturn";
        }
        if ("ap_finapbill".equals(writeOffBillRow.getEntity())) {
            return "apfinself";
        }
        if ("ar_revcfmbill".equals(writeOffBillRow.getEntity())) {
            return "arfinself";
        }
        return null;
    }

    protected String getVerifyRecordEntity() {
        String verifyRecordEntity = null;
        if (this.fcalculatekind == 0 && (EASWriteoffRecordConstant.PURWRITEOFF_CREATETYPE.contains(this.fcreatetype) || EASWriteoffRecordConstant.OSPURWRITEOFF_CREATETYPE.contains(this.fcreatetype))) {
            verifyRecordEntity = "cal_purwfrecord";
        } else if (this.fcalculatekind == 1 && EASWriteoffRecordConstant.SALWRITEOFF_CREATETYPE.contains(this.fcreatetype)) {
            verifyRecordEntity = "cal_salwfrecord";
        }
        return verifyRecordEntity;
    }
}

