/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.process.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.Input;
import kd.bos.algo.Row;
import kd.bos.algo.input.OrmInput;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.extplugin.PluginProxy;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.xdb.hint.ShardingHintContext;
import kd.bos.xdb.sharding.sql.FilterType;
import kd.fi.cal.business.process.AbstractBizProcessor;
import kd.fi.cal.business.process.inner.OverWfAutoUnWfHelper;
import kd.fi.cal.common.enums.DischargeTypeEnum;
import kd.fi.cal.common.helper.IDGenerator;
import kd.fi.cal.common.helper.PeriodHelper;
import kd.fi.cal.common.helper.WhiteListHelper;
import kd.fi.cal.common.util.CommonUtils;
import kd.fi.cal.common.util.DynamicObjectUtils;
import kd.sdk.fi.cal.extpoint.writeoff.ICalWriteOffFilter;

public class AbstractWriteOffServiceProcess
extends AbstractBizProcessor {
    private static final Log logger = LogFactory.getLog(AbstractWriteOffServiceProcess.class);
    protected String writeOffSeq = "verifyseq";
    protected final String billtype = "billtype";
    protected final String vbillID = "billid";
    protected final String vbillNumber = "billno";
    protected final String vbillEntryID = "billentryid";
    protected final String verifybaseqty = "verifybaseqty";
    protected final String verifyamount = "verifyamount";
    protected final String assitVerifyBaseQty = "e_verifybaseqty";
    protected final String vbilldate = "billdate";
    protected final String vverifyrelation = "verifyrelation";
    protected final String vEntry = "entry";
    protected final String vapTypeValue = "e_billtype";
    protected final String vamount = "e_verifyamount";
    protected final String vqty = "e_verifybaseqty";
    protected final String vasstacttype = "e_asstacttype";
    protected final String vasstact = "e_asstact";
    protected final String vcurrency = "e_currency";
    protected final String vapBilldate = "e_billdate";
    protected final String vassBillIdKey = "e_billid";
    protected final String vassBillNoKey = "e_billno";
    protected Map<Long, DynamicObject> accountPeriod = new HashMap<Long, DynamicObject>(16);
    protected String lock_key = "cal_writeOff";
    protected Map<Long, Long> ancesBillIdWriteoffEndPeriodMap = new HashMap<Long, Long>(16);
    protected DynamicObject[] writeOffInfos;
    protected String actionName;
    protected Set<Long> bizBillIds = new HashSet<Long>(16);
    protected String calBillType = "IN";
    protected String verifytype = "";
    protected Map<Long, Date> wfid2DateMap = new HashMap<Long, Date>(4);
    private IDGenerator idGenerator = new IDGenerator("t_cal_calcostrecordentry");
    private static final String detailAddSql = "update t_cal_costrecord_detail set fbaseqty = fbaseqty + ?,factualcost = factualcost + ?,fstandardcost = fstandardcost + ? where fentryid = ? and fcostsubelementid = ?";
    private static final String entryAddSql = "update t_cal_calcostrecordentry set fbaseqty = fbaseqty + ?,fmaterialcost = fmaterialcost + ?,fprocesscost = fprocesscost + ?,fstandardcost = fstandardcost + ?,ffee = ffee + ?,flocaltax = flocaltax + ?,factualcost = factualcost + ?,fmanufacturecost = fmanufacturecost + ?,fresource = fresource + ? where fentryid = ?";
    protected List<Long> auditVoucherCostRecordIds = new ArrayList<Long>(16);
    protected Map<Long, Date> wfid2CalWriteoffDateMap = new HashMap<Long, Date>(4);

    protected DynamicObject[] getAllCostRecordByBizBillID(Long bizBillId, Set<Long> bizEntryIds) {
        DataSet dataSet;
        this.bizBillIds.add(bizBillId);
        String fields = this.getCostReorcdField();
        QFilter filter = new QFilter("bizbillid", "=", (Object)bizBillId);
        filter.and("entry.bizbillentryid", "in", bizEntryIds);
        QFilter billStatusf = new QFilter("billstatus", "=", (Object)"C");
        filter.and(billStatusf);
        filter.and(new QFilter("costaccount.enable", "=", (Object)Character.valueOf('1')));
        filter.and("calbilltype", "=", (Object)this.calBillType);
        filter.and("costaccount.accountcosttype", "!=", (Object)Character.valueOf('B'));
        PluginProxy pluginProxy = PluginProxy.create(null, ICalWriteOffFilter.class, (String)"FI_CAL_WRITEOFF_QFILTER", null);
        List ext_filters = pluginProxy.callReplace(p -> {
            QFilter q = p.getExtQfilter();
            return q;
        });
        if (ext_filters != null && !ext_filters.isEmpty()) {
            filter = filter.and((QFilter)ext_filters.get(0));
        }
        if ((dataSet = QueryServiceHelper.queryDataSet((String)"AbstractWriteOffServiceProcess_getAllCostRecordByBizBillID", (String)"cal_costrecord", (String)"id,writeoffstatus,costaccount,entry.ancestorbillid", (QFilter[])filter.toArray(), (String)"writeoffperiod asc")).isEmpty()) {
            this.addQueue();
            String msg = ResManager.loadKDString((String)"\u672a\u627e\u5230\u5df2\u5ba1\u6838\u7684\u6838\u7b97\u6210\u672c\u8bb0\u5f55\uff0c\u8bf7\u67e5\u770b\u6838\u7b97\u4e1a\u52a1\u5904\u7406\u65e5\u5fd7\u6216\u7a0d\u540e\u91cd\u65b0\u6267\u884c\u3002", (String)"AbstractWriteOffServiceProcess_0", (String)"fi-cal-business", (Object[])new Object[0]);
            throw new KDBizException(msg);
        }
        HashMap<Long, Long> idMap = new HashMap<Long, Long>();
        HashSet<Long> idSet = new HashSet<Long>(bizEntryIds.size());
        for (Row info : dataSet) {
            String writeOffStatus;
            long ancestorbillid = info.getLong("entry.ancestorbillid");
            if (ancestorbillid == 0L) {
                ancestorbillid = info.getLong("id");
            }
            if (!"B".equals(writeOffStatus = info.getString("writeoffstatus"))) continue;
            idMap.put(ancestorbillid, info.getLong("id"));
        }
        for (Long id : idMap.values()) {
            idSet.add(id);
        }
        if (idSet.isEmpty()) {
            new OverWfAutoUnWfHelper().autoUnWf(this.writeOffInfos);
            throw new KDBizException(new ErrorCode("5", ResManager.loadKDString((String)"\u4e1a\u52a1\u6570\u636e\u591a\u6838\u9500\uff0c\u8bf7\u68c0\u67e5\u6838\u9500\u8bb0\u5f55\u3002", (String)"AbstractWriteOffServiceProcess_2", (String)"fi-cal-business", (Object[])new Object[0])), new Object[0]);
        }
        DynamicObject[] costRecordArray = BusinessDataServiceHelper.load((String)"cal_costrecord", (String)fields, (QFilter[])new QFilter("id", "in", idSet).toArray(), (String)"costaccount.id");
        return costRecordArray;
    }

    protected String getCostReorcdField() {
        return this.getCostReorcdField(false);
    }

    protected String getCostReorcdField(boolean hasCostDetail) {
        String costRecordEntity = "cal_costrecord";
        if (hasCostDetail) {
            costRecordEntity = "cal_costrecord_subentity";
        }
        StringBuilder fields = new StringBuilder();
        MainEntityType calEntityType = EntityMetadataCache.getDataEntityType((String)costRecordEntity);
        Set selectorsSet = calEntityType.getAllFields().keySet();
        for (String o : selectorsSet) {
            fields.append(o).append(',');
        }
        fields.append("costaccount.calpolicy.convertmode,");
        fields.append("entry.seq,");
        fields.append("costaccount.calpolicy.exratetable,");
        fields.append("entry.subentryentity.id,entry.subentryentityest.id");
        return fields.toString();
    }

    protected void splitCostRecords(Long bizBillId, DynamicObject writeOffInfo) {
    }

    protected DynamicObject splitCostRecord(DynamicObject oldCostRecordInfo, Map<Long, DynamicObject> groupMap, boolean writeBack, boolean isRedBill, Map<String, Date> dateMap, Map<Long, Long> billIdMap) {
        long bBillId;
        this.checkWriteoffIsOver(oldCostRecordInfo, isRedBill, groupMap);
        long ancestorbillid = ((DynamicObject)oldCostRecordInfo.getDynamicObjectCollection("entry").get(0)).getLong("ancestorbillid");
        if (ancestorbillid == 0L) {
            ancestorbillid = oldCostRecordInfo.getLong("id");
        }
        long costAccountId = oldCostRecordInfo.getDynamicObject("costaccount").getLong("id");
        Date writeoffDate = null;
        if ("extsys".equals(this.verifytype)) {
            DynamicObjectCollection entry = oldCostRecordInfo.getDynamicObjectCollection("entry");
            for (DynamicObject entryRow : entry) {
                long bizbillentryid = entryRow.getLong("bizbillentryid");
                DynamicObject wfInfo = groupMap.get(bizbillentryid);
                if (wfInfo == null) continue;
                DynamicObject parent = (DynamicObject)wfInfo.getParent();
                writeoffDate = parent != null ? this.wfid2CalWriteoffDateMap.get(parent.getLong("id")) : this.wfid2CalWriteoffDateMap.get(wfInfo.getLong("id"));
                break;
            }
        } else if (isRedBill) {
            Long bizBillId = oldCostRecordInfo.getLong("bizbillid");
            Long mainBizBillId = billIdMap.get(bizBillId);
            String key = mainBizBillId + "_" + costAccountId;
            writeoffDate = dateMap.get(key);
        } else {
            writeoffDate = this.getWriteOffDate(oldCostRecordInfo, groupMap);
        }
        DynamicObject writeOffPeriod = this.getPeriod(writeoffDate, costAccountId);
        long writeOffPeriodId = writeOffPeriod.getLong("id");
        Long bizBillId = oldCostRecordInfo.getLong("bizbillid");
        this.bizBillIds.add(bizBillId);
        boolean isCostRecordChanged = false;
        if (oldCostRecordInfo.getDynamicObject("writeoffperiod").getLong("id") > writeOffPeriodId) {
            QFilter q = new QFilter("bizbillid", "=", (Object)bizBillId);
            q.and("writeoffperiod", "<=", (Object)writeOffPeriodId);
            q.and("writeoffstatus", "in", (Object)new String[]{"B"});
            q.and("costaccount", "=", (Object)costAccountId);
            q.and("calbilltype", "=", (Object)this.calBillType);
            QFilter q1 = new QFilter("entry.ancestorbillid", "=", (Object)ancestorbillid);
            q1.or("id", "=", (Object)ancestorbillid);
            q.and(q1);
            DynamicObject[] infos = BusinessDataServiceHelper.load((String)"cal_costrecord", (String)this.getCostReorcdField(), (QFilter[])q.toArray(), (String)"writeoffperiod desc");
            if (infos != null && infos.length > 0) {
                oldCostRecordInfo = infos[0];
                isCostRecordChanged = true;
            }
        }
        DynamicObject newRecordA = this.cloneCostRecord(oldCostRecordInfo);
        Date date = TimeServiceHelper.now();
        newRecordA.set("auditdate", (Object)date);
        newRecordA.set("isvoucher", (Object)false);
        newRecordA.set("issubbillinvoiceverify", (Object)false);
        newRecordA.set("issplit", (Object)false);
        newRecordA.set("ischargeoff", (Object)false);
        newRecordA.set("ischargeoffed", (Object)false);
        for (DynamicObject entry : newRecordA.getDynamicObjectCollection("entry")) {
            entry.getDynamicObjectCollection("subentryentity").clear();
            entry.getDynamicObjectCollection("subentryentityest").clear();
            entry.set("costpricesource", (Object)" ");
            entry.set("designatedcost", (Object)"0");
        }
        DynamicObject newRecordB = this.cloneCostRecord(newRecordA);
        newRecordA.set("writeoffstatus", (Object)"A");
        newRecordA.set("issplitcreate", (Object)true);
        newRecordA.set("writeoffdate", (Object)writeoffDate);
        newRecordA.set("writeoffperiod_id", (Object)writeOffPeriodId);
        int periodNumber = writeOffPeriod.getInt("periodyear") * 100 + writeOffPeriod.getInt("periodnumber");
        String srcBillNo = newRecordA.getString("billnumber");
        String billNo = this.getCostRecordABillNo(srcBillNo, bizBillId, writeOffPeriodId, costAccountId, periodNumber, ancestorbillid);
        newRecordA.set("billno", (Object)billNo);
        this.dealRecordA(newRecordA, groupMap, writeBack, isRedBill);
        QFilter q = new QFilter("writeoffperiod", "=", (Object)writeOffPeriodId);
        q.and("bizbillid", "=", (Object)bizBillId);
        q.and("writeoffstatus", "=", (Object)"A");
        q.and("costaccount", "=", (Object)costAccountId);
        q.and("entry.ancestorbillid", "=", (Object)ancestorbillid);
        boolean hasCurPeriodB = false;
        if (QueryServiceHelper.exists((String)"cal_costrecord", (QFilter[])q.toArray())) {
            q = new QFilter("writeoffperiod", "=", (Object)writeOffPeriodId);
            q.and("bizbillid", "=", (Object)bizBillId);
            q.and("writeoffstatus", "=", (Object)"B");
            q.and("costaccount", "=", (Object)costAccountId);
            q.and("calbilltype", "=", (Object)this.calBillType);
            q.and("entry.ancestorbillid", "=", (Object)ancestorbillid);
            try {
                newRecordB = BusinessDataServiceHelper.loadSingle((String)"cal_costrecord", (String)this.getCostReorcdField(), (QFilter[])q.toArray());
            }
            catch (Exception e) {
                new OverWfAutoUnWfHelper().autoUnWf(this.writeOffInfos);
                throw new KDBizException(new ErrorCode("5", ResManager.loadKDString((String)"\u4e1a\u52a1\u6570\u636e\u591a\u6838\u9500\uff0c\u8bf7\u68c0\u67e5\u6838\u9500\u8bb0\u5f55\u3002", (String)"AbstractWriteOffServiceProcess_2", (String)"fi-cal-business", (Object[])new Object[0])), new Object[0]);
            }
            if (newRecordB == null) {
                new OverWfAutoUnWfHelper().autoUnWf(this.writeOffInfos);
                throw new KDBizException(new ErrorCode("5", ResManager.loadKDString((String)"\u4e1a\u52a1\u6570\u636e\u591a\u6838\u9500\uff0c\u8bf7\u68c0\u67e5\u6838\u9500\u8bb0\u5f55\u3002", (String)"AbstractWriteOffServiceProcess_2", (String)"fi-cal-business", (Object[])new Object[0])), new Object[0]);
            }
            hasCurPeriodB = true;
            HashMap<Long, String> recordBMap = new HashMap<Long, String>(8);
            recordBMap.put(newRecordB.getLong("id"), newRecordB.getString("billno"));
            this.checkVoucher(recordBMap);
        }
        if (!hasCurPeriodB) {
            newRecordB.set("billno", (Object)(srcBillNo + "-B-" + periodNumber));
            newRecordB.set("issplitcreate", (Object)true);
            newRecordB.set("writeoffstatus", (Object)"B");
        }
        this.dealRecordB(newRecordA, newRecordB, groupMap, isRedBill);
        boolean isDeleteB = false;
        if (newRecordB.getDynamicObjectCollection("entry").size() == 0) {
            isDeleteB = true;
            Long writeoffPeriodId = newRecordA.getLong("writeoffperiod_id");
            DynamicObjectCollection entrys = oldCostRecordInfo.getDynamicObjectCollection("entry");
            long fatherBillId = oldCostRecordInfo.getLong("id");
            for (DynamicObject item : entrys) {
                Long ancestorBillId = item.getLong("ancestorbillid");
                if (ancestorBillId.equals(0L)) {
                    ancestorBillId = fatherBillId;
                }
                this.ancesBillIdWriteoffEndPeriodMap.put(ancestorBillId, writeoffPeriodId);
            }
        } else {
            newRecordB.set("writeoffperiod_id", newRecordA.get("writeoffperiod_id"));
            newRecordB.set("writeoffdate", newRecordA.get("writeoffdate"));
            for (DynamicObject entry : newRecordB.getDynamicObjectCollection("entry")) {
                entry.set("costpricesource", (Object)" ");
                entry.set("designatedcost", (Object)"0");
            }
        }
        if (!oldCostRecordInfo.getBoolean("issplitcreate")) {
            oldCostRecordInfo.set("issplit", (Object)true);
            if (oldCostRecordInfo.getDynamicObject("writeoffperiod").getLong("id") == writeOffPeriodId) {
                oldCostRecordInfo.set("writeoffstatus", (Object)" ");
            }
        }
        this.setABillVoucherFlag(newRecordA);
        if (!hasCurPeriodB) {
            this.setBBillVoucherFlag(newRecordB, newRecordA.getBoolean("istempvoucher"));
        }
        this.buildRelation(oldCostRecordInfo, newRecordA, newRecordB);
        this.saveCostRecordInfo(newRecordA);
        this.auditVoucherCostRecordIds.add((Long)newRecordA.getPkValue());
        if (isCostRecordChanged) {
            this.saveCostRecordInfo(oldCostRecordInfo);
        }
        DynamicObject delBDyc = null;
        if (isDeleteB) {
            delBDyc = newRecordB;
            newRecordB = null;
        } else {
            this.saveCostRecordInfo(newRecordB);
        }
        HashMap<String, DynamicObject> oldCostRecordDetailMap = new HashMap<String, DynamicObject>();
        HashMap<String, DynamicObject> costRecordADetailMap = new HashMap<String, DynamicObject>();
        this.dealSalOutCostRecordDetal(oldCostRecordInfo, newRecordA, oldCostRecordDetailMap, costRecordADetailMap);
        this.buildCostRecordBDetail(oldCostRecordDetailMap, costRecordADetailMap, newRecordB, !hasCurPeriodB);
        this.handleAfterCostRecordB(writeOffPeriodId, bizBillId, costAccountId, newRecordA, oldCostRecordInfo, groupMap, isRedBill, oldCostRecordDetailMap, costRecordADetailMap, ancestorbillid);
        if (isDeleteB && delBDyc != null && (bBillId = delBDyc.getLong("id")) != 0L) {
            QFilter idF = new QFilter("id", "=", (Object)bBillId);
            DeleteServiceHelper.delete((String)"cal_costrecord_subentity", (QFilter[])idF.toArray());
        }
        return newRecordA;
    }

    protected void checkVoucher(Map<Long, String> updateIdsMap) {
        Map<Long, List<String>> vouSourceMap = this.getVouSourceMap(updateIdsMap.keySet());
        for (Map.Entry<Long, String> entry : updateIdsMap.entrySet()) {
            Long recordID = entry.getKey();
            String billNo = entry.getValue();
            if (!this.hasVoucher(recordID, vouSourceMap)) continue;
            String msg = String.format(ResManager.loadKDString((String)"\u6838\u9500\u62c6\u5355\u751f\u6210\u7684\u6210\u672c\u8bb0\u5f55\u5df2\u751f\u6210\u51ed\u8bc1\u3002\u5355\u636e\u7f16\u53f7\u4e3a\uff1a%1$s", (String)"PurUnWriteOffServiceProcess_1", (String)"fi-cal-business", (Object[])new Object[0]), billNo);
            throw new KDBizException(msg);
        }
    }

    protected void dealSalOutCostRecordDetal(DynamicObject oldCostRecordInfo, DynamicObject newRecordA, Map<String, DynamicObject> oldCostRecordDetailMap, Map<String, DynamicObject> costRecordADetailMap) {
    }

    protected void buildCostRecordBDetail(Map<String, DynamicObject> oldCostRecordDetailMap, Map<String, DynamicObject> costRecordADetailMap, DynamicObject newRecordB, boolean isNewB) {
    }

    private void buildRelation(DynamicObject oldCostRecordInfo, DynamicObject newRecordA, DynamicObject newRecordB) {
        HashMap<Long, RelationIds> billRelationIds = new HashMap<Long, RelationIds>();
        DynamicObjectCollection entrys = oldCostRecordInfo.getDynamicObjectCollection("entry");
        long fatherBillId = oldCostRecordInfo.getLong("id");
        for (DynamicObject dynamic : entrys) {
            long fatherEntryId = dynamic.getLong("id");
            long bizbillEntryId = dynamic.getLong("bizbillentryid");
            long ancestorBillId = dynamic.getLong("ancestorbillid");
            long ancestorEntryId = dynamic.getLong("ancestorentryid");
            if (ancestorBillId == 0L) {
                ancestorBillId = fatherBillId;
            }
            if (ancestorEntryId == 0L) {
                ancestorEntryId = fatherEntryId;
            }
            RelationIds relationIds = new RelationIds();
            relationIds.setFatherBillid(fatherBillId);
            relationIds.setFatherEntryid(fatherEntryId);
            relationIds.setAncestorBillid(ancestorBillId);
            relationIds.setAncestorEntryid(ancestorEntryId);
            billRelationIds.put(bizbillEntryId, relationIds);
        }
        newRecordA = this.relationParent(newRecordA, billRelationIds);
        newRecordB = this.relationParent(newRecordB, billRelationIds);
    }

    private DynamicObject relationParent(DynamicObject newRecord, Map<Long, RelationIds> billRelationIds) {
        if (newRecord == null || billRelationIds.isEmpty()) {
            return newRecord;
        }
        DynamicObjectCollection entrys = newRecord.getDynamicObjectCollection("entry");
        for (DynamicObject entry : entrys) {
            long bizbillEntryId = entry.getLong("bizbillentryid");
            RelationIds relationIds = billRelationIds.get(bizbillEntryId);
            entry.set("ancestorbillid", (Object)relationIds.getAncestorBillid());
            entry.set("ancestorentryid", (Object)relationIds.getAncestorEntryid());
        }
        return newRecord;
    }

    protected void calculateEntry(DynamicObject oldEntryInfo, DynamicObject aEntry, DynamicObject bEntry, DynamicObject writeOffInvEntry) {
    }

    protected DynamicObject cloneCostRecord(DynamicObject oldCostRecordInfo) {
        DynamicObject newRecord = BusinessDataServiceHelper.newDynamicObject((String)this.getCostRecordEntity());
        DynamicObjectUtils.copy((DynamicObject)oldCostRecordInfo, (DynamicObject)newRecord);
        return newRecord;
    }

    protected void saveCostRecordInfo(DynamicObject costRecords) {
        if (costRecords == null) {
            return;
        }
        Object[] saveInfos = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{costRecords});
        this.createIepBusinesstask(saveInfos);
        logger.info("saveCostRecordInfo=" + costRecords.getPkValue() + "," + costRecords.getString("billno"));
    }

    protected void setABillVoucherFlag(DynamicObject newCostRecord) {
    }

    protected void setBBillVoucherFlag(DynamicObject newCostRecord, boolean istempVoucher) {
    }

    protected void dealRecordA(DynamicObject newRecordA, Map<Long, DynamicObject> groupMap, boolean writeBack, boolean isRedBill) {
    }

    protected DynamicObject getPeriod(Date writeOffDate, Long costAccountID) {
        return PeriodHelper.getPeriodByDate((Date)writeOffDate, (Long)costAccountID);
    }

    protected Date getWriteOffDate(DynamicObject newRecordA, Map<Long, DynamicObject> groupMap) {
        Date costRecordDate = newRecordA.getDate("bookdate");
        Date arapDate = this.getWriteOffAssistMaxDate(newRecordA, groupMap);
        long costAccountID = newRecordA.getLong("costaccount.id");
        String costAcctNum = newRecordA.getString("costaccount.number");
        Date firstDate = null;
        try {
            firstDate = PeriodHelper.getCurrentPeriod((Long)costAccountID).getDate("begindate");
        }
        catch (Exception e) {
            String acctPeriodMsg = ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u201c%1$s\u201d\u672a\u7ed3\u675f\u521d\u59cb\u5316\u3002", (String)"AbstractWriteOffServiceProcess_4", (String)"fi-cal-business", (Object[])new Object[0]);
            acctPeriodMsg = String.format(acctPeriodMsg, costAcctNum);
            throw new KDBizException(acctPeriodMsg);
        }
        Date maxDate = costRecordDate;
        if (arapDate != null && maxDate.before(arapDate)) {
            maxDate = arapDate;
        }
        if (maxDate.before(firstDate)) {
            maxDate = firstDate;
        }
        return maxDate;
    }

    private Date getWriteOffAssistMaxDate(DynamicObject newRecordA, Map<Long, DynamicObject> groupMap) {
        Date maxDate = null;
        DynamicObjectCollection coll = newRecordA.getDynamicObjectCollection("entry");
        Map<Long, Date> billIdBookDateMap = this.getBillIdBookDateMap(groupMap, coll);
        for (DynamicObject entry : coll) {
            DynamicObjectCollection entry1;
            DynamicObject writeOffInfo = groupMap.get(entry.getLong("bizbillentryid"));
            if (writeOffInfo == null || (entry1 = writeOffInfo.getDynamicObjectCollection("entry")) == null || entry1.isEmpty()) continue;
            for (DynamicObject writeOffEntry : entry1) {
                Long billId = writeOffEntry.getLong("e_billid");
                Date bookDate = billIdBookDateMap.get(billId);
                if (maxDate == null) {
                    maxDate = bookDate;
                    continue;
                }
                if (!maxDate.before(bookDate)) continue;
                maxDate = bookDate;
            }
        }
        return maxDate;
    }

    private Map<Long, Date> getBillIdBookDateMap(Map<Long, DynamicObject> groupMap, DynamicObjectCollection coll) {
        ArrayList<OrmInput> inputs = new ArrayList<OrmInput>(16);
        HashMap<String, Set> entityBillIdsMap = new HashMap<String, Set>(16);
        for (DynamicObject dynamicObject : coll) {
            DynamicObject writeOffInfo = groupMap.get(dynamicObject.getLong("bizbillentryid"));
            if (writeOffInfo == null) continue;
            String entryBillType = "";
            DynamicObjectCollection entry1 = writeOffInfo.getDynamicObjectCollection("entry");
            if (entry1 == null || entry1.isEmpty()) continue;
            for (DynamicObject writeOffEntry : entry1) {
                entryBillType = writeOffEntry.getString("e_billtype");
                Long billId = writeOffEntry.getLong("e_billid");
                Set billIds = entityBillIdsMap.computeIfAbsent(entryBillType, k -> new HashSet(16));
                billIds.add(billId);
            }
        }
        for (Map.Entry entry : entityBillIdsMap.entrySet()) {
            String entity = (String)entry.getKey();
            Set billIds = (Set)entry.getValue();
            QFilter billIdF = new QFilter("id", "in", (Object)billIds);
            OrmInput input = new OrmInput(((Object)((Object)this)).getClass().getName(), entity, "id,bookdate", billIdF.toArray());
            inputs.add(input);
        }
        DataSet assBillDs = Algo.create((String)((Object)((Object)this)).getClass().getName()).createDataSet(inputs.toArray(new Input[0]));
        HashMap<Long, Date> hashMap = new HashMap<Long, Date>(16);
        for (Row row : assBillDs) {
            hashMap.put(row.getLong("id"), row.getDate("bookdate"));
        }
        return hashMap;
    }

    protected void dealRecordB(DynamicObject newRecordA, DynamicObject newRecordB, Map<Long, DynamicObject> groupMap, boolean isRedBill) {
    }

    protected Long getCostTypeId(DynamicObject entity) {
        DynamicObject costTypeDynamic = entity.getDynamicObject("costaccount");
        long costTypeId = costTypeDynamic.getLong("costtype_id");
        return costTypeId;
    }

    public DBRoute getCalDBRouteKey() {
        return new DBRoute("cal");
    }

    public Set<Long> getAllAncestorBillId(List<Long> childIds) {
        if (childIds.isEmpty()) {
            return null;
        }
        QFilter idFilter = new QFilter("id", "in", childIds);
        DynamicObject[] ancestorIdRecords = BusinessDataServiceHelper.load((String)"cal_costrecord", (String)"entry.ancestorbillid", (QFilter[])new QFilter[]{idFilter});
        HashSet<Long> ancestorIds = new HashSet<Long>();
        for (DynamicObject record : ancestorIdRecords) {
            DynamicObjectCollection recordEntry = record.getDynamicObjectCollection("entry");
            if (recordEntry.size() <= 0) continue;
            ancestorIds.add(((DynamicObject)recordEntry.get(0)).getLong("ancestorbillid"));
        }
        ancestorIds.remove(0L);
        return ancestorIds;
    }

    public void writeBackAncestorBillVerifyField(Set<Long> ancestorIds, Set<Long> bizbillIds) {
        DynamicObject[] writeBackRecords;
        if (ancestorIds == null || ancestorIds.isEmpty()) {
            return;
        }
        QFilter isInvoiceFilter = new QFilter("entry.ancestorbillid", "in", ancestorIds);
        isInvoiceFilter.and("writeoffstatus", "=", (Object)"A");
        isInvoiceFilter.and("writeofftype", "=", (Object)"B");
        isInvoiceFilter.and("issplitcreate", "=", (Object)Character.valueOf('1'));
        isInvoiceFilter.and("bizbillid", "in", bizbillIds);
        isInvoiceFilter.and("ischargeoff", "=", (Object)Character.valueOf('0'));
        isInvoiceFilter.and("ischargeoffed", "=", (Object)Character.valueOf('0'));
        try (ShardingHintContext ctx = ShardingHintContext.create((String)"t_cal_calcostrecord", (ShardingHintContext.ShardingHintCondition[])new ShardingHintContext.ShardingHintCondition[]{new ShardingHintContext.ShardingHintCondition("fid", FilterType.in_range, ancestorIds)});){
            DynamicObject[] isInvoiceRecords;
            ctx.set();
            DynamicObject[] dynamicObjectArray = isInvoiceRecords = BusinessDataServiceHelper.load((String)"cal_costrecord", (String)"entry.ancestorbillid", (QFilter[])new QFilter[]{isInvoiceFilter});
            int n = dynamicObjectArray.length;
            for (int i = 0; i < n; ++i) {
                DynamicObject invoiceRecord = dynamicObjectArray[i];
                DynamicObjectCollection recordEntry = invoiceRecord.getDynamicObjectCollection("entry");
                if (recordEntry.size() <= 0) continue;
                ancestorIds.remove(((DynamicObject)recordEntry.get(0)).getLong("ancestorbillid"));
            }
        }
        QFilter writeBackIds = new QFilter("id", "in", ancestorIds);
        for (DynamicObject writeBackRecord : writeBackRecords = BusinessDataServiceHelper.load((String)"cal_costrecord", (String)"issubbillinvoiceverify", (QFilter[])new QFilter[]{writeBackIds})) {
            writeBackRecord.set("issubbillinvoiceverify", (Object)false);
        }
        SaveServiceHelper.save((DynamicObject[])writeBackRecords);
    }

    protected void createIepBusinesstask(Object[] saveInfos) {
        if (saveInfos == null || saveInfos.length == 0) {
            return;
        }
        ArrayList<Long> billIds = new ArrayList<Long>(saveInfos.length);
        for (Object saveInfo : saveInfos) {
            DynamicObject info = (DynamicObject)saveInfo;
            billIds.add(info.getLong("id"));
        }
        WhiteListHelper.writeWhiteList((String)"cal_costrecord_subentity", billIds);
    }

    protected void setWriteOffEndPeriod() {
        List<DynamicObject> allCostRecordDycs = this.getAllCostRecordDycs(this.ancesBillIdWriteoffEndPeriodMap.keySet(), this.bizBillIds);
        block0: for (DynamicObject costRecordDyc : allCostRecordDycs) {
            Long writeEndPeriod = this.ancesBillIdWriteoffEndPeriodMap.get(costRecordDyc.getLong("id"));
            if (writeEndPeriod != null) {
                costRecordDyc.set("writeoffendperiod", (Object)writeEndPeriod);
            }
            DynamicObjectCollection entryDycs = costRecordDyc.getDynamicObjectCollection("entry");
            for (DynamicObject entryDyc : entryDycs) {
                writeEndPeriod = this.ancesBillIdWriteoffEndPeriodMap.get(entryDyc.getLong("ancestorbillid"));
                if (writeEndPeriod == null) continue;
                costRecordDyc.set("writeoffendperiod", (Object)writeEndPeriod);
                continue block0;
            }
        }
        SaveServiceHelper.save((DynamicObject[])allCostRecordDycs.toArray(new DynamicObject[0]));
    }

    protected void clearWriteOffEndPeriod(Set<Long> ancestorIds, Set<Long> bizBillIds) {
        List<DynamicObject> allCostRecordDycs = this.getAllCostRecordDycs(ancestorIds, bizBillIds);
        for (DynamicObject costRecordDyc : allCostRecordDycs) {
            costRecordDyc.set("writeoffendperiod", (Object)0L);
        }
        SaveServiceHelper.save((DynamicObject[])allCostRecordDycs.toArray(new DynamicObject[0]));
    }

    protected void setFatherRecordUnWriteoff(Set<Long> ancestorIds, Set<Long> bizbillIds) {
        Object sql;
        Object row2;
        HashMap<Long, Long> writeOffPeriodMap = new HashMap<Long, Long>(ancestorIds.size());
        QFilter q = new QFilter("id", "in", ancestorIds);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_costrecord", (String)"id,writeoffperiod", (QFilter[])q.toArray(), null);){
            for (Object row2 : dataSet) {
                writeOffPeriodMap.put(row2.getLong("id"), row2.getLong("writeoffperiod"));
            }
        }
        q = new QFilter("entry.ancestorbillid", "in", ancestorIds);
        q.and("issplitcreate", "=", (Object)Boolean.TRUE);
        q.and("writeoffstatus", "in", (Object)new String[]{"A", "B"});
        q.and("bizbillid", "in", bizbillIds);
        HashSet<Long> hasCurPeriodChildSet = new HashSet<Long>(16);
        HashSet<Long> hasChildSet = new HashSet<Long>(16);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_costrecord", (String)"writeoffperiod,entry.ancestorbillid", (QFilter[])q.toArray(), null);
        row2 = null;
        try {
            for (Row row3 : dataSet) {
                if (row3.getLong("writeoffperiod").longValue() == ((Long)writeOffPeriodMap.get(row3.getLong("entry.ancestorbillid"))).longValue()) {
                    hasCurPeriodChildSet.add(row3.getLong("entry.ancestorbillid"));
                }
                hasChildSet.add(row3.getLong("entry.ancestorbillid"));
            }
        }
        catch (Throwable throwable) {
            row2 = throwable;
            throw throwable;
        }
        finally {
            if (dataSet != null) {
                if (row2 != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)row2).addSuppressed(throwable);
                    }
                } else {
                    dataSet.close();
                }
            }
        }
        ArrayList<Object[]> paramList = new ArrayList<Object[]>(16);
        for (Long id : ancestorIds) {
            if (hasCurPeriodChildSet.contains(id)) continue;
            paramList.add(new Object[]{id});
        }
        if (!paramList.isEmpty()) {
            sql = "update t_cal_calcostrecord set fwriteoffstatus = 'B' where fid = ?";
            DB.executeBatch((DBRoute)CommonUtils.getCalDBRouteKey(), (String)sql, paramList);
        }
        paramList.clear();
        for (Long id : ancestorIds) {
            if (hasChildSet.contains(id)) continue;
            paramList.add(new Object[]{id});
        }
        if (!paramList.isEmpty()) {
            sql = "update t_cal_calcostrecord set fissplit = '0' where fid = ?";
            DB.executeBatch((DBRoute)CommonUtils.getCalDBRouteKey(), (String)sql, paramList);
        }
    }

    private List<DynamicObject> getAllCostRecordDycs(Set<Long> ancestorIds, Set<Long> bizBillIds) {
        ArrayList<DynamicObject> allCostRecordDycs = new ArrayList<DynamicObject>(16);
        QFilter ancestBillIdf = new QFilter("entry.ancestorbillid", "in", ancestorIds);
        if (bizBillIds != null && !bizBillIds.isEmpty()) {
            ancestBillIdf.and("bizbillid", "in", bizBillIds);
        }
        DynamicObject[] subCostRecordDycs = BusinessDataServiceHelper.load((String)"cal_costrecord", (String)"id,writeoffendperiod,entry.ancestorbillid", (QFilter[])new QFilter[]{ancestBillIdf});
        allCostRecordDycs.addAll(Arrays.asList(subCostRecordDycs));
        QFilter idf = new QFilter("id", "in", ancestorIds);
        DynamicObject[] costRecordDycs = BusinessDataServiceHelper.load((String)"cal_costrecord", (String)"id,writeoffendperiod,entry.ancestorbillid", (QFilter[])new QFilter[]{idf});
        allCostRecordDycs.addAll(Arrays.asList(costRecordDycs));
        return allCostRecordDycs;
    }

    protected void deleteRecordB(Set<Long> ancestorIds, Set<Long> bizbillIds) {
        QFilter qb = new QFilter("entry.ancestorbillid", "in", ancestorIds);
        qb.and("issplitcreate", "=", (Object)Boolean.TRUE);
        qb.and("writeoffstatus", "=", (Object)"B");
        qb.and("bizbillid", "in", bizbillIds);
        QFilter qa = new QFilter("entry.ancestorbillid", "in", ancestorIds);
        qa.and("issplitcreate", "=", (Object)Boolean.TRUE);
        qa.and("writeoffstatus", "=", (Object)"A");
        qa.and("bizbillid", "in", bizbillIds);
        try (DataSet dataSetB = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_costrecord", (String)"id,writeoffperiod,bizbillid,costaccount", (QFilter[])qb.toArray(), null);
             DataSet dataSetA = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_costrecord", (String)"id,writeoffperiod,bizbillid,costaccount", (QFilter[])qa.toArray(), null);
             DataSet joinSet = dataSetB.leftJoin(dataSetA).on("writeoffperiod", "writeoffperiod").on("bizbillid", "bizbillid").on("costaccount", "costaccount").select(new String[]{"id as bid"}, new String[]{"id as aid"}).finish();){
            HashSet<Long> delbid = new HashSet<Long>();
            for (Row row : joinSet) {
                Long aid = row.getLong("aid");
                if (aid != null) continue;
                delbid.add(row.getLong("bid"));
            }
            if (!delbid.isEmpty()) {
                QFilter filter = new QFilter("id", "in", delbid);
                DeleteServiceHelper.delete((String)"cal_costrecord_subentity", (QFilter[])filter.toArray());
            }
        }
    }

    protected void addNewRecordB(DynamicObject[] costRecords, Set<Long> noWriteChildEntryIds) {
        Object afterAPeriodDateMap;
        this.sortCostRecdDycsWriteOffPeriodAsc(costRecords);
        HashMap<Long, Map> ancIdAfterAPeriodDateMap = new HashMap<Long, Map>(16);
        HashSet<Long> ancestorIds = new HashSet<Long>(16);
        HashSet<Long> bizBillIds = new HashSet<Long>(16);
        HashSet<Long> acctIds = new HashSet<Long>(16);
        Long minWriteOffPeriod = 0L;
        for (DynamicObject infoA : costRecords) {
            Long ancId = ((DynamicObject)infoA.getDynamicObjectCollection("entry").get(0)).getLong("ancestorbillid");
            Long bizBillId = infoA.getLong("bizbillid");
            Long writeOffPeriod = infoA.getDynamicObject("writeoffperiod").getLong("id");
            Long costAccountId = infoA.getDynamicObject("costaccount").getLong("id");
            ancestorIds.add(ancId);
            bizBillIds.add(bizBillId);
            if (minWriteOffPeriod == 0L || minWriteOffPeriod.compareTo(writeOffPeriod) > 0) {
                minWriteOffPeriod = writeOffPeriod;
            }
            acctIds.add(costAccountId);
        }
        QFilter afterAFilter = new QFilter("writeoffperiod", ">=", (Object)minWriteOffPeriod);
        afterAFilter.and("bizbillid", "in", bizBillIds);
        afterAFilter.and("costaccount", "in", acctIds);
        afterAFilter.and("writeoffstatus", "=", (Object)"A");
        afterAFilter.and("issplitcreate", "=", (Object)Boolean.TRUE);
        afterAFilter.and("entry.ancestorbillid", "in", ancestorIds);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_costrecord", (String)"writeoffperiod,writeoffdate,entry.ancestorbillid ancestorbillid", (QFilter[])afterAFilter.toArray(), (String)"writeoffdate asc");){
            for (Row row : dataSet) {
                afterAPeriodDateMap = ancIdAfterAPeriodDateMap.computeIfAbsent(row.getLong("ancestorbillid"), k -> new HashMap(16));
                afterAPeriodDateMap.put(row.getLong("writeoffperiod"), row.getDate("writeoffdate"));
            }
        }
        IDGenerator idGenerator = new IDGenerator("t_cal_calcostrecord");
        HashSet<Long> existBIds = new HashSet<Long>(16);
        QFilter afterBFilter = new QFilter("writeoffperiod", ">=", (Object)minWriteOffPeriod);
        afterBFilter.and("bizbillid", "in", bizBillIds);
        afterBFilter.and("costaccount", "in", acctIds);
        afterBFilter.and("writeoffstatus", "=", (Object)"B");
        afterBFilter.and("issplitcreate", "=", (Object)Boolean.TRUE);
        afterBFilter.and("calbilltype", "=", (Object)this.calBillType);
        afterBFilter.and("entry.ancestorbillid", "in", ancestorIds);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_costrecord", (String)"id,writeoffperiod,entry.ancestorbillid ancestorbillid", (QFilter[])afterBFilter.toArray(), null);
        afterAPeriodDateMap = null;
        try {
            for (DynamicObject[] row : dataSet) {
                Long bAncestorBillId = row.getLong("ancestorbillid");
                Long bWriteOffPeriodId = row.getLong("writeoffperiod");
                Map afterAPeriodDateMap2 = (Map)ancIdAfterAPeriodDateMap.get(bAncestorBillId);
                afterAPeriodDateMap2 = afterAPeriodDateMap2 == null ? new HashMap(16) : afterAPeriodDateMap2;
                if (!afterAPeriodDateMap2.containsKey(bWriteOffPeriodId)) continue;
                afterAPeriodDateMap2.remove(bWriteOffPeriodId);
                existBIds.add(row.getLong("id"));
            }
        }
        catch (Throwable writeOffPeriod) {
            afterAPeriodDateMap = writeOffPeriod;
            throw writeOffPeriod;
        }
        finally {
            if (dataSet != null) {
                if (afterAPeriodDateMap != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable writeOffPeriod) {
                        ((Throwable)afterAPeriodDateMap).addSuppressed(writeOffPeriod);
                    }
                } else {
                    dataSet.close();
                }
            }
        }
        boolean hasDetail = this.getCostRecordEntity().equals("cal_costrecord_subentity");
        DynamicObject[] existBInfos = BusinessDataServiceHelper.load((String)this.getCostRecordEntity(), (String)this.getCostReorcdField(hasDetail), (QFilter[])new QFilter("id", "in", existBIds).toArray());
        HashMap<Long, List> existAncIdBDycsMap = new HashMap<Long, List>(16);
        for (DynamicObject existBInfo : existBInfos) {
            Long ancId = ((DynamicObject)existBInfo.getDynamicObjectCollection("entry").get(0)).getLong("ancestorbillid");
            List existBDycs = existAncIdBDycsMap.computeIfAbsent(ancId, k -> new ArrayList(16));
            existBDycs.add(existBInfo);
        }
        HashSet<Long> addNewEntryBIds = new HashSet<Long>(16);
        HashMap<Long, Long> needAddEntryA2BIdMap = new HashMap<Long, Long>(4);
        ArrayList<Object[]> entryAddParamList = new ArrayList<Object[]>(4);
        if (!ancIdAfterAPeriodDateMap.isEmpty()) {
            HashSet afterAPeriodIds = new HashSet(16);
            for (Map periodDateMap : ancIdAfterAPeriodDateMap.values()) {
                afterAPeriodIds.addAll(periodDateMap.keySet());
            }
            HashMap<Long, Integer> periodNumberMap = new HashMap<Long, Integer>(16);
            try (DataSet dataSet2 = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bd_period", (String)"id,periodyear,periodnumber", (QFilter[])new QFilter("id", "in", afterAPeriodIds).toArray(), null);){
                for (Row row : dataSet2) {
                    int period = row.getInteger("periodyear") * 100 + row.getInteger("periodnumber");
                    periodNumberMap.put(row.getLong("id"), period);
                }
            }
            HashSet<DynamicObject> newInfoBs = new HashSet<DynamicObject>(16);
            HashMap<Long, List> newBAncIdDycsMap = new HashMap<Long, List>(16);
            for (DynamicObject infoA : costRecords) {
                Long ancId = ((DynamicObject)infoA.getDynamicObjectCollection("entry").get(0)).getLong("ancestorbillid");
                Map afterAPeriodDateMap3 = (Map)ancIdAfterAPeriodDateMap.get(ancId);
                afterAPeriodDateMap3 = afterAPeriodDateMap3 == null ? new HashMap(16) : afterAPeriodDateMap3;
                long aWriteOffPeriod = infoA.getLong("writeoffperiod_id");
                for (Map.Entry afterAPeriodDateEnt : afterAPeriodDateMap3.entrySet()) {
                    Object entryA2;
                    Long afterANoBPeriod = (Long)afterAPeriodDateEnt.getKey();
                    if (aWriteOffPeriod > afterANoBPeriod) continue;
                    DynamicObject infoB = this.cloneCostRecord(infoA);
                    for (Object entryA2 : infoA.getDynamicObjectCollection("entry")) {
                        noWriteChildEntryIds.remove(entryA2.getLong("id"));
                    }
                    infoB.set("writeoffperiod_id", (Object)afterANoBPeriod);
                    infoB.set("writeoffdate", afterAPeriodDateEnt.getValue());
                    infoB.set("writeoffstatus", (Object)"B");
                    infoB.set("writeofftype", null);
                    String srcBillNo = infoA.getString("billno").split("-A")[0];
                    infoB.set("billno", (Object)(srcBillNo + "-B-" + periodNumberMap.get(afterANoBPeriod)));
                    newInfoBs.add(infoB);
                    infoB.set("id", (Object)idGenerator.getId());
                    entryA2 = infoB.getDynamicObjectCollection("entry").iterator();
                    while (entryA2.hasNext()) {
                        DynamicObject entry = (DynamicObject)entryA2.next();
                        entry.set("id", (Object)idGenerator.getId());
                    }
                    afterAPeriodDateMap3.remove(afterANoBPeriod);
                    existBIds.add(infoB.getLong("id"));
                    List newBDycs = newBAncIdDycsMap.computeIfAbsent(ancId, k -> new ArrayList(16));
                    newBDycs.add(infoB);
                }
                List existBDycs = (List)existAncIdBDycsMap.get(ancId);
                this.addNewRecordBEntry(existBDycs, infoA, noWriteChildEntryIds, addNewEntryBIds, needAddEntryA2BIdMap, entryAddParamList);
                List newBDycs = (List)newBAncIdDycsMap.get(ancId);
                this.addNewRecordBEntry(newBDycs, infoA, noWriteChildEntryIds, addNewEntryBIds, needAddEntryA2BIdMap, entryAddParamList);
            }
            if (!newInfoBs.isEmpty()) {
                SaveServiceHelper.save((DynamicObject[])newInfoBs.toArray(new DynamicObject[0]));
            }
        }
        if (existBInfos.length > 0) {
            SaveServiceHelper.save((DynamicObject[])existBInfos);
        }
        if (!entryAddParamList.isEmpty()) {
            DB.executeBatch((DBRoute)CommonUtils.getCalDBRouteKey(), (String)entryAddSql, entryAddParamList);
        }
        if (!needAddEntryA2BIdMap.isEmpty()) {
            ArrayList<Object[]> detailAddParamList = new ArrayList<Object[]>(4);
            DataSet dataSet3 = QueryServiceHelper.queryDataSet((String)"AbstractWriteOffServiceProcess_addNewRecordB", (String)"cal_costrecord_detail", (String)"id,entryid,costsubelement,actualcost,unitactualcost,baseqty,standardcost,unitstandardcost", (QFilter[])new QFilter("entryid", "in", needAddEntryA2BIdMap.keySet()).toArray(), null);
            for (Row info : dataSet3) {
                detailAddParamList.add(new Object[]{info.getBigDecimal("baseqty"), info.getBigDecimal("actualcost"), info.getBigDecimal("standardcost"), needAddEntryA2BIdMap.get(info.getLong("entryid")), info.getLong("costsubelement")});
            }
            if (!detailAddParamList.isEmpty()) {
                DB.executeBatch((DBRoute)CommonUtils.getCalDBRouteKey(), (String)detailAddSql, detailAddParamList);
            }
        }
    }

    private void sortCostRecdDycsWriteOffPeriodAsc(DynamicObject[] costRecords) {
        Arrays.sort(costRecords, new Comparator<DynamicObject>(){

            @Override
            public int compare(DynamicObject o1, DynamicObject o2) {
                if (o1.getLong("writeoffperiod_id") < o2.getLong("writeoffperiod_id")) {
                    return -1;
                }
                if (o1.getLong("writeoffperiod_id") > o2.getLong("writeoffperiod_id")) {
                    return 1;
                }
                return 0;
            }
        });
    }

    private void addNewRecordBEntry(List<DynamicObject> existBDycs, DynamicObject infoA, Set<Long> noWriteChildEntryIds, Set<Long> addNewEntryBIds, Map<Long, Long> needAddEntryA2BIdMap, List<Object[]> entryAddParamList) {
        if (existBDycs != null && !existBDycs.isEmpty()) {
            HashSet<DynamicObject> infoBs = new HashSet<DynamicObject>(16);
            DynamicObjectCollection entryAs = infoA.getDynamicObjectCollection("entry");
            long aWriteOffPeriod = infoA.getLong("writeoffperiod_id");
            for (DynamicObject infoB : existBDycs) {
                long bWriteOffPeriod = infoB.getLong("writeoffperiod_id");
                if (bWriteOffPeriod < aWriteOffPeriod) continue;
                boolean needSave = false;
                DynamicObjectCollection entryBs = infoB.getDynamicObjectCollection("entry");
                for (DynamicObject entryA : entryAs) {
                    boolean hasA = false;
                    for (DynamicObject entryB : entryBs) {
                        if (entryB.getLong("ancestorentryid") != entryA.getLong("ancestorentryid")) continue;
                        if (addNewEntryBIds.contains(entryB.getLong("id"))) {
                            needAddEntryA2BIdMap.put(entryA.getLong("id"), entryB.getLong("id"));
                            this.buildEntryBAddParams(entryA, entryAddParamList, entryB.getLong("id"));
                            noWriteChildEntryIds.remove(entryA.getLong("id"));
                        }
                        hasA = true;
                        break;
                    }
                    if (hasA) continue;
                    DynamicObject newEntry = entryBs.addNew();
                    DynamicObjectUtils.copy((DynamicObject)entryA, (DynamicObject)newEntry);
                    Long entryid = this.idGenerator.getId();
                    newEntry.set("id", (Object)entryid);
                    addNewEntryBIds.add(entryid);
                    needSave = true;
                    noWriteChildEntryIds.remove(entryA.getLong("id"));
                }
                if (!needSave) continue;
                infoBs.add(infoB);
            }
            if (!infoBs.isEmpty()) {
                HashMap<Long, String> recordBMap = new HashMap<Long, String>(16);
                for (DynamicObject info : infoBs) {
                    recordBMap.put(info.getLong("id"), info.getString("billno"));
                }
                this.checkVoucher(recordBMap);
            }
        }
    }

    private void buildEntryBAddParams(DynamicObject entryA, List<Object[]> entryParamList, long entryBid) {
        entryParamList.add(new Object[]{entryA.getBigDecimal("baseqty"), entryA.getBigDecimal("materialcost"), entryA.getBigDecimal("processcost"), entryA.getBigDecimal("standardcost"), entryA.getBigDecimal("fee"), entryA.getBigDecimal("localtax"), entryA.getBigDecimal("actualcost"), entryA.getBigDecimal("manufacturecost"), entryA.getBigDecimal("resource"), entryBid});
    }

    protected String getCostRecordEntity() {
        return "cal_costrecord";
    }

    protected void checkUnWriteOff(DynamicObject[] costRecords, ArrayList<Long> childIds, ArrayList<Long> childEntryIds, Set<Long> bizbillIds) {
        CharSequence msg;
        boolean hasVoucher = false;
        boolean lessCurrentPeriod = false;
        if (costRecords == null) {
            return;
        }
        int cSize = costRecords.length;
        HashSet<String> voucherbillNumber = new HashSet<String>(cSize);
        HashSet<String> periodbillNumber = new HashSet<String>(cSize);
        HashSet<Long> idSet = new HashSet<Long>(cSize);
        HashSet<Long> costAccountIdSet = new HashSet<Long>(16);
        for (DynamicObject record : costRecords) {
            idSet.add(record.getLong("id"));
            costAccountIdSet.add(record.getLong("costaccount.id"));
        }
        Map curPeriodMap = PeriodHelper.getCurrentPeriods(costAccountIdSet);
        Map<Long, List<String>> vouSourceMap = this.getVouSourceMap(idSet);
        for (DynamicObject record : costRecords) {
            childIds.add(record.getLong("id"));
            bizbillIds.add(record.getLong("bizbillid"));
            DynamicObjectCollection entrys = record.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entrys) {
                childEntryIds.add(entry.getLong("id"));
            }
            if (!hasVoucher) {
                hasVoucher = this.hasVoucher(record, vouSourceMap);
            }
            if (!lessCurrentPeriod) {
                lessCurrentPeriod = this.lessCurrentPeriod(record, curPeriodMap);
            }
            if (hasVoucher) {
                voucherbillNumber.add(record.getString("billno"));
            }
            if (!lessCurrentPeriod) continue;
            periodbillNumber.add(record.getString("billno"));
        }
        if (hasVoucher) {
            msg = String.format(ResManager.loadKDString((String)"\u6838\u9500\u62c6\u5355\u751f\u6210\u7684\u6210\u672c\u8bb0\u5f55\u5df2\u751f\u6210\u51ed\u8bc1\u3002\u5355\u636e\u7f16\u53f7\u4e3a\uff1a%1$s", (String)"PurUnWriteOffServiceProcess_1", (String)"fi-cal-business", (Object[])new Object[0]), voucherbillNumber);
            throw new KDBizException((String)msg);
        }
        if (lessCurrentPeriod) {
            msg = new StringBuffer();
            ((StringBuffer)msg).append(ResManager.loadKDString((String)"\u53cd\u6838\u9500\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\u4e3a\uff1a\u6838\u9500\u62c6\u5355\u751f\u6210\u7684\u6210\u672c\u8bb0\u5f55\u7684\u671f\u95f4\u6216\u6838\u9500\u65e5\u671f\u4e3a\u5f80\u671f\u3002\u5355\u636e\u7f16\u53f7", (String)"PurUnWriteOffServiceProcess_2", (String)"fi-cal-business", (Object[])new Object[0])).append(periodbillNumber);
            throw new KDBizException(((StringBuffer)msg).toString());
        }
    }

    protected boolean hasVoucher(DynamicObject record, Map<Long, List<String>> vouSourceMap) {
        long recordID = record.getLong("id");
        return this.hasVoucher(recordID, vouSourceMap);
    }

    protected boolean hasVoucher(Long recordID, Map<Long, List<String>> vouSourceMap) {
        List<String> voucherSources = vouSourceMap.get(recordID);
        if (voucherSources == null) {
            return false;
        }
        for (String vouchersource : voucherSources) {
            if (!"A".equals(vouchersource) && !"B".equals(vouchersource)) continue;
            return true;
        }
        return false;
    }

    protected boolean lessCurrentPeriod(DynamicObject record, Map<Long, DynamicObject> curPeriodMap) {
        long costAccountID = record.getLong("costaccount.id");
        Date witeOffDate = record.getDate("writeoffdate");
        DynamicObject curPeriod = curPeriodMap.get(costAccountID);
        if (curPeriod == null) {
            return false;
        }
        Date currentPeriodDate = curPeriod.getDate("begindate");
        return witeOffDate.compareTo(currentPeriodDate) < 0;
    }

    protected Map<Long, List<String>> getVouSourceMap(Set<Long> idSet) {
        HashMap<Long, List<String>> vouSourceMap = new HashMap<Long, List<String>>(idSet.size());
        QFilter filter = new QFilter("costrecordid", "in", idSet);
        DynamicObjectCollection coll = QueryServiceHelper.query((String)"cal_voucher", (String)"costrecordid,vouchersource", (QFilter[])new QFilter[]{filter});
        for (DynamicObject info : coll) {
            ArrayList<String> list = (ArrayList<String>)vouSourceMap.get(info.getLong("costrecordid"));
            if (list == null) {
                list = new ArrayList<String>(16);
                vouSourceMap.put(info.getLong("costrecordid"), list);
            }
            list.add(info.getString("vouchersource"));
        }
        return vouSourceMap;
    }

    private String getCostRecordABillNo(String srcBillNo, Long bizBillId, Long writeOffPeriodId, Long costAccountId, int periodNumber, Long ancestorbillid) {
        String sn = "001";
        QFilter filters = new QFilter("bizbillid", "=", (Object)bizBillId);
        filters.and("writeoffperiod", "=", (Object)writeOffPeriodId);
        filters.and("writeoffstatus", "=", (Object)"A");
        filters.and("costaccount", "=", (Object)costAccountId);
        filters.and("ischargeoff", "=", (Object)Boolean.FALSE);
        filters.and("entry.ancestorbillid", "=", (Object)ancestorbillid);
        DynamicObjectCollection maxBillNoAinfos = QueryServiceHelper.query((String)"cal_costrecord", (String)"billno", (QFilter[])filters.toArray(), (String)"billno desc", (int)1);
        if (maxBillNoAinfos != null && !maxBillNoAinfos.isEmpty()) {
            String maxBillNo = ((DynamicObject)maxBillNoAinfos.get(0)).getString("billno");
            String[] billNoArrays = maxBillNo.split("-");
            int snum = 0;
            try {
                if (!"A".equals(billNoArrays[billNoArrays.length - 1])) {
                    snum = Integer.parseInt(billNoArrays[billNoArrays.length - 1]) + 1;
                }
            }
            catch (Exception e) {
                logger.info("\u5b50\u5355A\u4e3a\u5386\u53f2\u6570\u636e:" + maxBillNo);
            }
            if (snum > 0) {
                sn = String.valueOf(snum);
                int zeroCount = 3 - sn.length();
                StringBuilder zeroStr = new StringBuilder();
                for (int i = 0; i < zeroCount; ++i) {
                    zeroStr.append("0");
                }
                sn = zeroStr + sn;
            }
        }
        String billNo = srcBillNo + "-A-" + periodNumber + "-" + sn;
        return billNo;
    }

    private void handleAfterCostRecordB(Long writeOffPeriodId, Long bizBillId, Long costAccountId, DynamicObject newRecordA, DynamicObject oldCostRecordInfo, Map<Long, DynamicObject> groupMap, boolean isRedBill, Map<String, DynamicObject> oldCostRecordDetailMap, Map<String, DynamicObject> costRecordADetailMap, Long ancestorbillid) {
        this.bizBillIds.add(bizBillId);
        QFilter q = new QFilter("writeoffperiod", ">", (Object)writeOffPeriodId);
        q.and("bizbillid", "=", (Object)bizBillId);
        q.and("writeoffstatus", "=", (Object)"B");
        q.and("costaccount", "=", (Object)costAccountId);
        q.and("calbilltype", "=", (Object)this.calBillType);
        q.and("entry.ancestorbillid", "=", (Object)ancestorbillid);
        DynamicObject[] afterPeriodRecordBs = BusinessDataServiceHelper.load((String)"cal_costrecord", (String)this.getCostReorcdField(), (QFilter[])q.toArray());
        if (afterPeriodRecordBs == null || afterPeriodRecordBs.length == 0) {
            return;
        }
        try (ShardingHintContext ctx = ShardingHintContext.create((String)"t_cal_calcostrecord", (ShardingHintContext.ShardingHintCondition[])new ShardingHintContext.ShardingHintCondition[]{new ShardingHintContext.ShardingHintCondition("bizbillid", FilterType.eq, (Object)bizBillId)});){
            ctx.set();
            for (DynamicObject afterRecordB : afterPeriodRecordBs) {
                HashMap<Long, String> recordBMap = new HashMap<Long, String>(8);
                recordBMap.put(afterRecordB.getLong("id"), afterRecordB.getString("billno"));
                this.checkVoucher(recordBMap);
                this.dealRecordB(newRecordA, afterRecordB, groupMap, isRedBill);
                if (afterRecordB.getDynamicObjectCollection("entry").size() == 0) {
                    DeleteServiceHelper.delete((String)"cal_costrecord", (QFilter[])new QFilter("id", "=", (Object)afterRecordB.getLong("id")).toArray());
                    DynamicObjectCollection entrys = oldCostRecordInfo.getDynamicObjectCollection("entry");
                    long srcBillId = oldCostRecordInfo.getLong("id");
                    long writeOffPeriodB = afterRecordB.getDynamicObject("writeoffperiod").getLong("id");
                    for (DynamicObject item : entrys) {
                        Long ancestorBillId = item.getLong("ancestorbillid");
                        if (ancestorBillId == 0L) {
                            ancestorBillId = srcBillId;
                        }
                        this.ancesBillIdWriteoffEndPeriodMap.put(ancestorBillId, writeOffPeriodB);
                    }
                    continue;
                }
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{afterRecordB});
                this.buildCostRecordBDetail(oldCostRecordDetailMap, costRecordADetailMap, afterRecordB, false);
            }
        }
    }

    private void checkWriteoffIsOver(DynamicObject oldCostRecordInfo, boolean isRedBill, Map<Long, DynamicObject> groupMap) {
        if (oldCostRecordInfo.getDynamicObject("writeoffendperiod") != null) {
            new OverWfAutoUnWfHelper().autoUnWf(this.writeOffInfos);
            throw new KDBizException(new ErrorCode("5", ResManager.loadKDString((String)"\u4e1a\u52a1\u6570\u636e\u591a\u6838\u9500\uff0c\u8bf7\u68c0\u67e5\u6838\u9500\u8bb0\u5f55\u3002", (String)"AbstractWriteOffServiceProcess_2", (String)"fi-cal-business", (Object[])new Object[0])), new Object[0]);
        }
        DynamicObjectCollection entrys = oldCostRecordInfo.getDynamicObjectCollection("entry");
        for (int i = entrys.size() - 1; i >= 0; --i) {
            DynamicObject entry = (DynamicObject)entrys.get(i);
            Long purEntryID = entry.getLong("bizbillentryid");
            DynamicObject writeOffInfo = groupMap.get(purEntryID);
            BigDecimal writeOffqty = BigDecimal.ZERO;
            if (writeOffInfo != null) {
                String baseQtyField = "verifybaseqty";
                if (isRedBill) {
                    baseQtyField = "e_verifybaseqty";
                }
                writeOffqty = writeOffInfo.getBigDecimal(baseQtyField);
            }
            BigDecimal baseqty = entry.getBigDecimal("baseqty");
            if (writeOffqty.abs().compareTo(baseqty.abs()) <= 0) continue;
            new OverWfAutoUnWfHelper().autoUnWf(this.writeOffInfos);
            throw new KDBizException(new ErrorCode("5", ResManager.loadKDString((String)"\u4e1a\u52a1\u6570\u636e\u591a\u6838\u9500\uff0c\u8bf7\u68c0\u67e5\u6838\u9500\u8bb0\u5f55\u3002", (String)"AbstractWriteOffServiceProcess_2", (String)"fi-cal-business", (Object[])new Object[0])), new Object[0]);
        }
    }

    protected void addQueue() {
        if (this.writeOffInfos == null || this.writeOffInfos.length == 0) {
            return;
        }
        HashMap<String, String> param = new HashMap<String, String>(16);
        param.put("retry", "1");
        DispatchServiceHelper.invokeBizService((String)"fi", (String)"cal", (String)"CalBizService", (String)"doService", (Object[])new Object[]{this.actionName, param, this.writeOffInfos});
    }

    protected void checkBillAudit() {
        HashMap<Long, String> billIdNumMap = new HashMap<Long, String>(16);
        for (DynamicObject dynamicObject : this.writeOffInfos) {
            String mainBillEntity = dynamicObject.getString("billtype");
            if (this.isSynBillEntity(mainBillEntity)) {
                billIdNumMap.put(dynamicObject.getLong("billid"), dynamicObject.getString("billno"));
            }
            DynamicObjectCollection wfEntryDycs = dynamicObject.getDynamicObjectCollection("entry");
            for (DynamicObject wfEntryDyc : wfEntryDycs) {
                String assBillEntity = wfEntryDyc.getString("e_billtype");
                if (!this.isSynBillEntity(assBillEntity)) continue;
                billIdNumMap.put(wfEntryDyc.getLong("e_billid"), wfEntryDyc.getString("e_billno"));
            }
        }
        QFilter bizBillIdFilter = new QFilter("bizbillid", "in", billIdNumMap.keySet());
        QFilter billStatusFilter = new QFilter("billstatus", "=", (Object)"C");
        Throwable throwable = null;
        try (DataSet costRecordDs = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_costrecord", (String)"bizbillid", (QFilter[])new QFilter[]{bizBillIdFilter, billStatusFilter}, null);){
            for (Row row : costRecordDs) {
                billIdNumMap.remove(row.getLong("bizbillid"));
                if (!billIdNumMap.isEmpty()) continue;
                break;
            }
        }
        catch (Throwable throwable2) {
            Throwable throwable3 = throwable2;
            throw throwable2;
        }
        if (billIdNumMap.isEmpty()) {
            return;
        }
        String msg = ResManager.loadKDString((String)"\u672a\u627e\u5230\u5df2\u5ba1\u6838\u7684\u6838\u7b97\u6210\u672c\u8bb0\u5f55\uff0c\u8bf7\u67e5\u770b\u6838\u7b97\u4e1a\u52a1\u5904\u7406\u65e5\u5fd7\u6216\u7a0d\u540e\u91cd\u65b0\u6267\u884c\u3002", (String)"AbstractWriteOffServiceProcess_0", (String)"fi-cal-business", (Object[])new Object[0]);
        String string = String.join((CharSequence)"\u3001", billIdNumMap.values());
        msg = msg + "\uff1a" + string;
        this.addQueue();
        throw new KDBizException(msg);
    }

    protected Set<Long> getBizBillIdByWfRecord(DynamicObject[] wfRecordDycs) {
        HashSet<Long> bizBillIds = new HashSet<Long>(16);
        for (DynamicObject wfRecordDyc : wfRecordDycs) {
            bizBillIds.add(wfRecordDyc.getLong("billid"));
            DynamicObjectCollection entry = wfRecordDyc.getDynamicObjectCollection("entry");
            if (entry == null || entry.isEmpty()) continue;
            for (DynamicObject wfEntryDyc : entry) {
                bizBillIds.add(wfEntryDyc.getLong("e_billid"));
            }
        }
        return bizBillIds;
    }

    private boolean isSynBillEntity(String entity) {
        return "im_purinbill".equals(entity) || "im_saloutbill".equals(entity) || "im_mdc_ominbill".equals(entity) || "im_ospurinbill".equals(entity);
    }

    protected void writeBackIsVoucherUncheck(Set<Long> ancestorIds, Set<Long> bizbillIds) {
        HashSet<Long> copyAncestorIds = new HashSet<Long>(ancestorIds);
        QFilter bizBillIdFilter = new QFilter("bizbillid", "in", bizbillIds);
        QFilter ancFilter = new QFilter("entry.ancestorbillid", "in", copyAncestorIds);
        DataSet ancNoVouchDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_costrecord", (String)"id,issplitcreate,entry.ancestorbillid,isinitbill,dischargetype,isfivoucher,istempvoucher,isdischargevoucher,iscostcarryover,isfeevoucher", (QFilter[])new QFilter[]{ancFilter, bizBillIdFilter}, null);
        QFilter filter = new QFilter("id", "in", copyAncestorIds);
        DataSet noVoucherDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_costrecord", (String)"id,issplitcreate,entry.ancestorbillid,isinitbill,dischargetype,isfivoucher,istempvoucher,isdischargevoucher,iscostcarryover,isfeevoucher", (QFilter[])new QFilter[]{filter, bizBillIdFilter}, null);
        noVoucherDataSet = noVoucherDataSet.union(ancNoVouchDataSet);
        for (Row row : noVoucherDataSet) {
            boolean isVoucher;
            boolean bl = isVoucher = row.getBoolean("isfivoucher") != false || row.getBoolean("istempvoucher") != false || row.getBoolean("isdischargevoucher") != false || row.getBoolean("iscostcarryover") != false || row.getBoolean("isfeevoucher") != false;
            if (row.getBoolean("isinitbill").booleanValue() && DischargeTypeEnum.BILLCOMECLEAR.getValue().equals(row.getString("dischargetype"))) {
                boolean bl2 = isVoucher = row.getBoolean("isfivoucher") != false || row.getBoolean("isdischargevoucher") != false || row.getBoolean("iscostcarryover") != false || row.getBoolean("isfeevoucher") != false;
            }
            if (!isVoucher) continue;
            if (row.getBoolean("issplitcreate").booleanValue()) {
                copyAncestorIds.remove(row.getLong("entry.ancestorbillid"));
                continue;
            }
            copyAncestorIds.remove(row.getLong("id"));
        }
        if (!copyAncestorIds.isEmpty()) {
            DB.execute((DBRoute)DBRoute.of((String)"cal"), (String)("update t_cal_calcostrecord set fisvoucher = '0' where fid in (" + StringUtils.join((Object[])copyAncestorIds.toArray(), (char)',') + ") and fisvoucher = '1'"));
        }
    }

    protected void queryCalWriteoffRecordIdChange(DynamicObject[] reLoadInfos) {
        HashSet<String> wfIds = new HashSet<String>(4);
        for (DynamicObject reLoadInfo : reLoadInfos) {
            wfIds.add(reLoadInfo.getString("id"));
        }
        try (DataSet dataSet = DB.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (DBRoute)CommonUtils.getCalDBRouteKey(), (String)("select FCONID,FWRITEOFFDATE from T_CAL_WRITEOFFRECORD_IDCHANGE where FCONID in (" + String.join((CharSequence)",", wfIds) + ")"));){
            for (Row row : dataSet) {
                this.wfid2CalWriteoffDateMap.put(row.getLong("FCONID"), row.getDate("FWRITEOFFDATE"));
            }
        }
    }

    protected Set<Long> getAllBizBillIds(DynamicObject[] bizBills) {
        HashSet<Long> allBizBillIds = new HashSet<Long>(16);
        for (DynamicObject info : bizBills) {
            allBizBillIds.add(info.getLong("billid"));
            DynamicObjectCollection writeEntryColl = info.getDynamicObjectCollection("entry");
            for (DynamicObject writeOffEntry : writeEntryColl) {
                allBizBillIds.add(writeOffEntry.getLong("e_billid"));
            }
        }
        return allBizBillIds;
    }

    private static class RelationIds {
        private long fatherBillid;
        private long fatherEntryid;
        private long ancestorBillid;
        private long ancestorEntryid;

        private RelationIds() {
        }

        public long getFatherBillid() {
            return this.fatherBillid;
        }

        public void setFatherBillid(long fatherBillid) {
            this.fatherBillid = fatherBillid;
        }

        public long getFatherEntryid() {
            return this.fatherEntryid;
        }

        public void setFatherEntryid(long fatherEntryid) {
            this.fatherEntryid = fatherEntryid;
        }

        public long getAncestorBillid() {
            return this.ancestorBillid;
        }

        public void setAncestorBillid(long ancestorBillid) {
            this.ancestorBillid = ancestorBillid;
        }

        public long getAncestorEntryid() {
            return this.ancestorEntryid;
        }

        public void setAncestorEntryid(long ancestorEntryid) {
            this.ancestorEntryid = ancestorEntryid;
        }
    }
}

