/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.process.impl;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.AlgoContext;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDBizException;
import kd.bos.extplugin.PluginProxy;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.fi.cal.business.bizfinint.BizFinIntOrderRedisLock;
import kd.fi.cal.business.calculate.billgroup.GroupRelationCostCalculator;
import kd.fi.cal.business.calculate.bizbillgroup.BizGroupRecordBuilder;
import kd.fi.cal.business.calculate.out.FIFOCalculate;
import kd.fi.cal.business.calculate.out.IntimeBufferPoolHandle;
import kd.fi.cal.business.calculate.out.MoveAddAverageCalculate4Sync;
import kd.fi.cal.business.process.AbstractBizProcessor;
import kd.fi.cal.business.process.ErrorMsg;
import kd.fi.cal.business.process.inner.CalMoveDlock;
import kd.fi.cal.business.process.inner.OmInBillInfoHelper;
import kd.fi.cal.common.constant.CalDbParamConstant;
import kd.fi.cal.common.enums.AccountTypeEnum;
import kd.fi.cal.common.enums.ActionEnum;
import kd.fi.cal.common.enums.CostPriceSourceTypeEnum;
import kd.fi.cal.common.helper.AcctGroupModelHelper;
import kd.fi.cal.common.helper.CalCustomEventCallHelper;
import kd.fi.cal.common.helper.CalDbParamServiceHelper;
import kd.fi.cal.common.helper.CalGroupAccountHelper;
import kd.fi.cal.common.helper.CommonSettingHelper;
import kd.fi.cal.common.model.CostPriceResultInfo;
import kd.sdk.fi.cal.extpoint.calintime.ICalMoveGroupCost;

public class CalMoveAddAverageNewProcess
extends AbstractBizProcessor {
    private static final Log logger = LogFactory.getLog(CalMoveAddAverageNewProcess.class);
    private Set<String> omInBills = new HashSet<String>(16);
    private static final String NO_FEED = "N";
    private Map<String, Set<Long>> billGroupIdTgtBillIdMap = new HashMap<String, Set<Long>>(16);
    private Map<Long, CostPriceResultInfo> preZeroPrice = new HashMap<Long, CostPriceResultInfo>(16);
    private Map<Long, CostPriceResultInfo> preNegativePrice = new HashMap<Long, CostPriceResultInfo>(16);
    private Map<Long, CostPriceResultInfo> preNegativeQty = new HashMap<Long, CostPriceResultInfo>(16);
    private Set<Long> hasGetZeroPriceEntryIds = new HashSet<Long>(16);
    private Set<Long> hasGetNegPriceEntryIds = new HashSet<Long>(16);
    private String bizBillEntity = null;

    /*
     * WARNING - void declaration
     */
    public void doProcessor(Map params, DynamicObject[] bizBills) {
        if (bizBills.length == 0 || "im_initbill".equals(bizBills[0].getDataEntityType().getName())) {
            return;
        }
        this.bizBillEntity = bizBills[0].getDataEntityType().getName();
        HashMap<Long, DynamicObject> billIdDycMap = new HashMap<Long, DynamicObject>(16);
        HashSet<Long> idSet = new HashSet<Long>();
        for (DynamicObject bill : bizBills) {
            if (bill == null) continue;
            idSet.add(bill.getLong("id"));
            billIdDycMap.put(bill.getLong("id"), bill);
        }
        this.omInBills = CommonSettingHelper.getBizEntityNumbers((String)"ominbiztype");
        String auditType = String.valueOf(params.get("type"));
        String entityName = "cal_costrecord";
        QFilter qs = new QFilter("bizbillid", "in", idSet);
        qs.and("isinitbill", "=", (Object)Boolean.FALSE);
        qs.and("issplitcreate", "=", (Object)Boolean.FALSE);
        qs.and("entry.accounttype", "in", (Object)new String[]{AccountTypeEnum.MOVE_ADD_AVERAGE.getValue(), AccountTypeEnum.FIN_FOUT.getValue(), AccountTypeEnum.STANDARDCOST.getValue()});
        qs.and("invscheme.isforwardamount", "=", (Object)Boolean.TRUE);
        qs.and("entry.invtype.isforwardamount", "=", (Object)Boolean.TRUE);
        qs.and("biztype", "not in", (Object)CommonSettingHelper.getNotUpdBalBizType());
        new CalGroupAccountHelper().addNotGroupAcctFilter4Bill(qs);
        QFilter[] filter = qs.toArray();
        DynamicObjectCollection coll = QueryServiceHelper.query((String)"cal_costrecord", (String)"id,bizbillid,calbilltype,auditdate,costaccount,entry.material as material,entry.accounttype as accounttype,entry.id as entryid,entry.bizbillentryid as bizbillentryid,bookdate,entry.queuetype as queuetype", (QFilter[])filter);
        if (!coll.isEmpty()) {
            String errorMsg;
            Collection<Object[]> errorBillInfo;
            HashMap<Long, Map<Long, Long>> inBillFifoMap = new HashMap<Long, Map<Long, Long>>(coll.size());
            HashMap<Long, Map<Long, Long>> outBillFifoMap = new HashMap<Long, Map<Long, Long>>(coll.size());
            HashMap<Long, Set<Long>> inBillMap = new HashMap<Long, Set<Long>>(coll.size());
            HashMap<Long, Set<Long>> outBillMap = new HashMap<Long, Set<Long>>(coll.size());
            HashMap<Long, Set<Long>> outStdMap = new HashMap<Long, Set<Long>>(coll.size());
            HashMap<Long, Set<Long>> inStdMap = new HashMap<Long, Set<Long>>(coll.size());
            HashMap isOutMoveAddSuccessMap = new HashMap(coll.size());
            HashMap isInMoveAddSuccessMap = new HashMap(coll.size());
            boolean isHasMoveFifo = false;
            for (Object info : coll) {
                void var25_29;
                Set costRecordSet;
                long bizBillId2 = info.getLong("bizbillid");
                HashMap<Long, Map<Long, Long>> thisFifoMap = null;
                Iterator<Long> thisMap = null;
                Object var25_30 = null;
                if ("OUT".equals(info.getString("calbilltype"))) {
                    thisFifoMap = outBillFifoMap;
                    thisMap = outBillMap;
                    HashMap<Long, Set<Long>> hashMap = outStdMap;
                } else {
                    thisFifoMap = inBillFifoMap;
                    thisMap = inBillMap;
                    HashMap<Long, Set<Long>> hashMap = inStdMap;
                }
                if (AccountTypeEnum.MOVE_ADD_AVERAGE.getValue().equals(info.getString("accounttype"))) {
                    costRecordSet = thisMap.computeIfAbsent(bizBillId2, k -> new HashSet());
                    costRecordSet.add(info.getLong("id"));
                    isHasMoveFifo = true;
                }
                if (AccountTypeEnum.FIN_FOUT.getValue().equals(info.getString("accounttype"))) {
                    Map costRecordMap = thisFifoMap.computeIfAbsent(bizBillId2, k -> new HashMap());
                    costRecordMap.put(info.getLong("costaccount"), info.getLong("id"));
                    isHasMoveFifo = true;
                }
                if (!AccountTypeEnum.STANDARDCOST.getValue().equals(info.getString("accounttype"))) continue;
                costRecordSet = var25_29.computeIfAbsent(bizBillId2, k -> new HashSet());
                costRecordSet.add(info.getLong("bizbillentryid"));
            }
            HashSet<Long> realTimeBizBillIds = new HashSet<Long>(16);
            for (DynamicObject costRecordDyc : coll) {
                realTimeBizBillIds.add(costRecordDyc.getLong("bizbillid"));
            }
            String bizEntity = bizBills[0].getDataEntityType().getName();
            List<Long> retryBillIds = AcctGroupModelHelper.isBizGroupModel() ? this.checkSrcBillByBizBillGroup(bizEntity, realTimeBizBillIds) : this.checkSrcBillByBillGroup(realTimeBizBillIds);
            this.doCalMovePreCal(entityName, outBillMap, bizBills, auditType);
            this.doCalMovePreCal(entityName, inBillMap, bizBills, auditType);
            this.addLock(idSet, isHasMoveFifo);
            Set<Long> noCalMoveBizBillIds = this.removeOmInBillCalMove(bizEntity, inBillMap);
            Set<Long> noCalFifoBizBillIds = this.removeOmInBillFifo(inBillFifoMap, bizBills);
            noCalMoveBizBillIds.addAll(noCalFifoBizBillIds);
            for (ErrorMsg errorMsg2 : this.getErrors()) {
                Long bizBillid = errorMsg2.getId();
                inBillFifoMap.remove(bizBillid);
                outBillFifoMap.remove(bizBillid);
                outBillMap.remove(bizBillid);
                inBillMap.remove(bizBillid);
                inStdMap.remove(bizBillid);
                outStdMap.remove(bizBillid);
            }
            for (Long l : retryBillIds) {
                this.calProcessContext.addRetryBillDyc((DynamicObject)billIdDycMap.get(l));
            }
            noCalMoveBizBillIds.addAll(retryBillIds);
            if (CalDbParamServiceHelper.getBoolean((String)CalDbParamConstant.ENTRY_SPLIT_INTIME_CAL).booleanValue()) {
                this.insertBufferPool(coll, noCalMoveBizBillIds);
                CalCustomEventCallHelper.calImmediateAccountingEventCall(idSet);
                return;
            }
            if (!outBillMap.isEmpty()) {
                while ((errorBillInfo = this.doCalMoved(entityName, outBillMap, bizBills, auditType)) != null && !errorBillInfo.isEmpty()) {
                    for (Object[] objs : errorBillInfo) {
                        Long l = (Long)objs[0];
                        errorMsg = (String)objs[1];
                        inBillFifoMap.remove(l);
                        outBillFifoMap.remove(l);
                        outBillMap.remove(l);
                        inBillMap.remove(l);
                        inStdMap.remove(l);
                        outStdMap.remove(l);
                        this.addErrorMsg(l, "3", errorMsg);
                        retryBillIds.add(l);
                    }
                }
                errorBillInfo = outBillMap.entrySet().iterator();
                while (errorBillInfo.hasNext()) {
                    Map.Entry entry = (Map.Entry)errorBillInfo.next();
                    isOutMoveAddSuccessMap.put(entry.getKey(), true);
                }
            }
            if (!outBillFifoMap.isEmpty()) {
                while ((errorBillInfo = this.doCalFifo(entityName, outBillFifoMap, auditType)) != null && !errorBillInfo.isEmpty()) {
                    for (Object[] objs : errorBillInfo) {
                        Long l = (Long)objs[0];
                        errorMsg = (String)objs[1];
                        Boolean isOutMoveAddSuccess = (Boolean)isOutMoveAddSuccessMap.get(l);
                        if (isOutMoveAddSuccess != null && isOutMoveAddSuccess.booleanValue()) {
                            throw new KDBizException(errorMsg);
                        }
                        outBillFifoMap.remove(l);
                        inBillFifoMap.remove(l);
                        outBillMap.remove(l);
                        inBillMap.remove(l);
                        inStdMap.remove(l);
                        outStdMap.remove(l);
                        this.addErrorMsg(l, "3", errorMsg);
                    }
                }
            }
            if (!outStdMap.isEmpty()) {
                this.dealGroupCost4StandardType(outStdMap, "OUT");
            }
            if (!inBillMap.isEmpty()) {
                Collection<Object[]> errorBillInfo2;
                ArrayList<String> errBilNoAndMatNoList = new ArrayList<String>(16);
                boolean bl = outBillMap.isEmpty();
                while ((errorBillInfo2 = this.doCalMoved(entityName, inBillMap, bizBills, auditType)) != null && !errorBillInfo2.isEmpty()) {
                    for (Object[] objs : errorBillInfo2) {
                        Long bizBillid = (Long)objs[0];
                        String errorMsg2 = (String)objs[1];
                        errBilNoAndMatNoList.add(objs[2] + "," + objs[3] + "," + objs[4]);
                        inBillFifoMap.remove(bizBillid);
                        outBillFifoMap.remove(bizBillid);
                        outBillMap.remove(bizBillid);
                        inBillMap.remove(bizBillid);
                        inStdMap.remove(bizBillid);
                        outStdMap.remove(bizBillid);
                        this.addErrorMsg(bizBillid, "3", errorMsg2);
                    }
                }
                if (!bl && !errBilNoAndMatNoList.isEmpty()) {
                    StringBuilder errMsg = new StringBuilder();
                    errMsg.append(ResManager.loadKDString((String)"\u4ee5\u4e0b\u5355\u636e\u5bf9\u5e94\u7269\u6599\u7684\u5355\u4f4d\u6210\u672c\u5c0f\u4e8e\u7b49\u4e8e0\uff0c\u5355\u4ef7\u5f02\u5e38\uff0c\u6838\u7b97\u4e2d\u6b62\uff0c\u8bf7\u6838\u67e5\u51fa\u5e93\u6838\u7b97\u62a5\u544a\u53ca\u5355\u636e\uff0c\u786e\u4fdd\u6838\u7b97\u5355\u636e\u6570\u91cf\u91d1\u989d\u6b63\u786e \u3002", (String)"FIFOCalculate_10", (String)"fi-cal-business", (Object[])new Object[0]));
                    for (String errBilNoAndMatNo : errBilNoAndMatNoList) {
                        errMsg.append("\n");
                        String[] errs = errBilNoAndMatNo.split(",");
                        String billNoError = ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\uff1a", (String)"FIFOCalculate_11", (String)"fi-cal-business", (Object[])new Object[0]);
                        errMsg.append(billNoError).append(errs[0]).append(" ").append(ResManager.loadKDString((String)"\u7269\u6599\u7f16\u7801\uff1a", (String)"FIFOCalculate_12", (String)"fi-cal-business", (Object[])new Object[0])).append(errs[1]);
                    }
                    throw new KDBizException(errMsg.toString());
                }
                for (Map.Entry entry : inBillMap.entrySet()) {
                    isInMoveAddSuccessMap.put(entry.getKey(), true);
                }
            }
            if (!inBillFifoMap.isEmpty()) {
                while ((errorBillInfo = this.doCalFifo(entityName, inBillFifoMap, auditType)) != null && !errorBillInfo.isEmpty()) {
                    for (Object[] objs : errorBillInfo) {
                        Long l = (Long)objs[0];
                        errorMsg = (String)objs[1];
                        Boolean isInMoveAddSuccess = (Boolean)isInMoveAddSuccessMap.get(l);
                        if (isInMoveAddSuccess != null && isInMoveAddSuccess.booleanValue()) {
                            throw new KDBizException(errorMsg);
                        }
                        outBillFifoMap.remove(l);
                        inBillFifoMap.remove(l);
                        outBillMap.remove(l);
                        inBillMap.remove(l);
                        inStdMap.remove(l);
                        outStdMap.remove(l);
                        this.addErrorMsg(l, "3", errorMsg);
                    }
                }
            }
            if (!inStdMap.isEmpty()) {
                this.dealGroupCost4StandardType(inStdMap, "IN");
            }
            CalCustomEventCallHelper.calImmediateAccountingEventCall(idSet);
            for (Long l : retryBillIds) {
                this.calProcessContext.addRetryBillDyc((DynamicObject)billIdDycMap.get(l));
            }
        }
    }

    private List<Long> checkSrcBillByBizBillGroup(String bizEntity, Set<Long> realTimeBizBillIds) {
        ArrayList<Long> retryBillIds = new ArrayList<Long>(16);
        if (realTimeBizBillIds.isEmpty()) {
            return retryBillIds;
        }
        Map<Long, Set<String>> tgtBillIdSrcBillNosMap = this.getSrcNoSyncMap(bizEntity, realTimeBizBillIds);
        HashMap<String, Set<Long>> map = new HashMap<String, Set<Long>>(4);
        map.put(bizEntity, realTimeBizBillIds);
        DataSet groupds = new BizGroupRecordBuilder().getAllGroupRecordDataSetByBizBillIds(map);
        HashMap<Long, String> tgCalentryIdGroupIdMap = new HashMap<Long, String>(16);
        HashMap<String, String> groupIdSrcBillValueStrMap = new HashMap<String, String>(16);
        HashMap<String, Set> unAuditGroupId2SrcBillnos = new HashMap<String, Set>(16);
        for (Row row : groupds) {
            String entryentitytype = row.getString("type");
            if ("0".equals(entryentitytype)) {
                String groupId = row.getString("groupid");
                String status = row.getString("billstatus");
                if (!(realTimeBizBillIds.contains(row.getLong("bizbillid")) || status != null && "C".equals(status))) {
                    Set srcnos = unAuditGroupId2SrcBillnos.computeIfAbsent(groupId, k -> new HashSet(4));
                    srcnos.add(row.getString("billno"));
                    continue;
                }
                String valueStr = row.getLong("period") + "_" + row.getBigDecimal("baseqty").signum();
                groupIdSrcBillValueStrMap.put(groupId, valueStr);
                continue;
            }
            Set destBizBillIds = this.billGroupIdTgtBillIdMap.computeIfAbsent(row.getString("groupid"), k -> new HashSet(4));
            destBizBillIds.add(row.getLong("bizbillid"));
            tgCalentryIdGroupIdMap.put(row.getLong("calentryid"), row.getString("groupid"));
        }
        logger.info("CalMoveAddAverageNewProcess checkSrcBillByBillGroup tgCalentryIdGroupIdMap=" + tgCalentryIdGroupIdMap);
        this.calProcessContext.putCustomerParams("tgCalentryIdGroupIdMap", tgCalentryIdGroupIdMap);
        for (Map.Entry longSetEntry : unAuditGroupId2SrcBillnos.entrySet()) {
            String groupid = (String)longSetEntry.getKey();
            Set srcBillnos = (Set)longSetEntry.getValue();
            Set<Long> tgBillids = this.billGroupIdTgtBillIdMap.get(groupid);
            for (Long tgBillid : tgBillids) {
                Set unAuditSrcBillNums = tgtBillIdSrcBillNosMap.computeIfAbsent(tgBillid, k -> new HashSet(16));
                unAuditSrcBillNums.addAll(srcBillnos);
            }
        }
        this.calProcessContext.putCustomerParams("groupIdSrcBillValueStrMap", groupIdSrcBillValueStrMap);
        String msgFormat = ResManager.loadKDString((String)"\u6210\u7ec4\u5355\u636e\u6e90\u5355\u672a\u5ba1\u6838\uff1a%1$s", (String)"CalMoveAddAverageNewProcess_4", (String)"fi-cal-business", (Object[])new Object[0]);
        logger.info("CalMoveAddAverageNewProcess checkSrcBillByBillGroup groupIdSrcBillValueStrMap=" + groupIdSrcBillValueStrMap);
        for (Map.Entry<Long, Set<String>> item : tgtBillIdSrcBillNosMap.entrySet()) {
            this.addErrorMsg(item.getKey(), "3", String.format(msgFormat, String.join((CharSequence)",", (Iterable<? extends CharSequence>)item.getValue())));
            retryBillIds.add(item.getKey());
        }
        return retryBillIds;
    }

    private Map<Long, Set<String>> getSrcNoSyncMap(String bizEntity, Set<Long> realTimeBizBillIds) {
        HashMap<Long, Set<String>> tgtBillIdSrcBillNosMap = new HashMap<Long, Set<String>>(16);
        QFilter destFilter = new QFilter("entryentity.bizbillid", "in", realTimeBizBillIds);
        destFilter.and("entryentity.type", "=", (Object)"1");
        DataSet destDS = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"im_bgrecord", (String)"id,entryentity.bizbillid as destBizBillid", (QFilter[])destFilter.toArray(), null);
        HashSet<Long> bgIds = new HashSet<Long>(16);
        for (Row row : destDS.copy()) {
            bgIds.add(row.getLong("id"));
        }
        QFilter srcFilter = new QFilter("id", "in", bgIds);
        srcFilter.and("entryentity.type", "=", (Object)"0");
        DataSet srcDS = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"im_bgrecord", (String)"id,entryentity.bizbillid as srcBizBillid,entryentity.billno as srcBillno", (QFilter[])srcFilter.toArray(), null);
        HashSet<Long> srcBizBillIds = new HashSet<Long>(16);
        for (Row row : srcDS.copy()) {
            srcBizBillIds.add(row.getLong("srcBizBillid"));
        }
        srcBizBillIds.removeAll(realTimeBizBillIds);
        QFilter crFilter = new QFilter("bizbillid", "in", srcBizBillIds);
        DataSet crDS = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_costrecord", (String)"bizbillid,id as crid", (QFilter[])crFilter.toArray(), null);
        DataSet dest2srcDS = destDS.join(srcDS, JoinType.INNER).on("id", "id").select(new String[]{"destBizBillid"}, new String[]{"srcBizBillid", "srcBillno"}).finish().join(crDS, JoinType.LEFT).on("srcBizBillid", "bizbillid").select(new String[]{"destBizBillid", "srcBizBillid", "srcBillno"}, new String[]{"crid"}).finish().where("crid == null");
        for (Row row : dest2srcDS) {
            Long tgBillid = row.getLong("destBizBillid");
            String srcBillno = row.getString("srcBillno");
            Set unAuditSrcBillNums = tgtBillIdSrcBillNosMap.computeIfAbsent(tgBillid, k -> new HashSet(16));
            unAuditSrcBillNums.add(srcBillno);
        }
        QFilter bgSetFitler = new QFilter("grouptype", "=", (Object)"B");
        bgSetFitler.and("enable", "=", (Object)"1");
        bgSetFitler.and("groupbillentry.formid", "=", (Object)bizEntity);
        DynamicObject bgSet = QueryServiceHelper.queryOne((String)"im_bizgroupsetting", (String)"groupbillentry.reltype as reltype", (QFilter[])bgSetFitler.toArray());
        if (bgSet != null) {
            String reltype = bgSet.getString("reltype");
            String select = "bizbillid as destBizBillid,entry.srcbillid as srcbillid";
            if ("E".equals(reltype)) {
                select = "bizbillid as destBizBillid,entry.mainbillid as srcbillid";
            }
            QFilter ischargeoffCrFilter = new QFilter("bizbillid", "in", realTimeBizBillIds);
            ischargeoffCrFilter.and("ischargeoff", "=", (Object)true);
            DataSet chargeoffDS = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_costrecord", (String)select, (QFilter[])ischargeoffCrFilter.toArray(), null);
            HashSet<Long> isChargeoffedBizBillids = new HashSet<Long>(16);
            for (Row row : chargeoffDS.copy()) {
                isChargeoffedBizBillids.add(row.getLong("srcbillid"));
            }
            isChargeoffedBizBillids.removeAll(realTimeBizBillIds);
            QFilter ischargeoffedFilter = new QFilter("bizbillid", "in", isChargeoffedBizBillids);
            DataSet chargeoffedDS = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_costrecord", (String)"bizbillid as srcBizBillid", (QFilter[])ischargeoffedFilter.toArray(), null);
            for (Row row : chargeoffedDS) {
                isChargeoffedBizBillids.remove(row.getLong("srcBizBillid"));
            }
            if (!isChargeoffedBizBillids.isEmpty()) {
                QFilter bizFilter = new QFilter("id", "in", isChargeoffedBizBillids);
                DataSet bizDS = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)bizEntity, (String)"id as srcBizBillid,billno as srcBillno", (QFilter[])bizFilter.toArray(), null);
                dest2srcDS = chargeoffDS.join(bizDS, JoinType.INNER).on("srcbillid", "srcBizBillid").select(new String[]{"destBizBillid"}, new String[]{"srcBillno"}).finish();
                for (Row row : dest2srcDS) {
                    Long tgBillid = row.getLong("destBizBillid");
                    String srcBillno = row.getString("srcBillno");
                    Set unAuditSrcBillNums = tgtBillIdSrcBillNosMap.computeIfAbsent(tgBillid, k -> new HashSet(16));
                    unAuditSrcBillNums.add(srcBillno);
                }
            }
        }
        return tgtBillIdSrcBillNosMap;
    }

    private void addLock(Set<Long> idSet, boolean isHasMoveFifo) {
        if (!isHasMoveFifo) {
            return;
        }
        BizFinIntOrderRedisLock bizFinIntOrderRedisLock = new BizFinIntOrderRedisLock();
        bizFinIntOrderRedisLock.tryLock(idSet);
        CalMoveDlock calMoveDlock = new CalMoveDlock();
        Map keyLockMap = calMoveDlock.addLockBatchByCostRecord(idSet);
        for (Map.Entry keyLockEntry : keyLockMap.entrySet()) {
            this.addLock((String)keyLockEntry.getKey(), (DLock)keyLockEntry.getValue());
        }
    }

    private void insertBufferPool(DynamicObjectCollection coll, Set<Long> noCalMoveBizBillIds) {
        DynamicObjectCollection bufferPoolCalDycs = new DynamicObjectCollection();
        for (DynamicObject costReDyc : coll) {
            if (noCalMoveBizBillIds.contains(costReDyc.getLong("bizbillid"))) continue;
            bufferPoolCalDycs.add((Object)costReDyc);
        }
        IntimeBufferPoolHandle handle = new IntimeBufferPoolHandle(bufferPoolCalDycs, "cal_costrecord_subentity", ActionEnum.AUDIT.getValue(), false);
        handle.insertIntoPool();
        this.calProcessContext.putCustomerParams("bufferPoolBizBills", handle.getBufferPoolBizBillids());
    }

    private Set<Long> removeOmInBillCalMove(String entityName, Map<Long, Set<Long>> inBillMap) {
        HashSet<Long> noCalBizBillIds = new HashSet<Long>(16);
        if (this.omInBills.contains(entityName)) {
            if (!"im_ospurinbill".equals(entityName)) {
                HashMap<Long, Long> realTimeCostRecordIdBizBillIdMap = new HashMap<Long, Long>(16);
                for (Map.Entry<Long, Set<Long>> bizBillIdCostIds : inBillMap.entrySet()) {
                    for (Long costId : bizBillIdCostIds.getValue()) {
                        realTimeCostRecordIdBizBillIdMap.put(costId, bizBillIdCostIds.getKey());
                    }
                }
                QFilter idf = new QFilter("id", "in", realTimeCostRecordIdBizBillIdMap.keySet());
                idf.and(new QFilter("entry.baseqty", ">", (Object)BigDecimal.ZERO));
                List notCalIds = QueryServiceHelper.queryPrimaryKeys((String)"cal_costrecord", (QFilter[])idf.toArray(), null, (int)-1);
                for (Long notCalId : notCalIds) {
                    Long bizBillId = (Long)realTimeCostRecordIdBizBillIdMap.get(notCalId);
                    inBillMap.remove(bizBillId);
                    noCalBizBillIds.add(bizBillId);
                }
            }
            if ("im_ospurinbill".equals(entityName)) {
                HashSet needRemove = new HashSet(16);
                Set<Long> curBizbillIds = inBillMap.keySet();
                QFilter q = new QFilter("bizbillid", "in", curBizbillIds);
                DynamicObjectCollection costRecordAndEntrys = QueryServiceHelper.query((String)((Object)((Object)this)).getClass().getName(), (String)"cal_costrecord_subentity", (String)"id,bizbillid,entry.bizbillentryid", (QFilter[])new QFilter[]{q}, null);
                HashSet<Long> bizbillIds = new HashSet<Long>(16);
                HashSet<Long> bizbillentryIds = new HashSet<Long>(16);
                for (DynamicObject costRecord : costRecordAndEntrys) {
                    bizbillIds.add(costRecord.getLong("bizbillid"));
                    long bizbillentryid = costRecord.getLong("entry.bizbillentryid");
                    bizbillentryIds.add(bizbillentryid);
                }
                OmInBillInfoHelper omHelper = new OmInBillInfoHelper();
                omHelper.getSubTypeAndBizId(bizbillIds, bizbillentryIds, NO_FEED, needRemove);
                for (Long bizbillId : needRemove) {
                    inBillMap.remove(bizbillId);
                    noCalBizBillIds.add(bizbillId);
                }
            }
        }
        return noCalBizBillIds;
    }

    private Set<Long> removeOmInBillFifo(Map<Long, Map<Long, Long>> inBillFifoMap, DynamicObject[] bizBills) {
        HashSet<Long> noCalBizBillIds = new HashSet<Long>(16);
        if (this.omInBills.contains(bizBills[0].getDataEntityType().getName())) {
            if ("im_ospurinbill".equals(bizBills[0].getDataEntityType().getName())) {
                HashSet needRemove = new HashSet(16);
                HashSet<Long> curBizbillIds = new HashSet<Long>(16);
                for (DynamicObject bizBill : bizBills) {
                    curBizbillIds.add(bizBill.getLong("id"));
                }
                QFilter q = new QFilter("bizbillid", "in", curBizbillIds);
                DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)((Object)((Object)this)).getClass().getName(), (String)"cal_costrecord_subentity", (String)"id,bizbillid,entry.bizbillentryid", (QFilter[])new QFilter[]{q}, null);
                HashSet<Long> bizbillIds = new HashSet<Long>(16);
                HashSet<Long> bizbillentryIds = new HashSet<Long>(16);
                for (DynamicObject costRecord : dynamicObjectCollection) {
                    bizbillIds.add(costRecord.getLong("bizbillid"));
                    long bizbillentryid = costRecord.getLong("entry.bizbillentryid");
                    bizbillentryIds.add(bizbillentryid);
                }
                OmInBillInfoHelper omHelper = new OmInBillInfoHelper();
                omHelper.getSubTypeAndBizId(bizbillIds, bizbillentryIds, NO_FEED, needRemove);
                if (!inBillFifoMap.isEmpty() && !needRemove.isEmpty()) {
                    inBillFifoMap.keySet().removeAll(needRemove);
                    noCalBizBillIds.addAll(needRemove);
                }
            }
            if (!"im_ospurinbill".equals(bizBills[0].getDataEntityType().getName())) {
                HashSet notCalBizBillIds = new HashSet(16);
                HashMap realTimeCostRecordIdBizBillIdMap = new HashMap(16);
                for (Map.Entry entry : inBillFifoMap.entrySet()) {
                    for (Long costId : ((Map)entry.getValue()).values()) {
                        realTimeCostRecordIdBizBillIdMap.put(costId, entry.getKey());
                    }
                }
                QFilter idf = new QFilter("id", "in", realTimeCostRecordIdBizBillIdMap.keySet());
                idf.and(new QFilter("entry.baseqty", ">", (Object)BigDecimal.ZERO));
                List list = QueryServiceHelper.queryPrimaryKeys((String)"cal_costrecord", (QFilter[])idf.toArray(), null, (int)-1);
                for (Object notCalId : list) {
                    notCalBizBillIds.add(realTimeCostRecordIdBizBillIdMap.get(notCalId));
                }
                for (Long notCalBizBillId : notCalBizBillIds) {
                    inBillFifoMap.remove(notCalBizBillId);
                    noCalBizBillIds.add(notCalBizBillId);
                }
            }
        }
        return noCalBizBillIds;
    }

    private List<Long> checkSrcBillByBillGroup(Set<Long> billIds) {
        ArrayList<Long> retryBillIds = new ArrayList<Long>(16);
        if (billIds.isEmpty()) {
            return retryBillIds;
        }
        QFilter tgtIdF = new QFilter("entryentity.bizbillid", "in", billIds);
        QFilter isTgtF = new QFilter("entryentity.type", "=", (Object)"1");
        HashMap<Long, String> tgCalentryIdGroupIdMap = new HashMap<Long, String>(16);
        String groupRecKey = AcctGroupModelHelper.isNewGroupModel() ? "cal_account_grouprecord" : "cal_groupbillrecord";
        String tgSelectFields = "id,entryentity.bizbillid as tgtbillid,entryentity.billno as tgtbillno,entryentity.billentryid as tgcalentryid,groupsetting";
        if ("cal_account_grouprecord".equals(groupRecKey)) {
            tgSelectFields = "id,entryentity.bizbillid as tgtbillid,entryentity.billno as tgtbillno,entryentity.calentryid as tgcalentryid,groupsetting";
        }
        HashSet<Long> calEntryIdSet = new HashSet<Long>(16);
        HashSet<Long> bizBillIdSet = new HashSet<Long>(16);
        DataSet billGroupDs = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)groupRecKey, (String)tgSelectFields, (QFilter[])new QFilter[]{tgtIdF, isTgtF}, null);
        DataSet billGroupDsCy = billGroupDs.copy();
        HashSet<Long> groupIds = new HashSet<Long>(16);
        for (Row row : billGroupDs) {
            groupIds.add(row.getLong("id"));
            Set destBizBillIds = this.billGroupIdTgtBillIdMap.computeIfAbsent(row.getLong("id").toString(), k -> new HashSet(4));
            destBizBillIds.add(row.getLong("tgtbillid"));
            tgCalentryIdGroupIdMap.put(row.getLong("tgcalentryid"), row.getLong("id").toString());
            calEntryIdSet.add(row.getLong("tgcalentryid"));
            bizBillIdSet.add(row.getLong("tgtbillid"));
        }
        if (!AcctGroupModelHelper.isNewGroupModel() && !calEntryIdSet.isEmpty()) {
            QFilter recordFilter = new QFilter("issplitcreate", "=", (Object)false);
            recordFilter.and("costaccount.status", "=", (Object)Character.valueOf('C'));
            recordFilter.and("costaccount.enable", "=", (Object)true);
            if (!calEntryIdSet.isEmpty()) {
                recordFilter.and("entry.calentryid", "in", calEntryIdSet);
            }
            if (!bizBillIdSet.isEmpty()) {
                recordFilter.and("bizbillid", "in", bizBillIdSet);
            }
            new CalGroupAccountHelper().addNotGroupAcctFilter4Bill(recordFilter);
            DataSet costrecordDataSet = QueryServiceHelper.queryDataSet((String)CalMoveAddAverageNewProcess.class.getName(), (String)"cal_costrecord", (String)"entry.calentryid as calentryid,entry.accounttype as accounttype", (QFilter[])recordFilter.toArray(), null);
            DataSet accountGroupRecordSet = billGroupDsCy.join(costrecordDataSet, JoinType.INNER).on("tgcalentryid", "calentryid").select(new String[]{"groupsetting", "tgcalentryid"}, new String[]{"accounttype"}).finish();
            Set<Long> isReturnBillSetting = this.getIsReturnBillGroupBillSetting();
            for (Iterator row : accountGroupRecordSet) {
                String accounttype = row.getString("accounttype");
                Long groupSettingId = row.getLong("groupsetting");
                Long calentryid = row.getLong("tgcalentryid");
                if (!"D".equals(accounttype) || !isReturnBillSetting.contains(groupSettingId)) continue;
                tgCalentryIdGroupIdMap.remove(calentryid);
            }
        }
        this.calProcessContext.putCustomerParams("tgCalentryIdGroupIdMap", tgCalentryIdGroupIdMap);
        HashSet<Long> srcbillIds = new HashSet<Long>(16);
        srcbillIds.add(1L);
        QFilter billGroupIdF = new QFilter("id", "in", groupIds);
        QFilter isSrcF = new QFilter("entryentity.type", "=", (Object)"0");
        DataSet billGroupRecordDs = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)groupRecKey, (String)"id as groupid,entryentity.bizbillid as srcbizbillid,entryentity.type as type", (QFilter[])new QFilter[]{billGroupIdF, isSrcF}, null);
        Object object = null;
        try {
            for (Row row : billGroupRecordDs.copy()) {
                srcbillIds.add(row.getLong("srcbizbillid"));
            }
            QFilter bizBillIdF = new QFilter("bizbillid", "in", srcbillIds);
            new CalGroupAccountHelper().addNotGroupAcctFilter4Bill(bizBillIdF);
            DataSet costRecordDs = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_costrecord", (String)"billno,bizbillid,period,entry.baseqty as baseqty,billstatus", (QFilter[])new QFilter[]{bizBillIdF}, null);
            costRecordDs = billGroupRecordDs.join(costRecordDs).on("srcbizbillid", "bizbillid").select(new String[]{"groupid", "srcbizbillid"}, new String[]{"billno", "period", "baseqty", "billstatus"}).finish();
            HashMap<Long, Set> tgtBillIdSrcBillNosMap = new HashMap<Long, Set>(16);
            HashMap<String, String> groupIdSrcBillValueStrMap = new HashMap<String, String>(16);
            for (Object row : costRecordDs.copy()) {
                String groupId = row.getLong("groupid").toString();
                String valueStr = row.getLong("period") + "_" + row.getBigDecimal("baseqty").signum();
                groupIdSrcBillValueStrMap.put(groupId, valueStr);
            }
            QFilter billStatusF = new QFilter("billstatus", "in", (Object)new String[]{"A", "B"});
            costRecordDs = costRecordDs.filter(billStatusF.toString());
            for (Row row : costRecordDs) {
                Long srcbillid;
                String groupId = row.getLong("groupid").toString();
                Set<Long> tgtBillIds = this.billGroupIdTgtBillIdMap.get(groupId);
                if (tgtBillIds.contains(srcbillid = row.getLong("srcbizbillid"))) continue;
                for (Long tgtBillId : tgtBillIds) {
                    Set unAuditSrcBillNums = tgtBillIdSrcBillNosMap.computeIfAbsent(tgtBillId, k -> new HashSet(16));
                    unAuditSrcBillNums.add(row.getString("billno"));
                }
            }
            this.calProcessContext.putCustomerParams("groupIdSrcBillValueStrMap", groupIdSrcBillValueStrMap);
            String msgFormat = ResManager.loadKDString((String)"\u6210\u7ec4\u5355\u636e\u6e90\u5355\u672a\u5ba1\u6838\uff1a%1$s", (String)"CalMoveAddAverageNewProcess_4", (String)"fi-cal-business", (Object[])new Object[0]);
            logger.info("CalMoveAddAverageNewProcess checkSrcBillByBillGroup groupIdSrcBillValueStrMap=" + groupIdSrcBillValueStrMap);
            for (Map.Entry item : tgtBillIdSrcBillNosMap.entrySet()) {
                this.addErrorMsg((Long)item.getKey(), "3", String.format(msgFormat, String.join((CharSequence)",", (Iterable)item.getValue())));
                retryBillIds.add((Long)item.getKey());
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (billGroupRecordDs != null) {
                if (object != null) {
                    try {
                        billGroupRecordDs.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    billGroupRecordDs.close();
                }
            }
        }
        return retryBillIds;
    }

    private Collection<Object[]> doCalMoved(String entityName, Map<Long, Set<Long>> outBillMap, DynamicObject[] bizBills, String auditType) {
        if (outBillMap.isEmpty()) {
            return null;
        }
        HashSet<Long> allBills = new HashSet<Long>();
        for (Set<Long> ids : outBillMap.values()) {
            allBills.addAll(ids);
        }
        MoveAddAverageCalculate4Sync outCalMov = new MoveAddAverageCalculate4Sync(allBills.toArray(new Long[0]), entityName, "1", auditType);
        outCalMov.setBizBillEntity(this.bizBillEntity);
        DataSet dataSet = outCalMov.beforeCalculate();
        Map<String, BigDecimal> billGroupMap = outCalMov.getBillGroupMap();
        this.doCalGroupCostEx(billGroupMap, bizBills);
        outCalMov.setBillCostPriceMap4ZeroPrice(this.preZeroPrice);
        outCalMov.setBillCostPriceMap4NegativePrice(this.preNegativePrice);
        outCalMov.setBillCostPriceMap4NegativeQty(this.preNegativeQty);
        outCalMov.setHasGetZeroPriceEntryIds(new HashSet<Long>(this.hasGetZeroPriceEntryIds));
        outCalMov.setHasGetNegPriceEntryIds(new HashSet<Long>(this.hasGetNegPriceEntryIds));
        return outCalMov.doCalculate(dataSet);
    }

    private Collection<Object[]> doCalFifo(String entityName, Map<Long, Map<Long, Long>> outBillFifoMap, String auditType) {
        if (outBillFifoMap.isEmpty()) {
            return null;
        }
        HashMap<Long, Set> allBillMap = new HashMap<Long, Set>();
        for (Map<Long, Long> costAccBillidMap : outBillFifoMap.values()) {
            for (Map.Entry<Long, Long> e : costAccBillidMap.entrySet()) {
                Set costRecordSet = allBillMap.computeIfAbsent(e.getKey(), k -> new HashSet());
                costRecordSet.add(e.getValue());
            }
        }
        ArrayList<FIFOCalculate> list = new ArrayList<FIFOCalculate>(allBillMap.size());
        for (Map.Entry e : allBillMap.entrySet()) {
            long costAccountId = (Long)e.getKey();
            Set billIds = (Set)e.getValue();
            FIFOCalculate fifoCal = new FIFOCalculate(billIds.toArray(new Long[0]), entityName, "1", costAccountId, true, auditType);
            try (TraceSpan span = Tracer.create((String)("fifoCal.calculate4Sync-" + billIds.size()), (String)"fifoCal.calculate4Sync");
                 AlgoContext context = Algo.newContext();){
                Collection coll = fifoCal.calculate4Sync();
                if (coll != null && !coll.isEmpty()) {
                    Collection collection = coll;
                    return collection;
                }
            }
            list.add(fifoCal);
        }
        for (FIFOCalculate cal : list) {
            TraceSpan span = Tracer.create((String)("fifoCal.writeToDB-" + list.size()), (String)"fifoCal.writeToDB");
            Throwable throwable = null;
            try {
                cal.writeToDB();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (span == null) continue;
                if (throwable != null) {
                    try {
                        span.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                span.close();
            }
        }
        return null;
    }

    private void dealGroupCost4StandardType(Map<Long, Set<Long>> stdMap, String calBillType) {
        HashMap<Long, Set<Long>> newStdMap = new HashMap<Long, Set<Long>>(stdMap);
        HashSet<Long> allTgtBizBillIds = new HashSet<Long>(16);
        for (Set<Long> set : this.billGroupIdTgtBillIdMap.values()) {
            allTgtBizBillIds.addAll(set);
        }
        newStdMap.keySet().retainAll(allTgtBizBillIds);
        if (newStdMap.isEmpty()) {
            return;
        }
        HashSet bizBillEntryIds = new HashSet(newStdMap.size());
        for (Set entryIds : newStdMap.values()) {
            bizBillEntryIds.addAll(entryIds);
        }
        QFilter qFilter = new QFilter("entry.bizbillentryid", "in", bizBillEntryIds);
        qFilter.and("isinitbill", "=", (Object)Boolean.FALSE);
        qFilter.and("issplitcreate", "=", (Object)Boolean.FALSE);
        qFilter.and("calbilltype", "=", (Object)calBillType);
        qFilter.and("entry.accounttype", "=", (Object)AccountTypeEnum.STANDARDCOST.getValue());
        qFilter.and("biztype", "not in", (Object)CommonSettingHelper.getNotUpdBalBizType());
        DynamicObject[] costRecords = BusinessDataServiceHelper.load((String)"cal_costrecord_subentity", (String)"costaccount,costaccount.calpolicy,costaccount.calpolicy.calbycostelement,period,invscheme,entry.id,entry.calentryid,entry.baseqty,entry.accounttype,entry.invtype,entry.materialcost,entry.fee,entry.manufacturecost,entry.resource,entry.processcost,entry.actualcost,entry.unitmaterialcost,entry.unitfee,entry.unitmanufacturecost,entry.unitresource,entry.unitprocesscost,entry.unitactualcost,subentrycostelement.costsubelement,subentrycostelement.costelement,subentrycostelement.costelement.type,subentrycostelement.sub_actualcost,subentrycostelement.sub_unitactualcost,entry.costpricesource,entry.designatedcost", (QFilter[])qFilter.toArray());
        if (costRecords == null || costRecords.length == 0) {
            return;
        }
        HashSet<Long> costAccountIds = new HashSet<Long>(16);
        HashMap costAccount_calEntryIdMap = new HashMap(16);
        ArrayList<DynamicObject> recordEntryList = new ArrayList<DynamicObject>(10);
        for (DynamicObject costRecord : costRecords) {
            for (DynamicObject recordEntry : costRecord.getDynamicObjectCollection("entry")) {
                if (!AccountTypeEnum.STANDARDCOST.getValue().equals(recordEntry.getString("accounttype")) || !costRecord.getDynamicObject("invscheme").getBoolean("isforwardamount") || !recordEntry.getDynamicObject("invtype").getBoolean("isforwardamount")) continue;
                recordEntryList.add(recordEntry);
                long costAccount = costRecord.getLong("costaccount_id");
                long calentryId = recordEntry.getLong("calentryid");
                long period = costRecord.getLong("period_id");
                costAccountIds.add(costAccount);
                if (costAccount_calEntryIdMap.containsKey(costAccount + "|" + period)) {
                    ((Set)costAccount_calEntryIdMap.get(costAccount + "|" + period)).add(calentryId);
                    continue;
                }
                HashSet<Long> set = new HashSet<Long>();
                set.add(calentryId);
                costAccount_calEntryIdMap.put(costAccount + "|" + period, set);
            }
        }
        Map costAccountMap = BusinessDataServiceHelper.loadFromCache((Object[])costAccountIds.toArray(), (String)"cal_bd_costaccount");
        HashMap<String, BigDecimal> billGroupMap = new HashMap<String, BigDecimal>(16);
        for (Map.Entry entry : costAccount_calEntryIdMap.entrySet()) {
            String key = (String)entry.getKey();
            Map map = GroupRelationCostCalculator.calculateCost((Object)key.split("\\|")[0], (long)Long.parseLong(key.split("\\|")[1]), (Set)((Set)entry.getValue()));
            billGroupMap.putAll(map);
        }
        logger.info("\u6210\u7ec4\u5173\u7cfb\u83b7\u53d6\uff1a" + billGroupMap);
        if (billGroupMap.isEmpty()) {
            return;
        }
        HashSet<Long> targetEntryIds = new HashSet<Long>(billGroupMap.size());
        for (String key : billGroupMap.keySet()) {
            targetEntryIds.add(Long.valueOf(key.split("\\|")[1]));
        }
        for (DynamicObject recordEntry : recordEntryList) {
            DynamicObject record = (DynamicObject)recordEntry.getParent();
            DynamicObject costAccount = record.getDynamicObject("costaccount");
            BigDecimal qty = recordEntry.getBigDecimal("baseqty");
            long costAccountId = costAccount.getLong("id");
            boolean calbycostelement = ((DynamicObject)costAccountMap.get(costAccountId)).getDynamicObject("calpolicy").getBoolean("calbycostelement");
            long calentryId = recordEntry.getLong("calentryid");
            if (!targetEntryIds.contains(calentryId)) continue;
            String keyPfefix = costAccountId + "|" + calentryId + "|";
            if (calbycostelement) {
                this.dealElementEntry(billGroupMap, recordEntry, qty, keyPfefix);
                continue;
            }
            this.dealNoneElementEntry(billGroupMap, recordEntry, qty, keyPfefix);
        }
        SaveServiceHelper.save((DynamicObject[])costRecords);
    }

    private void dealNoneElementEntry(Map<String, BigDecimal> billGroupMap, DynamicObject recordEntry, BigDecimal qty, String keyPfefix) {
        BigDecimal cost = billGroupMap.get(keyPfefix + "materialcost");
        if (cost != null) {
            recordEntry.set("materialcost", (Object)cost);
            recordEntry.set("unitmaterialcost", (Object)cost.divide(qty, 10, RoundingMode.HALF_UP));
        }
        BigDecimal materialcost = recordEntry.getBigDecimal("materialcost");
        cost = billGroupMap.get(keyPfefix + "fee");
        if (cost != null) {
            recordEntry.set("fee", (Object)cost);
            recordEntry.set("unitfee", (Object)cost.divide(qty, 10, RoundingMode.HALF_UP));
        }
        BigDecimal fee = recordEntry.getBigDecimal("fee");
        cost = billGroupMap.get(keyPfefix + "manufacturecost");
        if (cost != null) {
            recordEntry.set("manufacturecost", (Object)cost);
            recordEntry.set("unitmanufacturecost", (Object)cost.divide(qty, 10, RoundingMode.HALF_UP));
        }
        BigDecimal manufacturecost = recordEntry.getBigDecimal("manufacturecost");
        cost = billGroupMap.get(keyPfefix + "resource");
        if (cost != null) {
            recordEntry.set("resource", (Object)cost);
            recordEntry.set("unitresource", (Object)cost.divide(qty, 10, RoundingMode.HALF_UP));
        }
        BigDecimal resource = recordEntry.getBigDecimal("resource");
        cost = billGroupMap.get(keyPfefix + "processcost");
        if (cost != null) {
            recordEntry.set("processcost", (Object)cost);
            recordEntry.set("unitprocesscost", (Object)cost.divide(qty, 10, RoundingMode.HALF_UP));
        }
        BigDecimal processcost = recordEntry.getBigDecimal("processcost");
        BigDecimal actualCost = materialcost.add(fee).add(manufacturecost).add(resource).add(processcost);
        recordEntry.set("actualcost", (Object)actualCost);
        recordEntry.set("unitactualcost", (Object)actualCost.divide(qty, 10, RoundingMode.HALF_UP));
        recordEntry.set("costpricesource", (Object)CostPriceSourceTypeEnum.getCostPriceSourceValue((String)CostPriceSourceTypeEnum.GROUP_COST_SPECIFICATION.getValue()));
        recordEntry.set("designatedcost", (Object)CostPriceSourceTypeEnum.GROUP_COST_SPECIFICATION.getDesignated());
        DynamicObject detail = (DynamicObject)recordEntry.getDynamicObjectCollection("subentrycostelement").get(0);
        detail.set("sub_actualcost", (Object)actualCost);
        detail.set("sub_unitactualcost", (Object)actualCost.divide(qty, 10, RoundingMode.HALF_UP));
    }

    private void dealElementEntry(Map<String, BigDecimal> billGroupMap, DynamicObject recordEntry, BigDecimal qty, String keyPfefix) {
        BigDecimal materialCost = BigDecimal.ZERO;
        BigDecimal fee = BigDecimal.ZERO;
        BigDecimal processCost = BigDecimal.ZERO;
        BigDecimal resource = BigDecimal.ZERO;
        BigDecimal manufactureCost = BigDecimal.ZERO;
        for (DynamicObject detail : recordEntry.getDynamicObjectCollection("subentrycostelement")) {
            long subElementId = detail.getDynamicObject("costsubelement").getLong("id");
            BigDecimal cost = billGroupMap.get(keyPfefix + subElementId);
            String type = detail.getDynamicObject("costelement").getString("type");
            if (cost != null) {
                detail.set("sub_actualcost", (Object)cost);
                detail.set("sub_unitactualcost", (Object)cost.divide(qty, 10, RoundingMode.HALF_UP));
            }
            cost = detail.getBigDecimal("sub_actualcost");
            if ("001".equals(type)) {
                materialCost = materialCost.add(cost);
            }
            if ("002".equals(type)) {
                fee = fee.add(cost);
            }
            if ("003".equals(type)) {
                manufactureCost = manufactureCost.add(cost);
            }
            if ("004".equals(type)) {
                resource = resource.add(cost);
            }
            if (!"005".equals(type)) continue;
            processCost = processCost.add(cost);
        }
        BigDecimal actualCost = materialCost.add(fee).add(manufactureCost).add(resource).add(processCost);
        recordEntry.set("materialcost", (Object)materialCost);
        recordEntry.set("unitmaterialcost", (Object)materialCost.divide(qty, 10, RoundingMode.HALF_UP));
        recordEntry.set("fee", (Object)fee);
        recordEntry.set("unitfee", (Object)fee.divide(qty, 10, RoundingMode.HALF_UP));
        recordEntry.set("manufacturecost", (Object)manufactureCost);
        recordEntry.set("unitmanufacturecost", (Object)manufactureCost.divide(qty, 10, RoundingMode.HALF_UP));
        recordEntry.set("resource", (Object)resource);
        recordEntry.set("unitresource", (Object)resource.divide(qty, 10, RoundingMode.HALF_UP));
        recordEntry.set("processcost", (Object)processCost);
        recordEntry.set("unitprocesscost", (Object)processCost.divide(qty, 10, RoundingMode.HALF_UP));
        recordEntry.set("actualcost", (Object)actualCost);
        recordEntry.set("unitactualcost", (Object)actualCost.divide(qty, 10, RoundingMode.HALF_UP));
        recordEntry.set("costpricesource", (Object)CostPriceSourceTypeEnum.getCostPriceSourceValue((String)CostPriceSourceTypeEnum.GROUP_COST_SPECIFICATION.getValue()));
        recordEntry.set("designatedcost", (Object)CostPriceSourceTypeEnum.GROUP_COST_SPECIFICATION.getDesignated());
    }

    public void doCalGroupCostEx(Map<String, BigDecimal> billGroupMap, DynamicObject[] bizBills) {
        HashSet<Long> bizBillIds = new HashSet<Long>(100);
        for (DynamicObject bill : bizBills) {
            bizBillIds.add(bill.getLong("id"));
        }
        PluginProxy pluginProxy = PluginProxy.create(null, ICalMoveGroupCost.class, (String)"FI_CAL_CALINTIME_CALMOVEGROUPCOST", null);
        pluginProxy.callReplace(p -> {
            p.doCalGroupCostEx(billGroupMap, "cal_costrecord", bizBillIds);
            return null;
        });
    }

    private Set<Long> getIsReturnBillGroupBillSetting() {
        HashSet<Long> isReturnBillSettings = new HashSet<Long>(16);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)CalMoveAddAverageNewProcess.class.getName(), (String)"cal_billgroupsetting", (String)"id", (QFilter[])new QFilter("isreturnbill", "=", (Object)true).toArray(), null);){
            for (Row row : dataSet) {
                isReturnBillSettings.add(row.getLong("id"));
            }
        }
        return isReturnBillSettings;
    }

    private Collection<Object[]> doCalMovePreCal(String entityName, Map<Long, Set<Long>> outBillMap, DynamicObject[] bizBills, String auditType) {
        Boolean needPreCal = CalDbParamServiceHelper.getBoolean((String)CalDbParamConstant.CAL_MOVE_PRE_CAL);
        if (outBillMap.isEmpty() || !needPreCal.booleanValue()) {
            return null;
        }
        ArrayList<Object[]> allErrros = new ArrayList<Object[]>(16);
        HashSet<Long> outAllBills = new HashSet<Long>();
        for (Set<Long> ids : outBillMap.values()) {
            outAllBills.addAll(ids);
        }
        MoveAddAverageCalculate4Sync outPreCalMov = new MoveAddAverageCalculate4Sync(outAllBills.toArray(new Long[0]), entityName, "1", auditType);
        outPreCalMov.setBizBillEntity(this.bizBillEntity);
        DataSet outPreDataSet = outPreCalMov.beforeCalculate();
        Map<String, BigDecimal> outBillGroupMap = outPreCalMov.getBillGroupMap();
        this.doCalGroupCostEx(outBillGroupMap, bizBills);
        outPreCalMov.setPreCal(true);
        Collection<Object[]> outErrors = outPreCalMov.doCalculate(outPreDataSet);
        if (outErrors != null) {
            allErrros.addAll(outErrors);
        }
        Map<Long, CostPriceResultInfo> outZeroPrice = outPreCalMov.getBillCostPriceMap4ZeroPrice();
        Map<Long, CostPriceResultInfo> outNegativePrice = outPreCalMov.getBillCostPriceMap4NegativePrice();
        Map<Long, CostPriceResultInfo> outNegativeQty = outPreCalMov.getBillCostPriceMap4NegativeQty();
        Set<Long> hasGetZeroPriceEntryIds = outPreCalMov.getHasGetZeroPriceEntryIds();
        Set<Long> hasGetNegPriceEntryIds = outPreCalMov.getHasGetNegPriceEntryIds();
        this.hasGetZeroPriceEntryIds.addAll(hasGetZeroPriceEntryIds);
        this.hasGetNegPriceEntryIds.addAll(hasGetNegPriceEntryIds);
        this.preZeroPrice.putAll(outZeroPrice);
        this.preNegativePrice.putAll(outNegativePrice);
        this.preNegativeQty.putAll(outNegativeQty);
        return allErrros;
    }
}

