/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.process.impl;

import com.google.common.collect.Lists;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.bos.xdb.hint.ShardingHintContext;
import kd.bos.xdb.sharding.sql.FilterType;
import kd.fi.cal.business.calculate.out.CalIntimeBufferPoolHelper;
import kd.fi.cal.business.process.ErrorMsg;
import kd.fi.cal.business.process.impl.AbstractWriteOffServiceProcess;
import kd.fi.cal.business.process.inner.PrevCostAdjustProcessHelper;
import kd.fi.cal.business.service.SyncLockHelper;
import kd.fi.cal.common.constant.CalDbParamConstant;
import kd.fi.cal.common.enums.ActionEnum;
import kd.fi.cal.common.enums.CostAdjustBilCreateTypeEnum;
import kd.fi.cal.common.enums.CostAdjustBillEnum;
import kd.fi.cal.common.helper.CalDbParamServiceHelper;
import kd.fi.cal.common.helper.WhiteListHelper;
import kd.fi.cal.common.util.CommonUtils;

public class PurUnWriteOffServiceProcess
extends AbstractWriteOffServiceProcess {
    private static final Log logger = LogFactory.getLog(PurUnWriteOffServiceProcess.class);

    public PurUnWriteOffServiceProcess() {
        this.calBillType = "IN";
    }

    public void doProcessor(Map params, DynamicObject[] bizBills) {
        Integer batchSize = CalDbParamServiceHelper.getInteger((String)CalDbParamConstant.UN_WRITEOFF_SIZE);
        Lists.partition(Arrays.asList(bizBills), (int)batchSize).forEach(list -> this.doProcessorJob(params, list.toArray(new DynamicObject[0])));
    }

    private void doProcessorJob(Map params, DynamicObject[] bizBills) {
        if (bizBills == null || bizBills.length < 1) {
            return;
        }
        Set<Long> allBizBillIds = this.getAllBizBillIds(bizBills);
        SyncLockHelper syncLockHelper = new SyncLockHelper(ActionEnum.PUR_UN_WRITEOFF.getValue(), bizBills);
        try (TraceSpan span = Tracer.create((String)"PurUnWriteOffServiceProcess-doProcessor", (String)"PurUnWriteOffServiceProcess-doProcessor");
             ShardingHintContext ctx = ShardingHintContext.create((String)"t_cal_calcostrecord", (ShardingHintContext.ShardingHintCondition[])new ShardingHintContext.ShardingHintCondition[]{new ShardingHintContext.ShardingHintCondition("fbizbillid", FilterType.in_range, allBizBillIds)});){
            ctx.set();
            this.txCommitReleaseLock(syncLockHelper);
            syncLockHelper.setSyncParams(params);
            syncLockHelper.setNoRetry(true);
            List mutErrors = syncLockHelper.lock();
            StringBuilder sb = new StringBuilder();
            HashSet<String> errMsgs = new HashSet<String>(16);
            for (ErrorMsg err : mutErrors) {
                errMsgs.add(err.getErrorMsg());
            }
            for (String errMsg : errMsgs) {
                sb.append(errMsg);
            }
            if (sb.length() > 0) {
                throw new KDBizException(sb.toString());
            }
            logger.info("\u53cd\u6838\u9500\u8c03\u7528\u6838\u7b97\u63a5\u53e3\u5f00\u59cb\u3002\u3002\u3002" + System.currentTimeMillis());
            if (bizBills[0].getString("billno").startsWith("test_delay")) {
                logger.info("\u53cd\u6838\u9500\u6d4b\u8bd5,\u4e09\u5206\u949f\u5ef6\u65f6\u4e2d");
                try {
                    Thread.sleep(180000L);
                }
                catch (InterruptedException e) {
                    logger.info("PurUnWriteOffServiceProcess doProcessor", (Object)e);
                }
            }
            int cSize = bizBills.length;
            HashSet<Long> writeOffIDSet = new HashSet<Long>(cSize);
            HashSet<Long> bizbillIds = new HashSet<Long>(16);
            for (DynamicObject info : bizBills) {
                writeOffIDSet.add(info.getLong("id"));
                bizbillIds.add(info.getLong("billid"));
                DynamicObjectCollection writeEntryColl = info.getDynamicObjectCollection("entry");
                for (DynamicObject writeOffEntry : writeEntryColl) {
                    bizbillIds.add(writeOffEntry.getLong("e_billid"));
                }
            }
            DynamicObject[] costRecords = this.checkMoreReocrd(writeOffIDSet, bizbillIds);
            if (costRecords.length == 0) {
                return;
            }
            ArrayList<Long> childIds = new ArrayList<Long>(8);
            ArrayList<Long> childEntryIds = new ArrayList<Long>(1024);
            this.checkUnWriteOff(costRecords, childIds, childEntryIds, bizbillIds);
            try {
                logger.info("\u53cd\u6838\u9500\u8c03\u7528\u6838\u7b97\u63a5\u53e3\uff1a\u6210\u672c\u8bb0\u5f55\u5b50\u5355id:" + (childIds.isEmpty() ? "" : (Serializable)childIds.get(0)));
                HashSet<Long> noWriteChildEntryIds = new HashSet<Long>(childEntryIds);
                Set<Long> ancestorIds = this.getAllAncestorBillId(childIds);
                this.writeBackRecordB(childIds, noWriteChildEntryIds, bizbillIds);
                this.addNewRecordB(costRecords, noWriteChildEntryIds);
                if (!noWriteChildEntryIds.isEmpty()) {
                    this.writeBackRecordB(childIds, noWriteChildEntryIds, bizbillIds);
                }
                Map<Long, List<String>> vouSourceMap = this.getVouSourceMap(new HashSet<Long>(childIds));
                this.deleteCostAdjustBill(childIds, CostAdjustBilCreateTypeEnum.PUR_WIRTEOFF.getValue(), vouSourceMap, "cal_costadjust_subentity");
                this.deleteCostAdjustBill(childIds, CostAdjustBilCreateTypeEnum.OM_WRITEOFF.getValue(), vouSourceMap, "cal_costadjust_subentity");
                this.deleteCostAdjustBill(childIds, CostAdjustBilCreateTypeEnum.PUR_WIRTEOFF.getValue(), vouSourceMap, "cal_stdcostdiffbill");
                this.deleteCostAdjustBill(childIds, CostAdjustBilCreateTypeEnum.OM_WRITEOFF.getValue(), vouSourceMap, "cal_stdcostdiffbill");
                this.deletChildBills(childIds);
                this.deleteRecordB(ancestorIds, bizbillIds);
                this.setFatherRecordUnWriteoff(ancestorIds, bizbillIds);
                this.clearWriteOffEndPeriod(ancestorIds, bizbillIds);
                this.writeBackAncestorBillVerifyField(ancestorIds, bizbillIds);
                this.writeBackIsVoucherUncheck(ancestorIds, bizbillIds);
                this.deleteIepBusinesstask(childIds);
            }
            catch (Exception e) {
                logger.info("\u53cd\u6838\u9500\u8c03\u7528\u6838\u7b97\u63a5\u53e3\u62a5\u9519:", (Object)e);
                throw e;
            }
            logger.info("\u53cd\u6838\u9500\u8c03\u7528\u6838\u7b97\u63a5\u53e3\u7ed3\u675f\u3002\u3002\u3002" + System.currentTimeMillis());
        }
        catch (Throwable e) {
            syncLockHelper.close();
            this.addErrorMsg(bizBills[0], this.getErrorMsg(new Exception(e)));
        }
    }

    private void writeBackRecordB(ArrayList<Long> childIds, Set<Long> noWriteChildEntryIds, Set<Long> bizbillIds) {
        HashMap<Long, String> updateIdsMap = new HashMap<Long, String>(16);
        QFilter qa = new QFilter("id", "in", childIds);
        HashSet<Long> ancestorIds = new HashSet<Long>();
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_costrecord", (String)"entry.ancestorbillid", (QFilter[])qa.toArray(), null);){
            for (Row row : dataSet) {
                ancestorIds.add(row.getLong("entry.ancestorbillid"));
            }
        }
        QFilter qb = new QFilter("entry.ancestorbillid", "in", ancestorIds);
        qb.and("writeoffstatus", "=", (Object)"B");
        qb.and("bizbillid", "in", bizbillIds);
        HashMap<Long, HashMap<String, BigDecimal>> bMap = new HashMap<Long, HashMap<String, BigDecimal>>(16);
        HashSet<Long> aIDs = new HashSet<Long>(16);
        String updateSql = "update t_cal_calcostrecordentry set fbaseqty = fbaseqty + ?,fmaterialcost = fmaterialcost + ?,fprocesscost = fprocesscost + ?,fstandardcost = fstandardcost + ?,flocaltax = flocaltax + ?,factualcost = factualcost + ? where fentryid = ?";
        DataSet dataSetA = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_costrecord", (String)"id,entry.id,entry.baseqty,entry.materialcost,entry.processcost,entry.standardcost,entry.localtax,entry.actualcost,entry.ancestorentryid,writeoffperiod", (QFilter[])qa.toArray(), null);
        Object object = null;
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_costrecord", (String)"id,billno,entry.id,entry.ancestorentryid,writeoffperiod", (QFilter[])qb.toArray(), null);
             DataSet joinSet = dataSet.join(dataSetA).on("entry.ancestorentryid", "entry.ancestorentryid").select(new String[]{"id as bid", "billno", "entry.id as bentryid", "writeoffperiod as bwriteoffperiod"}, new String[]{"id as aid", "entry.id as aentryid", "entry.baseqty as abaseqty", "entry.materialcost as amaterialcost", "entry.processcost as aprocesscost", "entry.standardcost as astandardcost", "entry.localtax as alocaltax", "entry.actualcost as aactualcost", "writeoffperiod as awriteoffperiod"}).finish();){
            for (Row row : joinSet) {
                Long aWriteoffperiod = row.getLong("awriteoffperiod");
                Long bWriteoffperiod = row.getLong("bwriteoffperiod");
                if (aWriteoffperiod > bWriteoffperiod || !noWriteChildEntryIds.contains(row.getLong("aentryid"))) continue;
                aIDs.add(row.getLong("aentryid"));
                Long bEntryId = row.getLong("bentryid");
                updateIdsMap.put(row.getLong("bid"), row.getString("billno"));
                HashMap<String, BigDecimal> aMap = (HashMap<String, BigDecimal>)bMap.get(bEntryId);
                if (aMap == null) {
                    aMap = new HashMap<String, BigDecimal>();
                    aMap.put("baseqty", row.getBigDecimal("abaseqty"));
                    aMap.put("materialcost", row.getBigDecimal("amaterialcost"));
                    aMap.put("processcost", row.getBigDecimal("aprocesscost"));
                    aMap.put("standardcost", row.getBigDecimal("astandardcost"));
                    aMap.put("localtax", row.getBigDecimal("alocaltax"));
                    aMap.put("actualcost", row.getBigDecimal("aactualcost"));
                    bMap.put(bEntryId, aMap);
                    continue;
                }
                aMap.put("baseqty", ((BigDecimal)aMap.get("baseqty")).add(row.getBigDecimal("abaseqty")));
                aMap.put("materialcost", ((BigDecimal)aMap.get("materialcost")).add(row.getBigDecimal("amaterialcost")));
                aMap.put("processcost", ((BigDecimal)aMap.get("processcost")).add(row.getBigDecimal("aprocesscost")));
                aMap.put("standardcost", ((BigDecimal)aMap.get("standardcost")).add(row.getBigDecimal("astandardcost")));
                aMap.put("localtax", ((BigDecimal)aMap.get("localtax")).add(row.getBigDecimal("alocaltax")));
                aMap.put("actualcost", ((BigDecimal)aMap.get("actualcost")).add(row.getBigDecimal("aactualcost")));
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (dataSetA != null) {
                if (object != null) {
                    try {
                        dataSetA.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    dataSetA.close();
                }
            }
        }
        noWriteChildEntryIds.removeAll(aIDs);
        if (!updateIdsMap.isEmpty()) {
            this.checkVoucher(updateIdsMap);
        }
        ArrayList<Object[]> paramList = new ArrayList<Object[]>(bMap.size());
        for (Map.Entry entry : bMap.entrySet()) {
            Map aMap = (Map)entry.getValue();
            paramList.add(new Object[]{aMap.get("baseqty"), aMap.get("materialcost"), aMap.get("processcost"), aMap.get("standardcost"), aMap.get("localtax"), aMap.get("actualcost"), entry.getKey()});
        }
        if (!paramList.isEmpty()) {
            Throwable throwable = null;
            try (ShardingHintContext ctx = ShardingHintContext.create((String)"t_cal_calcostrecord", (ShardingHintContext.ShardingHintCondition[])new ShardingHintContext.ShardingHintCondition[]{new ShardingHintContext.ShardingHintCondition("fid", FilterType.in_range, childIds)});){
                ctx.set();
                DB.executeBatch((DBRoute)CommonUtils.getCalDBRouteKey(), (String)updateSql, paramList);
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                throw throwable2;
            }
        }
    }

    private void deleteIepBusinesstask(ArrayList<Long> recordIds) {
        WhiteListHelper.deleteWhiteList((String)"cal_costrecord_subentity", new ArrayList<Long>(recordIds));
    }

    /*
     * WARNING - void declaration
     */
    private void deleteCostAdjustBill(ArrayList<Long> childIds, String createType, Map<Long, List<String>> vouSourceMap, String entityNnumber) {
        DynamicObject[] errors;
        if (childIds.isEmpty()) {
            return;
        }
        QFilter q = new QFilter("entryentity.invbillid", "in", childIds).and("createtype", "=", (Object)createType);
        StringBuilder fields = new StringBuilder();
        MainEntityType calEntityType = EntityMetadataCache.getDataEntityType((String)entityNnumber);
        Set selectorsSet = calEntityType.getAllFields().keySet();
        for (String o : selectorsSet) {
            fields.append(o).append(',');
        }
        fields.setLength(fields.length() - 1);
        DynamicObject[] infos = BusinessDataServiceHelper.load((String)entityNnumber, (String)fields.toString(), (QFilter[])new QFilter[]{q});
        if (infos == null || infos.length == 0) {
            return;
        }
        HashMap<String, String> ignoreVoucherMap = new HashMap<String, String>(16);
        Set costadjustbillIds = new HashSet<Long>(16);
        block1: for (DynamicObject info : infos) {
            costadjustbillIds.add(info.getLong("id"));
            for (DynamicObject dynamicObject : info.getDynamicObjectCollection("entryentity")) {
                List<String> sourceMapList = vouSourceMap.get(dynamicObject.getLong("invbillid"));
                if (sourceMapList == null || sourceMapList.size() != 1 || !sourceMapList.contains("C")) continue;
                ignoreVoucherMap.put(info.getString("id"), "1");
                continue block1;
            }
        }
        OperateOption op = OperateOption.create();
        if (!ignoreVoucherMap.isEmpty()) {
            op.setVariableValue("ignorevouchermap", SerializationUtils.toJsonString(ignoreVoucherMap));
        }
        op.setVariableValue("unwriteoff", "true");
        op.setVariableValue("ishasright", "true");
        op.setVariableValue("ignoreValidation", "true");
        logger.info("\u53cd\u6838\u9500\u8c03\u7528\u6838\u7b97\u63a5\u53e3\uff1a\u6210\u672c\u8c03\u6574\u5355\u53cd\u5ba1\u6838\u5f00\u59cb:" + infos[0].getString("billno"));
        OperationResult result = OperationServiceHelper.executeOperate((String)"unaudit", (String)entityNnumber, (DynamicObject[])infos, (OperateOption)op);
        if (!result.isSuccess()) {
            StringBuilder msg = new StringBuilder();
            errors = result.getAllErrorOrValidateInfo();
            msg.append(ResManager.loadKDString((String)"\u6210\u672c\u8c03\u6574\u5355\u53cd\u5ba1\u6838\u5931\u8d25\uff1a", (String)"PurUnWriteOffServiceProcess_0", (String)"fi-cal-business", (Object[])new Object[0]));
            if (!errors.isEmpty()) {
                for (IOperateInfo iOperateInfo : errors) {
                    OperateInfo operror = (OperateInfo)iOperateInfo;
                    msg.append(operror.getMessage()).append('\n');
                }
            }
            msg.append(result.getMessage()).append('\n');
            throw new KDBizException(msg.toString());
        }
        logger.info("\u53cd\u6838\u9500\u8c03\u7528\u6838\u7b97\u63a5\u53e3\uff1a\u6210\u672c\u8c03\u6574\u5355\u53cd\u5ba1\u6838\u7ed3\u675f:" + infos[0].getString("billno"));
        logger.info("\u53cd\u6838\u9500\u8c03\u7528\u6838\u7b97\u63a5\u53e3\uff1a\u6210\u672c\u8c03\u6574\u5355\u53cd\u5ba1\u6838\u4fe1\u606f:" + result.getMessage());
        logger.info("\u53cd\u6838\u9500\u8c03\u7528\u6838\u7b97\u63a5\u53e3\uff1a\u6210\u672c\u8c03\u6574\u5355\u53cd\u5ba1\u6838\u6210\u529fID:" + result.getSuccessPkIds().get(0));
        logger.info("\u53cd\u6838\u9500\u8c03\u7528\u6838\u7b97\u63a5\u53e3\uff1a\u6210\u672c\u8c03\u6574\u5355\u5220\u9664\u5f00\u59cb:" + costadjustbillIds);
        costadjustbillIds = CalIntimeBufferPoolHelper.removeBufferPoolRevBill((String)entityNnumber, costadjustbillIds);
        logger.info("\u53cd\u6838\u9500\u8c03\u7528\u6838\u7b97\u63a5\u53e3\uff1a\u6210\u672c\u8c03\u6574\u5355\u5220\u9664\u5f00\u59cb:" + costadjustbillIds);
        if (!costadjustbillIds.isEmpty()) {
            QFilter deleteFilter = new QFilter("id", "in", costadjustbillIds);
            DeleteServiceHelper.delete((String)entityNnumber, (QFilter[])new QFilter[]{deleteFilter});
        }
        logger.info("\u53cd\u6838\u9500\u8c03\u7528\u6838\u7b97\u63a5\u53e3\uff1a\u6210\u672c\u8c03\u6574\u5355\u5220\u9664\u7ed3\u675f:" + q);
        if (CostAdjustBillEnum.PURCHASEAUTO.getValue().equals(createType)) {
            void var17_26;
            HashSet<Long> inAdjustIds = new HashSet<Long>(infos.length);
            errors = infos;
            int n = errors.length;
            boolean bl = false;
            while (var17_26 < n) {
                DynamicObject info = errors[var17_26];
                inAdjustIds.add(info.getLong("id"));
                ++var17_26;
            }
            PrevCostAdjustProcessHelper helper = new PrevCostAdjustProcessHelper();
            helper.unAduitAndDelAdjustBill(inAdjustIds);
        }
    }

    private void deletChildBills(ArrayList<Long> ids) {
        if (ids.isEmpty()) {
            return;
        }
        QFilter filter = new QFilter("id", "in", ids);
        DeleteServiceHelper.delete((String)"cal_costrecord", (QFilter[])new QFilter[]{filter});
    }

    private DynamicObject[] checkMoreReocrd(Set<Long> writeOffIDSet, Set<Long> bizbillIds) {
        int cSize = writeOffIDSet.size();
        HashSet<Long> costRecordAidSet = new HashSet<Long>(cSize);
        if (this.hasMoreRecord(writeOffIDSet, costRecordAidSet, bizbillIds) && costRecordAidSet.isEmpty()) {
            return new DynamicObject[0];
        }
        QFilter q = new QFilter("id", "in", costRecordAidSet);
        String field = this.getCostReorcdField();
        DynamicObject[] costRecords = BusinessDataServiceHelper.load((String)"cal_costrecord", (String)field, (QFilter[])q.toArray());
        return costRecords;
    }

    private boolean hasMoreRecord(Set<Long> writeOffIDSet, Set<Long> costRecordAidSet, Set<Long> bizbillIds) {
        HashSet<Long> copySet = new HashSet<Long>(writeOffIDSet);
        HashSet<Long> runningSet = new HashSet<Long>();
        QFilter q = new QFilter("bizbillid", "in", writeOffIDSet);
        q.and("success", "=", (Object)Character.valueOf('2'));
        try (DataSet rs = QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass() + "hasMoreRecord"), (String)"cal_businesslog", (String)"success,bizbillid", (QFilter[])q.toArray(), null);){
            for (Row row : rs) {
                runningSet.add(row.getLong("bizbillid"));
            }
        }
        q = new QFilter("entry.writeoffid", "in", writeOffIDSet);
        q.and("bizbillid", "in", bizbillIds);
        rs = QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass() + "hasMoreRecord"), (String)"cal_costrecord", (String)"id,billno,costaccount,entry.id,entry.fatherentryid,entry.writeoffid", (QFilter[])q.toArray(), null);
        var8_8 = null;
        try {
            while (rs.hasNext()) {
                Row row = rs.next();
                costRecordAidSet.add(row.getLong("id"));
                copySet.remove(row.getLong("entry.writeoffid"));
            }
        }
        catch (Throwable row) {
            var8_8 = row;
            throw row;
        }
        finally {
            if (rs != null) {
                if (var8_8 != null) {
                    try {
                        rs.close();
                    }
                    catch (Throwable row) {
                        var8_8.addSuppressed(row);
                    }
                } else {
                    rs.close();
                }
            }
        }
        if (!copySet.isEmpty()) {
            boolean isRedBlueWrite;
            HashSet<Long> hasRedBillWriteOffSet;
            HashSet<Long> hasBillWriteOffSet;
            block94: {
                hasBillWriteOffSet = new HashSet<Long>(128);
                hasRedBillWriteOffSet = new HashSet<Long>(128);
                QFilter q1 = new QFilter("id", "in", writeOffIDSet);
                isRedBlueWrite = false;
                try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"ap_verifyrecord", (String)"id,billid,verifyrelation,entry.e_billid", (QFilter[])q1.toArray(), null);){
                    Throwable throwable;
                    DataSet joinSet;
                    HashSet<Long> billIdSet = new HashSet<Long>(writeOffIDSet.size());
                    HashSet<Long> redBillIdSet = new HashSet<Long>(writeOffIDSet.size());
                    for (Row row : dataSet.copy()) {
                        billIdSet.add(row.getLong("billid"));
                        String verifyRelation = row.getString("verifyrelation");
                        if (!"purself".equals(verifyRelation) && !"apfinself".equals(verifyRelation)) continue;
                        isRedBlueWrite = true;
                        redBillIdSet.add(row.getLong("entry.e_billid"));
                    }
                    QFilter q2 = new QFilter("bizbillid", "in", billIdSet);
                    try (DataSet dataSet1 = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_costrecord", (String)"id,bizbillid", (QFilter[])q2.toArray(), null);){
                        joinSet = dataSet.copy().join(dataSet1).on("billid", "bizbillid").select(new String[]{"id as writeoffid"}, new String[]{"id as billid"}).finish();
                        throwable = null;
                        try {
                            for (Row row : joinSet) {
                                hasBillWriteOffSet.add(row.getLong("writeoffid"));
                            }
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (joinSet != null) {
                                if (throwable != null) {
                                    try {
                                        joinSet.close();
                                    }
                                    catch (Throwable throwable3) {
                                        throwable.addSuppressed(throwable3);
                                    }
                                } else {
                                    joinSet.close();
                                }
                            }
                        }
                    }
                    if (!isRedBlueWrite) break block94;
                    q2 = new QFilter("bizbillid", "in", redBillIdSet);
                    dataSet1 = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_costrecord", (String)"id,bizbillid", (QFilter[])q2.toArray(), null);
                    var17_29 = null;
                    try {
                        joinSet = dataSet.join(dataSet1).on("entry.e_billid", "bizbillid").select(new String[]{"id as writeoffid"}, new String[]{"id as billid"}).finish();
                        throwable = null;
                        try {
                            for (Row row : joinSet) {
                                hasRedBillWriteOffSet.add(row.getLong("writeoffid"));
                            }
                        }
                        catch (Throwable throwable4) {
                            throwable = throwable4;
                            throw throwable4;
                        }
                        finally {
                            if (joinSet != null) {
                                if (throwable != null) {
                                    try {
                                        joinSet.close();
                                    }
                                    catch (Throwable throwable5) {
                                        throwable.addSuppressed(throwable5);
                                    }
                                } else {
                                    joinSet.close();
                                }
                            }
                        }
                    }
                    catch (Throwable throwable6) {
                        var17_29 = throwable6;
                        throw throwable6;
                    }
                    finally {
                        if (dataSet1 != null) {
                            if (var17_29 != null) {
                                try {
                                    dataSet1.close();
                                }
                                catch (Throwable throwable7) {
                                    var17_29.addSuppressed(throwable7);
                                }
                            } else {
                                dataSet1.close();
                            }
                        }
                    }
                }
            }
            Iterator iterator = copySet.iterator();
            while (iterator.hasNext()) {
                long id = (Long)iterator.next();
                if (!runningSet.contains(id) || !(isRedBlueWrite ? hasBillWriteOffSet.contains(id) && hasRedBillWriteOffSet.contains(id) : hasBillWriteOffSet.contains(id))) continue;
                throw new KDBizException(ResManager.loadKDString((String)"\u6838\u9500\u540e\u7684\u5b58\u8d27\u6838\u7b97\u670d\u52a1\u672a\u6267\u884c\u5b8c\u6210\u6216\u8005\u6267\u884c\u5931\u8d25\uff0c\u8bf7\u8fdb\u5165\u201c\u5b58\u8d27\u6838\u7b97>\u6838\u7b97\u5355\u636e>\u670d\u52a1\u6267\u884c\u65e5\u5fd7\u201d\u786e\u8ba4\uff0c\u5982\u5931\u8d25\uff0c\u8bf7\u91cd\u65b0\u6267\u884c\u3002", (String)"PurUnWriteOffServiceProcess_7", (String)"fi-cal-business", (Object[])new Object[0]));
            }
            return true;
        }
        return false;
    }
}

