/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.process.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.xdb.hint.ShardingHintContext;
import kd.bos.xdb.sharding.sql.FilterType;
import kd.fi.cal.business.process.impl.AbstractWriteOffServiceProcess;
import kd.fi.cal.business.process.inner.CostRecordAuditInvoker;
import kd.fi.cal.business.process.inner.OverWfAutoUnWfHelper;
import kd.fi.cal.chargeoff.CalChargeOffHelper;
import kd.fi.cal.common.enums.ActionEnum;
import kd.fi.cal.common.helper.CalCustomEventCallHelper;
import kd.fi.cal.common.helper.CostElementHelper;
import kd.fi.cal.common.helper.IDGenerator;

public class SalOutWriteOffServiceProcess
extends AbstractWriteOffServiceProcess {
    private static final Log logger = LogFactory.getLog(SalOutWriteOffServiceProcess.class);

    public SalOutWriteOffServiceProcess() {
        this.calBillType = "OUT";
    }

    public void doProcessor(Map params, DynamicObject[] writeOffInfos) {
        if (writeOffInfos == null || writeOffInfos.length < 1) {
            logger.info("\u9500\u552e\u51fa\u5e93\u6838\u9500\u62c6\u5355\u5931\u8d25\uff1a\u4f20\u9012\u53c2\u6570\u4e3a\u7a7a");
            return;
        }
        this.writeOffInfos = writeOffInfos;
        this.actionName = ActionEnum.SALE_WRITEOFF.getValue();
        IAppCache cache = AppCache.get((String)"cal");
        String unwriteoff_ids = (String)cache.get(this.lock_key, String.class);
        if (unwriteoff_ids != null) {
            for (DynamicObject info : writeOffInfos) {
                boolean isUnWriteOff = unwriteoff_ids.contains(String.valueOf(info.getLong("id")));
                if (!isUnWriteOff) continue;
                throw new KDBizException(new ErrorCode("5", ResManager.loadKDString((String)"\u8be5\u6838\u9500\u8bb0\u5f55\u6b63\u5728\u53cd\u6838\u9500\u6216\u8005\u5df2\u7ecf\u53cd\u6838\u9500\u7ed3\u675f\u3002", (String)"PurWriteOffServiceProcess_5", (String)"fi-cal-business", (Object[])new Object[0])), new Object[0]);
            }
        }
        this.checkBillAudit();
        DynamicObject[] reLoadInfos = this.reLoadWriteRecord(writeOffInfos);
        Set<Long> allBizBillIds = this.getAllBizBillIds(writeOffInfos);
        try (TXHandle h = TX.requiresNew();
             ShardingHintContext ctx = ShardingHintContext.create((String)"t_cal_calcostrecord", (ShardingHintContext.ShardingHintCondition[])new ShardingHintContext.ShardingHintCondition[]{new ShardingHintContext.ShardingHintCondition("fbizbillid", FilterType.in_range, allBizBillIds)});){
            Map<Long, DynamicObject> groupMap;
            HashSet<Long> salOutIds;
            block43: {
                ctx.set();
                salOutIds = new HashSet<Long>(128);
                groupMap = this.buildGroupRecord(reLoadInfos, salOutIds);
                if (!salOutIds.isEmpty() && reLoadInfos != null && groupMap != null) break block43;
                return;
            }
            try {
                HashMap<String, Date> dateMap = new HashMap<String, Date>(16);
                HashMap<Long, Long> billIdMap = new HashMap<Long, Long>(16);
                DynamicObject wrireOff = reLoadInfos[0];
                this.verifytype = wrireOff.getString("verifytype");
                if ("extsys".equals(this.verifytype)) {
                    this.queryCalWriteoffRecordIdChange(reLoadInfos);
                }
                String verifyrelation = wrireOff.getString("verifyrelation");
                for (Long salOutId : salOutIds) {
                    this.salWriteOff(salOutId, groupMap, verifyrelation, dateMap);
                }
                if ("salself".equals(verifyrelation) || "arfinself".equals(verifyrelation) || "saloutwrittenoff".equals(verifyrelation) || "salreturnwrittenoff".equals(verifyrelation) || "1363799584391826432".equals(verifyrelation)) {
                    salOutIds.clear();
                    groupMap.clear();
                    groupMap = this.buildRedGroupRecord(reLoadInfos, salOutIds, billIdMap);
                    for (Long salOutId : salOutIds) {
                        this.salRedWriteOff(salOutId, groupMap, dateMap, billIdMap);
                    }
                }
                this.setWriteOffEndPeriod();
                new CostRecordAuditInvoker().invoke((Collection)this.auditVoucherCostRecordIds);
                CalCustomEventCallHelper.calSalesSplitOrderEventCall((List)this.auditVoucherCostRecordIds);
                Collection<DynamicObject> wfRecordDycs = groupMap.values();
                new CalChargeOffHelper().autoInvokeCharge(wfRecordDycs, "ar_verifyrecord");
            }
            catch (KDBizException e) {
                h.markRollback();
                for (DynamicObject info : reLoadInfos) {
                    this.addErrorMsg(info, "3", this.getErrorMsg((Exception)((Object)e)));
                }
            }
            catch (Exception e) {
                h.markRollback();
                for (DynamicObject info : reLoadInfos) {
                    this.addErrorMsg(info, "4", this.getErrorMsg(e));
                }
            }
        }
    }

    private DynamicObject[] reLoadWriteRecord(DynamicObject[] writeOffInfos) {
        int cSize = writeOffInfos.length;
        ArrayList<Long> ids = new ArrayList<Long>(cSize);
        for (DynamicObject writeOffInfo : writeOffInfos) {
            ids.add((Long)writeOffInfo.getPkValue());
        }
        QFilter filter = new QFilter("id", "in", ids);
        String fields = this.getWriteOffFields();
        DynamicObject[] infos = BusinessDataServiceHelper.load((String)"ar_verifyrecord", (String)fields, (QFilter[])new QFilter[]{filter});
        for (int i = 0; i < 3 && (infos == null || infos.length == 0); ++i) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                logger.info("SalOutWriteOffServiceProcess reLoadWriteRecord : ", (Object)e);
            }
            infos = BusinessDataServiceHelper.load((String)"ar_verifyrecord", (String)fields, (QFilter[])new QFilter[]{filter});
        }
        logger.info(writeOffInfos[0].getString("billno") + "\u91cd\u53d6\u6838\u9500\u8bb0\u5f55\u7ed3\u679c\uff1a" + (infos == null || infos.length == 0 ? ResManager.loadKDString((String)"\u6838\u9500\u8bb0\u5f55\u4e0d\u5b58\u5728\u3002", (String)"SalOutWriteOffServiceProcess_0", (String)"fi-cal-business", (Object[])new Object[0]) : infos[0].get("billno") + "," + infos[0].get("id")));
        if (infos == null || infos.length == 0) {
            this.addQueue();
            throw new KDBizException(new ErrorCode("5", ResManager.loadKDString((String)"\u6838\u9500\u8bb0\u5f55\u4e0d\u5b58\u5728\u3002", (String)"SalOutWriteOffServiceProcess_0", (String)"fi-cal-business", (Object[])new Object[0])), new Object[0]);
        }
        if (infos[0].getString("billno").startsWith("test_delay")) {
            logger.info("\u6838\u9500\u6d4b\u8bd5,\u4e09\u5206\u949f\u5ef6\u65f6\u4e2d");
            try {
                Thread.sleep(180000L);
            }
            catch (InterruptedException e) {
                logger.info("SalOutWriteOffServiceProcess reLoadWriteRecord : ", (Object)e);
            }
        }
        Set<Long> bizBillIds = this.getBizBillIdByWfRecord(infos);
        QFilter q = new QFilter("entry.writeoffid", "in", ids);
        QFilter bizBillIdFilter = new QFilter("bizbillid", "in", bizBillIds);
        q.and(bizBillIdFilter);
        if (QueryServiceHelper.exists((String)"cal_costrecord", (QFilter[])q.toArray())) {
            throw new KDBizException(new ErrorCode("5", ResManager.loadKDString((String)"\u6838\u9500\u8bb0\u5f55\u5df2\u62c6\u5355\u3002", (String)"PurWriteOffServiceProcess_4", (String)"fi-cal-business", (Object[])new Object[0])), new Object[0]);
        }
        return infos;
    }

    private String getWriteOffFields() {
        StringBuilder selector = new StringBuilder();
        selector.append("id,verifyseq,verifytype,billtype,billid,billno,billentryid,verifybaseqty,");
        selector.append("billdate,verifyrelation,asstacttype,asstact,currency,");
        selector.append("entry,entry.id,entry.e_billtype,entry.e_verifyamount,entry.e_verifybaseqty,");
        selector.append("entry.e_asstacttype,entry.e_asstact,entry.e_currency,entry.e_billdate,entry.e_billno,entry.e_billid,entry.e_billentryid,entry.e_hadwrittenoff,entry.e_iswrittenoff,entry.e_writtenoffremark");
        return selector.toString();
    }

    private Map<Long, DynamicObject> buildGroupRecord(DynamicObject[] writeOffInfos, Set<Long> salOutIds) {
        if (writeOffInfos == null) {
            return null;
        }
        int cSize = writeOffInfos.length;
        HashMap<Long, DynamicObject> groupMap = new HashMap<Long, DynamicObject>(cSize);
        for (DynamicObject writeOffInfo : writeOffInfos) {
            String billTypeName = writeOffInfo.getString("billtype");
            if (!"im_saloutbill".equals(billTypeName)) continue;
            Long salOutID = writeOffInfo.getLong("billid");
            Long salOutEntryID = writeOffInfo.getLong("billentryid");
            groupMap.put(salOutEntryID, writeOffInfo);
            salOutIds.add(salOutID);
        }
        return groupMap;
    }

    private Map<Long, DynamicObject> buildRedGroupRecord(DynamicObject[] writeOffInfos, Set<Long> purIds, Map<Long, Long> billIdMap) {
        if (writeOffInfos == null) {
            return null;
        }
        int cSize = writeOffInfos.length;
        HashMap<Long, DynamicObject> groupMap = new HashMap<Long, DynamicObject>(cSize);
        for (DynamicObject writeOffInfo : writeOffInfos) {
            DynamicObjectCollection writeEntryColl = writeOffInfo.getDynamicObjectCollection("entry");
            if (writeEntryColl == null || writeEntryColl.isEmpty()) continue;
            for (DynamicObject writeOffEntry : writeEntryColl) {
                Long purID = writeOffEntry.getLong("e_billid");
                Long purEntryID = writeOffEntry.getLong("e_billentryid");
                groupMap.put(purEntryID, writeOffEntry);
                billIdMap.put(purID, writeOffInfo.getLong("billid"));
                purIds.add(purID);
            }
        }
        return groupMap;
    }

    private void salWriteOff(Long salOutId, Map<Long, DynamicObject> groupMap, String verifyRelation, Map<String, Date> dateMap) {
        DynamicObject[] costRecords = this.getAllCostRecordByBizBillID(salOutId, groupMap.keySet());
        int size = costRecords.length;
        HashSet<Long> ancestorIds = new HashSet<Long>(size);
        for (int i = 0; i < size; ++i) {
            DynamicObjectCollection recordInfoEntrys;
            DynamicObject costRecordInfo = costRecords[i];
            DynamicObject subCostRecordInfo = this.splitCostRecord(costRecordInfo, groupMap, false, false, null, null);
            dateMap.put(salOutId + "_" + subCostRecordInfo.getDynamicObject("costaccount").getLong("id"), subCostRecordInfo.getDate("writeoffdate"));
            this.saveCostRecordInfo(costRecordInfo);
            if (!"arsalout".equals(verifyRelation) && !"arsalreturn".equals(verifyRelation) && !"appurin".equals(verifyRelation) && !"appurreturn".equals(verifyRelation) && !"1363792412954068992".equals(verifyRelation) || (recordInfoEntrys = subCostRecordInfo.getDynamicObjectCollection("entry")) == null || recordInfoEntrys.size() <= 0) continue;
            ancestorIds.add(((DynamicObject)recordInfoEntrys.get(0)).getLong("ancestorbillid"));
        }
        if (ancestorIds.size() > 0) {
            DB.execute((DBRoute)DBRoute.of((String)"cal"), (String)("update t_cal_calcostrecord set fissubbillinvoiceverify = '1' where fid in (" + StringUtils.join((Object[])ancestorIds.toArray(), (char)',') + ") and fissubbillinvoiceverify = '0'"));
        }
    }

    private void salRedWriteOff(Long purID, Map<Long, DynamicObject> groupMap, Map<String, Date> dateMap, Map<Long, Long> billIdMap) {
        for (DynamicObject costRecordInfo : this.getAllCostRecordByBizBillID(purID, groupMap.keySet())) {
            this.splitCostRecord(costRecordInfo, groupMap, false, true, dateMap, billIdMap);
            this.saveCostRecordInfo(costRecordInfo);
        }
    }

    @Override
    protected void setABillVoucherFlag(DynamicObject newCostRecordA) {
        if (newCostRecordA == null) {
            return;
        }
        newCostRecordA.set("carryovervouchernum", null);
        newCostRecordA.set("fivouchernum", null);
        newCostRecordA.set("fivoucherid", null);
    }

    @Override
    protected void setBBillVoucherFlag(DynamicObject newCostRecordB, boolean istempVoucher) {
        if (newCostRecordB == null) {
            return;
        }
        newCostRecordB.set("carryovervouchernum", null);
        newCostRecordB.set("fivouchernum", null);
        newCostRecordB.set("fivoucherid", null);
    }

    @Override
    protected void dealRecordA(DynamicObject newRecordA, Map<Long, DynamicObject> groupMap, boolean writeBack, boolean isRedBill) {
        String writeofftype = "B";
        if (isRedBill) {
            writeofftype = "A";
        } else {
            Map.Entry<Long, DynamicObject> mapEntry = groupMap.entrySet().iterator().next();
            DynamicObject wrireOff = mapEntry.getValue();
            String verifyrelation = wrireOff.getString("verifyrelation");
            if ("arsalout".equals(verifyrelation) || "arsalreturn".equals(verifyrelation)) {
                writeofftype = "B";
            } else if ("salself".equals(verifyrelation) || "arfinself".equals(verifyrelation) || "saloutwrittenoff".equals(verifyrelation) || "salreturnwrittenoff".equals(verifyrelation) || "1363799584391826432".equals(verifyrelation)) {
                writeofftype = "A";
            }
        }
        newRecordA.set("writeofftype", (Object)writeofftype);
        DynamicObjectCollection entrys = newRecordA.getDynamicObjectCollection("entry");
        IDGenerator idGenerator = new IDGenerator("t_cal_calcostrecordentry", entrys.size());
        for (int i = entrys.size() - 1; i >= 0; --i) {
            BigDecimal baseqty;
            BigDecimal writeOffqty;
            DynamicObject entry = (DynamicObject)entrys.get(i);
            Long purEntryID = entry.getLong("bizbillentryid");
            DynamicObject writeOffInfo = groupMap.get(purEntryID);
            if (writeOffInfo == null) {
                entrys.remove(i);
                continue;
            }
            entry.set("id", (Object)idGenerator.getId());
            String baseQtyField = "verifybaseqty";
            if (isRedBill) {
                baseQtyField = "e_verifybaseqty";
            }
            if ((writeOffqty = writeOffInfo.getBigDecimal(baseQtyField)).compareTo(baseqty = entry.getBigDecimal("baseqty")) != 0) {
                DynamicObject localcurrency = newRecordA.getDynamicObject("localcurrency");
                int amtPrecision = localcurrency.getInt("amtprecision");
                BigDecimal unitActualCost = entry.getBigDecimal("unitactualcost");
                BigDecimal actualCost = writeOffqty.multiply(unitActualCost).setScale(amtPrecision, 4);
                entry.set("actualcost", (Object)actualCost);
                BigDecimal oldUnitMaterialCost = entry.getBigDecimal("unitmaterialcost");
                BigDecimal oldUnitFee = entry.getBigDecimal("unitfee");
                BigDecimal oldUnitProcessCost = entry.getBigDecimal("unitprocesscost");
                BigDecimal oldUnitManufactureCost = entry.getBigDecimal("unitmanufacturecost");
                BigDecimal oldUnitResource = entry.getBigDecimal("unitresource");
                BigDecimal oldUnitStandardCost = entry.getBigDecimal("unitstandardcost");
                entry.set("materialcost", (Object)oldUnitMaterialCost.multiply(writeOffqty).setScale(amtPrecision, 4));
                entry.set("fee", (Object)oldUnitFee.multiply(writeOffqty).setScale(amtPrecision, 4));
                entry.set("processcost", (Object)oldUnitProcessCost.multiply(writeOffqty).setScale(amtPrecision, 4));
                entry.set("manufacturecost", (Object)oldUnitManufactureCost.multiply(writeOffqty).setScale(amtPrecision, 4));
                entry.set("resource", (Object)oldUnitResource.multiply(writeOffqty).setScale(amtPrecision, 4));
                entry.set("standardcost", (Object)oldUnitStandardCost.multiply(writeOffqty).setScale(amtPrecision, 4));
                BigDecimal localTax = entry.getBigDecimal("localtax");
                localTax = writeOffqty.divide(baseqty, 10, 4).multiply(localTax).setScale(amtPrecision, 4);
                entry.set("localtax", (Object)localTax);
            }
            entry.set("baseqty", (Object)writeOffqty);
            if (isRedBill) {
                entry.set("writeoffid", (Object)((DynamicObject)writeOffInfo.getParent()).getLong("id"));
                continue;
            }
            entry.set("writeoffid", (Object)writeOffInfo.getLong("id"));
        }
    }

    @Override
    protected void dealRecordB(DynamicObject newRecordA, DynamicObject newRecordB, Map<Long, DynamicObject> groupMap, boolean isRedBill) {
        DynamicObjectCollection entrys = newRecordB.getDynamicObjectCollection("entry");
        DynamicObjectCollection entryAs = newRecordA.getDynamicObjectCollection("entry");
        IDGenerator idGenerator = new IDGenerator("t_cal_calcostrecordentry", entrys.size());
        HashSet<Long> allBPurEntryids = new HashSet<Long>(4);
        for (int i = entrys.size() - 1; i >= 0; --i) {
            BigDecimal writeOqty;
            BigDecimal oldBaseQty;
            BigDecimal newQty;
            DynamicObject writeOffInfo;
            DynamicObject entry = (DynamicObject)entrys.get(i);
            long purEntryID = entry.getLong("bizbillentryid");
            allBPurEntryids.add(purEntryID);
            DynamicObject entryA = null;
            for (DynamicObject entryInfo : entryAs) {
                long purEntryIDA = entryInfo.getLong("bizbillentryid");
                if (purEntryID != purEntryIDA) continue;
                entryA = entryInfo;
                break;
            }
            if ((writeOffInfo = groupMap.get(purEntryID)) == null) continue;
            String baseQtyField = "verifybaseqty";
            if (isRedBill) {
                baseQtyField = "e_verifybaseqty";
            }
            if (BigDecimal.ZERO.compareTo(newQty = (oldBaseQty = entry.getBigDecimal("baseqty")).subtract(writeOqty = writeOffInfo.getBigDecimal(baseQtyField))) == 0) {
                entrys.remove(i);
                continue;
            }
            if (oldBaseQty.abs().compareTo(writeOqty.abs()) < 0) {
                new OverWfAutoUnWfHelper().autoUnWf(this.writeOffInfos);
                throw new KDBizException(new ErrorCode("5", ResManager.loadKDString((String)"\u4e1a\u52a1\u6570\u636e\u591a\u6838\u9500\uff0c\u8bf7\u68c0\u67e5\u6838\u9500\u8bb0\u5f55\u3002", (String)"AbstractWriteOffServiceProcess_2", (String)"fi-cal-business", (Object[])new Object[0])), new Object[0]);
            }
            if (entry.getLong("id") == 0L) {
                entry.set("id", (Object)idGenerator.getId());
            }
            BigDecimal bActualcost = entry.getBigDecimal("actualcost").subtract(entryA == null ? BigDecimal.ZERO : entryA.getBigDecimal("actualcost"));
            entry.set("actualcost", (Object)bActualcost);
            BigDecimal localTaxB = entry.getBigDecimal("localtax").subtract(entryA == null ? BigDecimal.ZERO : entryA.getBigDecimal("localtax"));
            entry.set("localtax", (Object)localTaxB);
            entry.set("baseqty", (Object)newQty);
            BigDecimal oldMaterialCost = entry.getBigDecimal("materialcost");
            BigDecimal oldFee = entry.getBigDecimal("fee");
            BigDecimal oldProcessCost = entry.getBigDecimal("processcost");
            BigDecimal oldManufactureCost = entry.getBigDecimal("manufacturecost");
            BigDecimal oldResource = entry.getBigDecimal("resource");
            BigDecimal oldStandardCost = entry.getBigDecimal("standardcost");
            BigDecimal materialCost = entryA == null ? BigDecimal.ZERO : entryA.getBigDecimal("materialcost");
            BigDecimal fee = entryA == null ? BigDecimal.ZERO : entryA.getBigDecimal("fee");
            BigDecimal processCost = entryA == null ? BigDecimal.ZERO : entryA.getBigDecimal("processcost");
            BigDecimal manufactureCost = entryA == null ? BigDecimal.ZERO : entryA.getBigDecimal("manufacturecost");
            BigDecimal resource = entryA == null ? BigDecimal.ZERO : entryA.getBigDecimal("resource");
            BigDecimal standardCost = entryA == null ? BigDecimal.ZERO : entryA.getBigDecimal("standardcost");
            entry.set("materialcost", (Object)oldMaterialCost.subtract(materialCost));
            entry.set("fee", (Object)oldFee.subtract(fee));
            entry.set("processcost", (Object)oldProcessCost.subtract(processCost));
            entry.set("manufacturecost", (Object)oldManufactureCost.subtract(manufactureCost));
            entry.set("resource", (Object)oldResource.subtract(resource));
            entry.set("standardcost", (Object)oldStandardCost.subtract(standardCost));
        }
        for (DynamicObject entryInfo : entryAs) {
            long purEntryIDA = entryInfo.getLong("bizbillentryid");
            if (allBPurEntryids.contains(purEntryIDA)) continue;
            new OverWfAutoUnWfHelper().autoUnWf(this.writeOffInfos);
            throw new KDBizException(new ErrorCode("5", ResManager.loadKDString((String)"\u4e1a\u52a1\u6570\u636e\u591a\u6838\u9500\uff0c\u8bf7\u68c0\u67e5\u6838\u9500\u8bb0\u5f55\u3002", (String)"AbstractWriteOffServiceProcess_2", (String)"fi-cal-business", (Object[])new Object[0])), new Object[0]);
        }
    }

    @Override
    protected void dealSalOutCostRecordDetal(DynamicObject oldCostRecordInfo, DynamicObject newRecordA, Map<String, DynamicObject> oldCostRecordDetailMap, Map<String, DynamicObject> costRecordADetailMap) {
        super.dealSalOutCostRecordDetal(oldCostRecordInfo, newRecordA, oldCostRecordDetailMap, costRecordADetailMap);
        try (ShardingHintContext ctx = ShardingHintContext.create((String)"t_cal_calcostrecord", (ShardingHintContext.ShardingHintCondition[])new ShardingHintContext.ShardingHintCondition[]{new ShardingHintContext.ShardingHintCondition("fid", FilterType.eq, (Object)oldCostRecordInfo.getLong("id"))});){
            ctx.set();
            DynamicObject[] costRecordDetailArry = new DynamicObject[]{newRecordA};
            CostElementHelper.insertCostElements((DynamicObject[])costRecordDetailArry);
            this.buildFatherDetails(oldCostRecordInfo, oldCostRecordDetailMap);
            this.buildCostRecordADetail(oldCostRecordDetailMap, costRecordADetailMap, newRecordA);
        }
    }

    @Override
    protected void buildCostRecordBDetail(Map<String, DynamicObject> oldCostRecordDetailMap, Map<String, DynamicObject> costRecordADetailMap, DynamicObject newRecordB, boolean isNewB) {
        ShardingHintContext costRecordBDetailArray;
        if (newRecordB == null) {
            return;
        }
        DynamicObjectCollection costRecordEntry = newRecordB.getDynamicObjectCollection("entry");
        if (costRecordEntry == null || costRecordEntry.isEmpty()) {
            return;
        }
        if (isNewB) {
            DynamicObject[] costRecordDetailArry = new DynamicObject[]{newRecordB};
            CostElementHelper.insertCostElements((DynamicObject[])costRecordDetailArry);
        }
        int cSize = costRecordEntry.size();
        HashSet<Long> entryIds = new HashSet<Long>(cSize);
        HashMap<Long, Long> relationIdMap = new HashMap<Long, Long>(cSize);
        HashMap<Long, BigDecimal> qtyMap = new HashMap<Long, BigDecimal>(cSize);
        for (DynamicObject entry : costRecordEntry) {
            long entryId = entry.getLong("id");
            entryIds.add(entryId);
            relationIdMap.put(entryId, entry.getLong("ancestorentryid"));
            qtyMap.put(entryId, entry.getBigDecimal("baseqty"));
        }
        Long bizBillId = newRecordB.getLong("bizbillid");
        try (ShardingHintContext ctx = ShardingHintContext.create((String)"t_cal_calcostrecord", (ShardingHintContext.ShardingHintCondition[])new ShardingHintContext.ShardingHintCondition[]{new ShardingHintContext.ShardingHintCondition("fbizbillid", FilterType.eq, (Object)bizBillId)});){
            ctx.set();
            costRecordBDetailArray = BusinessDataServiceHelper.load((String)"cal_costrecord_detail", (String)"id,entryid,costsubelement,actualcost,unitactualcost,costsubelement.id,baseqty,standardcost,unitstandardcost", (QFilter[])new QFilter("entryid", "in", entryIds).toArray());
        }
        if (costRecordBDetailArray == null) {
            return;
        }
        for (DynamicObject dynamic : costRecordBDetailArray) {
            DynamicObject costRecordADetail;
            long entryId = dynamic.getLong("entryid");
            long ancestorEntryid = (Long)relationIdMap.get(entryId);
            long detailCostSubElemnetId = dynamic.getLong("costsubelement.id");
            DynamicObject oldCostRecordDetail = oldCostRecordDetailMap.get(ancestorEntryid + "_" + detailCostSubElemnetId);
            if (oldCostRecordDetail == null) continue;
            BigDecimal oldUnitActualCost = oldCostRecordDetail.getBigDecimal("unitactualcost");
            BigDecimal oldActualCost = oldCostRecordDetail.getBigDecimal("actualcost");
            BigDecimal oldUnitStandardCost = oldCostRecordDetail.getBigDecimal("unitstandardcost");
            BigDecimal oldStandardCost = oldCostRecordDetail.getBigDecimal("standardcost");
            if (!isNewB) {
                oldUnitActualCost = dynamic.getBigDecimal("unitactualcost");
                oldActualCost = dynamic.getBigDecimal("actualcost");
                oldUnitStandardCost = dynamic.getBigDecimal("unitstandardcost");
                oldStandardCost = dynamic.getBigDecimal("standardcost");
                dynamic.set("baseqty", qtyMap.get(entryId));
            }
            if ((costRecordADetail = costRecordADetailMap.get(ancestorEntryid + "_" + detailCostSubElemnetId)) == null) {
                dynamic.set("actualcost", (Object)oldActualCost);
                dynamic.set("unitactualcost", (Object)oldUnitActualCost);
                dynamic.set("standardcost", (Object)oldStandardCost);
                dynamic.set("unitstandardcost", (Object)oldUnitStandardCost);
                continue;
            }
            BigDecimal aActualCost = costRecordADetail.getBigDecimal("actualcost");
            BigDecimal aStandardCost = costRecordADetail.getBigDecimal("standardcost");
            dynamic.set("actualcost", (Object)oldActualCost.subtract(aActualCost));
            dynamic.set("unitactualcost", (Object)oldUnitActualCost);
            dynamic.set("standardcost", (Object)oldStandardCost.subtract(aStandardCost));
            dynamic.set("unitstandardcost", (Object)oldUnitStandardCost);
        }
        ctx = ShardingHintContext.create((String)"t_cal_calcostrecord", (ShardingHintContext.ShardingHintCondition[])new ShardingHintContext.ShardingHintCondition[]{new ShardingHintContext.ShardingHintCondition("fbizbillid", FilterType.eq, (Object)bizBillId)});
        Throwable throwable = null;
        try {
            ctx.set();
            SaveServiceHelper.save((DynamicObject[])costRecordBDetailArray);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            if (ctx != null) {
                if (throwable != null) {
                    try {
                        ctx.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                } else {
                    ctx.close();
                }
            }
        }
    }

    private Map<String, DynamicObject> buildCostRecordADetail(Map<String, DynamicObject> oldCostRecordDetailMap, Map<String, DynamicObject> costRecordADetailMap, DynamicObject newRecordA) {
        DynamicObject[] costRecordADetailArray;
        DynamicObjectCollection costRecordEntry = newRecordA.getDynamicObjectCollection("entry");
        DynamicObject localcurrency = newRecordA.getDynamicObject("localcurrency");
        int amtPrecision = localcurrency.getInt("amtprecision");
        int cSize = costRecordEntry.size();
        HashSet<Long> entryIds = new HashSet<Long>(cSize);
        HashMap<Long, Long> relationIdMap = new HashMap<Long, Long>(cSize);
        for (DynamicObject entry : costRecordEntry) {
            long entryId = entry.getLong("id");
            entryIds.add(entryId);
            relationIdMap.put(entryId, entry.getLong("ancestorentryid"));
        }
        for (DynamicObject dynamic : costRecordADetailArray = BusinessDataServiceHelper.load((String)"cal_costrecord_detail", (String)"id,entryid,costsubelement,actualcost,unitactualcost,costsubelement.id,baseqty,standardcost,unitstandardcost", (QFilter[])new QFilter("entryid", "in", entryIds).toArray())) {
            long entryId = dynamic.getLong("entryid");
            long ancestorEntryid = (Long)relationIdMap.get(entryId);
            long detailCostSubElemnetId = dynamic.getLong("costsubelement.id");
            DynamicObject oldCostRecordDetail = oldCostRecordDetailMap.get(ancestorEntryid + "_" + detailCostSubElemnetId);
            if (oldCostRecordDetail == null) continue;
            BigDecimal oldBaseqty = oldCostRecordDetail.getBigDecimal("baseqty");
            BigDecimal baseqty = dynamic.getBigDecimal("baseqty");
            BigDecimal oldUnitActualCost = oldCostRecordDetail.getBigDecimal("unitactualcost");
            BigDecimal oldActualCost = oldCostRecordDetail.getBigDecimal("actualcost");
            BigDecimal oldUnitStandardCost = oldCostRecordDetail.getBigDecimal("unitstandardcost");
            BigDecimal oldStandardCost = oldCostRecordDetail.getBigDecimal("standardcost");
            if (baseqty.compareTo(oldBaseqty) == 0) {
                dynamic.set("actualcost", (Object)oldActualCost);
                dynamic.set("standardcost", (Object)oldStandardCost);
            } else {
                dynamic.set("actualcost", (Object)oldUnitActualCost.multiply(baseqty).setScale(amtPrecision, 4));
                dynamic.set("standardcost", (Object)oldUnitStandardCost.multiply(baseqty).setScale(amtPrecision, 4));
            }
            dynamic.set("unitactualcost", (Object)oldUnitActualCost);
            dynamic.set("unitstandardcost", (Object)oldUnitStandardCost);
            costRecordADetailMap.put(ancestorEntryid + "_" + detailCostSubElemnetId, dynamic);
        }
        SaveServiceHelper.save((DynamicObject[])costRecordADetailArray);
        return costRecordADetailMap;
    }

    private void buildFatherDetails(DynamicObject oldCostRecordInfo, Map<String, DynamicObject> oldCostRecordDetailMap) {
        DynamicObjectCollection costRecordEntry = oldCostRecordInfo.getDynamicObjectCollection("entry");
        if (costRecordEntry == null) {
            return;
        }
        int cSize = costRecordEntry.size();
        HashSet<Long> entryIds = new HashSet<Long>(cSize);
        HashMap<Long, Long> relationIdMap = new HashMap<Long, Long>(cSize);
        for (DynamicObject entry : costRecordEntry) {
            entryIds.add(entry.getLong("id"));
            relationIdMap.put(entry.getLong("id"), entry.getLong("ancestorentryid"));
        }
        DynamicObjectCollection allCostRecordDetails = QueryServiceHelper.query((String)"cal_costrecord_detail", (String)"entryid,costelement.id,costsubelement.id,baseunit.id,baseqty,unitactualcost,actualcost,currency.priceprecision,standardcost,unitstandardcost", (QFilter[])new QFilter("entryid", "in", entryIds).toArray());
        if (allCostRecordDetails == null) {
            return;
        }
        for (DynamicObject dynamic : allCostRecordDetails) {
            long detailEntryId = dynamic.getLong("entryid");
            long detailCostSubElemnetId = dynamic.getLong("costsubelement.id");
            oldCostRecordDetailMap.put(relationIdMap.get(detailEntryId) + "_" + detailCostSubElemnetId, dynamic);
        }
    }
}

