/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.process.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dlock.DLock;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.bos.util.StringUtils;
import kd.fi.cal.business.calculate.out.FIFOCalculate;
import kd.fi.cal.business.calculate.out.IntimeBufferPoolHandle;
import kd.fi.cal.business.calculate.out.MoveAddAverageCalculate4Sync;
import kd.fi.cal.business.process.AbstractBizProcessor;
import kd.fi.cal.business.process.inner.CalMoveDlock;
import kd.fi.cal.business.process.inner.SyncOpLegalChecker;
import kd.fi.cal.common.constant.CalDbParamConstant;
import kd.fi.cal.common.enums.AccountTypeEnum;
import kd.fi.cal.common.enums.ActionEnum;
import kd.fi.cal.common.helper.CalDbParamServiceHelper;
import kd.fi.cal.common.helper.CalGroupAccountHelper;
import kd.fi.cal.common.helper.CommonSettingHelper;
import kd.fi.cal.common.helper.StopSyncBizBillHelper;
import kd.fi.cal.common.model.SynBillErrInfo;

public class UnCalMoveAddAverageProcess
extends AbstractBizProcessor {
    private Set<String> omInBills = new HashSet<String>(16);

    public void doProcessor(Map params, DynamicObject bill) {
        super.doProcessor(params, bill);
        if ("im_initbill".equals(bill.getDataEntityType().getName())) {
            return;
        }
        Long bizbillId = bill.getLong("id");
        QFilter q = new QFilter("bizbillid", "=", bill.getPkValue());
        new CalGroupAccountHelper().addNotGroupAcctFilter4Bill(q);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_costrecord", (String)"id,calorg", (QFilter[])q.toArray(), null).groupBy(new String[]{"calorg", "id"}).finish();){
            SynBillErrInfo errInfo;
            HashSet<Long> calOrgIds = new HashSet<Long>(8);
            for (Row row : dataSet) {
                Long calorgId = row.getLong("calorg");
                if (calorgId == null) continue;
                calOrgIds.add(calorgId);
            }
            HashSet<Long> hashSet = new HashSet<Long>(16);
            hashSet.add(bizbillId);
            Map stopSyncBizBillMap = new StopSyncBizBillHelper().doStop(hashSet, calOrgIds);
            if (stopSyncBizBillMap != null && (errInfo = (SynBillErrInfo)stopSyncBizBillMap.get(bizbillId)) != null && StringUtils.isNotEmpty((String)errInfo.getErrorMsg())) {
                throw new KDBizException(new ErrorCode("4", errInfo.getErrorMsg()), new Object[0]);
            }
        }
        DynamicObject[] bizBills = new DynamicObject[]{bill};
        SyncOpLegalChecker opCheck = new SyncOpLegalChecker(bizBills, ActionEnum.UN_AUDIT.getValue());
        opCheck.setCalProcessContext(this.calProcessContext);
        opCheck.setParams(params);
        opCheck.doCheck();
        if (opCheck.isCancel()) {
            return;
        }
        for (Map.Entry entry : opCheck.getErrMap().entrySet()) {
            this.addErrorMsg((Long)entry.getKey(), (SynBillErrInfo)entry.getValue());
        }
        Map successOpBizBillDycs = opCheck.getSuccessOpBizBillDycs();
        bizBills = successOpBizBillDycs.values().toArray(new DynamicObject[0]);
        if (bizBills.length < 1) {
            return;
        }
        HashSet<Long> hashSet = new HashSet<Long>();
        String entityName = "cal_costrecord";
        HashMap<Long, HashSet<Long>> map = new HashMap<Long, HashSet<Long>>();
        QFilter qs = new QFilter("bizbillid", "=", bill.getPkValue());
        qs.and("isinitbill", "=", (Object)false);
        qs.and("billstatus", "in", (Object)new String[]{"C", "D"});
        qs.and("issplitcreate", "=", (Object)Boolean.FALSE);
        qs.and("entry.accounttype", "in", (Object)new String[]{AccountTypeEnum.MOVE_ADD_AVERAGE.getValue(), AccountTypeEnum.FIN_FOUT.getValue()});
        qs.and("invscheme.isforwardamount", "=", (Object)Boolean.TRUE);
        qs.and("entry.invtype.isforwardamount", "=", (Object)Boolean.TRUE);
        qs.and("biztype", "not in", (Object)CommonSettingHelper.getNotUpdBalBizType());
        new CalGroupAccountHelper().addNotGroupAcctFilter4Bill(qs);
        QFilter[] filter = qs.toArray();
        DynamicObjectCollection coll = QueryServiceHelper.query((String)"cal_costrecord", (String)"id,bizbillid,calbilltype,auditdate,costaccount,entry.material as material,entry.accounttype as accounttype,entry.id as entryid,entry.bizbillentryid as bizbillentryid,bookdate,entry.queuetype as queuetype", (QFilter[])filter);
        if (coll.size() > 0) {
            for (DynamicObject info : coll) {
                hashSet.add(info.getLong("id"));
                long costAccountId = info.getLong("costaccount");
                HashSet<Long> idSet = (HashSet<Long>)map.get(costAccountId);
                if (idSet != null) {
                    idSet.add(info.getLong("id"));
                    continue;
                }
                idSet = new HashSet<Long>();
                idSet.add(info.getLong("id"));
                map.put(costAccountId, idSet);
            }
            Map keyLockMap = new HashMap(16);
            if (CalDbParamServiceHelper.getBoolean((String)CalDbParamConstant.ENTRY_SPLIT_INTIME_CAL).booleanValue()) {
                DynamicObjectCollection calCostRecDycs = this.getPosCalEntryIds(bill, hashSet, coll);
                IntimeBufferPoolHandle handle = new IntimeBufferPoolHandle(calCostRecDycs, "cal_costrecord_subentity", ActionEnum.UN_AUDIT.getValue(), false);
                handle.insertIntoPool();
                this.calProcessContext.putCustomerParams("bufferPoolBizBills", handle.getBufferPoolBizBillids());
                return;
            }
            HashSet<Long> bizBillIds = new HashSet<Long>(1);
            bizBillIds.add((Long)bill.getPkValue());
            CalMoveDlock calMoveDlock = new CalMoveDlock();
            calMoveDlock.setHasKeyLockMap(this.calProcessContext.getLockMap());
            keyLockMap = calMoveDlock.addLockBatchByCostRecord(bizBillIds);
            for (Map.Entry keyLockEntry : keyLockMap.entrySet()) {
                this.addLock((String)keyLockEntry.getKey(), (DLock)keyLockEntry.getValue());
            }
            String bizBillEntity = bill.getDataEntityType().getName();
            if (!hashSet.isEmpty()) {
                Long[] calCostRecordEntryIds = this.getCalBlueOmInCostRecordEntryId(bizBillEntity, hashSet);
                this.doUnCalMove(hashSet, entityName, calCostRecordEntryIds);
            }
            for (Map.Entry entry : map.entrySet()) {
                Long[] calCostRecordEntryIds = this.getCalBlueOmInCostRecordEntryId(bizBillEntity, (Set)entry.getValue());
                long costAccountId = (Long)entry.getKey();
                TraceSpan span = Tracer.create((String)("fifoCal.calculate-" + ((Set)entry.getValue()).size()), (String)"fifoCal.calculate-");
                Throwable throwable = null;
                try {
                    FIFOCalculate cal1 = new FIFOCalculate(((Set)entry.getValue()).toArray(new Long[0]), entityName, "0", costAccountId);
                    cal1.setBillEntryIds(calCostRecordEntryIds);
                    cal1.calculate();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (span == null) continue;
                    if (throwable != null) {
                        try {
                            span.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    span.close();
                }
            }
        }
    }

    private void doUnCalMove(Set<Long> billIds, String entityName, Long[] calCostRecordEntryIds) {
        DataSet dataSet;
        MoveAddAverageCalculate4Sync calMov = new MoveAddAverageCalculate4Sync(billIds.toArray(new Long[0]), calCostRecordEntryIds, entityName, "0");
        Collection<Object[]> errorBillInfo = calMov.doCalculate(dataSet = calMov.beforeCalculate());
        if (errorBillInfo != null) {
            StringBuilder errorMsgSb = new StringBuilder();
            for (Object[] objs : errorBillInfo) {
                String errorMsg = (String)objs[1];
                errorMsgSb.append(errorMsg).append("\r\n");
            }
            if (errorMsgSb.length() > 0) {
                throw new KDBizException(errorMsgSb.toString());
            }
        }
    }

    private Long[] getCalBlueOmInCostRecordEntryId(String bizBillEntity, Set<Long> costRecordIds) {
        HashSet<Long> calCostRecordEntryIds = null;
        this.omInBills = CommonSettingHelper.getBizEntityNumbers((String)"ominbiztype");
        if (this.omInBills.contains(bizBillEntity)) {
            calCostRecordEntryIds = new HashSet<Long>(16);
            QFilter idf = new QFilter("id", "in", costRecordIds);
            idf.and(new QFilter("entry.iscalculated", "=", (Object)Boolean.TRUE));
            try (DataSet calCostRecordDs = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_costrecord", (String)"entry.id", (QFilter[])idf.toArray(), null);){
                for (Row row : calCostRecordDs) {
                    calCostRecordEntryIds.add(row.getLong("entry.id"));
                }
            }
        }
        Long[] billEntryIds = null;
        if (calCostRecordEntryIds != null) {
            billEntryIds = calCostRecordEntryIds.toArray(new Long[0]);
        }
        return billEntryIds;
    }

    public Long getOrgId(MainEntityType entityType, DynamicObject bizBillDyc) {
        String orgName = entityType.getMainOrg();
        Long orgId = null;
        if (StringUtils.isNotEmpty((String)orgName)) {
            orgId = bizBillDyc.getLong(orgName + "_id");
        } else if (entityType.getProperties().containsKey((Object)"org")) {
            orgId = bizBillDyc.getLong("org_id");
        }
        return orgId;
    }

    private List<Long> getCostRecordBillInvOrgIdList(Set<Long> bizBillIds) {
        HashSet<Long> invOrgIdSet = new HashSet<Long>(16);
        QFilter filter = new QFilter("bizbillid", "in", bizBillIds);
        filter.and("entryentity.accounttype", "=", (Object)AccountTypeEnum.MOVE_ADD_AVERAGE.getValue());
        try (DataSet adjustBillDs = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_costrecord", (String)"storageorgunit", (QFilter[])filter.toArray(), null);){
            for (Row row : adjustBillDs) {
                invOrgIdSet.add(row.getLong("storageorgunit"));
            }
        }
        ArrayList<Long> invOrgIdList = new ArrayList<Long>(invOrgIdSet);
        Collections.sort(invOrgIdList);
        return invOrgIdList;
    }

    private DynamicObjectCollection getPosCalEntryIds(DynamicObject bill, Set<Long> costRecordIds, DynamicObjectCollection coll) {
        DynamicObjectCollection calCostRecDycs = new DynamicObjectCollection();
        String bizBillEntity = bill.getDataEntityType().getName();
        Long[] calCostRecordEntryIds = this.getCalBlueOmInCostRecordEntryId(bizBillEntity, costRecordIds);
        if (calCostRecordEntryIds != null) {
            HashSet<Long> calEntryIds = new HashSet<Long>(Arrays.asList(calCostRecordEntryIds));
            for (DynamicObject costRecDyc : coll) {
                if (!calEntryIds.contains(costRecDyc.getLong("entryid"))) continue;
                calCostRecDycs.add((Object)costRecDyc);
            }
        } else {
            calCostRecDycs = coll;
        }
        return calCostRecDycs;
    }
}

