/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.common.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;

public class AccountingSysHelper {
    public static DynamicObjectCollection getAccountingSysColls(List<Long> orgList, String accountSysSelects) {
        QFilter bizOrgQf = new QFilter("bizorgentry.bizorg", "<>", (Object)0L);
        if (orgList != null) {
            bizOrgQf.and("bizorgentry.bizacctorg", "in", orgList);
        }
        return AccountingSysHelper.getAccountingSysColls(bizOrgQf, accountSysSelects);
    }

    public static Map<Long, Set<Long>> getOwnersByCalorgIds(Set<Long> calorgIds) {
        DynamicObjectCollection collection = AccountingSysHelper.getAccountingSysColls(Arrays.asList(calorgIds.toArray(new Long[0])), null);
        HashMap<Long, Set<Long>> calorg2OwneridMap = new HashMap<Long, Set<Long>>(16);
        for (DynamicObject dynamicObject : collection) {
            Long calorgid = dynamicObject.getLong("calorgid");
            Long ownerid = dynamicObject.getLong("ownerid");
            Set ownerids = calorg2OwneridMap.computeIfAbsent(calorgid, k -> new HashSet(16));
            ownerids.add(ownerid);
        }
        return calorg2OwneridMap;
    }

    public static DynamicObjectCollection getAccountingSysCollsByOwner(Long ownerId, String accountSysSelects) {
        QFilter bizOrgQf = new QFilter("bizorgentry.bizorg", "=", (Object)ownerId);
        return AccountingSysHelper.getAccountingSysColls(bizOrgQf, accountSysSelects);
    }

    public static DataSet getAccountingSysDataSetByOwners(Collection<Long> ownerIds) {
        QFilter bizOrgQf = new QFilter("bizorgentry.bizorg", "in", ownerIds);
        String accountSysSelects = "id,number,name,bizorgentry.bizorg as owner,bizorgentry.bizorg.number as ownernumber,bizorgentry.bizorg.name as ownername,bizorgentry.bizacctorg as calorgid,bizorgentry.bizacctorg.number as calorgnumber,bizorgentry.bizacctorg.name as calorgname,bizorgentry.bizacctorg.number,bizorgentry.bizorg.number";
        DataSet ds = QueryServiceHelper.queryDataSet((String)AccountingSysHelper.class.getName(), (String)"bd_accountingsys", (String)accountSysSelects, (QFilter[])new QFilter[]{bizOrgQf}, (String)"number,bizorgentry.bizacctorg.number,bizorgentry.bizorg.number");
        return ds;
    }

    public static DataSet getAccountingSysCostaccountDataSetByOwners(Collection<Long> ownerIds) {
        DataSet accSysDS = AccountingSysHelper.getAccountingSysDataSetByOwners(ownerIds);
        HashSet<Long> calorgids = new HashSet<Long>(16);
        for (Row row : accSysDS.copy()) {
            calorgids.add(row.getLong("calorgid"));
        }
        QFilter filter = new QFilter("calorg", "in", calorgids);
        filter.and("enable", "=", (Object)true);
        DataSet costAccountDS = QueryServiceHelper.queryDataSet((String)AccountingSysHelper.class.getName(), (String)"cal_bd_costaccount", (String)"id as costaccount,calorg,booktype,booktype.isingroup as isingroup", (QFilter[])new QFilter[]{filter}, null);
        costAccountDS = accSysDS.join(costAccountDS, JoinType.INNER).on("calorgid", "calorg").select(new String[]{"owner"}, new String[]{"costaccount", "booktype", "isingroup"}).finish();
        return costAccountDS;
    }

    public static DynamicObjectCollection getAccountingSysColls(Long id, String accountSysSelects) {
        QFilter q = new QFilter("id", "=", (Object)id);
        return AccountingSysHelper.getAccountingSysColls(q, accountSysSelects);
    }

    public static DynamicObjectCollection getAccountingSysColls(QFilter q, String accountSysSelects) {
        if (accountSysSelects == null) {
            accountSysSelects = "id,number,name,bizorgentry.bizorg as ownerid,bizorgentry.bizorg.number as ownernumber,bizorgentry.bizorg.name as ownername,bizorgentry.bizacctorg as calorgid,bizorgentry.bizacctorg.number as calorgnumber,bizorgentry.bizacctorg.name as calorgname,bizorgentry.bizacctorg.number,bizorgentry.bizorg.number";
        }
        DynamicObjectCollection accSysColl = QueryServiceHelper.query((String)"bd_accountingsys", (String)accountSysSelects, (QFilter[])new QFilter[]{q}, (String)"number,bizorgentry.bizacctorg.number,bizorgentry.bizorg.number");
        return accSysColl;
    }

    public static Long[] getOwners(Long costAccountId) {
        DynamicObject costAccount = QueryServiceHelper.queryOne((String)"cal_bd_costaccount", (String)"id,calsystem,calorg", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)costAccountId)});
        long accSysId = costAccount.getLong("calsystem");
        long calOrgId = costAccount.getLong("calorg");
        DynamicObjectCollection accSysColl = BaseDataServiceHelper.getAccountingSysBizOrg((Long)accSysId, (Long[])new Long[]{calOrgId});
        ArrayList<Long> ownerList = new ArrayList<Long>();
        for (DynamicObject info : accSysColl) {
            ownerList.add(info.getLong("bizorg"));
        }
        ownerList.sort(Comparator.naturalOrder());
        return ownerList.toArray(new Long[0]);
    }

    public static Long[] getCostAccounts(Long ownerId) {
        DynamicObjectCollection coll = AccountingSysHelper.getAccountingSysCollsByOwner(ownerId, null);
        HashSet<Long> costAccountIdSet = new HashSet<Long>();
        QFilter q = QFilter.of((String)"1 <> 1", (Object[])new Object[0]);
        for (DynamicObject info : coll) {
            long calSystemId = info.getLong("id");
            long calOrgId = info.getLong("calorgid");
            QFilter q1 = new QFilter("calsystem", "=", (Object)calSystemId);
            q1.and("calorg", "=", (Object)calOrgId);
            q.or(q1);
        }
        DynamicObjectCollection costAccountColl = QueryServiceHelper.query((String)"cal_bd_costaccount", (String)"id,calsystem,calorg", (QFilter[])new QFilter[]{q});
        for (DynamicObject info : costAccountColl) {
            costAccountIdSet.add(info.getLong("id"));
        }
        return costAccountIdSet.toArray(new Long[0]);
    }

    public static Long[] getCalOrgIds(Long ownerId) {
        if (ownerId == null || ownerId.equals(0L)) {
            return new Long[0];
        }
        HashSet<Long> calOrgIds = new HashSet<Long>(16);
        Long[] costAccountIds = AccountingSysHelper.getCostAccounts(ownerId);
        if (costAccountIds.length > 0) {
            QFilter costAccoutIdFilter = new QFilter("id", "in", (Object)costAccountIds);
            DynamicObjectCollection costAccountDycs = QueryServiceHelper.query((String)"cal_bd_costaccount", (String)"calorg", (QFilter[])new QFilter[]{costAccoutIdFilter}, null);
            for (DynamicObject costRecordDyc : costAccountDycs) {
                calOrgIds.add(costRecordDyc.getLong("calorg"));
            }
        }
        return calOrgIds.toArray(new Long[0]);
    }

    public static Long[] getCalOrgIds(Set<Long> calOrgIds) {
        if (calOrgIds == null || calOrgIds.isEmpty()) {
            return new Long[0];
        }
        HashSet<Long> hasAccountCalOrgIds = new HashSet<Long>(16);
        QFilter costAccoutIdFilter = new QFilter("calorg", "in", calOrgIds);
        DynamicObjectCollection costAccountDycs = QueryServiceHelper.query((String)"cal_bd_costaccount", (String)"calorg", (QFilter[])new QFilter[]{costAccoutIdFilter}, null);
        for (DynamicObject costRecordDyc : costAccountDycs) {
            hasAccountCalOrgIds.add(costRecordDyc.getLong("calorg"));
        }
        return hasAccountCalOrgIds.toArray(new Long[0]);
    }

    public static Date getCurrentPeriodMaxDateByOwner(long ownerId) {
        DynamicObjectCollection accSysColl = AccountingSysHelper.getAccountingSysCollsByOwner(ownerId, null);
        QFilter q = QFilter.of((String)"1 <> 1", (Object[])new Object[0]);
        for (DynamicObject accSysInfo : accSysColl) {
            QFilter q1 = new QFilter("entry.costaccount.calsystem", "=", accSysInfo.get("id"));
            q1.and("entry.costaccount.calorg", "=", accSysInfo.get("calorgid"));
            q.or(q1);
        }
        String fields = "org,entry.currentperiod,entry.currentperiod.begindate,entry.currentperiod.enddate";
        DynamicObjectCollection sysPeriodColl = QueryServiceHelper.query((String)"cal_sysctrlentity", (String)fields, (QFilter[])new QFilter[]{q}, (String)"entry.currentperiod.begindate desc", (int)1);
        if (sysPeriodColl.size() > 0) {
            Date maxBeginDate = ((DynamicObject)sysPeriodColl.get(0)).getDate("entry.currentperiod.begindate");
            return maxBeginDate;
        }
        return null;
    }

    public static Date getCurrentPeriodMaxDateByOrg(long orgId) {
        QFilter q = new QFilter("entry.costaccount.calorg", "=", (Object)orgId);
        q.and("entry.isenabled", "=", (Object)true);
        String fields = "org,entry.currentperiod,entry.currentperiod.begindate,entry.currentperiod.enddate";
        DynamicObjectCollection sysPeriodColl = QueryServiceHelper.query((String)"cal_sysctrlentity", (String)fields, (QFilter[])new QFilter[]{q}, (String)"entry.currentperiod.begindate desc", (int)1);
        if (sysPeriodColl.size() > 0) {
            Date maxBeginDate = ((DynamicObject)sysPeriodColl.get(0)).getDate("entry.currentperiod.begindate");
            return maxBeginDate;
        }
        return null;
    }

    public static Map<Long, Date> getCurrentPeriodsMaxDateByOrg(long orgId) {
        QFilter q = new QFilter("entry.costaccount.calorg", "=", (Object)orgId);
        q.and("entry.isenabled", "=", (Object)true);
        String fields = "entry.currentperiod.begindate,entry.costaccount";
        DynamicObjectCollection sysPeriodColl = QueryServiceHelper.query((String)"cal_sysctrlentity", (String)fields, (QFilter[])new QFilter[]{q}, null);
        HashMap<Long, Date> maxBeginDates = new HashMap<Long, Date>(16);
        for (DynamicObject sysPeriod : sysPeriodColl) {
            Date maxBeginDate = sysPeriod.getDate("entry.currentperiod.begindate");
            maxBeginDates.put(sysPeriod.getLong("entry.costaccount"), maxBeginDate);
        }
        return maxBeginDates;
    }

    public static Set<Long> getOwnerIdsByCalOrg(Long calorgid) {
        QFilter bizOrgQf = new QFilter("bizorgentry.bizacctorg", "=", (Object)calorgid);
        DynamicObjectCollection accountSysColls = AccountingSysHelper.getAccountingSysColls(bizOrgQf, "number,bizorgentry.bizacctorg.number,bizorgentry.bizorg.number,bizorgentry.bizorg as ownerid");
        HashSet<Long> ownerids = new HashSet<Long>(16);
        for (DynamicObject accountSysColl : accountSysColls) {
            ownerids.add(accountSysColl.getLong("ownerid"));
        }
        return ownerids;
    }

    public static Map<Long, String> getAssociationCostAccountNameMap(Set<Long> costAccountids) {
        String name;
        Long id;
        QFilter filter = QFilter.of((String)"1=1", (Object[])new Object[0]);
        if (costAccountids != null && !costAccountids.isEmpty()) {
            filter.and("id", "in", costAccountids);
        }
        HashMap<Long, String> map = new HashMap<Long, String>(4);
        HashSet<Long> booktypes = new HashSet<Long>(6);
        try (DataSet costAccountDs = QueryServiceHelper.queryDataSet((String)AccountingSysHelper.class.getName(), (String)"cal_bd_costaccount", (String)"id,name,booktype,booktype.isingroup as isingroup", (QFilter[])filter.toArray(), null);){
            for (Row row : costAccountDs) {
                id = row.getLong("id");
                name = row.getString("name");
                map.put(id, name);
                boolean isingroup = row.getBoolean("isingroup");
                if (!isingroup) continue;
                booktypes.add(row.getLong("booktype"));
            }
        }
        if (costAccountids != null && !costAccountids.isEmpty() && !booktypes.isEmpty()) {
            filter = new QFilter("enable", "=", (Object)true);
            filter.and("booktype", "in", booktypes);
            costAccountDs = QueryServiceHelper.queryDataSet((String)AccountingSysHelper.class.getName(), (String)"cal_bd_costaccount", (String)"id,name", (QFilter[])filter.toArray(), null);
            var5_5 = null;
            try {
                for (Row row : costAccountDs) {
                    id = row.getLong("id");
                    name = row.getString("name");
                    map.put(id, name);
                }
            }
            catch (Throwable throwable) {
                var5_5 = throwable;
                throw throwable;
            }
            finally {
                if (costAccountDs != null) {
                    if (var5_5 != null) {
                        try {
                            costAccountDs.close();
                        }
                        catch (Throwable throwable) {
                            var5_5.addSuppressed(throwable);
                        }
                    } else {
                        costAccountDs.close();
                    }
                }
            }
        }
        return map;
    }

    public static Set<Long> getAllEnableAcctIds() {
        HashSet<Long> acctIds = new HashSet<Long>(16);
        QFilter acctF = new QFilter("enable", "=", (Object)Boolean.TRUE);
        try (DataSet acctDs = QueryServiceHelper.queryDataSet((String)AccountingSysHelper.class.getName(), (String)"cal_bd_costaccount", (String)"id", (QFilter[])acctF.toArray(), null);){
            for (Row row : acctDs) {
                acctIds.add(row.getLong("id"));
            }
        }
        return acctIds;
    }

    public static boolean isHasAcctType(Set<Long> acctIds, Set<String> accTypes) {
        boolean hasAcctType = false;
        QFilter rangeAcctIdF = new QFilter("costaccount", "in", acctIds);
        rangeAcctIdF.and("accounttype", "in", accTypes);
        rangeAcctIdF.and("status", "=", (Object)"C");
        rangeAcctIdF.and("enable", "=", (Object)Boolean.TRUE);
        boolean existCalRange = QueryServiceHelper.exists((String)"cal_bd_calrange", (QFilter[])rangeAcctIdF.toArray());
        if (existCalRange) {
            hasAcctType = true;
        }
        QFilter matAcctAcctIdF = new QFilter("calrange.costaccount", "in", acctIds);
        matAcctAcctIdF.and("entry.accounttype", "in", accTypes);
        matAcctAcctIdF.and("status", "=", (Object)"C");
        matAcctAcctIdF.and("enable", "=", (Object)Boolean.TRUE);
        boolean existMatAcct = QueryServiceHelper.exists((String)"cal_bd_accounttype", (QFilter[])matAcctAcctIdF.toArray());
        if (existMatAcct) {
            hasAcctType = true;
        }
        return hasAcctType;
    }
}

