/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.newreport.stockdetaildailyrpt.query;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.bplat.scmc.report.conf.ReportConf;
import kd.bplat.scmc.report.conf.SrcBlockConf;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.core.tpl.IDataTransform;
import kd.bplat.scmc.report.core.tpl.IDataXTransform;
import kd.bplat.scmc.report.core.tpl.IReportDataHandle;
import kd.bplat.scmc.report.util.ReportUtil;
import kd.fi.cal.common.enums.AccountTypeEnum;
import kd.fi.cal.common.helper.CommonSettingHelper;
import kd.fi.cal.report.newreport.base.CalBaseRptParam;
import kd.fi.cal.report.newreport.base.NewReportDataHelper;
import kd.fi.cal.report.newreport.base.ToCharFieldDataTransform;
import kd.fi.cal.report.newreport.stockcostgatherrpt.StockCostGatherQueryHelper;
import kd.fi.cal.report.newreport.stockdetaildailyrpt.StockDetailDailyRptParam;
import kd.fi.cal.report.newreport.stockdetaildailyrpt.handler.CalBalTransform;
import kd.fi.cal.report.newreport.stockdetaildailyrpt.handler.CalBalanceTransform;
import kd.fi.cal.report.newreport.stockdetaildailyrpt.handler.CostAdjustTransform;
import kd.fi.cal.report.newreport.stockdetaildailyrpt.handler.CostDiffTransform;
import kd.fi.cal.report.newreport.stockdetaildailyrpt.handler.CostRecordTransform;
import kd.fi.cal.report.newreport.stockdetaildailyrpt.handler.FilterTransform;
import kd.fi.cal.report.newreport.stockdetaildailyrpt.handler.FinalDataAmtTransform;
import kd.fi.cal.report.newreport.stockdetaildailyrpt.handler.FinalDataOrderTansform;
import kd.fi.cal.report.newreport.stockdetaildailyrpt.handler.PeriodEndTransform;
import kd.fi.cal.report.newreport.stockdetaildailyrpt.handler.RealStartPeriodTransform;
import kd.fi.cal.report.newreport.stockdetaildailyrpt.handler.StartPeriodTransform;
import kd.fi.cal.report.newreport.stockdetaildailyrpt.mapfunction.AddMaterialGroupTransform;

public class StockDetailDailyRptResourceCfg
implements IReportDataHandle {
    private static final List<String> SPBILLS = Arrays.asList("im_adjustbill", "im_assembbill", "im_locationtransfer", "im_disassemblebill");
    private static final Log logger = LogFactory.getLog(StockDetailDailyRptResourceCfg.class);
    private StockDetailDailyRptParam stockDetailDailyParam;
    private static final String[] qty = new String[]{"periodinqty", "periodinprice", "periodinamount", "periodoutqty", "periodoutprice", "periodoutamount", "periodendqty", "periodendprice", "periodendamount"};
    private static String[] COSTRECORDPARAM = new String[]{"entry.material", "storageorgunit", "entry.warehouse", "entry.location", "entry.project", "entry.invtype", "entry.invstatus", "entry.warehouse.group", "entry.lot", "entry.calrange", "entry.accounttype", "entry.tracknumber", "entry.stocktype"};
    private static String[] COSTADJUSTBILLPARAM = new String[]{"entryentity.material", "entryentity.storageorgunit", "entryentity.warehouse", "entryentity.location", "entryentity.project", "entryentity.invtype", "entryentity.invstatus", "entryentity.warehouse.group", "entryentity.lot", "entryentity.calrange", "entryentity.accounttype", "entryentity.tracknumber", "entryentity.stocktype"};
    private static String[] BALANCEPARAM = new String[]{"material", "storageorgunit", "warehouse", "location", "project", "invtype", "invstatus", "warehouse.group", "lot", "calrange", "accounttype", "tracknumber", "stocktype"};
    private static final String[] backGroundKeepField = new String[]{"year", "month", "unitprice", "billid", "bizentityobject", "linetype", "invtype", "invtype.name", "invtypecode", "invstatus", "invstatus.name", "invstatuscode", "invtype.number", "invstatus.number"};
    private static final String[] calBalanceGroup = new String[]{"calorg", "costaccount", "material"};
    private static final String[] billNoDataLegalFilterGroup = new String[]{"calorg", "costaccount", "material", "year", "month"};
    private static final String[] helpOrderField = new String[]{"priorityorder", "priorityorder_first", "entryid", "cur_index_adjust"};
    private static final String[] periodOrder = new String[]{"calorg", "costaccount", "material", "priorityorder_first", "priorityorder", "year", "month", "bizdate", "bookdate", "audittime"};
    private static final String[] periodOrderSumTop = new String[]{"calorg", "costaccount", "material", "priorityorder desc", "priorityorder_first", "year", "month", "bizdate", "bookdate", "audittime"};
    private static final String[] backGroundField = new String[]{"month", "periodendactualcost", "periodbeginqty", "periodbeginactualcost", "periodinqtybak", "periodinamountbak", "yearinqty", "yearinactualcost", "yearissueqty", "yearissueactualcost", "yearincostdiff", "yearissuecostdiff", "yearissuecost", "yearincost", "accounttype", "difftype", "createtype", "adjustamt", "auditdate", "baseqty", "standardcost", "actualcost", "unitstandardcost", "unitactualcost"};
    private static final String[][] engageFields = new String[][]{helpOrderField, backGroundKeepField, backGroundField};
    private Set<String> spBills = new HashSet<String>();
    private LocaleString locale_periodBegin = new LocaleString(this.getLocale_periodBegin());
    private LocaleString locale_periodIn = new LocaleString(this.getLocale_periodIn());
    private LocaleString locale_periodOut = new LocaleString(this.getLocale_periodOut());
    private LocaleString locale_periodEnd = new LocaleString(this.getLocale_periodEnd());

    private String getLocale_startPeriodRest() {
        return ResManager.loadKDString((String)"\u671f\u521d\u4f59\u989d", (String)"StockDetailRptQueryPlugin_14", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_periodTotal() {
        return ResManager.loadKDString((String)"\u5c0f\u8ba1", (String)"StockCostDetailRptQueryPlugin_11", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_periodBegin() {
        return ResManager.loadKDString((String)"\u671f\u521d\u7ed3\u5b58", (String)"StockGatherRptQueryPlugin_21", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_periodIn() {
        return ResManager.loadKDString((String)"\u672c\u671f\u6536\u5165", (String)"StockGatherRptQueryPlugin_22", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_periodOut() {
        return ResManager.loadKDString((String)"\u672c\u671f\u53d1\u51fa", (String)"StockGatherRptQueryPlugin_23", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_periodEnd() {
        return ResManager.loadKDString((String)"\u671f\u672b\u7ed3\u5b58", (String)"StockGatherRptQueryPlugin_24", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_costAdjustName() {
        return ResManager.loadKDString((String)"\u6210\u672c\u8c03\u6574\u5355", (String)"StockDetailRptQueryPlugin_13", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_stdDiffName() {
        return ResManager.loadKDString((String)"\u6807\u51c6\u6210\u672c\u5dee\u5f02\u5355", (String)"StockDetailRptQueryPlugin_23", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    public void setupCtx(ReportDataCtx ctx) {
        logger.info("stockDetailDaily query start");
        ctx.setShowBlockEntity(false);
        Set showKeyCols = ctx.getShowKeyCols();
        Set showQtyCols = ctx.getShowQtyCols();
        Set amtFields = ReportUtil.filterBigtableCols((ReportConf)ctx.getReportConf(), colConf -> "B".equals(colConf.getCalType()));
        HashSet<String> qtyFields = new HashSet<String>(Arrays.asList(qty));
        amtFields.addAll(qtyFields);
        amtFields.addAll(showQtyCols);
        ctx.setShowQtyCols(amtFields);
        Set keyFields = ReportUtil.filterBigtableCols((ReportConf)ctx.getReportConf(), colConf -> "A".equals(colConf.getCalType()));
        keyFields.addAll(showKeyCols);
        ctx.setShowKeyCols(keyFields);
        this.stockDetailDailyParam = (StockDetailDailyRptParam)ctx.getParam(StockDetailDailyRptParam.class.getName());
        List fixed = ctx.getFixedFs();
        QFilter q = QFilter.of((String)"1 = 1", (Object[])new Object[0]);
        if (this.stockDetailDailyParam != null) {
            List valueFilter = this.stockDetailDailyParam.getValueFilter();
            if (valueFilter != null) {
                for (QFilter filter : valueFilter) {
                    q.and(filter);
                }
            }
            this.getBDMaterials(this.stockDetailDailyParam);
            ArrayList commonFix = new ArrayList(16);
            if (fixed == null) {
                ctx.setFixedFs(commonFix);
            } else {
                fixed.addAll(commonFix);
            }
        }
    }

    public void modifyBlocks(List<SrcBlockConf> blockCollector, ReportDataCtx ctx) {
        ArrayList<SrcBlockConf> result = new ArrayList<SrcBlockConf>();
        if (this.stockDetailDailyParam == null) {
            return;
        }
        boolean isNewBalance = this.stockDetailDailyParam.isNewBalance();
        for (SrcBlockConf blockConf : blockCollector) {
            boolean showStd;
            String tableName = blockConf.getSrcEntity();
            Set costAccountIds = this.stockDetailDailyParam.getCostAccountIds();
            long costaccountId = costAccountIds.stream().findFirst().orElse(0L);
            DynamicObject periodDyc = StockCostGatherQueryHelper.getYearPeriodByDate((Object)costaccountId, (Date)this.stockDetailDailyParam.getBeginDate());
            int yearPeriod = periodDyc == null ? 1 : periodDyc.getInt("periodyear") * 100 + periodDyc.getInt("periodnumber");
            Date minBeginDate = periodDyc == null ? null : periodDyc.getDate("begindate");
            List periodNumber = this.stockDetailDailyParam.getPeriodNumber();
            if (periodNumber == null) {
                ArrayList<Integer> list = new ArrayList<Integer>();
                list.add(yearPeriod);
                this.stockDetailDailyParam.setPeriodNumber(list);
            } else if (!periodNumber.contains(yearPeriod)) {
                this.stockDetailDailyParam.getPeriodNumber().add(yearPeriod);
            }
            Set recSedTypes = this.stockDetailDailyParam.getRecSedTypes();
            Set sedSpBills = this.stockDetailDailyParam.getSedSpBills();
            Set recSpBills = this.stockDetailDailyParam.getRecSpBills();
            boolean allEmpty = sedSpBills.isEmpty() && recSpBills.isEmpty() && recSedTypes.isEmpty();
            boolean showAdj = allEmpty || sedSpBills.contains("cal_costadjustbill") || recSpBills.contains("cal_costadjustbill");
            boolean bl = showStd = allEmpty || sedSpBills.contains("cal_stdcostdiffbill") || recSpBills.contains("cal_stdcostdiffbill");
            if (!recSedTypes.isEmpty()) {
                if (sedSpBills.isEmpty() && recSpBills.isEmpty()) {
                    sedSpBills.removeAll(SPBILLS);
                    recSpBills.removeAll(SPBILLS);
                } else {
                    HashSet<String> spBills = new HashSet<String>(SPBILLS);
                    spBills.removeAll(sedSpBills);
                    spBills.removeAll(recSpBills);
                    if (!spBills.isEmpty()) {
                        sedSpBills.removeAll(spBills);
                        recSpBills.removeAll(spBills);
                    }
                }
            }
            switch (tableName) {
                case "cal_costrecord": {
                    QFilter costRecord_Filter = this.commonFilter(tableName, null, minBeginDate);
                    blockConf.setDataFs(costRecord_Filter);
                    blockConf.setAllowNotMatch(true);
                    Map srcColMap = blockConf.getRepoColSrcColMap();
                    srcColMap.put("entryid", "entryid");
                    blockConf.setRepoColSrcColMap(srcColMap);
                    Map repoColFullSrcColMap = blockConf.getRepoColFullSrcColMap();
                    repoColFullSrcColMap.put("entryid", "entry.id");
                    blockConf.setRepoColFullSrcColMap(repoColFullSrcColMap);
                    srcColMap = blockConf.getRepoColSrcColMap();
                    srcColMap.put("billid", "billid");
                    blockConf.setRepoColSrcColMap(srcColMap);
                    repoColFullSrcColMap = blockConf.getRepoColFullSrcColMap();
                    repoColFullSrcColMap.put("billid", "id");
                    blockConf.setRepoColFullSrcColMap(repoColFullSrcColMap);
                    List costRecordTransform = blockConf.getDataTransform();
                    if (costRecordTransform != null) {
                        costRecordTransform.add(new CostRecordTransform(ctx, this.stockDetailDailyParam));
                    }
                    result.add(blockConf);
                    break;
                }
                case "cal_costadjustbill": {
                    if (!showAdj) break;
                    QFilter costAdjust_Filter = this.commonFilter(tableName, null, minBeginDate);
                    blockConf.setDataFs(costAdjust_Filter);
                    blockConf.setAllowNotMatch(true);
                    Map srcColMap = blockConf.getRepoColSrcColMap();
                    srcColMap.put("entryid", "entryid");
                    blockConf.setRepoColSrcColMap(srcColMap);
                    Map repoColFullSrcColMap = blockConf.getRepoColFullSrcColMap();
                    repoColFullSrcColMap.put("entryid", "entryentity.id");
                    blockConf.setRepoColFullSrcColMap(repoColFullSrcColMap);
                    srcColMap = blockConf.getRepoColSrcColMap();
                    srcColMap.put("billid", "billid");
                    blockConf.setRepoColSrcColMap(srcColMap);
                    repoColFullSrcColMap = blockConf.getRepoColFullSrcColMap();
                    repoColFullSrcColMap.put("billid", "id");
                    blockConf.setRepoColFullSrcColMap(repoColFullSrcColMap);
                    List costAdjustTransform = blockConf.getDataTransform();
                    if (costAdjustTransform != null) {
                        costAdjustTransform.add(new CostAdjustTransform(this.getLocale_costAdjustName(), this.stockDetailDailyParam));
                    }
                    result.add(blockConf);
                    break;
                }
                case "cal_stdcostdiffbill": {
                    if (!showStd) break;
                    QFilter costDiff_Filter = this.commonFilter(tableName, null, minBeginDate);
                    blockConf.setDataFs(costDiff_Filter);
                    blockConf.setAllowNotMatch(true);
                    Map srcColMap = blockConf.getRepoColSrcColMap();
                    srcColMap.put("entryid", "entryid");
                    blockConf.setRepoColSrcColMap(srcColMap);
                    Map repoColFullSrcColMap = blockConf.getRepoColFullSrcColMap();
                    repoColFullSrcColMap.put("entryid", "entryentity.id");
                    blockConf.setRepoColFullSrcColMap(repoColFullSrcColMap);
                    srcColMap = blockConf.getRepoColSrcColMap();
                    srcColMap.put("billid", "billid");
                    blockConf.setRepoColSrcColMap(srcColMap);
                    repoColFullSrcColMap = blockConf.getRepoColFullSrcColMap();
                    repoColFullSrcColMap.put("billid", "id");
                    blockConf.setRepoColFullSrcColMap(repoColFullSrcColMap);
                    List costDiff = blockConf.getDataTransform();
                    if (costDiff != null) {
                        costDiff.add(new CostDiffTransform(this.getLocale_stdDiffName(), this.stockDetailDailyParam));
                    }
                    result.add(blockConf);
                    break;
                }
                case "cal_balance": {
                    if (isNewBalance) break;
                    SrcBlockConf curBalance = new SrcBlockConf();
                    curBalance.setDefVals(blockConf.getDefVals());
                    curBalance.setRepoColFullSrcColMap(blockConf.getRepoColFullSrcColMap());
                    curBalance.setRepoColSrcColMap(blockConf.getRepoColSrcColMap());
                    curBalance.setSrcEntity(blockConf.getSrcEntity());
                    curBalance.setType(blockConf.getType());
                    curBalance.setAllowNotMatch(true);
                    QFilter calBalance_Filter = this.commonFilter(tableName, yearPeriod, null);
                    curBalance.setDataFs(calBalance_Filter);
                    List calBalanceTransform = curBalance.getDataTransform();
                    if (calBalanceTransform != null) {
                        calBalanceTransform.add(new CalBalanceTransform(Integer.valueOf(yearPeriod)));
                    }
                    result.add(curBalance);
                    break;
                }
                case "cal_bal": {
                    if (!isNewBalance) break;
                    SrcBlockConf curBal = new SrcBlockConf();
                    curBal.setDefVals(blockConf.getDefVals());
                    curBal.setRepoColFullSrcColMap(blockConf.getRepoColFullSrcColMap());
                    curBal.setRepoColSrcColMap(blockConf.getRepoColSrcColMap());
                    curBal.setSrcEntity(blockConf.getSrcEntity());
                    curBal.setType(blockConf.getType());
                    curBal.setAllowNotMatch(true);
                    QFilter calBal_Filter = this.commonFilter(tableName, yearPeriod, null);
                    curBal.setDataFs(calBal_Filter);
                    NewReportDataHelper.addNewBalDimCols((ReportDataCtx)ctx, (SrcBlockConf)curBal, (CalBaseRptParam)this.stockDetailDailyParam);
                    List calBalTransform = curBal.getDataTransform();
                    if (calBalTransform != null) {
                        calBalTransform.add(new CalBalTransform(Integer.valueOf(yearPeriod)));
                    }
                    result.add(curBal);
                }
            }
        }
        ctx.getReportConf().setSrcBlockConf(result);
    }

    public void transFormAfterUnion(List<IDataXTransform> transCollector, ReportDataCtx ctx) {
        transCollector.add((IDataXTransform)new StartPeriodTransform(this.stockDetailDailyParam, calBalanceGroup, this.getLocale_startPeriodRest(), ctx));
        transCollector.add((IDataXTransform)new AddMaterialGroupTransform(this.stockDetailDailyParam, ctx));
        transCollector.add((IDataXTransform)new RealStartPeriodTransform(this.stockDetailDailyParam, periodOrder, calBalanceGroup, ctx));
        transCollector.add((IDataXTransform)new PeriodEndTransform(this.stockDetailDailyParam, periodOrder, calBalanceGroup, this.getLocale_periodTotal(), ctx));
        transCollector.add((IDataXTransform)new FilterTransform(this.stockDetailDailyParam, calBalanceGroup, billNoDataLegalFilterGroup, ctx));
    }

    public void handleBigtableCols(Set<String> repoColFilter, ReportDataCtx ctx) {
        String[][] stringArray = engageFields;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String[] part;
            for (String engageField : part = stringArray[i]) {
                repoColFilter.add(engageField);
            }
        }
        repoColFilter.addAll(this.stockDetailDailyParam.getOtherBalDims());
    }

    public void beforeGroupData(ReportDataCtx ctx) {
        ctx.setGroupPlans(null);
    }

    public void transFormAfterGroup(List<IDataXTransform> transCollector, ReportDataCtx ctx) {
        ArrayList<String> waitForDelete = new ArrayList<String>(Arrays.asList(engageFields[2]));
        ArrayList<String> waitForOrder = new ArrayList<String>(Arrays.asList(periodOrder));
        ArrayList<String> waitForCalculate = new ArrayList<String>(Arrays.asList(engageFields[1]));
        waitForDelete.removeAll(waitForOrder);
        waitForDelete.removeAll(waitForCalculate);
        transCollector.add((IDataXTransform)new FinalDataAmtTransform(this.stockDetailDailyParam, ctx, waitForDelete));
    }

    public void transformResult(List<IDataTransform> transCollector, ReportDataCtx ctx) {
        boolean topsumrow = this.stockDetailDailyParam.isTopsumrow();
        String[] order = topsumrow ? periodOrderSumTop : periodOrder;
        transCollector.add((IDataTransform)new FinalDataOrderTansform(order));
        transCollector.add((IDataTransform)new ToCharFieldDataTransform("period"));
        this.stockDetailDailyParam.closeMaterialCategory();
    }

    public List<AbstractReportColumn> buildShowColumn(List<AbstractReportColumn> cols, ReportDataCtx ctx) {
        ArrayList<AbstractReportColumn> reslutcols = new ArrayList<AbstractReportColumn>(cols.size());
        ArrayList periodbegincols = new ArrayList();
        ArrayList<AbstractReportColumn> periodincols = new ArrayList<AbstractReportColumn>();
        ArrayList<AbstractReportColumn> periodOutcols = new ArrayList<AbstractReportColumn>();
        ArrayList<AbstractReportColumn> periodEndcols = new ArrayList<AbstractReportColumn>();
        HashSet<String> shouldDelete = new HashSet<String>(16);
        shouldDelete.addAll(Arrays.asList(helpOrderField));
        HashSet<String> backGroundKeepField = new HashSet<String>(Arrays.asList(StockDetailDailyRptResourceCfg.backGroundKeepField));
        for (AbstractReportColumn abstractReportColumn : cols) {
            ReportColumn reportCol = (ReportColumn)abstractReportColumn;
            String fieldKey = reportCol.getFieldKey();
            if (fieldKey.contains("periodin")) {
                reportCol.setZeroShow(false);
                reportCol.setNoDisplayScaleZero(false);
                periodincols.add(abstractReportColumn);
                continue;
            }
            if (fieldKey.contains("periodout")) {
                reportCol.setZeroShow(false);
                reportCol.setNoDisplayScaleZero(false);
                periodOutcols.add(abstractReportColumn);
                continue;
            }
            if (fieldKey.contains("periodend")) {
                reportCol.setZeroShow(false);
                reportCol.setNoDisplayScaleZero(false);
                periodEndcols.add(abstractReportColumn);
                continue;
            }
            if (backGroundKeepField.contains(fieldKey)) {
                ((ReportColumn)abstractReportColumn).setHide(true);
                reslutcols.add(abstractReportColumn);
                continue;
            }
            if (shouldDelete.contains(fieldKey)) continue;
            reslutcols.add(abstractReportColumn);
        }
        ReportColumnGroup begingroupCol = new ReportColumnGroup();
        begingroupCol.setCaption(this.locale_periodBegin);
        begingroupCol.setFieldKey("periodbegin");
        cols.add((AbstractReportColumn)begingroupCol);
        for (Object beginCol : periodbegincols) {
            begingroupCol.getChildren().add(beginCol);
        }
        reslutcols.add((AbstractReportColumn)begingroupCol);
        ReportColumnGroup reportColumnGroup = new ReportColumnGroup();
        reportColumnGroup.setCaption(this.locale_periodIn);
        reportColumnGroup.setFieldKey("periodin");
        cols.add((AbstractReportColumn)reportColumnGroup);
        for (Object inCol : periodincols) {
            reportColumnGroup.getChildren().add(inCol);
        }
        reslutcols.add((AbstractReportColumn)reportColumnGroup);
        ReportColumnGroup outgroupCol = new ReportColumnGroup();
        outgroupCol.setCaption(this.locale_periodOut);
        outgroupCol.setFieldKey("periodout");
        cols.add((AbstractReportColumn)outgroupCol);
        for (AbstractReportColumn abstractReportColumn : periodOutcols) {
            outgroupCol.getChildren().add(abstractReportColumn);
        }
        reslutcols.add((AbstractReportColumn)outgroupCol);
        ReportColumnGroup endgroupCol = new ReportColumnGroup();
        endgroupCol.setCaption(this.locale_periodEnd);
        endgroupCol.setFieldKey("periodend");
        cols.add((AbstractReportColumn)endgroupCol);
        for (AbstractReportColumn abstractReportColumn : periodEndcols) {
            endgroupCol.getChildren().add(abstractReportColumn);
        }
        reslutcols.add((AbstractReportColumn)endgroupCol);
        return reslutcols;
    }

    public QFilter commonFilter(String tableName, Integer periodNumber, Date beginDate) {
        QFilter q = QFilter.of((String)"1 = 1", (Object[])new Object[0]);
        Set costAccountIds = null;
        if (this.stockDetailDailyParam != null) {
            costAccountIds = this.stockDetailDailyParam.getCostAccountIds();
        }
        if (costAccountIds != null) {
            q = !costAccountIds.isEmpty() ? new QFilter("costaccount", "in", (Object)costAccountIds) : q;
        }
        Date endDate = this.stockDetailDailyParam == null ? null : this.stockDetailDailyParam.getEndDate();
        String ownerType = this.stockDetailDailyParam == null ? null : this.stockDetailDailyParam.getOwnerType();
        DynamicObjectCollection ownerFrom = this.stockDetailDailyParam == null ? null : this.stockDetailDailyParam.getOwnerFrom();
        String billNo = this.stockDetailDailyParam == null ? "" : this.stockDetailDailyParam.getBillno().trim();
        DynamicObjectCollection billtypes = this.stockDetailDailyParam == null ? null : this.stockDetailDailyParam.getBilltypes();
        Set recSedTypes = this.stockDetailDailyParam == null ? new HashSet(16) : this.stockDetailDailyParam.getRecSedTypes();
        Set sedSpBills = this.stockDetailDailyParam == null ? new HashSet(16) : this.stockDetailDailyParam.getSedSpBills();
        Set recSpBills = this.stockDetailDailyParam == null ? new HashSet(16) : this.stockDetailDailyParam.getRecSpBills();
        boolean allEmpty = recSedTypes.isEmpty() && sedSpBills.isEmpty() && recSpBills.isEmpty();
        String[] commonParamName = null;
        switch (tableName) {
            case "cal_costrecord": {
                q.and("bookdate", ">=", (Object)beginDate);
                q.and("bookdate", "<=", (Object)endDate);
                q.and("issplitcreate", "=", (Object)false);
                q.and("isinitbill", "=", (Object)false);
                Set notUpdBalBizType = CommonSettingHelper.getNotUpdBalBizType();
                if (!notUpdBalBizType.isEmpty()) {
                    q.and("biztype", "not in", (Object)notUpdBalBizType);
                }
                q.and("billstatus", "=", (Object)"C");
                if (!StringUtils.isEmpty((String)billNo)) {
                    q.and("billno", "in", (Object)billNo.split(","));
                }
                if (billtypes != null) {
                    HashSet<Object> set = new HashSet<Object>(billtypes.size());
                    for (DynamicObject info : billtypes) {
                        set.add(info.getPkValue());
                    }
                    q.and("billtype", "in", set);
                }
                QFilter finalFilter = null;
                if (!allEmpty) {
                    HashSet<String> cur = new HashSet<String>(SPBILLS);
                    QFilter spTypeFilter = null;
                    if (recSedTypes.size() > 0) {
                        spTypeFilter = new QFilter("invscheme.transceivertype", "in", recSedTypes);
                    }
                    QFilter spFilter = null;
                    if (recSpBills.size() <= 0 || sedSpBills.size() <= 0) {
                        if (recSpBills.size() > 0) {
                            cur.removeAll(recSpBills);
                            spFilter = new QFilter("calbilltype", "=", (Object)"IN");
                            spFilter.and(new QFilter("bizentityobject.id", "in", recSpBills));
                        }
                        if (sedSpBills.size() > 0) {
                            cur.removeAll(sedSpBills);
                            spFilter = new QFilter("calbilltype", "=", (Object)"OUT");
                            spFilter.and(new QFilter("bizentityobject.id", "in", sedSpBills));
                        }
                    } else {
                        HashSet allBizObject = new HashSet();
                        allBizObject.addAll(recSpBills);
                        allBizObject.addAll(sedSpBills);
                        if (!allBizObject.isEmpty()) {
                            spFilter = new QFilter("bizentityobject.id", "in", allBizObject);
                        }
                    }
                    if (!cur.isEmpty() && spTypeFilter != null) {
                        spTypeFilter.and(new QFilter("bizentityobject.id", "not in", cur));
                    }
                    if (spTypeFilter != null && spFilter != null) {
                        finalFilter = spTypeFilter.or(spFilter);
                    } else {
                        if (spTypeFilter != null) {
                            finalFilter = spTypeFilter;
                        }
                        if (spFilter != null) {
                            finalFilter = spFilter;
                        }
                    }
                }
                if (finalFilter != null) {
                    q.and(finalFilter);
                }
                StockDetailDailyRptResourceCfg.getOwnerFilterNew(q, ownerType, ownerFrom, "cal_costrecord");
                commonParamName = COSTRECORDPARAM;
                break;
            }
            case "cal_costadjustbill": {
                q.and("bookdate", ">=", (Object)beginDate);
                q.and("bookdate", "<=", (Object)endDate);
                q.and("billstatus", "=", (Object)"C");
                if (!StringUtils.isEmpty((String)billNo)) {
                    q.and("billno", "in", (Object)billNo.split(","));
                }
                q.and("isupdatecost", "=", (Object)"1");
                if (billtypes != null) {
                    HashSet<Object> set = new HashSet<Object>(billtypes.size());
                    for (DynamicObject info : billtypes) {
                        set.add(info.getPkValue());
                    }
                    q.and("billtype", "in", set);
                }
                q.and("entryentity.accounttype", "<>", (Object)AccountTypeEnum.STANDARDCOST.getValue());
                if (recSpBills.size() <= 0 || sedSpBills.size() <= 0) {
                    if (recSpBills.size() > 0) {
                        q.and(new QFilter("biztype", "=", (Object)"A"));
                    }
                    if (sedSpBills.size() > 0) {
                        q.and(new QFilter("biztype", "=", (Object)"B"));
                    }
                }
                StockDetailDailyRptResourceCfg.getOwnerFilterNew(q, ownerType, ownerFrom, "cal_costadjustbill");
                commonParamName = COSTADJUSTBILLPARAM;
                break;
            }
            case "cal_stdcostdiffbill": {
                q.and("bookdate", ">=", (Object)beginDate);
                q.and("bookdate", "<=", (Object)endDate);
                q.and("billstatus", "=", (Object)"C");
                if (!StringUtils.isEmpty((String)billNo)) {
                    q.and("billno", "in", (Object)billNo.split(","));
                }
                q.and("isupdatecost", "=", (Object)"1");
                if (billtypes != null) {
                    HashSet<Object> set = new HashSet<Object>(billtypes.size());
                    for (DynamicObject info : billtypes) {
                        set.add(info.getPkValue());
                    }
                    q.and("billtype", "in", set);
                }
                if (recSpBills.size() <= 0 || sedSpBills.size() <= 0) {
                    if (recSpBills.size() > 0) {
                        q.and(new QFilter("biztype", "=", (Object)"A"));
                    }
                    if (sedSpBills.size() > 0) {
                        q.and(new QFilter("biztype", "=", (Object)"B"));
                    }
                }
                StockDetailDailyRptResourceCfg.getOwnerFilterNew(q, ownerType, ownerFrom, "cal_costadjustbill");
                commonParamName = COSTADJUSTBILLPARAM;
                break;
            }
            case "cal_balance": {
                q.and("period", "<", (Object)periodNumber);
                q.and("endperiod", ">=", (Object)periodNumber);
                StockDetailDailyRptResourceCfg.getOwnerFilterNew(q, ownerType, ownerFrom, "cal_balance");
                commonParamName = BALANCEPARAM;
                break;
            }
            case "cal_bal": {
                q.and("period", "<", (Object)periodNumber);
                q.and("endperiod", ">=", (Object)periodNumber);
                StockDetailDailyRptResourceCfg.getOwnerFilterNew(q, ownerType, ownerFrom, "cal_bal");
                commonParamName = BALANCEPARAM;
                break;
            }
            default: {
                q.and("1", "<>", (Object)"1");
            }
        }
        if (commonParamName != null) {
            this.getCommonFix(q, commonParamName);
        }
        return q;
    }

    private List<QFilter> getCommonFix(QFilter q, String[] commonParamName) {
        ArrayList<QFilter> result = new ArrayList<QFilter>();
        DynamicObjectCollection storageOrgs = this.stockDetailDailyParam.getStorageOrgs();
        DynamicObjectCollection warehouses = this.stockDetailDailyParam.getWarehouses();
        DynamicObjectCollection locations = this.stockDetailDailyParam.getLocations();
        DynamicObjectCollection projects = this.stockDetailDailyParam.getProjects();
        DynamicObjectCollection tracknumbers = this.stockDetailDailyParam.getTracknumbers();
        DynamicObjectCollection invTypes = this.stockDetailDailyParam.getInvTypes();
        DynamicObjectCollection invStatuss = this.stockDetailDailyParam.getInvStatuss();
        DynamicObjectCollection matCategorys = this.stockDetailDailyParam.getMatcategory();
        Set warehouseGroupIds = this.stockDetailDailyParam.getWarehouseGroupIds();
        String[] lotIds = this.stockDetailDailyParam.getLotIds();
        DynamicObjectCollection calRange = this.stockDetailDailyParam.getCalRange();
        Set materialIdContainer = this.stockDetailDailyParam.getMaterialIdContainer();
        if (materialIdContainer != null && !materialIdContainer.isEmpty()) {
            q.and(commonParamName[0], "in", (Object)materialIdContainer);
        }
        q = this.setIds(storageOrgs, q, commonParamName[1]);
        q = this.setIds(warehouses, q, commonParamName[2]);
        q = this.setIds(locations, q, commonParamName[3]);
        q = this.setIds(projects, q, commonParamName[4]);
        q = this.setIds(invTypes, q, commonParamName[5]);
        q = this.setIds(invStatuss, q, commonParamName[6]);
        q = warehouseGroupIds != null && warehouseGroupIds.size() != 0 ? q.and(commonParamName[7], "in", (Object)warehouseGroupIds) : q;
        q = lotIds != null && lotIds.length != 0 ? q.and(commonParamName[8], "in", (Object)lotIds) : q;
        q = this.setIds(calRange, q, commonParamName[9]);
        q = this.setTracknumberIds(tracknumbers, q, commonParamName[11]);
        q = this.setIds(matCategorys, q, commonParamName[12]);
        result.add(q);
        return result;
    }

    private QFilter setTracknumberIds(DynamicObjectCollection tracknumbers, QFilter q, String multiParamIdName) {
        HashSet<Object> idContainer = new HashSet<Object>(16);
        if (tracknumbers != null && tracknumbers.size() != 0) {
            for (DynamicObject tracknumber : tracknumbers) {
                idContainer.add(tracknumber.getPkValue());
            }
            q = tracknumbers != null ? q.and(multiParamIdName, "in", idContainer) : q;
        }
        return q;
    }

    private QFilter setIds(DynamicObjectCollection multiParam, QFilter q, String multiParamIdName) {
        HashSet<Object> idContainer = new HashSet<Object>(16);
        if (multiParam != null && multiParam.size() != 0) {
            for (DynamicObject storageOrg : multiParam) {
                idContainer.add(storageOrg.getPkValue());
            }
            q = multiParam != null ? q.and(multiParamIdName, "in", idContainer) : q;
        }
        return q;
    }

    public static void getOwnerFilterNew(QFilter q, String filter_ownertype, DynamicObjectCollection filter_owner, String entityName) {
        if (StringUtils.isEmpty((String)filter_ownertype)) {
            return;
        }
        String entry = "";
        if ("cal_costrecord".equals(entityName)) {
            entry = "entry.";
        } else if ("cal_costadjustbill".equals(entityName)) {
            entry = "entryentity.";
        }
        q.and(entry + "ownertype", "=", (Object)filter_ownertype);
        if (filter_owner != null) {
            HashSet<Object> set = new HashSet<Object>(8);
            for (DynamicObject info : filter_owner) {
                set.add(info.getPkValue());
            }
            q.and(entry + "owner", "in", set);
        }
    }

    private void getBDMaterials(StockDetailDailyRptParam queryParam) {
        DynamicObjectCollection filter_materialFrom = queryParam.getMaterialFrom();
        DynamicObject filter_materialTo = queryParam.getMaterialTo();
        QFilter q = QFilter.of((String)"1=1", (Object[])new Object[0]);
        if (filter_materialFrom != null) {
            if (filter_materialFrom.size() > 1) {
                HashSet<Object> set = new HashSet<Object>(16);
                for (DynamicObject dynamicObject : filter_materialFrom) {
                    set.add(dynamicObject.getPkValue());
                }
                q.and("id", "in", set);
            } else {
                q.and("number", ">=", (Object)((DynamicObject)filter_materialFrom.get(0)).getString("number"));
            }
        }
        if (filter_materialTo != null) {
            q.and("number", "<=", (Object)filter_materialTo.getString("number"));
        }
        DynamicObjectCollection dynamicObjects = null;
        if (filter_materialFrom != null || filter_materialTo != null) {
            dynamicObjects = QueryServiceHelper.query((String)this.getClass().getName(), (String)"bd_material", (String)"id as material.id", (QFilter[])new QFilter[]{q}, null);
        }
        if (dynamicObjects != null && dynamicObjects.size() > 0) {
            HashSet<Long> idSet = new HashSet<Long>(dynamicObjects.size());
            for (DynamicObject balInfo : dynamicObjects) {
                long materialId = balInfo.getLong("material.id");
                if (materialId == 0L) continue;
                idSet.add(materialId);
            }
            this.stockDetailDailyParam.setMaterialIdContainer(idSet);
        }
    }
}

