/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.newreport.stockdetailrpt.query;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.bplat.scmc.report.conf.ReportConf;
import kd.bplat.scmc.report.conf.SrcBlockConf;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.core.tpl.IDataTransform;
import kd.bplat.scmc.report.core.tpl.IDataXTransform;
import kd.bplat.scmc.report.core.tpl.IReportDataHandle;
import kd.bplat.scmc.report.util.ReportUtil;
import kd.fi.cal.common.enums.AccountTypeEnum;
import kd.fi.cal.common.enums.CostAdjustBilCreateTypeEnum;
import kd.fi.cal.common.helper.CalBalanceModelHelper;
import kd.fi.cal.common.helper.CommonSettingHelper;
import kd.fi.cal.report.newreport.base.CalBaseRptParam;
import kd.fi.cal.report.newreport.base.NewReportDataHelper;
import kd.fi.cal.report.newreport.base.ToCharFieldDataTransform;
import kd.fi.cal.report.newreport.stockdetailrpt.StockDetailRptParam;
import kd.fi.cal.report.newreport.stockdetailrpt.formplugin.StockDetailNewRptFormPlugin;
import kd.fi.cal.report.newreport.stockdetailrpt.handler.AddMaterialGroupTransform;
import kd.fi.cal.report.newreport.stockdetailrpt.handler.BeginInObjectNameNoinDataxTransform;
import kd.fi.cal.report.newreport.stockdetailrpt.handler.BeginOutObjectNameNoinDataxTransform;
import kd.fi.cal.report.newreport.stockdetailrpt.handler.CalBalTransform;
import kd.fi.cal.report.newreport.stockdetailrpt.handler.CalBalanceTransform;
import kd.fi.cal.report.newreport.stockdetailrpt.handler.CombinePeriodTransform;
import kd.fi.cal.report.newreport.stockdetailrpt.handler.CombineTotalTransform;
import kd.fi.cal.report.newreport.stockdetailrpt.handler.CostAdjustTransform;
import kd.fi.cal.report.newreport.stockdetailrpt.handler.CostDiffTransform;
import kd.fi.cal.report.newreport.stockdetailrpt.handler.CostRecordTransform;
import kd.fi.cal.report.newreport.stockdetailrpt.handler.FinalDataOrderTansform;
import kd.fi.cal.report.newreport.stockdetailrpt.handler.FinalDataTransform;
import kd.fi.cal.report.newreport.stockdetailrpt.handler.InitBalanceTransform;
import kd.fi.cal.report.newreport.stockdetailrpt.handler.MaterialGroupCoverTransform;
import kd.fi.cal.report.newreport.stockdetailrpt.handler.PeriodTotalSumTransform;

public class StockDetailRptResourceCfg
implements IReportDataHandle {
    private static final Log logger = LogFactory.getLog(StockDetailRptResourceCfg.class);
    private StockDetailRptParam stockDetailParam;
    private static String[] COSTRECORDPARAM = new String[]{"entry.material", "storageorgunit", "entry.warehouse", "entry.location", "entry.project", "entry.invtype", "entry.invstatus", "entry.warehouse.group", "entry.lot", "entry.calrange", "entry.accounttype", "entry.tracknumber", "entry.stocktype"};
    private static String[] COSTADJUSTBILLPARAM = new String[]{"entryentity.material", "entryentity.storageorgunit", "entryentity.warehouse", "entryentity.location", "entryentity.project", "entryentity.invtype", "entryentity.invstatus", "entryentity.warehouse.group", "entryentity.lot", "entryentity.calrange", "entryentity.accounttype", "entryentity.tracknumber", "entryentity.stocktype"};
    private static String[] BALANCEPARAM = new String[]{"material", "storageorgunit", "warehouse", "location", "project", "invtype", "invstatus", "warehouse.group", "lot", "calrange", "accounttype", "tracknumber", "stocktype"};
    private static String[] top_standardCostOne_TYPE_BizFirst_Print = new String[]{"calorg", "costaccount", "material", "year", "period", "priorityorder desc", "priorityorder_first", "calbilltype", "bookdate", "audittime", "billid", "entryid", "cur_index_adjust"};
    private static String[] top_standardCostOne_TYPE_BizFirst_Print_detail = new String[]{"calorg", "costaccount", "material", "year", "period", "priorityorder desc", "priorityorder_first", "calbilltype", "bookdate", "audittime", "billid", "entryid", "cur_index_adjust", "costelement", "costsubelement", "orderline"};
    private static String[] top_standardCostOne_TYPE_BizFirst = new String[]{"calorg", "costaccount", "year", "period", "material", "priorityorder desc", "priorityorder_first", "calbilltype", "bookdate", "audittime", "billid", "entryid", "cur_index_adjust"};
    private static String[] top_standardCostOne_TYPE_BizFirst_detail = new String[]{"calorg", "costaccount", "year", "period", "material", "priorityorder desc", "priorityorder_first", "calbilltype", "bookdate", "audittime", "billid", "entryid", "cur_index_adjust", "costelement", "costsubelement", "orderline"};
    private static String[] top_standardCostOne_TYPE_AuditFirst_Print = new String[]{"calorg", "costaccount", "material", "year", "period", "priorityorder desc", "priorityorder_first", "calbilltype", "audittime", "bookdate", "billid", "entryid", "cur_index_adjust"};
    private static String[] top_standardCostOne_TYPE_AuditFirst_Print_detail = new String[]{"calorg", "costaccount", "material", "year", "period", "priorityorder desc", "priorityorder_first", "calbilltype", "audittime", "bookdate", "billid", "entryid", "cur_index_adjust", "costelement", "costsubelement", "orderline"};
    private static String[] top_standardCostOne_TYPE_AuditFirst = new String[]{"calorg", "costaccount", "year", "period", "material", "priorityorder desc", "priorityorder_first", "calbilltype", "audittime", "bookdate", "billid", "entryid", "cur_index_adjust"};
    private static String[] top_standardCostOne_TYPE_AuditFirst_detail = new String[]{"calorg", "costaccount", "year", "period", "material", "priorityorder desc", "priorityorder_first", "calbilltype", "audittime", "bookdate", "billid", "entryid", "cur_index_adjust", "costelement", "costsubelement", "orderline"};
    private static String[] top_standardCost_BizFirst_Print = new String[]{"calorg", "costaccount", "material", "year", "period", "priorityorder desc", "priorityorder_first", "bookdate", "audittime", "billid", "entryid", "cur_index_adjust"};
    private static String[] top_standardCost_BizFirst_Print_detail = new String[]{"calorg", "costaccount", "material", "year", "period", "priorityorder desc", "priorityorder_first", "bookdate", "audittime", "billid", "entryid", "cur_index_adjust", "costelement", "costsubelement", "orderline"};
    private static String[] top_standardCost_BizFirst = new String[]{"calorg", "costaccount", "year", "period", "material", "priorityorder desc", "priorityorder_first", "bookdate", "audittime", "billid", "entryid", "cur_index_adjust"};
    private static String[] top_standardCost_BizFirst_detail = new String[]{"calorg", "costaccount", "year", "period", "material", "priorityorder desc", "priorityorder_first", "bookdate", "audittime", "billid", "entryid", "cur_index_adjust", "costelement", "costsubelement", "orderline"};
    private static String[] top_standardCost_AuditFirst_Print = new String[]{"calorg", "costaccount", "material", "year", "period", "priorityorder desc", "priorityorder_first", "audittime", "bookdate", "billid", "entryid", "cur_index_adjust"};
    private static String[] top_standardCost_AuditFirst_Print_detail = new String[]{"calorg", "costaccount", "material", "year", "period", "priorityorder desc", "priorityorder_first", "audittime", "bookdate", "billid", "entryid", "cur_index_adjust", "costelement", "costsubelement", "orderline"};
    private static String[] top_standardCost_AuditFirst = new String[]{"calorg", "costaccount", "year", "period", "material", "priorityorder desc", "priorityorder_first", "audittime", "bookdate", "billid", "entryid", "cur_index_adjust"};
    private static String[] top_standardCost_AuditFirst_detail = new String[]{"calorg", "costaccount", "year", "period", "material", "priorityorder desc", "priorityorder_first", "audittime", "bookdate", "billid", "entryid", "cur_index_adjust", "costelement", "costsubelement", "orderline"};
    private static String[] standardCostOne_TYPE_BizFirst_Print = new String[]{"calorg", "costaccount", "material", "year", "period", "priorityorder", "priorityorder_first", "calbilltype", "bookdate", "audittime", "billid", "entryid", "cur_index_adjust"};
    private static String[] standardCostOne_TYPE_BizFirst_Print_detail = new String[]{"calorg", "costaccount", "material", "year", "period", "priorityorder", "priorityorder_first", "calbilltype", "bookdate", "audittime", "billid", "entryid", "cur_index_adjust", "costelement", "costsubelement", "orderline"};
    private static String[] standardCostOne_TYPE_BizFirst = new String[]{"calorg", "costaccount", "year", "period", "material", "priorityorder", "priorityorder_first", "calbilltype", "bookdate", "audittime", "billid", "entryid", "cur_index_adjust"};
    private static String[] standardCostOne_TYPE_BizFirst_detail = new String[]{"calorg", "costaccount", "year", "period", "material", "priorityorder", "priorityorder_first", "calbilltype", "bookdate", "audittime", "billid", "entryid", "cur_index_adjust", "costelement", "costsubelement", "orderline"};
    private static String[] standardCostOne_TYPE_AuditFirst_Print = new String[]{"calorg", "costaccount", "material", "year", "period", "priorityorder", "priorityorder_first", "calbilltype", "audittime", "bookdate", "billid", "entryid", "cur_index_adjust"};
    private static String[] standardCostOne_TYPE_AuditFirst_Print_detail = new String[]{"calorg", "costaccount", "material", "year", "period", "priorityorder", "priorityorder_first", "calbilltype", "audittime", "bookdate", "billid", "entryid", "cur_index_adjust", "costelement", "costsubelement", "orderline"};
    private static String[] standardCostOne_TYPE_AuditFirst = new String[]{"calorg", "costaccount", "year", "period", "material", "priorityorder", "priorityorder_first", "calbilltype", "audittime", "bookdate", "billid", "entryid", "cur_index_adjust"};
    private static String[] standardCostOne_TYPE_AuditFirst_detail = new String[]{"calorg", "costaccount", "year", "period", "material", "priorityorder", "priorityorder_first", "calbilltype", "audittime", "bookdate", "billid", "entryid", "cur_index_adjust", "costelement", "costsubelement", "orderline"};
    private static String[] standardCost_BizFirst_Print = new String[]{"calorg", "costaccount", "material", "year", "period", "priorityorder", "priorityorder_first", "bookdate", "audittime", "billid", "entryid", "cur_index_adjust"};
    private static String[] standardCost_BizFirst_Print_detail = new String[]{"calorg", "costaccount", "material", "year", "period", "priorityorder", "priorityorder_first", "bookdate", "audittime", "billid", "entryid", "cur_index_adjust", "costelement", "costsubelement", "orderline"};
    private static String[] standardCost_BizFirst = new String[]{"calorg", "costaccount", "year", "period", "material", "priorityorder", "priorityorder_first", "bookdate", "audittime", "billid", "entryid", "cur_index_adjust"};
    private static String[] standardCost_BizFirst_detail = new String[]{"calorg", "costaccount", "year", "period", "material", "priorityorder", "priorityorder_first", "bookdate", "audittime", "billid", "entryid", "cur_index_adjust", "costelement", "costsubelement", "orderline"};
    private static String[] standardCost_AuditFirst_Print = new String[]{"calorg", "costaccount", "material", "year", "period", "priorityorder", "priorityorder_first", "audittime", "bookdate", "billid", "entryid", "cur_index_adjust"};
    private static String[] standardCost_AuditFirst_Print_detail = new String[]{"calorg", "costaccount", "material", "year", "period", "priorityorder", "priorityorder_first", "audittime", "bookdate", "billid", "entryid", "cur_index_adjust", "costelement", "costsubelement", "orderline"};
    private static String[] standardCost_AuditFirst = new String[]{"calorg", "costaccount", "year", "period", "material", "priorityorder", "priorityorder_first", "audittime", "bookdate", "billid", "entryid", "cur_index_adjust"};
    private static String[] standardCost_AuditFirst_detail = new String[]{"calorg", "costaccount", "year", "period", "material", "priorityorder", "priorityorder_first", "audittime", "bookdate", "billid", "entryid", "cur_index_adjust", "costelement", "costsubelement", "orderline"};
    private static String[] standardCost_TYPE_BizFirst_OneOrder = new String[]{"calorg", "costaccount", "material", "year", "period", "priorityorder_first", "calbilltype", "bookdate", "audittime", "billid", "entryid", "cur_index_adjust"};
    private static String[] standardCost_TYPE_BizFirst_OneOrder_detail = new String[]{"calorg", "costaccount", "material", "year", "period", "priorityorder_first", "calbilltype", "bookdate", "audittime", "billid", "entryid", "cur_index_adjust", "costelement", "costsubelement", "orderline"};
    private static String[] standardCost_TYPE_AuditFirst_OneOrder = new String[]{"calorg", "costaccount", "material", "year", "period", "priorityorder_first", "calbilltype", "audittime", "bookdate", "billid", "entryid", "cur_index_adjust"};
    private static String[] standardCost_TYPE_AuditFirst_OneOrder_detail = new String[]{"calorg", "costaccount", "material", "year", "period", "priorityorder_first", "calbilltype", "audittime", "bookdate", "billid", "entryid", "cur_index_adjust", "costelement", "costsubelement", "orderline"};
    private static String[] standardCost_BizFirst_OneOrder = new String[]{"calorg", "costaccount", "material", "year", "period", "priorityorder_first", "bookdate", "audittime", "billid", "entryid", "cur_index_adjust"};
    private static String[] standardCost_BizFirst_OneOrder_detail = new String[]{"calorg", "costaccount", "material", "year", "period", "priorityorder_first", "bookdate", "audittime", "billid", "entryid", "cur_index_adjust", "costelement", "costsubelement", "orderline"};
    private static String[] standardCost_AuditFirst_OneOrder = new String[]{"calorg", "costaccount", "material", "year", "period", "priorityorder_first", "audittime", "bookdate", "billid", "entryid", "cur_index_adjust"};
    private static String[] standardCost_AuditFirst_OneOrder_detail = new String[]{"calorg", "costaccount", "material", "year", "period", "priorityorder_first", "audittime", "bookdate", "billid", "entryid", "cur_index_adjust", "costelement", "costsubelement", "orderline"};
    private static final String[] periodEndGroup = new String[]{"calorg", "costaccount", "material", "year"};
    private static final String[] periodSumGroup = new String[]{"calorg", "costaccount", "year", "period"};
    private static final String[] calBalanceGroup = new String[]{"calorg", "costaccount", "material", "year", "month"};
    private static final String[] helpOrderField = new String[]{"priorityorder", "priorityorder_first", "entryid", "cur_index_adjust"};
    private static final String[] backGroundKeepField = new String[]{"year", "unitprice", "billid", "bizentityobject", "invtype", "invtype.name", "invtypecode", "invstatus", "invstatus.name", "invstatuscode", "invtype.number", "invstatus.number", "group"};
    private static final String[] backGroundField = new String[]{"month", "periodendactualcost", "periodbeginqty", "periodbeginactualcost", "periodinqtybak", "periodinamountbak", "yearinqty", "yearinactualcost", "yearissueqty", "yearissueactualcost", "yearincostdiff", "yearissuecostdiff", "yearissuecost", "yearincost", "accounttype", "difftype", "createtype", "adjustamt", "auditdate", "baseqty", "standardcost", "actualcost", "unitstandardcost", "unitactualcost", "subentryentity_json"};
    private static final String[] qty = new String[]{"periodinqty", "periodinprice", "periodinamount", "periodoutqty", "periodoutprice", "periodoutamount", "periodendqty", "periodendprice", "periodendamount"};
    private static final String[][] engageFields = new String[][]{helpOrderField, backGroundKeepField, backGroundField};
    private LocaleString locale_periodBegin = new LocaleString(this.getLocale_periodBegin());
    private LocaleString locale_periodIn = new LocaleString(this.getLocale_periodIn());
    private LocaleString locale_periodOut = new LocaleString(this.getLocale_periodOut());
    private LocaleString locale_periodEnd = new LocaleString(this.getLocale_periodEnd());

    private String getLocale_periodBegin() {
        return ResManager.loadKDString((String)"\u671f\u521d\u7ed3\u5b58", (String)"StockGatherRptQueryPlugin_21", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_periodIn() {
        return ResManager.loadKDString((String)"\u672c\u671f\u6536\u5165", (String)"StockGatherRptQueryPlugin_22", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_periodOut() {
        return ResManager.loadKDString((String)"\u672c\u671f\u53d1\u51fa", (String)"StockGatherRptQueryPlugin_23", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_periodEnd() {
        return ResManager.loadKDString((String)"\u671f\u672b\u7ed3\u5b58", (String)"StockGatherRptQueryPlugin_24", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_costAdjustName() {
        return ResManager.loadKDString((String)"\u6210\u672c\u8c03\u6574\u5355", (String)"StockDetailRptQueryPlugin_13", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_stdDiffName() {
        return ResManager.loadKDString((String)"\u6807\u51c6\u6210\u672c\u5dee\u5f02\u5355", (String)"StockDetailRptQueryPlugin_23", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_total() {
        return ResManager.loadKDString((String)"\u672c\u671f\u5408\u8ba1", (String)"StockDetailRptQueryPlugin_24", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    public void setupCtx(ReportDataCtx ctx) {
        logger.info("stockDetail query start");
        ctx.setShowBlockEntity(false);
        Set showKeyCols = ctx.getShowKeyCols();
        Set showQtyCols = ctx.getShowQtyCols();
        Set amtFields = ReportUtil.filterBigtableCols((ReportConf)ctx.getReportConf(), colConf -> "B".equals(colConf.getCalType()));
        HashSet<String> qtyFields = new HashSet<String>(Arrays.asList(qty));
        amtFields.addAll(qtyFields);
        amtFields.addAll(showQtyCols);
        ctx.setShowQtyCols(amtFields);
        this.stockDetailParam = (StockDetailRptParam)ctx.getParam(StockDetailNewRptFormPlugin.class.getName());
        Set keyFields = ReportUtil.filterBigtableCols((ReportConf)ctx.getReportConf(), colConf -> "A".equals(colConf.getCalType()));
        keyFields.addAll(showKeyCols);
        if (this.stockDetailParam != null) {
            ArrayList<String> groups = new ArrayList<String>();
            groups.add("costsubelement");
            groups.add("costelement");
            groups.add("costelement.number");
            groups.add("costsubelement.number");
            groups.add("costelement_ref_number");
            groups.add("costsubelement_ref_number");
            groups.add("subentryentity_json");
            if (this.stockDetailParam.isShowDetail()) {
                keyFields.addAll(groups);
            } else {
                keyFields.removeAll(groups);
            }
        }
        ctx.setShowKeyCols(keyFields);
        List fixed = ctx.getFixedFs();
        QFilter q = QFilter.of((String)"1 = 1", (Object[])new Object[0]);
        if (this.stockDetailParam != null) {
            this.getBDMaterials(this.stockDetailParam);
            List valueFilter = this.stockDetailParam.getValueFilter();
            if (valueFilter != null) {
                for (QFilter filter : valueFilter) {
                    q.and(filter);
                }
            }
            ArrayList<QFilter> commonFix = new ArrayList<QFilter>(16);
            commonFix.add(q);
            commonFix.add(this.getCommonFixFilter());
            QFilter commonFs = ctx.getCommonFs();
            if (commonFs != null) {
                String property = commonFs.getProperty();
                Object value1 = commonFs.getValue();
                String inCp = commonFs.getCP();
                if (!StringUtils.isEmpty((String)property) && "calbilltype".equals(property) && "in".equals(inCp)) {
                    if ("IN".equals(value1)) {
                        commonFs.__setCP("in");
                        commonFs.__setValue((Object)new String[]{"A", "IN"});
                    } else {
                        commonFs.__setCP("in");
                        commonFs.__setValue((Object)new String[]{"B", "OUT"});
                    }
                }
                List nests = commonFs.getNests(true);
                for (QFilter.QFilterNest nest : nests) {
                    QFilter curFilter = nest.getFilter();
                    String curProperty = curFilter.getProperty();
                    Object value = curFilter.getValue();
                    String cp = curFilter.getCP();
                    if (StringUtils.isEmpty((String)curProperty) || !"calbilltype".equals(curProperty) || !"in".equals(cp)) continue;
                    if (value instanceof String) {
                        String curValue = (String)value;
                        if ("IN".equals(curValue)) {
                            curFilter.__setCP("in");
                            curFilter.__setValue((Object)new String[]{"A", "IN"});
                        } else {
                            curFilter.__setCP("in");
                            curFilter.__setValue((Object)new String[]{"B", "OUT"});
                        }
                    }
                    if (!(value instanceof ArrayList)) continue;
                    ArrayList values = (ArrayList)value;
                    HashSet<String> filter = new HashSet<String>();
                    for (String curValue : values) {
                        if ("IN".equals(curValue)) {
                            filter.add("A");
                            filter.add("IN");
                        }
                        if (!"OUT".equals(curValue)) continue;
                        filter.add("B");
                        filter.add("OUT");
                    }
                    curFilter.__setCP("in");
                    curFilter.__setValue((Object)filter.toArray(new String[0]));
                }
            }
            if (fixed == null) {
                ctx.setFixedFs(commonFix);
            } else {
                fixed.addAll(commonFix);
            }
        }
    }

    private QFilter getCommonFixFilter() {
        QFilter filter = QFilter.of((String)"1 = 1", (Object[])new Object[0]);
        List auxptyIds = this.stockDetailParam.getAuxptyIds();
        if (auxptyIds != null) {
            filter.and("assist", "in", (Object)auxptyIds);
        }
        return filter;
    }

    private void getBDMaterials(StockDetailRptParam queryParam) {
        DynamicObjectCollection filter_materialFrom = queryParam.getMaterialFrom();
        DynamicObject filter_materialTo = queryParam.getMaterialTo();
        QFilter q = QFilter.of((String)"1=1", (Object[])new Object[0]);
        if (filter_materialFrom != null) {
            if (filter_materialFrom.size() > 1) {
                HashSet<Object> set = new HashSet<Object>(16);
                for (DynamicObject dynamicObject : filter_materialFrom) {
                    set.add(dynamicObject.getPkValue());
                }
                q.and("id", "in", set);
            } else {
                q.and("number", ">=", (Object)((DynamicObject)filter_materialFrom.get(0)).getString("number"));
            }
        }
        if (filter_materialTo != null) {
            q.and("number", "<=", (Object)filter_materialTo.getString("number"));
        }
        DynamicObjectCollection dynamicObjects = null;
        if (filter_materialFrom != null || filter_materialTo != null) {
            dynamicObjects = QueryServiceHelper.query((String)this.getClass().getName(), (String)"bd_material", (String)"id as material.id", (QFilter[])new QFilter[]{q}, null);
        }
        if (dynamicObjects != null && dynamicObjects.size() > 0) {
            HashSet<Long> idSet = new HashSet<Long>(dynamicObjects.size());
            for (DynamicObject balInfo : dynamicObjects) {
                long materialId = balInfo.getLong("material.id");
                if (materialId == 0L) continue;
                idSet.add(materialId);
            }
            this.stockDetailParam.setMaterialIdContainer(idSet);
        }
    }

    public QFilter commonFilter(String tableName, Set<Long> materialIdContainer, Integer periodNumber) {
        QFilter q = QFilter.of((String)"1 = 1", (Object[])new Object[0]);
        DynamicObjectCollection costAccountObjects = null;
        if (this.stockDetailParam != null) {
            costAccountObjects = this.stockDetailParam.getCostAccountObject();
        }
        HashSet<Long> costAccountIds = new HashSet<Long>(16);
        if (costAccountObjects != null) {
            for (DynamicObject costAccountObject : costAccountObjects) {
                Long id = costAccountObject.getPkValue() == null ? 0L : Long.parseLong(costAccountObject.getPkValue().toString());
                if (id == 0L) continue;
                costAccountIds.add(id);
            }
            q = !costAccountIds.isEmpty() ? new QFilter("costaccount", "in", costAccountIds) : q;
        }
        Date beginDate = this.stockDetailParam == null ? null : this.stockDetailParam.getBeginDate();
        Date endDate = this.stockDetailParam == null ? null : this.stockDetailParam.getEndDate();
        String ownerType = this.stockDetailParam == null ? null : this.stockDetailParam.getOwnerType();
        DynamicObjectCollection ownerFrom = this.stockDetailParam == null ? null : this.stockDetailParam.getOwnerFrom();
        int startPeriodValue = this.stockDetailParam == null ? 0 : this.stockDetailParam.getStartPeriodValue();
        int endPeriodValue = this.stockDetailParam == null ? 0 : this.stockDetailParam.getEndPeriodValue();
        String[] commonParamName = null;
        DynamicObjectCollection subElements = this.stockDetailParam == null ? null : this.stockDetailParam.getSubElements();
        HashSet<Long> subElementIds = new HashSet<Long>();
        if (subElements != null) {
            for (DynamicObject subElement : subElements) {
                Long id = subElement.getPkValue() == null ? 0L : Long.parseLong(subElement.getPkValue().toString());
                if (id == 0L) continue;
                subElementIds.add(id);
            }
        }
        String amountShowCondition = this.stockDetailParam == null ? null : this.stockDetailParam.getAmountShowCondition();
        String qtyShowCondition = this.stockDetailParam == null ? null : this.stockDetailParam.getQtyShowCondition();
        boolean filter_qty_amt = !StringUtils.isEmpty((String)amountShowCondition) || !StringUtils.isEmpty((String)qtyShowCondition);
        switch (tableName) {
            case "cal_costrecord": 
            case "cal_costrecord_subentity": {
                q.and("bookdate", ">=", (Object)beginDate);
                q.and("bookdate", "<=", (Object)endDate);
                q.and("issplitcreate", "=", (Object)false);
                q.and("isinitbill", "=", (Object)false);
                q.and("billstatus", "=", (Object)"C");
                StockDetailRptResourceCfg.getOwnerFilterNew(q, ownerType, ownerFrom, "cal_costrecord");
                HashSet biztypeNotInSet = new HashSet(16);
                biztypeNotInSet.addAll(CommonSettingHelper.getNotUpdBalBizType());
                q.and("biztype", "not in", biztypeNotInSet);
                if (!subElementIds.isEmpty() && !filter_qty_amt) {
                    q.and("entry.subentrycostelement.costsubelement", "in", subElementIds);
                }
                commonParamName = COSTRECORDPARAM;
                break;
            }
            case "cal_costadjustbill": 
            case "cal_costadjust_subentity": {
                q.and("bookdate", ">=", (Object)beginDate);
                q.and("bookdate", "<=", (Object)endDate);
                q.and("billstatus", "=", (Object)"C");
                q.and("isupdatecost", "=", (Object)"1");
                q.and("entryentity.accounttype", "<>", (Object)AccountTypeEnum.STANDARDCOST.getValue());
                if (!subElementIds.isEmpty() && !filter_qty_amt) {
                    q.and("entryentity.subentryentity.costsubelement", "in", subElementIds);
                }
                StockDetailRptResourceCfg.getOwnerFilterNew(q, ownerType, ownerFrom, "cal_costadjustbill");
                commonParamName = COSTADJUSTBILLPARAM;
                break;
            }
            case "cal_stdcostdiffbill": {
                q.and("bookdate", ">=", (Object)beginDate);
                q.and("bookdate", "<=", (Object)endDate);
                q.and("billstatus", "=", (Object)"C");
                q.and("isupdatecost", "=", (Object)"1");
                q.and("createtype", "<>", (Object)CostAdjustBilCreateTypeEnum.STAND_CHANGE.getValue());
                StockDetailRptResourceCfg.getOwnerFilterNew(q, ownerType, ownerFrom, "cal_costadjustbill");
                commonParamName = COSTADJUSTBILLPARAM;
                break;
            }
            case "cal_balance": 
            case "cal_balance_subentity": {
                q.and("period", "<", (Object)periodNumber);
                q.and("endperiod", ">=", (Object)periodNumber);
                if (!subElementIds.isEmpty() && !filter_qty_amt) {
                    q.and("entryentity.costsubelement", "in", subElementIds);
                }
                StockDetailRptResourceCfg.getOwnerFilterNew(q, ownerType, ownerFrom, "cal_balance");
                commonParamName = BALANCEPARAM;
                break;
            }
            case "cal_bal": {
                q.and("period", "<", (Object)periodNumber);
                q.and("endperiod", ">=", (Object)periodNumber);
                if (!subElementIds.isEmpty() && !filter_qty_amt) {
                    q.and("costsubelement", "in", subElementIds);
                }
                StockDetailRptResourceCfg.getOwnerFilterNew(q, ownerType, ownerFrom, "cal_bal");
                commonParamName = BALANCEPARAM;
                break;
            }
            case "cal_initbill": {
                q.and("period.periodyear", ">=", (Object)(startPeriodValue / 100));
                q.and("period.periodyear", "<=", (Object)(endPeriodValue / 100));
                if (!subElementIds.isEmpty() && !filter_qty_amt) {
                    q.and("entryentity.subentryentity.costsubelement", "in", subElementIds);
                }
                StockDetailRptResourceCfg.getOwnerFilterNew(q, ownerType, ownerFrom, "cal_costadjustbill");
                commonParamName = COSTADJUSTBILLPARAM;
                break;
            }
            default: {
                q.and(QFilter.of((String)"1!=1", (Object[])new Object[0]));
            }
        }
        if (commonParamName != null) {
            this.getCommonFix(q, commonParamName);
        }
        return q;
    }

    private List<QFilter> getCommonFix(QFilter q, String[] commonParamName) {
        ArrayList<QFilter> result = new ArrayList<QFilter>();
        DynamicObjectCollection storageOrgs = this.stockDetailParam.getStorageOrgs();
        DynamicObjectCollection warehouses = this.stockDetailParam.getWarehouses();
        DynamicObjectCollection locations = this.stockDetailParam.getLocations();
        DynamicObjectCollection projects = this.stockDetailParam.getProjects();
        DynamicObjectCollection tracknumbers = this.stockDetailParam.getTracknumbers();
        DynamicObjectCollection invTypes = this.stockDetailParam.getInvTypes();
        DynamicObjectCollection invStatuss = this.stockDetailParam.getInvStatuss();
        DynamicObjectCollection matcategorys = this.stockDetailParam.getMatcategory();
        Set warehouseGroupIds = this.stockDetailParam.getWarehouseGroupIds();
        String[] lotIds = this.stockDetailParam.getLotIds();
        DynamicObjectCollection calRange = this.stockDetailParam.getCalRange();
        Set accountTypeContainer = this.stockDetailParam.getAccountTypeContainer();
        Set materialIdContainer = this.stockDetailParam.getMaterialIdContainer();
        if (materialIdContainer != null && !materialIdContainer.isEmpty()) {
            q.and(commonParamName[0], "in", (Object)materialIdContainer);
        }
        q = this.setIds(storageOrgs, q, commonParamName[1]);
        q = this.setIds(warehouses, q, commonParamName[2]);
        q = this.setIds(locations, q, commonParamName[3]);
        q = this.setIds(projects, q, commonParamName[4]);
        q = this.setIds(invTypes, q, commonParamName[5]);
        q = this.setIds(invStatuss, q, commonParamName[6]);
        q = warehouseGroupIds != null && warehouseGroupIds.size() != 0 ? q.and(commonParamName[7], "in", (Object)warehouseGroupIds) : q;
        q = lotIds != null && lotIds.length != 0 ? q.and(commonParamName[8], "in", (Object)lotIds) : q;
        q = this.setIds(calRange, q, commonParamName[9]);
        q = accountTypeContainer != null && accountTypeContainer.size() != 0 ? q.and(commonParamName[10], "in", (Object)accountTypeContainer) : q;
        q = this.setTracknumberIds(tracknumbers, q, commonParamName[11]);
        q = this.setIds(matcategorys, q, commonParamName[12]);
        result.add(q);
        return result;
    }

    private QFilter setTracknumberIds(DynamicObjectCollection tracknumbers, QFilter q, String multiParamIdName) {
        HashSet<Object> idContainer = new HashSet<Object>(16);
        if (tracknumbers != null && tracknumbers.size() != 0) {
            for (DynamicObject tracknumber : tracknumbers) {
                idContainer.add(tracknumber.getPkValue());
            }
            q = tracknumbers != null ? q.and(multiParamIdName, "in", idContainer) : q;
        }
        return q;
    }

    private QFilter setIds(DynamicObjectCollection multiParam, QFilter q, String multiParamIdName) {
        HashSet<Object> idContainer = new HashSet<Object>(16);
        if (multiParam != null && multiParam.size() != 0) {
            for (DynamicObject storageOrg : multiParam) {
                idContainer.add(storageOrg.getPkValue());
            }
            q = multiParam != null ? q.and(multiParamIdName, "in", idContainer) : q;
        }
        return q;
    }

    public void modifyBlocks(List<SrcBlockConf> blockCollector, ReportDataCtx ctx) {
        Set allKeyColsC;
        Set allKeyColsB;
        HashSet allKeyCols = new HashSet(16);
        Set allKeyColsA = ReportUtil.filterBigtableCols((ReportConf)ctx.getReportConf(), colConf -> "A".equals(colConf.getCalType()));
        if (allKeyColsA != null && allKeyColsA.size() > 0) {
            allKeyCols.addAll(allKeyColsA);
        }
        if ((allKeyColsB = ReportUtil.filterBigtableCols((ReportConf)ctx.getReportConf(), colConf -> "B".equals(colConf.getCalType()))) != null && allKeyColsB.size() > 0) {
            allKeyCols.addAll(allKeyColsB);
        }
        if ((allKeyColsC = ReportUtil.filterBigtableCols((ReportConf)ctx.getReportConf(), colConf -> "C".equals(colConf.getCalType()))) != null && allKeyColsC.size() > 0) {
            allKeyCols.addAll(allKeyColsC);
        }
        if (!allKeyCols.isEmpty() && !allKeyCols.contains("yearshow")) {
            throw new KDBizException(ResManager.loadKDString((String)"\u62a5\u8868\u914d\u7f6e\u51fa\u73b0\u5f02\u5e38\uff0c\u8bf7\u5230\uff1a\u4f9b\u5e94\u94fe\u4e91>>\u4e1a\u52a1\u8bbe\u7f6e>>\u62a5\u8868\u914d\u7f6e\u83dc\u5355\u4e0b\u9762\u68c0\u67e5\u201c\u62a5\u8868\u6570\u636e\u6e90\u914d\u7f6e\u201d\uff0c\u201c\u62a5\u8868\u5b57\u6bb5\u6620\u5c04\u914d\u7f6e\u201d\u662f\u5426\u6b63\u786e\u3002", (String)"StockDetailRptResourceCfg_0", (String)"fi-cal-report", (Object[])new Object[0]));
        }
        ArrayList<SrcBlockConf> result = new ArrayList<SrcBlockConf>();
        if (this.stockDetailParam == null) {
            return;
        }
        boolean showdetailUnBlockCol = false;
        boolean isNewBalance = this.stockDetailParam.getIsNewBalance();
        for (SrcBlockConf blockConf : blockCollector) {
            String tableName = blockConf.getSrcEntity();
            Set materialIdContainer = this.stockDetailParam.getMaterialIdContainer();
            List periodNumber = this.stockDetailParam.getPeriodNumber();
            switch (tableName) {
                case "cal_costrecord": 
                case "cal_costrecord_subentity": {
                    SrcBlockConf costRecordblockConf = new SrcBlockConf();
                    QFilter costRecord_Filter = null;
                    if ("cal_costrecord_subentity".equals(tableName)) {
                        if (this.stockDetailParam.isShowDetail()) {
                            costRecordblockConf.setEnbale(true);
                            costRecord_Filter = this.commonFilter(tableName, materialIdContainer, null);
                            showdetailUnBlockCol = true;
                        } else {
                            costRecordblockConf.setEnbale(false);
                        }
                    } else if ("cal_costrecord".equals(tableName)) {
                        if (this.stockDetailParam.isShowDetail()) {
                            costRecordblockConf.setEnbale(false);
                        } else {
                            costRecordblockConf.setEnbale(true);
                            costRecord_Filter = this.commonFilter(tableName, materialIdContainer, null);
                        }
                    }
                    if (costRecord_Filter == null) break;
                    costRecordblockConf.setDataFs(costRecord_Filter);
                    blockConf.setDataFs(costRecord_Filter);
                    costRecordblockConf.setAllowNotMatch(true);
                    Map srcColMap = blockConf.getRepoColSrcColMap();
                    srcColMap.put("entryid", "entryid");
                    blockConf.setRepoColSrcColMap(srcColMap);
                    Map repoColFullSrcColMap = blockConf.getRepoColFullSrcColMap();
                    repoColFullSrcColMap.put("entryid", "entry.id");
                    blockConf.setRepoColFullSrcColMap(repoColFullSrcColMap);
                    srcColMap = blockConf.getRepoColSrcColMap();
                    srcColMap.put("tartranstype", "transtype");
                    blockConf.setRepoColSrcColMap(srcColMap);
                    repoColFullSrcColMap = blockConf.getRepoColFullSrcColMap();
                    repoColFullSrcColMap.put("tartranstype", "transtype");
                    blockConf.setRepoColFullSrcColMap(repoColFullSrcColMap);
                    srcColMap = blockConf.getRepoColSrcColMap();
                    srcColMap.put("tarbiztype", "biztype");
                    blockConf.setRepoColSrcColMap(srcColMap);
                    repoColFullSrcColMap = blockConf.getRepoColFullSrcColMap();
                    repoColFullSrcColMap.put("tarbiztype", "biztype");
                    blockConf.setRepoColFullSrcColMap(repoColFullSrcColMap);
                    srcColMap = blockConf.getRepoColSrcColMap();
                    srcColMap.put("tarbizentityobject", "bizentityobject");
                    blockConf.setRepoColSrcColMap(srcColMap);
                    repoColFullSrcColMap = blockConf.getRepoColFullSrcColMap();
                    repoColFullSrcColMap.put("tarbizentityobject", "bizentityobject");
                    blockConf.setRepoColFullSrcColMap(repoColFullSrcColMap);
                    srcColMap = blockConf.getRepoColSrcColMap();
                    srcColMap.put("billid", "billid");
                    blockConf.setRepoColSrcColMap(srcColMap);
                    repoColFullSrcColMap = blockConf.getRepoColFullSrcColMap();
                    repoColFullSrcColMap.put("billid", "id");
                    blockConf.setRepoColFullSrcColMap(repoColFullSrcColMap);
                    costRecordblockConf.setDefVals(blockConf.getDefVals());
                    costRecordblockConf.setRepoColFullSrcColMap(blockConf.getRepoColFullSrcColMap());
                    costRecordblockConf.setRepoColSrcColMap(blockConf.getRepoColSrcColMap());
                    costRecordblockConf.setSrcEntity(blockConf.getSrcEntity());
                    costRecordblockConf.setType(blockConf.getType());
                    List costRecordTransform = costRecordblockConf.getDataTransform();
                    if (costRecordTransform != null) {
                        costRecordTransform.add(new CostRecordTransform(ctx, this.stockDetailParam, periodSumGroup));
                    }
                    costRecordblockConf.setAllowNotMatch(true);
                    result.add(costRecordblockConf);
                    boolean mulbeginconoutnoindata = this.stockDetailParam.isMulbeginconoutnoindata();
                    String mulnojoinsumrange = this.stockDetailParam.getMulnojoinsumrange();
                    if (!StringUtils.isNotEmpty((String)mulnojoinsumrange) || !mulbeginconoutnoindata || !mulnojoinsumrange.contains("A") && !mulnojoinsumrange.contains("B")) break;
                    HashSet<String> transtypeSet = new HashSet<String>(16);
                    if (mulnojoinsumrange.contains("A")) {
                        transtypeSet.add("A");
                    }
                    if (mulnojoinsumrange.contains("B")) {
                        transtypeSet.add("B");
                    }
                    SrcBlockConf beginInblockConf = new SrcBlockConf();
                    beginInblockConf.setDefVals(blockConf.getDefVals());
                    beginInblockConf.setRepoColFullSrcColMap(blockConf.getRepoColFullSrcColMap());
                    beginInblockConf.setRepoColSrcColMap(blockConf.getRepoColSrcColMap());
                    beginInblockConf.setSrcEntity(blockConf.getSrcEntity());
                    beginInblockConf.setType(blockConf.getType());
                    QFilter commonBeginInFilter = new QFilter("bookdate", "<", (Object)this.stockDetailParam.getFilter_endStartDate());
                    commonBeginInFilter.and("issplitcreate", "=", (Object)Boolean.FALSE);
                    commonBeginInFilter.and("isinitbill", "=", (Object)Boolean.FALSE);
                    commonBeginInFilter.and("billstatus", "=", (Object)"C");
                    HashSet<String> bizbillstrSet = new HashSet<String>(16);
                    bizbillstrSet.add("im_transdirbill");
                    bizbillstrSet.add("im_transoutbill");
                    bizbillstrSet.add("im_transinbill");
                    commonBeginInFilter.and("bizentityobject", "in", bizbillstrSet);
                    commonBeginInFilter.and("calbilltype", "=", (Object)"IN");
                    Set mulnosumbiztypeIdSet = this.stockDetailParam.getMulnosumbiztypeIdSet();
                    if (mulnosumbiztypeIdSet != null && mulnosumbiztypeIdSet.size() > 0) {
                        commonBeginInFilter.and("biztype", "in", (Object)mulnosumbiztypeIdSet);
                    }
                    commonBeginInFilter.and("costaccount", "in", (Object)this.stockDetailParam.getCostaccountIdSet());
                    commonBeginInFilter.and("calorg", "in", (Object)this.stockDetailParam.getCalorgIdSet());
                    Set materialIds = this.stockDetailParam.getMaterialIdContainer();
                    if (materialIds != null && materialIds.size() != 0) {
                        commonBeginInFilter.and("entry.material", "in", (Object)this.stockDetailParam.getMaterialIdContainer());
                    }
                    if (!transtypeSet.isEmpty()) {
                        commonBeginInFilter.and("transtype", "in", transtypeSet);
                    }
                    this.getCommonFix(commonBeginInFilter, COSTRECORDPARAM);
                    beginInblockConf.setDataFs(commonBeginInFilter);
                    List dataXTransformsBeginIn = beginInblockConf.getDataTransform();
                    if (dataXTransformsBeginIn != null) {
                        dataXTransformsBeginIn.add(new BeginInObjectNameNoinDataxTransform());
                    }
                    beginInblockConf.setAllowNotMatch(true);
                    result.add(beginInblockConf);
                    SrcBlockConf beginOutblockConf = new SrcBlockConf();
                    beginOutblockConf.setDefVals(blockConf.getDefVals());
                    beginOutblockConf.setRepoColFullSrcColMap(blockConf.getRepoColFullSrcColMap());
                    beginOutblockConf.setRepoColSrcColMap(blockConf.getRepoColSrcColMap());
                    beginOutblockConf.setSrcEntity(blockConf.getSrcEntity());
                    beginOutblockConf.setType(blockConf.getType());
                    QFilter commonBeginOutFilter = new QFilter("bookdate", "<", (Object)this.stockDetailParam.getFilter_endStartDate());
                    commonBeginOutFilter.and("issplitcreate", "=", (Object)Boolean.FALSE);
                    commonBeginOutFilter.and("isinitbill", "=", (Object)Boolean.FALSE);
                    commonBeginOutFilter.and("billstatus", "=", (Object)"C");
                    bizbillstrSet.add("im_transdirbill");
                    bizbillstrSet.add("im_transoutbill");
                    bizbillstrSet.add("im_transinbill");
                    commonBeginOutFilter.and("bizentityobject", "in", bizbillstrSet);
                    commonBeginOutFilter.and("calbilltype", "=", (Object)"OUT");
                    if (mulnosumbiztypeIdSet != null && mulnosumbiztypeIdSet.size() > 0) {
                        commonBeginOutFilter.and("biztype", "in", (Object)mulnosumbiztypeIdSet);
                    }
                    commonBeginOutFilter.and("costaccount", "in", (Object)this.stockDetailParam.getCostaccountIdSet());
                    commonBeginOutFilter.and("calorg", "in", (Object)this.stockDetailParam.getCalorgIdSet());
                    if (materialIds != null && materialIds.size() != 0) {
                        commonBeginOutFilter.and("entry.material", "in", (Object)this.stockDetailParam.getMaterialIdContainer());
                    }
                    if (!transtypeSet.isEmpty()) {
                        commonBeginOutFilter.and("transtype", "in", transtypeSet);
                    }
                    this.getCommonFix(commonBeginOutFilter, COSTRECORDPARAM);
                    beginOutblockConf.setDataFs(commonBeginOutFilter);
                    List dataXTransformsBeginOut = beginOutblockConf.getDataTransform();
                    if (dataXTransformsBeginOut != null) {
                        dataXTransformsBeginOut.add(new BeginOutObjectNameNoinDataxTransform());
                    }
                    beginOutblockConf.setAllowNotMatch(true);
                    result.add(beginOutblockConf);
                    break;
                }
                case "cal_costadjustbill": 
                case "cal_costadjust_subentity": {
                    QFilter costAdjust_Filter = null;
                    if ("cal_costadjust_subentity".equals(tableName)) {
                        if (this.stockDetailParam.isShowDetail()) {
                            blockConf.setEnbale(true);
                            costAdjust_Filter = this.commonFilter(tableName, materialIdContainer, null);
                        } else {
                            blockConf.setEnbale(false);
                        }
                    } else if ("cal_costadjustbill".equals(tableName)) {
                        if (this.stockDetailParam.isShowDetail()) {
                            blockConf.setEnbale(false);
                        } else {
                            blockConf.setEnbale(true);
                            costAdjust_Filter = this.commonFilter(tableName, materialIdContainer, null);
                        }
                    }
                    if (costAdjust_Filter == null) break;
                    blockConf.setDataFs(costAdjust_Filter);
                    blockConf.setAllowNotMatch(true);
                    Map srcColMap = blockConf.getRepoColSrcColMap();
                    srcColMap.put("entryid", "entryid");
                    blockConf.setRepoColSrcColMap(srcColMap);
                    Map repoColFullSrcColMap = blockConf.getRepoColFullSrcColMap();
                    repoColFullSrcColMap.put("entryid", "entryentity.id");
                    blockConf.setRepoColFullSrcColMap(repoColFullSrcColMap);
                    srcColMap = blockConf.getRepoColSrcColMap();
                    srcColMap.put("billid", "billid");
                    blockConf.setRepoColSrcColMap(srcColMap);
                    repoColFullSrcColMap = blockConf.getRepoColFullSrcColMap();
                    repoColFullSrcColMap.put("billid", "id");
                    blockConf.setRepoColFullSrcColMap(repoColFullSrcColMap);
                    List costAdjustTransform = blockConf.getDataTransform();
                    if (costAdjustTransform != null) {
                        costAdjustTransform.add(new CostAdjustTransform(this.getLocale_costAdjustName(), periodSumGroup));
                    }
                    result.add(blockConf);
                    break;
                }
                case "cal_stdcostdiffbill": {
                    String std_bizObject;
                    QFilter std_Filter = null;
                    Map std_defVals = blockConf.getDefVals();
                    String string = std_bizObject = std_defVals.get("bizentityobject") == null ? "" : (String)std_defVals.get("bizentityobject");
                    if ("\"cal_costadjust_subentity_detail\"".equals(std_bizObject)) {
                        if (this.stockDetailParam.isShowDetail()) {
                            blockConf.setEnbale(true);
                            std_Filter = this.commonFilter(tableName, materialIdContainer, null);
                        } else {
                            blockConf.setEnbale(false);
                        }
                    } else if ("\"cal_costadjust_subentity\"".equals(std_bizObject)) {
                        if (this.stockDetailParam.isShowDetail()) {
                            blockConf.setEnbale(false);
                        } else {
                            blockConf.setEnbale(true);
                            std_Filter = this.commonFilter(tableName, materialIdContainer, null);
                        }
                    }
                    if (std_Filter == null) break;
                    blockConf.setDataFs(std_Filter);
                    blockConf.setAllowNotMatch(true);
                    Map srcColMap = blockConf.getRepoColSrcColMap();
                    srcColMap.put("entryid", "entryid");
                    blockConf.setRepoColSrcColMap(srcColMap);
                    Map repoColFullSrcColMap = blockConf.getRepoColFullSrcColMap();
                    repoColFullSrcColMap.put("entryid", "entryentity.id");
                    blockConf.setRepoColFullSrcColMap(repoColFullSrcColMap);
                    srcColMap = blockConf.getRepoColSrcColMap();
                    srcColMap.put("billid", "billid");
                    blockConf.setRepoColSrcColMap(srcColMap);
                    repoColFullSrcColMap = blockConf.getRepoColFullSrcColMap();
                    repoColFullSrcColMap.put("billid", "id");
                    blockConf.setRepoColFullSrcColMap(repoColFullSrcColMap);
                    List costDiff = blockConf.getDataTransform();
                    if (costDiff != null) {
                        costDiff.add(new CostDiffTransform(this.getLocale_stdDiffName(), periodSumGroup, this.stockDetailParam));
                    }
                    result.add(blockConf);
                    break;
                }
                case "cal_balance": 
                case "cal_balance_subentity": {
                    if (isNewBalance) break;
                    for (Integer period : periodNumber) {
                        SrcBlockConf curBalance = new SrcBlockConf();
                        curBalance.setDefVals(blockConf.getDefVals());
                        curBalance.setRepoColFullSrcColMap(blockConf.getRepoColFullSrcColMap());
                        curBalance.setRepoColSrcColMap(blockConf.getRepoColSrcColMap());
                        curBalance.setSrcEntity(blockConf.getSrcEntity());
                        curBalance.setType(blockConf.getType());
                        curBalance.setAllowNotMatch(true);
                        QFilter calBalance_Filter = null;
                        if ("cal_balance_subentity".equals(tableName)) {
                            if (this.stockDetailParam.isShowDetail()) {
                                curBalance.setEnbale(true);
                                calBalance_Filter = this.commonFilter(tableName, materialIdContainer, period);
                            } else {
                                curBalance.setEnbale(false);
                            }
                        } else if ("cal_balance".equals(tableName)) {
                            if (this.stockDetailParam.isShowDetail()) {
                                curBalance.setEnbale(false);
                            } else {
                                curBalance.setEnbale(true);
                                calBalance_Filter = this.commonFilter(tableName, materialIdContainer, period);
                            }
                        }
                        if (calBalance_Filter == null) continue;
                        curBalance.setDataFs(calBalance_Filter);
                        List calBalanceTransform = curBalance.getDataTransform();
                        if (calBalanceTransform != null) {
                            calBalanceTransform.add(new CalBalanceTransform(period, periodSumGroup, this.stockDetailParam, ctx));
                        }
                        result.add(curBalance);
                    }
                    break;
                }
                case "cal_bal": {
                    if (!isNewBalance) break;
                    for (Integer period : periodNumber) {
                        SrcBlockConf curBal = new SrcBlockConf();
                        curBal.setDefVals(blockConf.getDefVals());
                        curBal.setRepoColFullSrcColMap(blockConf.getRepoColFullSrcColMap());
                        curBal.setRepoColSrcColMap(blockConf.getRepoColSrcColMap());
                        curBal.setSrcEntity(blockConf.getSrcEntity());
                        curBal.setType(blockConf.getType());
                        curBal.setAllowNotMatch(true);
                        QFilter calBal_Filter = this.commonFilter(tableName, materialIdContainer, period);
                        curBal.setDataFs(calBal_Filter);
                        NewReportDataHelper.addNewBalDimCols((ReportDataCtx)ctx, (SrcBlockConf)curBal, (CalBaseRptParam)this.stockDetailParam);
                        List calBalTransform = curBal.getDataTransform();
                        if (calBalTransform != null) {
                            calBalTransform.add(new CalBalTransform(period, periodSumGroup));
                        }
                        result.add(curBal);
                    }
                    break;
                }
                case "cal_initbill": {
                    String bizObject;
                    QFilter initbalance_Filter = null;
                    Map defVals = blockConf.getDefVals();
                    String string = bizObject = defVals.get("bizentityobject") == null ? "" : (String)defVals.get("bizentityobject");
                    if ("\"initbalancedetail\"".equals(bizObject)) {
                        if (this.stockDetailParam.isShowDetail()) {
                            blockConf.setEnbale(true);
                            initbalance_Filter = this.commonFilter(tableName, materialIdContainer, null);
                        } else {
                            blockConf.setEnbale(false);
                        }
                    } else if ("\"initbalance\"".equals(bizObject) || "\"\"".equals(bizObject)) {
                        if (this.stockDetailParam.isShowDetail()) {
                            blockConf.setEnbale(false);
                        } else {
                            blockConf.setEnbale(true);
                            initbalance_Filter = this.commonFilter(tableName, materialIdContainer, null);
                        }
                    }
                    if (initbalance_Filter == null) break;
                    blockConf.setDataFs(initbalance_Filter);
                    blockConf.setAllowNotMatch(true);
                    List calBalanceTransform = blockConf.getDataTransform();
                    if (calBalanceTransform != null) {
                        calBalanceTransform.add(new InitBalanceTransform(periodSumGroup));
                    }
                    result.add(blockConf);
                }
            }
        }
        if (this.stockDetailParam.isShowDetail() && !showdetailUnBlockCol) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f00\u542f\u201c\u6309\u5206\u9879\u7ed3\u8f6c\u660e\u7ec6\u67e5\u770b\u62a5\u8868\u201d\u67e5\u8be2\u62a5\u8868\u65f6\u7531\u4e8e\u62a5\u8868\u6570\u636e\u6e90\u914d\u7f6e\u4e2d\u7f3a\u5931\u90e8\u5206\u6570\u636e\u5757\u8bf7\u91cd\u65b0\u914d\u7f6e\u3002", (String)"StockGatherSumReportHandle_0", (String)"fi-cal-report", (Object[])new Object[0]));
        }
        ctx.getReportConf().setSrcBlockConf(result);
    }

    public static Set<String> addNewBalDimCols(ReportDataCtx ctx, SrcBlockConf blockConf) {
        HashSet<String> otherBalDims = new HashSet<String>(16);
        Set newBalDimFields = CalBalanceModelHelper.getDimField();
        Set allKeyColsA = ReportUtil.filterBigtableCols((ReportConf)ctx.getReportConf(), colConf -> "A".equals(colConf.getCalType()));
        Set allKeyColsB = ReportUtil.filterBigtableCols((ReportConf)ctx.getReportConf(), colConf -> "B".equals(colConf.getCalType()));
        Set allKeyColsC = ReportUtil.filterBigtableCols((ReportConf)ctx.getReportConf(), colConf -> "C".equals(colConf.getCalType()));
        for (String dim : newBalDimFields) {
            if (allKeyColsA.contains(dim) || allKeyColsB.contains(dim) || allKeyColsC.contains(dim)) continue;
            otherBalDims.add(dim);
        }
        Map srcColMap = blockConf.getRepoColSrcColMap();
        Map repoColFullSrcColMap = blockConf.getRepoColFullSrcColMap();
        if (!otherBalDims.isEmpty()) {
            for (String dim : otherBalDims) {
                srcColMap.put(dim, dim);
                repoColFullSrcColMap.put(dim, dim);
            }
        }
        blockConf.setRepoColSrcColMap(srcColMap);
        blockConf.setRepoColFullSrcColMap(repoColFullSrcColMap);
        return otherBalDims;
    }

    public void transFormAfterUnion(List<IDataXTransform> transCollector, ReportDataCtx ctx) {
        transCollector.add((IDataXTransform)new CombinePeriodTransform(calBalanceGroup, this.getCalperiodEndOrderByField(), ctx));
        transCollector.add((IDataXTransform)new CombineTotalTransform(periodEndGroup, ctx));
        transCollector.add((IDataXTransform)new PeriodTotalSumTransform(periodSumGroup, this.stockDetailParam, ctx, "new"));
    }

    public void handleBigtableCols(Set<String> repoColFilter, ReportDataCtx ctx) {
        String[][] stringArray = engageFields;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String[] part;
            for (String engageField : part = stringArray[i]) {
                repoColFilter.add(engageField);
            }
        }
        repoColFilter.add("tartranstype");
        repoColFilter.add("tarbiztype");
        repoColFilter.add("tarbizentityobject");
        repoColFilter.addAll(this.stockDetailParam.getOtherBalDims());
    }

    public void beforeGroupData(ReportDataCtx ctx) {
        ctx.setGroupPlans(null);
    }

    public void transFormAfterGroup(List<IDataXTransform> transCollector, ReportDataCtx ctx) {
        transCollector.add((IDataXTransform)new AddMaterialGroupTransform(ctx, this.stockDetailParam));
        transCollector.add((IDataXTransform)new MaterialGroupCoverTransform(ctx, this.stockDetailParam));
        ArrayList<String> waitForDelete = new ArrayList<String>(Arrays.asList(engageFields[2]));
        ArrayList<String> waitForOrder = new ArrayList<String>(Arrays.asList(this.getOrder(this.stockDetailParam)));
        ArrayList<String> waitForCalculate = new ArrayList<String>(Arrays.asList(engageFields[1]));
        waitForDelete.removeAll(waitForOrder);
        waitForDelete.removeAll(waitForCalculate);
        transCollector.add((IDataXTransform)new FinalDataTransform(this.stockDetailParam, waitForDelete));
    }

    public void transformResult(List<IDataTransform> transCollector, ReportDataCtx ctx) {
        transCollector.add((IDataTransform)new FinalDataOrderTansform(this.getOrder(this.stockDetailParam)));
        transCollector.add((IDataTransform)new ToCharFieldDataTransform("period"));
        this.stockDetailParam.closeMaterialCategory();
    }

    public List<AbstractReportColumn> buildShowColumn(List<AbstractReportColumn> cols, ReportDataCtx ctx) {
        ArrayList<AbstractReportColumn> reslutcols = new ArrayList<AbstractReportColumn>(cols.size());
        ArrayList periodbegincols = new ArrayList();
        ArrayList<AbstractReportColumn> periodincols = new ArrayList<AbstractReportColumn>();
        ArrayList<AbstractReportColumn> periodOutcols = new ArrayList<AbstractReportColumn>();
        ArrayList<AbstractReportColumn> periodEndcols = new ArrayList<AbstractReportColumn>();
        HashSet<String> shouldDelete = new HashSet<String>(16);
        shouldDelete.addAll(Arrays.asList(helpOrderField));
        HashSet<String> backGroundKeepField = new HashSet<String>(Arrays.asList(StockDetailRptResourceCfg.backGroundKeepField));
        boolean noShowZero = this.stockDetailParam.isNoShowZero();
        for (AbstractReportColumn abstractReportColumn : cols) {
            ReportColumn reportCol = (ReportColumn)abstractReportColumn;
            String fieldKey = reportCol.getFieldKey();
            if (fieldKey.contains("periodin")) {
                reportCol.setZeroShow(false);
                reportCol.setNoDisplayScaleZero(noShowZero);
                periodincols.add(abstractReportColumn);
                continue;
            }
            if (fieldKey.contains("periodout")) {
                reportCol.setZeroShow(false);
                reportCol.setNoDisplayScaleZero(noShowZero);
                periodOutcols.add(abstractReportColumn);
                continue;
            }
            if (fieldKey.contains("periodend")) {
                reportCol.setZeroShow(false);
                reportCol.setNoDisplayScaleZero(noShowZero);
                periodEndcols.add(abstractReportColumn);
                continue;
            }
            if (backGroundKeepField.contains(fieldKey)) {
                ((ReportColumn)abstractReportColumn).setHide(true);
                reslutcols.add(abstractReportColumn);
                continue;
            }
            if (shouldDelete.contains(fieldKey)) continue;
            reslutcols.add(abstractReportColumn);
        }
        ReportColumnGroup begingroupCol = new ReportColumnGroup();
        begingroupCol.setCaption(this.locale_periodBegin);
        begingroupCol.setFieldKey("periodbegin");
        cols.add((AbstractReportColumn)begingroupCol);
        for (Object beginCol : periodbegincols) {
            begingroupCol.getChildren().add(beginCol);
        }
        reslutcols.add((AbstractReportColumn)begingroupCol);
        ReportColumnGroup reportColumnGroup = new ReportColumnGroup();
        reportColumnGroup.setCaption(this.locale_periodIn);
        reportColumnGroup.setFieldKey("periodin");
        cols.add((AbstractReportColumn)reportColumnGroup);
        for (Object inCol : periodincols) {
            reportColumnGroup.getChildren().add(inCol);
        }
        reslutcols.add((AbstractReportColumn)reportColumnGroup);
        ReportColumnGroup outgroupCol = new ReportColumnGroup();
        outgroupCol.setCaption(this.locale_periodOut);
        outgroupCol.setFieldKey("periodout");
        cols.add((AbstractReportColumn)outgroupCol);
        for (AbstractReportColumn abstractReportColumn : periodOutcols) {
            outgroupCol.getChildren().add(abstractReportColumn);
        }
        reslutcols.add((AbstractReportColumn)outgroupCol);
        ReportColumnGroup endgroupCol = new ReportColumnGroup();
        endgroupCol.setCaption(this.locale_periodEnd);
        endgroupCol.setFieldKey("periodend");
        cols.add((AbstractReportColumn)endgroupCol);
        for (AbstractReportColumn abstractReportColumn : periodEndcols) {
            endgroupCol.getChildren().add(abstractReportColumn);
        }
        reslutcols.add((AbstractReportColumn)endgroupCol);
        return reslutcols;
    }

    public static void getOwnerFilterNew(QFilter q, String filter_ownertype, DynamicObjectCollection filter_owner, String entityName) {
        if (StringUtils.isEmpty((String)filter_ownertype)) {
            return;
        }
        String entry = "";
        if ("cal_costrecord".equals(entityName)) {
            entry = "entry.";
        } else if ("cal_costadjustbill".equals(entityName)) {
            entry = "entryentity.";
        }
        q.and(entry + "ownertype", "=", (Object)filter_ownertype);
        if (filter_owner != null) {
            HashSet<Object> set = new HashSet<Object>(8);
            for (DynamicObject info : filter_owner) {
                set.add(info.getPkValue());
            }
            q.and(entry + "owner", "in", set);
        }
    }

    private String[] getCalperiodEndOrderByField() {
        Set accountTypeContainer = this.stockDetailParam.getAccountTypeContainer();
        String orderType = this.stockDetailParam.getOrderType();
        boolean showDetail = this.stockDetailParam.isShowDetail();
        if (accountTypeContainer.size() == 1 && accountTypeContainer.contains("D")) {
            if ("A".equals(orderType)) {
                if (showDetail) {
                    logger.info(orderType + "--------------------bookdate+audittime+" + accountTypeContainer);
                    return standardCost_TYPE_BizFirst_OneOrder_detail;
                }
                logger.info(orderType + "--------------------bookdate+audittime+" + accountTypeContainer);
                return standardCost_TYPE_BizFirst_OneOrder;
            }
            if (showDetail) {
                logger.info(orderType + "--------------------audittime+bookdate+" + accountTypeContainer);
                return standardCost_TYPE_AuditFirst_OneOrder_detail;
            }
            logger.info(orderType + "--------------------audittime+bookdate+" + accountTypeContainer);
            return standardCost_TYPE_AuditFirst_OneOrder;
        }
        if ("A".equals(orderType)) {
            if (showDetail) {
                logger.info(orderType + "--------------------bookdate+audittime");
                return standardCost_BizFirst_OneOrder_detail;
            }
            logger.info(orderType + "--------------------bookdate+audittime");
            return standardCost_BizFirst_OneOrder;
        }
        if (showDetail) {
            logger.info(orderType + "--------------------audittime+bookdate");
            return standardCost_AuditFirst_OneOrder_detail;
        }
        logger.info(orderType + "--------------------audittime+bookdate");
        return standardCost_AuditFirst_OneOrder;
    }

    private String[] getOrder(StockDetailRptParam param) {
        String[] orderFields;
        Set accountTypeContainer = param.getAccountTypeContainer();
        String orderType = param.getOrderType();
        boolean printAll = false;
        boolean topSumRow = param.isTopsumrow();
        boolean showDetail = param.isShowDetail();
        if (topSumRow) {
            if (accountTypeContainer.size() == 1 && accountTypeContainer.contains("D")) {
                if ("A".equals(orderType)) {
                    logger.info("------------------" + orderType + "--bookdate-audittime");
                    orderFields = printAll ? (showDetail ? top_standardCostOne_TYPE_BizFirst_Print_detail : top_standardCostOne_TYPE_BizFirst_Print) : (showDetail ? top_standardCostOne_TYPE_BizFirst_detail : top_standardCostOne_TYPE_BizFirst);
                } else {
                    logger.info("------------------" + orderType + "--audittime-bookdate");
                    orderFields = printAll ? (showDetail ? top_standardCostOne_TYPE_AuditFirst_Print_detail : top_standardCostOne_TYPE_AuditFirst_Print) : (showDetail ? top_standardCostOne_TYPE_AuditFirst_detail : top_standardCostOne_TYPE_AuditFirst);
                }
            } else if ("A".equals(orderType)) {
                logger.info("------------------" + orderType + "--bookdate-audittime");
                orderFields = printAll ? (showDetail ? top_standardCost_BizFirst_Print_detail : top_standardCost_BizFirst_Print) : (showDetail ? top_standardCost_BizFirst_detail : top_standardCost_BizFirst);
            } else {
                logger.info("------------------" + orderType + "--audittime-bookdate");
                orderFields = printAll ? (showDetail ? top_standardCost_AuditFirst_Print_detail : top_standardCost_AuditFirst_Print) : (showDetail ? top_standardCost_AuditFirst_detail : top_standardCost_AuditFirst);
            }
        } else if (accountTypeContainer.size() == 1 && accountTypeContainer.contains("D")) {
            if ("A".equals(orderType)) {
                logger.info("------------------" + orderType + "--bookdate-audittime");
                orderFields = printAll ? (showDetail ? standardCostOne_TYPE_BizFirst_Print_detail : standardCostOne_TYPE_BizFirst_Print) : (showDetail ? standardCostOne_TYPE_BizFirst_detail : standardCostOne_TYPE_BizFirst);
            } else {
                logger.info("------------------" + orderType + "--audittime-bookdate");
                orderFields = printAll ? (showDetail ? standardCostOne_TYPE_AuditFirst_Print_detail : standardCostOne_TYPE_AuditFirst_Print) : (showDetail ? standardCostOne_TYPE_AuditFirst_detail : standardCostOne_TYPE_AuditFirst);
            }
        } else if ("A".equals(orderType)) {
            logger.info("------------------" + orderType + "--bookdate-audittime");
            orderFields = printAll ? (showDetail ? standardCost_BizFirst_Print_detail : standardCost_BizFirst_Print) : (showDetail ? standardCost_BizFirst_detail : standardCost_BizFirst);
        } else {
            logger.info("------------------" + orderType + "--audittime-bookdate");
            orderFields = printAll ? (showDetail ? standardCost_AuditFirst_Print_detail : standardCost_AuditFirst_Print) : (showDetail ? standardCost_AuditFirst_detail : standardCost_AuditFirst);
        }
        return orderFields;
    }
}

