/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.formplugin.account;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.bos.entity.AppMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.cal.business.account.CloseAccountFacade;
import kd.fi.cal.business.account.CloseAccountParamBuilder;
import kd.fi.cal.common.helper.AccountingSysHelper;
import kd.fi.cal.common.model.CloseAccountParam;
import kd.fi.cal.common.util.DateUtils;
import kd.fi.cal.formplugin.queryscheme.QuerySchemeHolder;
import kd.fi.cal.formplugin.queryscheme.SchemeSettingPlugin;
import org.apache.commons.lang.time.DateFormatUtils;

public class CloseAccountPlugin
extends SchemeSettingPlugin
implements ProgresssListener,
BeforeF7SelectListener {
    private static final String KEY_PROGRESSBAR = "progressbarap";
    public static final String CACHEKEY_PROGRESS = "progress";
    public static final String CACHEKEY_STARTPROPGRESS = "startprogress";
    public static final String KEY_ENTRYENTITY = "entryentity";
    public static final String CHECKENTRY = "checkentry";
    public static final String MULCALORG = "mulcalorg";
    public static final String QUERY = "query";
    public static final String DOACCOUNT = "doaccount";
    public static final String UNDOACCOUNT = "undoaccount";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        this.addItemClickListeners(new String[]{"itemsbar"});
        this.addF7Listener(this, MULCALORG);
    }

    private void addF7Listener(BeforeF7SelectListener form, String ... f7Name) {
        for (String str : f7Name) {
            BasedataEdit f7Control = (BasedataEdit)this.getView().getControl(str);
            if (null == f7Control) continue;
            f7Control.addBeforeF7SelectListener(form);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        if (MULCALORG.equals(key)) {
            List<Long> orgList = this.getAllPermOrgs();
            DynamicObjectCollection accSysColl = AccountingSysHelper.getAccountingSysColls(orgList, null);
            HashSet<Long> calorgSet = new HashSet<Long>();
            for (DynamicObject accSysInfo : accSysColl) {
                calorgSet.add(accSysInfo.getLong("calorgid"));
            }
            ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(new QFilter("id", "in", calorgSet));
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        if ("btn_refresh".equals(evt.getItemKey())) {
            this.refresh();
        } else if ("bar_querylog".equals(evt.getItemKey())) {
            this.queryLog();
        } else if ("openall".equals(evt.getItemKey())) {
            this.changeCheckEntryStatus(true);
        } else if ("closeall".equals(evt.getItemKey())) {
            this.changeCheckEntryStatus(false);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs event) {
        EntryGrid entryGrid;
        int[] selectedRowIndexs;
        super.beforeDoOperation(event);
        FormOperate formOperate = (FormOperate)event.getSource();
        String key = formOperate.getOperateKey();
        if ("savescheme".equals(key) && (selectedRowIndexs = (entryGrid = (EntryGrid)this.getControl(KEY_ENTRYENTITY)).getSelectRows()).length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u5173\u8d26\u7684\u8d27\u4e3b\u3002", (String)"CloseAccountPlugin_9", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            event.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs event) {
        int[] legalSelectIndexs;
        super.afterDoOperation(event);
        String key = event.getOperateKey();
        if (QUERY.equals(key)) {
            this.loadGrid();
        } else if (DOACCOUNT.equals(key)) {
            DynamicObject closeAcctDyc = this.getModel().getDataEntity(true);
            if (CloseAccountParamBuilder.isUpdateInvDate((DynamicObject)closeAcctDyc, (String)"A").booleanValue() || CloseAccountParamBuilder.isUpdateInvDate((DynamicObject)closeAcctDyc, (String)"B").booleanValue()) {
                ConfirmCallBackListener callBackListener = new ConfirmCallBackListener("updateInvDate", (IFormPlugin)this);
                String loadKDString = ResManager.loadKDString((String)"\u672a\u6821\u9a8c\u5e93\u5b58\u672a\u5ba1\u6838\u72b6\u6001\u5355\u636e\u65f6\uff0c\u5173\u8d26\u9ed8\u8ba4\u5c06\u6682\u5b58\u3001\u63d0\u4ea4\u72b6\u6001\u7684\u5e93\u5b58\u4e0e\u6838\u7b97\u5355\u636e\u8bb0\u8d26\u65e5\u671f\u4fee\u6539\u4e3a\u5173\u8d26\u65e5\u671f\u540e\u4e00\u5929\uff0c\u662f\u5426\u786e\u8ba4\u5173\u8d26\uff1f", (String)"CloseAccountPlugin_8", (String)"fi-cal-formplugin", (Object[])new Object[0]);
                this.getView().showConfirm(loadKDString, null, MessageBoxOptions.YesNo, null, callBackListener, null, "");
                return;
            }
            if (!this.checkCloseAccountDate()) {
                return;
            }
            int[] legalSelectIndexs2 = this.checkCloseDate();
            if (legalSelectIndexs2 != null) {
                this.closeAccount(legalSelectIndexs2);
            }
        } else if (UNDOACCOUNT.equals(key) && (legalSelectIndexs = this.CheckUnCloseDate()) != null) {
            this.unCloseAccount(legalSelectIndexs);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.loadCheckItemList();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.loadGrid();
        this.getView().setVisible(Boolean.FALSE, new String[]{KEY_PROGRESSBAR});
        this.getView().getModel().setDataChanged(false);
    }

    public void onProgress(ProgressEvent e) {
        String startProgress = this.getPageCache().get(CACHEKEY_STARTPROPGRESS);
        if (StringUtils.isEmpty((String)startProgress)) {
            e.setProgress(0);
            e.setText(ResManager.loadKDString((String)" \u672a\u5f00\u59cb ", (String)"CloseAccountPlugin_0", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        }
        int progress = 0;
        String text = ResManager.loadKDString((String)" \u8fdb\u884c\u4e2d ...", (String)"CloseAccountPlugin_1", (String)"fi-cal-formplugin", (Object[])new Object[0]);
        String cacheProgress = this.getPageCache().get(CACHEKEY_PROGRESS);
        if (!StringUtils.isEmpty((String)cacheProgress)) {
            progress = Integer.parseInt(cacheProgress);
        }
        if (progress >= 100) {
            text = ResManager.loadKDString((String)" \u5b8c\u6210 ", (String)"CloseAccountPlugin_2", (String)"fi-cal-formplugin", (Object[])new Object[0]);
        }
        if (startProgress.equals("false")) {
            text = ResManager.loadKDString((String)"\u5df2\u53d6\u6d88\u6267\u884c ", (String)"CloseAccountPlugin_3", (String)"fi-cal-formplugin", (Object[])new Object[0]);
        }
        e.setProgress(progress);
        e.setText(text);
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        int[] legalSelectIndex;
        super.confirmCallBack(e);
        MessageBoxResult result = e.getResult();
        if (e.getCallBackId().equals("updateInvDate") && MessageBoxResult.Yes.equals((Object)result)) {
            legalSelectIndex = this.checkCloseDate();
            if (this.checkCloseAccountDate() && legalSelectIndex != null) {
                this.closeAccount(legalSelectIndex);
            }
        }
        if (e.getCallBackId().equals("closeDateConfirm") && MessageBoxResult.Yes.equals((Object)result) && (legalSelectIndex = this.checkCloseDate()) != null) {
            this.closeAccount(legalSelectIndex);
        }
    }

    protected void afterSelScheme() {
        super.afterSelScheme();
        this.reloadDycData();
        this.setCheckItem();
    }

    protected void afterAddScheme() {
        super.afterAddScheme();
        this.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeAccount(int[] legalSelectIndexs) {
        ArrayList<DLock> lockList = new ArrayList<DLock>(16);
        try {
            HashMap<Long, String> ownerMap = new HashMap<Long, String>(16);
            for (int i = 0; i < legalSelectIndexs.length; ++i) {
                DynamicObject ownerObject = (DynamicObject)this.getModel().getValue("owner", legalSelectIndexs[i]);
                ownerMap.put(ownerObject.getLong("id"), ownerObject.getString("name"));
            }
            for (Map.Entry entry : ownerMap.entrySet()) {
                String lockId = "CloseAccount" + entry.getKey();
                DLock lock = DLock.create((String)lockId, (String)ResManager.loadKDString((String)"\u5173\u8d26\u9501", (String)"CloseAccountPlugin_20", (String)"fi-cal-formplugin", (Object[])new Object[0]));
                lockList.add(lock);
                if (lock.tryLock()) continue;
                String msgStr = MessageFormat.format(ResManager.loadKDString((String)"\u8d27\u4e3b\u201c{0}\u201d\u6b63\u5728\u8fdb\u884c\u5173\u8d26\uff0c\u8bf7\u7a0d\u5019\u3002", (String)"CloseAccountPlugin_11", (String)"fi-cal-formplugin", (Object[])new Object[0]), entry.getValue());
                throw new KDBizException(msgStr);
            }
            DynamicObject closeAcctDyc = this.getModel().getDataEntity(true);
            CloseAccountParamBuilder closeAccountParamBuilder = new CloseAccountParamBuilder(closeAcctDyc);
            Long querySchemeId = new QuerySchemeHolder(this.getView()).getCurSchemeId();
            closeAccountParamBuilder.setQuerySchemeId(querySchemeId);
            CloseAccountParam[] params = closeAccountParamBuilder.build(legalSelectIndexs);
            Map failMap = new CloseAccountFacade().doCloseAccount(params);
            this.loadSuccessEntry(legalSelectIndexs);
            this.updateEntryResult(legalSelectIndexs, failMap, true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5173\u8d26\u8bf7\u6c42\u5df2\u63d0\u4ea4\u5904\u7406\uff0c\u8bf7\u67e5\u770b\u65e5\u5fd7\u3002", (String)"CloseAccountPlugin_6", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        }
        catch (Exception e) {
            this.getView().showTipNotification(ResManager.loadKDString((String)e.getMessage(), (String)"CloseAccountPlugin_13", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        }
        finally {
            for (DLock lock : lockList) {
                if (lock == null) continue;
                lock.close();
            }
        }
    }

    private void unCloseAccount(int[] legalSelectIndexs) {
        DynamicObject closeAcctDyc = this.getModel().getDataEntity(true);
        CloseAccountParamBuilder closeAccountParamBuilder = new CloseAccountParamBuilder(closeAcctDyc);
        CloseAccountParam[] params = closeAccountParamBuilder.build(legalSelectIndexs);
        Long querySchemeId = new QuerySchemeHolder(this.getView()).getCurSchemeId();
        closeAccountParamBuilder.setQuerySchemeId(querySchemeId);
        Map failMap = new CloseAccountFacade().doUnCloseAccount(params);
        this.loadSuccessEntry(legalSelectIndexs);
        this.updateEntryResult(legalSelectIndexs, failMap, false);
        this.getView().showTipNotification(ResManager.loadKDString((String)"\u53cd\u5173\u8d26\u8bf7\u6c42\u5df2\u63d0\u4ea4\u5904\u7406\uff0c\u8bf7\u67e5\u770b\u65e5\u5fd7\u3002", (String)"CloseAccountPlugin_7", (String)"fi-cal-formplugin", (Object[])new Object[0]));
    }

    private void refresh() {
        this.loadGrid();
        this.loadCheckItemList();
    }

    private void loadGrid() {
        Long calorgid;
        DynamicObjectCollection accSysColl;
        List<Long> orgList;
        this.getModel().deleteEntryData(KEY_ENTRYENTITY);
        DynamicObjectCollection mulcalorg = (DynamicObjectCollection)this.getModel().getValue(MULCALORG);
        if (mulcalorg != null && !mulcalorg.isEmpty()) {
            orgList = new ArrayList<Long>(mulcalorg.size());
            for (DynamicObject org : mulcalorg) {
                orgList.add(org.getLong("fbasedataid_id"));
            }
        } else {
            orgList = this.getAllPermOrgs();
        }
        if ((accSysColl = AccountingSysHelper.getAccountingSysColls(orgList, null)).size() == 0) {
            return;
        }
        HashSet<Long> ownerIdSet = new HashSet<Long>();
        HashSet<Long> calorgSet = new HashSet<Long>();
        for (DynamicObject accSysInfo : accSysColl) {
            ownerIdSet.add(accSysInfo.getLong("ownerid"));
            calorgSet.add(accSysInfo.getLong("calorgid"));
        }
        Long[] calOrgIds = AccountingSysHelper.getCalOrgIds(calorgSet);
        calorgSet.retainAll(Arrays.asList(calOrgIds));
        Map calOrgIdCurPeriodMaxEndateMap = CloseAccountParamBuilder.getCalOrgCurPeriodMaxEndDateMap(calorgSet);
        Map ownerIdLastCloseAccountDycMap = CloseAccountParamBuilder.getOwnerIdLastCloseAcctDycMap(ownerIdSet);
        ArrayList<DynamicObject> hasAccountAccSysDycs = new ArrayList<DynamicObject>(16);
        for (DynamicObject accSysDyc : accSysColl) {
            calorgid = accSysDyc.getLong("calorgid");
            if (!calorgSet.contains(calorgid)) continue;
            hasAccountAccSysDycs.add(accSysDyc);
        }
        accSysColl.clear();
        accSysColl.addAll(hasAccountAccSysDycs);
        if (accSysColl.isEmpty()) {
            return;
        }
        this.getModel().batchCreateNewEntryRow(KEY_ENTRYENTITY, accSysColl.size());
        DynamicObject lastInfo = null;
        this.getModel().beginInit();
        for (int i = 0; i < accSysColl.size(); ++i) {
            calorgid = ((DynamicObject)accSysColl.get(i)).getLong("calorgid");
            if (!calorgSet.contains(calorgid)) continue;
            Long ownerId = ((DynamicObject)accSysColl.get(i)).getLong("ownerid");
            lastInfo = (DynamicObject)ownerIdLastCloseAccountDycMap.get(ownerId);
            this.getModel().setValue("owner", (Object)ownerId, i);
            this.getModel().setValue("accsys", ((DynamicObject)accSysColl.get(i)).get("id"), i);
            this.getModel().setValue("calorg", (Object)calorgid, i);
            Date maxEndDate = (Date)calOrgIdCurPeriodMaxEndateMap.get(calorgid);
            if (maxEndDate != null) {
                this.getModel().setValue("closedate", (Object)DateUtils.getDayStartTime((Date)maxEndDate), i);
            }
            if (lastInfo != null) {
                this.getModel().setValue("lastclosedate", (Object)lastInfo.getDate("closedate"), i);
                continue;
            }
            this.getModel().setValue("lastclosedate", null, i);
        }
        this.getModel().endInit();
        this.getView().updateView(KEY_ENTRYENTITY);
    }

    private void loadSuccessEntry(int[] indexs) {
        HashSet<Long> ownerSet = new HashSet<Long>(32);
        for (int i : indexs) {
            ownerSet.add(((DynamicObject)this.getModel().getValue("owner", i)).getLong("id"));
        }
        Map ownerIdLastCloseAcctDycMap = CloseAccountParamBuilder.getOwnerIdLastCloseAcctDycMap(ownerSet);
        for (int i : indexs) {
            Long key = (Long)((DynamicObject)this.getModel().getValue("owner", i)).getPkValue();
            if (ownerIdLastCloseAcctDycMap.get(key) != null) {
                this.getModel().setValue("lastclosedate", (Object)((DynamicObject)ownerIdLastCloseAcctDycMap.get(key)).getDate("closedate"), i);
            } else {
                this.getModel().setValue("lastclosedate", null, i);
            }
            this.getView().updateView(KEY_ENTRYENTITY, i);
        }
    }

    private void updateEntryResult(int[] selectedRowIndexs, Map<Long, String> failMap, boolean isClose) {
        String successResult = "A";
        String failResult = "B";
        if (!isClose) {
            successResult = "C";
            failResult = "D";
        }
        this.getModel().beginInit();
        for (int i : selectedRowIndexs) {
            DynamicObject owner = (DynamicObject)this.getModel().getValue("owner", i);
            if (failMap.containsKey(owner.getLong("id"))) {
                this.getModel().setValue("result", (Object)failResult, i);
                this.getModel().setValue("log", (Object)failMap.get(owner.getLong("id")), i);
                continue;
            }
            this.getModel().setValue("result", (Object)successResult, i);
            this.getModel().setValue("log", null, i);
        }
        this.getModel().endInit();
        this.getView().updateView(KEY_ENTRYENTITY);
    }

    private boolean doValidate(int[] selectedRowIndexs, String flag, String msg) {
        if (selectedRowIndexs.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u9009\u62e9\u8d27\u4e3b", (String)"CloseAccountPlugin_4", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            return false;
        }
        HashSet<Long> set = new HashSet<Long>(32);
        for (int i = 0; i < selectedRowIndexs.length; ++i) {
            DynamicObject calorg = (DynamicObject)this.getModel().getValue("calorg", selectedRowIndexs[i]);
            set.add(calorg.getLong("id"));
        }
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        for (Long calorgid : set) {
            int result = this.getCalOrgPermission(calorgid, userId, flag);
            if (result > 0) continue;
            this.getView().showErrorNotification(msg);
            return false;
        }
        return true;
    }

    private List<Long> getAllPermOrgs() {
        String appInnerId;
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        HasPermOrgResult rs = PermissionServiceHelper.getAllPermOrgs((Long)userId, (String)(appInnerId = AppMetadataCache.getAppInfo((String)"cal").getId()), (String)"cal_closeaccount", (String)"47150e89000000ac");
        if (!rs.hasAllOrgPerm()) {
            return rs.getHasPermOrgs();
        }
        return null;
    }

    private int getCalOrgPermission(Long orgId, Long userId, String flag) {
        int result = PermissionServiceHelper.checkPermission((long)userId, (String)"DIM_ORG", (long)orgId, (String)"/KIUHEXROK3D", (String)"cal_closeaccount", (String)flag);
        return result;
    }

    public boolean getIsCheckStatus() {
        return true;
    }

    private void loadCheckItemList() {
        String entryKey = CHECKENTRY;
        DynamicObjectCollection checkItems = QueryServiceHelper.query((String)"cal_datacheck_task", (String)"purpose,entryentity.checkitem,entryentity.entryenable,entryentity.level", (QFilter[])new QFilter("id", "in", (Object)1255063777360084992L).toArray(), (String)"purpose asc,entryentity.checkitem.number asc");
        if (checkItems.isEmpty()) {
            return;
        }
        this.getModel().deleteEntryData(entryKey);
        this.getModel().batchCreateNewEntryRow(entryKey, checkItems.size());
        int row = 0;
        for (DynamicObject item : checkItems) {
            this.getModel().setValue("purpose", (Object)item.getString("purpose"), row);
            this.getModel().setValue("checkitem", (Object)item.getLong("entryentity.checkitem"), row);
            this.getModel().setValue("ischeck", (Object)item.getBoolean("entryentity.entryenable"), row);
            this.getModel().setValue("level", (Object)item.getString("entryentity.level"), row);
            ++row;
        }
        this.getView().updateView(entryKey);
    }

    private void queryLog() {
        EntryGrid entryGrid = (EntryGrid)this.getControl(KEY_ENTRYENTITY);
        int[] selectedRowIndexs = entryGrid.getSelectRows();
        if (selectedRowIndexs.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"SettleAccountPlugin_4", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            return;
        }
        ListShowParameter listParameter = new ListShowParameter();
        listParameter.setBillFormId("cal_closeaccountlog");
        listParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        HashSet<Object> ownerIds = new HashSet<Object>(16);
        HashMap<String, String> calOrgIdNameMap = new HashMap<String, String>(16);
        for (int selectedRowIndex : selectedRowIndexs) {
            DynamicObject ownerDyc = (DynamicObject)this.getModel().getValue("owner", selectedRowIndex);
            if (ownerDyc == null) continue;
            ownerIds.add(ownerDyc.getPkValue());
            DynamicObject calOrgDyc = (DynamicObject)this.getModel().getValue("calorg", selectedRowIndex);
            if (calOrgDyc == null) continue;
            calOrgIdNameMap.put(calOrgDyc.getString("id"), calOrgDyc.getString("name"));
        }
        QFilter q = new QFilter("owner", "in", ownerIds);
        listParameter.setCustomParam("filter", (Object)q.toString());
        listParameter.setCustomParam("calorg", calOrgIdNameMap);
        this.getView().showForm((FormShowParameter)listParameter);
    }

    private int[] checkCloseDate() {
        EntryGrid entryGrid = (EntryGrid)this.getControl(KEY_ENTRYENTITY);
        int[] selectedRowIndexs = entryGrid.getSelectRows();
        if (!this.doValidate(selectedRowIndexs, "/O6GR+6VXPQ2", ResManager.loadKDString((String)"\u65e0\u201c\u671f\u672b\u5173\u8d26\u201d\u7684\u201c\u5173\u8d26\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"CloseAccountPlugin_5", (String)"fi-cal-formplugin", (Object[])new Object[0]))) {
            return null;
        }
        HashSet<Integer> legalIndexSet = new HashSet<Integer>(16);
        this.getModel().beginInit();
        for (int i = 0; i < selectedRowIndexs.length; ++i) {
            Date maxBeginDate;
            DynamicObject owner = (DynamicObject)this.getModel().getValue("owner", selectedRowIndexs[i]);
            Date closeDate = (Date)this.getModel().getValue("closedate", selectedRowIndexs[i]);
            Date lastCloseDate = (Date)this.getModel().getValue("lastclosedate", selectedRowIndexs[i]);
            if (closeDate == null) {
                this.getModel().setValue("result", (Object)"B", selectedRowIndexs[i]);
                this.getModel().setValue("log", (Object)ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u5173\u8d26\u65e5\u671f\u3002", (String)"CloseAccountFacade_14", (String)"fi-cal-business", (Object[])new Object[0]), selectedRowIndexs[i]);
                this.getView().updateView("result", selectedRowIndexs[i]);
                this.getView().updateView("log", selectedRowIndexs[i]);
                continue;
            }
            if (lastCloseDate != null && closeDate.compareTo(lastCloseDate) <= 0) {
                this.getModel().setValue("result", (Object)"B", selectedRowIndexs[i]);
                String val = String.format(ResManager.loadKDString((String)"\u8d27\u4e3b\u201c%1$s\u201d\u5df2\u5173\u8d26\u3002", (String)"CloseAccountFacade_20", (String)"fi-cal-business", (Object[])new Object[0]), owner.getString("name"));
                this.getModel().setValue("log", (Object)val, selectedRowIndexs[i]);
                this.getView().updateView("result", selectedRowIndexs[i]);
                this.getView().updateView("log", selectedRowIndexs[i]);
                continue;
            }
            if (lastCloseDate == null && (maxBeginDate = AccountingSysHelper.getCurrentPeriodMaxDateByOwner((long)owner.getLong("id"))) != null && closeDate.compareTo(maxBeginDate) < 0) {
                this.getModel().setValue("result", (Object)"B", selectedRowIndexs[i]);
                String val = String.format(ResManager.loadKDString((String)"\u5173\u8d26\u65e5\u671f\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u6309\u6838\u7b97\u4f53\u7cfb\u4e0e\u6838\u7b97\u7ec4\u7ec7\u53d6\u6838\u7b97\u671f\u95f4\u4e2d\u6700\u5927\u7684\u4e00\u4e2a\u671f\u95f4\u7684\u7b2c\u4e00\u5929\u201c%1$s\u201d\u3002", (String)"CloseAccountFacade_7", (String)"fi-cal-business", (Object[])new Object[0]), DateFormatUtils.format((Date)maxBeginDate, (String)"yyyy-MM-dd"));
                this.getModel().setValue("log", (Object)val, selectedRowIndexs[i]);
                this.getView().updateView("result", selectedRowIndexs[i]);
                this.getView().updateView("log", selectedRowIndexs[i]);
                continue;
            }
            legalIndexSet.add(selectedRowIndexs[i]);
        }
        this.getModel().endInit();
        Integer[] legalIndex = legalIndexSet.toArray(new Integer[0]);
        if (legalIndex.length == 0) {
            return null;
        }
        int[] legalIndexInt = new int[legalIndex.length];
        int i = 0;
        for (Integer index : legalIndex) {
            legalIndexInt[i] = index;
            ++i;
        }
        return legalIndexInt;
    }

    private int[] CheckUnCloseDate() {
        EntryGrid entryGrid = (EntryGrid)this.getControl(KEY_ENTRYENTITY);
        int[] selectedRowIndexs = entryGrid.getSelectRows();
        if (!this.doValidate(selectedRowIndexs, "/O6GVID5/Q7Z", ResManager.loadKDString((String)"\u65e0\u201c\u671f\u672b\u5173\u8d26\u201d\u7684\u201c\u53cd\u5173\u8d26\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"CloseAccountPlugin_10", (String)"fi-cal-formplugin", (Object[])new Object[0]))) {
            return null;
        }
        HashSet<Integer> legalIndexSet = new HashSet<Integer>(16);
        this.getModel().beginInit();
        for (int i = 0; i < selectedRowIndexs.length; ++i) {
            DynamicObject owner = (DynamicObject)this.getModel().getValue("owner", selectedRowIndexs[i]);
            Date lastCloseDate = (Date)this.getModel().getValue("lastclosedate", selectedRowIndexs[i]);
            if (lastCloseDate == null) {
                this.getModel().setValue("result", (Object)"D", selectedRowIndexs[i]);
                String val = String.format(ResManager.loadKDString((String)"\u8d27\u4e3b\u7f16\u7801\u201c%1$s\u201d\u540d\u79f0\u201c%2$s\u201d\u672a\u5173\u8d26\uff0c\u4e0d\u9700\u8981\u53cd\u5173\u8d26\u3002", (String)"CloseAccountFacade_21", (String)"fi-cal-business", (Object[])new Object[0]), owner.getString("number"), owner.getString("name"));
                this.getModel().setValue("log", (Object)val, selectedRowIndexs[i]);
                continue;
            }
            legalIndexSet.add(selectedRowIndexs[i]);
        }
        this.getModel().endInit();
        this.getView().updateView(KEY_ENTRYENTITY);
        Integer[] legalIndex = legalIndexSet.toArray(new Integer[0]);
        if (legalIndex.length == 0) {
            return null;
        }
        int[] legalIndexInt = new int[legalIndex.length];
        int i = 0;
        for (Integer index : legalIndex) {
            legalIndexInt[i] = index;
            ++i;
        }
        return legalIndexInt;
    }

    private void changeCheckEntryStatus(boolean isOpen) {
        DynamicObjectCollection checkEntry = this.getModel().getEntryEntity(CHECKENTRY);
        for (DynamicObject item : checkEntry) {
            item.set("ischeck", (Object)isOpen);
        }
        this.getView().updateView(CHECKENTRY);
    }

    private void reloadDycData() {
        EntryGrid entryEntityGrid = (EntryGrid)this.getView().getControl(KEY_ENTRYENTITY);
        int[] selectRows = entryEntityGrid.getSelectRows();
        DynamicObject closeDyc = this.getModel().getDataEntity(true);
        DynamicObjectCollection closeEntryDycs = closeDyc.getDynamicObjectCollection(KEY_ENTRYENTITY);
        HashSet<Long> ownerIds = new HashSet<Long>(16);
        HashSet<Long> calOrgIds = new HashSet<Long>(16);
        for (DynamicObject closeEntryDyc : closeEntryDycs) {
            DynamicObject calOrgDyc;
            DynamicObject ownerDyc = closeEntryDyc.getDynamicObject("owner");
            if (ownerDyc != null) {
                ownerIds.add((Long)ownerDyc.getPkValue());
            }
            if ((calOrgDyc = closeEntryDyc.getDynamicObject("calorg")) == null) continue;
            calOrgIds.add((Long)calOrgDyc.getPkValue());
        }
        Map calOrgIdCurPeriodMaxEndateMap = CloseAccountParamBuilder.getCalOrgCurPeriodMaxEndDateMap(calOrgIds);
        Map ownerIdLastCloseAccountDycMap = CloseAccountParamBuilder.getOwnerIdLastCloseAcctDycMap(ownerIds);
        for (DynamicObject closeEntryDyc : closeEntryDycs) {
            DynamicObject lastCloseDyc;
            DynamicObject ownerDyc = closeEntryDyc.getDynamicObject("owner");
            DynamicObject calOrgDyc = closeEntryDyc.getDynamicObject("calorg");
            if (ownerDyc != null && (lastCloseDyc = (DynamicObject)ownerIdLastCloseAccountDycMap.get((Long)ownerDyc.getPkValue())) != null) {
                closeEntryDyc.set("lastclosedate", (Object)lastCloseDyc.getDate("closedate"));
            }
            if (calOrgDyc != null) {
                closeEntryDyc.set("closedate", calOrgIdCurPeriodMaxEndateMap.get((Long)calOrgDyc.getPkValue()));
            }
            closeEntryDyc.set("result", null);
            closeEntryDyc.set("log", null);
        }
        this.getView().updateView(KEY_ENTRYENTITY);
        entryEntityGrid.selectRows(selectRows, 0);
    }

    private void setCheckItem() {
        DynamicObject checkItemDyc;
        this.getModel().beginInit();
        String entryKey = CHECKENTRY;
        DynamicObjectCollection checkEntryDycs = this.getModel().getEntryEntity(entryKey);
        HashMap<Long, Boolean> checkItemIdIsCheckMap = new HashMap<Long, Boolean>(16);
        for (DynamicObject checkEntryDyc : checkEntryDycs) {
            checkItemDyc = checkEntryDyc.getDynamicObject("checkitem");
            if (checkItemDyc == null) continue;
            checkItemIdIsCheckMap.put(checkItemDyc.getLong("id"), checkEntryDyc.getBoolean("ischeck"));
        }
        this.loadCheckItemList();
        checkEntryDycs = this.getModel().getEntryEntity(entryKey);
        for (DynamicObject checkEntryDyc : checkEntryDycs) {
            Boolean isCheck;
            checkItemDyc = checkEntryDyc.getDynamicObject("checkitem");
            if (checkItemDyc == null || (isCheck = (Boolean)checkItemIdIsCheckMap.get(checkItemDyc.getLong("id"))) == null) continue;
            checkEntryDyc.set("ischeck", (Object)isCheck);
        }
        this.getModel().endInit();
        this.getView().updateView(entryKey);
    }

    private boolean checkCloseAccountDate() {
        int[] selectedRowIndex = this.checkCloseDate();
        if (selectedRowIndex == null) {
            return true;
        }
        Date nowDate = new Date();
        StringJoiner msg = new StringJoiner("\u3001");
        for (int i = 0; i < selectedRowIndex.length; ++i) {
            DynamicObject ownerObject = (DynamicObject)this.getModel().getValue("owner", selectedRowIndex[i]);
            String ownerName = ownerObject.getString("name");
            Date closeDate = (Date)this.getModel().getValue("closedate", selectedRowIndex[i]);
            if (closeDate == null || !closeDate.after(nowDate)) continue;
            msg.add(MessageFormat.format(ResManager.loadKDString((String)"\u8d27\u4e3b-\u3010{0}\u3011", (String)"CloseAccountPlugin_23", (String)"fi-cal-formplugin", (Object[])new Object[0]), ownerName));
        }
        String confirmMsg = msg.toString();
        if (StringUtils.isNotEmpty((String)confirmMsg)) {
            ConfirmCallBackListener callBackListener = new ConfirmCallBackListener("closeDateConfirm", (IFormPlugin)this);
            String loadKDString = MessageFormat.format(ResManager.loadKDString((String)"{0}\u5bf9\u5e94\u7684\u5173\u8d26\u65e5\u671f\u5927\u4e8e\u5f53\u524d\u7cfb\u7edf\u65f6\u95f4\uff0c\u662f\u5426\u7ee7\u7eed\u5173\u8d26\uff1f", (String)"CloseAccountPlugin_24", (String)"fi-cal-formplugin", (Object[])new Object[0]), confirmMsg);
            this.getView().showConfirm(loadKDString, null, MessageBoxOptions.YesNo, null, callBackListener, null, "");
            return false;
        }
        return true;
    }
}

