/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.formplugin.bill;

import com.alibaba.fastjson.JSONObject;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.InitImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.ComboProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.EntryGridBindDataEvent;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.org.model.OrgViewTypeEnum;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.cal.common.constant.CalDbParamConstant;
import kd.fi.cal.common.enums.CostAdjustBilCreateTypeEnum;
import kd.fi.cal.common.enums.CostAdjustBillDiffTypeEnum;
import kd.fi.cal.common.helper.AccountingSysHelper;
import kd.fi.cal.common.helper.BatchFillEntryHelper;
import kd.fi.cal.common.helper.CalDbParamServiceHelper;
import kd.fi.cal.common.helper.CommonSettingHelper;
import kd.fi.cal.common.helper.CostElementHelper;
import kd.fi.cal.common.helper.OrgHelper;
import kd.fi.cal.common.helper.PeriodHelper;
import kd.fi.cal.common.helper.SCMHelper;
import kd.fi.cal.common.helper.WriteOffServerHelper;
import kd.fi.cal.common.util.DateUtils;

public class CostAdjustBillPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener,
EntryGridBindDataListener,
RowClickEventListener {
    private String COSTACCOUNT = "costaccount";
    private String BILLTYPE = "billtype";
    private String WAREHOUSE = "warehouse";
    private String LOCATION = "location";
    private String MATERIAL = "material";
    private String BIZTYPE = "biztype";
    private String BIZDATE = "bizdate";
    private String BOOKDATE = "bookdate";
    private String LOT = "lot";
    private String ENTRY = "entryentity";
    private String BASEUNIT = "baseunit";
    private String STORAGEORGUNIT = "storageorgunit";
    private Set<Long> disableSubElement = new HashSet<Long>(16);

    public void afterCreateNewData(EventObject e) {
        ((ComboEdit)this.getView().getControl("difftype")).setMustInput(true);
        this.getView().updateView("entryentity");
        DynamicObject calOrg = (DynamicObject)this.getModel().getValue("calorg");
        if (calOrg == null) {
            return;
        }
        long orgId = calOrg.getLong("id");
        this.getModel().setValue("owner", (Object)orgId, 0);
        String biztype = (String)SystemParamServiceHelper.getAppParameter((String)"/KIUHEXROK3D", (String)"10", (Long)orgId, (Long)0L, (String)"handcostadjustbiztype");
        DynamicObject billtype = (DynamicObject)SystemParamServiceHelper.getAppParameter((String)"/KIUHEXROK3D", (String)"10", (Long)orgId, (Long)0L, (String)"handcostadjustbilltype");
        if (biztype == null || billtype == null) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u6240\u5c5e\u7ec4\u7ec7\u672a\u7ef4\u62a4\u6210\u672c\u8c03\u6574\u5355\u53c2\u6570\uff0c\u8bf7\u8fdb\u5165\u201c\u7cfb\u7edf\u4e91>\u914d\u7f6e\u5de5\u5177>\u7cfb\u7edf\u53c2\u6570>\u5b58\u8d27\u6838\u7b97\u201d\u4e0b,\u9009\u62e9\u5f53\u524d\u7528\u6237\u7ec4\u7ec7\u540e,\u5bf9\u624b\u5de5\u65b0\u589e\u6210\u672c\u8c03\u6574\u5355\u8fdb\u884c\u76f8\u5e94\u914d\u7f6e\u3002", (String)"CostAdjustBillPlugin_0", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getModel().setValue("biztype", (Object)biztype);
        this.getModel().setValue("billtype", billtype.get("id"));
        if ("A".equals(biztype)) {
            this.getModel().setValue("cstype", (Object)"bd_supplier");
        } else {
            this.getModel().setValue("cstype", (Object)"bd_customer");
        }
        this.getModel().setValue("srcsys", (Object)"A");
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        Long calOrgId = OrgHelper.getCalOrgByUserOrg((Long)userId, (Long)orgId, (String)"cal_costadjustbill");
        this.getModel().setValue("difftype", (Object)CostAdjustBillDiffTypeEnum.ACT_COST.getValue());
        this.getModel().setValue("createtype", (Object)CostAdjustBilCreateTypeEnum.HAND.getValue());
        this.setCostAccountByCalOrg(calOrgId);
        DynamicObject costaccount = (DynamicObject)this.getModel().getValue("costaccount");
        DynamicObject currentPeriod = null;
        if (costaccount != null) {
            currentPeriod = PeriodHelper.getCurrentPeriod((Long)costaccount.getLong("id"));
        }
        Date sysDate = new Date();
        Date firstDate = currentPeriod != null ? currentPeriod.getDate("begindate") : sysDate;
        sysDate = sysDate.before(firstDate) ? firstDate : sysDate;
        sysDate = DateUtils.getDayStartTime((Date)sysDate);
        this.getModel().setValue(this.BIZDATE, (Object)sysDate);
        this.getModel().setValue(this.BOOKDATE, (Object)sysDate);
        DynamicObjectCollection entrys = this.getModel().getEntryEntity("entryentity");
        for (DynamicObject entry : entrys) {
            entry.set("invbizdate", (Object)sysDate);
        }
        this.initDept(calOrgId);
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
    }

    public void initialize() {
        super.initialize();
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        if (entryGrid != null) {
            entryGrid.addDataBindListener((EntryGridBindDataListener)this);
            entryGrid.addRowClickListener((RowClickEventListener)this);
        }
    }

    public void entryGridBindData(EntryGridBindDataEvent e) {
        boolean calByCostelement = this.getCalByCostElement();
        String billstatus = (String)this.getModel().getValue("billstatus");
        if (!"A".equals(billstatus)) {
            return;
        }
        boolean enable = !calByCostelement;
        this.getView().setEnable(Boolean.valueOf(enable), -1, new String[]{"adjustamt"});
    }

    private void initDept(Long calOrgId) {
        long userId = UserServiceHelper.getCurrentUserId();
        List deptids = OrgUnitServiceHelper.getAllToOrg((String)OrgViewTypeEnum.IS_ORGUNIT.getViewType(), (String)OrgViewTypeEnum.IS_ADMINISTRATIVE.getViewType(), (Long)calOrgId, (boolean)true);
        if (deptids != null && deptids.size() > 0) {
            List userdeptIds = UserServiceHelper.getUserDepartment((long)userId, (boolean)false);
            if (userdeptIds != null && userdeptIds.size() > 0) {
                for (Long deptId : userdeptIds) {
                    if (!deptids.contains(deptId)) continue;
                    this.getModel().setValue("adminorg", (Object)deptId);
                    break;
                }
            }
        } else {
            List userdeptIds = UserServiceHelper.getUserDepartment((long)userId, (boolean)false);
            if (userdeptIds != null && userdeptIds.size() > 0) {
                this.getModel().setValue("adminorg", userdeptIds.get(0));
            }
        }
    }

    public void initImportData(InitImportDataEventArgs e) {
        List sourceDataList = e.getSourceDataList();
        HashMap<String, Map<String, Long>> costAccountNum2CurrencyIdMap = new HashMap<String, Map<String, Long>>(4);
        for (Map sourceData : sourceDataList) {
            DynamicObject costAccount;
            sourceData.put("billstatus", "A");
            sourceData.put("createtype", CostAdjustBilCreateTypeEnum.HAND_IMPORT.getValue());
            sourceData.put("difftype", CostAdjustBillDiffTypeEnum.ACT_COST.getValue());
            sourceData.put("billcretype", "import");
            String biztype = (String)sourceData.get("biztype");
            if ("A".equals(biztype)) {
                sourceData.put("cstype", "bd_supplier");
            } else {
                sourceData.put("cstype", "bd_customer");
            }
            sourceData.put("period", null);
            sourceData.put("bizdate", sourceData.get("bookdate"));
            Object currency = sourceData.get("currency");
            if (currency != null) continue;
            JSONObject costaccount = (JSONObject)sourceData.get("costaccount");
            String costAccountNum = (String)costaccount.get((Object)"number");
            Map<String, Long> currencyIdMap = (Map<String, Long>)costAccountNum2CurrencyIdMap.get(costAccountNum);
            if (currencyIdMap == null && (costAccount = QueryServiceHelper.queryOne((String)"cal_bd_costaccount", (String)"calpolicy.currency", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)costAccountNum)})) != null) {
                Long currencyId = costAccount.getLong("calpolicy.currency");
                currencyIdMap = Collections.singletonMap("id", currencyId);
                costAccountNum2CurrencyIdMap.put(costAccountNum, currencyIdMap);
            }
            sourceData.put("currency", currencyIdMap);
        }
    }

    private void setCostAccountByCalOrg(Long calOrg) {
        DynamicObject costAccount = OrgHelper.getCostAccountByCalOrg((Long)calOrg);
        if (costAccount != null) {
            DynamicObjectCollection coll = QueryServiceHelper.query((String)"cal_bd_calpolicy", (String)"id,currency", (QFilter[])new QFilter("id", "=", (Object)costAccount.getLong("calpolicy")).toArray());
            this.getModel().setValue("costaccount", (Object)costAccount.getLong("id"));
            this.getModel().setValue("currency", ((DynamicObject)coll.get(0)).get("currency"));
        } else {
            this.getModel().setValue("costaccount", null);
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        int rowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
        DynamicObject storageOrg = (DynamicObject)this.getModel().getValue("storageorgunit", rowIndex);
        for (RowDataEntity obj : e.getRowDataEntities()) {
            int currentRowIndex = obj.getRowIndex();
            this.getModel().setValue("owner", ((DynamicObject)this.getModel().getValue("calorg")).get("id"), currentRowIndex);
            if (storageOrg != null) {
                this.getModel().setValue("storageorgunit", storageOrg.getPkValue(), currentRowIndex);
            }
            boolean calByCostelement = this.getCalByCostElement();
            this.getView().setEnable(Boolean.valueOf(!calByCostelement), currentRowIndex, new String[]{"adjustamt"});
        }
    }

    public void afterBindData(EventObject e) {
        this.setRowEnable();
        boolean calByCostelement = this.getCalByCostElement();
        String diffType = (String)this.getModel().getValue("difftype");
        String billstatus = (String)this.getModel().getValue("billstatus");
        ((ComboEdit)this.getView().getControl("difftype")).setMustInput(true);
        String showSubElement = CalDbParamServiceHelper.getString((String)CalDbParamConstant.BILL_SHOW_SUBELEMENTENTRY, null);
        if ("0".equals(showSubElement)) {
            this.setSubEntryVisible(calByCostelement);
        }
        String billStatus = (String)this.getModel().getValue("billstatus");
        this.setRowAdjustAmtEnable(calByCostelement, billstatus);
        if (calByCostelement && "C".equals(billStatus) && "0".equals(showSubElement)) {
            DynamicObjectCollection coll = this.getModel().getEntryEntity("entryentity");
            for (DynamicObject entry : coll) {
                DynamicObjectCollection subColl = entry.getDynamicObjectCollection("subentryentity");
                Iterator it = subColl.iterator();
                while (it.hasNext()) {
                    DynamicObject subEntry = (DynamicObject)it.next();
                    BigDecimal sub_adjustamt = subEntry.getBigDecimal("sub_adjustamt");
                    if (sub_adjustamt.compareTo(BigDecimal.ZERO) != 0) continue;
                    it.remove();
                }
            }
        }
        this.getView().updateView("subentryentity");
        this.setDiffTypeEnable(diffType, billstatus);
        this.lockBill4EntryStatus(diffType, billStatus);
        this.getModel().setDataChanged(false);
    }

    private void lockBill4EntryStatus(String diffType, String billStatus) {
        boolean lockBill = false;
        if (this.isActDiffType(diffType) && "A".equals(billStatus)) {
            DynamicObjectCollection coll = this.getModel().getEntryEntity("entryentity");
            for (DynamicObject entry : coll) {
                String entryStatus = entry.getString("entrystatus");
                if (!"D".equals(entryStatus) && !"E".equals(entryStatus)) continue;
                lockBill = true;
                break;
            }
        }
        if (lockBill) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"contentpanel"});
        }
    }

    private void setDiffTypeEnable(String diffType, String billstatus) {
        boolean actDiffType = this.isActDiffType(diffType);
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"createtype"});
        String createType = (String)this.getModel().getValue("createtype");
        String biztype = (String)this.getModel().getValue("biztype");
        if ("A".equals(billstatus) && "A".equals(biztype) && CostAdjustBilCreateTypeEnum.STAND_CHANGE.getValue().equals(createType) && CostAdjustBillDiffTypeEnum.STAND_CHANGE_DIFF.getValue().equals(diffType)) {
            this.createStandChangeBill();
        } else if (!actDiffType && "A".equals(billstatus)) {
            this.getView().setEnable(Boolean.TRUE, new String[]{"difftype"});
            ArrayList<ComboItem> items = new ArrayList<ComboItem>(16);
            ComboEdit diffTypeComboEdit = (ComboEdit)this.getView().getControl("difftype");
            List diffTypes = ((ComboProp)diffTypeComboEdit.getProperty()).getComboItems();
            for (ValueMapItem diffItem : diffTypes) {
                if (this.isActDiffType(diffItem.getValue())) continue;
                items.add(new ComboItem(diffItem.getName(), diffItem.getValue()));
            }
            diffTypeComboEdit.setComboItems(items);
            this.getView().updateView("difftype");
        } else {
            this.getView().setEnable(Boolean.FALSE, new String[]{"difftype"});
            this.getView().updateView("difftype");
        }
    }

    private void setRowAdjustAmtEnable(boolean calByCostelement, String billstatus) {
        if (!"A".equals(billstatus)) {
            return;
        }
        DynamicObjectCollection coll = this.getModel().getEntryEntity("entryentity");
        for (int i = 0; i < coll.size(); ++i) {
            this.getView().setEnable(Boolean.valueOf(!calByCostelement), i, new String[]{"adjustamt"});
            this.getView().updateView("adjustamt", i);
        }
    }

    private boolean getCalByCostElement() {
        boolean calByCostelement = false;
        DynamicObject costAccount = (DynamicObject)this.getModel().getValue("costaccount");
        if (costAccount != null) {
            DynamicObject costAccountDy = QueryServiceHelper.queryOne((String)"cal_bd_costaccount", (String)"calpolicy.calbycostelement", (QFilter[])new QFilter("id", "=", costAccount.getPkValue()).toArray());
            calByCostelement = costAccountDy.getBoolean("calpolicy.calbycostelement");
        }
        return calByCostelement;
    }

    private boolean judgeHandAddCostDiffBill() {
        String invBillnoRow0;
        DynamicObjectCollection entry;
        boolean handAddCostDiffBill = false;
        String difftype = (String)this.getModel().getValue("difftype");
        if (!this.isActDiffType(difftype) && (entry = this.getModel().getEntryEntity("entryentity")) != null && entry.size() > 0 && StringUtils.isEmpty((String)(invBillnoRow0 = ((DynamicObject)entry.get(0)).getString("invbillnum")))) {
            handAddCostDiffBill = true;
        }
        return handAddCostDiffBill;
    }

    /*
     * WARNING - void declaration
     */
    private void setRowEnable() {
        void var11_18;
        Serializable materialId;
        DynamicObject costAdjustBill = this.getModel().getDataEntity();
        DynamicObjectCollection entryColl = costAdjustBill.getDynamicObjectCollection(this.ENTRY);
        HashMap<Long, HashSet<Long>> storMaterialsMap = new HashMap<Long, HashSet<Long>>(16);
        HashSet<Long> warehouseIdSet = new HashSet<Long>(16);
        for (DynamicObject dynamicObject : entryColl) {
            Long storageOrgId = dynamicObject.getLong("storageorgunit.id");
            materialId = Long.valueOf(dynamicObject.getLong("material.id"));
            Long warehouseId = dynamicObject.getLong("warehouse.id");
            HashSet<Long> materialIds = (HashSet<Long>)storMaterialsMap.get(storageOrgId);
            if (materialIds == null) {
                materialIds = new HashSet<Long>(16);
                storMaterialsMap.put(storageOrgId, materialIds);
            }
            materialIds.add((Long)materialId);
            warehouseIdSet.add(warehouseId);
        }
        QFilter warehouseFilter = new QFilter("id", "in", warehouseIdSet);
        warehouseFilter.and("enable", "=", (Object)"1");
        warehouseFilter.and("status", "=", (Object)"C");
        HashMap<Long, Boolean> warehouseEnableLocationMap = new HashMap<Long, Boolean>(16);
        DataSet warehouseDataSet = QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass().getName() + "-warehous"), (String)"bd_warehouse", (String)"id,isopenlocation", (QFilter[])warehouseFilter.toArray(), null);
        materialId = null;
        try {
            for (Object row : warehouseDataSet) {
                Long l = row.getLong("id");
                Boolean isopenlocation = row.getBoolean("isopenlocation");
                warehouseEnableLocationMap.put(l, isopenlocation);
            }
        }
        catch (Throwable warehouseId) {
            materialId = warehouseId;
            throw warehouseId;
        }
        finally {
            if (warehouseDataSet != null) {
                if (materialId != null) {
                    try {
                        warehouseDataSet.close();
                    }
                    catch (Throwable warehouseId) {
                        ((Throwable)materialId).addSuppressed(warehouseId);
                    }
                } else {
                    warehouseDataSet.close();
                }
            }
        }
        HashMap<String, Boolean> privateEnableLotMap = new HashMap<String, Boolean>(16);
        HashMap<String, Boolean> publiceEnableLotMap = new HashMap<String, Boolean>(16);
        HashMap<Long, Boolean> enableAssistMap = new HashMap<Long, Boolean>(16);
        for (Map.Entry entry : storMaterialsMap.entrySet()) {
            Long stoId = (Long)entry.getKey();
            Set matIds = (Set)entry.getValue();
            QFilter qFilter = new QFilter("masterid", "in", (Object)matIds);
            DynamicObjectCollection stockMaterialInfos = BaseDataServiceHelper.queryBaseData((String)"bd_materialinventoryinfo", (Long)stoId, (QFilter)qFilter, (String)"id,masterid,createorg,enablelot,masterid.isuseauxpty");
            for (DynamicObject dynamicObject : stockMaterialInfos) {
                Object material = dynamicObject.get("masterid");
                if (material instanceof DynamicObject) {
                    material = ((DynamicObject)material).get("id");
                }
                boolean enableAssist = dynamicObject.getBoolean("masterid.isuseauxpty");
                Object createOrg = dynamicObject.get("createorg");
                if (createOrg instanceof DynamicObject) {
                    createOrg = ((DynamicObject)createOrg).get("id");
                }
                String key = stoId + "_" + material;
                boolean enableLot = dynamicObject.getBoolean("enablelot");
                if (stoId.equals(createOrg)) {
                    privateEnableLotMap.put(key, enableLot);
                } else {
                    publiceEnableLotMap.put(key, enableLot);
                }
                enableAssistMap.put((Long)material, enableAssist);
            }
        }
        int size = entryColl.size();
        boolean bl = false;
        while (var11_18 < size) {
            Boolean isopenlocation;
            DynamicObject entryRow = (DynamicObject)entryColl.get((int)var11_18);
            Long storageOrgId = entryRow.getLong("storageorgunit.id");
            Long materialId2 = entryRow.getLong("material.id");
            Long warehouseId = entryRow.getLong("warehouse.id");
            if (storageOrgId != null && materialId2 != null) {
                String key = storageOrgId + "_" + materialId2;
                Boolean enablelot = (Boolean)privateEnableLotMap.get(key);
                if (enablelot == null) {
                    enablelot = (Boolean)publiceEnableLotMap.get(key);
                }
                Boolean isuseauxpty = (Boolean)enableAssistMap.get(materialId2);
                if (enablelot != null) {
                    this.getView().setEnable(enablelot, (int)var11_18, new String[]{this.LOT});
                }
                if (isuseauxpty != null) {
                    this.getView().setEnable(isuseauxpty, (int)var11_18, new String[]{"assist"});
                }
            }
            if ((isopenlocation = (Boolean)warehouseEnableLocationMap.get(warehouseId)) != null) {
                this.getView().setEnable(isopenlocation, (int)var11_18, new String[]{this.LOCATION});
            }
            ++var11_18;
        }
    }

    private void setBillType(boolean isChange) {
        Object biztype = this.getModel().getValue(this.BIZTYPE);
        this.getModel().beginInit();
        if ("A".equals(biztype)) {
            this.getModel().setValue(this.BILLTYPE, (Object)"366348248593474560");
            if (isChange) {
                this.getModel().setValue("custsupplier", null);
            }
            this.getModel().setValue("cstype", (Object)"bd_supplier");
        } else {
            this.getModel().setValue(this.BILLTYPE, (Object)"452682831861140480");
            this.getModel().setValue("cstype", (Object)"bd_customer");
        }
        this.getModel().endInit();
        this.getView().updateView(this.BILLTYPE);
        this.getView().updateView("cstype");
        this.getView().updateView("custsupplier");
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String key = e.getOperateKey();
        if (("unaudit".equals(key) || "unsubmit".equals(key)) && e.getOperationResult().isSuccess()) {
            boolean calByCostelement = this.getCalByCostElement();
            String billStatus = (String)this.getModel().getValue("billstatus");
            String diffType = (String)this.getModel().getValue("difftype");
            this.setDiffTypeEnable(diffType, billStatus);
            this.setRowEnable();
            this.setRowAdjustAmtEnable(calByCostelement, billStatus);
        }
        if (e.getOperationResult() != null && e.getOperationResult().isSuccess() && ("unaudit".equals(key) || "unsubmit".equals(key) || "audit".equals(key) || "submit".equals(key))) {
            this.getView().invokeOperation("refresh");
        }
    }

    public void registerListener(EventObject e) {
        BasedataEdit costaccount = (BasedataEdit)this.getControl(this.COSTACCOUNT);
        costaccount.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit billtype = (BasedataEdit)this.getControl(this.BILLTYPE);
        billtype.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit material = (BasedataEdit)this.getControl(this.MATERIAL);
        material.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit warehouseEdit = (BasedataEdit)this.getControl(this.WAREHOUSE);
        warehouseEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit locationEdit = (BasedataEdit)this.getControl(this.LOCATION);
        locationEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit storageorgUnit = (BasedataEdit)this.getControl(this.STORAGEORGUNIT);
        storageorgUnit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit invType = (BasedataEdit)this.getControl("invtype");
        invType.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit ownerEdit = (BasedataEdit)this.getControl("owner");
        ownerEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit mversionEdit = (BasedataEdit)this.getControl("mversion");
        mversionEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit configuredCodeEdit = (BasedataEdit)this.getControl("configuredcode");
        configuredCodeEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addItemClickListeners(new String[]{"tbmain"});
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void beforeF7Select(BeforeF7SelectEvent event) {
        String sourceID = event.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)event.getFormShowParameter();
        if (this.COSTACCOUNT.equals(sourceID)) {
            DynamicObject orgInfo = (DynamicObject)this.getModel().getValue("calorg");
            if (orgInfo == null) return;
            QFilter qFilter = new QFilter("calorg.id", "=", orgInfo.getPkValue());
            showParameter.getListFilterParameter().setFilter(qFilter);
            return;
        }
        if (this.BILLTYPE.equals(sourceID)) {
            Object biztype = this.getModel().getValue(this.BIZTYPE);
            DynamicObject dynamicObject = CommonSettingHelper.getSettingObj();
            HashSet<String> hashSet = new HashSet<String>();
            if ("A".equals(biztype)) {
                DynamicObjectCollection calInBillTypes = dynamicObject.getDynamicObjectCollection("calinbilltypes");
                if (calInBillTypes.size() < 1) throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u901a\u8fc7\u201c\u8d22\u52a1\u4e91>\u5b58\u8d27\u6838\u7b97>\u516c\u5171\u914d\u7f6e>\u6838\u7b97\u5355\u5355\u636e\u7c7b\u578b\u201d\u4e0b\u7ef4\u62a4\u5165\u5e93\u6838\u7b97\u5355\u636e\u3002", (String)"CostAdjustBillPlugin_1", (String)"fi-cal-formplugin", (Object[])new Object[0]));
                for (DynamicObject calInBillType : calInBillTypes) {
                    if (calInBillType.getDynamicObject("fbasedataid") == null) continue;
                    hashSet.add(calInBillType.getDynamicObject("fbasedataid").getString("number"));
                }
            } else {
                DynamicObjectCollection calOutBillTypes = dynamicObject.getDynamicObjectCollection("caloutbilltypes");
                if (calOutBillTypes.size() < 1) throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u901a\u8fc7\u201c\u8d22\u52a1\u4e91>\u5b58\u8d27\u6838\u7b97>\u516c\u5171\u914d\u7f6e>\u6838\u7b97\u5355\u5355\u636e\u7c7b\u578b\u201d\u4e0b\u7ef4\u62a4\u51fa\u5e93\u6838\u7b97\u5355\u636e\u3002", (String)"CostAdjustBillPlugin_2", (String)"fi-cal-formplugin", (Object[])new Object[0]));
                for (DynamicObject calOutBillType : calOutBillTypes) {
                    hashSet.add(calOutBillType.getDynamicObject("fbasedataid").getString("number"));
                }
            }
            QFilter qf = new QFilter("number", "in", hashSet);
            showParameter.getListFilterParameter().setFilter(qf);
            return;
        }
        if (this.WAREHOUSE.equals(sourceID)) {
            void var6_29;
            int rowIndex = event.getRow();
            DynamicObject dynamicObject = (DynamicObject)this.getModel().getValue("storageorgunit", rowIndex);
            if (dynamicObject == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u5e93\u5b58\u7ec4\u7ec7\u3002", (String)"CostAdjustBillPlugin_3", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            }
            Long[] longArray = new Long[]{688888L};
            if (dynamicObject != null) {
                Long[] longArray2 = SCMHelper.getAllWarehouseIDs((String)dynamicObject.getString("number"));
            }
            showParameter.getListFilterParameter().setFilter(new QFilter("id", "in", (Object)var6_29));
            return;
        } else if (this.LOCATION.equals(sourceID)) {
            void var6_32;
            int rowIndex = event.getRow();
            DynamicObject dynamicObject = (DynamicObject)this.getModel().getValue(this.WAREHOUSE, rowIndex);
            ArrayList<Long> arrayList = new ArrayList<Long>();
            arrayList.add(688888L);
            if (dynamicObject != null) {
                DynamicObjectCollection locationCol = dynamicObject.getDynamicObjectCollection(this.ENTRY);
                List<Long> list = this.getLoactionIds(locationCol);
            }
            QFilter qFilter1 = new QFilter("id", "in", (Object)var6_32);
            showParameter.getListFilterParameter().setFilter(qFilter1);
            return;
        } else if (this.STORAGEORGUNIT.equals(sourceID)) {
            void var5_21;
            DynamicObject orgInfo = (DynamicObject)this.getModel().getValue("calorg");
            ArrayList arrayList = new ArrayList();
            if (orgInfo != null) {
                List list = OrgHelper.getStorageOrgUnitByCalOrg((Long)orgInfo.getLong("id"));
            }
            QFilter qFilter = new QFilter("id", "in", (Object)var5_21);
            showParameter.getListFilterParameter().setFilter(qFilter);
            return;
        } else if (this.MATERIAL.equals(sourceID)) {
            DynamicObject storageorgunit = (DynamicObject)this.getModel().getValue(this.STORAGEORGUNIT);
            if (storageorgunit == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u5e93\u5b58\u7ec4\u7ec7\u3002", (String)"CostAdjustBillPlugin_3", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            }
            this.createProductionLine();
            return;
        } else if ("owner".equals(sourceID)) {
            DynamicObject costAccount = (DynamicObject)this.getModel().getValue("costaccount");
            if (costAccount == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u6210\u672c\u8d26\u7c3f\u3002", (String)"CostAdjustBillPlugin_4", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            }
            Long l = costAccount.getLong("id");
            Long[] longArray = AccountingSysHelper.getOwners((Long)l);
            QFilter qf = new QFilter("id", "in", (Object)longArray);
            showParameter.getListFilterParameter().setFilter(qf);
            return;
        } else if ("invtype".equals(sourceID)) {
            QFilter qFilter = new QFilter("isforwardamount", "=", (Object)true);
            qFilter.and("enable", "=", (Object)"1");
            showParameter.getListFilterParameter().setFilter(qFilter);
            return;
        } else if ("mversion".equals(sourceID)) {
            int rowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
            DynamicObject dynamicObject = (DynamicObject)this.getModel().getValue("material", rowIndex);
            if (dynamicObject == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u7269\u6599\u3002", (String)"CostAdjustBillPlugin_5", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            }
            Long l = dynamicObject.getLong("id");
            QFilter mversionFilter = new QFilter("material", "=", (Object)l);
            mversionFilter.and("enable", "=", (Object)"1");
            showParameter.getListFilterParameter().setFilter(mversionFilter);
            return;
        } else if ("configuredcode".equals(sourceID)) {
            DynamicObject material = (DynamicObject)this.getModel().getValue("material", event.getRow());
            if (material == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u7269\u6599\u3002", (String)"CostAdjustBillPlugin_5", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            }
            Long l = material.getLong("id");
            QFilter qFilter = new QFilter("material", "=", (Object)l);
            showParameter.getListFilterParameter().setFilter(qFilter);
            return;
        } else {
            if (!"productline".equals(sourceID)) return;
            HashSet<Long> materialIds = new HashSet<Long>();
            int n = event.getRow();
            DynamicObject dynamicObject = (DynamicObject)this.getModel().getValue(this.MATERIAL, n);
            long materialId = dynamicObject == null ? 0L : dynamicObject.getLong("id");
            materialIds.add(materialId);
            HashMap<Integer, Long> indexAndMaterialId = new HashMap<Integer, Long>();
            indexAndMaterialId.put(n, materialId);
            this.getProductionLineByMaterial(indexAndMaterialId, materialIds);
        }
    }

    private void createProductionLine() {
        DynamicObjectCollection entrys = this.getModel().getEntryEntity("entryentity");
        HashSet<Long> materialIds = new HashSet<Long>();
        for (DynamicObject entry : entrys) {
            DynamicObject material = entry.getDynamicObject("material");
            DynamicObject productline = entry.getDynamicObject("productline");
            if (productline != null || material == null) continue;
            materialIds.add(material.getLong("id"));
        }
        HashSet<Integer> emptyMaterialRow = new HashSet<Integer>();
        HashMap<Integer, Long> indexAndMaterialId = new HashMap<Integer, Long>();
        for (int i = 0; i < entrys.size(); ++i) {
            DynamicObject entry = (DynamicObject)entrys.get(i);
            DynamicObject material = entry.getDynamicObject("material");
            DynamicObject productline = entry.getDynamicObject("productline");
            if (material == null) {
                emptyMaterialRow.add(i);
            }
            if (productline != null || material == null) continue;
            indexAndMaterialId.put(i, material.getLong("id"));
        }
        if (!emptyMaterialRow.isEmpty()) {
            for (Integer index : emptyMaterialRow) {
                this.getModel().setValue("productline", null, index.intValue());
            }
        }
        if (materialIds.isEmpty()) {
            return;
        }
        this.getProductionLineByMaterial(indexAndMaterialId, materialIds);
    }

    private void getProductionLineByMaterial(Map<Integer, Long> indexAndMaterialId, Set<Long> materialIds) {
        DynamicObjectCollection materials = QueryServiceHelper.query((String)"bd_material", (String)"id,productline", (QFilter[])new QFilter[]{new QFilter("id", "in", materialIds)}, null);
        HashMap<Long, Long> materialIdAndProductionLine = new HashMap<Long, Long>();
        if (materials != null && materials.size() != 0) {
            for (DynamicObject dynamicObject : materials) {
                long productionLine;
                long l = productionLine = dynamicObject == null ? 0L : dynamicObject.getLong("productline");
                if (dynamicObject == null) continue;
                materialIdAndProductionLine.put(dynamicObject.getLong("id"), productionLine);
            }
        }
        for (Map.Entry entry : indexAndMaterialId.entrySet()) {
            Integer rowIndex = (Integer)entry.getKey();
            long materialId = (Long)entry.getValue();
            this.getModel().setValue("productline", materialIdAndProductionLine.get(materialId), rowIndex.intValue());
        }
    }

    private List<Long> getLoactionIds(DynamicObjectCollection locationCol) {
        ArrayList<Long> ids = new ArrayList<Long>();
        if (locationCol == null || locationCol.size() == 0) {
            return ids;
        }
        for (DynamicObject locDym : locationCol) {
            ids.add(locDym.getLong("location.id"));
        }
        return ids;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        IDataEntityProperty property = e.getProperty();
        String propertyName = property.getName();
        if (this.COSTACCOUNT.equals(propertyName)) {
            DynamicObject costaccount = (DynamicObject)this.getModel().getValue(this.COSTACCOUNT);
            Object currecy = null;
            boolean calByCostelement = false;
            if (costaccount != null) {
                Object accountID = costaccount.getPkValue();
                DynamicObject rs = QueryServiceHelper.queryOne((String)"cal_bd_costaccount", (String)"calorg,calpolicy.currency.id,calpolicy.calbycostelement,costtype", (QFilter[])new QFilter[]{new QFilter("id", "=", accountID)});
                currecy = rs.get("calpolicy.currency.id");
                calByCostelement = rs.getBoolean("calpolicy.calbycostelement");
                this.disableSubElement = CostElementHelper.getDisableSubElement();
                IDataModel model = this.getModel();
                DynamicObjectCollection entry = this.getModel().getEntryEntity(this.ENTRY);
                for (int i = 0; i < entry.size(); ++i) {
                    if (calByCostelement) {
                        this.getView().setEnable(Boolean.valueOf(false), i, new String[]{"adjustamt"});
                    } else {
                        this.getView().setEnable(Boolean.valueOf(true), i, new String[]{"adjustamt"});
                    }
                    DynamicObject material = (DynamicObject)model.getValue("material", i);
                    if (material == null) continue;
                    this.reSetCostelement(calByCostelement, i, material.getLong("id"));
                }
                this.getView().updateView("entryentity");
                this.getView().updateView("subentryentity");
            }
            this.getModel().setValue("currency", currecy);
            this.setSubEntryVisible(calByCostelement);
        } else if (this.BIZTYPE.equals(propertyName)) {
            this.setBillType(true);
        } else if (this.MATERIAL.equals(propertyName)) {
            this.setAssAndLotEnable4MaterialChanged(e);
            this.buildSubEntry4MaterialChanged(e);
            this.createProductionLine();
        } else if (this.WAREHOUSE.equals(propertyName)) {
            int rowIndex = e.getChangeSet()[0].getRowIndex();
            DynamicObject warehouseInfo = (DynamicObject)this.getModel().getValue(this.WAREHOUSE, rowIndex);
            if (warehouseInfo == null) {
                this.getModel().setValue(this.LOCATION, null, rowIndex);
                this.getView().updateView(this.LOCATION, rowIndex);
                return;
            }
            this.getModel().setValue(this.LOCATION, null, rowIndex);
            boolean isopenlocation = warehouseInfo.getBoolean("isopenlocation");
            this.getView().setEnable(Boolean.valueOf(isopenlocation), rowIndex, new String[]{this.LOCATION});
            this.getView().updateView(this.LOCATION, rowIndex);
        } else if ("sub_adjustamt".equals(propertyName)) {
            this.sumSubEntryAdjustAmt();
        } else if ("adjustamt".equals(propertyName)) {
            this.writeSubEntryAdjustAmt(e);
        } else if ("bookdate".equals(propertyName)) {
            this.getModel().setValue("period", null);
            this.getModel().setValue("bizdate", this.getModel().getValue("bookdate"));
        } else if (!"productline".equals(propertyName) && this.STORAGEORGUNIT.equals(propertyName)) {
            int rowIndex = e.getChangeSet()[0].getRowIndex();
            this.getModel().setValue(this.MATERIAL, null, rowIndex);
            this.getModel().setValue(this.WAREHOUSE, null, rowIndex);
            this.getModel().setValue(this.LOCATION, null, rowIndex);
            this.getView().updateView(this.MATERIAL, rowIndex);
            this.getView().updateView(this.WAREHOUSE, rowIndex);
            this.getView().updateView(this.LOCATION, rowIndex);
        }
    }

    private void writeSubEntryAdjustAmt(PropertyChangedArgs e) {
        Object accountID;
        DynamicObject rs;
        boolean calByCostelement;
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        BigDecimal adjustAmt = (BigDecimal)this.getModel().getValue("adjustamt", rowIndex);
        DynamicObject costaccount = (DynamicObject)this.getModel().getValue(this.COSTACCOUNT);
        if (costaccount != null && this.getModel().getValue("material", rowIndex) != null && !(calByCostelement = (rs = QueryServiceHelper.queryOne((String)"cal_bd_costaccount", (String)"calpolicy.calbycostelement", (QFilter[])new QFilter[]{new QFilter("id", "=", accountID = costaccount.getPkValue())})).getBoolean("calpolicy.calbycostelement"))) {
            this.getModel().setEntryCurrentRowIndex("entryentity", rowIndex);
            DynamicObject entryRow = this.getModel().getEntryRowEntity("entryentity", rowIndex);
            DynamicObjectCollection subEntryColl = entryRow.getDynamicObjectCollection("subentryentity");
            if (subEntryColl != null && subEntryColl.size() >= 1) {
                this.getModel().setValue("sub_adjustamt", (Object)adjustAmt, 0);
            }
        }
    }

    private void sumSubEntryAdjustAmt() {
        int rowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
        DynamicObject entryRow = this.getModel().getEntryRowEntity("entryentity", rowIndex);
        DynamicObjectCollection subEntryColl = entryRow.getDynamicObjectCollection("subentryentity");
        BigDecimal adjustAmt = BigDecimal.ZERO;
        for (DynamicObject dynamicObject : subEntryColl) {
            BigDecimal sub_adjustamt = dynamicObject.getBigDecimal("sub_adjustamt");
            if (sub_adjustamt == null) continue;
            adjustAmt = adjustAmt.add(sub_adjustamt);
        }
        this.getModel().beginInit();
        this.getModel().setValue("adjustamt", (Object)adjustAmt, rowIndex);
        this.getModel().endInit();
        this.getView().updateView("adjustamt", rowIndex);
    }

    private void buildSubEntry4MaterialChanged(PropertyChangedArgs e) {
        IDataModel model = this.getModel();
        DynamicObject costaccount = (DynamicObject)model.getValue(this.COSTACCOUNT);
        boolean calByCostelement = false;
        if (costaccount != null) {
            Object accountID = costaccount.getPkValue();
            DynamicObject rs = QueryServiceHelper.queryOne((String)"cal_bd_costaccount", (String)"calorg,costtype,calpolicy.currency.id,calpolicy.calbycostelement", (QFilter[])new QFilter[]{new QFilter("id", "=", accountID)});
            calByCostelement = rs.getBoolean("calpolicy.calbycostelement");
        }
        this.disableSubElement = CostElementHelper.getDisableSubElement();
        ChangeData[] changeDataArr = e.getChangeSet();
        for (int i = 0; i < changeDataArr.length; ++i) {
            int rowIndex = changeDataArr[i].getRowIndex();
            DynamicObject material = (DynamicObject)model.getValue("material", rowIndex);
            DynamicObject entryRow = model.getEntryRowEntity("entryentity", rowIndex);
            DynamicObjectCollection subEntryColl = entryRow.getDynamicObjectCollection("subentryentity");
            subEntryColl.clear();
            if (calByCostelement) {
                this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"adjustamt"});
            } else {
                this.getView().setEnable(Boolean.valueOf(true), rowIndex, new String[]{"adjustamt"});
            }
            if (material == null) continue;
            Long materialId = material.getLong("id");
            this.reSetCostelement(calByCostelement, rowIndex, materialId);
            this.getView().updateView("adjustamt", rowIndex);
        }
        this.getView().updateView("subentryentity");
    }

    private void setAssAndLotEnable4MaterialChanged(PropertyChangedArgs e) {
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        this.getModel().setValue("stocktype", null, rowIndex);
        this.getModel().setValue("mversion", null, rowIndex);
        this.getModel().setValue("configuredcode", null, rowIndex);
        DynamicObject materialInfo = (DynamicObject)this.getModel().getValue(this.MATERIAL, rowIndex);
        if (materialInfo == null) {
            this.getModel().beginInit();
            this.getModel().setValue(this.BASEUNIT, null, rowIndex);
            this.getView().updateView(this.BASEUNIT, rowIndex);
            this.getModel().endInit();
            return;
        }
        DynamicObject storageorgunit = (DynamicObject)this.getModel().getValue("storageorgunit", rowIndex);
        if (storageorgunit == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u5e93\u5b58\u7ec4\u7ec7\u3002", (String)"CostAdjustBillPlugin_3", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        }
        QFilter qFilter = new QFilter("masterid", "=", materialInfo.getPkValue());
        DynamicObjectCollection stockMaterialInfos = BaseDataServiceHelper.queryBaseData((String)"bd_materialinventoryinfo", (Long)storageorgunit.getLong("id"), (QFilter)qFilter, (String)"id,enablelot");
        boolean isuseauxpty = materialInfo.getBoolean("isuseauxpty");
        boolean enablelot = false;
        if (stockMaterialInfos == null || stockMaterialInfos.size() <= 0) {
            this.getModel().setValue(this.MATERIAL, null, rowIndex);
            this.getView().updateView(this.MATERIAL, rowIndex);
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u7ef4\u62a4\u8be5\u7269\u6599\u5728\u76f8\u5e94\u5e93\u5b58\u7ec4\u7ec7\u4e0b\u7684\u7269\u6599\u5e93\u5b58\u4fe1\u606f\u3002", (String)"CostAdjustBillPlugin_6", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        }
        enablelot = ((DynamicObject)stockMaterialInfos.get(0)).getBoolean("enablelot");
        DynamicObject baseunit = materialInfo.getDynamicObject(this.BASEUNIT);
        this.getModel().beginInit();
        this.getModel().setValue(this.BASEUNIT, baseunit.get("id"), rowIndex);
        this.getView().setEnable(Boolean.valueOf(isuseauxpty), rowIndex, new String[]{"assist"});
        this.getView().setEnable(Boolean.valueOf(enablelot), rowIndex, new String[]{this.LOT});
        if (!isuseauxpty) {
            this.getModel().setValue("assist", null, rowIndex);
        }
        if (!enablelot) {
            this.getModel().setValue(this.LOT, null, rowIndex);
        }
        this.getView().updateView(this.LOT, rowIndex);
        this.getView().updateView("assist", rowIndex);
        this.getView().updateView(this.BASEUNIT, rowIndex);
        this.getModel().endInit();
    }

    public void afterCopyData(EventObject e) {
        this.getModel().setValue("checkstrikeaccount", (Object)Boolean.FALSE);
        this.getModel().setValue("createtype", (Object)CostAdjustBilCreateTypeEnum.HAND.getValue());
        this.getModel().setValue("difftype", (Object)CostAdjustBillDiffTypeEnum.ACT_COST.getValue());
        IDataModel model = this.getModel();
        DynamicObject costaccount = (DynamicObject)model.getValue(this.COSTACCOUNT);
        boolean calByCostelement = false;
        if (costaccount != null) {
            Object accountID = costaccount.getPkValue();
            DynamicObject rs = QueryServiceHelper.queryOne((String)"cal_bd_costaccount", (String)"calpolicy.calbycostelement", (QFilter[])new QFilter[]{new QFilter("id", "=", accountID)});
            calByCostelement = rs.getBoolean("calpolicy.calbycostelement");
            this.disableSubElement = CostElementHelper.getDisableSubElement();
            DynamicObjectCollection entry = this.getModel().getEntryEntity(this.ENTRY);
            for (int i = 0; i < entry.size(); ++i) {
                DynamicObject material = (DynamicObject)model.getValue("material", i);
                if (material == null) {
                    return;
                }
                this.reSetCostelement(calByCostelement, i, material.getLong("id"));
            }
        }
    }

    public void beforeItemClick(BeforeItemClickEvent e) {
        super.beforeItemClick(e);
        String key = e.getItemKey();
        Long id = (Long)this.getModel().getValue("id");
        String billstatus = (String)this.getModel().getValue("billstatus");
        if ("btntrackup".equals(key)) {
            if (id == null || id == 0L) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u627e\u5230\u76f8\u5e94\u6765\u6e90\u5355\u636e\u3002", (String)"CostUpdateApplyBillPlugin_3", (String)"fi-cal-formplugin", (Object[])new Object[0]));
                return;
            }
            this.queryPrevBill(id);
        } else {
            if ("btntrackdown".equals(key)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u627e\u5230\u76f8\u5e94\u4e0b\u6e38\u5355\u636e\u3002", (String)"CostAdjustListPlugin_3", (String)"fi-cal-formplugin", (Object[])new Object[0]));
                return;
            }
            if ("batchfill".equals(key)) {
                new BatchFillEntryHelper().batchFill(this.getView(), "entryentity");
            } else if ("view_feesharerecord".equals(key)) {
                this.showFeeShareRecord(id);
            } else if ("view_apverifyrecord".equals(key)) {
                this.showApVerifyRecord(id);
            } else if ("view_costestimaterecord".equals(key)) {
                this.showCostEstimateRecords();
            } else if ("createstandchange".equals(key) && "A".equals(billstatus)) {
                this.createStandChangeBill();
            } else if ("view_chargeoffbill".equals(key)) {
                this.showChargeoffBill(id, true);
            } else if ("view_chargeoffedbill".equals(key)) {
                this.showChargeoffBill(id, false);
            }
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        DynamicObject costaccount = (DynamicObject)this.getModel().getValue(this.COSTACCOUNT);
        boolean calByCostelement = false;
        if (costaccount != null) {
            Object accountID = costaccount.getPkValue();
            DynamicObject rs = QueryServiceHelper.queryOne((String)"cal_bd_costaccount", (String)"calpolicy.calbycostelement", (QFilter[])new QFilter[]{new QFilter("id", "=", accountID)});
            calByCostelement = rs.getBoolean("calpolicy.calbycostelement");
            if (!calByCostelement) {
                return;
            }
            DynamicObjectCollection subEntrys = this.getModel().getEntryEntity("subentryentity");
            if (subEntrys == null || subEntrys.size() < 1) {
                return;
            }
            this.disableSubElement = CostElementHelper.getDisableSubElement();
            this.getModel().beginInit();
            for (int i = 0; i < subEntrys.size(); ++i) {
                Long subElementId = ((DynamicObject)subEntrys.get(i)).getDynamicObject("costsubelement").getLong("id");
                if (this.disableSubElement.contains(subElementId)) {
                    this.getView().setEnable(Boolean.FALSE, i, new String[]{"sub_adjustamt"});
                    continue;
                }
                this.getView().setEnable(Boolean.TRUE, i, new String[]{"sub_adjustamt"});
            }
            this.getModel().endInit();
        }
    }

    private void showChargeoffBill(Long id, boolean isShowChargeOff) {
        if (id == null || id == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"CostAdjustListPlugin_0", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            return;
        }
        String chargeoffedField = "ischargeoffed";
        String chargeoffField = "ischargeoff";
        if (!isShowChargeOff) {
            chargeoffedField = "ischargeoff";
            chargeoffField = "ischargeoffed";
        }
        HashSet<Long> recordEntryIds = new HashSet<Long>(16);
        QFilter q = new QFilter("id", "=", (Object)id);
        q.and(chargeoffedField, "=", (Object)Boolean.TRUE);
        DynamicObjectCollection costAdjustColl = QueryServiceHelper.query((String)"cal_costadjustbill", (String)"entryentity.invbillentryid", (QFilter[])q.toArray());
        for (DynamicObject dynamic : costAdjustColl) {
            recordEntryIds.add(dynamic.getLong("entryentity.invbillentryid"));
        }
        if (recordEntryIds.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5bf9\u5e94\u7684\u8bb0\u5f55\u3002", (String)"CostRecordEditPlugin_1", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            return;
        }
        HashSet<Long> costAdjustIds = new HashSet<Long>();
        q = new QFilter("entryentity.invbillentryid", "in", recordEntryIds);
        q.and(chargeoffField, "=", (Object)Boolean.TRUE);
        DynamicObjectCollection chargeoffCostAdjustColl = QueryServiceHelper.query((String)"cal_costadjustbill", (String)"id", (QFilter[])q.toArray());
        for (DynamicObject dynamic : chargeoffCostAdjustColl) {
            costAdjustIds.add(dynamic.getLong("id"));
        }
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setBillFormId("cal_costadjust_subentity");
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(new QFilter("id", "in", costAdjustIds));
        showParameter.getListFilterParameter().setQFilters(qFilters);
        Iterator iterator = costAdjustIds.iterator();
        while (iterator.hasNext()) {
            long billId = (Long)iterator.next();
            showParameter.addLinkQueryPkId((Object)billId);
        }
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setShowFilter(false);
        showParameter.setShowQuickFilter(false);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void createStandChangeBill() {
        this.getModel().beginInit();
        this.getModel().setValue("biztype", (Object)"A");
        this.getModel().setValue("billtype", null);
        this.getModel().setValue("createtype", (Object)CostAdjustBilCreateTypeEnum.STAND_CHANGE.getValue());
        this.getModel().setValue("difftype", (Object)CostAdjustBillDiffTypeEnum.STAND_CHANGE_DIFF.getValue());
        this.getModel().endInit();
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"biztype", "billtype", "createtype", "difftype"});
        this.getView().updateView("biztype");
        this.getView().updateView("billtype");
        this.getView().updateView("createtype");
        this.getView().updateView("difftype");
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate op = (FormOperate)args.getSource();
        String key = op.getOperateKey();
        if ("new".equals(key)) {
            this.getView().getPageCache().put("difftype", (String)this.getModel().getValue("difftype"));
        }
        if ("unaudit".equals(key)) {
            op.getOption().setVariableValue("isdeletebill", "false");
        }
    }

    private void showCostEstimateRecords() {
        DynamicObjectCollection entry = this.getModel().getEntryEntity("entryentity");
        HashSet<Long> costEstimateBillEntryIds = new HashSet<Long>(16);
        for (DynamicObject dynamicObject : entry) {
            Long costEstimateBillEntryId = dynamicObject.getLong("srcbillentryid");
            String srcbizentityobject = dynamicObject.getString("srcbizentityobject");
            if (costEstimateBillEntryId == null || costEstimateBillEntryId == 0L || !"cal_costestimatebill".equals(srcbizentityobject)) continue;
            costEstimateBillEntryIds.add(costEstimateBillEntryId);
        }
        if (costEstimateBillEntryIds.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5bf9\u5e94\u7684\u8bb0\u5f55\u3002", (String)"CostRecordEditPlugin_1", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            return;
        }
        ListShowParameter param = new ListShowParameter();
        param.setFormId("bos_list");
        param.setBillFormId("cal_costestimaterecord");
        param.getListFilterParameter().setFilter(new QFilter("id", "in", costEstimateBillEntryIds));
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)param);
    }

    private void showFeeShareRecord(Long id) {
        if (id == null || id == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5bf9\u5e94\u7684\u8bb0\u5f55\u3002", (String)"CostRecordEditPlugin_1", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject[] costAdjustBills = BusinessDataServiceHelper.load((String)"cal_costadjustbill", (String)"feeshareflag", (QFilter[])new QFilter("id", "=", (Object)id).toArray());
        HashSet<Long> feeShareRecordIdSet = new HashSet<Long>(costAdjustBills.length);
        for (DynamicObject dynamic : costAdjustBills) {
            long feeshareflag = dynamic.getLong("feeshareflag");
            if (feeshareflag == 0L) continue;
            feeShareRecordIdSet.add(feeshareflag);
        }
        if (feeShareRecordIdSet == null || feeShareRecordIdSet.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5bf9\u5e94\u7684\u8bb0\u5f55\u3002", (String)"CostRecordEditPlugin_1", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            return;
        }
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setBillFormId("cal_feeshare_newrecord");
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(new QFilter("id", "in", feeShareRecordIdSet));
        showParameter.getListFilterParameter().setQFilters(qFilters);
        for (Long feeShareRecordId : feeShareRecordIdSet) {
            showParameter.addLinkQueryPkId((Object)feeShareRecordId);
        }
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setShowFilter(false);
        showParameter.setShowQuickFilter(false);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void showApVerifyRecord(Long id) {
        if (id == null || id == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5bf9\u5e94\u7684\u8bb0\u5f55\u3002", (String)"CostRecordEditPlugin_1", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            return;
        }
        HashSet<Long> invBillEntryIds = new HashSet<Long>();
        DynamicObjectCollection writeOffDynamics = QueryServiceHelper.query((String)"cal_costadjustbill", (String)"entryentity.invbillentryid", (QFilter[])new QFilter("id", "=", (Object)id).toArray());
        for (DynamicObject dynamic : writeOffDynamics) {
            invBillEntryIds.add(dynamic.getLong("entryentity.invbillentryid"));
        }
        DynamicObjectCollection costRecordDynamics = QueryServiceHelper.query((String)"cal_costrecord", (String)"entry.writeoffid", (QFilter[])new QFilter("entry.id", "in", invBillEntryIds).toArray());
        HashSet<Long> writeOffIds = new HashSet<Long>();
        for (DynamicObject dynamic : costRecordDynamics) {
            if (dynamic.getLong("entry.writeoffid") == 0L) continue;
            writeOffIds.add(dynamic.getLong("entry.writeoffid"));
        }
        if (writeOffIds.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5bf9\u5e94\u7684\u8bb0\u5f55\u3002", (String)"CostRecordEditPlugin_1", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            return;
        }
        String entityNum = "ap_verifyrecord";
        Long calorgId = ((DynamicObject)this.getModel().getValue("calorg")).getLong("id");
        entityNum = WriteOffServerHelper.getNewRecordEntityNum((Long)calorgId, (String)entityNum);
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setBillFormId(entityNum);
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(new QFilter("id", "in", writeOffIds));
        showParameter.getListFilterParameter().setQFilters(qFilters);
        Iterator iterator = writeOffIds.iterator();
        while (iterator.hasNext()) {
            long writeOffId = (Long)iterator.next();
            showParameter.addLinkQueryPkId((Object)writeOffId);
        }
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setShowFilter(false);
        showParameter.setShowQuickFilter(false);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void showBill4ApplyBill(String billentity, Object id) {
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setPkId(id);
        showParameter.setFormId(billentity);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void queryPrevBill(Object id) {
        DynamicObject costadjustbill = BusinessDataServiceHelper.loadSingle((Object)id, (String)"cal_costadjust_subentity", (String)"id,invbizentityobject,invbillid");
        if (costadjustbill != null) {
            DynamicObjectCollection entry = costadjustbill.getDynamicObjectCollection("entryentity");
            if (entry == null) {
                return;
            }
            DynamicObject entryRow = (DynamicObject)entry.get(0);
            String srcbillentity = entryRow.getString("invbizentityobject");
            Long srcbillid = entryRow.getLong("invbillid");
            if (StringUtils.isNotEmpty((String)srcbillentity) && "cal_costupdateapplybill".equals(srcbillentity) && srcbillid != null && srcbillid != 0L) {
                this.showBill4ApplyBill(srcbillentity, srcbillid);
                return;
            }
        }
        this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u627e\u5230\u76f8\u5e94\u6765\u6e90\u5355\u636e\u3002", (String)"CostUpdateApplyBillPlugin_3", (String)"fi-cal-formplugin", (Object[])new Object[0]));
    }

    private void setSubEntryVisible(boolean calByCostelement) {
        if (calByCostelement) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"subentryentity"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"subentryentity"});
        }
    }

    private boolean isActDiffType(String diffType) {
        return CostAdjustBillDiffTypeEnum.ACT_COST.getValue().equals(diffType);
    }

    private void reSetCostelement(boolean calByCostelement, int rowIndex, Long materialId) {
        IDataModel model = this.getModel();
        Long currencyId = (Long)this.getModel().getValue("currency_id");
        this.getModel().setEntryCurrentRowIndex("entryentity", rowIndex);
        this.getModel().getEntryEntity("subentryentity").clear();
        this.getModel().beginInit();
        if (calByCostelement) {
            this.getModel().setValue("adjustamt", null, this.getModel().getEntryCurrentRowIndex(this.ENTRY));
            List elements = CostElementHelper.getAllCostEle4InitBill();
            for (Long[] longs : elements) {
                int subRowIndex = model.createNewEntryRow("subentryentity");
                model.setValue("costelement", (Object)longs[1], subRowIndex);
                model.setValue("costsubelement", (Object)longs[0], subRowIndex);
                model.setValue("sub_material", (Object)materialId, subRowIndex);
                model.setValue("sub_currency", (Object)currencyId, subRowIndex);
                if (this.disableSubElement.contains(longs[0])) {
                    this.getView().setEnable(Boolean.FALSE, subRowIndex, new String[]{"sub_adjustamt"});
                    continue;
                }
                this.getView().setEnable(Boolean.TRUE, subRowIndex, new String[]{"sub_adjustamt"});
            }
        } else {
            Long[] element = CostElementHelper.getDefaultMaterialElements();
            int subRowIndex = model.createNewEntryRow("subentryentity");
            model.setValue("costelement", (Object)element[1], subRowIndex);
            model.setValue("costsubelement", (Object)element[0], subRowIndex);
            model.setValue("sub_material", (Object)materialId, subRowIndex);
            model.setValue("sub_currency", (Object)currencyId, subRowIndex);
            this.getModel().setValue("sub_adjustamt", this.getModel().getValue("adjustamt", rowIndex), 0);
        }
        this.getModel().endInit();
        this.getView().updateView("subentryentity");
    }
}

