/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.formplugin.home;

import java.lang.constant.Constable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.AxisType;
import kd.bos.form.chart.LineSeries;
import kd.bos.form.chart.PointLineChart;
import kd.bos.form.chart.Position;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cal.common.constant.CalDbParamConstant;
import kd.fi.cal.common.helper.CalDbParamServiceHelper;
import kd.fi.cal.common.helper.PeriodHelper;
import kd.fi.cal.common.model.CalTurnOver;
import kd.fi.cal.formplugin.home.CardHomePlugin;

public class CalTurnOverPlugin
extends CardHomePlugin {
    private static final String materiel = "turnovermateriel";

    public void afterCreateNewData(EventObject e) {
        this.drawChart();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if (materiel.equals(key)) {
            this.drawChart();
        }
    }

    private void drawChart() {
        if (!CalDbParamServiceHelper.getBoolean((String)CalDbParamConstant.ENABLE_HOME_PAGE).booleanValue()) {
            return;
        }
        PointLineChart customchart = this.getMainChart();
        customchart.clearData();
        List<Object> turnOverList = new ArrayList();
        if (this.judgeDrawChart()) {
            turnOverList = this.getData();
        }
        ArrayList<String> demensions = new ArrayList<String>(turnOverList.size());
        ArrayList<Number> countList = new ArrayList<Number>(turnOverList.size());
        for (CalTurnOver calTurnOver : turnOverList) {
            demensions.add(calTurnOver.getName());
            countList.add(calTurnOver.getTurnOver());
        }
        Axis categoryAxis = this.createCategoryXaxis();
        categoryAxis.setCategorys(demensions);
        this.createValueYaxis();
        this.createLineSeries(countList, "#CC00CC");
        customchart.setMargin(Position.right, "40px");
        customchart.setMargin(Position.top, "30px");
        customchart.refresh();
    }

    private boolean judgeDrawChart() {
        long calOrg = this.getCalorg();
        DynamicObject costAccount = this.getCostAccount();
        if (calOrg == 0L || costAccount == null) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private List<CalTurnOver> getData() {
        DynamicObject cuccency = this.getCuccencyBycostAccount();
        int amtprecision = cuccency.getInt("amtprecision");
        List<DynamicObject> multiPeriod = this.getAllPeriod();
        Map<Long, BigDecimal> salBillAmtMap = this.getSalBillAmt(multiPeriod);
        Map<Long, BigDecimal> periodBalanceMap = this.getPeriodAmt(multiPeriod, amtprecision);
        long key = 0L;
        BigDecimal periodBalanceAmt = BigDecimal.ZERO;
        BigDecimal value = BigDecimal.ZERO;
        BigDecimal rate = new BigDecimal(100);
        CalTurnOver calTurnOver = null;
        ArrayList<CalTurnOver> turnOverList = new ArrayList<CalTurnOver>(salBillAmtMap.size());
        for (Map.Entry<Long, BigDecimal> entry : salBillAmtMap.entrySet()) {
            key = entry.getKey();
            periodBalanceAmt = periodBalanceMap.get(key);
            if (periodBalanceAmt == null || periodBalanceAmt.compareTo(BigDecimal.ZERO) == 0) continue;
            value = entry.getValue();
            calTurnOver = new CalTurnOver(Long.valueOf(key), value.divide(periodBalanceAmt, amtprecision, 4).multiply(rate), multiPeriod);
            turnOverList.add(calTurnOver);
        }
        this.getAscData(turnOverList);
        return turnOverList;
    }

    private List<DynamicObject> getAllPeriod() {
        DynamicObject costAccount = this.getCostAccount();
        DynamicObject currentPeriod = PeriodHelper.getCurrentPeriod((Long)costAccount.getLong("id"));
        if (currentPeriod == null) {
            return new ArrayList<DynamicObject>();
        }
        int top = 5;
        DynamicObject[] multiPeriod = PeriodHelper.getMultiPreviousPeriod((Object)currentPeriod.getPkValue(), (int)top);
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(multiPeriod.length);
        Collections.addAll(list, multiPeriod);
        list.add(currentPeriod);
        return list;
    }

    public DynamicObject getMateriel() {
        return (DynamicObject)this.getModel().getValue(materiel);
    }

    private void getAscData(List<CalTurnOver> turnOverList) {
        if (turnOverList.size() != 0) {
            Collections.sort(turnOverList, new Comparator<CalTurnOver>(){

                @Override
                public int compare(CalTurnOver o1, CalTurnOver o2) {
                    return o1.getAsc() - o2.getAsc();
                }
            });
        }
    }

    private Map<Long, BigDecimal> getPeriodAmt(List<DynamicObject> multiPeriod, Integer amtprecision) {
        long calOrgId = this.getCalorg();
        DynamicObject costAccount = this.getCostAccount();
        HashMap<Long, BigDecimal> periodBalanceMap = new HashMap<Long, BigDecimal>(multiPeriod.size());
        HashMap<Long, Integer> periodNumberMap = new HashMap<Long, Integer>(multiPeriod.size());
        for (DynamicObject entity : multiPeriod) {
            periodNumberMap.put(entity.getLong("id"), entity.getInt("periodyear") * 100 + entity.getInt("periodnumber"));
            periodBalanceMap.put(entity.getLong("id"), BigDecimal.ZERO);
        }
        BigDecimal amt = BigDecimal.ZERO;
        BigDecimal two = new BigDecimal(2);
        for (Map.Entry entry : periodNumberMap.entrySet()) {
            Integer periodNumber = (Integer)entry.getValue();
            QFilter periodStartQf = new QFilter("calorg", "=", (Object)calOrgId).and("costaccount", "=", costAccount.getPkValue()).and("period", "<", (Object)periodNumber).and("endperiod", ">=", (Object)periodNumber);
            DynamicObject material = this.getMateriel();
            if (material != null) {
                periodStartQf.and("material", "=", material.getPkValue());
            }
            DataSet periodSartDs = QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass() + "getPeriodAmt"), (String)"cal_balance", (String)"calorg,periodendactualcost as amt,1 as year ", (QFilter[])periodStartQf.toArray(), (String)"");
            QFilter periodEndQf = new QFilter("calorg", "=", (Object)calOrgId).and("costaccount", "=", costAccount.getPkValue()).and("period", "<=", (Object)periodNumber).and("endperiod", ">", (Object)periodNumber);
            if (material != null) {
                periodEndQf.and("material", "=", material.getPkValue());
            }
            DataSet periodEndDs = QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass() + "getPeriodAmt"), (String)"cal_balance", (String)"calorg,periodendactualcost as amt,2 as year", (QFilter[])periodEndQf.toArray(), (String)"");
            periodSartDs = periodSartDs.union(periodEndDs).groupBy(new String[]{"calorg"}).sum("amt").finish();
            for (Row row : periodSartDs) {
                amt = row.getBigDecimal("amt");
                periodBalanceMap.put((Long)entry.getKey(), amt.divide(two, (int)amtprecision, 4));
            }
        }
        return periodBalanceMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Long, BigDecimal> getSalBillAmt(List<DynamicObject> multiPeriod) {
        HashSet<Long> periodIdSet = new HashSet<Long>(multiPeriod.size());
        for (DynamicObject entity : multiPeriod) {
            periodIdSet.add(entity.getLong("id"));
        }
        Map<Long, BigDecimal> salBillAmtMap = this.getSalBillAmtMap(multiPeriod);
        long calOrgId = this.getCalorg();
        DynamicObject costAccount = this.getCostAccount();
        QFilter salCostRecordQf = new QFilter("calorg", "=", (Object)calOrgId);
        salCostRecordQf.and("costaccount", "=", costAccount.getPkValue()).and("period", "in", periodIdSet).and("bizentityobject", "=", (Object)"im_saloutbill").and("issplitcreate", "=", (Object)Boolean.FALSE).and("billstatus", "=", (Object)"C");
        DynamicObject material = this.getMateriel();
        if (material != null) {
            salCostRecordQf.and("entry.material", "=", material.getPkValue());
        }
        DataSet costRecordDataSet = null;
        DataSet adjustBillAmtDs = null;
        try {
            costRecordDataSet = QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass() + "getSalBillAmt\uff08\uff09"), (String)"cal_costrecord", (String)"1  as billno,period.id as periodid,period.number as periodnumber,entry.actualcost as actualcost", (QFilter[])salCostRecordQf.toArray(), (String)"");
            QFilter salAdjustQf = new QFilter("calorg", "=", (Object)calOrgId).and("costaccount", "=", costAccount.getPkValue()).and("billtype", "=", (Object)452682831861140480L).and("period", "in", periodIdSet).and("billstatus", "=", (Object)"C");
            if (material != null) {
                salAdjustQf.and("entryentity.material", "=", material.getPkValue());
            }
            adjustBillAmtDs = QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass() + "getSalBillAmt\uff08\uff09"), (String)"cal_costadjustbill", (String)"2 as billno,period.id as  periodid, period.number as periodnumber,entryentity.adjustamt as actualcost", (QFilter[])salAdjustQf.toArray(), (String)"");
            costRecordDataSet = costRecordDataSet.union(adjustBillAmtDs).groupBy(new String[]{"periodid"}).sum("actualcost").finish();
            long periodid = 0L;
            BigDecimal actualcost = BigDecimal.ZERO;
            for (Row row : costRecordDataSet) {
                periodid = row.getLong("periodid");
                actualcost = row.getBigDecimal("actualcost");
                salBillAmtMap.put(periodid, actualcost);
            }
        }
        finally {
            if (costRecordDataSet != null) {
                costRecordDataSet.close();
            }
            if (adjustBillAmtDs != null) {
                adjustBillAmtDs.close();
            }
        }
        return salBillAmtMap;
    }

    private Map<Long, BigDecimal> getSalBillAmtMap(List<DynamicObject> multiPeriod) {
        HashMap<Long, BigDecimal> salBillAmtMap = new HashMap<Long, BigDecimal>(multiPeriod.size());
        for (DynamicObject entry : multiPeriod) {
            salBillAmtMap.put(entry.getLong("id"), BigDecimal.ZERO);
        }
        return salBillAmtMap;
    }

    private Axis createCategoryXaxis() {
        Axis axis = null;
        axis = this.getMainChart().createXAxis(ResManager.loadKDString((String)"\u671f\u95f4", (String)"CalTurnOverPlugin_0", (String)"fi-cal-formplugin", (Object[])new Object[0]), AxisType.category);
        HashMap<String, Constable> axisTick = new HashMap<String, Constable>();
        axisTick.put("interval", Integer.valueOf(0));
        axisTick.put("show", Boolean.FALSE);
        axis.setPropValue("axisTick", axisTick);
        this.setLineColor(axis, "#999999");
        return axis;
    }

    private Axis createValueYaxis() {
        Axis axis = null;
        axis = this.getMainChart().createYAxis(ResManager.loadKDString((String)"%", (String)"CalTurnOverPlugin_1", (String)"fi-cal-formplugin", (Object[])new Object[0]), AxisType.value);
        HashMap<String, Boolean> axisTick = new HashMap<String, Boolean>();
        axisTick.put("show", Boolean.FALSE);
        axis.setPropValue("axisTick", axisTick);
        HashMap splitLine = new HashMap();
        HashMap<String, String> lineStyle = new HashMap<String, String>();
        lineStyle.put("type", "dotted");
        lineStyle.put("color", "#E2E2E2");
        splitLine.put("lineStyle", lineStyle);
        axis.setPropValue("splitLine", splitLine);
        this.setLineColor(axis, "#999999");
        this.getMainChart().setShowTooltip(Boolean.TRUE.booleanValue());
        return axis;
    }

    private LineSeries createLineSeries(List<Number> values, String color) {
        LineSeries expireSeries = this.getMainChart().createSeries(ResManager.loadKDString((String)"\u5b58\u8d27\u5468\u8f6c\u7387", (String)"CalTurnOverPlugin_2", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        expireSeries.setItemColor(color);
        expireSeries.setAnimationDuration(2000);
        expireSeries.setData(values.toArray(new Number[0]));
        return expireSeries;
    }

    private PointLineChart getMainChart() {
        return (PointLineChart)this.getControl("pointlinechartap");
    }

    private void setLineColor(Axis axix, String color) {
        HashMap axisLineMap = new HashMap();
        HashMap<String, String> lineStyleMap = new HashMap<String, String>();
        lineStyleMap.put("color", color);
        axisLineMap.put("lineStyle", lineStyleMap);
        axix.setPropValue("axisLine", axisLineMap);
    }
}

