/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.formplugin.home;

import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cal.common.constant.CalDbParamConstant;
import kd.fi.cal.common.helper.CalDbParamServiceHelper;
import kd.fi.cal.formplugin.home.CardHomePlugin;

public class HandleCertificatePlugin
extends CardHomePlugin {
    private String TOBEPROCESSEDSALECNT = "tobeprocessedsalecnt";
    private String TOBEPROCESSEDCOSTCNT = "tobeprocessedcostcnt";
    private String TOBEPROCESSEDOTHERSCNT = "tobeprocessedotherscnt";

    public void afterCreateNewData(EventObject e) {
        if (!CalDbParamServiceHelper.getBoolean((String)CalDbParamConstant.ENABLE_HOME_PAGE).booleanValue()) {
            return;
        }
        DynamicObject costAccount = this.getCostAccount();
        if (costAccount != null) {
            this.initValue(costAccount, this.TOBEPROCESSEDSALECNT, 0);
            this.initValue(costAccount, this.TOBEPROCESSEDCOSTCNT, 0);
            this.initValue(costAccount, this.TOBEPROCESSEDOTHERSCNT, 0);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{this.TOBEPROCESSEDSALECNT, this.TOBEPROCESSEDCOSTCNT, this.TOBEPROCESSEDOTHERSCNT});
    }

    private void initValue(DynamicObject costAccount, String anyCnt, int isfivoucher) {
        int count = 0;
        QFilter filters = new QFilter(this.COSTACCOUNT, "=", costAccount.getPkValue());
        filters.and(new QFilter(this.CALORG, "=", (Object)this.getCalorg()));
        if (this.TOBEPROCESSEDCOSTCNT.equals(anyCnt)) {
            filters.and(new QFilter("iscostcarryover", "=", (Object)isfivoucher));
        } else {
            filters.and(new QFilter("isfivoucher", "=", (Object)isfivoucher));
        }
        DynamicObjectCollection costRecords = QueryServiceHelper.query((String)"cal_costrecord_subentity", (String)"id", (QFilter[])filters.toArray());
        count = costRecords.size();
        Label label = (Label)this.getView().getControl(anyCnt);
        label.setText(String.valueOf(count));
    }

    public void click(EventObject evt) {
        super.click(evt);
        if (!CalDbParamServiceHelper.getBoolean((String)CalDbParamConstant.ENABLE_HOME_PAGE).booleanValue()) {
            return;
        }
        if (this.getCostAccount() == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u6210\u672c\u8d26\u7c3f\u3002", (String)"HandleCertificatePlugin_0", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            return;
        }
        Control ctl = (Control)evt.getSource();
        String key = ctl.getKey();
        if (this.TOBEPROCESSEDSALECNT.equals(key)) {
            this.showVoucherFormWithFilter(this.TOBEPROCESSEDSALECNT, 0);
        } else if (this.TOBEPROCESSEDCOSTCNT.equals(key)) {
            this.showVoucherFormWithFilter(this.TOBEPROCESSEDCOSTCNT, 0);
        } else if (this.TOBEPROCESSEDOTHERSCNT.equals(key)) {
            this.showVoucherFormWithFilter(this.TOBEPROCESSEDOTHERSCNT, 0);
        }
    }

    private void showVoucherFormWithFilter(String anyCnt, int isfivoucher) {
        DynamicObject costAccountObj = this.getCostAccount();
        ListShowParameter para = new ListShowParameter();
        para.setBillFormId("cal_costrecord_subentity");
        para.setFormId("bos_list");
        para.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        para.getOpenStyle().setTargetKey("_submaintab_");
        QFilter filters = new QFilter(this.COSTACCOUNT, "=", costAccountObj.getPkValue());
        filters.and(new QFilter(this.CALORG, "=", (Object)this.getCalorg()));
        if (this.TOBEPROCESSEDCOSTCNT.equals(anyCnt)) {
            filters.and(new QFilter("iscostcarryover", "=", (Object)isfivoucher));
            para.setCustomParam("iscostcarryover", (Object)isfivoucher);
        } else {
            filters.and(new QFilter("isfivoucher", "=", (Object)isfivoucher));
            para.setCustomParam("isfivoucher", (Object)isfivoucher);
        }
        para.setCustomParam("source", (Object)"CalHandleCertificatePlugin");
        para.setCustomParam("costaccount", costAccountObj.getPkValue());
        para.setCustomParam("calorg", (Object)this.getCalorg());
        para.setCustomParam("filter", (Object)filters.toSerializedString());
        this.getView().showForm((FormShowParameter)para);
    }
}

