/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.formplugin.home;

import java.math.BigDecimal;
import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Label;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cal.common.constant.CalDbParamConstant;
import kd.fi.cal.common.helper.CalDbParamServiceHelper;
import kd.fi.cal.common.helper.PeriodHelper;
import kd.fi.cal.formplugin.home.CardHomePlugin;

public class HandleExpCostPlugin
extends CardHomePlugin {
    private String TOBEPROCESSEDCNT = "tobeprocessedcnt";

    public void afterCreateNewData(EventObject e) {
        if (!CalDbParamServiceHelper.getBoolean((String)CalDbParamConstant.ENABLE_HOME_PAGE).booleanValue()) {
            return;
        }
        DynamicObject costAccount = this.getCostAccount();
        if (costAccount != null) {
            this.initValue(costAccount);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{this.TOBEPROCESSEDCNT});
    }

    private void initValue(DynamicObject costAccount) {
        int count = 0;
        QFilter filters = this.getFilter(costAccount);
        DynamicObjectCollection costAdjustBills = QueryServiceHelper.query((String)"cal_costrecord_subentity", (String)"id", (QFilter[])filters.toArray());
        count = costAdjustBills.size();
        Label label = (Label)this.getView().getControl(this.TOBEPROCESSEDCNT);
        label.setText(String.valueOf(count));
    }

    private QFilter getFilter(DynamicObject costAccount) {
        DynamicObject currPeriod = PeriodHelper.getCurrentPeriod((Long)costAccount.getLong("id"));
        QFilter q = new QFilter(this.COSTACCOUNT, "=", costAccount.getPkValue()).and(new QFilter(this.CALORG, "=", (Object)this.getCalorg())).and(new QFilter("calbilltype", "=", (Object)"IN")).and(new QFilter("entry.ispresent", "=", (Object)"0")).and(new QFilter("billtype", "in", (Object)new Long[]{366348248593474560L, 366342412236234752L, 697678838297318400L})).and(new QFilter("entry.unitactualcost", "<=", (Object)BigDecimal.ZERO)).and(new QFilter("issplitcreate", "=", (Object)"0"));
        if (currPeriod != null) {
            q.and(new QFilter("period", "=", currPeriod.getPkValue()));
            q.and(new QFilter("bookdate", "<=", (Object)currPeriod.getDate("enddate")));
            q.and(new QFilter("bookdate", ">=", (Object)currPeriod.getDate("begindate")));
        }
        return q;
    }

    public void click(EventObject evt) {
        super.click(evt);
        if (!CalDbParamServiceHelper.getBoolean((String)CalDbParamConstant.ENABLE_HOME_PAGE).booleanValue()) {
            return;
        }
        if (this.getCostAccount() == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6210\u672c\u8d26\u7c3f\u3002", (String)"HandleExpCostPlugin_0", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            return;
        }
        this.showVoucherFormWithFilter();
    }

    private void showVoucherFormWithFilter() {
        DynamicObject costAccountObj = this.getCostAccount();
        ListShowParameter para = new ListShowParameter();
        para.setBillFormId("cal_costrecord_subentity");
        para.setFormId("bos_list");
        para.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        para.getOpenStyle().setTargetKey("_submaintab_");
        QFilter filters = this.getFilter(costAccountObj);
        para.setCustomParam("source", (Object)"CalHandleExpCostPlugin");
        para.setCustomParam("costaccount", costAccountObj.getPkValue());
        para.setCustomParam("calorg", (Object)this.getCalorg());
        para.setCustomParam("filter", (Object)filters.toSerializedString());
        this.getView().showForm((FormShowParameter)para);
    }
}

